# ゴシック体

ゴシック体は日本語書体の分類のひとつで、明朝体にある「ウロコ」などの飾りが少なく、縦画と横画の太さが均一であることが特徴です。欧文書体ではサンセリフ体が相当します。

![ゴシック体](../images/gothic.png)

## 用法

サンセリフ体と同様に、公共のサインなどのほか、Webサイトでも多く採用されています。また、とくに書籍や雑誌において、本文が明朝体の場合に強調する語句をゴシック体にする例も見られます。

## 実践

Webでゴシック体を表示するには、CSSの`font-family`プロパティで具体的なファミリー名を指定するとともに、フォールバックとして`sans-serif`キーワードも指定するとよいでしょう。

```css
body {
  font-family: "Hiragino Kaku Gothic ProN", "Meiryo", sans-serif;
}
```

上記コード例では、第1候補のヒラギノ角ゴシックと第2候補のメイリオがともに利用できない場合、ブラウザーの設定に応じて利用可能なゴシック体が選ばれます。

## 関連項目

- [サンセリフ体](./sans-serif.md)
- [明朝体](./mincho.md)
