# ベースライン

ベースライン（baseline）はアルファベットが整列する垂直方向の基準線で、「H」や「x」などの文字の下端が接する仮想のラインをいいます。ベースラインに沿って文字を配置することを「ベースライン揃え」といいます。

本来日本語の文字にはベースラインは存在しませんが、欧文と組み合わせる必要から日本語にもベースラインの考え方が持ち込まれました。日本語の文字におけるベースラインをとくに「欧文ベースライン」ということがあります。

![ラテンアルファベットの構造](../images/baseline.png)

## 実践

CSSの`vertical-align`プロパティの初期値は`baseline`なので、デフォルトではすべての文字がベースライン揃えで配置されます。

## 関連項目

- [文字揃え](./vertical-alignment.md)
- [キャップハイト](./cap-height.md)
- [エックスハイト](./x-height.md)
- [アセンダー](./ascender.md)
- [ディセンダー](./descender.md)
- [カウンター](./counter.md)
