# Webタイポグラフィの基礎知識と実践

Webタイポグラフィに関するキーワードを解説、同分野における知見を蓄積・共有します。  

## 概要

近年、日本語のサイトでもWebフォントへの注目が集まるなど、Webタイポグラフィに対する関心が高まりつつあります。ただ英語を始めとする欧米圏と比較すると、そのノウハウはあまり蓄積されておらず議論も少ないのが現状です。

そんな状況を鑑み、本プロジェクトではWebの制作に関わる人がタイポグラフィに取り組む際に参照できるよう、「実践」の観点からキーワードを取り上げていきます。Webタイポグラフィの知見が、日本語で蓄積・共有できる場所になればと考えています。（記事内容やタイトル、目次などの内容は、随時更新される可能性があります）

## 目次

### 文字

#### 文字の概念

- [字体](./terms/jitai.md)
- [異体字](./terms/itaiji.md)
- [字形](./terms/jikei.md)

#### 書体とフォント

- [書体](./terms/typeface.md)
- [フォント](./terms/font.md)
- [ファミリー](./terms/family.md)
- [ウェイト](./terms/weight.md)
- [イタリック体](./terms/italic.md)
- [ローマン体](./terms/roman.md)
- [コンデンスト体](./terms/condensed.md)
- [エクステンデッド体](./terms/extended.md)
- [合字（リガチャー）](./terms/ligature.md)
- [スモールキャップ](./terms/small-caps.md)
- [OpenType](./terms/opentype.md)

#### 書体の分類

- [セリフ体](./terms/serif.md)
- [サンセリフ体](./terms/sans-serif.md)
- [スラブセリフ体](./terms/slab-serif.md)
- [明朝体](./terms/mincho.md)
- [ゴシック体](./terms/gothic.md)
- [等幅フォント](./terms/monospaced-font.md)
- [全角](./terms/fullwidth.md)

#### 文字のディテール

- [グリフ](./terms/glyph.md)
- [ボディ](./terms/body.md)
- [字面](./terms/face.md)
- [サイドベアリング](./terms/side-bearing.md)
- [ベースライン](./terms/baseline.md)
- [キャップハイト](./terms/cap-height.md)
- [エックスハイト](./terms/x-height.md)
- [アセンダー](./terms/ascender.md)
- [ディセンダー](./terms/descender.md)
- [カウンター](./terms/counter.md)

### 行

- [文字サイズ](./terms/font-size.md)
- [字間](./terms/letter-space.md)
- [ベタ組み](./terms/betagumi.md)
- [カーニング](./terms/kerning.md)
- [トラッキング](./terms/tracking.md)
- [プロポーショナルメトリクス](./terms/proportional-metrics.md)
- [文字揃え](./terms/vertical-alignment.md)
- [ルビ](./terms/ruby.md)
- [圏点](./terms/emphasis-dots.md)
- [行送り（レディング）](./terms/leading.md)
- [行間](./terms/line-space.md)
- [行揃え](./terms/text-alignment.md)
- [行頭揃え](./terms/flush-left.md)
- [行末揃え](./terms/flush-right.md)
- [中央揃え](./terms/centered.md)
- [両端揃え](./terms/justified.md)
- [ぶら下げ](./terms/hanging-punctuation.md)
- [インデント](./terms/indent.md)
- [字詰め](./terms/jidume.md)
- [ハイフネーション](./terms/hyphenation.md)
- [禁則](./terms/line-breaking-rules.md)
- [縦中横](./terms/horizontal-in-vertical.md)

### 読みやすさ

- [リーダビリティ](./terms/readability.md)
- [レジビリティ](./terms/legibility.md)

### コンピューターと文字

- [文字コード](./terms/character-encoding.md)
- [Unicode](./terms/unicode.md)
- [UTF-8](./terms/utf-8.md)
- [文字参照](./terms/character-reference.md)
- [Adobe-Japan1](./terms/adobe-japan1.md)
- [JIS2004](./terms/jis2004.md)

### Webと文字

- [Webフォント](./terms/web-font.md)
- [FOUT](./terms/fout.md)
- [WOFF](./terms/woff.md)
- [サブセット（Webフォント）](./terms/font-subsetting.md)

### 付録

- [参考資料](references.md)

## コントリビューション
本プロジェクトでは、みなさまの議論への参加を歓迎します。項目・内容について、疑問・質問・提案などがあれば、自由にIssueを立ててください。議論を反映しながら、更新を進めていきます。

## 更新について
2019年1月から不定期に更新を開始し、同年9月の[第6回リリース](https://github.com/fontplus/web-typography-glossary/pull/109)をもって基本となる用語はカバーできたと考え用語の追加は一旦終了します。今後も改訂・加筆等の提案は歓迎いたしますので、ぜひ気軽にIssueを立ててください。

## ライセンス
[CC BY-NC-SA 4.0](https://creativecommons.org/licenses/by-nc-sa/4.0/)

## クレジット
執筆：[鈴木丈](https://github.com/terkel)  
図版：[伊藤涼](https://github.com/itosuzu)  
編集：[土屋綾子](https://github.com/tsuchir)、[平松るい](https://github.com/hrmtrui)  
協賛：[FONTPLUS](https://webfont.fontplus.jp)  
