---
layout: default
title: "GetGo Fonts for FontLab"
nav_order: 1
---

# GetGo Fonts for FontLab

Scratching your head to start a font? [FontLab 8](https://www.fontlab.com/font-editor/fontlab/) gives you a head start. With 99 free template fonts, we’re guiding you from the get-go! GetGo Fonts for FontLab is a carefully curated collection of quality typeface designs available in FontLab’s native VFJ format.

![Start your font with one of the 99 free GetGo Fonts for FontLab](illustrations/fontlab-getgo-poster-1920x880.svg)

The 99 free designs range from simple Latin sanserif and serif designs, include display and script fonts, and boast several massive multi-axis variable font projects.

But that’s not all! The Zoto fonts (based on the Noto global font collection) give you ready-to-use templates for over 70 writing systems (scripts) from around the world (Cyrillic, Greek, Arabic, emoji, and many others). Those fonts include the right glyph sets and OpenType features. The GetGo collection even bundles a few single-stroke (skeleton) fonts, on which you can experiment with FontLab’s live calligraphic Power Brush.

You may create your own fonts based on these fonts, and you may incorporate portions of these fonts into your own fonts. Each GetGo font is available under one of three licenses: CC-0 (public domain), Apache or OFL. You can download them in the FontLab VFJ format and open them in [FontLab 8](https://www.fontlab.com/font-editor/fontlab/). The collection is growing!

## Download

[Download all fonts](https://github.com/fontlabcom/getgo-fonts/raw/main/getgo-fonts-for-fontlab.zip){: .btn .btn-purple }

## Licenses

### CC-0

If the font is licensed under the [CC0 1.0 Universal Public Domain Dedication](https://creativecommons.org/publicdomain/zero/1.0/), it’s dedicated to the public domain. The person who associated a work with this deed has dedicated the work to the public domain by waiving all of his or her rights to the work worldwide under copyright law, including all related and neighboring rights, to the extent allowed by law. You can copy, modify, distribute and perform the work, even for commercial purposes, all without asking permission.

You may create your own fonts based on this font, and you may incorporate portions of this font into your own font. You may publish your own font under any license, including a commercial license, without any limitations.

### Apache

If the font is licensed under the [Apache License v2.0](https://www.apache.org/licenses/LICENSE-2.0.txt):

You may create your own fonts based on this font, and you may incorporate portions of this font into your own font. You may publish your own font under any license, including a commercial license, but you must:

- in _Font Info › Legal › Copyright_, include `Portions Copyright (put the year and the original copyright owner here).`
- in _Font Info › Legal › License_, include `Portions licensed under the Apache License v2.0.`

### OFL

If the font is licensed under the [SIL Open Font License, Version 1.1](https://scripts.sil.org/OFL):

You may create your own fonts based on this font, and you may incorporate portions of this font into your own font, but you must publish the resulting font under the same license (SIL Open Font License, Version 1.1):

- in _Font Info › Legal › Copyright_, include `Portions Copyright (put the year and the original copyright owner here).`
- in _Font Info › Legal › License_, put `Licensed under the SIL Open Font License, Version 1.1.`
- see [the license](https://scripts.sil.org/OFL) for more details

