---
layout: default
title: "Zoto Serif Lao"
---

# Zoto Serif Lao

<small>You can type in the box below to preview the font:</small>

<div contenteditable="true" class="texteditor" style="font-family: 'Zoto Serif Lao';">
<p spellcheck="false">ໃຣຯສຕດ ຊຢມໝເຫ ໂນໄຝວແ ໞບຈພະລ ຟກໜຳຮໟ</p>
</div>

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotoserif/zotoserif-lao.vfj){: .btn .btn-purple target="_blank" }

license: Apache \| Reference serif font for the Lao script \| glyphs: 166 \| scripts: Lao

---


## Zoto Serif Lao

Zoto Serif Lao is a design for the Lao script.

It contains 166 glyphs and 2 OpenType features, and supports 120 characters from the Unicode blocks: Lao, Basic Latin.


### Supported writing systems


#### Lao

Lao (ລາວ) is a Southeast Asian abugida, written left-to-right (7 million users). Used since the 14th century in Laos the Lao language, and also for Isan, Thai. Derived from the Khmer script. Needs software support for complex text layout (shaping). Read more on [ScriptSource](https://scriptsource.org/scr/Laoo), [Wikipedia](https://en.wikipedia.org/wiki/ISO_15924:Laoo), [Unicode](https://www.unicode.org/versions/Unicode13.0.0/ch16.pdf#G10988), [Wiktionary](https://en.wiktionary.org/wiki/Category:Lao_script).


### License

Based on [Noto](https://github.com/notofonts) by Google. Copyright 2011-2015 Google Inc. All Rights Reserved. Licensed under the [Apache License v2.0](https://www.apache.org/licenses/LICENSE-2.0.txt).

### Using this font

You may create your own fonts based on this font, and you may incorporate portions of this font into your own font. You may publish your own font under any license, including a commercial license, but you must:

- in _Font Info › Legal › Copyright_, include `Portions Copyright 2011-2015 Google Inc.`
- in _Font Info › Legal › License_, include `Portions licensed under the Apache License v2.0.`


---

## Character map

<div style="font-family: 'Zoto Serif Lao'; font-size: 2em;">
! " $ % & ' ( ) * + , - . / : ; < = > ? @   ; ກ ຂ ຄ ງ ຈ ຊ ຍ ດ ຕ ຖ ທ ນ ບ ປ ຜ ຝ ພ ຟ ມ ຢ ຣ ລ ວ ສ ຫ ອ ຮ ຯ ະ ັ າ ຳ ິ ີ ຶ ື ຸ ູ ົ ຼ ຽ ເ ແ ໂ ໃ ໄ ໆ ່ ້ ໊ ໋ ໌ ໍ ໜ ໝ ໞ ໟ ◌
</div>

