---
layout: default
title: "Zoto Sans Sundanese"
---

# Zoto Sans Sundanese

<small>You can type in the box below to preview the font:</small>

<div contenteditable="true" class="texteditor" style="font-family: 'Zoto Sans Sundanese';">
<p spellcheck="false">ᮙᮍᮮᮜᮠᮗ ᮅᮞᮚᮒᮑᮯ ᮌᮻᮘᮛᮃᮽ ᮇᮟᮎᮕᮏᮊ ᮓᮺᮝᮄᮆᮋ</p>
</div>

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-sundanese.vfj){: .btn .btn-purple target="_blank" }

license: Apache \| Reference sans font for the Sundanese script \| glyphs: 79 \| scripts: Sundanese

---


## Zoto Sans Sundanese

Zoto Sans Sundanese is a design for the Sundanese script.

It contains 79 glyphs and 4 OpenType features, and supports 77 characters from the Unicode blocks: Sundanese, Sundanese Supplement.


### Supported writing systems


#### Sundanese

Sundanese (ᮃᮊ᮪ᮞᮛ ᮞᮥᮔ᮪ᮓ) is a Southeast Asian abugida, written left-to-right. The standard form (Aksara Sunda Baku, ᮃᮊ᮪ᮞᮛ ᮞᮥᮔ᮪ᮓ ᮘᮊᮥ) is used on the Indonesian island Java since 1996 for the Sundanese language (27 million speakers), and is derived from Old Sundanese script (Aksara Sunda Kuno, ᮃᮊ᮪ᮞᮛ ᮞᮥᮔ᮪ᮓ ᮊᮥᮔ) used in the 14th–18th centuries. The Sudanese language also uses Latin script. Needs software support for complex text layout (shaping). Read more on [ScriptSource](https://scriptsource.org/scr/Sund), [Wikipedia](https://en.wikipedia.org/wiki/ISO_15924:Sund), [Unicode](https://www.unicode.org/versions/Unicode13.0.0/ch17.pdf#G27244), [Wiktionary](https://en.wiktionary.org/wiki/Category:Sundanese_script).


### License

Based on [Noto](https://github.com/notofonts) by Google. Copyright 2011-2015 Google Inc. All Rights Reserved. Licensed under the [Apache License v2.0](https://www.apache.org/licenses/LICENSE-2.0.txt).

### Using this font

You may create your own fonts based on this font, and you may incorporate portions of this font into your own font. You may publish your own font under any license, including a commercial license, but you must:

- in _Font Info › Legal › Copyright_, include `Portions Copyright 2011-2015 Google Inc.`
- in _Font Info › Legal › License_, include `Portions licensed under the Apache License v2.0.`


---

## Character map

<div style="font-family: 'Zoto Sans Sundanese'; font-size: 2em;">
ᮀ ᮁ ᮂ ᮃ ᮄ ᮅ ᮆ ᮇ ᮈ ᮉ ᮊ ᮋ ᮌ ᮍ ᮎ ᮏ ᮐ ᮑ ᮒ ᮓ ᮔ ᮕ ᮖ ᮗ ᮘ ᮙ ᮚ ᮛ ᮜ ᮝ ᮞ ᮟ ᮠ ᮡ ᮢ ᮣ ᮤ ᮥ ᮦ ᮧ ᮨ ᮩ ᮪ ᮫ ᮬ ᮭ ᮮ ᮯ ᮺ ᮻ ᮼ ᮽ ᮾ ᮿ ᳀ ᳁ ᳂ ᳃ ᳄ ᳅ ᳆ ᳇
</div>

