---
layout: default
title: "Zoto Sans Cuneiform"
---

# Zoto Sans Cuneiform

<small>You can type in the box below to preview the font:</small>

<div contenteditable="true" class="texteditor" style="font-family: 'Zoto Sans Cuneiform';">
<p spellcheck="false">𒆀𒀵𒈏𒁼𒃠𒂚 𒁱𒄊𒋍𒃈𒅊𒈤 𒆿𒌓𒌥𒌭𒋗𒄵 𒀴𒋬𒅤𒁋𒀕𒍃 𒈿𒅸𒈙𒋊𒄸𒊻</p>
</div>

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-cuneiform.vfj){: .btn .btn-purple target="_blank" }

license: Apache \| Reference sans font for the Cuneiform script \| glyphs: 986 \| scripts: Cuneiform

---


## Zoto Sans Cuneiform

Zoto Sans Cuneiform is a design for the Sumero-Akkadian cuneiform script.

It contains 986 glyphs, and supports 987 characters from the Unicode blocks: Cuneiform, Cuneiform Numbers and Punctuation.


### Supported writing systems


#### Sumero-Akkadian cuneiform

Sumero-Akkadian cuneiform is a historical Middle Eastern logo-syllabary, written left-to-right. Was used at least since 3200 BCE in today’s Iraq for the now-exinct Sumerian language. Was later used in today’s Iran, Turkey, Syria, and Egypt, for languages like Akkadian, Elamite, Hittite, Luwian and Urartian. Widely believed to be the first writing system in the world. Combined logographic, consonantal alphabetic and syllabic signs. Since c. 900 BCE gradually replaced by the Aramaic script. Read more on [ScriptSource](https://scriptsource.org/scr/Xsux), [Wikipedia](https://en.wikipedia.org/wiki/ISO_15924:Xsux), [Unicode](https://www.unicode.org/versions/Unicode13.0.0/ch11.pdf#G26852), [Wiktionary](https://en.wiktionary.org/wiki/Category:Cuneiform_script).


### License

Based on [Noto](https://github.com/notofonts) by Google. Copyright 2011-2015 Google Inc. All Rights Reserved. Licensed under the [Apache License v2.0](https://www.apache.org/licenses/LICENSE-2.0.txt).

### Using this font

You may create your own fonts based on this font, and you may incorporate portions of this font into your own font. You may publish your own font under any license, including a commercial license, but you must:

- in _Font Info › Legal › Copyright_, include `Portions Copyright 2011-2015 Google Inc.`
- in _Font Info › Legal › License_, include `Portions licensed under the Apache License v2.0.`


---

## Character map

<div style="font-family: 'Zoto Sans Cuneiform'; font-size: 2em;">
𒀀 𒀁 𒀂 𒀃 𒀄 𒀅 𒀆 𒀇 𒀈 𒀉 𒀊 𒀋 𒀌 𒀍 𒀎 𒀏 𒀐 𒀑 𒀒 𒀓 𒀔 𒀕 𒀖 𒀗 𒀘 𒀙 𒀚 𒀛 𒀜 𒀝 𒀞 𒀟 𒀠 𒀡 𒀢 𒀣 𒀤 𒀥 𒀦 𒀧 𒀨 𒀩 𒀪 𒀫 𒀬 𒀭 𒀮 𒀯 𒀰 𒀱 𒀲 𒀳 𒀴 𒀵 𒀶 𒀷 𒀸 𒀹 𒀺 𒀻 𒀼 𒀽 𒀾 𒀿 𒁀 𒁁 𒁂 𒁃 𒁄 𒁅 𒁆 𒁇 𒁈 𒁉 𒁊 𒁋 𒁌 𒁍 𒁎 𒁏 𒁐 𒁑 𒁒 𒁓 𒁔 𒁕 𒁖 𒁗 𒁘 𒁙 𒁚 𒁛 𒁜 𒁝 𒁞 𒁟 𒁠 𒁡 𒁢 𒁣 𒁤 𒁥 𒁦 𒁧 𒁨 𒁩 𒁪 𒁫 𒁬 𒁭 𒁮 𒁯 𒁰 𒁱 𒁲 𒁳 𒁴 𒁵 𒁶 𒁷 𒁸 𒁹 𒁺 𒁻 𒁼 𒁽 𒁾 𒁿 𒂀 𒂁 𒂂 𒂃 𒂄 𒂅 𒂆 𒂇 𒂈 𒂉 𒂊 𒂋 𒂌 𒂍 𒂎 𒂏 𒂐 𒂑 𒂒 𒂓 𒂔 𒂕 𒂖 𒂗 𒂘 𒂙 𒂚 𒂛 𒂜 𒂝 𒂞 𒂟 𒂠 𒂡 𒂢 𒂣 𒂤 𒂥 𒂦 𒂧 𒂨 𒂩 𒂪 𒂫 𒂬 𒂭 𒂮 𒂯 𒂰 𒂱 𒂲 𒂳 𒂴 𒂵 𒂶 𒂷 𒂸 𒂹 𒂺 𒂻 𒂼 𒂽 𒂾 𒂿 𒃀 𒃁 𒃂 𒃃 𒃄 𒃅 𒃆 𒃇 𒃈 𒃉 𒃊 𒃋 𒃌 𒃍 𒃎 𒃏 𒃐 𒃑 𒃒 𒃓 𒃔 𒃕 𒃖 𒃗 𒃘 𒃙 𒃚 𒃛 𒃜 𒃝 𒃞 𒃟 𒃠 𒃡 𒃢 𒃣 𒃤 𒃥 𒃦 𒃧 𒃨 𒃩 𒃪 𒃫 𒃬 𒃭 𒃮 𒃯 𒃰 𒃱 𒃲 𒃳 𒃴 𒃵 𒃶 𒃷 𒃸 𒃹 𒃺 𒃻 𒃼 𒃽 𒃾 𒃿 𒄀 𒄁 𒄂 𒄃 𒄄 𒄅 𒄆 𒄇 𒄈 𒄉 𒄊 𒄋 𒄌 𒄍 𒄎 𒄏 𒄐 𒄑 𒄒 𒄓 𒄔 𒄕 𒄖 𒄗 𒄘 𒄙 𒄚 𒄛 𒄜 𒄝 𒄞 𒄟 𒄠 𒄡 𒄢 𒄣 𒄤 𒄥 𒄦 𒄧 𒄨 𒄩 𒄪 𒄫 𒄬 𒄭 𒄮 𒄯 𒄰 𒄱 𒄲 𒄳 𒄴 𒄵 𒄶 𒄷 𒄸 𒄹 𒄺 𒄻 𒄼 𒄽 𒄾 𒄿 𒅀 𒅁 𒅂 𒅃 𒅄 𒅅 𒅆 𒅇 𒅈 𒅉 𒅊 𒅋 𒅌 𒅍 𒅎 𒅏 𒅐 𒅑 𒅒 𒅓 𒅔 𒅕 𒅖 𒅗 𒅘 𒅙 𒅚 𒅛 𒅜 𒅝 𒅞 𒅟 𒅠 𒅡 𒅢 𒅣 𒅤 𒅥 𒅦 𒅧 𒅨 𒅩 𒅪 𒅫 𒅬 𒅭 𒅮 𒅯 𒅰 𒅱 𒅲 𒅳 𒅴 𒅵 𒅶 𒅷 𒅸 𒅹 𒅺 𒅻 𒅼 𒅽 𒅾 𒅿 𒆀 𒆁 𒆂 𒆃 𒆄 𒆅 𒆆 𒆇 𒆈 𒆉 𒆊 𒆋 𒆌 𒆍 𒆎 𒆏 𒆐 𒆑 𒆒 𒆓 𒆔 𒆕 𒆖 𒆗 𒆘 𒆙 𒆚 𒆛 𒆜 𒆝 𒆞 𒆟 𒆠 𒆡 𒆢 𒆣 𒆤 𒆥 𒆦 𒆧 𒆨 𒆩 𒆪 𒆫 𒆬 𒆭 𒆮 𒆯 𒆰 𒆱 𒆲 𒆳 𒆴 𒆵 𒆶 𒆷 𒆸 𒆹 𒆺 𒆻 𒆼 𒆽 𒆾 𒆿 𒇀 𒇁 𒇂 𒇃 𒇄 𒇅 𒇆 𒇇 𒇈 𒇉 𒇊 𒇋 𒇌 𒇍 𒇎 𒇏 𒇐 𒇑 𒇒 𒇓 𒇔 𒇕 𒇖 𒇗 𒇘 𒇙 𒇚 𒇛 𒇜 𒇝 𒇞 𒇟 𒇠 𒇡 𒇢 𒇣 𒇤 𒇥 𒇦 𒇧 𒇨 𒇩 𒇪 𒇫 𒇬 𒇭 𒇮 𒇯 𒇰 𒇱 𒇲 𒇳 𒇴 𒇵 𒇶 𒇷 𒇸 𒇹 𒇺 𒇻 𒇼 𒇽 𒇾 𒇿 𒈀 𒈁 𒈂 𒈃 𒈄 𒈅 𒈆 𒈇 𒈈 𒈉 𒈊 𒈋 𒈌 𒈍 𒈎 𒈏 𒈐 𒈑 𒈒 𒈓 𒈔 𒈕 𒈖 𒈗 𒈘 𒈙 𒈚 𒈛 𒈜 𒈝 𒈞 𒈟 𒈠 𒈡 𒈢 𒈣 𒈤 𒈥 𒈦 𒈧 𒈨 𒈩 𒈪 𒈫 𒈬 𒈭 𒈮 𒈯 𒈰 𒈱 𒈲 𒈳 𒈴 𒈵 𒈶 𒈷 𒈸 𒈹 𒈺 𒈻 𒈼 𒈽 𒈾 𒈿 𒉀 𒉁 𒉂 𒉃 𒉄 𒉅 𒉆 𒉇 𒉈 𒉉 𒉊 𒉋 𒉌 𒉍 𒉎 𒉏 𒉐 𒉑 𒉒 𒉓 𒉔 𒉕 𒉖 𒉗 𒉘 𒉙 𒉚 𒉛 𒉜 𒉝 𒉞 𒉟 𒉠 𒉡 𒉢 𒉣 𒉤 𒉥 𒉦 𒉧 𒉨 𒉩 𒉪 𒉫 𒉬 𒉭 𒉮 𒉯 𒉰 𒉱 𒉲 𒉳 𒉴 𒉵 𒉶 𒉷 𒉸 𒉹 𒉺 𒉻 𒉼 𒉽 𒉾 𒉿 𒊀 𒊁 𒊂 𒊃 𒊄 𒊅 𒊆 𒊇 𒊈 𒊉 𒊊 𒊋 𒊌 𒊍 𒊎 𒊏 𒊐 𒊑 𒊒 𒊓 𒊔 𒊕 𒊖 𒊗 𒊘 𒊙 𒊚 𒊛 𒊜 𒊝 𒊞 𒊟 𒊠 𒊡 𒊢 𒊣 𒊤 𒊥 𒊦 𒊧 𒊨 𒊩 𒊪 𒊫 𒊬 𒊭 𒊮 𒊯 𒊰 𒊱 𒊲 𒊳 𒊴 𒊵 𒊶 𒊷 𒊸 𒊹 𒊺 𒊻 𒊼 𒊽 𒊾 𒊿 𒋀 𒋁 𒋂 𒋃 𒋄 𒋅 𒋆 𒋇 𒋈 𒋉 𒋊 𒋋 𒋌 𒋍 𒋎 𒋏 𒋐 𒋑 𒋒 𒋓 𒋔 𒋕 𒋖 𒋗 𒋘 𒋙 𒋚 𒋛 𒋜 𒋝 𒋞 𒋟 𒋠 𒋡 𒋢 𒋣 𒋤 𒋥 𒋦 𒋧 𒋨 𒋩 𒋪 𒋫 𒋬 𒋭 𒋮 𒋯 𒋰 𒋱 𒋲 𒋳 𒋴 𒋵 𒋶 𒋷 𒋸 𒋹 𒋺 𒋻 𒋼 𒋽 𒋾 𒋿 𒌀 𒌁 𒌂 𒌃 𒌄 𒌅 𒌆 𒌇 𒌈 𒌉 𒌊 𒌋 𒌌 𒌍 𒌎 𒌏 𒌐 𒌑 𒌒 𒌓 𒌔 𒌕 𒌖 𒌗 𒌘 𒌙 𒌚 𒌛 𒌜 𒌝 𒌞 𒌟 𒌠 𒌡 𒌢 𒌣 𒌤 𒌥 𒌦 𒌧 𒌨 𒌩 𒌪 𒌫 𒌬 𒌭 𒌮 𒌯 𒌰 𒌱 𒌲 𒌳 𒌴 𒌵 𒌶 𒌷 𒌸 𒌹 𒌺 𒌻 𒌼 𒌽 𒌾 𒌿 𒍀 𒍁 𒍂 𒍃 𒍄 𒍅 𒍆 𒍇 𒍈 𒍉 𒍊 𒍋 𒍌 𒍍 𒍎 𒍏 𒍐 𒍑 𒍒 𒍓 𒍔 𒍕 𒍖 𒍗 𒍘 𒍙 𒍚 𒍛 𒍜 𒍝 𒍞 𒍟 𒍠 𒍡 𒍢 𒍣 𒍤 𒍥 𒍦 𒍧 𒍨 𒍩 𒍪 𒍫 𒍬 𒍭 𒍮 𒑰 𒑱 𒑲 𒑳
</div>

