---
layout: default
title: "Zoto Sans Coptic"
---

# Zoto Sans Coptic

<small>You can type in the box below to preview the font:</small>

<div contenteditable="true" class="texteditor" style="font-family: 'Zoto Sans Coptic';">
<p spellcheck="false">ⲰⲮⲄⳜⲜⳄ ⲦⲤⲢϮⲶⳠ ⲽⲫⲭⳗⲿⳳ ⲃⳇⲃⲏⳃⳗ ϫⳁⲅⲽⲉⲩ</p>
</div>

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-coptic.vfj){: .btn .btn-purple target="_blank" }

license: Apache \| Reference sans font for the Coptic script \| glyphs: 190 \| scripts: Coptic, Latin

---


## Zoto Sans Coptic

Zoto Sans Coptic is a design for the Coptic script.

It contains 190 glyphs and 3 OpenType features, and supports 177 characters from the Unicode blocks: Coptic, Greek and Coptic, IPA Extensions, Combining Diacritical Marks, Spacing Modifier Letters.


### Supported writing systems


#### Coptic

Coptic is a European bicameral alphabet, written left-to-right (0.4 million users). Since the 2nd century CE was used for the Coptic language, now the liturgical language of the Coptic church. Als used for Andaandi, Nobiin, Old Nubian and Mattokki. Derived from the Greek alphabet. Read more on [ScriptSource](https://scriptsource.org/scr/Copt), [Wikipedia](https://en.wikipedia.org/wiki/ISO_15924:Copt), [Unicode](https://www.unicode.org/versions/Unicode13.0.0/ch07.pdf#G16256), [Wiktionary](https://en.wiktionary.org/wiki/Category:Coptic_script).


### License

Based on [Noto](https://github.com/notofonts) by Google. Copyright 2011-2015 Google Inc. All Rights Reserved. Licensed under the [Apache License v2.0](https://www.apache.org/licenses/LICENSE-2.0.txt).

### Using this font

You may create your own fonts based on this font, and you may incorporate portions of this font into your own font. You may publish your own font under any license, including a commercial license, but you must:

- in _Font Info › Legal › Copyright_, include `Portions Copyright 2011-2015 Google Inc.`
- in _Font Info › Legal › License_, include `Portions licensed under the Apache License v2.0.`


---

## Character map

<div style="font-family: 'Zoto Sans Coptic'; font-size: 2em;">
ŋ ǁ ɑ ɔ ə ɛ ɟ ɡ ɲ ɾ ʃ ʒ ʤ ʧ ˇ ː ˘ ˙ ˚ ˛ ˝ ̀ ́ ̂ ̄ ̅ ̇ ̈ ̣ ̿ ͡ Ϣ ϣ Ϥ ϥ Ϧ ϧ Ϩ ϩ Ϫ ϫ Ϭ ϭ Ϯ ϯ ᷍ Ⲁ ⲁ Ⲃ ⲃ Ⲅ ⲅ Ⲇ ⲇ Ⲉ ⲉ Ⲋ ⲋ Ⲍ ⲍ Ⲏ ⲏ Ⲑ ⲑ Ⲓ ⲓ Ⲕ ⲕ Ⲗ ⲗ Ⲙ ⲙ Ⲛ ⲛ Ⲝ ⲝ Ⲟ ⲟ Ⲡ ⲡ Ⲣ ⲣ Ⲥ ⲥ Ⲧ ⲧ Ⲩ ⲩ Ⲫ ⲫ Ⲭ ⲭ Ⲯ ⲯ Ⲱ ⲱ Ⲳ ⲳ Ⲵ ⲵ Ⲷ ⲷ Ⲹ ⲹ Ⲻ ⲻ Ⲽ ⲽ Ⲿ ⲿ Ⳁ ⳁ Ⳃ ⳃ Ⳅ ⳅ Ⳇ ⳇ Ⳉ ⳉ Ⳋ ⳋ Ⳍ ⳍ Ⳏ ⳏ Ⳑ ⳑ Ⳓ ⳓ Ⳕ ⳕ Ⳗ ⳗ Ⳙ ⳙ Ⳛ ⳛ Ⳝ ⳝ Ⳟ ⳟ Ⳡ ⳡ Ⳣ ⳣ ⳤ ⳥ ⳦ ⳧ ⳨ ⳩ ⳪ Ⳬ ⳬ Ⳮ ⳮ ⳯ ⳰ ⳱ Ⳳ ⳳ ⳹ ⳺ ⳻ ⳼ ⳾ ⳿ ︤ ︥ ︦
</div>

