---
layout: default
title: "Zoto Kufi Arabic"
---

# Zoto Kufi Arabic

<small>You can type in the box below to preview the font:</small>

<div contenteditable="true" class="texteditor" style="font-family: 'Zoto Kufi Arabic';">
<p spellcheck="false">ﻹݬݣڙﺯﭘ ﹾﺂښێﹲۯ ۮڦﭖﺤﮌظ ڰګﺊذﮭڢ ۉﺠحﭧﭭﭽ</p>
</div>

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zoto-kufiarabic.vfj){: .btn .btn-purple target="_blank" }

license: Apache \| Reference font for the Arabic script in the Kufi style \| glyphs: 762 \| scripts: Arabic

---


## Zoto Kufi Arabic

Zoto Kufi Arabic is a design for the Arabic script.

It contains 762 glyphs and 10 OpenType features, and supports 473 characters from the Unicode blocks: Arabic, Arabic Presentation Forms-B, Arabic Presentation Forms-A, Arabic Supplement.


### Supported writing systems


#### Arabic

Arabic (العربية) is a Middle Eastern abjad, written right-to-left (660 million users). 2nd- or 3rd-most used script in the world. Used for the Arabic language since the 4th century, and for many other languages, often in Islamic countries or communities in Asia, Africa and the Middle East, like Persian, Uyghur, Kurdish, Punjabi, Sindhi, Balti, Balochi, Pashto, Lurish, Urdu, Kashmiri, Rohingya, Somali, Mandinka, Kazakh (in China), Kurdish, or Azeri (in Iran). Was used for Turkish until 1928. Includes 28 basic consonant letters for the Arabic language, plus additional letters for other languages. Some letters represent a consonant or a long vowel, while short vowels are optionally written with diacritics. Variants include Kufi with a very simplified structure, the widely-used Naskh calligraphic variant, and the highly cursive Nastaliq used mainly for Urdu. Needs software support for complex text layout (shaping). Read more on [ScriptSource](https://scriptsource.org/scr/Arab), [Wikipedia](https://en.wikipedia.org/wiki/ISO_15924:Arab), [Unicode](https://www.unicode.org/versions/Unicode13.0.0/ch09.pdf#G20596), [Wiktionary](https://en.wiktionary.org/wiki/Category:Arabic_script).


### License

Based on [Noto](https://github.com/notofonts) by Google. Copyright 2011-2015 Google Inc. All Rights Reserved. Licensed under the [Apache License v2.0](https://www.apache.org/licenses/LICENSE-2.0.txt).

### Using this font

You may create your own fonts based on this font, and you may incorporate portions of this font into your own font. You may publish your own font under any license, including a commercial license, but you must:

- in _Font Info › Legal › Copyright_, include `Portions Copyright 2011-2015 Google Inc.`
- in _Font Info › Legal › License_, include `Portions licensed under the Apache License v2.0.`


---

## Character map

<div style="font-family: 'Zoto Kufi Arabic'; font-size: 2em;">
؋ ، ؍ ؎ ؏ ؐ ؑ ؒ ؓ ؔ ؕ ؛ ؞ ؟ ء آ أ ؤ إ ئ ا ب ة ت ث ج ح خ د ذ ر ز س ش ص ض ط ظ ع غ ـ ف ق ك ل م ن ه و ى ي ً ٌ ٍ َ ُ ِ ّ ْ ٓ ٔ ٕ ٖ ٗ ٘ ٙ ٚ ٛ ٜ ٝ ٞ ٪ ٫ ٬ ٭ ٮ ٯ ٰ ٱ ٲ ٳ ٵ ٶ ٷ ٸ ٹ ٺ ٻ ټ ٽ پ ٿ ڀ ځ ڂ ڃ ڄ څ چ ڇ ڈ ډ ڊ ڋ ڌ ڍ ڎ ڏ ڐ ڑ ڒ ړ ڔ ڕ ږ ڗ ژ ڙ ښ ڛ ڜ ڝ ڞ ڟ ڠ ڡ ڢ ڣ ڤ ڥ ڦ ڧ ڨ ک ڪ ګ ڬ ڭ ڮ گ ڰ ڱ ڲ ڳ ڴ ڵ ڶ ڷ ڸ ڹ ں ڻ ڼ ڽ ھ ڿ ۀ ہ ۂ ۃ ۄ ۅ ۆ ۇ ۈ ۉ ۊ ۋ ی ۍ ێ ۏ ې ۑ ے ۓ ۔ ە ۖ ۗ ۘ ۙ ۚ ۛ ۜ ۞ ۟ ۠ ۡ ۢ ۣ ۤ ۥ ۦ ۧ ۨ ۩ ۪ ۫ ۭ ۮ ۯ ۺ ۻ ۼ ۽ ۾ ۿ ݐ ݑ ݒ ݓ ݔ ݕ ݖ ݗ ݘ ݙ ݚ ݛ ݜ ݝ ݞ ݟ ݠ ݡ ݢ ݣ ݤ ݥ ݦ ݧ ݨ ݩ ݪ ݫ ݬ ݭ ◌ ﭐ ﭑ ﭖ ﭗ ﭘ ﭙ ﭦ ﭧ ﭨ ﭩ ﭪ ﭫ ﭬ ﭭ ﭺ ﭻ ﭼ ﭽ ﮈ ﮉ ﮊ ﮋ ﮌ ﮍ ﮎ ﮏ ﮐ ﮑ ﮒ ﮓ ﮔ ﮕ ﮞ ﮟ ﮤ ﮥ ﮦ ﮧ ﮨ ﮩ ﮪ ﮫ ﮬ ﮭ ﮮ ﮯ ﮰ ﮱ ﯦ ﯧ ﯨ ﯩ ﯼ ﯽ ﯾ ﯿ ﱞ ﱟ ﱠ ﱡ ﱢ ﱣ ﴾ ﴿ ﷲ ﷼ ﹰ ﹲ ﹴ ﹶ ﹸ ﹺ ﹼ ﹾ ﺀ ﺁ ﺂ ﺃ ﺄ ﺅ ﺆ ﺇ ﺈ ﺉ ﺊ ﺋ ﺌ ﺍ ﺎ ﺏ ﺐ ﺑ ﺒ ﺓ ﺔ ﺕ ﺖ ﺗ ﺘ ﺙ ﺚ ﺛ ﺜ ﺝ ﺞ ﺟ ﺠ ﺡ ﺢ ﺣ ﺤ ﺥ ﺦ ﺧ ﺨ ﺩ ﺪ ﺫ ﺬ ﺭ ﺮ ﺯ ﺰ ﺱ ﺲ ﺳ ﺴ ﺵ ﺶ ﺷ ﺸ ﺹ ﺺ ﺻ ﺼ ﺽ ﺾ ﺿ ﻀ ﻁ ﻂ ﻃ ﻄ ﻅ ﻆ ﻇ ﻈ ﻉ ﻊ ﻋ ﻌ ﻍ ﻎ ﻏ ﻐ ﻑ ﻒ ﻓ ﻔ ﻕ ﻖ ﻗ ﻘ ﻙ ﻚ ﻛ ﻜ ﻝ ﻞ ﻟ ﻠ ﻡ ﻢ ﻣ ﻤ ﻥ ﻦ ﻧ ﻨ ﻩ ﻪ ﻫ ﻬ ﻭ ﻮ ﻯ ﻰ ﻱ ﻲ ﻳ ﻴ ﻵ ﻶ ﻷ ﻸ ﻹ ﻺ ﻻ ﻼ
</div>

