---
layout: default
title: "GetGo Fonts for FontLab"
nav_order: 1
---

# GetGo Fonts for FontLab

Scratching your head to start a font? [FontLab 8](https://www.fontlab.com/font-editor/fontlab/) gives you a head start. With 99 free template fonts, we’re guiding you from the get-go! GetGo Fonts for FontLab is a carefully curated collection of quality typeface designs available in FontLab’s native VFJ format.

![Start your font with one of the 99 free GetGo Fonts for FontLab](illustrations/fontlab-getgo-poster-1920x880.svg)

The 99 free designs range from simple Latin sanserif and serif designs, include display and script fonts, and boast several massive multi-axis variable font projects.

But that’s not all! The Zoto fonts (based on the Noto global font collection) give you ready-to-use templates for over 70 writing systems (scripts) from around the world (Cyrillic, Greek, Arabic, emoji, and many others). Those fonts include the right glyph sets and OpenType features. The GetGo collection even bundles a few single-stroke (skeleton) fonts, on which you can experiment with FontLab’s live calligraphic Power Brush.

You may create your own fonts based on these fonts, and you may incorporate portions of these fonts into your own fonts. Each GetGo font is available under one of three licenses: CC-0 (public domain), Apache or OFL. You can download them in the FontLab VFJ format and open them in [FontLab 8](https://www.fontlab.com/font-editor/fontlab/). The collection is growing!

## Download

[Download all fonts](https://github.com/fontlabcom/getgo-fonts/raw/main/getgo-fonts-for-fontlab.zip){: .btn .btn-purple }

## Licenses

### CC-0

If the font is licensed under the [CC0 1.0 Universal Public Domain Dedication](https://creativecommons.org/publicdomain/zero/1.0/), it’s dedicated to the public domain. The person who associated a work with this deed has dedicated the work to the public domain by waiving all of his or her rights to the work worldwide under copyright law, including all related and neighboring rights, to the extent allowed by law. You can copy, modify, distribute and perform the work, even for commercial purposes, all without asking permission.

You may create your own fonts based on this font, and you may incorporate portions of this font into your own font. You may publish your own font under any license, including a commercial license, without any limitations.

### Apache

If the font is licensed under the [Apache License v2.0](https://www.apache.org/licenses/LICENSE-2.0.txt):

You may create your own fonts based on this font, and you may incorporate portions of this font into your own font. You may publish your own font under any license, including a commercial license, but you must:

- in _Font Info › Legal › Copyright_, include `Portions Copyright (put the year and the original copyright owner here).`
- in _Font Info › Legal › License_, include `Portions licensed under the Apache License v2.0.`

### OFL

If the font is licensed under the [SIL Open Font License, Version 1.1](https://scripts.sil.org/OFL):

You may create your own fonts based on this font, and you may incorporate portions of this font into your own font, but you must publish the resulting font under the same license (SIL Open Font License, Version 1.1):

- in _Font Info › Legal › Copyright_, include `Portions Copyright (put the year and the original copyright owner here).`
- in _Font Info › Legal › License_, put `Licensed under the SIL Open Font License, Version 1.1.`
- see [the license](https://scripts.sil.org/OFL) for more details



## Fonts



### GG Baar

[![DECODE MYSTERY observe greatest rubrum](images/baar.svg)](baar/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/cc0/baar/baar.vfj){: .btn target="_blank" }

license: CC-0 \| Modular narrow display font \| glyphs: 98 \| scripts: Latin \| [Read more…](baar/)

---


### GG Boto

[![Vältože бомуще θρώπον çavatečkul](images/boto-var.svg)](boto-var/)

[Download FontLab VFJ](https://minhaskamal.github.io/DownGit/#/home?url=https://github.com/fontlabcom/getgo-fonts/blob/main/getgo-fonts/apache/boto/boto-var.vfj){: .btn target="_blank" }

license: Apache \| Grotesque sanserif design with the width, weight and italic axis \| glyphs: 3387 \| scripts: Latin, Cyrillic, Greek \| [Read more…](boto-var/)

---


### GG Cafe

[![FRESH DIRECT espresso first ļbĩẅńà](images/cafe.svg)](cafe/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/cafe/cafe.vfj){: .btn target="_blank" }

license: Apache \| Signpainter-style flat brush script font \| glyphs: 372 \| scripts: Latin, Greek \| [Read more…](cafe/)

---


### GG Club OFL

[![CLUB ŞẎLOP sports ħěbmṍģ ḝæŧlāť](images/club-var.svg)](club-var/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/ofl/club/club-var.vfj){: .btn target="_blank" }

license: OFL \| Variable font with 12 axes in college block style \| glyphs: 563 \| scripts: Latin, Greek \| [Read more…](club-var/)

---


### GG Cosm Italic

[![COSMOS ŊŲĦŊŤĮ natural yșœśôá vûūâŧô](images/cosm-italic-var.svg)](cosm-italic-var/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/cc0/cosm/cosm-italic-var.vfj){: .btn target="_blank" }

license: CC-0 \| Neo-grotesque sanserif font family with a weight axis, italic version \| glyphs: 340 \| scripts: Latin \| [Read more…](cosm-italic-var/)

---


### GG Cosm

[![WORLD ĖÈØŎXĴ discover nękćzęĥ oșőűng](images/cosm-var.svg)](cosm-var/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/cc0/cosm/cosm-var.vfj){: .btn target="_blank" }

license: CC-0 \| Neo-grotesque sanserif font family with a weight axis, upright version \| glyphs: 359 \| scripts: Latin \| [Read more…](cosm-var/)

---


### GG Deco

[![RIDSNC QUAMJV zifwlz matknh bopfxc](images/deco.svg)](deco/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/cc0/deco/deco.vfj){: .btn target="_blank" }

license: CC-0 \| Geometric art deco sanserif font \| glyphs: 104 \| scripts: Latin \| [Read more…](deco/)

---


### GG Fest

[![FESTIVE Hippy orange astound łeľũŧó](images/fest.svg)](fest/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/fest/fest.vfj){: .btn target="_blank" }

license: Apache \| Festive slab serif font inspired by 1950s hand lettering \| glyphs: 369 \| scripts: Latin \| [Read more…](fest/)

---


### GG Hint

[![REVOLT Revolt revolt ĦBŦĒC bĉţėŷľ](images/hint.svg)](hint/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/hint/hint.vfj){: .btn target="_blank" }

license: Apache \| Unicase sanserif design with pixel-perfect manual TrueType Hinting (TTH) \| glyphs: 372 \| scripts: Latin, Greek \| [Read more…](hint/)

---


### GG Medi

[![XLJWDB XAPQJK oilmfd eurnco evsywc](images/medi.svg)](medi/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/cc0/medi/medi.vfj){: .btn target="_blank" }

license: CC-0 \| Didone serif font \| glyphs: 103 \| scripts: Latin \| [Read more…](medi/)

---


### GG Ocra

[![KYXIZW PKOJG bpxhzb ｳｴｵｶｷ vlegms](images/ocra.svg)](ocra/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/cc0/ocra/ocra.vfj){: .btn target="_blank" }

license: CC-0 \| Simple OCR-A (Latin) and OCR-BK (Japanese) font \| glyphs: 177 \| scripts: Latin, Katakana \| [Read more…](ocra/)

---


### GG Pixa

[![A˪̀ͰϢЀ Ա֑؆܀ހߊऀ ঀஂഀกༀကᄀ Ꭰ᐀ ᚠ⠀ ⴰ⺔ぁァ](images/pixa.svg)](pixa/)

[Download FontLab VFJ](https://minhaskamal.github.io/DownGit/#/home?url=https://github.com/fontlabcom/getgo-fonts/blob/main/getgo-fonts/cc0/pixa/pixa.vfj){: .btn target="_blank" }

license: CC-0 \| Quirky pixel font with 14 pixels tall letters, for 28 writing systems \| glyphs: 14769 \| scripts: Han, Hangul, Latin, Canadian Aboriginal, Greek, Cyrillic, Arabic, Katakana, Myanmar, Coptic, Devanagari, Cherokee, Armenian, Hiragana, Hebrew, Runic, Bengali, Syriac, Thai, Braille, Tamil, Tifinagh, Nko, Thaana, Tibetan, Ogham, Bopomofo, Malayalam \| [Read more…](pixa/)

---


### GG Plum

[![CLARITY CĞBJÌĂ flight ẅoîẁĳœ effvgý](images/plum-var.svg)](plum-var/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/cc0/plum/plum-var.vfj){: .btn target="_blank" }

license: CC-0 \| Humanist sanserif font family with a weight axis \| glyphs: 205 \| scripts: Latin \| [Read more…](plum-var/)

---


### GG Ptit OFL

[![SCRIPT fluids write ķniṟɱ îʑᴽțṵž](images/ptit.svg)](ptit/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/ofl/ptit/ptit.vfj){: .btn target="_blank" }

license: OFL \| Multi-script handwritten font that uses single stroke \| glyphs: 4760 \| scripts: Latin, Greek, Cyrillic, Katakana, Cherokee \| [Read more…](ptit/)

---


### GG Rafi OFL Italic

[![LIBRE ŽĿŮŸ interface đkūăbņ](images/rafi-italic-var.svg)](rafi-italic-var/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/ofl/rafi/rafi-italic-var.vfj){: .btn target="_blank" }

license: OFL \| Legible sanserif for UIs and signage with a weight axis, italic version \| glyphs: 854 \| scripts: Latin, Greek \| [Read more…](rafi-italic-var/)

---


### GG Rafi OFL

[![ÓSITEV TÛĒRGD speaker âdłamÿ ðèŉzæy](images/rafi-var.svg)](rafi-var/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/ofl/rafi/rafi-var.vfj){: .btn target="_blank" }

license: OFL \| Legible sanserif for UIs and signage with a weight axis, italic version \| glyphs: 855 \| scripts: Latin, Greek \| [Read more…](rafi-var/)

---


### GG Scig OFL Regular

[![HELLO ĠRŦȂǺẄ square ǫpøåĝð ąậaģbw](images/scig-var.svg)](scig-var/)

[Download FontLab VFJ](https://minhaskamal.github.io/DownGit/#/home?url=https://github.com/fontlabcom/getgo-fonts/blob/main/getgo-fonts/ofl/scig/scig-var.vfj){: .btn target="_blank" }

license: OFL \| Rectangular sanserif design with weight, width, slant and contrast axes \| glyphs: 1218 \| scripts: Latin, Cyrillic \| [Read more…](scig-var/)

---


### GG Star

[![QUEST СЪРГУЮ imagine зфоляч ицщиач](images/star.svg)](star/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/cc0/star/star.vfj){: .btn target="_blank" }

license: CC-0 \| Narrow retro sci-fi display font \| glyphs: 144 \| scripts: Cyrillic, Latin \| [Read more…](star/)

---


### GG Stroke Chan OFL Italic

[![TLVUBG YKMMIP txnckj qixarh zpyegj](images/stroke-chan.svg)](stroke-chan/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/ofl/stroke-chan/stroke-chan.vfj){: .btn target="_blank" }

license: OFL \| Single-stroke italic design in chancery style, for use with Power Brush or Stroke \| glyphs: 106 \| scripts: Latin \| [Read more…](stroke-chan/)

---


### GG Stroke Grot OFL

[![PJVNNX TQFBHI wuufªk ldmzea prxhºy](images/stroke-grot.svg)](stroke-grot/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/ofl/stroke-grot/stroke-grot.vfj){: .btn target="_blank" }

license: OFL \| Single-stroke grotesque sanserif design, for use with Power Brush or Stroke \| glyphs: 132 \| scripts: Latin \| [Read more…](stroke-grot/)

---


### GG Veni

[![VESTIRO ÂÌDÓŸM quantas ùämõœl elegant](images/veni.svg)](veni/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/cc0/veni/veni.vfj){: .btn target="_blank" }

license: CC-0 \| Renaissance serif font \| glyphs: 199 \| scripts: Latin \| [Read more…](veni/)

---


### GG Vize

[![CAPITAL QUEST fashion cuisine elegant](images/vize.svg)](vize/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/cc0/vize/vize.vfj){: .btn target="_blank" }

license: CC-0 \| Renaissance humanist sanserif font \| glyphs: 103 \| scripts: Latin \| [Read more…](vize/)

---


### Zoto Emoji

[![🎡💄🀄🈴😱🐞 🇰🈚👺🍉2🍃 🔨🐣👠🌟🎯✈ 🍪😁 🎈🍸🌼 🍷📧🐔󾓩🏄👶](images/zoto-emoji.svg)](zoto-emoji/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotoemoji/zoto-emoji.vfj){: .btn target="_blank" }

license: Apache \| Reference font for Emoji symbols \| glyphs: 771 \| scripts:  \| [Read more…](zoto-emoji/)

---


### Zoto Kufi Arabic

[![ﻹݬݣڙﺯﭘ ﹾﺂښێﹲۯ ۮڦﭖﺤﮌظ ڰګﺊذﮭڢ ۉﺠحﭧﭭﭽ](images/zoto-kufiarabic.svg)](zoto-kufiarabic/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zoto-kufiarabic.vfj){: .btn target="_blank" }

license: Apache \| Reference font for the Arabic script in the Kufi style \| glyphs: 762 \| scripts: Arabic \| [Read more…](zoto-kufiarabic/)

---


### Zoto Sans Armenian

[![ԼՃԻԶԹՆ ՑԻՖՐՂՌ ւզթսգղ ժյﬔվմն փկդխկց](images/zotosans-armenian.svg)](zotosans-armenian/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-armenian.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Armenian script \| glyphs: 98 \| scripts: Armenian \| [Read more…](zotosans-armenian/)

---


### Zoto Sans Avestan

[![𐬑𐬂𐬜𐬴𐬢𐬄 𐬖𐬁𐬱𐬭𐬆𐬍 𐬛𐬔𐬡𐬫𐬗𐬵 𐬒𐬦𐬥𐬬𐬊𐬲 𐬘𐬣𐬰𐬏𐬅𐬨](images/zotosans-avestan.svg)](zotosans-avestan/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-avestan.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Avestan script \| glyphs: 73 \| scripts: Avestan \| [Read more…](zotosans-avestan/)

---


### Zoto Sans Balinese

[![ᬰᬋᬘᬎᬓᬮ ᭊᬉᬥᬫᬌᬯ ᬪᬠᬲᭋᭅᬡ ᬑᬊᬭᬒᬨᬅ ᬧᬇᬗᬍᬩᭆ](images/zotosans-balinese.svg)](zotosans-balinese/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-balinese.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Balinese script \| glyphs: 182 \| scripts: Balinese \| [Read more…](zotosans-balinese/)

---


### Zoto Sans Bamum

[![𖦺ꚯꛀꛂ𖡖𖠟 𖢇𖧶𖤣𖡎𖢯𖧷 𖦢𖣙ꛚ𖥌ꚴ𖢏 𖣮𖨅𖦿𖧀𖥵𖢱 𖠓ꛆ𖢴ꛎ𖣯𖦊](images/zotosans-bamum.svg)](zotosans-bamum/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-bamum.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Bamum script \| glyphs: 661 \| scripts: Bamum \| [Read more…](zotosans-bamum/)

---


### Zoto Sans Batak

[![ᯓᯇᯆᯂᯠᯑ ᯗᯍᯝᯣᯖᯛ ᯅᯈᯎᯡᯃᯜ ᯀᯊᯄᯘᯤᯙ ᯔᯉᯥᯚᯁᯏ](images/zotosans-batak.svg)](zotosans-batak/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-batak.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Batak script \| glyphs: 61 \| scripts: Batak \| [Read more…](zotosans-batak/)

---


### Zoto Sans Brahmi

[![𑀤𑀭𑀬𑀥𑀰𑀉 𑀐𑀨𑀘𑀟𑀫𑀕 𑀗𑀓𑀷𑀣𑀲𑀳 𑀃𑀎𑀒𑀍𑀌𑀦 𑀡𑀋𑀚𑀑𑀊𑀇](images/zotosans-brahmi.svg)](zotosans-brahmi/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-brahmi.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Brahmi script \| glyphs: 182 \| scripts: Brahmi \| [Read more…](zotosans-brahmi/)

---


### Zoto Sans Buginese

[![ᨐᨁᨖᨆᨋᨍ ᨕᨇᨑᨂᨌᨏ ᨃᨉᨓᨈᨒᨅ ᨎᨀᨊᨄᨔ](images/zotosans-buginese.svg)](zotosans-buginese/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-buginese.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Buginese script \| glyphs: 63 \| scripts: Buginese \| [Read more…](zotosans-buginese/)

---


### Zoto Sans Buhid

[![ᝌᝃᝑᝏᝊᝄ ᝎᝍᝇᝀᝂᝉ ᝆᝈᝋᝅᝐᝁ](images/zotosans-buhid.svg)](zotosans-buhid/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-buhid.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Buhid script \| glyphs: 39 \| scripts: Buhid \| [Read more…](zotosans-buhid/)

---


### Zoto Sans Canadian Aboriginal

[![ᓿᒩᗰᒺᓙᘈ ᐳᗛᙸᔣᗊᐴ ᐨᕸᕂᒮᘂᔴ ᗝᒝᗿᘗᐧᖵ ᖀᖴᗄᐸᒌᑾ](images/zotosans-canadianaboriginal.svg)](zotosans-canadianaboriginal/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-canadianaboriginal.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Canadian Aboriginal syllabics \| glyphs: 744 \| scripts: Canadian Aboriginal, Latin \| [Read more…](zotosans-canadianaboriginal/)

---


### Zoto Sans Carian

[![𐊨𐋁𐊭𐊦𐊳𐊤 𐊱𐋋𐋅𐋎𐋂𐊿 𐋏𐊾𐊢𐊵𐋆𐊠 𐋇𐊡𐊽𐋃𐊣𐊹 𐊬𐊸𐊫𐊷𐊩𐊻](images/zotosans-carian.svg)](zotosans-carian/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-carian.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Carian script \| glyphs: 53 \| scripts: Carian \| [Read more…](zotosans-carian/)

---


### Zoto Sans Cham

[![ꨌꨝꨨꨘꩈꨢ ꨑꨤꨙꩀꨡꩇ ꨕꨅꨠꨍꨦꨒ ꨋꨏꩄꨃꨈꩆ ꨐꨚꨎꨁꨖꨆ](images/zotosans-cham.svg)](zotosans-cham/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-cham.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Cham script \| glyphs: 127 \| scripts: Cham \| [Read more…](zotosans-cham/)

---


### Zoto Sans Cherokee

[![ᏓᎲᎮᎻᏛᏱ ᏌᎼᎳᏦᏊᎹ ᎸᏐᏒᏭᏧᏂ ᎿᏏᎠᎣᏚᎷ ᏤᏰᎶᏬᏔᎨ](images/zotosans-cherokee.svg)](zotosans-cherokee/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-cherokee.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Cherokee script \| glyphs: 89 \| scripts: Cherokee \| [Read more…](zotosans-cherokee/)

---


### Zoto Sans Coptic

[![ⲰⲮⲄⳜⲜⳄ ⲦⲤⲢϮⲶⳠ ⲽⲫⲭⳗⲿⳳ ⲃⳇⲃⲏⳃⳗ ϫⳁⲅⲽⲉⲩ](images/zotosans-coptic.svg)](zotosans-coptic/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-coptic.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Coptic script \| glyphs: 190 \| scripts: Coptic, Latin \| [Read more…](zotosans-coptic/)

---


### Zoto Sans Cuneiform

[![𒆀𒀵𒈏𒁼𒃠𒂚 𒁱𒄊𒋍𒃈𒅊𒈤 𒆿𒌓𒌥𒌭𒋗𒄵 𒀴𒋬𒅤𒁋𒀕𒍃 𒈿𒅸𒈙𒋊𒄸𒊻](images/zotosans-cuneiform.svg)](zotosans-cuneiform/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-cuneiform.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Cuneiform script \| glyphs: 986 \| scripts: Cuneiform \| [Read more…](zotosans-cuneiform/)

---


### Zoto Sans Cypriot

[![𐠼𐠐𐠣𐠅𐠎𐠱 𐠩𐠍𐠪𐠢𐠦𐠮 𐠤𐠬𐠲𐠌𐠔𐠰 𐠕𐠞𐠡𐠝𐠖𐠊 𐠒𐠠𐠀𐠨𐠭𐠟](images/zotosans-cypriot.svg)](zotosans-cypriot/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-cypriot.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Cypriot script \| glyphs: 59 \| scripts: Cypriot \| [Read more…](zotosans-cypriot/)

---


### Zoto Sans Deseret

[![𐐈𐐔𐐟𐐚𐐢𐐌 𐐜𐐀𐐒𐐖𐐈𐐇 𐐹𐐷𐐮𐑅𐐫𐐵 𐐬𐐩𐐵𐐾𐑌𐐯 𐑏𐐸𐐬𐐽𐐱𐑏](images/zotosans-deseret.svg)](zotosans-deseret/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-deseret.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Deseret script \| glyphs: 84 \| scripts: Deseret \| [Read more…](zotosans-deseret/)

---


### Zoto Sans Egyptian Hieroglyphs

[![𓁫𓋾𓅷𓆢𓋁𓁗 𓇶𓈓𓋉𓄌𓅞𓈥 𓍪𓅵𓂥𓎮𓎇𓅺 𓋘𓐦𓀮𓅶𓎐𓍼 𓈭𓍙𓐣𓐘𓁳𓅅](images/zotosans-egyptianhieroglyphs.svg)](zotosans-egyptianhieroglyphs/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-egyptianhieroglyphs.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Egyptian Hieroglyphs script \| glyphs: 1075 \| scripts: Egyptian Hieroglyphs \| [Read more…](zotosans-egyptianhieroglyphs/)

---


### Zoto Sans Ethiopic

[![ⷞⶌኻዝጼዬ ዑቿⷀጴሠሂ ᎍቊዃቾዔሃ ፑጆⷙቶⶉⶳ ጜየቀꬥጽቱ](images/zotosans-ethiopic.svg)](zotosans-ethiopic/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-ethiopic.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Ethiopic script \| glyphs: 559 \| scripts: Ethiopic \| [Read more…](zotosans-ethiopic/)

---


### Zoto Sans Georgian

[![ႣჀႽჂ ႭႸႺႱ ⴇზⴂⴄჺⴊ ⴊფაⴥⴡⴌ ⴤჟღⴄსⴇ](images/zotosans-georgian.svg)](zotosans-georgian/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-georgian.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Georgian script \| glyphs: 127 \| scripts: Georgian, Armenian \| [Read more…](zotosans-georgian/)

---


### Zoto Sans Glagolitic

[![ⰋⰤⰗⰁⰇⰏ ⰆⰥⰃⰒⰛⰍ ⰵⱍⰴⱑⰰⱎ ⱐⱏⱀⱗⱚⱑ ⰺⰽⱆⱊⱇⱌ](images/zotosans-glagolitic.svg)](zotosans-glagolitic/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-glagolitic.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Glagolitic script \| glyphs: 98 \| scripts: Glagolitic \| [Read more…](zotosans-glagolitic/)

---


### Zoto Sans Gothic

[![𐍉𐍆𐌱𐌿𐍀𐌾 𐌹𐌶𐍃𐌼𐍈𐍇 𐍂𐌷𐌳𐍄𐌰𐌲 𐌺𐌸𐍅𐌵𐌽𐌻 𐌴](images/zotosans-gothic.svg)](zotosans-gothic/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-gothic.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Gothic script \| glyphs: 43 \| scripts: Gothic \| [Read more…](zotosans-gothic/)

---


### Zoto Sans Gurmukhi

[![ਔਅਗ਼ਘਇਪ ਣੴਆਙਜਥ ਯਡਫ਼ਖ਼ਹਦ ਨਲ਼ਈਞਲਛ ਬਏਕੲਗਭ](images/zotosans-gurmukhi.svg)](zotosans-gurmukhi/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-gurmukhi.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Gurmukhi script \| glyphs: 301 \| scripts: Gurmukhi \| [Read more…](zotosans-gurmukhi/)

---


### Zoto Sans Hanunoo

[![ᜣᜢᜬᜮᜡᜥ ᜦᜩᜱᜫᜤᜰ ᜠᜪᜨᜧᜯᜭ](images/zotosans-hanunoo.svg)](zotosans-hanunoo/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-hanunoo.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Hanunoo script \| glyphs: 43 \| scripts: Hanunoo \| [Read more…](zotosans-hanunoo/)

---


### Zoto Sans Hebrew

[![ןפרטּזּשׂ לּאָקמּיּשּׂ זףתעהּךּ אﬠךהװתּ כּײַﭏﬦוּבֿ](images/zotosans-hebrew.svg)](zotosans-hebrew/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-hebrew.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Hebrew script \| glyphs: 155 \| scripts: Hebrew \| [Read more…](zotosans-hebrew/)

---


### Zoto Sans Historic

[![ࠀࠁࡀࡁꡀ ꡁ𐀀𐀁𐊀𐊁 𐎀𐎁𐎠𐎡𐒀 𐒁𐡀𐡁𐤀𐤁 𐤠𐤡𐩠𐩡𐬀 𐬁𐭀𐭁𐭠𐭡𐰀𐰁𒀀𒀁𓀀𓀁](images/zotosans-historic.svg)](zotosans-historic/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-historic.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for several historic scripts \| glyphs: 3638 \| scripts: Egyptian Hieroglyphs, Cuneiform, Linear B, Latin, Old Turkic, Samaritan, Avestan, Phags Pa, Carian, Old Persian, Ugaritic, Osmanya, Old South Arabian, Mandaic, Lycian, Lydian, Imperial Aramaic, Phoenician, Inscriptional Parthian, Inscriptional Pahlavi \| [Read more…](zotosans-historic/)

---


### Zoto Sans Imperial Aramaic

[![𐡑𐡀𐡈𐡉𐡄𐡁 𐡕𐡇𐡋𐡍𐡔𐡓 𐡆𐡎𐡅𐡏𐡒𐡂 𐡌𐡊𐡐𐡃](images/zotosans-imperialaramaic.svg)](zotosans-imperialaramaic/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-imperialaramaic.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Imperial Aramaic script \| glyphs: 35 \| scripts: Imperial Aramaic \| [Read more…](zotosans-imperialaramaic/)

---


### Zoto Sans Inscriptional Pahlavi

[![𐭰𐭠𐭫𐭨𐭬𐭩 𐭢𐭧𐭯𐭦𐭣𐭤 𐭡𐭱𐭪𐭲𐭭𐭮 𐭥](images/zotosans-inscriptionalpahlavi.svg)](zotosans-inscriptionalpahlavi/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-inscriptionalpahlavi.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Inscriptional Pahlavi script \| glyphs: 34 \| scripts: Inscriptional Pahlavi \| [Read more…](zotosans-inscriptionalpahlavi/)

---


### Zoto Sans Inscriptional Parthian

[![𐭊𐭕𐭈𐭃𐭔𐭍 𐭏𐭋𐭆𐭁𐭐𐭂 𐭀𐭄𐭒𐭌𐭎𐭅 𐭓𐭇𐭉𐭑](images/zotosans-inscriptionalparthian.svg)](zotosans-inscriptionalparthian/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-inscriptionalparthian.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Inscriptional Parthian script \| glyphs: 45 \| scripts: Inscriptional Parthian \| [Read more…](zotosans-inscriptionalparthian/)

---


### Zoto Sans Javanese

[![ꦅꦲꦈꦠꦞꦕ ꦪꦉꦚꦜꦣꦯ ꦧꦋꦇꦙꦥꦛ ꦆꦦꦡꦔꦫꦭ ꦩꦬꦖꦏꦝꦢ](images/zotosans-javanese.svg)](zotosans-javanese/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-javanese.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Javanese script \| glyphs: 155 \| scripts: Javanese \| [Read more…](zotosans-javanese/)

---


### Zoto Sans Kayah Li

[![ꤢꤜꤊꤍꤠꤝ ꤒꤥꤟꤖꤐꤛ ꤋꤡꤌꤑꤞꤔ ꤚꤙꤎꤕꤏꤤ ꤘꤣꤓꤗ](images/zotosans-kayahli.svg)](zotosans-kayahli/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-kayahli.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Kayah Li script \| glyphs: 54 \| scripts: Kayah Li \| [Read more…](zotosans-kayahli/)

---


### Zoto Sans Kharoshthi

[![𐨙𐨥𐨣𐨦𐨮𐨤 𐨀𐨬𐨐𐨞𐨖𐨠 𐨡𐨟𐨳𐨛𐨰𐨲 𐨯𐨜𐨭𐨒𐨫𐨱 𐨨𐨗𐨢𐨑𐨪𐨧](images/zotosans-kharoshthi.svg)](zotosans-kharoshthi/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-kharoshthi.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Kharoshthi script \| glyphs: 133 \| scripts: Kharoshthi \| [Read more…](zotosans-kharoshthi/)

---


### Zoto Sans Khmer

[![យខឍឡឣឳ ឱផងទណឥ ឃពកឨឰគ ឮៗជសឲឫ ឌលថឋឧឝ](images/zotosans-khmer.svg)](zotosans-khmer/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-khmer.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Khmer script \| glyphs: 265 \| scripts: Khmer \| [Read more…](zotosans-khmer/)

---


### Zoto Sans Lao

[![ບໃຜລາອ ຫຽຟະຂຄ ຍຣມຳສຈ ໟໆເປຕໝ ພຢງທໜກ](images/zotosans-lao.svg)](zotosans-lao/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-lao.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Lao script \| glyphs: 166 \| scripts: Lao \| [Read more…](zotosans-lao/)

---


### Zoto Sans Limbu

[![ᤌᤖᤓᤁᤕᤃ ᤐᤒᤚᤏᤛᤗ ᤑᤈᤎᤄᤅᤀ ᤜᤍᤆᤂᤔᤘ ᤊᤇᤋᤙᤉ](images/zotosans-limbu.svg)](zotosans-limbu/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-limbu.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Limbu script \| glyphs: 73 \| scripts: Limbu \| [Read more…](zotosans-limbu/)

---


### Zoto Sans Linear B

[![𐁃𐃁𐂬𐂼𐂗𐀫 𐀔𐃀𐂌𐂹𐁉𐂳 𐀺𐃍𐃑𐀁𐂘𐃰 𐀦𐃪𐁍𐁆𐁐𐂵 𐂢𐃵𐃣𐃃𐂨𐂫](images/zotosans-linearb.svg)](zotosans-linearb/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-linearb.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Linear B script \| glyphs: 272 \| scripts: Linear B \| [Read more…](zotosans-linearb/)

---


### Zoto Sans Lisu

[![ꓞꓣꓓꓩꓑꓶ ꓵꓛꓦꓤꓺꓰ ꓲꓹꓢꓳꓽꓫ ꓱꓐꓝꓚꓒꓧ ꓡꓼꓗꓠꓭꓴ](images/zotosans-lisu.svg)](zotosans-lisu/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-lisu.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Lisu script \| glyphs: 54 \| scripts: Lisu \| [Read more…](zotosans-lisu/)

---


### Zoto Sans Lycian

[![𐊜𐊀𐊖𐊙𐊋𐊊 𐊂𐊐𐊛𐊓𐊆𐊑 𐊔𐊗𐊄𐊍𐊘𐊃 𐊕𐊌𐊒𐊉𐊁𐊚 𐊈𐊅𐊎𐊏𐊇](images/zotosans-lycian.svg)](zotosans-lycian/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-lycian.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Lycian script \| glyphs: 33 \| scripts: Lycian \| [Read more…](zotosans-lycian/)

---


### Zoto Sans Lydian

[![𐤡𐤠𐤶𐤰𐤫𐤥 𐤣𐤮𐤸𐤬𐤲𐤯 𐤤𐤦𐤪𐤢𐤷𐤴 𐤩𐤧𐤨𐤹𐤱𐤭 𐤵𐤳](images/zotosans-lydian.svg)](zotosans-lydian/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-lydian.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Lydian script \| glyphs: 31 \| scripts: Lydian \| [Read more…](zotosans-lydian/)

---


### Zoto Sans Mandaic

[![ࡗࡆࡌࡒࡁࡇ ࡊࡉࡋࡎࡖࡈ ࡏࡔࡍࡂࡄࡑ ࡓࡀࡅࡐࡃࡘ ࡕ](images/zotosans-mandaic.svg)](zotosans-mandaic/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-mandaic.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Mandaic script \| glyphs: 128 \| scripts: Mandaic \| [Read more…](zotosans-mandaic/)

---


### Zoto Sans Meetei Mayek

[![ꫢꯐꫧꯝꯂꫡ ꯒꫠꯇꯙꯎꯋ ꯡꯍꫲꯈꫦꯏ ꯔꯕꫩꯜꯛꯖ ꯅꫥꯠꯢꯄꯗ](images/zotosans-meeteimayek.svg)](zotosans-meeteimayek/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-meeteimayek.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Meetei Mayek script \| glyphs: 91 \| scripts: Meetei Mayek \| [Read more…](zotosans-meeteimayek/)

---


### Zoto Sans Mongolian

[![ᡙᡇᠷᡬᢃᠠ ᢖᠱᠽᠩᡞᡏ ᢢᠬᢙᡮᠫᠥ ᠼᢨᠾᠰᢎᡲ ᢉᢛᢝᢋᠮᡓ](images/zotosans-mongolian.svg)](zotosans-mongolian/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-mongolian.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Mongolian script \| glyphs: 1511 \| scripts: Mongolian \| [Read more…](zotosans-mongolian/)

---


### Zoto Sans New Tai Lue

[![ᦝᧀᧄᦈᦒᦕ ᧂᦁᧃᦱᦆᧉ ᦙᦗᦉᦵᦡᦇ ᦄᦞᦰᦴᦪᦎ ᧅᦑᦸᦌᦏᦘ](images/zotosans-newtailue.svg)](zotosans-newtailue/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-newtailue.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the New Tai Lue script \| glyphs: 91 \| scripts: New Tai Lue \| [Read more…](zotosans-newtailue/)

---


### Zoto Sans NKo

[![ߓߪߣߍߑߞ ߕߛߧߘߖߤ ߟߏߵߨߒߠ ߢߎߥߡߴߝ ߔߩߌߙߊߦ](images/zotosans-nko.svg)](zotosans-nko/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-nko.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Nko script \| glyphs: 174 \| scripts: Nko, Arabic \| [Read more…](zotosans-nko/)

---


### Zoto Sans Ogham

[![ᚔᚚᚍᚋᚈᚐ ᚉᚏᚕᚅᚆᚂ ᚖᚑᚎᚗᚘᚊ ᚁᚇᚓᚄᚌᚒ ᚙᚃ](images/zotosans-ogham.svg)](zotosans-ogham/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-ogham.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Ogham script \| glyphs: 33 \| scripts: Ogham \| [Read more…](zotosans-ogham/)

---


### Zoto Sans Ol Chiki

[![ᱦᱫᱳᱰᱽᱜ ᱮᱧᱢᱝᱛᱶ ᱡᱯᱞᱹᱴᱣ ᱥᱱᱵᱷᱠᱭ ᱸᱬᱺᱲᱤᱪ](images/zotosans-olchiki.svg)](zotosans-olchiki/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-olchiki.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Ol Chiki script \| glyphs: 52 \| scripts: Ol Chiki \| [Read more…](zotosans-olchiki/)

---


### Zoto Sans Old Italic

[![𐌏𐌉𐌆𐌊𐌙𐌜 𐌇𐌞𐌕𐌎𐌀𐌚 𐌃𐌁𐌓𐌅𐌋𐌔 𐌘𐌌𐌛𐌖𐌍𐌈 𐌄𐌝𐌐𐌂𐌗𐌑](images/zotosans-olditalic.svg)](zotosans-olditalic/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-olditalic.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Old Italic script \| glyphs: 39 \| scripts: Old Italic \| [Read more…](zotosans-olditalic/)

---


### Zoto Sans Old Persian

[![𐎣𐏈𐎽𐎸𐎢𐎻 𐎷𐏊𐎳𐎱𐎵𐎩 𐎨𐏌𐎶𐎬𐎰𐏋 𐎾𐎠𐏀𐎺𐎿𐎦 𐏍𐏉𐎡𐎴𐎼𐎹](images/zotosans-oldpersian.svg)](zotosans-oldpersian/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-oldpersian.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Old Persian script \| glyphs: 54 \| scripts: Old Persian \| [Read more…](zotosans-oldpersian/)

---


### Zoto Sans Old South Arabian

[![𐩧𐩣𐩳𐩡𐩺𐩻 𐩷𐩰𐩫𐩸𐩶𐩮 𐩴𐩱𐩥𐩢𐩭𐩵 𐩪𐩬𐩨𐩩𐩼𐩦 𐩹𐩯𐩠𐩲𐩤](images/zotosans-oldsoutharabian.svg)](zotosans-oldsoutharabian/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-oldsoutharabian.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Old South Arabian script \| glyphs: 36 \| scripts: Old South Arabian \| [Read more…](zotosans-oldsoutharabian/)

---


### Zoto Sans Old Turkic

[![𐰥𐱁𐰶𐰢𐰯𐰐 𐰋𐰪𐰚𐰈𐰛𐰗 𐰳𐰝𐰖𐰊𐱆𐰽 𐰬𐰺𐰨𐰘𐰟𐰦 𐱅𐰼𐰁𐰹𐰙𐱀](images/zotosans-oldturkic.svg)](zotosans-oldturkic/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-oldturkic.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Old Turkic script \| glyphs: 77 \| scripts: Old Turkic \| [Read more…](zotosans-oldturkic/)

---


### Zoto Sans Osmanya

[![𐒌𐒆𐒓𐒈𐒊𐒚 𐒒𐒉𐒙𐒀𐒑𐒘 𐒖𐒅𐒃𐒄𐒕𐒝 𐒇𐒍𐒏𐒋𐒗𐒜 𐒛𐒐𐒔𐒁𐒂𐒎](images/zotosans-osmanya.svg)](zotosans-osmanya/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-osmanya.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Osmanya script \| glyphs: 44 \| scripts: Osmanya \| [Read more…](zotosans-osmanya/)

---


### Zoto Sans Phags Pa

[![ꡜꡤꡩꡕꡏꡂ ꡐꡗꡡꡯꡭꡓ ꡖꡘꡑꡉꡧꡟ ꡇꡁꡰꡄꡲꡥ ꡀꡆꡌꡙꡪꡠ](images/zotosans-phagspa.svg)](zotosans-phagspa/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-phagspa.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Phags-pa script \| glyphs: 382 \| scripts: Phags Pa, Mongolian \| [Read more…](zotosans-phagspa/)

---


### Zoto Sans Phoenician

[![𐤏𐤋𐤕𐤑𐤐𐤆 𐤉𐤔𐤍𐤅𐤒𐤄 𐤂𐤇𐤃𐤓𐤀𐤈 𐤁𐤊𐤎𐤌](images/zotosans-phoenician.svg)](zotosans-phoenician/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-phoenician.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Phoenician script \| glyphs: 33 \| scripts: Phoenician \| [Read more…](zotosans-phoenician/)

---


### Zoto Sans Rejang

[![ꤶꥀꤱꤺꤻꤵ ꤳꥂꥁꤴꥃꤸ ꤼꥄꥅꤾꤹꤿ ꤽꤲꤰꥆꤷ](images/zotosans-rejang.svg)](zotosans-rejang/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-rejang.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Rejang script \| glyphs: 41 \| scripts: Rejang \| [Read more…](zotosans-rejang/)

---


### Zoto Sans Runic

[![ᛗᛠᛌᚴᚠᛊ ᛢᛍᛅᛐᚵᛦ ᚪᛡᚽᛣᚲᛉ ᛤᚥᛖᚢᛘᚧ ᛥᚾᛔᛏᚿᚷ](images/zotosans-runic.svg)](zotosans-runic/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-runic.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Runic script \| glyphs: 85 \| scripts: Runic \| [Read more…](zotosans-runic/)

---


### Zoto Sans Samaritan

[![ࠎࠑࠃࠔࠕࠁ ࠚࠇࠐࠤࠆࠓ ࠄࠌࠍࠅࠋࠂ ࠏࠈࠉࠒࠨࠀ ࠊ](images/zotosans-samaritan.svg)](zotosans-samaritan/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-samaritan.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Samaritan script \| glyphs: 67 \| scripts: Samaritan \| [Read more…](zotosans-samaritan/)

---


### Zoto Sans Saurashtra

[![ꢘꢉꢓꢛꢤꢔ ꢧꢰꢕꢋꢙꢩ ꢮꢬꢊꢑꢡꢨ ꢃꢂꢫꢖꢞꢣ ꢲꢦꢯꢌꢠꢱ](images/zotosans-saurashtra.svg)](zotosans-saurashtra/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-saurashtra.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Saurasthra script \| glyphs: 93 \| scripts: Saurashtra \| [Read more…](zotosans-saurashtra/)

---


### Zoto Sans Shavian

[![𐑙𐑷𐑺𐑚𐑶𐑲 𐑳𐑴𐑮𐑤𐑜𐑬 𐑟𐑞𐑥𐑼𐑣𐑭 𐑔𐑵𐑰𐑸𐑻𐑖 𐑢𐑹𐑾𐑿𐑗𐑑](images/zotosans-shavian.svg)](zotosans-shavian/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-shavian.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Shavian script \| glyphs: 52 \| scripts: Shavian \| [Read more…](zotosans-shavian/)

---


### Zoto Sans Sundanese

[![ᮙᮍᮮᮜᮠᮗ ᮅᮞᮚᮒᮑᮯ ᮌᮻᮘᮛᮃᮽ ᮇᮟᮎᮕᮏᮊ ᮓᮺᮝᮄᮆᮋ](images/zotosans-sundanese.svg)](zotosans-sundanese/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-sundanese.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Sundanese script \| glyphs: 79 \| scripts: Sundanese \| [Read more…](zotosans-sundanese/)

---


### Zoto Sans Syloti Nagri

[![ꠅꠏꠙꠒꠍꠡ ꠠꠑꠢꠘꠉꠇ ꠔꠚꠓꠐꠈꠕ ꠖꠌꠀꠁꠊꠎ ꠛꠄꠃꠝꠗꠟ](images/zotosans-sylotinagri.svg)](zotosans-sylotinagri/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-sylotinagri.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Syloti Nagri script \| glyphs: 85 \| scripts: Syloti Nagri \| [Read more…](zotosans-sylotinagri/)

---


### Zoto Sans Symbols

[![⛈꜐➊𝐛ℐ𝛶 ⎶𝜷➇⠭𝈷⩛ 🁁𝒱⍹𝞝𝛍⓾ ⎠ℼ🂧⤖⦖⏕ ⍃𝛕⪃𝑬𝜀⥆](images/zotosans-symbols.svg)](zotosans-symbols/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-symbols.vfj){: .btn target="_blank" }

license: Apache \| Reference symbol font \| glyphs: 5126 \| scripts: Braille, Greek \| [Read more…](zotosans-symbols/)

---


### Zoto Sans Tagalog

[![ᜋᜐᜂᜊᜏᜈ ᜁᜃᜀᜑᜄᜇ ᜅᜎᜉᜌᜆ](images/zotosans-tagalog.svg)](zotosans-tagalog/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-tagalog.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Tagalog script \| glyphs: 26 \| scripts: Tagalog \| [Read more…](zotosans-tagalog/)

---


### Zoto Sans Tagbanwa

[![ᝰᝣᝯᝪᝨᝤ ᝦᝠᝡᝥᝢᝧ ᝫᝮᝬᝩ](images/zotosans-tagbanwa.svg)](zotosans-tagbanwa/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-tagbanwa.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Tagbanwa script \| glyphs: 24 \| scripts: Tagbanwa \| [Read more…](zotosans-tagbanwa/)

---


### Zoto Sans Tai Le

[![ᥑᥪᥗᥢᥤᥡ ᥘᥥᥱᥩᥝᥔ ᥜᥣᥟᥬᥲᥙ ᥒᥴᥠᥖᥭᥕ ᥞᥳᥫᥨᥧᥚ](images/zotosans-taile.svg)](zotosans-taile/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-taile.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Tai Le script \| glyphs: 55 \| scripts: Tai Le \| [Read more…](zotosans-taile/)

---


### Zoto Sans Tai Tham

[![ᨻᩈᨾᩁᨫᩓ ᨿᩃᩊᨯᩒᨹ ᨤᩏᨭᩀᨳᨢ ᨡᨧᨲᨺᨵᩌ ᨸᩎᨩᨶᩅᨨ](images/zotosans-taitham.svg)](zotosans-taitham/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-taitham.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Tai Tham script \| glyphs: 231 \| scripts: Tai Tham \| [Read more…](zotosans-taitham/)

---


### Zoto Sans Tai Viet

[![ꪕꪮꪃꪺꪄꪪ ꪅꪻꪍꪢꪠꪩ ꪔꪆꪶꪭꪯꪋ ꪇꪽꫛꪟꪛꫝ ꪒꪘꪚꪉꪌꪊ](images/zotosans-taiviet.svg)](zotosans-taiviet/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-taiviet.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Tai Viet script \| glyphs: 81 \| scripts: Tai Viet, Latin \| [Read more…](zotosans-taiviet/)

---


### Zoto Sans Tamil

[![ஶஹௐஈஞட ஓணஎஙளய தஊஔஉஆற மசஒநவஸ ஏஐகழஜஷ](images/zotosans-tamil.svg)](zotosans-tamil/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-tamil.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Tamil script \| glyphs: 215 \| scripts: Tamil \| [Read more…](zotosans-tamil/)

---


### Zoto Sans Thaana

[![ޘޢޚޝމޕ ލޱފވޔޖ ޣސބށޙޥ ޠޅޓޏޗޤ ކތހޛޡރ](images/zotosans-thaana.svg)](zotosans-thaana/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-thaana.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Thaana script \| glyphs: 95 \| scripts: Thaana, Arabic \| [Read more…](zotosans-thaana/)

---


### Zoto Sans Tifinagh

[![ⴲⵢⵑⴿⴺⵉ ⵆⵅⵤⵕⴸⵞ ⴼⴵⴻⵍⵃⵄ ⵈⵐⴳⵛⵌⵖ ⵣⴴⵧⵓⵏⴹ](images/zotosans-tifinagh.svg)](zotosans-tifinagh/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-tifinagh.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Tifinagh script \| glyphs: 101 \| scripts: Tifinagh \| [Read more…](zotosans-tifinagh/)

---


### Zoto Sans Ugaritic

[![𐎍𐎒𐎁𐎓𐎔𐎋 𐎄𐎌𐎅𐎛𐎆𐎑 𐎊𐎐𐎜𐎝𐎏𐎘 𐎉𐎈𐎚𐎃𐎖𐎗 𐎇𐎕𐎙𐎀𐎂𐎎](images/zotosans-ugaritic.svg)](zotosans-ugaritic/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-ugaritic.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Ugaritic script \| glyphs: 35 \| scripts: Ugaritic \| [Read more…](zotosans-ugaritic/)

---


### Zoto Sans Vai

[![ꗌꕥꗍꕟꔆꕭ ꖡꔈꗚꗝꔴꖒ ꗦꔚꖏꕣꔼꕀ ꔋꕷꖢꕽꕑꗛ ꔳꘁꗮꖱꗫꖫ](images/zotosans-vai.svg)](zotosans-vai/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-vai.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Vai script \| glyphs: 304 \| scripts: Vai \| [Read more…](zotosans-vai/)

---


### Zoto Sans Yi

[![ꋅꁪꁳꃬꂘꏦ ꅫꐕꌉꆂꉨꆌ ꆣꆋꋆꅐꆿꅠ ꎫꄇꅙꌤꋻꅱ ꉀꎲꇵꂭꋸꅝ](images/zotosans-yi.svg)](zotosans-yi/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotosans/zotosans-yi.vfj){: .btn target="_blank" }

license: Apache \| Reference sans font for the Yi script \| glyphs: 1251 \| scripts: Yi \| [Read more…](zotosans-yi/)

---


### Zoto Serif Armenian

[![ԽՉՒԿՂՅ ՏՂԸՄԵԻ էէզըքգ նբյթփպ թցզՙձծ](images/zotoserif-armenian.svg)](zotoserif-armenian/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotoserif/zotoserif-armenian.vfj){: .btn target="_blank" }

license: Apache \| Reference serif font for the Armenian script \| glyphs: 98 \| scripts: Armenian \| [Read more…](zotoserif-armenian/)

---


### Zoto Serif Georgian

[![ჁჼჅႧႶႴႲ ⴟშვⴌⴔⴠ ⴤⴆჰⴀⴈⴎ ⴟჶⴊⴚლგⴌ](images/zotoserif-georgian.svg)](zotoserif-georgian/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotoserif/zotoserif-georgian.vfj){: .btn target="_blank" }

license: Apache \| Reference serif font for the Georgian script \| glyphs: 127 \| scripts: Georgian, Armenian \| [Read more…](zotoserif-georgian/)

---


### Zoto Serif Khmer

[![ឲយរឦញណ ឫខឥហសឭ ឳគងបឌឍ ថឧឈៗនធ ឡឆឯជឬឞ](images/zotoserif-khmer.svg)](zotoserif-khmer/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotoserif/zotoserif-khmer.vfj){: .btn target="_blank" }

license: Apache \| Reference serif font for the Khmer script \| glyphs: 378 \| scripts: Khmer \| [Read more…](zotoserif-khmer/)

---


### Zoto Serif Lao

[![ໃຣຯສຕດ ຊຢມໝເຫ ໂນໄຝວແ ໞບຈພະລ ຟກໜຳຮໟ](images/zotoserif-lao.svg)](zotoserif-lao/)

[Download FontLab VFJ](https://cdn.jsdelivr.net/gh/fontlabcom/getgo-fonts/getgo-fonts/apache/zotoserif/zotoserif-lao.vfj){: .btn target="_blank" }

license: Apache \| Reference serif font for the Lao script \| glyphs: 166 \| scripts: Lao \| [Read more…](zotoserif-lao/)

---
