(self.webpackChunkvue3_quill_docs=self.webpackChunkvue3_quill_docs||[]).push([[509],{422:function(n,s,a){"use strict";a.r(s),a.d(s,{data:function(){return t}});const t={key:"v-8daa1a0e",path:"/",title:"Vue3-quill",lang:"en-US",frontmatter:{home:!0,title:"Vue3-quill",footer:"MIT Licensed | Copyright © 2021-present flyween"},excerpt:"",headers:[{level:2,title:"Get started",slug:"get-started",children:[]},{level:2,title:"Form Input Bindings: v-model",slug:"form-input-bindings-v-model",children:[]},{level:2,title:"Event binding",slug:"event-binding",children:[]},{level:2,title:"options prop",slug:"options-prop",children:[]}],filePathRelative:"README.md",git:{updatedTime:1617289362e3,contributors:[{name:"Li",email:"443708569@qq.com",commits:1}]}}},745:function(n,s,a){"use strict";a.r(s),a.d(s,{default:function(){return w}});var t=a(252),p=a(577);const e=(0,t.Wm)("p",null,[(0,t.Wm)("b",null,"Content:")],-1),o=(0,t.uE)('<hr><h2 id="get-started"><a class="header-anchor" href="#get-started">#</a> Get started</h2><div class="language-bash ext-sh line-numbers-mode"><pre class="language-bash"><code><span class="token function">npm</span> i vue3-quill\n<span class="token comment"># or</span>\n<span class="token function">yarn</span> <span class="token function">add</span> vue3-quill\n</code></pre><div class="line-numbers"><span class="line-number">1</span><br><span class="line-number">2</span><br><span class="line-number">3</span><br></div></div><p><strong>Global Registration:</strong></p><div class="language-javascript ext-js line-numbers-mode"><pre class="language-javascript"><code><span class="token keyword">import</span> <span class="token punctuation">{</span> quillEditor<span class="token punctuation">,</span> Quill <span class="token punctuation">}</span> <span class="token keyword">from</span> <span class="token string">&#39;vue3-quill&#39;</span>\n<span class="token keyword">import</span> customQuillModule <span class="token keyword">from</span> <span class="token string">&#39;customQuillModule&#39;</span>\nQuill<span class="token punctuation">.</span><span class="token function">register</span><span class="token punctuation">(</span><span class="token string">&#39;modules/customQuillModule&#39;</span><span class="token punctuation">,</span> customQuillModule<span class="token punctuation">)</span>\napp<span class="token punctuation">.</span><span class="token function">use</span><span class="token punctuation">(</span>quillEditor<span class="token punctuation">)</span>\n</code></pre><div class="line-numbers"><span class="line-number">1</span><br><span class="line-number">2</span><br><span class="line-number">3</span><br><span class="line-number">4</span><br></div></div><p><strong>or Local Registration:</strong></p><div class="language-vue ext-vue line-numbers-mode"><pre class="language-vue"><code><span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>script</span><span class="token punctuation">&gt;</span></span><span class="token script"><span class="token language-javascript">\n<span class="token keyword">import</span> <span class="token punctuation">{</span> quillEditor<span class="token punctuation">,</span> Quill <span class="token punctuation">}</span> <span class="token keyword">from</span> <span class="token string">&#39;vue3-quill&#39;</span>\n<span class="token keyword">import</span> customQuillModule <span class="token keyword">from</span> <span class="token string">&#39;customQuillModule&#39;</span>\nQuill<span class="token punctuation">.</span><span class="token function">register</span><span class="token punctuation">(</span><span class="token string">&#39;modules/customQuillModule&#39;</span><span class="token punctuation">,</span> customQuillModule<span class="token punctuation">)</span>\n\n<span class="token keyword">export</span> <span class="token keyword">default</span> <span class="token punctuation">{</span>\n  components<span class="token operator">:</span> <span class="token punctuation">{</span>\n    quillEditor\n  <span class="token punctuation">}</span>\n<span class="token punctuation">}</span>\n</span></span><span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>script</span><span class="token punctuation">&gt;</span></span>\n</code></pre><div class="line-numbers"><span class="line-number">1</span><br><span class="line-number">2</span><br><span class="line-number">3</span><br><span class="line-number">4</span><br><span class="line-number">5</span><br><span class="line-number">6</span><br><span class="line-number">7</span><br><span class="line-number">8</span><br><span class="line-number">9</span><br><span class="line-number">10</span><br><span class="line-number">11</span><br></div></div><p><strong>Example:</strong></p><div class="language-vue ext-vue line-numbers-mode"><pre class="language-vue"><code><span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>template</span><span class="token punctuation">&gt;</span></span>\n<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>component</span> <span class="token attr-name">v-if</span><span class="token attr-value"><span class="token punctuation attr-equals">=</span><span class="token punctuation">&quot;</span>dynamicComponent<span class="token punctuation">&quot;</span></span> <span class="token attr-name">:is</span><span class="token attr-value"><span class="token punctuation attr-equals">=</span><span class="token punctuation">&quot;</span>dynamicComponent<span class="token punctuation">&quot;</span></span><span class="token punctuation">&gt;</span></span><span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>component</span><span class="token punctuation">&gt;</span></span>\n  <span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>quill-editor</span>\n    <span class="token attr-name"><span class="token namespace">v-model:</span>value</span><span class="token attr-value"><span class="token punctuation attr-equals">=</span><span class="token punctuation">&quot;</span>state.content<span class="token punctuation">&quot;</span></span>\n    <span class="token attr-name">:options</span><span class="token attr-value"><span class="token punctuation attr-equals">=</span><span class="token punctuation">&quot;</span>state.editorOption<span class="token punctuation">&quot;</span></span>\n    <span class="token attr-name">:disabled</span><span class="token attr-value"><span class="token punctuation attr-equals">=</span><span class="token punctuation">&quot;</span>state.disabled<span class="token punctuation">&quot;</span></span>\n    <span class="token attr-name">@blur</span><span class="token attr-value"><span class="token punctuation attr-equals">=</span><span class="token punctuation">&quot;</span>onEditorBlur($event)<span class="token punctuation">&quot;</span></span>\n    <span class="token attr-name">@focus</span><span class="token attr-value"><span class="token punctuation attr-equals">=</span><span class="token punctuation">&quot;</span>onEditorFocus($event)<span class="token punctuation">&quot;</span></span>\n    <span class="token attr-name">@ready</span><span class="token attr-value"><span class="token punctuation attr-equals">=</span><span class="token punctuation">&quot;</span>onEditorReady($event)<span class="token punctuation">&quot;</span></span>\n    <span class="token attr-name">@change</span><span class="token attr-value"><span class="token punctuation attr-equals">=</span><span class="token punctuation">&quot;</span>onEditorChange($event)<span class="token punctuation">&quot;</span></span>\n  <span class="token punctuation">/&gt;</span></span>\n<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>template</span><span class="token punctuation">&gt;</span></span>\n\n<span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>script</span><span class="token punctuation">&gt;</span></span><span class="token script"><span class="token language-javascript">\n<span class="token keyword">import</span> <span class="token punctuation">{</span> reactive <span class="token punctuation">}</span> <span class="token keyword">from</span> <span class="token string">&#39;vue&#39;</span>\n<span class="token keyword">import</span> <span class="token punctuation">{</span> quillEditor <span class="token punctuation">}</span> <span class="token keyword">from</span> <span class="token string">&#39;vue3-quill&#39;</span>\n\n<span class="token keyword">export</span> <span class="token keyword">default</span> <span class="token punctuation">{</span>\n  name<span class="token operator">:</span> <span class="token string">&#39;App&#39;</span><span class="token punctuation">,</span>\n  components<span class="token operator">:</span> <span class="token punctuation">{</span>\n    quillEditor\n  <span class="token punctuation">}</span><span class="token punctuation">,</span>\n  <span class="token function">setup</span><span class="token punctuation">(</span><span class="token punctuation">)</span> <span class="token punctuation">{</span>\n    <span class="token keyword">const</span> state <span class="token operator">=</span> <span class="token function">reactive</span><span class="token punctuation">(</span><span class="token punctuation">{</span>\n      dynamicComponent<span class="token operator">:</span> <span class="token keyword">null</span><span class="token punctuation">,</span>\n      content<span class="token operator">:</span> <span class="token string">&#39;&lt;p&gt;2333&lt;/p&gt;&#39;</span><span class="token punctuation">,</span>\n      _content<span class="token operator">:</span> <span class="token string">&#39;&#39;</span><span class="token punctuation">,</span>\n      editorOption<span class="token operator">:</span> <span class="token punctuation">{</span>\n        placeholder<span class="token operator">:</span> <span class="token string">&#39;core&#39;</span><span class="token punctuation">,</span>\n        modules<span class="token operator">:</span> <span class="token punctuation">{</span>\n          toolbar<span class="token operator">:</span> <span class="token punctuation">[</span>\n            <span class="token comment">// custom toolbars options</span>\n            <span class="token comment">// will override the default configuration</span>\n          <span class="token punctuation">]</span><span class="token punctuation">,</span>\n          <span class="token comment">// other moudle options here</span>\n        <span class="token punctuation">}</span>\n        <span class="token comment">// more options</span>\n      <span class="token punctuation">}</span><span class="token punctuation">,</span>\n      disabled<span class="token operator">:</span> <span class="token boolean">false</span>\n    <span class="token punctuation">}</span><span class="token punctuation">)</span>\n\n    <span class="token keyword">const</span> <span class="token function-variable function">onEditorBlur</span> <span class="token operator">=</span> <span class="token parameter">quill</span> <span class="token operator">=&gt;</span> <span class="token punctuation">{</span>\n      console<span class="token punctuation">.</span><span class="token function">log</span><span class="token punctuation">(</span><span class="token string">&#39;editor blur!&#39;</span><span class="token punctuation">,</span> quill<span class="token punctuation">)</span>\n    <span class="token punctuation">}</span>\n    <span class="token keyword">const</span> <span class="token function-variable function">onEditorFocus</span> <span class="token operator">=</span> <span class="token parameter">quill</span> <span class="token operator">=&gt;</span> <span class="token punctuation">{</span>\n      console<span class="token punctuation">.</span><span class="token function">log</span><span class="token punctuation">(</span><span class="token string">&#39;editor focus!&#39;</span><span class="token punctuation">,</span> quill<span class="token punctuation">)</span>\n    <span class="token punctuation">}</span>\n    <span class="token keyword">const</span> <span class="token function-variable function">onEditorReady</span> <span class="token operator">=</span> <span class="token parameter">quill</span> <span class="token operator">=&gt;</span> <span class="token punctuation">{</span>\n      console<span class="token punctuation">.</span><span class="token function">log</span><span class="token punctuation">(</span><span class="token string">&#39;editor ready!&#39;</span><span class="token punctuation">,</span> quill<span class="token punctuation">)</span>\n    <span class="token punctuation">}</span>\n    <span class="token keyword">const</span> <span class="token function-variable function">onEditorChange</span> <span class="token operator">=</span> <span class="token punctuation">(</span><span class="token parameter"><span class="token punctuation">{</span> quill<span class="token punctuation">,</span> html<span class="token punctuation">,</span> text <span class="token punctuation">}</span></span><span class="token punctuation">)</span> <span class="token operator">=&gt;</span> <span class="token punctuation">{</span>\n      console<span class="token punctuation">.</span><span class="token function">log</span><span class="token punctuation">(</span><span class="token string">&#39;editor change!&#39;</span><span class="token punctuation">,</span> quill<span class="token punctuation">,</span> html<span class="token punctuation">,</span> text<span class="token punctuation">)</span>\n      state<span class="token punctuation">.</span>_content <span class="token operator">=</span> html\n    <span class="token punctuation">}</span>\n\n    <span class="token function">setTimeout</span><span class="token punctuation">(</span><span class="token punctuation">(</span><span class="token punctuation">)</span> <span class="token operator">=&gt;</span> <span class="token punctuation">{</span>\n      state<span class="token punctuation">.</span>disabled <span class="token operator">=</span> <span class="token boolean">true</span>\n    <span class="token punctuation">}</span><span class="token punctuation">,</span> <span class="token number">2000</span><span class="token punctuation">)</span>\n\n    <span class="token keyword">return</span> <span class="token punctuation">{</span> state<span class="token punctuation">,</span> onEditorBlur<span class="token punctuation">,</span> onEditorFocus<span class="token punctuation">,</span> onEditorReady<span class="token punctuation">,</span> onEditorChange <span class="token punctuation">}</span>\n  <span class="token punctuation">}</span>\n<span class="token punctuation">}</span>\n</span></span><span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>script</span><span class="token punctuation">&gt;</span></span>\n</code></pre><div class="line-numbers"><span class="line-number">1</span><br><span class="line-number">2</span><br><span class="line-number">3</span><br><span class="line-number">4</span><br><span class="line-number">5</span><br><span class="line-number">6</span><br><span class="line-number">7</span><br><span class="line-number">8</span><br><span class="line-number">9</span><br><span class="line-number">10</span><br><span class="line-number">11</span><br><span class="line-number">12</span><br><span class="line-number">13</span><br><span class="line-number">14</span><br><span class="line-number">15</span><br><span class="line-number">16</span><br><span class="line-number">17</span><br><span class="line-number">18</span><br><span class="line-number">19</span><br><span class="line-number">20</span><br><span class="line-number">21</span><br><span class="line-number">22</span><br><span class="line-number">23</span><br><span class="line-number">24</span><br><span class="line-number">25</span><br><span class="line-number">26</span><br><span class="line-number">27</span><br><span class="line-number">28</span><br><span class="line-number">29</span><br><span class="line-number">30</span><br><span class="line-number">31</span><br><span class="line-number">32</span><br><span class="line-number">33</span><br><span class="line-number">34</span><br><span class="line-number">35</span><br><span class="line-number">36</span><br><span class="line-number">37</span><br><span class="line-number">38</span><br><span class="line-number">39</span><br><span class="line-number">40</span><br><span class="line-number">41</span><br><span class="line-number">42</span><br><span class="line-number">43</span><br><span class="line-number">44</span><br><span class="line-number">45</span><br><span class="line-number">46</span><br><span class="line-number">47</span><br><span class="line-number">48</span><br><span class="line-number">49</span><br><span class="line-number">50</span><br><span class="line-number">51</span><br><span class="line-number">52</span><br><span class="line-number">53</span><br><span class="line-number">54</span><br><span class="line-number">55</span><br><span class="line-number">56</span><br><span class="line-number">57</span><br><span class="line-number">58</span><br><span class="line-number">59</span><br><span class="line-number">60</span><br><span class="line-number">61</span><br><span class="line-number">62</span><br><span class="line-number">63</span><br></div></div><h1 id="options"><a class="header-anchor" href="#options">#</a> Options</h1><h2 id="form-input-bindings-v-model"><a class="header-anchor" href="#form-input-bindings-v-model">#</a> Form Input Bindings: v-model</h2><p>The v-model directive can be used to create a two-way data binding. For example:</p><div class="language-vue ext-vue line-numbers-mode"><pre class="language-vue"><code><span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>quill-editor</span> <span class="token attr-name"><span class="token namespace">v-model:</span>value</span><span class="token attr-value"><span class="token punctuation attr-equals">=</span><span class="token punctuation">&quot;</span>state.content<span class="token punctuation">&quot;</span></span><span class="token punctuation">&gt;</span></span><span class="token tag"><span class="token tag"><span class="token punctuation">&lt;/</span>quill-editor</span><span class="token punctuation">&gt;</span></span>\n</code></pre><div class="line-numbers"><span class="line-number">1</span><br></div></div><h2 id="event-binding"><a class="header-anchor" href="#event-binding">#</a> Event binding</h2><div class="language-vue ext-vue line-numbers-mode"><pre class="language-vue"><code><span class="token tag"><span class="token tag"><span class="token punctuation">&lt;</span>quill-editor</span>\n    <span class="token attr-name"><span class="token namespace">v-model:</span>value</span><span class="token attr-value"><span class="token punctuation attr-equals">=</span><span class="token punctuation">&quot;</span>state.content<span class="token punctuation">&quot;</span></span>\n    <span class="token attr-name">@blur</span><span class="token attr-value"><span class="token punctuation attr-equals">=</span><span class="token punctuation">&quot;</span>onEditorBlur($event)<span class="token punctuation">&quot;</span></span>\n    <span class="token attr-name">@focus</span><span class="token attr-value"><span class="token punctuation attr-equals">=</span><span class="token punctuation">&quot;</span>onEditorFocus($event)<span class="token punctuation">&quot;</span></span>\n    <span class="token attr-name">@ready</span><span class="token attr-value"><span class="token punctuation attr-equals">=</span><span class="token punctuation">&quot;</span>onEditorReady($event)<span class="token punctuation">&quot;</span></span>\n    <span class="token attr-name">@change</span><span class="token attr-value"><span class="token punctuation attr-equals">=</span><span class="token punctuation">&quot;</span>onEditorChange($event)<span class="token punctuation">&quot;</span></span>\n  <span class="token punctuation">/&gt;</span></span>\n</code></pre><div class="line-numbers"><span class="line-number">1</span><br><span class="line-number">2</span><br><span class="line-number">3</span><br><span class="line-number">4</span><br><span class="line-number">5</span><br><span class="line-number">6</span><br><span class="line-number">7</span><br></div></div><p>The following events are available:</p><ul><li>blur</li><li>focus</li><li>ready</li><li>change</li></ul><h2 id="options-prop"><a class="header-anchor" href="#options-prop">#</a> options prop</h2>',18),l=(0,t.uE)('<strong>options</strong><br> Apply the default options by not passing this prop.<br> The options passed in will override the default preset options.<br> For example:<div class="language-javascript ext-js line-numbers-mode"><pre class="language-javascript"><code>modules<span class="token operator">:</span> <span class="token punctuation">{</span>\n  toolbar<span class="token operator">:</span> <span class="token punctuation">[</span><span class="token punctuation">]</span>\n<span class="token punctuation">}</span>\n</code></pre><div class="line-numbers"><span class="line-number">1</span><br><span class="line-number">2</span><br><span class="line-number">3</span><br></div></div>this option will generate an empty toolbar.<br> Check the offical doc ',11),c={href:"https://quilljs.com/docs/configuration/",target:"_blank",rel:"noopener noreferrer"},u=(0,t.Uk)("Quill Documentation"),i=(0,t.Uk)(" for all options."),r=(0,t.Wm)("li",null,[(0,t.Wm)("strong",null,"disabled"),(0,t.Wm)("br"),(0,t.Wm)("strong",null,"Default:"),(0,t.Uk)(),(0,t.Wm)("code",null,"false"),(0,t.Wm)("br"),(0,t.Uk)(" Set "),(0,t.Wm)("code",null,"true"),(0,t.Uk)(" to disabled the editor.")],-1),k=(0,t.uE)('<h1 id="default-quill-options"><a class="header-anchor" href="#default-quill-options">#</a> Default Quill options</h1><div class="language-javascript ext-js line-numbers-mode"><pre class="language-javascript"><code>modules<span class="token operator">:</span> <span class="token punctuation">{</span>\n  toolbar<span class="token operator">:</span> <span class="token punctuation">[</span>\n    <span class="token punctuation">[</span><span class="token string">&#39;bold&#39;</span><span class="token punctuation">,</span> <span class="token string">&#39;italic&#39;</span><span class="token punctuation">,</span> <span class="token string">&#39;underline&#39;</span><span class="token punctuation">,</span> <span class="token string">&#39;strike&#39;</span><span class="token punctuation">]</span><span class="token punctuation">,</span>\n    <span class="token punctuation">[</span><span class="token string">&#39;blockquote&#39;</span><span class="token punctuation">,</span> <span class="token string">&#39;code-block&#39;</span><span class="token punctuation">]</span><span class="token punctuation">,</span>\n    <span class="token punctuation">[</span><span class="token punctuation">{</span> header<span class="token operator">:</span> <span class="token number">1</span> <span class="token punctuation">}</span><span class="token punctuation">,</span> <span class="token punctuation">{</span> header<span class="token operator">:</span> <span class="token number">2</span> <span class="token punctuation">}</span><span class="token punctuation">]</span><span class="token punctuation">,</span>\n    <span class="token punctuation">[</span><span class="token punctuation">{</span> list<span class="token operator">:</span> <span class="token string">&#39;ordered&#39;</span> <span class="token punctuation">}</span><span class="token punctuation">,</span> <span class="token punctuation">{</span> list<span class="token operator">:</span> <span class="token string">&#39;bullet&#39;</span> <span class="token punctuation">}</span><span class="token punctuation">]</span><span class="token punctuation">,</span>\n    <span class="token punctuation">[</span><span class="token punctuation">{</span> script<span class="token operator">:</span> <span class="token string">&#39;sub&#39;</span> <span class="token punctuation">}</span><span class="token punctuation">,</span> <span class="token punctuation">{</span> script<span class="token operator">:</span> <span class="token string">&#39;super&#39;</span> <span class="token punctuation">}</span><span class="token punctuation">]</span><span class="token punctuation">,</span>\n    <span class="token punctuation">[</span><span class="token punctuation">{</span> indent<span class="token operator">:</span> <span class="token string">&#39;-1&#39;</span> <span class="token punctuation">}</span><span class="token punctuation">,</span> <span class="token punctuation">{</span> indent<span class="token operator">:</span> <span class="token string">&#39;+1&#39;</span> <span class="token punctuation">}</span><span class="token punctuation">]</span><span class="token punctuation">,</span>\n    <span class="token punctuation">[</span><span class="token punctuation">{</span> direction<span class="token operator">:</span> <span class="token string">&#39;rtl&#39;</span> <span class="token punctuation">}</span><span class="token punctuation">]</span><span class="token punctuation">,</span>\n    <span class="token punctuation">[</span><span class="token punctuation">{</span> size<span class="token operator">:</span> <span class="token punctuation">[</span><span class="token string">&#39;small&#39;</span><span class="token punctuation">,</span> <span class="token boolean">false</span><span class="token punctuation">,</span> <span class="token string">&#39;large&#39;</span><span class="token punctuation">,</span> <span class="token string">&#39;huge&#39;</span><span class="token punctuation">]</span> <span class="token punctuation">}</span><span class="token punctuation">]</span><span class="token punctuation">,</span>\n    <span class="token punctuation">[</span><span class="token punctuation">{</span> header<span class="token operator">:</span> <span class="token punctuation">[</span><span class="token number">1</span><span class="token punctuation">,</span> <span class="token number">2</span><span class="token punctuation">,</span> <span class="token number">3</span><span class="token punctuation">,</span> <span class="token number">4</span><span class="token punctuation">,</span> <span class="token number">5</span><span class="token punctuation">,</span> <span class="token number">6</span><span class="token punctuation">,</span> <span class="token boolean">false</span><span class="token punctuation">]</span> <span class="token punctuation">}</span><span class="token punctuation">]</span><span class="token punctuation">,</span>\n    <span class="token punctuation">[</span><span class="token punctuation">{</span> color<span class="token operator">:</span> <span class="token punctuation">[</span><span class="token punctuation">]</span> <span class="token punctuation">}</span><span class="token punctuation">,</span> <span class="token punctuation">{</span> background<span class="token operator">:</span> <span class="token punctuation">[</span><span class="token punctuation">]</span> <span class="token punctuation">}</span><span class="token punctuation">]</span><span class="token punctuation">,</span>\n    <span class="token punctuation">[</span><span class="token punctuation">{</span> font<span class="token operator">:</span> <span class="token punctuation">[</span><span class="token punctuation">]</span> <span class="token punctuation">}</span><span class="token punctuation">]</span><span class="token punctuation">,</span>\n    <span class="token punctuation">[</span><span class="token punctuation">{</span> align<span class="token operator">:</span> <span class="token punctuation">[</span><span class="token punctuation">]</span> <span class="token punctuation">}</span><span class="token punctuation">]</span><span class="token punctuation">,</span>\n    <span class="token punctuation">[</span><span class="token string">&#39;clean&#39;</span><span class="token punctuation">]</span><span class="token punctuation">,</span>\n    <span class="token punctuation">[</span><span class="token string">&#39;link&#39;</span><span class="token punctuation">,</span> <span class="token string">&#39;image&#39;</span><span class="token punctuation">,</span> <span class="token string">&#39;video&#39;</span><span class="token punctuation">]</span>\n  <span class="token punctuation">]</span>\n<span class="token punctuation">}</span>\n</code></pre><div class="line-numbers"><span class="line-number">1</span><br><span class="line-number">2</span><br><span class="line-number">3</span><br><span class="line-number">4</span><br><span class="line-number">5</span><br><span class="line-number">6</span><br><span class="line-number">7</span><br><span class="line-number">8</span><br><span class="line-number">9</span><br><span class="line-number">10</span><br><span class="line-number">11</span><br><span class="line-number">12</span><br><span class="line-number">13</span><br><span class="line-number">14</span><br><span class="line-number">15</span><br><span class="line-number">16</span><br><span class="line-number">17</span><br><span class="line-number">18</span><br></div></div><h1 id="packages"><a class="header-anchor" href="#packages">#</a> Packages</h1>',3),b=(0,t.Uk)("Borrowing from: "),m={href:"https://github.com/surmon-china/vue-quill-editor",target:"_blank",rel:"noopener noreferrer"},d=(0,t.Uk)("vue-quill-editor"),g=(0,t.Uk)(" Inspired by this one"),v={href:"https://www.npmjs.com/package/quill-image-uploader",target:"_blank",rel:"noopener noreferrer"},h=(0,t.Uk)("Quill ImageHandler Module"),q=(0,t.Wm)("br",null,null,-1),f=(0,t.Uk)(" ...");var y=a(262),w={components:{},setup(){const n=(0,y.qj)({dynamicComponent:null,content:"<p>2333</p>",_content:"",editorOption:{placeholder:"core",modules:{}},disabled:!1});return(0,t.bv)((()=>{Promise.all([a.e(326),a.e(507)]).then(a.bind(a,507)).then((s=>{n.dynamicComponent=s.default.quillEditor}))})),{state:n}},render:function(n,s,a,y,w,E){const W=(0,t.up)("OutboundLink");return(0,t.wg)(),(0,t.j4)(t.HY,null,[y.state.dynamicComponent?((0,t.wg)(),(0,t.j4)((0,t.LL)(y.state.dynamicComponent),{key:0,value:y.state.content,"onUpdate:value":s[1]||(s[1]=n=>y.state.content=n),options:y.state.editorOption,disabled:y.state.disabled},null,8,["value","options","disabled"])):(0,t.ry)("",!0),e,(0,t.Wm)("p",null,(0,p.zw)(y.state.content),1),o,(0,t.Wm)("ul",null,[(0,t.Wm)("li",null,[l,(0,t.Wm)("a",c,[u,(0,t.Wm)(W)]),i]),r]),k,(0,t.Wm)("p",null,[b,(0,t.Wm)("a",m,[d,(0,t.Wm)(W)]),g]),(0,t.Wm)("p",null,[(0,t.Wm)("a",v,[h,(0,t.Wm)(W)]),q,f])],64)}}}}]);