﻿// ReSharper disable once CheckNamespace
namespace Fluent;

using System.Collections.ObjectModel;
using System.Collections.Specialized;
using System.ComponentModel;
using System.Windows;
using System.Windows.Markup;

/// <summary>
/// Represent logical container for toolbar items
/// </summary>
[ContentProperty(nameof(Children))]
public class RibbonToolBarControlGroupDefinition : DependencyObject
{
    #region Events

    /// <summary>
    /// Occures when children has been changed
    /// </summary>
    public event NotifyCollectionChangedEventHandler? ChildrenChanged;

    #endregion

    #region Fields

    // User defined rows

    #endregion

    #region Children Property

    /// <summary>
    /// Gets rows
    /// </summary>
    [DesignerSerializationVisibility(DesignerSerializationVisibility.Content)]
    public ObservableCollection<RibbonToolBarControlDefinition> Children { get; } = new();

    #endregion

    #region Initialization

    /// <summary>
    /// Default constructor
    /// </summary>
    public RibbonToolBarControlGroupDefinition()
    {
        this.Children.CollectionChanged += this.OnChildrenCollectionChanged;
    }

    private void OnChildrenCollectionChanged(object? sender, NotifyCollectionChangedEventArgs e)
    {
        this.ChildrenChanged?.Invoke(sender, e);
    }

    #endregion
}