const std = @import("std");

pub fn build(b: *std.Build) void {
    const target = b.standardTargetOptions(.{});
    const optimize = b.standardOptimizeOption(.{});

    const zbackoff = b.dependency("zbackoff", .{
        .target = target,
        .optimize = optimize,
    });

    const mod_zbackoff = zbackoff.module("zbackoff");

    const lib = b.addStaticLibrary(.{
        .name = "zgroup",
        .root_source_file = b.path("src/zgroup.zig"),
        .target = target,
        .optimize = optimize,
    });

    lib.root_module.addImport("zbackoff", mod_zbackoff);
    b.installArtifact(lib);

    const exe = b.addExecutable(.{
        .name = "zgroup",
        .root_source_file = b.path("src/main.zig"),
        .target = target,
        .optimize = optimize,
    });

    exe.root_module.addImport("zbackoff", mod_zbackoff);

    b.installArtifact(exe);

    const run_cmd = b.addRunArtifact(exe);
    run_cmd.step.dependOn(b.getInstallStep());

    if (b.args) |args| {
        run_cmd.addArgs(args);
    }

    const run_step = b.step("run", "Run the app");
    run_step.dependOn(&run_cmd.step);

    const lib_unit_tests = b.addTest(.{
        .root_source_file = b.path("src/zgroup.zig"),
        .target = target,
        .optimize = optimize,
    });

    const run_lib_unit_tests = b.addRunArtifact(lib_unit_tests);

    const exe_unit_tests = b.addTest(.{
        .root_source_file = b.path("src/scratch.zig"),
        .target = target,
        .optimize = optimize,
        .filter = b.option([]const u8, "test-filter", "Filter strings for test"),
    });

    exe_unit_tests.root_module.addImport("zbackoff", mod_zbackoff);

    const run_exe_unit_tests = b.addRunArtifact(exe_unit_tests);

    const test_step = b.step("test", "Run unit tests");
    test_step.dependOn(&run_lib_unit_tests.step);
    test_step.dependOn(&run_exe_unit_tests.step);
}
