require 'spec_helper'

describe LogfileReader do

  let(:reader) do
    reader = LogfileReader.allocate
    reader.stub! :exclaim
    reader.send :initialize, 'spec/data/search.log'
    reader
  end
  
  describe 'process' do
    it 'works correctly' do
      reader.process(
        ">|2010-12-12 19:36:33|0.000197|s                                                 |10000000|   0| 1|"
      ).should == [
        '2010-12-12 19:36:33',
        0.000197,
        's',
        10000000,
        0,
        1
      ]
    end
  end
  
  describe 'since_last' do
    it 'works correctly' do
      reader.since(0).should == [
        ["2010-12-09 16:13:45", 1.0e-06,  "", 0, 0, 0],
        ["2010-12-09 16:13:45", 1.0e-05,  "", 1, 0, 1],
        ["2010-12-09 16:13:45", 0.0001,   "", 2, 0, 2],
        ["2010-12-12 12:42:19", 0.000999, "", 3, 0, 3],
        ["2010-12-12 12:42:19", 0.001,    "", 4, 20, 4],
        ["2010-12-12 12:42:19", 0.009999, "", 5, 40, 5],
        ["2010-12-12 17:20:55", 0.01,     "", 10, 0, 1],
        ["2010-12-12 17:20:55", 0.099999, "", 15, 0, 1],
        ["2010-12-12 17:20:55", 0.1,      "", 20, 0, 1],
        ["2010-12-12 17:21:32", 0.999999, "", 25, 0, 1],
        ["2010-12-12 17:21:32", 1.0,      "", 100, 0, 1],
        ["2010-12-12 17:21:32", 9.999999, "", 500, 0, 1],
        ["2010-12-12 18:06:24", 6.5e-05,  "", 1000, 0, 1],
        ["2010-12-12 18:06:24", 4.5e-05,  "", 5000, 0, 1],
        ["2010-12-12 18:06:24", 1.8e-05,  "", 10000, 0, 10],
        ["2010-12-12 19:36:00", 0.001109, "s", 50000, 0, 1],
        ["2010-12-12 19:36:24", 0.000199, "s", 100000, 0, 1],
        ["2010-12-12 19:36:32", 0.00016,  "s", 500000, 0, 1],
        ["2010-12-12 19:36:32", 0.001147, "s", 1000000, 0, 1],
        ["2010-12-12 19:36:33", 0.000209, "s", 5000000, 0, 1],
        ["2010-12-12 19:36:33", 0.000197, "s", 10000000, 0, 1],
        ["2010-12-12 19:36:33", 0.000188, "s", 99999999, 0, 99],
        ["2010-12-09 19:45:01", 1.0e-06,  "", 0, 0, 0]
      ]
    end
  end

end