#ifndef HEADER_fd_src_util_alloc_fd_alloc_cfg_h
#define HEADER_fd_src_util_alloc_fd_alloc_cfg_h

/* The below table was autogenerated.

   The method begins by choosing the parameters for the wksp allocation
   request used to support small allocations (i.e. that align and sz
   should be passed to fd_wksp_alloc to create a "huge" superblock).
   Below is such that fd_alloc_malloc will request arbitrarily aligned
   512KiB regions.  This was picked to match the maximum size supported
   by the 19-bit fd_alloc_hdr_t offset (used to find in an address space
   invariant way the superblock of an allocation).  Unaligned was used
   to be as general as possible (e.g. can swap in any other allocator
   of last resort as needed).

   Noting that superblocks have an alignment of 16 bytes, the maximum
   safe superblock footprint that can be carved out of this request is
   H=512KiB-19B=524269B (where the 19B accounts for a 4B fd_alloc_hdr_t
   and a 15B worst case alignment padding since fd_alloc_malloc
   superblock allocation doesn't assume anything the returned
   alignment).

   We note that a superblock can be divided into 1 to 64 blocks and that
   dividing it into O(1) blocks defeats the point clustering lots of
   similarly sized allocations (used to amortize various space and time
   overheads).  So we pick the minimum number of blocks in a superblock
   as 8 (~sqrt(64) and around an order of magnitude reduction in
   overheads).

   Critically, noting that ~ 512KiB/64 ~ 8KiB is pretty clumsy for small
   allocations, we recursively nest a smaller sized superblock within
   blocks of this superblock.
   
   Specifically, we pick a "large" superblock size that will nest as
   tightly inside a block of a "huge" superblock when the huge
   superblock is divided into the minimum 8 blocks.  Noting that the the
   large superblock will have the same 19B overhead and the huge huge
   superblock has a 16B header, we have L=floor((H-16B)/8)-19B=65512B.

   We recurse this all the way down to the smallest potentially useful
   superblock size (deciding to use the same 8 nesting for each level),
   yielding 5 superblock footprints (tiny 104B, small 1000B, medium
   8168B, large 65512B, huge 524269B).

   We then target 33 sizeclasses for each superblock footprint (33 is
   from trial-and-error to get something that doesn't need more than 127
   sizeclasses after the below cleanups ... 127 so that the sizeclass
   index fits and uses practically all of the 7-bits in the
   fd_alloc_hdr_t sizeclass field).  We chose block counts for these 33
   sizeclasses to be uniformly logarithmic spaced over [8,64) before
   rounding nearest.  (For the parameters here, this implies a few
   percent overhead from the implicit rounding up of an unaligned
   allocation.)
   
   block_footprints are directly computed from these superblock
   footprints and and the block counts are recomputed to squeeze some
   extra blocks into the superblocks that various integer roundings
   might have exposed.  We discard any sizeclasses that are redundant
   and any sizeclasses that are too small to be useful (blocks need to
   be at least 5 as a single byte unaligned allocation will still have a
   4 byte fd_alloc_hdr_t associated with it).  This yields the 126 size
   classes below.

   On the assumption that small allocations have a shorter lifetime /
   higher frequency than large ones, we have the option to use more
   concurrency groups for tiny, small and medium superblocks than for
   large and huge superblocks (but we don't currently).  This would
   increase thread contention for decreased preemptive overallocation at
   large sizes.

   Note that the block_footprint in this table must be monotonically
   increasing to facilitate rapid searching.

   Note also that this allocator could be customized by tweaking
   sizeclasses to match specific application allocation sizes to get
   even tighter spatial packings. */

/* Requests with worst case footprint greater than
   FD_ALLOC_FOOTPRINT_SMALL_THRESH will be considered as large and done
   directly through the fd_wksp_alloc allocator.  Smaller footprints
   will be grouped together into superblocks to reduce the costs of the
   allocations.  This should be at most the largest sizeclass block
   footprint below. */

#define FD_ALLOC_FOOTPRINT_SMALL_THRESH (65531UL)

/* FD_ALLOC_SIZECLASS_CNT is the number of sizeclasses supported by this
   implementation.  This should be positive integer of at most 127. */

#define FD_ALLOC_SIZECLASS_CNT (126UL)

/* FD_ALLOC_SIZECLASS_LARGE is a sentinel value used to indicate that
   an allocation is "large" (i.e. that is was done by the fd_wksp_alloc
   allocator). */

#define FD_ALLOC_SIZECLASS_LARGE (127UL)

struct __attribute__((aligned(8))) fd_alloc_sizeclass_cfg {
  uint   superblock_footprint; /* Size of the allocation needed to make a superblock for this class */
  ushort block_footprint;      /* Footprint of blocks in this size class, block_cnt*block_footprint+16 <= superblock_footprint */
  uchar  block_cnt;            /* Number of blocks in this, in [1,64] */
  uchar  cgroup_mask;          /* Number of cgroups for this sizeclass minus 1, a power of 2 minus 1, at most CGROUP_HINT_MAX */
};

typedef struct fd_alloc_sizeclass_cfg fd_alloc_sizeclass_cfg_t;

static fd_alloc_sizeclass_cfg_t const fd_alloc_sizeclass_cfg[126] = {
  {    104U, (ushort)    5, (uchar)17, (uchar)15 }, // sizeclass   0 - tiny sb sizeclasses
  {    104U, (ushort)    6, (uchar)14, (uchar)15 }, // sizeclass   1
  {    104U, (ushort)    7, (uchar)12, (uchar)15 }, // sizeclass   2
  {    104U, (ushort)    8, (uchar)11, (uchar)15 }, // sizeclass   3
  {    104U, (ushort)    9, (uchar) 9, (uchar)15 }, // sizeclass   4
  {    104U, (ushort)   11, (uchar) 8, (uchar)15 }, // sizeclass   5
  {   1000U, (ushort)   16, (uchar)61, (uchar)15 }, // sizeclass   6 - small sb sizeclasses
  {   1000U, (ushort)   17, (uchar)57, (uchar)15 }, // sizeclass   7
  {   1000U, (ushort)   18, (uchar)54, (uchar)15 }, // sizeclass   8
  {   1000U, (ushort)   19, (uchar)51, (uchar)15 }, // sizeclass   9
  {   1000U, (ushort)   20, (uchar)49, (uchar)15 }, // sizeclass  10
  {   1000U, (ushort)   22, (uchar)44, (uchar)15 }, // sizeclass  11
  {   1000U, (ushort)   24, (uchar)41, (uchar)15 }, // sizeclass  12
  {   1000U, (ushort)   25, (uchar)39, (uchar)15 }, // sizeclass  13
  {   1000U, (ushort)   27, (uchar)36, (uchar)15 }, // sizeclass  14
  {   1000U, (ushort)   28, (uchar)35, (uchar)15 }, // sizeclass  15
  {   1000U, (ushort)   30, (uchar)32, (uchar)15 }, // sizeclass  16
  {   1000U, (ushort)   32, (uchar)30, (uchar)15 }, // sizeclass  17
  {   1000U, (ushort)   35, (uchar)28, (uchar)15 }, // sizeclass  18
  {   1000U, (ushort)   37, (uchar)26, (uchar)15 }, // sizeclass  19
  {   1000U, (ushort)   39, (uchar)25, (uchar)15 }, // sizeclass  20
  {   1000U, (ushort)   42, (uchar)23, (uchar)15 }, // sizeclass  21
  {   1000U, (ushort)   44, (uchar)22, (uchar)15 }, // sizeclass  22
  {   1000U, (ushort)   46, (uchar)21, (uchar)15 }, // sizeclass  23
  {   1000U, (ushort)   51, (uchar)19, (uchar)15 }, // sizeclass  24
  {   1000U, (ushort)   54, (uchar)18, (uchar)15 }, // sizeclass  25
  {   1000U, (ushort)   57, (uchar)17, (uchar)15 }, // sizeclass  26
  {   1000U, (ushort)   61, (uchar)16, (uchar)15 }, // sizeclass  27
  {   1000U, (ushort)   65, (uchar)15, (uchar)15 }, // sizeclass  28
  {   1000U, (ushort)   70, (uchar)14, (uchar)15 }, // sizeclass  29
  {   1000U, (ushort)   75, (uchar)13, (uchar)15 }, // sizeclass  30
  {   1000U, (ushort)   82, (uchar)12, (uchar)15 }, // sizeclass  31
  {   1000U, (ushort)   89, (uchar)11, (uchar)15 }, // sizeclass  32
  {   1000U, (ushort)   98, (uchar)10, (uchar)15 }, // sizeclass  33
  {   1000U, (ushort)  109, (uchar) 9, (uchar)15 }, // sizeclass  34
  {   1000U, (ushort)  123, (uchar) 8, (uchar)15 }, // sizeclass  35 - holds tiny sb
  {   8168U, (ushort)  135, (uchar)60, (uchar)15 }, // sizeclass  36 - medium sb sizeclasses
  {   8168U, (ushort)  145, (uchar)56, (uchar)15 }, // sizeclass  37
  {   8168U, (ushort)  153, (uchar)53, (uchar)15 }, // sizeclass  38
  {   8168U, (ushort)  163, (uchar)50, (uchar)15 }, // sizeclass  39
  {   8168U, (ushort)  173, (uchar)47, (uchar)15 }, // sizeclass  40
  {   8168U, (ushort)  185, (uchar)44, (uchar)15 }, // sizeclass  41
  {   8168U, (ushort)  198, (uchar)41, (uchar)15 }, // sizeclass  42
  {   8168U, (ushort)  209, (uchar)39, (uchar)15 }, // sizeclass  43
  {   8168U, (ushort)  226, (uchar)36, (uchar)15 }, // sizeclass  44
  {   8168U, (ushort)  239, (uchar)34, (uchar)15 }, // sizeclass  45
  {   8168U, (ushort)  254, (uchar)32, (uchar)15 }, // sizeclass  46
  {   8168U, (ushort)  271, (uchar)30, (uchar)15 }, // sizeclass  47
  {   8168U, (ushort)  291, (uchar)28, (uchar)15 }, // sizeclass  48
  {   8168U, (ushort)  313, (uchar)26, (uchar)15 }, // sizeclass  49
  {   8168U, (ushort)  326, (uchar)25, (uchar)15 }, // sizeclass  50
  {   8168U, (ushort)  354, (uchar)23, (uchar)15 }, // sizeclass  51
  {   8168U, (ushort)  370, (uchar)22, (uchar)15 }, // sizeclass  52
  {   8168U, (ushort)  388, (uchar)21, (uchar)15 }, // sizeclass  53
  {   8168U, (ushort)  429, (uchar)19, (uchar)15 }, // sizeclass  54
  {   8168U, (ushort)  452, (uchar)18, (uchar)15 }, // sizeclass  55
  {   8168U, (ushort)  479, (uchar)17, (uchar)15 }, // sizeclass  56
  {   8168U, (ushort)  509, (uchar)16, (uchar)15 }, // sizeclass  57
  {   8168U, (ushort)  543, (uchar)15, (uchar)15 }, // sizeclass  58
  {   8168U, (ushort)  582, (uchar)14, (uchar)15 }, // sizeclass  59
  {   8168U, (ushort)  627, (uchar)13, (uchar)15 }, // sizeclass  60
  {   8168U, (ushort)  679, (uchar)12, (uchar)15 }, // sizeclass  61
  {   8168U, (ushort)  741, (uchar)11, (uchar)15 }, // sizeclass  62
  {   8168U, (ushort)  815, (uchar)10, (uchar)15 }, // sizeclass  63
  {   8168U, (ushort)  905, (uchar) 9, (uchar)15 }, // sizeclass  64
  {   8168U, (ushort) 1019, (uchar) 8, (uchar)15 }, // sizeclass  65 - holds small sb
  {  65512U, (ushort) 1091, (uchar)60, (uchar)15 }, // sizeclass  66 - large sb sizeclasses
  {  65512U, (ushort) 1169, (uchar)56, (uchar)15 }, // sizeclass  67
  {  65512U, (ushort) 1235, (uchar)53, (uchar)15 }, // sizeclass  68
  {  65512U, (ushort) 1309, (uchar)50, (uchar)15 }, // sizeclass  69
  {  65512U, (ushort) 1393, (uchar)47, (uchar)15 }, // sizeclass  70
  {  65512U, (ushort) 1488, (uchar)44, (uchar)15 }, // sizeclass  71
  {  65512U, (ushort) 1597, (uchar)41, (uchar)15 }, // sizeclass  72
  {  65512U, (ushort) 1679, (uchar)39, (uchar)15 }, // sizeclass  73
  {  65512U, (ushort) 1819, (uchar)36, (uchar)15 }, // sizeclass  74
  {  65512U, (ushort) 1926, (uchar)34, (uchar)15 }, // sizeclass  75
  {  65512U, (ushort) 2046, (uchar)32, (uchar)15 }, // sizeclass  76
  {  65512U, (ushort) 2183, (uchar)30, (uchar)15 }, // sizeclass  77
  {  65512U, (ushort) 2339, (uchar)28, (uchar)15 }, // sizeclass  78
  {  65512U, (ushort) 2519, (uchar)26, (uchar)15 }, // sizeclass  79
  {  65512U, (ushort) 2619, (uchar)25, (uchar)15 }, // sizeclass  80
  {  65512U, (ushort) 2847, (uchar)23, (uchar)15 }, // sizeclass  81
  {  65512U, (ushort) 2977, (uchar)22, (uchar)15 }, // sizeclass  82
  {  65512U, (ushort) 3118, (uchar)21, (uchar)15 }, // sizeclass  83
  {  65512U, (ushort) 3447, (uchar)19, (uchar)15 }, // sizeclass  84
  {  65512U, (ushort) 3638, (uchar)18, (uchar)15 }, // sizeclass  85
  {  65512U, (ushort) 3852, (uchar)17, (uchar)15 }, // sizeclass  86
  {  65512U, (ushort) 4093, (uchar)16, (uchar)15 }, // sizeclass  87
  {  65512U, (ushort) 4366, (uchar)15, (uchar)15 }, // sizeclass  88
  {  65512U, (ushort) 4678, (uchar)14, (uchar)15 }, // sizeclass  89
  {  65512U, (ushort) 5038, (uchar)13, (uchar)15 }, // sizeclass  90
  {  65512U, (ushort) 5458, (uchar)12, (uchar)15 }, // sizeclass  91
  {  65512U, (ushort) 5954, (uchar)11, (uchar)15 }, // sizeclass  92
  {  65512U, (ushort) 6549, (uchar)10, (uchar)15 }, // sizeclass  93
  {  65512U, (ushort) 7277, (uchar) 9, (uchar)15 }, // sizeclass  94
  {  65512U, (ushort) 8187, (uchar) 8, (uchar)15 }, // sizeclass  95 - holds medium sb
  { 524269U, (ushort) 8737, (uchar)60, (uchar)15 }, // sizeclass  96 - huge sb sizeclasses
  { 524269U, (ushort) 9361, (uchar)56, (uchar)15 }, // sizeclass  97
  { 524269U, (ushort) 9891, (uchar)53, (uchar)15 }, // sizeclass  98
  { 524269U, (ushort)10485, (uchar)50, (uchar)15 }, // sizeclass  99
  { 524269U, (ushort)11154, (uchar)47, (uchar)15 }, // sizeclass 100
  { 524269U, (ushort)11914, (uchar)44, (uchar)15 }, // sizeclass 101
  { 524269U, (ushort)12786, (uchar)41, (uchar)15 }, // sizeclass 102
  { 524269U, (ushort)13442, (uchar)39, (uchar)15 }, // sizeclass 103
  { 524269U, (ushort)14562, (uchar)36, (uchar)15 }, // sizeclass 104
  { 524269U, (ushort)15419, (uchar)34, (uchar)15 }, // sizeclass 105
  { 524269U, (ushort)16382, (uchar)32, (uchar)15 }, // sizeclass 106
  { 524269U, (ushort)17475, (uchar)30, (uchar)15 }, // sizeclass 107
  { 524269U, (ushort)18723, (uchar)28, (uchar)15 }, // sizeclass 108
  { 524269U, (ushort)20163, (uchar)26, (uchar)15 }, // sizeclass 109
  { 524269U, (ushort)20970, (uchar)25, (uchar)15 }, // sizeclass 110
  { 524269U, (ushort)22793, (uchar)23, (uchar)15 }, // sizeclass 111
  { 524269U, (ushort)23829, (uchar)22, (uchar)15 }, // sizeclass 112
  { 524269U, (ushort)24964, (uchar)21, (uchar)15 }, // sizeclass 113
  { 524269U, (ushort)27592, (uchar)19, (uchar)15 }, // sizeclass 114
  { 524269U, (ushort)29125, (uchar)18, (uchar)15 }, // sizeclass 115
  { 524269U, (ushort)30838, (uchar)17, (uchar)15 }, // sizeclass 116
  { 524269U, (ushort)32765, (uchar)16, (uchar)15 }, // sizeclass 117
  { 524269U, (ushort)34950, (uchar)15, (uchar)15 }, // sizeclass 118
  { 524269U, (ushort)37446, (uchar)14, (uchar)15 }, // sizeclass 119
  { 524269U, (ushort)40327, (uchar)13, (uchar)15 }, // sizeclass 120
  { 524269U, (ushort)43687, (uchar)12, (uchar)15 }, // sizeclass 121
  { 524269U, (ushort)47659, (uchar)11, (uchar)15 }, // sizeclass 122
  { 524269U, (ushort)52425, (uchar)10, (uchar)15 }, // sizeclass 123
  { 524269U, (ushort)58250, (uchar) 9, (uchar)15 }, // sizeclass 124
  { 524269U, (ushort)65531, (uchar) 8, (uchar)15 }  // sizeclass 125 - holds large sb
  // huge sb are wksp allocated
};

#endif /* HEADER_fd_src_util_alloc_fd_alloc_cfg_h */

