void test_fd_webserver_json_keyword(void) {
  assert(fd_webserver_json_keyword("jsonrpc\0\0\0\0\0\0\0", 7) == KEYW_JSON_JSONRPC);
  assert(fd_webserver_json_keyword("jsonrpcx\0\0\0\0\0\0\0", 8) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("jsonrp\0\0\0\0\0\0\0", 6) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|sonrpc\0\0\0\0\0\0\0", 7) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("j|onrpc\0\0\0\0\0\0\0", 7) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("js|nrpc\0\0\0\0\0\0\0", 7) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("jso|rpc\0\0\0\0\0\0\0", 7) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("json|pc\0\0\0\0\0\0\0", 7) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("jsonr|c\0\0\0\0\0\0\0", 7) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("jsonrp|\0\0\0\0\0\0\0", 7) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("id\0\0\0\0\0\0\0", 2) == KEYW_JSON_ID);
  assert(fd_webserver_json_keyword("idx\0\0\0\0\0\0\0", 3) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("i\0\0\0\0\0\0\0", 1) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|d\0\0\0\0\0\0\0", 2) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("i|\0\0\0\0\0\0\0", 2) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("method\0\0\0\0\0\0\0", 6) == KEYW_JSON_METHOD);
  assert(fd_webserver_json_keyword("methodx\0\0\0\0\0\0\0", 7) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("metho\0\0\0\0\0\0\0", 5) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|ethod\0\0\0\0\0\0\0", 6) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("m|thod\0\0\0\0\0\0\0", 6) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("me|hod\0\0\0\0\0\0\0", 6) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("met|od\0\0\0\0\0\0\0", 6) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("meth|d\0\0\0\0\0\0\0", 6) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("metho|\0\0\0\0\0\0\0", 6) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("params\0\0\0\0\0\0\0", 6) == KEYW_JSON_PARAMS);
  assert(fd_webserver_json_keyword("paramsx\0\0\0\0\0\0\0", 7) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("param\0\0\0\0\0\0\0", 5) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|arams\0\0\0\0\0\0\0", 6) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("p|rams\0\0\0\0\0\0\0", 6) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("pa|ams\0\0\0\0\0\0\0", 6) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("par|ms\0\0\0\0\0\0\0", 6) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("para|s\0\0\0\0\0\0\0", 6) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("param|\0\0\0\0\0\0\0", 6) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("before\0\0\0\0\0\0\0", 6) == KEYW_JSON_BEFORE);
  assert(fd_webserver_json_keyword("beforex\0\0\0\0\0\0\0", 7) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("befor\0\0\0\0\0\0\0", 5) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|efore\0\0\0\0\0\0\0", 6) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("b|fore\0\0\0\0\0\0\0", 6) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("be|ore\0\0\0\0\0\0\0", 6) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("bef|re\0\0\0\0\0\0\0", 6) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("befo|e\0\0\0\0\0\0\0", 6) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("befor|\0\0\0\0\0\0\0", 6) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("bytes\0\0\0\0\0\0\0", 5) == KEYW_JSON_BYTES);
  assert(fd_webserver_json_keyword("bytesx\0\0\0\0\0\0\0", 6) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("byte\0\0\0\0\0\0\0", 4) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|ytes\0\0\0\0\0\0\0", 5) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("b|tes\0\0\0\0\0\0\0", 5) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("by|es\0\0\0\0\0\0\0", 5) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("byt|s\0\0\0\0\0\0\0", 5) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("byte|\0\0\0\0\0\0\0", 5) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("commitment\0\0\0\0\0\0\0", 10) == KEYW_JSON_COMMITMENT);
  assert(fd_webserver_json_keyword("commitmentx\0\0\0\0\0\0\0", 11) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("commitmen\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|ommitment\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("c|mmitment\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("co|mitment\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("com|itment\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("comm|tment\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("commi|ment\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("commit|ent\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("commitm|nt\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("commitme|t\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("commitmen|\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("dataSize\0\0\0\0\0\0\0", 8) == KEYW_JSON_DATASIZE);
  assert(fd_webserver_json_keyword("dataSizex\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("dataSiz\0\0\0\0\0\0\0", 7) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|ataSize\0\0\0\0\0\0\0", 8) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("d|taSize\0\0\0\0\0\0\0", 8) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("da|aSize\0\0\0\0\0\0\0", 8) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("dat|Size\0\0\0\0\0\0\0", 8) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("data|ize\0\0\0\0\0\0\0", 8) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("dataS|ze\0\0\0\0\0\0\0", 8) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("dataSi|e\0\0\0\0\0\0\0", 8) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("dataSiz|\0\0\0\0\0\0\0", 8) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("dataSlice\0\0\0\0\0\0\0", 9) == KEYW_JSON_DATASLICE);
  assert(fd_webserver_json_keyword("dataSlicex\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("dataSlic\0\0\0\0\0\0\0", 8) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|ataSlice\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("d|taSlice\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("da|aSlice\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("dat|Slice\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("data|lice\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("dataS|ice\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("dataSl|ce\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("dataSli|e\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("dataSlic|\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("delinquentSlotDistance\0\0\0\0\0\0\0", 22) == KEYW_JSON_DELINQUENTSLOTDISTANCE);
  assert(fd_webserver_json_keyword("delinquentSlotDistancex\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("delinquentSlotDistanc\0\0\0\0\0\0\0", 21) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|elinquentSlotDistance\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("d|linquentSlotDistance\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("de|inquentSlotDistance\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("del|nquentSlotDistance\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("deli|quentSlotDistance\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("delin|uentSlotDistance\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("delinq|entSlotDistance\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("delinqu|ntSlotDistance\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("delinque|tSlotDistance\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("delinquen|SlotDistance\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("delinquent|lotDistance\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("delinquentS|otDistance\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("delinquentSl|tDistance\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("delinquentSlo|Distance\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("delinquentSlot|istance\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("delinquentSlotD|stance\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("delinquentSlotDi|tance\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("delinquentSlotDis|ance\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("delinquentSlotDist|nce\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("delinquentSlotDista|ce\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("delinquentSlotDistan|e\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("delinquentSlotDistanc|\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("encoding\0\0\0\0\0\0\0", 8) == KEYW_JSON_ENCODING);
  assert(fd_webserver_json_keyword("encodingx\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("encodin\0\0\0\0\0\0\0", 7) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|ncoding\0\0\0\0\0\0\0", 8) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("e|coding\0\0\0\0\0\0\0", 8) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("en|oding\0\0\0\0\0\0\0", 8) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("enc|ding\0\0\0\0\0\0\0", 8) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("enco|ing\0\0\0\0\0\0\0", 8) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("encod|ng\0\0\0\0\0\0\0", 8) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("encodi|g\0\0\0\0\0\0\0", 8) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("encodin|\0\0\0\0\0\0\0", 8) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("epoch\0\0\0\0\0\0\0", 5) == KEYW_JSON_EPOCH);
  assert(fd_webserver_json_keyword("epochx\0\0\0\0\0\0\0", 6) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("epoc\0\0\0\0\0\0\0", 4) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|poch\0\0\0\0\0\0\0", 5) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("e|och\0\0\0\0\0\0\0", 5) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ep|ch\0\0\0\0\0\0\0", 5) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("epo|h\0\0\0\0\0\0\0", 5) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("epoc|\0\0\0\0\0\0\0", 5) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("filters\0\0\0\0\0\0\0", 7) == KEYW_JSON_FILTERS);
  assert(fd_webserver_json_keyword("filtersx\0\0\0\0\0\0\0", 8) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("filter\0\0\0\0\0\0\0", 6) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|ilters\0\0\0\0\0\0\0", 7) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("f|lters\0\0\0\0\0\0\0", 7) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("fi|ters\0\0\0\0\0\0\0", 7) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("fil|ers\0\0\0\0\0\0\0", 7) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("filt|rs\0\0\0\0\0\0\0", 7) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("filte|s\0\0\0\0\0\0\0", 7) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("filter|\0\0\0\0\0\0\0", 7) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("identity\0\0\0\0\0\0\0", 8) == KEYW_JSON_IDENTITY);
  assert(fd_webserver_json_keyword("identityx\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("identit\0\0\0\0\0\0\0", 7) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|dentity\0\0\0\0\0\0\0", 8) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("i|entity\0\0\0\0\0\0\0", 8) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("id|ntity\0\0\0\0\0\0\0", 8) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ide|tity\0\0\0\0\0\0\0", 8) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("iden|ity\0\0\0\0\0\0\0", 8) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ident|ty\0\0\0\0\0\0\0", 8) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("identi|y\0\0\0\0\0\0\0", 8) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("identit|\0\0\0\0\0\0\0", 8) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("keepUnstakedDelinquents\0\0\0\0\0\0\0", 23) == KEYW_JSON_KEEPUNSTAKEDDELINQUENTS);
  assert(fd_webserver_json_keyword("keepUnstakedDelinquentsx\0\0\0\0\0\0\0", 24) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("keepUnstakedDelinquent\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|eepUnstakedDelinquents\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("k|epUnstakedDelinquents\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ke|pUnstakedDelinquents\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("kee|UnstakedDelinquents\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("keep|nstakedDelinquents\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("keepU|stakedDelinquents\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("keepUn|takedDelinquents\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("keepUns|akedDelinquents\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("keepUnst|kedDelinquents\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("keepUnsta|edDelinquents\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("keepUnstak|dDelinquents\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("keepUnstake|Delinquents\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("keepUnstaked|elinquents\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("keepUnstakedD|linquents\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("keepUnstakedDe|inquents\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("keepUnstakedDel|nquents\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("keepUnstakedDeli|quents\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("keepUnstakedDelin|uents\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("keepUnstakedDelinq|ents\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("keepUnstakedDelinqu|nts\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("keepUnstakedDelinque|ts\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("keepUnstakedDelinquen|s\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("keepUnstakedDelinquent|\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("length\0\0\0\0\0\0\0", 6) == KEYW_JSON_LENGTH);
  assert(fd_webserver_json_keyword("lengthx\0\0\0\0\0\0\0", 7) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("lengt\0\0\0\0\0\0\0", 5) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|ength\0\0\0\0\0\0\0", 6) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("l|ngth\0\0\0\0\0\0\0", 6) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("le|gth\0\0\0\0\0\0\0", 6) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("len|th\0\0\0\0\0\0\0", 6) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("leng|h\0\0\0\0\0\0\0", 6) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("lengt|\0\0\0\0\0\0\0", 6) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("limit\0\0\0\0\0\0\0", 5) == KEYW_JSON_LIMIT);
  assert(fd_webserver_json_keyword("limitx\0\0\0\0\0\0\0", 6) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("limi\0\0\0\0\0\0\0", 4) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|imit\0\0\0\0\0\0\0", 5) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("l|mit\0\0\0\0\0\0\0", 5) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("li|it\0\0\0\0\0\0\0", 5) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("lim|t\0\0\0\0\0\0\0", 5) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("limi|\0\0\0\0\0\0\0", 5) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("maxSupportedTransactionVersion\0\0\0\0\0\0\0", 30) == KEYW_JSON_MAXSUPPORTEDTRANSACTIONVERSION);
  assert(fd_webserver_json_keyword("maxSupportedTransactionVersionx\0\0\0\0\0\0\0", 31) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("maxSupportedTransactionVersio\0\0\0\0\0\0\0", 29) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|axSupportedTransactionVersion\0\0\0\0\0\0\0", 30) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("m|xSupportedTransactionVersion\0\0\0\0\0\0\0", 30) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ma|SupportedTransactionVersion\0\0\0\0\0\0\0", 30) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("max|upportedTransactionVersion\0\0\0\0\0\0\0", 30) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("maxS|pportedTransactionVersion\0\0\0\0\0\0\0", 30) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("maxSu|portedTransactionVersion\0\0\0\0\0\0\0", 30) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("maxSup|ortedTransactionVersion\0\0\0\0\0\0\0", 30) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("maxSupp|rtedTransactionVersion\0\0\0\0\0\0\0", 30) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("maxSuppo|tedTransactionVersion\0\0\0\0\0\0\0", 30) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("maxSuppor|edTransactionVersion\0\0\0\0\0\0\0", 30) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("maxSupport|dTransactionVersion\0\0\0\0\0\0\0", 30) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("maxSupporte|TransactionVersion\0\0\0\0\0\0\0", 30) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("maxSupported|ransactionVersion\0\0\0\0\0\0\0", 30) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("maxSupportedT|ansactionVersion\0\0\0\0\0\0\0", 30) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("maxSupportedTr|nsactionVersion\0\0\0\0\0\0\0", 30) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("maxSupportedTra|sactionVersion\0\0\0\0\0\0\0", 30) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("maxSupportedTran|actionVersion\0\0\0\0\0\0\0", 30) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("maxSupportedTrans|ctionVersion\0\0\0\0\0\0\0", 30) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("maxSupportedTransa|tionVersion\0\0\0\0\0\0\0", 30) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("maxSupportedTransac|ionVersion\0\0\0\0\0\0\0", 30) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("maxSupportedTransact|onVersion\0\0\0\0\0\0\0", 30) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("maxSupportedTransacti|nVersion\0\0\0\0\0\0\0", 30) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("maxSupportedTransactio|Version\0\0\0\0\0\0\0", 30) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("maxSupportedTransaction|ersion\0\0\0\0\0\0\0", 30) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("maxSupportedTransactionV|rsion\0\0\0\0\0\0\0", 30) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("maxSupportedTransactionVe|sion\0\0\0\0\0\0\0", 30) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("maxSupportedTransactionVer|ion\0\0\0\0\0\0\0", 30) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("maxSupportedTransactionVers|on\0\0\0\0\0\0\0", 30) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("maxSupportedTransactionVersi|n\0\0\0\0\0\0\0", 30) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("maxSupportedTransactionVersio|\0\0\0\0\0\0\0", 30) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("maxRetries\0\0\0\0\0\0\0", 10) == KEYW_JSON_MAXRETRIES);
  assert(fd_webserver_json_keyword("maxRetriesx\0\0\0\0\0\0\0", 11) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("maxRetrie\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|axRetries\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("m|xRetries\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ma|Retries\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("max|etries\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("maxR|tries\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("maxRe|ries\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("maxRet|ies\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("maxRetr|es\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("maxRetri|s\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("maxRetrie|\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("minContextSlot\0\0\0\0\0\0\0", 14) == KEYW_JSON_MINCONTEXTSLOT);
  assert(fd_webserver_json_keyword("minContextSlotx\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("minContextSlo\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|inContextSlot\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("m|nContextSlot\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("mi|ContextSlot\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("min|ontextSlot\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("minC|ntextSlot\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("minCo|textSlot\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("minCon|extSlot\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("minCont|xtSlot\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("minConte|tSlot\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("minContex|Slot\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("minContext|lot\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("minContextS|ot\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("minContextSl|t\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("minContextSlo|\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("memcmp\0\0\0\0\0\0\0", 6) == KEYW_JSON_MEMCMP);
  assert(fd_webserver_json_keyword("memcmpx\0\0\0\0\0\0\0", 7) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("memcm\0\0\0\0\0\0\0", 5) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|emcmp\0\0\0\0\0\0\0", 6) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("m|mcmp\0\0\0\0\0\0\0", 6) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("me|cmp\0\0\0\0\0\0\0", 6) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("mem|mp\0\0\0\0\0\0\0", 6) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("memc|p\0\0\0\0\0\0\0", 6) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("memcm|\0\0\0\0\0\0\0", 6) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("mint\0\0\0\0\0\0\0", 4) == KEYW_JSON_MINT);
  assert(fd_webserver_json_keyword("mintx\0\0\0\0\0\0\0", 5) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("min\0\0\0\0\0\0\0", 3) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|int\0\0\0\0\0\0\0", 4) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("m|nt\0\0\0\0\0\0\0", 4) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("mi|t\0\0\0\0\0\0\0", 4) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("min|\0\0\0\0\0\0\0", 4) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("offset\0\0\0\0\0\0\0", 6) == KEYW_JSON_OFFSET);
  assert(fd_webserver_json_keyword("offsetx\0\0\0\0\0\0\0", 7) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("offse\0\0\0\0\0\0\0", 5) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|ffset\0\0\0\0\0\0\0", 6) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("o|fset\0\0\0\0\0\0\0", 6) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("of|set\0\0\0\0\0\0\0", 6) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("off|et\0\0\0\0\0\0\0", 6) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("offs|t\0\0\0\0\0\0\0", 6) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("offse|\0\0\0\0\0\0\0", 6) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("preflightCommitment\0\0\0\0\0\0\0", 19) == KEYS_PREFLIGHTCOMMITMENT);
  assert(fd_webserver_json_keyword("preflightCommitmentx\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("preflightCommitmen\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|reflightCommitment\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("p|eflightCommitment\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("pr|flightCommitment\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("pre|lightCommitment\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("pref|ightCommitment\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("prefl|ghtCommitment\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("prefli|htCommitment\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("preflig|tCommitment\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("prefligh|Commitment\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("preflight|ommitment\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("preflightC|mmitment\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("preflightCo|mitment\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("preflightCom|itment\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("preflightComm|tment\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("preflightCommi|ment\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("preflightCommit|ent\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("preflightCommitm|nt\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("preflightCommitme|t\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("preflightCommitmen|\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("programId\0\0\0\0\0\0\0", 9) == KEYW_JSON_PROGRAMID);
  assert(fd_webserver_json_keyword("programIdx\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("programI\0\0\0\0\0\0\0", 8) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|rogramId\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("p|ogramId\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("pr|gramId\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("pro|ramId\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("prog|amId\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("progr|mId\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("progra|Id\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("program|d\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("programI|\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("recentBlockhash\0\0\0\0\0\0\0", 15) == KEYW_JSON_RECENTBLOCKHASH);
  assert(fd_webserver_json_keyword("recentBlockhashx\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("recentBlockhas\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|ecentBlockhash\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("r|centBlockhash\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("re|entBlockhash\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("rec|ntBlockhash\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("rece|tBlockhash\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("recen|Blockhash\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("recent|lockhash\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("recentB|ockhash\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("recentBl|ckhash\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("recentBlo|khash\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("recentBloc|hash\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("recentBlock|ash\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("recentBlockh|sh\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("recentBlockha|h\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("recentBlockhas|\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("rewards\0\0\0\0\0\0\0", 7) == KEYW_JSON_REWARDS);
  assert(fd_webserver_json_keyword("rewardsx\0\0\0\0\0\0\0", 8) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("reward\0\0\0\0\0\0\0", 6) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|ewards\0\0\0\0\0\0\0", 7) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("r|wards\0\0\0\0\0\0\0", 7) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("re|ards\0\0\0\0\0\0\0", 7) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("rew|rds\0\0\0\0\0\0\0", 7) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("rewa|ds\0\0\0\0\0\0\0", 7) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("rewar|s\0\0\0\0\0\0\0", 7) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("reward|\0\0\0\0\0\0\0", 7) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("searchTransactionHistory\0\0\0\0\0\0\0", 24) == KEYW_JSON_SEARCHTRANSACTIONHISTORY);
  assert(fd_webserver_json_keyword("searchTransactionHistoryx\0\0\0\0\0\0\0", 25) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("searchTransactionHistor\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|earchTransactionHistory\0\0\0\0\0\0\0", 24) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("s|archTransactionHistory\0\0\0\0\0\0\0", 24) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("se|rchTransactionHistory\0\0\0\0\0\0\0", 24) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("sea|chTransactionHistory\0\0\0\0\0\0\0", 24) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("sear|hTransactionHistory\0\0\0\0\0\0\0", 24) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("searc|TransactionHistory\0\0\0\0\0\0\0", 24) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("search|ransactionHistory\0\0\0\0\0\0\0", 24) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("searchT|ansactionHistory\0\0\0\0\0\0\0", 24) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("searchTr|nsactionHistory\0\0\0\0\0\0\0", 24) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("searchTra|sactionHistory\0\0\0\0\0\0\0", 24) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("searchTran|actionHistory\0\0\0\0\0\0\0", 24) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("searchTrans|ctionHistory\0\0\0\0\0\0\0", 24) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("searchTransa|tionHistory\0\0\0\0\0\0\0", 24) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("searchTransac|ionHistory\0\0\0\0\0\0\0", 24) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("searchTransact|onHistory\0\0\0\0\0\0\0", 24) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("searchTransacti|nHistory\0\0\0\0\0\0\0", 24) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("searchTransactio|History\0\0\0\0\0\0\0", 24) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("searchTransaction|istory\0\0\0\0\0\0\0", 24) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("searchTransactionH|story\0\0\0\0\0\0\0", 24) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("searchTransactionHi|tory\0\0\0\0\0\0\0", 24) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("searchTransactionHis|ory\0\0\0\0\0\0\0", 24) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("searchTransactionHist|ry\0\0\0\0\0\0\0", 24) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("searchTransactionHisto|y\0\0\0\0\0\0\0", 24) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("searchTransactionHistor|\0\0\0\0\0\0\0", 24) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("skipPreflight\0\0\0\0\0\0\0", 13) == KEYW_SKIPPREFLIGHT);
  assert(fd_webserver_json_keyword("skipPreflightx\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("skipPrefligh\0\0\0\0\0\0\0", 12) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|kipPreflight\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("s|ipPreflight\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("sk|pPreflight\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ski|Preflight\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("skip|reflight\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("skipP|eflight\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("skipPr|flight\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("skipPre|light\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("skipPref|ight\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("skipPrefl|ght\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("skipPrefli|ht\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("skipPreflig|t\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("skipPrefligh|\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("transactionDetails\0\0\0\0\0\0\0", 18) == KEYW_JSON_TRANSACTIONDETAILS);
  assert(fd_webserver_json_keyword("transactionDetailsx\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("transactionDetail\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|ransactionDetails\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("t|ansactionDetails\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("tr|nsactionDetails\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("tra|sactionDetails\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("tran|actionDetails\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("trans|ctionDetails\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("transa|tionDetails\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("transac|ionDetails\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("transact|onDetails\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("transacti|nDetails\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("transactio|Details\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("transaction|etails\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("transactionD|tails\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("transactionDe|ails\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("transactionDet|ils\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("transactionDeta|ls\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("transactionDetai|s\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("transactionDetail|\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("votePubkey\0\0\0\0\0\0\0", 10) == KEYW_JSON_VOTEPUBKEY);
  assert(fd_webserver_json_keyword("votePubkeyx\0\0\0\0\0\0\0", 11) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("votePubke\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|otePubkey\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("v|tePubkey\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("vo|ePubkey\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("vot|Pubkey\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("vote|ubkey\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("voteP|bkey\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("votePu|key\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("votePub|ey\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("votePubk|y\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("votePubke|\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("excludeNonCirculatingAccountsList\0\0\0\0\0\0\0", 33) == KEYW_JSON_EXCLUDENONCIRCULATINGACCOUNTSLIST);
  assert(fd_webserver_json_keyword("excludeNonCirculatingAccountsListx\0\0\0\0\0\0\0", 34) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("excludeNonCirculatingAccountsLis\0\0\0\0\0\0\0", 32) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|xcludeNonCirculatingAccountsList\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("e|cludeNonCirculatingAccountsList\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ex|ludeNonCirculatingAccountsList\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("exc|udeNonCirculatingAccountsList\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("excl|deNonCirculatingAccountsList\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("exclu|eNonCirculatingAccountsList\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("exclud|NonCirculatingAccountsList\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("exclude|onCirculatingAccountsList\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("excludeN|nCirculatingAccountsList\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("excludeNo|CirculatingAccountsList\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("excludeNon|irculatingAccountsList\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("excludeNonC|rculatingAccountsList\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("excludeNonCi|culatingAccountsList\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("excludeNonCir|ulatingAccountsList\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("excludeNonCirc|latingAccountsList\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("excludeNonCircu|atingAccountsList\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("excludeNonCircul|tingAccountsList\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("excludeNonCircula|ingAccountsList\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("excludeNonCirculat|ngAccountsList\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("excludeNonCirculati|gAccountsList\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("excludeNonCirculatin|AccountsList\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("excludeNonCirculating|ccountsList\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("excludeNonCirculatingA|countsList\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("excludeNonCirculatingAc|ountsList\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("excludeNonCirculatingAcc|untsList\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("excludeNonCirculatingAcco|ntsList\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("excludeNonCirculatingAccou|tsList\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("excludeNonCirculatingAccoun|sList\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("excludeNonCirculatingAccount|List\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("excludeNonCirculatingAccounts|ist\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("excludeNonCirculatingAccountsL|st\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("excludeNonCirculatingAccountsLi|t\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("excludeNonCirculatingAccountsLis|\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getAccountInfo\0\0\0\0\0\0\0", 14) == KEYW_RPCMETHOD_GETACCOUNTINFO);
  assert(fd_webserver_json_keyword("getAccountInfox\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getAccountInf\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etAccountInfo\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tAccountInfo\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|AccountInfo\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|ccountInfo\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getA|countInfo\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getAc|ountInfo\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getAcc|untInfo\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getAcco|ntInfo\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getAccou|tInfo\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getAccoun|Info\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getAccount|nfo\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getAccountI|fo\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getAccountIn|o\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getAccountInf|\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBalance\0\0\0\0\0\0\0", 10) == KEYW_RPCMETHOD_GETBALANCE);
  assert(fd_webserver_json_keyword("getBalancex\0\0\0\0\0\0\0", 11) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBalanc\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etBalance\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tBalance\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|Balance\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|alance\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getB|lance\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBa|ance\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBal|nce\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBala|ce\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBalan|e\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBalanc|\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlock\0\0\0\0\0\0\0", 8) == KEYW_RPCMETHOD_GETBLOCK);
  assert(fd_webserver_json_keyword("getBlockx\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBloc\0\0\0\0\0\0\0", 7) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etBlock\0\0\0\0\0\0\0", 8) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tBlock\0\0\0\0\0\0\0", 8) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|Block\0\0\0\0\0\0\0", 8) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|lock\0\0\0\0\0\0\0", 8) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getB|ock\0\0\0\0\0\0\0", 8) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBl|ck\0\0\0\0\0\0\0", 8) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlo|k\0\0\0\0\0\0\0", 8) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBloc|\0\0\0\0\0\0\0", 8) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlockCommitment\0\0\0\0\0\0\0", 18) == KEYW_RPCMETHOD_GETBLOCKCOMMITMENT);
  assert(fd_webserver_json_keyword("getBlockCommitmentx\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlockCommitmen\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etBlockCommitment\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tBlockCommitment\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|BlockCommitment\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|lockCommitment\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getB|ockCommitment\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBl|ckCommitment\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlo|kCommitment\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBloc|Commitment\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlock|ommitment\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlockC|mmitment\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlockCo|mitment\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlockCom|itment\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlockComm|tment\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlockCommi|ment\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlockCommit|ent\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlockCommitm|nt\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlockCommitme|t\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlockCommitmen|\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlockHeight\0\0\0\0\0\0\0", 14) == KEYW_RPCMETHOD_GETBLOCKHEIGHT);
  assert(fd_webserver_json_keyword("getBlockHeightx\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlockHeigh\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etBlockHeight\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tBlockHeight\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|BlockHeight\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|lockHeight\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getB|ockHeight\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBl|ckHeight\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlo|kHeight\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBloc|Height\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlock|eight\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlockH|ight\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlockHe|ght\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlockHei|ht\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlockHeig|t\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlockHeigh|\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlockProduction\0\0\0\0\0\0\0", 18) == KEYW_RPCMETHOD_GETBLOCKPRODUCTION);
  assert(fd_webserver_json_keyword("getBlockProductionx\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlockProductio\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etBlockProduction\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tBlockProduction\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|BlockProduction\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|lockProduction\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getB|ockProduction\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBl|ckProduction\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlo|kProduction\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBloc|Production\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlock|roduction\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlockP|oduction\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlockPr|duction\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlockPro|uction\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlockProd|ction\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlockProdu|tion\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlockProduc|ion\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlockProduct|on\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlockProducti|n\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlockProductio|\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlocks\0\0\0\0\0\0\0", 9) == KEYW_RPCMETHOD_GETBLOCKS);
  assert(fd_webserver_json_keyword("getBlocksx\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etBlocks\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tBlocks\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|Blocks\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|locks\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getB|ocks\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBl|cks\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlo|ks\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBloc|s\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlock|\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlocksWithLimit\0\0\0\0\0\0\0", 18) == KEYW_RPCMETHOD_GETBLOCKSWITHLIMIT);
  assert(fd_webserver_json_keyword("getBlocksWithLimitx\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlocksWithLimi\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etBlocksWithLimit\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tBlocksWithLimit\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|BlocksWithLimit\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|locksWithLimit\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getB|ocksWithLimit\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBl|cksWithLimit\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlo|ksWithLimit\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBloc|sWithLimit\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlock|WithLimit\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlocks|ithLimit\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlocksW|thLimit\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlocksWi|hLimit\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlocksWit|Limit\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlocksWith|imit\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlocksWithL|mit\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlocksWithLi|it\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlocksWithLim|t\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlocksWithLimi|\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlockTime\0\0\0\0\0\0\0", 12) == KEYW_RPCMETHOD_GETBLOCKTIME);
  assert(fd_webserver_json_keyword("getBlockTimex\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlockTim\0\0\0\0\0\0\0", 11) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etBlockTime\0\0\0\0\0\0\0", 12) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tBlockTime\0\0\0\0\0\0\0", 12) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|BlockTime\0\0\0\0\0\0\0", 12) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|lockTime\0\0\0\0\0\0\0", 12) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getB|ockTime\0\0\0\0\0\0\0", 12) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBl|ckTime\0\0\0\0\0\0\0", 12) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlo|kTime\0\0\0\0\0\0\0", 12) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBloc|Time\0\0\0\0\0\0\0", 12) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlock|ime\0\0\0\0\0\0\0", 12) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlockT|me\0\0\0\0\0\0\0", 12) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlockTi|e\0\0\0\0\0\0\0", 12) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getBlockTim|\0\0\0\0\0\0\0", 12) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getClusterNodes\0\0\0\0\0\0\0", 15) == KEYW_RPCMETHOD_GETCLUSTERNODES);
  assert(fd_webserver_json_keyword("getClusterNodesx\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getClusterNode\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etClusterNodes\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tClusterNodes\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|ClusterNodes\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|lusterNodes\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getC|usterNodes\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getCl|sterNodes\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getClu|terNodes\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getClus|erNodes\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getClust|rNodes\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getCluste|Nodes\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getCluster|odes\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getClusterN|des\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getClusterNo|es\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getClusterNod|s\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getClusterNode|\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedBlock\0\0\0\0\0\0\0", 17) == KEYW_RPCMETHOD_GETCONFIRMEDBLOCK);
  assert(fd_webserver_json_keyword("getConfirmedBlockx\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedBloc\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etConfirmedBlock\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tConfirmedBlock\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|ConfirmedBlock\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|onfirmedBlock\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getC|nfirmedBlock\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getCo|firmedBlock\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getCon|irmedBlock\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConf|rmedBlock\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfi|medBlock\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfir|edBlock\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirm|dBlock\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirme|Block\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmed|lock\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedB|ock\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedBl|ck\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedBlo|k\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedBloc|\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedBlocks\0\0\0\0\0\0\0", 18) == KEYW_RPCMETHOD_GETCONFIRMEDBLOCKS);
  assert(fd_webserver_json_keyword("getConfirmedBlocksx\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etConfirmedBlocks\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tConfirmedBlocks\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|ConfirmedBlocks\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|onfirmedBlocks\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getC|nfirmedBlocks\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getCo|firmedBlocks\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getCon|irmedBlocks\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConf|rmedBlocks\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfi|medBlocks\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfir|edBlocks\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirm|dBlocks\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirme|Blocks\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmed|locks\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedB|ocks\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedBl|cks\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedBlo|ks\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedBloc|s\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedBlock|\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedBlocksWithLimit\0\0\0\0\0\0\0", 27) == KEYW_RPCMETHOD_GETCONFIRMEDBLOCKSWITHLIMIT);
  assert(fd_webserver_json_keyword("getConfirmedBlocksWithLimitx\0\0\0\0\0\0\0", 28) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedBlocksWithLimi\0\0\0\0\0\0\0", 26) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etConfirmedBlocksWithLimit\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tConfirmedBlocksWithLimit\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|ConfirmedBlocksWithLimit\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|onfirmedBlocksWithLimit\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getC|nfirmedBlocksWithLimit\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getCo|firmedBlocksWithLimit\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getCon|irmedBlocksWithLimit\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConf|rmedBlocksWithLimit\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfi|medBlocksWithLimit\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfir|edBlocksWithLimit\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirm|dBlocksWithLimit\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirme|BlocksWithLimit\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmed|locksWithLimit\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedB|ocksWithLimit\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedBl|cksWithLimit\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedBlo|ksWithLimit\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedBloc|sWithLimit\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedBlock|WithLimit\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedBlocks|ithLimit\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedBlocksW|thLimit\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedBlocksWi|hLimit\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedBlocksWit|Limit\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedBlocksWith|imit\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedBlocksWithL|mit\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedBlocksWithLi|it\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedBlocksWithLim|t\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedBlocksWithLimi|\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedSignaturesForAddress2\0\0\0\0\0\0\0", 33) == KEYW_RPCMETHOD_GETCONFIRMEDSIGNATURESFORADDRESS2);
  assert(fd_webserver_json_keyword("getConfirmedSignaturesForAddress2x\0\0\0\0\0\0\0", 34) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedSignaturesForAddress\0\0\0\0\0\0\0", 32) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etConfirmedSignaturesForAddress2\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tConfirmedSignaturesForAddress2\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|ConfirmedSignaturesForAddress2\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|onfirmedSignaturesForAddress2\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getC|nfirmedSignaturesForAddress2\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getCo|firmedSignaturesForAddress2\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getCon|irmedSignaturesForAddress2\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConf|rmedSignaturesForAddress2\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfi|medSignaturesForAddress2\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfir|edSignaturesForAddress2\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirm|dSignaturesForAddress2\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirme|SignaturesForAddress2\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmed|ignaturesForAddress2\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedS|gnaturesForAddress2\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedSi|naturesForAddress2\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedSig|aturesForAddress2\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedSign|turesForAddress2\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedSigna|uresForAddress2\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedSignat|resForAddress2\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedSignatu|esForAddress2\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedSignatur|sForAddress2\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedSignature|ForAddress2\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedSignatures|orAddress2\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedSignaturesF|rAddress2\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedSignaturesFo|Address2\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedSignaturesFor|ddress2\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedSignaturesForA|dress2\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedSignaturesForAd|ress2\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedSignaturesForAdd|ess2\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedSignaturesForAddr|ss2\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedSignaturesForAddre|s2\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedSignaturesForAddres|2\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedSignaturesForAddress|\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedTransaction\0\0\0\0\0\0\0", 23) == KEYW_RPCMETHOD_GETCONFIRMEDTRANSACTION);
  assert(fd_webserver_json_keyword("getConfirmedTransactionx\0\0\0\0\0\0\0", 24) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedTransactio\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etConfirmedTransaction\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tConfirmedTransaction\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|ConfirmedTransaction\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|onfirmedTransaction\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getC|nfirmedTransaction\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getCo|firmedTransaction\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getCon|irmedTransaction\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConf|rmedTransaction\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfi|medTransaction\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfir|edTransaction\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirm|dTransaction\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirme|Transaction\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmed|ransaction\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedT|ansaction\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedTr|nsaction\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedTra|saction\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedTran|action\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedTrans|ction\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedTransa|tion\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedTransac|ion\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedTransact|on\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedTransacti|n\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getConfirmedTransactio|\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getEpochInfo\0\0\0\0\0\0\0", 12) == KEYW_RPCMETHOD_GETEPOCHINFO);
  assert(fd_webserver_json_keyword("getEpochInfox\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getEpochInf\0\0\0\0\0\0\0", 11) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etEpochInfo\0\0\0\0\0\0\0", 12) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tEpochInfo\0\0\0\0\0\0\0", 12) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|EpochInfo\0\0\0\0\0\0\0", 12) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|pochInfo\0\0\0\0\0\0\0", 12) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getE|ochInfo\0\0\0\0\0\0\0", 12) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getEp|chInfo\0\0\0\0\0\0\0", 12) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getEpo|hInfo\0\0\0\0\0\0\0", 12) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getEpoc|Info\0\0\0\0\0\0\0", 12) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getEpoch|nfo\0\0\0\0\0\0\0", 12) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getEpochI|fo\0\0\0\0\0\0\0", 12) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getEpochIn|o\0\0\0\0\0\0\0", 12) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getEpochInf|\0\0\0\0\0\0\0", 12) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getEpochSchedule\0\0\0\0\0\0\0", 16) == KEYW_RPCMETHOD_GETEPOCHSCHEDULE);
  assert(fd_webserver_json_keyword("getEpochSchedulex\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getEpochSchedul\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etEpochSchedule\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tEpochSchedule\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|EpochSchedule\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|pochSchedule\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getE|ochSchedule\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getEp|chSchedule\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getEpo|hSchedule\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getEpoc|Schedule\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getEpoch|chedule\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getEpochS|hedule\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getEpochSc|edule\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getEpochSch|dule\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getEpochSche|ule\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getEpochSched|le\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getEpochSchedu|e\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getEpochSchedul|\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFeeCalculatorForBlockhash\0\0\0\0\0\0\0", 28) == KEYW_RPCMETHOD_GETFEECALCULATORFORBLOCKHASH);
  assert(fd_webserver_json_keyword("getFeeCalculatorForBlockhashx\0\0\0\0\0\0\0", 29) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFeeCalculatorForBlockhas\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etFeeCalculatorForBlockhash\0\0\0\0\0\0\0", 28) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tFeeCalculatorForBlockhash\0\0\0\0\0\0\0", 28) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|FeeCalculatorForBlockhash\0\0\0\0\0\0\0", 28) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|eeCalculatorForBlockhash\0\0\0\0\0\0\0", 28) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getF|eCalculatorForBlockhash\0\0\0\0\0\0\0", 28) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFe|CalculatorForBlockhash\0\0\0\0\0\0\0", 28) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFee|alculatorForBlockhash\0\0\0\0\0\0\0", 28) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFeeC|lculatorForBlockhash\0\0\0\0\0\0\0", 28) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFeeCa|culatorForBlockhash\0\0\0\0\0\0\0", 28) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFeeCal|ulatorForBlockhash\0\0\0\0\0\0\0", 28) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFeeCalc|latorForBlockhash\0\0\0\0\0\0\0", 28) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFeeCalcu|atorForBlockhash\0\0\0\0\0\0\0", 28) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFeeCalcul|torForBlockhash\0\0\0\0\0\0\0", 28) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFeeCalcula|orForBlockhash\0\0\0\0\0\0\0", 28) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFeeCalculat|rForBlockhash\0\0\0\0\0\0\0", 28) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFeeCalculato|ForBlockhash\0\0\0\0\0\0\0", 28) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFeeCalculator|orBlockhash\0\0\0\0\0\0\0", 28) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFeeCalculatorF|rBlockhash\0\0\0\0\0\0\0", 28) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFeeCalculatorFo|Blockhash\0\0\0\0\0\0\0", 28) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFeeCalculatorFor|lockhash\0\0\0\0\0\0\0", 28) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFeeCalculatorForB|ockhash\0\0\0\0\0\0\0", 28) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFeeCalculatorForBl|ckhash\0\0\0\0\0\0\0", 28) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFeeCalculatorForBlo|khash\0\0\0\0\0\0\0", 28) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFeeCalculatorForBloc|hash\0\0\0\0\0\0\0", 28) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFeeCalculatorForBlock|ash\0\0\0\0\0\0\0", 28) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFeeCalculatorForBlockh|sh\0\0\0\0\0\0\0", 28) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFeeCalculatorForBlockha|h\0\0\0\0\0\0\0", 28) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFeeCalculatorForBlockhas|\0\0\0\0\0\0\0", 28) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFeeForMessage\0\0\0\0\0\0\0", 16) == KEYW_RPCMETHOD_GETFEEFORMESSAGE);
  assert(fd_webserver_json_keyword("getFeeForMessagex\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFeeForMessag\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etFeeForMessage\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tFeeForMessage\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|FeeForMessage\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|eeForMessage\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getF|eForMessage\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFe|ForMessage\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFee|orMessage\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFeeF|rMessage\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFeeFo|Message\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFeeFor|essage\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFeeForM|ssage\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFeeForMe|sage\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFeeForMes|age\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFeeForMess|ge\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFeeForMessa|e\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFeeForMessag|\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFeeRateGovernor\0\0\0\0\0\0\0", 18) == KEYW_RPCMETHOD_GETFEERATEGOVERNOR);
  assert(fd_webserver_json_keyword("getFeeRateGovernorx\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFeeRateGoverno\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etFeeRateGovernor\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tFeeRateGovernor\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|FeeRateGovernor\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|eeRateGovernor\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getF|eRateGovernor\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFe|RateGovernor\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFee|ateGovernor\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFeeR|teGovernor\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFeeRa|eGovernor\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFeeRat|Governor\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFeeRate|overnor\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFeeRateG|vernor\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFeeRateGo|ernor\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFeeRateGov|rnor\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFeeRateGove|nor\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFeeRateGover|or\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFeeRateGovern|r\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFeeRateGoverno|\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFees\0\0\0\0\0\0\0", 7) == KEYW_RPCMETHOD_GETFEES);
  assert(fd_webserver_json_keyword("getFeesx\0\0\0\0\0\0\0", 8) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFee\0\0\0\0\0\0\0", 6) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etFees\0\0\0\0\0\0\0", 7) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tFees\0\0\0\0\0\0\0", 7) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|Fees\0\0\0\0\0\0\0", 7) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|ees\0\0\0\0\0\0\0", 7) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getF|es\0\0\0\0\0\0\0", 7) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFe|s\0\0\0\0\0\0\0", 7) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFee|\0\0\0\0\0\0\0", 7) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFirstAvailableBlock\0\0\0\0\0\0\0", 22) == KEYW_RPCMETHOD_GETFIRSTAVAILABLEBLOCK);
  assert(fd_webserver_json_keyword("getFirstAvailableBlockx\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFirstAvailableBloc\0\0\0\0\0\0\0", 21) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etFirstAvailableBlock\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tFirstAvailableBlock\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|FirstAvailableBlock\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|irstAvailableBlock\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getF|rstAvailableBlock\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFi|stAvailableBlock\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFir|tAvailableBlock\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFirs|AvailableBlock\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFirst|vailableBlock\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFirstA|ailableBlock\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFirstAv|ilableBlock\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFirstAva|lableBlock\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFirstAvai|ableBlock\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFirstAvail|bleBlock\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFirstAvaila|leBlock\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFirstAvailab|eBlock\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFirstAvailabl|Block\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFirstAvailable|lock\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFirstAvailableB|ock\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFirstAvailableBl|ck\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFirstAvailableBlo|k\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getFirstAvailableBloc|\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getGenesisHash\0\0\0\0\0\0\0", 14) == KEYW_RPCMETHOD_GETGENESISHASH);
  assert(fd_webserver_json_keyword("getGenesisHashx\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getGenesisHas\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etGenesisHash\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tGenesisHash\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|GenesisHash\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|enesisHash\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getG|nesisHash\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getGe|esisHash\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getGen|sisHash\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getGene|isHash\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getGenes|sHash\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getGenesi|Hash\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getGenesis|ash\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getGenesisH|sh\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getGenesisHa|h\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getGenesisHas|\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getHealth\0\0\0\0\0\0\0", 9) == KEYW_RPCMETHOD_GETHEALTH);
  assert(fd_webserver_json_keyword("getHealthx\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getHealt\0\0\0\0\0\0\0", 8) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etHealth\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tHealth\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|Health\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|ealth\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getH|alth\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getHe|lth\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getHea|th\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getHeal|h\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getHealt|\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getHighestSnapshotSlot\0\0\0\0\0\0\0", 22) == KEYW_RPCMETHOD_GETHIGHESTSNAPSHOTSLOT);
  assert(fd_webserver_json_keyword("getHighestSnapshotSlotx\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getHighestSnapshotSlo\0\0\0\0\0\0\0", 21) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etHighestSnapshotSlot\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tHighestSnapshotSlot\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|HighestSnapshotSlot\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|ighestSnapshotSlot\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getH|ghestSnapshotSlot\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getHi|hestSnapshotSlot\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getHig|estSnapshotSlot\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getHigh|stSnapshotSlot\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getHighe|tSnapshotSlot\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getHighes|SnapshotSlot\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getHighest|napshotSlot\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getHighestS|apshotSlot\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getHighestSn|pshotSlot\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getHighestSna|shotSlot\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getHighestSnap|hotSlot\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getHighestSnaps|otSlot\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getHighestSnapsh|tSlot\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getHighestSnapsho|Slot\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getHighestSnapshot|lot\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getHighestSnapshotS|ot\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getHighestSnapshotSl|t\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getHighestSnapshotSlo|\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getIdentity\0\0\0\0\0\0\0", 11) == KEYW_RPCMETHOD_GETIDENTITY);
  assert(fd_webserver_json_keyword("getIdentityx\0\0\0\0\0\0\0", 12) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getIdentit\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etIdentity\0\0\0\0\0\0\0", 11) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tIdentity\0\0\0\0\0\0\0", 11) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|Identity\0\0\0\0\0\0\0", 11) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|dentity\0\0\0\0\0\0\0", 11) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getI|entity\0\0\0\0\0\0\0", 11) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getId|ntity\0\0\0\0\0\0\0", 11) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getIde|tity\0\0\0\0\0\0\0", 11) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getIden|ity\0\0\0\0\0\0\0", 11) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getIdent|ty\0\0\0\0\0\0\0", 11) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getIdenti|y\0\0\0\0\0\0\0", 11) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getIdentit|\0\0\0\0\0\0\0", 11) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getInflationGovernor\0\0\0\0\0\0\0", 20) == KEYW_RPCMETHOD_GETINFLATIONGOVERNOR);
  assert(fd_webserver_json_keyword("getInflationGovernorx\0\0\0\0\0\0\0", 21) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getInflationGoverno\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etInflationGovernor\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tInflationGovernor\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|InflationGovernor\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|nflationGovernor\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getI|flationGovernor\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getIn|lationGovernor\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getInf|ationGovernor\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getInfl|tionGovernor\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getInfla|ionGovernor\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getInflat|onGovernor\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getInflati|nGovernor\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getInflatio|Governor\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getInflation|overnor\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getInflationG|vernor\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getInflationGo|ernor\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getInflationGov|rnor\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getInflationGove|nor\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getInflationGover|or\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getInflationGovern|r\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getInflationGoverno|\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getInflationRate\0\0\0\0\0\0\0", 16) == KEYW_RPCMETHOD_GETINFLATIONRATE);
  assert(fd_webserver_json_keyword("getInflationRatex\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getInflationRat\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etInflationRate\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tInflationRate\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|InflationRate\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|nflationRate\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getI|flationRate\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getIn|lationRate\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getInf|ationRate\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getInfl|tionRate\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getInfla|ionRate\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getInflat|onRate\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getInflati|nRate\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getInflatio|Rate\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getInflation|ate\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getInflationR|te\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getInflationRa|e\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getInflationRat|\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getInflationReward\0\0\0\0\0\0\0", 18) == KEYW_RPCMETHOD_GETINFLATIONREWARD);
  assert(fd_webserver_json_keyword("getInflationRewardx\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getInflationRewar\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etInflationReward\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tInflationReward\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|InflationReward\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|nflationReward\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getI|flationReward\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getIn|lationReward\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getInf|ationReward\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getInfl|tionReward\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getInfla|ionReward\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getInflat|onReward\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getInflati|nReward\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getInflatio|Reward\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getInflation|eward\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getInflationR|ward\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getInflationRe|ard\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getInflationRew|rd\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getInflationRewa|d\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getInflationRewar|\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getLargestAccounts\0\0\0\0\0\0\0", 18) == KEYW_RPCMETHOD_GETLARGESTACCOUNTS);
  assert(fd_webserver_json_keyword("getLargestAccountsx\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getLargestAccount\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etLargestAccounts\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tLargestAccounts\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|LargestAccounts\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|argestAccounts\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getL|rgestAccounts\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getLa|gestAccounts\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getLar|estAccounts\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getLarg|stAccounts\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getLarge|tAccounts\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getLarges|Accounts\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getLargest|ccounts\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getLargestA|counts\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getLargestAc|ounts\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getLargestAcc|unts\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getLargestAcco|nts\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getLargestAccou|ts\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getLargestAccoun|s\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getLargestAccount|\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getLatestBlockhash\0\0\0\0\0\0\0", 18) == KEYW_RPCMETHOD_GETLATESTBLOCKHASH);
  assert(fd_webserver_json_keyword("getLatestBlockhashx\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getLatestBlockhas\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etLatestBlockhash\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tLatestBlockhash\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|LatestBlockhash\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|atestBlockhash\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getL|testBlockhash\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getLa|estBlockhash\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getLat|stBlockhash\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getLate|tBlockhash\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getLates|Blockhash\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getLatest|lockhash\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getLatestB|ockhash\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getLatestBl|ckhash\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getLatestBlo|khash\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getLatestBloc|hash\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getLatestBlock|ash\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getLatestBlockh|sh\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getLatestBlockha|h\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getLatestBlockhas|\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getLeaderSchedule\0\0\0\0\0\0\0", 17) == KEYW_RPCMETHOD_GETLEADERSCHEDULE);
  assert(fd_webserver_json_keyword("getLeaderSchedulex\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getLeaderSchedul\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etLeaderSchedule\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tLeaderSchedule\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|LeaderSchedule\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|eaderSchedule\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getL|aderSchedule\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getLe|derSchedule\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getLea|erSchedule\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getLead|rSchedule\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getLeade|Schedule\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getLeader|chedule\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getLeaderS|hedule\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getLeaderSc|edule\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getLeaderSch|dule\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getLeaderSche|ule\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getLeaderSched|le\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getLeaderSchedu|e\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getLeaderSchedul|\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMaxRetransmitSlot\0\0\0\0\0\0\0", 20) == KEYW_RPCMETHOD_GETMAXRETRANSMITSLOT);
  assert(fd_webserver_json_keyword("getMaxRetransmitSlotx\0\0\0\0\0\0\0", 21) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMaxRetransmitSlo\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etMaxRetransmitSlot\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tMaxRetransmitSlot\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|MaxRetransmitSlot\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|axRetransmitSlot\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getM|xRetransmitSlot\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMa|RetransmitSlot\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMax|etransmitSlot\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMaxR|transmitSlot\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMaxRe|ransmitSlot\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMaxRet|ansmitSlot\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMaxRetr|nsmitSlot\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMaxRetra|smitSlot\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMaxRetran|mitSlot\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMaxRetrans|itSlot\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMaxRetransm|tSlot\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMaxRetransmi|Slot\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMaxRetransmit|lot\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMaxRetransmitS|ot\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMaxRetransmitSl|t\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMaxRetransmitSlo|\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMaxShredInsertSlot\0\0\0\0\0\0\0", 21) == KEYW_RPCMETHOD_GETMAXSHREDINSERTSLOT);
  assert(fd_webserver_json_keyword("getMaxShredInsertSlotx\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMaxShredInsertSlo\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etMaxShredInsertSlot\0\0\0\0\0\0\0", 21) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tMaxShredInsertSlot\0\0\0\0\0\0\0", 21) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|MaxShredInsertSlot\0\0\0\0\0\0\0", 21) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|axShredInsertSlot\0\0\0\0\0\0\0", 21) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getM|xShredInsertSlot\0\0\0\0\0\0\0", 21) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMa|ShredInsertSlot\0\0\0\0\0\0\0", 21) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMax|hredInsertSlot\0\0\0\0\0\0\0", 21) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMaxS|redInsertSlot\0\0\0\0\0\0\0", 21) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMaxSh|edInsertSlot\0\0\0\0\0\0\0", 21) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMaxShr|dInsertSlot\0\0\0\0\0\0\0", 21) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMaxShre|InsertSlot\0\0\0\0\0\0\0", 21) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMaxShred|nsertSlot\0\0\0\0\0\0\0", 21) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMaxShredI|sertSlot\0\0\0\0\0\0\0", 21) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMaxShredIn|ertSlot\0\0\0\0\0\0\0", 21) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMaxShredIns|rtSlot\0\0\0\0\0\0\0", 21) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMaxShredInse|tSlot\0\0\0\0\0\0\0", 21) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMaxShredInser|Slot\0\0\0\0\0\0\0", 21) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMaxShredInsert|lot\0\0\0\0\0\0\0", 21) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMaxShredInsertS|ot\0\0\0\0\0\0\0", 21) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMaxShredInsertSl|t\0\0\0\0\0\0\0", 21) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMaxShredInsertSlo|\0\0\0\0\0\0\0", 21) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMinimumBalanceForRentExemption\0\0\0\0\0\0\0", 33) == KEYW_RPCMETHOD_GETMINIMUMBALANCEFORRENTEXEMPTION);
  assert(fd_webserver_json_keyword("getMinimumBalanceForRentExemptionx\0\0\0\0\0\0\0", 34) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMinimumBalanceForRentExemptio\0\0\0\0\0\0\0", 32) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etMinimumBalanceForRentExemption\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tMinimumBalanceForRentExemption\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|MinimumBalanceForRentExemption\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|inimumBalanceForRentExemption\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getM|nimumBalanceForRentExemption\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMi|imumBalanceForRentExemption\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMin|mumBalanceForRentExemption\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMini|umBalanceForRentExemption\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMinim|mBalanceForRentExemption\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMinimu|BalanceForRentExemption\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMinimum|alanceForRentExemption\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMinimumB|lanceForRentExemption\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMinimumBa|anceForRentExemption\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMinimumBal|nceForRentExemption\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMinimumBala|ceForRentExemption\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMinimumBalan|eForRentExemption\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMinimumBalanc|ForRentExemption\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMinimumBalance|orRentExemption\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMinimumBalanceF|rRentExemption\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMinimumBalanceFo|RentExemption\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMinimumBalanceFor|entExemption\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMinimumBalanceForR|ntExemption\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMinimumBalanceForRe|tExemption\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMinimumBalanceForRen|Exemption\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMinimumBalanceForRent|xemption\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMinimumBalanceForRentE|emption\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMinimumBalanceForRentEx|mption\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMinimumBalanceForRentExe|ption\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMinimumBalanceForRentExem|tion\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMinimumBalanceForRentExemp|ion\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMinimumBalanceForRentExempt|on\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMinimumBalanceForRentExempti|n\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMinimumBalanceForRentExemptio|\0\0\0\0\0\0\0", 33) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMultipleAccounts\0\0\0\0\0\0\0", 19) == KEYW_RPCMETHOD_GETMULTIPLEACCOUNTS);
  assert(fd_webserver_json_keyword("getMultipleAccountsx\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMultipleAccount\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etMultipleAccounts\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tMultipleAccounts\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|MultipleAccounts\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|ultipleAccounts\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getM|ltipleAccounts\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMu|tipleAccounts\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMul|ipleAccounts\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMult|pleAccounts\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMulti|leAccounts\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMultip|eAccounts\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMultipl|Accounts\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMultiple|ccounts\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMultipleA|counts\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMultipleAc|ounts\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMultipleAcc|unts\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMultipleAcco|nts\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMultipleAccou|ts\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMultipleAccoun|s\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getMultipleAccount|\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getProgramAccounts\0\0\0\0\0\0\0", 18) == KEYW_RPCMETHOD_GETPROGRAMACCOUNTS);
  assert(fd_webserver_json_keyword("getProgramAccountsx\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getProgramAccount\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etProgramAccounts\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tProgramAccounts\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|ProgramAccounts\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|rogramAccounts\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getP|ogramAccounts\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getPr|gramAccounts\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getPro|ramAccounts\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getProg|amAccounts\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getProgr|mAccounts\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getProgra|Accounts\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getProgram|ccounts\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getProgramA|counts\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getProgramAc|ounts\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getProgramAcc|unts\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getProgramAcco|nts\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getProgramAccou|ts\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getProgramAccoun|s\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getProgramAccount|\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecentBlockhash\0\0\0\0\0\0\0", 18) == KEYW_RPCMETHOD_GETRECENTBLOCKHASH);
  assert(fd_webserver_json_keyword("getRecentBlockhashx\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecentBlockhas\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etRecentBlockhash\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tRecentBlockhash\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|RecentBlockhash\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|ecentBlockhash\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getR|centBlockhash\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRe|entBlockhash\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRec|ntBlockhash\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRece|tBlockhash\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecen|Blockhash\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecent|lockhash\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecentB|ockhash\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecentBl|ckhash\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecentBlo|khash\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecentBloc|hash\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecentBlock|ash\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecentBlockh|sh\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecentBlockha|h\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecentBlockhas|\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecentPerformanceSamples\0\0\0\0\0\0\0", 27) == KEYW_RPCMETHOD_GETRECENTPERFORMANCESAMPLES);
  assert(fd_webserver_json_keyword("getRecentPerformanceSamplesx\0\0\0\0\0\0\0", 28) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecentPerformanceSample\0\0\0\0\0\0\0", 26) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etRecentPerformanceSamples\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tRecentPerformanceSamples\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|RecentPerformanceSamples\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|ecentPerformanceSamples\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getR|centPerformanceSamples\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRe|entPerformanceSamples\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRec|ntPerformanceSamples\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRece|tPerformanceSamples\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecen|PerformanceSamples\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecent|erformanceSamples\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecentP|rformanceSamples\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecentPe|formanceSamples\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecentPer|ormanceSamples\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecentPerf|rmanceSamples\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecentPerfo|manceSamples\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecentPerfor|anceSamples\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecentPerform|nceSamples\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecentPerforma|ceSamples\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecentPerforman|eSamples\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecentPerformanc|Samples\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecentPerformance|amples\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecentPerformanceS|mples\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecentPerformanceSa|ples\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecentPerformanceSam|les\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecentPerformanceSamp|es\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecentPerformanceSampl|s\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecentPerformanceSample|\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecentPrioritizationFees\0\0\0\0\0\0\0", 27) == KEYW_RPCMETHOD_GETRECENTPRIORITIZATIONFEES);
  assert(fd_webserver_json_keyword("getRecentPrioritizationFeesx\0\0\0\0\0\0\0", 28) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecentPrioritizationFee\0\0\0\0\0\0\0", 26) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etRecentPrioritizationFees\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tRecentPrioritizationFees\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|RecentPrioritizationFees\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|ecentPrioritizationFees\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getR|centPrioritizationFees\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRe|entPrioritizationFees\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRec|ntPrioritizationFees\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRece|tPrioritizationFees\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecen|PrioritizationFees\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecent|rioritizationFees\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecentP|ioritizationFees\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecentPr|oritizationFees\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecentPri|ritizationFees\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecentPrio|itizationFees\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecentPrior|tizationFees\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecentPriori|izationFees\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecentPriorit|zationFees\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecentPrioriti|ationFees\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecentPrioritiz|tionFees\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecentPrioritiza|ionFees\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecentPrioritizat|onFees\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecentPrioritizati|nFees\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecentPrioritizatio|Fees\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecentPrioritization|ees\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecentPrioritizationF|es\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecentPrioritizationFe|s\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getRecentPrioritizationFee|\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSignaturesForAddress\0\0\0\0\0\0\0", 23) == KEYW_RPCMETHOD_GETSIGNATURESFORADDRESS);
  assert(fd_webserver_json_keyword("getSignaturesForAddressx\0\0\0\0\0\0\0", 24) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSignaturesForAddres\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etSignaturesForAddress\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tSignaturesForAddress\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|SignaturesForAddress\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|ignaturesForAddress\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getS|gnaturesForAddress\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSi|naturesForAddress\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSig|aturesForAddress\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSign|turesForAddress\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSigna|uresForAddress\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSignat|resForAddress\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSignatu|esForAddress\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSignatur|sForAddress\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSignature|ForAddress\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSignatures|orAddress\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSignaturesF|rAddress\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSignaturesFo|Address\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSignaturesFor|ddress\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSignaturesForA|dress\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSignaturesForAd|ress\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSignaturesForAdd|ess\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSignaturesForAddr|ss\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSignaturesForAddre|s\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSignaturesForAddres|\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSignatureStatuses\0\0\0\0\0\0\0", 20) == KEYW_RPCMETHOD_GETSIGNATURESTATUSES);
  assert(fd_webserver_json_keyword("getSignatureStatusesx\0\0\0\0\0\0\0", 21) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSignatureStatuse\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etSignatureStatuses\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tSignatureStatuses\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|SignatureStatuses\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|ignatureStatuses\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getS|gnatureStatuses\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSi|natureStatuses\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSig|atureStatuses\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSign|tureStatuses\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSigna|ureStatuses\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSignat|reStatuses\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSignatu|eStatuses\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSignatur|Statuses\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSignature|tatuses\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSignatureS|atuses\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSignatureSt|tuses\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSignatureSta|uses\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSignatureStat|ses\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSignatureStatu|es\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSignatureStatus|s\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSignatureStatuse|\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSlot\0\0\0\0\0\0\0", 7) == KEYW_RPCMETHOD_GETSLOT);
  assert(fd_webserver_json_keyword("getSlotx\0\0\0\0\0\0\0", 8) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSlo\0\0\0\0\0\0\0", 6) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etSlot\0\0\0\0\0\0\0", 7) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tSlot\0\0\0\0\0\0\0", 7) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|Slot\0\0\0\0\0\0\0", 7) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|lot\0\0\0\0\0\0\0", 7) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getS|ot\0\0\0\0\0\0\0", 7) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSl|t\0\0\0\0\0\0\0", 7) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSlo|\0\0\0\0\0\0\0", 7) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSlotLeader\0\0\0\0\0\0\0", 13) == KEYW_RPCMETHOD_GETSLOTLEADER);
  assert(fd_webserver_json_keyword("getSlotLeaderx\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSlotLeade\0\0\0\0\0\0\0", 12) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etSlotLeader\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tSlotLeader\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|SlotLeader\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|lotLeader\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getS|otLeader\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSl|tLeader\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSlo|Leader\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSlot|eader\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSlotL|ader\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSlotLe|der\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSlotLea|er\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSlotLead|r\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSlotLeade|\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSlotLeaders\0\0\0\0\0\0\0", 14) == KEYW_RPCMETHOD_GETSLOTLEADERS);
  assert(fd_webserver_json_keyword("getSlotLeadersx\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etSlotLeaders\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tSlotLeaders\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|SlotLeaders\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|lotLeaders\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getS|otLeaders\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSl|tLeaders\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSlo|Leaders\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSlot|eaders\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSlotL|aders\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSlotLe|ders\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSlotLea|ers\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSlotLead|rs\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSlotLeade|s\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSlotLeader|\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSnapshotSlot\0\0\0\0\0\0\0", 15) == KEYW_RPCMETHOD_GETSNAPSHOTSLOT);
  assert(fd_webserver_json_keyword("getSnapshotSlotx\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSnapshotSlo\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etSnapshotSlot\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tSnapshotSlot\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|SnapshotSlot\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|napshotSlot\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getS|apshotSlot\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSn|pshotSlot\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSna|shotSlot\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSnap|hotSlot\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSnaps|otSlot\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSnapsh|tSlot\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSnapsho|Slot\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSnapshot|lot\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSnapshotS|ot\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSnapshotSl|t\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSnapshotSlo|\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getStakeActivation\0\0\0\0\0\0\0", 18) == KEYW_RPCMETHOD_GETSTAKEACTIVATION);
  assert(fd_webserver_json_keyword("getStakeActivationx\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getStakeActivatio\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etStakeActivation\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tStakeActivation\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|StakeActivation\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|takeActivation\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getS|akeActivation\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSt|keActivation\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSta|eActivation\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getStak|Activation\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getStake|ctivation\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getStakeA|tivation\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getStakeAc|ivation\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getStakeAct|vation\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getStakeActi|ation\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getStakeActiv|tion\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getStakeActiva|ion\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getStakeActivat|on\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getStakeActivati|n\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getStakeActivatio|\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getStakeMinimumDelegation\0\0\0\0\0\0\0", 25) == KEYW_RPCMETHOD_GETSTAKEMINIMUMDELEGATION);
  assert(fd_webserver_json_keyword("getStakeMinimumDelegationx\0\0\0\0\0\0\0", 26) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getStakeMinimumDelegatio\0\0\0\0\0\0\0", 24) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etStakeMinimumDelegation\0\0\0\0\0\0\0", 25) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tStakeMinimumDelegation\0\0\0\0\0\0\0", 25) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|StakeMinimumDelegation\0\0\0\0\0\0\0", 25) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|takeMinimumDelegation\0\0\0\0\0\0\0", 25) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getS|akeMinimumDelegation\0\0\0\0\0\0\0", 25) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSt|keMinimumDelegation\0\0\0\0\0\0\0", 25) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSta|eMinimumDelegation\0\0\0\0\0\0\0", 25) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getStak|MinimumDelegation\0\0\0\0\0\0\0", 25) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getStake|inimumDelegation\0\0\0\0\0\0\0", 25) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getStakeM|nimumDelegation\0\0\0\0\0\0\0", 25) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getStakeMi|imumDelegation\0\0\0\0\0\0\0", 25) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getStakeMin|mumDelegation\0\0\0\0\0\0\0", 25) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getStakeMini|umDelegation\0\0\0\0\0\0\0", 25) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getStakeMinim|mDelegation\0\0\0\0\0\0\0", 25) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getStakeMinimu|Delegation\0\0\0\0\0\0\0", 25) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getStakeMinimum|elegation\0\0\0\0\0\0\0", 25) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getStakeMinimumD|legation\0\0\0\0\0\0\0", 25) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getStakeMinimumDe|egation\0\0\0\0\0\0\0", 25) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getStakeMinimumDel|gation\0\0\0\0\0\0\0", 25) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getStakeMinimumDele|ation\0\0\0\0\0\0\0", 25) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getStakeMinimumDeleg|tion\0\0\0\0\0\0\0", 25) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getStakeMinimumDelega|ion\0\0\0\0\0\0\0", 25) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getStakeMinimumDelegat|on\0\0\0\0\0\0\0", 25) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getStakeMinimumDelegati|n\0\0\0\0\0\0\0", 25) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getStakeMinimumDelegatio|\0\0\0\0\0\0\0", 25) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSupply\0\0\0\0\0\0\0", 9) == KEYW_RPCMETHOD_GETSUPPLY);
  assert(fd_webserver_json_keyword("getSupplyx\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSuppl\0\0\0\0\0\0\0", 8) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etSupply\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tSupply\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|Supply\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|upply\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getS|pply\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSu|ply\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSup|ly\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSupp|y\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getSuppl|\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenAccountBalance\0\0\0\0\0\0\0", 22) == KEYW_RPCMETHOD_GETTOKENACCOUNTBALANCE);
  assert(fd_webserver_json_keyword("getTokenAccountBalancex\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenAccountBalanc\0\0\0\0\0\0\0", 21) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etTokenAccountBalance\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tTokenAccountBalance\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|TokenAccountBalance\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|okenAccountBalance\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getT|kenAccountBalance\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTo|enAccountBalance\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTok|nAccountBalance\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getToke|AccountBalance\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getToken|ccountBalance\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenA|countBalance\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenAc|ountBalance\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenAcc|untBalance\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenAcco|ntBalance\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenAccou|tBalance\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenAccoun|Balance\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenAccount|alance\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenAccountB|lance\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenAccountBa|ance\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenAccountBal|nce\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenAccountBala|ce\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenAccountBalan|e\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenAccountBalanc|\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenAccountsByDelegate\0\0\0\0\0\0\0", 26) == KEYW_RPCMETHOD_GETTOKENACCOUNTSBYDELEGATE);
  assert(fd_webserver_json_keyword("getTokenAccountsByDelegatex\0\0\0\0\0\0\0", 27) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenAccountsByDelegat\0\0\0\0\0\0\0", 25) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etTokenAccountsByDelegate\0\0\0\0\0\0\0", 26) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tTokenAccountsByDelegate\0\0\0\0\0\0\0", 26) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|TokenAccountsByDelegate\0\0\0\0\0\0\0", 26) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|okenAccountsByDelegate\0\0\0\0\0\0\0", 26) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getT|kenAccountsByDelegate\0\0\0\0\0\0\0", 26) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTo|enAccountsByDelegate\0\0\0\0\0\0\0", 26) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTok|nAccountsByDelegate\0\0\0\0\0\0\0", 26) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getToke|AccountsByDelegate\0\0\0\0\0\0\0", 26) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getToken|ccountsByDelegate\0\0\0\0\0\0\0", 26) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenA|countsByDelegate\0\0\0\0\0\0\0", 26) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenAc|ountsByDelegate\0\0\0\0\0\0\0", 26) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenAcc|untsByDelegate\0\0\0\0\0\0\0", 26) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenAcco|ntsByDelegate\0\0\0\0\0\0\0", 26) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenAccou|tsByDelegate\0\0\0\0\0\0\0", 26) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenAccoun|sByDelegate\0\0\0\0\0\0\0", 26) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenAccount|ByDelegate\0\0\0\0\0\0\0", 26) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenAccounts|yDelegate\0\0\0\0\0\0\0", 26) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenAccountsB|Delegate\0\0\0\0\0\0\0", 26) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenAccountsBy|elegate\0\0\0\0\0\0\0", 26) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenAccountsByD|legate\0\0\0\0\0\0\0", 26) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenAccountsByDe|egate\0\0\0\0\0\0\0", 26) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenAccountsByDel|gate\0\0\0\0\0\0\0", 26) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenAccountsByDele|ate\0\0\0\0\0\0\0", 26) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenAccountsByDeleg|te\0\0\0\0\0\0\0", 26) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenAccountsByDelega|e\0\0\0\0\0\0\0", 26) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenAccountsByDelegat|\0\0\0\0\0\0\0", 26) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenAccountsByOwner\0\0\0\0\0\0\0", 23) == KEYW_RPCMETHOD_GETTOKENACCOUNTSBYOWNER);
  assert(fd_webserver_json_keyword("getTokenAccountsByOwnerx\0\0\0\0\0\0\0", 24) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenAccountsByOwne\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etTokenAccountsByOwner\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tTokenAccountsByOwner\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|TokenAccountsByOwner\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|okenAccountsByOwner\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getT|kenAccountsByOwner\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTo|enAccountsByOwner\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTok|nAccountsByOwner\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getToke|AccountsByOwner\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getToken|ccountsByOwner\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenA|countsByOwner\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenAc|ountsByOwner\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenAcc|untsByOwner\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenAcco|ntsByOwner\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenAccou|tsByOwner\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenAccoun|sByOwner\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenAccount|ByOwner\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenAccounts|yOwner\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenAccountsB|Owner\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenAccountsBy|wner\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenAccountsByO|ner\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenAccountsByOw|er\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenAccountsByOwn|r\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenAccountsByOwne|\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenLargestAccounts\0\0\0\0\0\0\0", 23) == KEYW_RPCMETHOD_GETTOKENLARGESTACCOUNTS);
  assert(fd_webserver_json_keyword("getTokenLargestAccountsx\0\0\0\0\0\0\0", 24) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenLargestAccount\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etTokenLargestAccounts\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tTokenLargestAccounts\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|TokenLargestAccounts\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|okenLargestAccounts\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getT|kenLargestAccounts\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTo|enLargestAccounts\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTok|nLargestAccounts\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getToke|LargestAccounts\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getToken|argestAccounts\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenL|rgestAccounts\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenLa|gestAccounts\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenLar|estAccounts\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenLarg|stAccounts\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenLarge|tAccounts\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenLarges|Accounts\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenLargest|ccounts\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenLargestA|counts\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenLargestAc|ounts\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenLargestAcc|unts\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenLargestAcco|nts\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenLargestAccou|ts\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenLargestAccoun|s\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenLargestAccount|\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenSupply\0\0\0\0\0\0\0", 14) == KEYW_RPCMETHOD_GETTOKENSUPPLY);
  assert(fd_webserver_json_keyword("getTokenSupplyx\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenSuppl\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etTokenSupply\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tTokenSupply\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|TokenSupply\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|okenSupply\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getT|kenSupply\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTo|enSupply\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTok|nSupply\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getToke|Supply\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getToken|upply\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenS|pply\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenSu|ply\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenSup|ly\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenSupp|y\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTokenSuppl|\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTransaction\0\0\0\0\0\0\0", 14) == KEYW_RPCMETHOD_GETTRANSACTION);
  assert(fd_webserver_json_keyword("getTransactionx\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTransactio\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etTransaction\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tTransaction\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|Transaction\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|ransaction\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getT|ansaction\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTr|nsaction\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTra|saction\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTran|action\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTrans|ction\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTransa|tion\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTransac|ion\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTransact|on\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTransacti|n\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTransactio|\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTransactionCount\0\0\0\0\0\0\0", 19) == KEYW_RPCMETHOD_GETTRANSACTIONCOUNT);
  assert(fd_webserver_json_keyword("getTransactionCountx\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTransactionCoun\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etTransactionCount\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tTransactionCount\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|TransactionCount\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|ransactionCount\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getT|ansactionCount\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTr|nsactionCount\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTra|sactionCount\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTran|actionCount\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTrans|ctionCount\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTransa|tionCount\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTransac|ionCount\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTransact|onCount\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTransacti|nCount\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTransactio|Count\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTransaction|ount\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTransactionC|unt\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTransactionCo|nt\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTransactionCou|t\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getTransactionCoun|\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getVersion\0\0\0\0\0\0\0", 10) == KEYW_RPCMETHOD_GETVERSION);
  assert(fd_webserver_json_keyword("getVersionx\0\0\0\0\0\0\0", 11) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getVersio\0\0\0\0\0\0\0", 9) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etVersion\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tVersion\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|Version\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|ersion\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getV|rsion\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getVe|sion\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getVer|ion\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getVers|on\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getVersi|n\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getVersio|\0\0\0\0\0\0\0", 10) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getVoteAccounts\0\0\0\0\0\0\0", 15) == KEYW_RPCMETHOD_GETVOTEACCOUNTS);
  assert(fd_webserver_json_keyword("getVoteAccountsx\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getVoteAccount\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|etVoteAccounts\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("g|tVoteAccounts\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ge|VoteAccounts\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("get|oteAccounts\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getV|teAccounts\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getVo|eAccounts\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getVot|Accounts\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getVote|ccounts\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getVoteA|counts\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getVoteAc|ounts\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getVoteAcc|unts\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getVoteAcco|nts\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getVoteAccou|ts\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getVoteAccoun|s\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("getVoteAccount|\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("isBlockhashValid\0\0\0\0\0\0\0", 16) == KEYW_RPCMETHOD_ISBLOCKHASHVALID);
  assert(fd_webserver_json_keyword("isBlockhashValidx\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("isBlockhashVali\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|sBlockhashValid\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("i|BlockhashValid\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("is|lockhashValid\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("isB|ockhashValid\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("isBl|ckhashValid\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("isBlo|khashValid\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("isBloc|hashValid\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("isBlock|ashValid\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("isBlockh|shValid\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("isBlockha|hValid\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("isBlockhas|Valid\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("isBlockhash|alid\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("isBlockhashV|lid\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("isBlockhashVa|id\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("isBlockhashVal|d\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("isBlockhashVali|\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("minimumLedgerSlot\0\0\0\0\0\0\0", 17) == KEYW_RPCMETHOD_MINIMUMLEDGERSLOT);
  assert(fd_webserver_json_keyword("minimumLedgerSlotx\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("minimumLedgerSlo\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|inimumLedgerSlot\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("m|nimumLedgerSlot\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("mi|imumLedgerSlot\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("min|mumLedgerSlot\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("mini|umLedgerSlot\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("minim|mLedgerSlot\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("minimu|LedgerSlot\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("minimum|edgerSlot\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("minimumL|dgerSlot\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("minimumLe|gerSlot\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("minimumLed|erSlot\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("minimumLedg|rSlot\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("minimumLedge|Slot\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("minimumLedger|lot\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("minimumLedgerS|ot\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("minimumLedgerSl|t\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("minimumLedgerSlo|\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("requestAirdrop\0\0\0\0\0\0\0", 14) == KEYW_RPCMETHOD_REQUESTAIRDROP);
  assert(fd_webserver_json_keyword("requestAirdropx\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("requestAirdro\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|equestAirdrop\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("r|questAirdrop\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("re|uestAirdrop\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("req|estAirdrop\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("requ|stAirdrop\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("reque|tAirdrop\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("reques|Airdrop\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("request|irdrop\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("requestA|rdrop\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("requestAi|drop\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("requestAir|rop\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("requestAird|op\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("requestAirdr|p\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("requestAirdro|\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("sendTransaction\0\0\0\0\0\0\0", 15) == KEYW_RPCMETHOD_SENDTRANSACTION);
  assert(fd_webserver_json_keyword("sendTransactionx\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("sendTransactio\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|endTransaction\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("s|ndTransaction\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("se|dTransaction\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("sen|Transaction\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("send|ransaction\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("sendT|ansaction\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("sendTr|nsaction\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("sendTra|saction\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("sendTran|action\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("sendTrans|ction\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("sendTransa|tion\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("sendTransac|ion\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("sendTransact|on\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("sendTransacti|n\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("sendTransactio|\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("simulateTransaction\0\0\0\0\0\0\0", 19) == KEYW_RPCMETHOD_SIMULATETRANSACTION);
  assert(fd_webserver_json_keyword("simulateTransactionx\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("simulateTransactio\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|imulateTransaction\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("s|mulateTransaction\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("si|ulateTransaction\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("sim|lateTransaction\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("simu|ateTransaction\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("simul|teTransaction\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("simula|eTransaction\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("simulat|Transaction\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("simulate|ransaction\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("simulateT|ansaction\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("simulateTr|nsaction\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("simulateTra|saction\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("simulateTran|action\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("simulateTrans|ction\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("simulateTransa|tion\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("simulateTransac|ion\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("simulateTransact|on\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("simulateTransacti|n\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("simulateTransactio|\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("accountSubscribe\0\0\0\0\0\0\0", 16) == KEYW_WS_METHOD_ACCOUNTSUBSCRIBE);
  assert(fd_webserver_json_keyword("accountSubscribex\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("accountSubscrib\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|ccountSubscribe\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("a|countSubscribe\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ac|ountSubscribe\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("acc|untSubscribe\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("acco|ntSubscribe\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("accou|tSubscribe\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("accoun|Subscribe\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("account|ubscribe\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("accountS|bscribe\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("accountSu|scribe\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("accountSub|cribe\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("accountSubs|ribe\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("accountSubsc|ibe\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("accountSubscr|be\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("accountSubscri|e\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("accountSubscrib|\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("accountUnsubscribe\0\0\0\0\0\0\0", 18) == KEYW_WS_METHOD_ACCOUNTUNSUBSCRIBE);
  assert(fd_webserver_json_keyword("accountUnsubscribex\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("accountUnsubscrib\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|ccountUnsubscribe\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("a|countUnsubscribe\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ac|ountUnsubscribe\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("acc|untUnsubscribe\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("acco|ntUnsubscribe\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("accou|tUnsubscribe\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("accoun|Unsubscribe\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("account|nsubscribe\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("accountU|subscribe\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("accountUn|ubscribe\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("accountUns|bscribe\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("accountUnsu|scribe\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("accountUnsub|cribe\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("accountUnsubs|ribe\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("accountUnsubsc|ibe\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("accountUnsubscr|be\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("accountUnsubscri|e\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("accountUnsubscrib|\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("blockSubscribe\0\0\0\0\0\0\0", 14) == KEYW_WS_METHOD_BLOCKSUBSCRIBE);
  assert(fd_webserver_json_keyword("blockSubscribex\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("blockSubscrib\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|lockSubscribe\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("b|ockSubscribe\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("bl|ckSubscribe\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("blo|kSubscribe\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("bloc|Subscribe\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("block|ubscribe\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("blockS|bscribe\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("blockSu|scribe\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("blockSub|cribe\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("blockSubs|ribe\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("blockSubsc|ibe\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("blockSubscr|be\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("blockSubscri|e\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("blockSubscrib|\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("blockUnsubscribe\0\0\0\0\0\0\0", 16) == KEYW_WS_METHOD_BLOCKUNSUBSCRIBE);
  assert(fd_webserver_json_keyword("blockUnsubscribex\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("blockUnsubscrib\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|lockUnsubscribe\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("b|ockUnsubscribe\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("bl|ckUnsubscribe\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("blo|kUnsubscribe\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("bloc|Unsubscribe\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("block|nsubscribe\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("blockU|subscribe\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("blockUn|ubscribe\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("blockUns|bscribe\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("blockUnsu|scribe\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("blockUnsub|cribe\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("blockUnsubs|ribe\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("blockUnsubsc|ibe\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("blockUnsubscr|be\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("blockUnsubscri|e\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("blockUnsubscrib|\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("logsSubscribe\0\0\0\0\0\0\0", 13) == KEYW_WS_METHOD_LOGSSUBSCRIBE);
  assert(fd_webserver_json_keyword("logsSubscribex\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("logsSubscrib\0\0\0\0\0\0\0", 12) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|ogsSubscribe\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("l|gsSubscribe\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("lo|sSubscribe\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("log|Subscribe\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("logs|ubscribe\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("logsS|bscribe\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("logsSu|scribe\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("logsSub|cribe\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("logsSubs|ribe\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("logsSubsc|ibe\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("logsSubscr|be\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("logsSubscri|e\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("logsSubscrib|\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("logsUnsubscribe\0\0\0\0\0\0\0", 15) == KEYW_WS_METHOD_LOGSUNSUBSCRIBE);
  assert(fd_webserver_json_keyword("logsUnsubscribex\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("logsUnsubscrib\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|ogsUnsubscribe\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("l|gsUnsubscribe\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("lo|sUnsubscribe\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("log|Unsubscribe\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("logs|nsubscribe\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("logsU|subscribe\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("logsUn|ubscribe\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("logsUns|bscribe\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("logsUnsu|scribe\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("logsUnsub|cribe\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("logsUnsubs|ribe\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("logsUnsubsc|ibe\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("logsUnsubscr|be\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("logsUnsubscri|e\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("logsUnsubscrib|\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("programSubscribe\0\0\0\0\0\0\0", 16) == KEYW_WS_METHOD_PROGRAMSUBSCRIBE);
  assert(fd_webserver_json_keyword("programSubscribex\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("programSubscrib\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|rogramSubscribe\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("p|ogramSubscribe\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("pr|gramSubscribe\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("pro|ramSubscribe\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("prog|amSubscribe\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("progr|mSubscribe\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("progra|Subscribe\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("program|ubscribe\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("programS|bscribe\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("programSu|scribe\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("programSub|cribe\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("programSubs|ribe\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("programSubsc|ibe\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("programSubscr|be\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("programSubscri|e\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("programSubscrib|\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("programUnsubscribe\0\0\0\0\0\0\0", 18) == KEYW_WS_METHOD_PROGRAMUNSUBSCRIBE);
  assert(fd_webserver_json_keyword("programUnsubscribex\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("programUnsubscrib\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|rogramUnsubscribe\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("p|ogramUnsubscribe\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("pr|gramUnsubscribe\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("pro|ramUnsubscribe\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("prog|amUnsubscribe\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("progr|mUnsubscribe\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("progra|Unsubscribe\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("program|nsubscribe\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("programU|subscribe\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("programUn|ubscribe\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("programUns|bscribe\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("programUnsu|scribe\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("programUnsub|cribe\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("programUnsubs|ribe\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("programUnsubsc|ibe\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("programUnsubscr|be\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("programUnsubscri|e\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("programUnsubscrib|\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("rootSubscribe\0\0\0\0\0\0\0", 13) == KEYW_WS_METHOD_ROOTSUBSCRIBE);
  assert(fd_webserver_json_keyword("rootSubscribex\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("rootSubscrib\0\0\0\0\0\0\0", 12) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|ootSubscribe\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("r|otSubscribe\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ro|tSubscribe\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("roo|Subscribe\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("root|ubscribe\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("rootS|bscribe\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("rootSu|scribe\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("rootSub|cribe\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("rootSubs|ribe\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("rootSubsc|ibe\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("rootSubscr|be\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("rootSubscri|e\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("rootSubscrib|\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("rootUnsubscribe\0\0\0\0\0\0\0", 15) == KEYW_WS_METHOD_ROOTUNSUBSCRIBE);
  assert(fd_webserver_json_keyword("rootUnsubscribex\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("rootUnsubscrib\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|ootUnsubscribe\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("r|otUnsubscribe\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("ro|tUnsubscribe\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("roo|Unsubscribe\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("root|nsubscribe\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("rootU|subscribe\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("rootUn|ubscribe\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("rootUns|bscribe\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("rootUnsu|scribe\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("rootUnsub|cribe\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("rootUnsubs|ribe\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("rootUnsubsc|ibe\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("rootUnsubscr|be\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("rootUnsubscri|e\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("rootUnsubscrib|\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("signatureSubscribe\0\0\0\0\0\0\0", 18) == KEYW_WS_METHOD_SIGNATURESUBSCRIBE);
  assert(fd_webserver_json_keyword("signatureSubscribex\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("signatureSubscrib\0\0\0\0\0\0\0", 17) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|ignatureSubscribe\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("s|gnatureSubscribe\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("si|natureSubscribe\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("sig|atureSubscribe\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("sign|tureSubscribe\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("signa|ureSubscribe\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("signat|reSubscribe\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("signatu|eSubscribe\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("signatur|Subscribe\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("signature|ubscribe\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("signatureS|bscribe\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("signatureSu|scribe\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("signatureSub|cribe\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("signatureSubs|ribe\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("signatureSubsc|ibe\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("signatureSubscr|be\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("signatureSubscri|e\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("signatureSubscrib|\0\0\0\0\0\0\0", 18) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("signatureUnsubscribe\0\0\0\0\0\0\0", 20) == KEYW_WS_METHOD_SIGNATUREUNSUBSCRIBE);
  assert(fd_webserver_json_keyword("signatureUnsubscribex\0\0\0\0\0\0\0", 21) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("signatureUnsubscrib\0\0\0\0\0\0\0", 19) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|ignatureUnsubscribe\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("s|gnatureUnsubscribe\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("si|natureUnsubscribe\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("sig|atureUnsubscribe\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("sign|tureUnsubscribe\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("signa|ureUnsubscribe\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("signat|reUnsubscribe\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("signatu|eUnsubscribe\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("signatur|Unsubscribe\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("signature|nsubscribe\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("signatureU|subscribe\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("signatureUn|ubscribe\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("signatureUns|bscribe\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("signatureUnsu|scribe\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("signatureUnsub|cribe\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("signatureUnsubs|ribe\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("signatureUnsubsc|ibe\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("signatureUnsubscr|be\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("signatureUnsubscri|e\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("signatureUnsubscrib|\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotSubscribe\0\0\0\0\0\0\0", 13) == KEYW_WS_METHOD_SLOTSUBSCRIBE);
  assert(fd_webserver_json_keyword("slotSubscribex\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotSubscrib\0\0\0\0\0\0\0", 12) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|lotSubscribe\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("s|otSubscribe\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("sl|tSubscribe\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slo|Subscribe\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slot|ubscribe\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotS|bscribe\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotSu|scribe\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotSub|cribe\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotSubs|ribe\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotSubsc|ibe\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotSubscr|be\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotSubscri|e\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotSubscrib|\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotUnsubscribe\0\0\0\0\0\0\0", 15) == KEYW_WS_METHOD_SLOTUNSUBSCRIBE);
  assert(fd_webserver_json_keyword("slotUnsubscribex\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotUnsubscrib\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|lotUnsubscribe\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("s|otUnsubscribe\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("sl|tUnsubscribe\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slo|Unsubscribe\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slot|nsubscribe\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotU|subscribe\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotUn|ubscribe\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotUns|bscribe\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotUnsu|scribe\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotUnsub|cribe\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotUnsubs|ribe\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotUnsubsc|ibe\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotUnsubscr|be\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotUnsubscri|e\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotUnsubscrib|\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotsUpdatesSubscribe\0\0\0\0\0\0\0", 21) == KEYW_WS_METHOD_SLOTSUPDATESSUBSCRIBE);
  assert(fd_webserver_json_keyword("slotsUpdatesSubscribex\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotsUpdatesSubscrib\0\0\0\0\0\0\0", 20) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|lotsUpdatesSubscribe\0\0\0\0\0\0\0", 21) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("s|otsUpdatesSubscribe\0\0\0\0\0\0\0", 21) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("sl|tsUpdatesSubscribe\0\0\0\0\0\0\0", 21) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slo|sUpdatesSubscribe\0\0\0\0\0\0\0", 21) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slot|UpdatesSubscribe\0\0\0\0\0\0\0", 21) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slots|pdatesSubscribe\0\0\0\0\0\0\0", 21) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotsU|datesSubscribe\0\0\0\0\0\0\0", 21) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotsUp|atesSubscribe\0\0\0\0\0\0\0", 21) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotsUpd|tesSubscribe\0\0\0\0\0\0\0", 21) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotsUpda|esSubscribe\0\0\0\0\0\0\0", 21) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotsUpdat|sSubscribe\0\0\0\0\0\0\0", 21) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotsUpdate|Subscribe\0\0\0\0\0\0\0", 21) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotsUpdates|ubscribe\0\0\0\0\0\0\0", 21) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotsUpdatesS|bscribe\0\0\0\0\0\0\0", 21) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotsUpdatesSu|scribe\0\0\0\0\0\0\0", 21) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotsUpdatesSub|cribe\0\0\0\0\0\0\0", 21) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotsUpdatesSubs|ribe\0\0\0\0\0\0\0", 21) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotsUpdatesSubsc|ibe\0\0\0\0\0\0\0", 21) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotsUpdatesSubscr|be\0\0\0\0\0\0\0", 21) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotsUpdatesSubscri|e\0\0\0\0\0\0\0", 21) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotsUpdatesSubscrib|\0\0\0\0\0\0\0", 21) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotsUpdatesUnsubscribe\0\0\0\0\0\0\0", 23) == KEYW_WS_METHOD_SLOTSUPDATESUNSUBSCRIBE);
  assert(fd_webserver_json_keyword("slotsUpdatesUnsubscribex\0\0\0\0\0\0\0", 24) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotsUpdatesUnsubscrib\0\0\0\0\0\0\0", 22) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|lotsUpdatesUnsubscribe\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("s|otsUpdatesUnsubscribe\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("sl|tsUpdatesUnsubscribe\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slo|sUpdatesUnsubscribe\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slot|UpdatesUnsubscribe\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slots|pdatesUnsubscribe\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotsU|datesUnsubscribe\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotsUp|atesUnsubscribe\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotsUpd|tesUnsubscribe\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotsUpda|esUnsubscribe\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotsUpdat|sUnsubscribe\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotsUpdate|Unsubscribe\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotsUpdates|nsubscribe\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotsUpdatesU|subscribe\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotsUpdatesUn|ubscribe\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotsUpdatesUns|bscribe\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotsUpdatesUnsu|scribe\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotsUpdatesUnsub|cribe\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotsUpdatesUnsubs|ribe\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotsUpdatesUnsubsc|ibe\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotsUpdatesUnsubscr|be\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotsUpdatesUnsubscri|e\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("slotsUpdatesUnsubscrib|\0\0\0\0\0\0\0", 23) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("voteSubscribe\0\0\0\0\0\0\0", 13) == KEYW_WS_METHOD_VOTESUBSCRIBE);
  assert(fd_webserver_json_keyword("voteSubscribex\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("voteSubscrib\0\0\0\0\0\0\0", 12) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|oteSubscribe\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("v|teSubscribe\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("vo|eSubscribe\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("vot|Subscribe\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("vote|ubscribe\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("voteS|bscribe\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("voteSu|scribe\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("voteSub|cribe\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("voteSubs|ribe\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("voteSubsc|ibe\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("voteSubscr|be\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("voteSubscri|e\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("voteSubscrib|\0\0\0\0\0\0\0", 13) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("voteUnsubscribe\0\0\0\0\0\0\0", 15) == KEYW_WS_METHOD_VOTEUNSUBSCRIBE);
  assert(fd_webserver_json_keyword("voteUnsubscribex\0\0\0\0\0\0\0", 16) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("voteUnsubscrib\0\0\0\0\0\0\0", 14) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("|oteUnsubscribe\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("v|teUnsubscribe\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("vo|eUnsubscribe\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("vot|Unsubscribe\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("vote|nsubscribe\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("voteU|subscribe\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("voteUn|ubscribe\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("voteUns|bscribe\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("voteUnsu|scribe\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("voteUnsub|cribe\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("voteUnsubs|ribe\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("voteUnsubsc|ibe\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("voteUnsubscr|be\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("voteUnsubscri|e\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
  assert(fd_webserver_json_keyword("voteUnsubscrib|\0\0\0\0\0\0\0", 15) == KEYW_UNKNOWN);
}
