#include "fd_x509_mock.h"
#include "../../util/fd_util.h"

int
main( int     argc,
      char ** argv ) {
  fd_boot( &argc, &argv );

  fd_rng_t _rng[1]; fd_rng_t * rng = fd_rng_join( fd_rng_new( _rng, 0U, 0UL ) );

  /* Test v1 */

  static uchar const cert_v1_1[] = {
    0x30, 0x81, 0xf6, 0x30, 0x81, 0xa9, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x08, 0x4c, 0x74, 0xcd,
    0x65, 0x33, 0x18, 0x6d, 0x97, 0x30, 0x05, 0x06, 0x03, 0x2b, 0x65, 0x70, 0x30, 0x16, 0x31, 0x14,
    0x30, 0x12, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x0b, 0x53, 0x6f, 0x6c, 0x61, 0x6e, 0x61, 0x20,
    0x6e, 0x6f, 0x64, 0x65, 0x30, 0x20, 0x17, 0x0d, 0x37, 0x35, 0x30, 0x31, 0x30, 0x31, 0x30, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x34, 0x30, 0x39, 0x36, 0x30, 0x31, 0x30, 0x31, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x30, 0x16, 0x31, 0x14, 0x30, 0x12, 0x06, 0x03, 0x55, 0x04,
    0x03, 0x0c, 0x0b, 0x53, 0x6f, 0x6c, 0x61, 0x6e, 0x61, 0x20, 0x6e, 0x6f, 0x64, 0x65, 0x30, 0x2a,
    0x30, 0x05, 0x06, 0x03, 0x2b, 0x65, 0x70, 0x03, 0x21, 0x00, 0x7f, 0xa5, 0xfc, 0xa7, 0x49, 0x59,
    0xef, 0xe4, 0xcb, 0xa1, 0xbb, 0x72, 0xd1, 0xf9, 0xf6, 0x73, 0x09, 0x06, 0x1b, 0x44, 0xbf, 0x50,
    0x88, 0x50, 0x57, 0x0b, 0x64, 0x72, 0x7f, 0x03, 0x85, 0xf9, 0xa3, 0x13, 0x30, 0x11, 0x30, 0x0f,
    0x06, 0x03, 0x55, 0x1d, 0x11, 0x04, 0x08, 0x30, 0x06, 0x87, 0x04, 0x00, 0x00, 0x00, 0x00, 0x30,
    0x05, 0x06, 0x03, 0x2b, 0x65, 0x70, 0x03, 0x41, 0x00, 0xe2, 0x64, 0x18, 0xe1, 0x95, 0x31, 0xfa,
    0xd3, 0x2b, 0xa1, 0x28, 0x12, 0xf6, 0x21, 0x19, 0xa6, 0xaf, 0xa8, 0xb8, 0xf1, 0xfe, 0xd4, 0x3b,
    0x9f, 0x31, 0x5f, 0x2f, 0x1a, 0x88, 0x2f, 0xd7, 0x7b, 0x58, 0x1c, 0xab, 0x5d, 0xaf, 0xa4, 0x93,
    0x00, 0xd7, 0xa2, 0x7b, 0x26, 0xfd, 0x73, 0xfc, 0x28, 0x6a, 0xa0, 0x29, 0x43, 0x8c, 0x96, 0x8b,
    0x34, 0x75, 0xd1, 0xdc, 0x94, 0x2a, 0x1a, 0xc1, 0x08
  };
  uchar const * pubkey = fd_x509_mock_pubkey( cert_v1_1, FD_X509_MOCK_CERT_SZ );
  FD_TEST( pubkey && pubkey - cert_v1_1 == 122 );

  static uchar const cert_v1_2[] = {
    0x30, 0x81, 0xf7, 0x30, 0x81, 0xaa, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x09, 0x00, 0xac, 0x9f,
    0x97, 0x50, 0x7d, 0x51, 0x00, 0xcf, 0x30, 0x05, 0x06, 0x03, 0x2b, 0x65, 0x70, 0x30, 0x16, 0x31,
    0x14, 0x30, 0x12, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0c, 0x0b, 0x53, 0x6f, 0x6c, 0x61, 0x6e, 0x61,
    0x20, 0x6e, 0x6f, 0x64, 0x65, 0x30, 0x20, 0x17, 0x0d, 0x37, 0x35, 0x30, 0x31, 0x30, 0x31, 0x30,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x18, 0x0f, 0x34, 0x30, 0x39, 0x36, 0x30, 0x31, 0x30, 0x31,
    0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x30, 0x16, 0x31, 0x14, 0x30, 0x12, 0x06, 0x03, 0x55,
    0x04, 0x03, 0x0c, 0x0b, 0x53, 0x6f, 0x6c, 0x61, 0x6e, 0x61, 0x20, 0x6e, 0x6f, 0x64, 0x65, 0x30,
    0x2a, 0x30, 0x05, 0x06, 0x03, 0x2b, 0x65, 0x70, 0x03, 0x21, 0x00, 0x09, 0x84, 0x85, 0x03, 0x61,
    0x39, 0x98, 0x75, 0x96, 0x06, 0xad, 0x52, 0x88, 0xb1, 0xb0, 0xf5, 0x57, 0xd5, 0xbd, 0x5a, 0x30,
    0x90, 0x39, 0x87, 0x82, 0xf7, 0x3d, 0xc1, 0x60, 0x30, 0xb2, 0x77, 0xa3, 0x13, 0x30, 0x11, 0x30,
    0x0f, 0x06, 0x03, 0x55, 0x1d, 0x11, 0x04, 0x08, 0x30, 0x06, 0x87, 0x04, 0x00, 0x00, 0x00, 0x00,
    0x30, 0x05, 0x06, 0x03, 0x2b, 0x65, 0x70, 0x03, 0x41, 0x00, 0x37, 0x2b, 0x28, 0x62, 0x29, 0x5a,
    0x37, 0x2e, 0x74, 0x74, 0x14, 0x1d, 0x80, 0x43, 0x63, 0xa1, 0x3a, 0x1d, 0x4f, 0xb4, 0x0a, 0x4f,
    0x45, 0x0f, 0x96, 0xe7, 0xb5, 0xdb, 0xc5, 0x18, 0xa9, 0x7f, 0x78, 0xe8, 0xea, 0x19, 0x8a, 0x34,
    0xa3, 0x3d, 0x90, 0x62, 0xe7, 0x6d, 0x8b, 0x19, 0x4a, 0xc0, 0x1f, 0xa1, 0x19, 0x7e, 0xf8, 0xaa,
    0x92, 0x0c, 0xef, 0xb4, 0x98, 0x2f, 0xa0, 0x9f, 0xfc, 0x03
  };
  pubkey = fd_x509_mock_pubkey( cert_v1_2, FD_X509_MOCK_CERT_SZ );
  FD_TEST( pubkey && pubkey - cert_v1_2 == 123 );

  /* Test out-of-bounds key */
  for( ulong j=0UL; j<32UL; j++ ) {
    FD_TEST( !fd_x509_mock_pubkey( cert_v1_2, 123+j ) );
  }
  FD_TEST( fd_x509_mock_pubkey( cert_v1_2, 123+32 ) );

  /* Test v2 */

  for( ulong j=0UL; j<100000UL; j++ ) {

    /* Params */
    uchar public_key[ 32 ];
    for( ulong j=0UL; j<32UL; j++ ) public_key[ j ] = fd_rng_uchar( rng );
    ulong hash = fd_hash( 0UL, public_key, 32UL );

    /* Generate certificate */
    uchar cert[ FD_X509_MOCK_CERT_SZ ];
    fd_x509_mock_cert( cert, public_key );

    /* Ensure pubkey matches */
    FD_TEST( fd_hash( 0UL, public_key, 32UL )==hash );  /* orig same */
    uchar const * extracted = fd_x509_mock_pubkey( cert, FD_X509_MOCK_CERT_SZ );
    FD_TEST( 0==memcmp( extracted, public_key, 32UL ) );  /* extract same */

    for( ulong k=0UL; k<64UL; k++ ) {

      /* Corrupt some bytes */
      uint off = fd_rng_uint_roll( rng, FD_X509_MOCK_CERT_SZ );
      uint val = fd_rng_uchar( rng );
      cert[ off ] = (uchar)( cert[ off ] ^ val );
      extracted = fd_x509_mock_pubkey( cert, FD_X509_MOCK_CERT_SZ );

      /* Extraction must fail if we flipped a bit in the template */
      FD_TEST( (!extracted) == ( ( (off<0x64) | (off>=0x84) ) & (!!val) ) );
      cert[ off ] = (uchar)( cert[ off ] ^ val );

    }

  }

  fd_rng_delete( fd_rng_leave( rng ) );

  FD_LOG_NOTICE(( "pass" ));
  fd_halt();
  return 0;
}
