#ifndef HEADER_fd_src_ballet_sbpf_fd_sbpf_opcodes_h
#define HEADER_fd_src_ballet_sbpf_fd_sbpf_opcodes_h

#include "../../util/fd_util.h"

/* Register shortcut macros */
#define FD_SBPF_R0   (0)
#define FD_SBPF_R1   (1)
#define FD_SBPF_R2   (2)
#define FD_SBPF_R3   (3)
#define FD_SBPF_R4   (4)
#define FD_SBPF_R5   (5)
#define FD_SBPF_R6   (6)
#define FD_SBPF_R7   (7)
#define FD_SBPF_R8   (8)
#define FD_SBPF_R9   (9)
#define FD_SBPF_R10  (10)

/* Opcode related macros. The following are many macros used for the construction of BPF opcodes */

/* Opcode classes */
#define FD_SBPF_OPCODE_CLASS_LD    (0x0) /* (0b000) */
#define FD_SBPF_OPCODE_CLASS_LDX   (0x1) /* (0b001) */
#define FD_SBPF_OPCODE_CLASS_ST    (0x2) /* (0b010) */
#define FD_SBPF_OPCODE_CLASS_STX   (0x3) /* (0b011) */
#define FD_SBPF_OPCODE_CLASS_ALU   (0x4) /* (0b100) */
#define FD_SBPF_OPCODE_CLASS_JMP   (0x5) /* (0b101) */
#define FD_SBPF_OPCODE_CLASS_JMP32 (0x6) /* (0b110) */ /* eBPF only, in classic BPF this is RET */
#define FD_SBPF_OPCODE_CLASS_ALU64 (0x7) /* (0b111) */ /* eBPF only, in classic BPF this is MISC */

/* Source modes (only ALU, JMP, and ALU64 opcodes) */
#define FD_SBPF_OPCODE_SOURCE_MODE_NO_SOURCE (0x0) /* (0b0) */
#define FD_SBPF_OPCODE_SOURCE_MODE_UNARY_IMM (0x0) /* (0b0) */
#define FD_SBPF_OPCODE_SOURCE_MODE_UNARY_REG (0x0) /* (0b0) */
#define FD_SBPF_OPCODE_SOURCE_MODE_IMM       (0x0) /* (0b0) */
#define FD_SBPF_OPCODE_SOURCE_MODE_REG       (0x1) /* (0b1) */

#define FD_SBPF_OPCODE_END_MODE_HOST_TO_LE (0x0) /* (0b0) */
#define FD_SBPF_OPCODE_END_MODE_HOST_TO_BE (0x1) /* (0b1) */

/* Size modes (only LD, LDX, ST, and STX opcodes) */
#define FD_SBPF_OPCODE_SIZE_MODE_WORD (0x0) /* (0b00) */
#define FD_SBPF_OPCODE_SIZE_MODE_HALF (0x1) /* (0b01) */
#define FD_SBPF_OPCODE_SIZE_MODE_BYTE (0x2) /* (0b10) */
#define FD_SBPF_OPCODE_SIZE_MODE_DOUB (0x3) /* (0b11) */ /* eBPF only */

#define FD_SBPF_OPCODE_ALU_OP_MODE_ADD   (0x0) /* (0b0000) */
#define FD_SBPF_OPCODE_ALU_OP_MODE_SUB   (0x1) /* (0b0001) */
#define FD_SBPF_OPCODE_ALU_OP_MODE_MUL   (0x2) /* (0b0010) */
#define FD_SBPF_OPCODE_ALU_OP_MODE_DIV   (0x3) /* (0b0011) */
#define FD_SBPF_OPCODE_ALU_OP_MODE_OR    (0x4) /* (0b0100) */
#define FD_SBPF_OPCODE_ALU_OP_MODE_AND   (0x5) /* (0b0101) */
#define FD_SBPF_OPCODE_ALU_OP_MODE_LSH   (0x6) /* (0b0110) */
#define FD_SBPF_OPCODE_ALU_OP_MODE_RSH   (0x7) /* (0b0111) */
#define FD_SBPF_OPCODE_ALU_OP_MODE_NEG   (0x8) /* (0b1000) */
#define FD_SBPF_OPCODE_ALU_OP_MODE_MOD   (0x9) /* (0b1001) */
#define FD_SBPF_OPCODE_ALU_OP_MODE_XOR   (0xA) /* (0b1010) */
#define FD_SBPF_OPCODE_ALU_OP_MODE_MOV   (0xB) /* (0b1011) */ /* eBPF only */
#define FD_SBPF_OPCODE_ALU_OP_MODE_ARSH  (0xC) /* (0b1100) */ /* eBPF only */
#define FD_SBPF_OPCODE_ALU_OP_MODE_END   (0xD) /* (0b1101) */ /* eBPF only */

#define FD_SBPF_OPCODE_JMP_OP_MODE_JA    (0x0) /* (0b0000) */ /* only for FD_SBPF_OPCODE_CLASS_JMP */
#define FD_SBPF_OPCODE_JMP_OP_MODE_JEQ   (0x1) /* (0b0001) */
#define FD_SBPF_OPCODE_JMP_OP_MODE_JGT   (0x2) /* (0b0010) */
#define FD_SBPF_OPCODE_JMP_OP_MODE_JGE   (0x3) /* (0b0011) */
#define FD_SBPF_OPCODE_JMP_OP_MODE_JSET  (0x4) /* (0b0100) */
#define FD_SBPF_OPCODE_JMP_OP_MODE_JNE   (0x5) /* (0b0101) */ /* eBPF only */
#define FD_SBPF_OPCODE_JMP_OP_MODE_JSGT  (0x6) /* (0b0110) */ /* eBPF only */
#define FD_SBPF_OPCODE_JMP_OP_MODE_JSGE  (0x7) /* (0b0111) */ /* eBPF only */
#define FD_SBPF_OPCODE_JMP_OP_MODE_CALL  (0x8) /* (0b1000) */ /* eBPF only */
#define FD_SBPF_OPCODE_JMP_OP_MODE_EXIT  (0x9) /* (0b1001) */ /* eBPF only */
#define FD_SBPF_OPCODE_JMP_OP_MODE_JLT   (0xA) /* (0b1010) */ /* eBPF only */
#define FD_SBPF_OPCODE_JMP_OP_MODE_JLE   (0xB) /* (0b1011) */ /* eBPF only */
#define FD_SBPF_OPCODE_JMP_OP_MODE_JSLT  (0xC) /* (0b1100) */ /* eBPF only */
#define FD_SBPF_OPCODE_JMP_OP_MODE_JSLE  (0xD) /* (0b1101) */ /* eBPF only */

#define FD_SBPF_OPCODE_ADDR_MODE_IMM   (0x0) /* (0b000) */
#define FD_SBPF_OPCODE_ADDR_MODE_ABS   (0x1) /* (0b001) */ /* kernel mode only */
#define FD_SBPF_OPCODE_ADDR_MODE_IND   (0x2) /* (0b010) */ /* kernel mode only */
#define FD_SBPF_OPCODE_ADDR_MODE_MEM   (0x3) /* (0b011) */
#define FD_SBPF_OPCODE_ADDR_MODE_LEN   (0x4) /* (0b100) */ /* classic BPF only */
#define FD_SBPF_OPCODE_ADDR_MODE_MSH   (0x5) /* (0b101) */ /* classic BPF only */
#define FD_SBPF_OPCODE_ADDR_MODE_XADD  (0x6) /* (0b110) */ /* eBPF only */

/* Instruction opcode definition macros */
/* Normal instruction opcode definition macro */
#define FD_SBPF_DEFINE_NORM_INSTR(cls,mode,src) ((cls) | (mode << 4) | (src << 3))
/* Memory access instruction opcode definition macro */
#define FD_SBPF_DEFINE_MEM_INSTR(cls,addr_mode,sz) ((cls) | (addr_mode << 5) | (sz << 3))

/* Instruction opcode constants */
static const uchar FD_SBPF_OP_ADD_IMM =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU,   FD_SBPF_OPCODE_ALU_OP_MODE_ADD,    FD_SBPF_OPCODE_SOURCE_MODE_IMM);
static const uchar FD_SBPF_OP_ADD_REG =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU,   FD_SBPF_OPCODE_ALU_OP_MODE_ADD,    FD_SBPF_OPCODE_SOURCE_MODE_REG);
static const uchar FD_SBPF_OP_SUB_IMM =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU,   FD_SBPF_OPCODE_ALU_OP_MODE_SUB,    FD_SBPF_OPCODE_SOURCE_MODE_IMM);
static const uchar FD_SBPF_OP_SUB_REG =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU,   FD_SBPF_OPCODE_ALU_OP_MODE_SUB,    FD_SBPF_OPCODE_SOURCE_MODE_REG);
static const uchar FD_SBPF_OP_MUL_IMM =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU,   FD_SBPF_OPCODE_ALU_OP_MODE_MUL,    FD_SBPF_OPCODE_SOURCE_MODE_IMM);
static const uchar FD_SBPF_OP_MUL_REG =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU,   FD_SBPF_OPCODE_ALU_OP_MODE_MUL,    FD_SBPF_OPCODE_SOURCE_MODE_REG);
static const uchar FD_SBPF_OP_DIV_IMM =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU,   FD_SBPF_OPCODE_ALU_OP_MODE_DIV,    FD_SBPF_OPCODE_SOURCE_MODE_IMM);
static const uchar FD_SBPF_OP_DIV_REG =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU,   FD_SBPF_OPCODE_ALU_OP_MODE_DIV,    FD_SBPF_OPCODE_SOURCE_MODE_REG);
static const uchar FD_SBPF_OP_OR_IMM =    FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU,   FD_SBPF_OPCODE_ALU_OP_MODE_OR,     FD_SBPF_OPCODE_SOURCE_MODE_IMM);
static const uchar FD_SBPF_OP_OR_REG =    FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU,   FD_SBPF_OPCODE_ALU_OP_MODE_OR,     FD_SBPF_OPCODE_SOURCE_MODE_REG);
static const uchar FD_SBPF_OP_AND_IMM =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU,   FD_SBPF_OPCODE_ALU_OP_MODE_AND,    FD_SBPF_OPCODE_SOURCE_MODE_IMM);
static const uchar FD_SBPF_OP_AND_REG =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU,   FD_SBPF_OPCODE_ALU_OP_MODE_AND,    FD_SBPF_OPCODE_SOURCE_MODE_REG);
static const uchar FD_SBPF_OP_LSH_IMM =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU,   FD_SBPF_OPCODE_ALU_OP_MODE_LSH,    FD_SBPF_OPCODE_SOURCE_MODE_IMM);
static const uchar FD_SBPF_OP_LSH_REG =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU,   FD_SBPF_OPCODE_ALU_OP_MODE_LSH,    FD_SBPF_OPCODE_SOURCE_MODE_REG);
static const uchar FD_SBPF_OP_RSH_IMM =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU,   FD_SBPF_OPCODE_ALU_OP_MODE_RSH,    FD_SBPF_OPCODE_SOURCE_MODE_IMM);
static const uchar FD_SBPF_OP_RSH_REG =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU,   FD_SBPF_OPCODE_ALU_OP_MODE_RSH,    FD_SBPF_OPCODE_SOURCE_MODE_REG);
static const uchar FD_SBPF_OP_NEG =       FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU,   FD_SBPF_OPCODE_ALU_OP_MODE_NEG,    FD_SBPF_OPCODE_SOURCE_MODE_UNARY_REG);
static const uchar FD_SBPF_OP_MOD_IMM =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU,   FD_SBPF_OPCODE_ALU_OP_MODE_MOD,    FD_SBPF_OPCODE_SOURCE_MODE_IMM);
static const uchar FD_SBPF_OP_MOD_REG =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU,   FD_SBPF_OPCODE_ALU_OP_MODE_MOD,    FD_SBPF_OPCODE_SOURCE_MODE_REG);
static const uchar FD_SBPF_OP_XOR_IMM =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU,   FD_SBPF_OPCODE_ALU_OP_MODE_XOR,    FD_SBPF_OPCODE_SOURCE_MODE_IMM);
static const uchar FD_SBPF_OP_XOR_REG =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU,   FD_SBPF_OPCODE_ALU_OP_MODE_XOR,    FD_SBPF_OPCODE_SOURCE_MODE_REG);
static const uchar FD_SBPF_OP_MOV_IMM =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU,   FD_SBPF_OPCODE_ALU_OP_MODE_MOV,    FD_SBPF_OPCODE_SOURCE_MODE_IMM);
static const uchar FD_SBPF_OP_MOV_REG =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU,   FD_SBPF_OPCODE_ALU_OP_MODE_MOV,    FD_SBPF_OPCODE_SOURCE_MODE_REG);
static const uchar FD_SBPF_OP_ARSH_IMM =  FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU,   FD_SBPF_OPCODE_ALU_OP_MODE_ARSH,   FD_SBPF_OPCODE_SOURCE_MODE_IMM);
static const uchar FD_SBPF_OP_ARSH_REG =  FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU,   FD_SBPF_OPCODE_ALU_OP_MODE_ARSH,   FD_SBPF_OPCODE_SOURCE_MODE_REG);
static const uchar FD_SBPF_OP_END_LE =    FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU,   FD_SBPF_OPCODE_ALU_OP_MODE_END,    FD_SBPF_OPCODE_END_MODE_HOST_TO_LE);
static const uchar FD_SBPF_OP_END_BE =    FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU,   FD_SBPF_OPCODE_ALU_OP_MODE_END,    FD_SBPF_OPCODE_END_MODE_HOST_TO_BE);

static const uchar FD_SBPF_OP_ADD64_IMM =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU64,   FD_SBPF_OPCODE_ALU_OP_MODE_ADD,    FD_SBPF_OPCODE_SOURCE_MODE_IMM);
static const uchar FD_SBPF_OP_ADD64_REG =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU64,   FD_SBPF_OPCODE_ALU_OP_MODE_ADD,    FD_SBPF_OPCODE_SOURCE_MODE_REG);
static const uchar FD_SBPF_OP_SUB64_IMM =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU64,   FD_SBPF_OPCODE_ALU_OP_MODE_SUB,    FD_SBPF_OPCODE_SOURCE_MODE_IMM);
static const uchar FD_SBPF_OP_SUB64_REG =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU64,   FD_SBPF_OPCODE_ALU_OP_MODE_SUB,    FD_SBPF_OPCODE_SOURCE_MODE_REG);
static const uchar FD_SBPF_OP_MUL64_IMM =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU64,   FD_SBPF_OPCODE_ALU_OP_MODE_MUL,    FD_SBPF_OPCODE_SOURCE_MODE_IMM);
static const uchar FD_SBPF_OP_MUL64_REG =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU64,   FD_SBPF_OPCODE_ALU_OP_MODE_MUL,    FD_SBPF_OPCODE_SOURCE_MODE_REG);
static const uchar FD_SBPF_OP_DIV64_IMM =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU64,   FD_SBPF_OPCODE_ALU_OP_MODE_DIV,    FD_SBPF_OPCODE_SOURCE_MODE_IMM);
static const uchar FD_SBPF_OP_DIV64_REG =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU64,   FD_SBPF_OPCODE_ALU_OP_MODE_DIV,    FD_SBPF_OPCODE_SOURCE_MODE_REG);
static const uchar FD_SBPF_OP_OR64_IMM =    FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU64,   FD_SBPF_OPCODE_ALU_OP_MODE_OR,     FD_SBPF_OPCODE_SOURCE_MODE_IMM);
static const uchar FD_SBPF_OP_OR64_REG =    FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU64,   FD_SBPF_OPCODE_ALU_OP_MODE_OR,     FD_SBPF_OPCODE_SOURCE_MODE_REG);
static const uchar FD_SBPF_OP_AND64_IMM =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU64,   FD_SBPF_OPCODE_ALU_OP_MODE_AND,    FD_SBPF_OPCODE_SOURCE_MODE_IMM);
static const uchar FD_SBPF_OP_AND64_REG =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU64,   FD_SBPF_OPCODE_ALU_OP_MODE_AND,    FD_SBPF_OPCODE_SOURCE_MODE_REG);
static const uchar FD_SBPF_OP_LSH64_IMM =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU64,   FD_SBPF_OPCODE_ALU_OP_MODE_LSH,    FD_SBPF_OPCODE_SOURCE_MODE_IMM);
static const uchar FD_SBPF_OP_LSH64_REG =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU64,   FD_SBPF_OPCODE_ALU_OP_MODE_LSH,    FD_SBPF_OPCODE_SOURCE_MODE_REG);
static const uchar FD_SBPF_OP_RSH64_IMM =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU64,   FD_SBPF_OPCODE_ALU_OP_MODE_RSH,    FD_SBPF_OPCODE_SOURCE_MODE_IMM);
static const uchar FD_SBPF_OP_RSH64_REG =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU64,   FD_SBPF_OPCODE_ALU_OP_MODE_RSH,    FD_SBPF_OPCODE_SOURCE_MODE_REG);
static const uchar FD_SBPF_OP_NEG64 =       FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU64,   FD_SBPF_OPCODE_ALU_OP_MODE_NEG,    FD_SBPF_OPCODE_SOURCE_MODE_UNARY_REG);
static const uchar FD_SBPF_OP_MOD64_IMM =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU64,   FD_SBPF_OPCODE_ALU_OP_MODE_MOD,    FD_SBPF_OPCODE_SOURCE_MODE_IMM);
static const uchar FD_SBPF_OP_MOD64_REG =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU64,   FD_SBPF_OPCODE_ALU_OP_MODE_MOD,    FD_SBPF_OPCODE_SOURCE_MODE_REG);
static const uchar FD_SBPF_OP_XOR64_IMM =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU64,   FD_SBPF_OPCODE_ALU_OP_MODE_XOR,    FD_SBPF_OPCODE_SOURCE_MODE_IMM);
static const uchar FD_SBPF_OP_XOR64_REG =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU64,   FD_SBPF_OPCODE_ALU_OP_MODE_XOR,    FD_SBPF_OPCODE_SOURCE_MODE_REG);
static const uchar FD_SBPF_OP_MOV64_IMM =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU64,   FD_SBPF_OPCODE_ALU_OP_MODE_MOV,    FD_SBPF_OPCODE_SOURCE_MODE_IMM);
static const uchar FD_SBPF_OP_MOV64_REG =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU64,   FD_SBPF_OPCODE_ALU_OP_MODE_MOV,    FD_SBPF_OPCODE_SOURCE_MODE_REG);
static const uchar FD_SBPF_OP_ARSH64_IMM =  FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU64,   FD_SBPF_OPCODE_ALU_OP_MODE_ARSH,   FD_SBPF_OPCODE_SOURCE_MODE_IMM);
static const uchar FD_SBPF_OP_ARSH64_REG =  FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU64,   FD_SBPF_OPCODE_ALU_OP_MODE_ARSH,   FD_SBPF_OPCODE_SOURCE_MODE_REG);
static const uchar FD_SBPF_OP_END64_LE =    FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU64,   FD_SBPF_OPCODE_ALU_OP_MODE_END,    FD_SBPF_OPCODE_END_MODE_HOST_TO_LE);
static const uchar FD_SBPF_OP_END64_BE =    FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_ALU64,   FD_SBPF_OPCODE_ALU_OP_MODE_END,    FD_SBPF_OPCODE_END_MODE_HOST_TO_BE);

static const uchar FD_SBPF_OP_JA =        FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_JMP, FD_SBPF_OPCODE_JMP_OP_MODE_JA,   FD_SBPF_OPCODE_SOURCE_MODE_UNARY_IMM);
static const uchar FD_SBPF_OP_JEQ_IMM =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_JMP, FD_SBPF_OPCODE_JMP_OP_MODE_JEQ,  FD_SBPF_OPCODE_SOURCE_MODE_IMM);
static const uchar FD_SBPF_OP_JEQ_REG =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_JMP, FD_SBPF_OPCODE_JMP_OP_MODE_JEQ,  FD_SBPF_OPCODE_SOURCE_MODE_REG);
static const uchar FD_SBPF_OP_JGT_IMM =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_JMP, FD_SBPF_OPCODE_JMP_OP_MODE_JGT,  FD_SBPF_OPCODE_SOURCE_MODE_IMM);
static const uchar FD_SBPF_OP_JGT_REG =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_JMP, FD_SBPF_OPCODE_JMP_OP_MODE_JGT,  FD_SBPF_OPCODE_SOURCE_MODE_REG);
static const uchar FD_SBPF_OP_JGE_IMM =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_JMP, FD_SBPF_OPCODE_JMP_OP_MODE_JGE,  FD_SBPF_OPCODE_SOURCE_MODE_IMM);
static const uchar FD_SBPF_OP_JGE_REG =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_JMP, FD_SBPF_OPCODE_JMP_OP_MODE_JGE,  FD_SBPF_OPCODE_SOURCE_MODE_REG);
static const uchar FD_SBPF_OP_JSET_IMM =  FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_JMP, FD_SBPF_OPCODE_JMP_OP_MODE_JSET, FD_SBPF_OPCODE_SOURCE_MODE_IMM);
static const uchar FD_SBPF_OP_JSET_REG =  FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_JMP, FD_SBPF_OPCODE_JMP_OP_MODE_JSET, FD_SBPF_OPCODE_SOURCE_MODE_REG);
static const uchar FD_SBPF_OP_JNE_IMM =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_JMP, FD_SBPF_OPCODE_JMP_OP_MODE_JNE,  FD_SBPF_OPCODE_SOURCE_MODE_IMM);
static const uchar FD_SBPF_OP_JNE_REG =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_JMP, FD_SBPF_OPCODE_JMP_OP_MODE_JNE,  FD_SBPF_OPCODE_SOURCE_MODE_REG);
static const uchar FD_SBPF_OP_JSGT_IMM =  FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_JMP, FD_SBPF_OPCODE_JMP_OP_MODE_JSGT, FD_SBPF_OPCODE_SOURCE_MODE_IMM);
static const uchar FD_SBPF_OP_JSGT_REG =  FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_JMP, FD_SBPF_OPCODE_JMP_OP_MODE_JSGT, FD_SBPF_OPCODE_SOURCE_MODE_REG);
static const uchar FD_SBPF_OP_JSGE_IMM =  FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_JMP, FD_SBPF_OPCODE_JMP_OP_MODE_JSGE, FD_SBPF_OPCODE_SOURCE_MODE_IMM);
static const uchar FD_SBPF_OP_JSGE_REG =  FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_JMP, FD_SBPF_OPCODE_JMP_OP_MODE_JSGE, FD_SBPF_OPCODE_SOURCE_MODE_REG);
static const uchar FD_SBPF_OP_CALL_IMM =  FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_JMP, FD_SBPF_OPCODE_JMP_OP_MODE_CALL, FD_SBPF_OPCODE_SOURCE_MODE_IMM);
static const uchar FD_SBPF_OP_CALL_REG =  FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_JMP, FD_SBPF_OPCODE_JMP_OP_MODE_CALL, FD_SBPF_OPCODE_SOURCE_MODE_REG);
static const uchar FD_SBPF_OP_EXIT =      FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_JMP, FD_SBPF_OPCODE_JMP_OP_MODE_EXIT, FD_SBPF_OPCODE_SOURCE_MODE_NO_SOURCE);
static const uchar FD_SBPF_OP_JLT_IMM =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_JMP, FD_SBPF_OPCODE_JMP_OP_MODE_JLT,  FD_SBPF_OPCODE_SOURCE_MODE_IMM);
static const uchar FD_SBPF_OP_JLT_REG =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_JMP, FD_SBPF_OPCODE_JMP_OP_MODE_JLT,  FD_SBPF_OPCODE_SOURCE_MODE_REG);
static const uchar FD_SBPF_OP_JLE_IMM =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_JMP, FD_SBPF_OPCODE_JMP_OP_MODE_JLE,  FD_SBPF_OPCODE_SOURCE_MODE_IMM);
static const uchar FD_SBPF_OP_JLE_REG =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_JMP, FD_SBPF_OPCODE_JMP_OP_MODE_JLE,  FD_SBPF_OPCODE_SOURCE_MODE_REG);
static const uchar FD_SBPF_OP_JSLT_IMM =  FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_JMP, FD_SBPF_OPCODE_JMP_OP_MODE_JSLT, FD_SBPF_OPCODE_SOURCE_MODE_IMM);
static const uchar FD_SBPF_OP_JSLT_REG =  FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_JMP, FD_SBPF_OPCODE_JMP_OP_MODE_JSLT, FD_SBPF_OPCODE_SOURCE_MODE_REG);
static const uchar FD_SBPF_OP_JSLE_IMM =  FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_JMP, FD_SBPF_OPCODE_JMP_OP_MODE_JSLE, FD_SBPF_OPCODE_SOURCE_MODE_IMM);
static const uchar FD_SBPF_OP_JSLE_REG =  FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_JMP, FD_SBPF_OPCODE_JMP_OP_MODE_JSLE, FD_SBPF_OPCODE_SOURCE_MODE_REG);

static const uchar FD_SBPF_OP_JEQ32_IMM =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_JMP, FD_SBPF_OPCODE_JMP_OP_MODE_JEQ,  FD_SBPF_OPCODE_SOURCE_MODE_IMM);
static const uchar FD_SBPF_OP_JEQ32_REG =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_JMP, FD_SBPF_OPCODE_JMP_OP_MODE_JEQ,  FD_SBPF_OPCODE_SOURCE_MODE_REG);
static const uchar FD_SBPF_OP_JGT32_IMM =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_JMP, FD_SBPF_OPCODE_JMP_OP_MODE_JGT,  FD_SBPF_OPCODE_SOURCE_MODE_IMM);
static const uchar FD_SBPF_OP_JGT32_REG =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_JMP, FD_SBPF_OPCODE_JMP_OP_MODE_JGT,  FD_SBPF_OPCODE_SOURCE_MODE_REG);
static const uchar FD_SBPF_OP_JGE32_IMM =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_JMP, FD_SBPF_OPCODE_JMP_OP_MODE_JGE,  FD_SBPF_OPCODE_SOURCE_MODE_IMM);
static const uchar FD_SBPF_OP_JGE32_REG =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_JMP, FD_SBPF_OPCODE_JMP_OP_MODE_JGE,  FD_SBPF_OPCODE_SOURCE_MODE_REG);
static const uchar FD_SBPF_OP_JSET32_IMM =  FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_JMP, FD_SBPF_OPCODE_JMP_OP_MODE_JSET, FD_SBPF_OPCODE_SOURCE_MODE_IMM);
static const uchar FD_SBPF_OP_JSET32_REG =  FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_JMP, FD_SBPF_OPCODE_JMP_OP_MODE_JSET, FD_SBPF_OPCODE_SOURCE_MODE_REG);
static const uchar FD_SBPF_OP_JNE32_IMM =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_JMP, FD_SBPF_OPCODE_JMP_OP_MODE_JNE,  FD_SBPF_OPCODE_SOURCE_MODE_IMM);
static const uchar FD_SBPF_OP_JNE32_REG =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_JMP, FD_SBPF_OPCODE_JMP_OP_MODE_JNE,  FD_SBPF_OPCODE_SOURCE_MODE_REG);
static const uchar FD_SBPF_OP_JSGT32_IMM =  FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_JMP, FD_SBPF_OPCODE_JMP_OP_MODE_JSGT, FD_SBPF_OPCODE_SOURCE_MODE_IMM);
static const uchar FD_SBPF_OP_JSGT32_REG =  FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_JMP, FD_SBPF_OPCODE_JMP_OP_MODE_JSGT, FD_SBPF_OPCODE_SOURCE_MODE_REG);
static const uchar FD_SBPF_OP_JSGE32_IMM =  FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_JMP, FD_SBPF_OPCODE_JMP_OP_MODE_JSGE, FD_SBPF_OPCODE_SOURCE_MODE_IMM);
static const uchar FD_SBPF_OP_JSGE32_REG =  FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_JMP, FD_SBPF_OPCODE_JMP_OP_MODE_JSGE, FD_SBPF_OPCODE_SOURCE_MODE_REG);
static const uchar FD_SBPF_OP_JLT32_IMM =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_JMP, FD_SBPF_OPCODE_JMP_OP_MODE_JLT,  FD_SBPF_OPCODE_SOURCE_MODE_IMM);
static const uchar FD_SBPF_OP_JLT32_REG =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_JMP, FD_SBPF_OPCODE_JMP_OP_MODE_JLT,  FD_SBPF_OPCODE_SOURCE_MODE_REG);
static const uchar FD_SBPF_OP_JLE32_IMM =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_JMP, FD_SBPF_OPCODE_JMP_OP_MODE_JLE,  FD_SBPF_OPCODE_SOURCE_MODE_IMM);
static const uchar FD_SBPF_OP_JLE32_REG =   FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_JMP, FD_SBPF_OPCODE_JMP_OP_MODE_JLE,  FD_SBPF_OPCODE_SOURCE_MODE_REG);
static const uchar FD_SBPF_OP_JSLT32_IMM =  FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_JMP, FD_SBPF_OPCODE_JMP_OP_MODE_JSLT, FD_SBPF_OPCODE_SOURCE_MODE_IMM);
static const uchar FD_SBPF_OP_JSLT32_REG =  FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_JMP, FD_SBPF_OPCODE_JMP_OP_MODE_JSLT, FD_SBPF_OPCODE_SOURCE_MODE_REG);
static const uchar FD_SBPF_OP_JSLE32_IMM =  FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_JMP, FD_SBPF_OPCODE_JMP_OP_MODE_JSLE, FD_SBPF_OPCODE_SOURCE_MODE_IMM);
static const uchar FD_SBPF_OP_JSLE32_REG =  FD_SBPF_DEFINE_NORM_INSTR(FD_SBPF_OPCODE_CLASS_JMP, FD_SBPF_OPCODE_JMP_OP_MODE_JSLE, FD_SBPF_OPCODE_SOURCE_MODE_REG);

static const uchar FD_SBPF_OP_LDDW =  FD_SBPF_DEFINE_MEM_INSTR(FD_SBPF_OPCODE_CLASS_LD,   FD_SBPF_OPCODE_ADDR_MODE_IMM,  FD_SBPF_OPCODE_SIZE_MODE_DOUB);

static const uchar FD_SBPF_OP_LDXW  =  FD_SBPF_DEFINE_MEM_INSTR(FD_SBPF_OPCODE_CLASS_LDX,  FD_SBPF_OPCODE_ADDR_MODE_MEM,  FD_SBPF_OPCODE_SIZE_MODE_WORD);
static const uchar FD_SBPF_OP_LDXH  =  FD_SBPF_DEFINE_MEM_INSTR(FD_SBPF_OPCODE_CLASS_LDX,  FD_SBPF_OPCODE_ADDR_MODE_MEM,  FD_SBPF_OPCODE_SIZE_MODE_HALF);
static const uchar FD_SBPF_OP_LDXB  =  FD_SBPF_DEFINE_MEM_INSTR(FD_SBPF_OPCODE_CLASS_LDX,  FD_SBPF_OPCODE_ADDR_MODE_MEM,  FD_SBPF_OPCODE_SIZE_MODE_BYTE);
static const uchar FD_SBPF_OP_LDXDW =  FD_SBPF_DEFINE_MEM_INSTR(FD_SBPF_OPCODE_CLASS_LDX,  FD_SBPF_OPCODE_ADDR_MODE_MEM,  FD_SBPF_OPCODE_SIZE_MODE_DOUB);

static const uchar FD_SBPF_OP_STW  =   FD_SBPF_DEFINE_MEM_INSTR(FD_SBPF_OPCODE_CLASS_ST,  FD_SBPF_OPCODE_ADDR_MODE_MEM,  FD_SBPF_OPCODE_SIZE_MODE_WORD);
static const uchar FD_SBPF_OP_STH  =   FD_SBPF_DEFINE_MEM_INSTR(FD_SBPF_OPCODE_CLASS_ST,  FD_SBPF_OPCODE_ADDR_MODE_MEM,  FD_SBPF_OPCODE_SIZE_MODE_HALF);
static const uchar FD_SBPF_OP_STB  =   FD_SBPF_DEFINE_MEM_INSTR(FD_SBPF_OPCODE_CLASS_ST,  FD_SBPF_OPCODE_ADDR_MODE_MEM,  FD_SBPF_OPCODE_SIZE_MODE_BYTE);
static const uchar FD_SBPF_OP_STDW =   FD_SBPF_DEFINE_MEM_INSTR(FD_SBPF_OPCODE_CLASS_ST,  FD_SBPF_OPCODE_ADDR_MODE_MEM,  FD_SBPF_OPCODE_SIZE_MODE_DOUB);

static const uchar FD_SBPF_OP_STXW  =  FD_SBPF_DEFINE_MEM_INSTR(FD_SBPF_OPCODE_CLASS_STX,  FD_SBPF_OPCODE_ADDR_MODE_MEM,  FD_SBPF_OPCODE_SIZE_MODE_WORD);
static const uchar FD_SBPF_OP_STXH  =  FD_SBPF_DEFINE_MEM_INSTR(FD_SBPF_OPCODE_CLASS_STX,  FD_SBPF_OPCODE_ADDR_MODE_MEM,  FD_SBPF_OPCODE_SIZE_MODE_HALF);
static const uchar FD_SBPF_OP_STXB  =  FD_SBPF_DEFINE_MEM_INSTR(FD_SBPF_OPCODE_CLASS_STX,  FD_SBPF_OPCODE_ADDR_MODE_MEM,  FD_SBPF_OPCODE_SIZE_MODE_BYTE);
static const uchar FD_SBPF_OP_STXDW =  FD_SBPF_DEFINE_MEM_INSTR(FD_SBPF_OPCODE_CLASS_STX,  FD_SBPF_OPCODE_ADDR_MODE_MEM,  FD_SBPF_OPCODE_SIZE_MODE_DOUB);

static const uchar FD_SBPF_OP_ADDL_IMM = (0x00); /* (0b00000000) */

#endif // HEADER_fd_src_ballet_sbpf_fd_sbpf_opcodes_h
