/* Do NOT modify. This file is auto generated by fd_curve25519_tables. */

#ifndef HEADER_fd_src_ballet_ed25519_fd_curve25519_h
#error "Do not include this directly; use fd_curve25519.h"
#endif

/* Ed25519 base point. */
static const fd_ed25519_point_t fd_ed25519_base_point[1] = {
  // compressed: 0x5866666666666666666666666666666666666666666666666666666666666666
  {
    { 0x000005608f25d51a, 0x0000066666666658, 0x0000000000000001, 0x000002b3a5b7dda3, 0x00000118feeb6e2e, 0x0000033333333333, 0x0000000000000000, 0x000007473255f1be, },
    { 0x000004b4f6592ac5, 0x000004cccccccccc, 0x0000000000000000, 0x0000022a5eadbbd1, 0x000006e53fec0a4e, 0x0000066666666666, 0x0000000000000000, 0x000000b766566ea4, },
    { 0x000001a4b31d8254, 0x0000019999999999, 0x0000000000000000, 0x00000483c27e01dd, 0x00000042d26da79a, 0x000000cccccccccc, 0x0000000000000000, 0x000000cf0ebe1faf, },
  },
};

/* Low-order points y coordinates. */
// 0x26e8958fc2b227b045c3f489f2ef98f0d5dfac05d3c63339b13802886d53fc05
static const fd_f25519_t fd_ed25519_order8_point_y0[1] = {{
  { 0x000002c28f95e826, 0x0000069868b604f6, 0x000007c263bfca27, 0x0000036982d66fea, 0x000000238b13933c, 0x0000000bf8a6db10, 0x0, 0x0, }
}};

// 0xc7176a703d4dd84fba3c0b760d10670f2a2053fa2c39ccc64ec7fd7792ac037a
static const fd_f25519_t fd_ed25519_order8_point_y1[1] = {{
  { 0x0000053d706a17c7, 0x000001679749fb09, 0x0000003d9c4035d8, 0x000004967d299015, 0x000007dc74ec6cc3, 0x000000f4075924ef, 0x0, 0x0, }
}};

/* Ed25519 base point w-NAF table for fast scalar multiplication.
   Table size 128 points, i.e. max w=8.
   Used by fd_ed25519_verify and similar. */
static const fd_ed25519_point_t fd_ed25519_base_point_wnaf_table[128] = {
  // compressed: 0x853b8cf5c693bc2f190e8cfbc62d93cfc2423d6498480b2765bad4333a9dcf07
  {
    { 0x00000105d740913e, 0x000003c6f58c3b85, 0x0000000000000001, 0x00000205877aaa68, 0x0000021a3447c504, 0x0000044c321ea161, 0x0000000000000000, 0x000006e5eea1acc6, },
    { 0x00000017d673a207, 0x00000181c325f792, 0x0000000000000000, 0x0000055893d57922, 0x00000781267a5c18, 0x0000054ba65270b4, 0x0000000000000000, 0x000000c65a85a1b7, },
    { 0x000007f4e67c1745, 0x0000033e4cb71bee, 0x0000000000000000, 0x0000009b67a08f32, 0x00000089fa5f2531, 0x0000000f9f3a7467, 0x0000000000000000, 0x000000de22f6d13e, },
  },
  // compressed: 0x3097ee4ca8b025af8a4b86e830845a023267019f02501bc1f4f8809a1b4e16fa
  {
    { 0x000007e8a4fcd265, 0x000000a84cee9730, 0x0000000000000001, 0x0000033f0dd0d889, 0x0000018d10a5eb5e, 0x000000014f80b399, 0x0000000000000000, 0x000002a2c6796da6, },
    { 0x000000374faacc23, 0x000000c97155e4b6, 0x0000000000000000, 0x000006bb4c4295d2, 0x000005bda628131f, 0x0000000f8f4c11b5, 0x0000000000000000, 0x0000039b4c6d170e, },
    { 0x000004ef4d4ff797, 0x000000096a10c3a2, 0x0000000000000000, 0x00000162508c8870, 0x00000055722b0eaa, 0x000000f42c9c3735, 0x0000000000000000, 0x000000b4504d5e25, },
  },
  // compressed: 0x33bba50844bc12a202ed5ec7c348508d44ecbf5a0ceb1bddeb06e246f1cc4529
  {
    { 0x000002c3a447d6ba, 0x0000044408a5bb33, 0x0000000000000001, 0x000003f1812a8285, 0x0000008e5c325043, 0x000005862d5ff622, 0x0000000000000000, 0x000003858dded396, },
    { 0x000004e536eff230, 0x000003dda0544257, 0x0000000000000000, 0x000007ba3f97977b, 0x000001b55f3e33cf, 0x000006206ebdd1be, 0x0000000000000000, 0x000003bb69ab41b6, },
    { 0x000007540053452c, 0x0000023541230f1d, 0x0000000000000000, 0x0000049c38201f42, 0x0000002a94fce7d6, 0x000000528b99e28d, 0x0000000000000000, 0x00000087557cd2d6, },
  },
  // compressed: 0xbfa34e94d05c1a6bd2c09db33a357074492e54288252b2717e923c2869ea1bc6
  {
    { 0x0000049aaa3221b1, 0x000004d0944ea3bf, 0x0000000000000001, 0x000005c801b8b3a2, 0x00000327c90c961d, 0x00000141142a1724, 0x0000000000000000, 0x000000dd2c3bd6f9, },
    { 0x0000074474f74de5, 0x000003b81a4d634b, 0x0000000000000000, 0x000007d4935e306d, 0x000005317e09dea7, 0x000003c927e71b25, 0x0000000000000000, 0x000000f90a7529c4, },
    { 0x000001b280854cee, 0x000005d1c0d4eace, 0x0000000000000000, 0x000006cc0d7d1c14, 0x0000003addbaba5c, 0x0000008c37d4d250, 0x0000000000000000, 0x000000f53f7638d4, },
  },
  // compressed: 0x2f63a8a68a672e9bc546bc516f9e50a6b5f586c6c933b2ce597fdd8a33edb934
  {
    { 0x0000017e039d8064, 0x0000078aa6a8632f, 0x0000000000000001, 0x000000bf9045af1b, 0x0000030473af5822, 0x000001e4e3437ada, 0x0000000000000000, 0x00000614c9ea678b, },
    { 0x00000408337e6dc4, 0x00000788d8b365cc, 0x0000000000000000, 0x0000033a45e0d69d, 0x000005c9c8f96cbc, 0x000005d7f59ceb23, 0x0000000000000000, 0x00000008b06aaf6f, },
    { 0x000002628206dbd4, 0x000006994279bd46, 0x0000000000000000, 0x0000038bfe0fa29c, 0x0000009380b4a3f5, 0x0000006973da6715, 0x0000000000000000, 0x000000e782e40436, },
  },
  // compressed: 0xde2a808a8400bf2f272e3002cffed9e50634701771843e11af8f6d54e2aa7542
  {
    { 0x0000030249864348, 0x000000848a802ade, 0x0000000000000001, 0x000004c5fd6089e9, 0x000002aab546f5ca, 0x000002388bb81a03, 0x0000000000000000, 0x000000ccda8d4311, },
    { 0x0000011070262beb, 0x00000605c4e5f7e0, 0x0000000000000000, 0x0000005c949b0565, 0x0000055c77fa3a07, 0x000006d8faf113e8, 0x0000000000000000, 0x000003df94844311, },
    { 0x000004fb5acda5dc, 0x0000039767fb3c08, 0x0000000000000000, 0x0000000c7ad284ca, 0x0000003156b30053, 0x00000084eb55c4a8, 0x0000000000000000, 0x0000007b8caa456a, },
  },
  // compressed: 0x6d7f00a222c270bfdbdebcb59ab384bf07ba07fb120e7a5341f246c3eed74fa3
  {
    { 0x0000013b327fbf93, 0x00000222a2007f6d, 0x0000000000000001, 0x00000119732ea378, 0x000001195556acb4, 0x000007097d83dd03, 0x0000000000000000, 0x000003fc48d3f299, },
    { 0x000006eded6a0de0, 0x0000079bdb77ee18, 0x0000000000000000, 0x000001ba8e2a6c14, 0x000006024a79d12b, 0x0000046f241537a0, 0x0000000000000000, 0x00000097863a2ef3, },
    { 0x000002bbf3af266d, 0x000006fe12ce6ad6, 0x0000000000000000, 0x00000490df9ac77e, 0x00000004cf105a2e, 0x000000469fafdd86, 0x0000000000000000, 0x00000092f74dfb54, },
  },
  // compressed: 0xa0eacf1303ccce246d249c188dc24886d0d4f2c1fabdbd2d2be72df11729e2e1
  {
    { 0x00000586468ccf0b, 0x0000040313cfeaa0, 0x0000000000000001, 0x0000062f9bd0b516, 0x0000000403d928c9, 0x000006fd60f96a68, 0x0000000000000000, 0x0000053ec9eb2138, },
    { 0x000003221ac08179, 0x000003848da499d9, 0x0000000000000000, 0x000007fbddcbb34e, 0x00000505ebf75083, 0x000002de72b2dbdb, 0x0000000000000000, 0x0000064d842032e5, },
    { 0x0000034e0a6e90aa, 0x00000219230a3462, 0x0000000000000000, 0x000003ace2bd38dc, 0x000000876b9a8431, 0x000000c3c4522fe2, 0x0000000000000000, 0x000000a23ac24215, },
  },
  // compressed: 0x819d0e95ef76c6924f04d7c0cd2046a548128f6f64369baae355b8dd245932ed
  {
    { 0x000006484420de87, 0x000006ef950e9d81, 0x0000000000000001, 0x000002b8a5c8c854, 0x0000071394ca1692, 0x0000033237c78924, 0x0000000000000000, 0x0000048c41bbc686, },
    { 0x0000025db6810270, 0x000002e089f258ce, 0x0000000000000000, 0x000003e5406d8e30, 0x0000048281039fa4, 0x000003855e3aa9b3, 0x0000000000000000, 0x000001eeaa972cf5, },
    { 0x0000062873c05ad6, 0x0000029518833703, 0x0000000000000000, 0x000000cff451e7f9, 0x000000e34ffcdfc4, 0x000000da64b249bb, 0x0000000000000000, 0x0000008e8d896cab, },
  },
  // compressed: 0x2b9ac66d3c7b77d317f6896f27b2fadeb5163ab5f71c6545b79ffe34de519adc
  {
    { 0x000006c864741147, 0x0000033c6dc69a2b, 0x0000000000000001, 0x000001cf79f10e67, 0x0000053b03395199, 0x0000067bda9d0b5a, 0x0000000000000000, 0x0000038b880a113b, },
    { 0x00000799092690a8, 0x0000013ec2fa6eef, 0x0000000000000000, 0x0000030a2b7ea21e, 0x0000035e6d6ff939, 0x000007e9fb745651, 0x0000000000000000, 0x000000223bb09c3a, },
    { 0x000001f4d6bb743b, 0x0000077beac89dbe, 0x0000000000000000, 0x000007ff776a8799, 0x000000432cc692fb, 0x000000b934a3bc69, 0x0000000000000000, 0x0000009008a078c1, },
  },
  // compressed: 0xc77fa32cd09e24c4abac15a6e3a059a0230e6ec9d76ea9886d695016a59833d5
  {
    { 0x000001d23a36d175, 0x000006d02ca37fc7, 0x0000000000000001, 0x000005d278451edf, 0x000006721041c523, 0x0000076be4b70711, 0x0000000000000000, 0x00000516cfd2ca84, },
    { 0x00000373c6476d04, 0x000002b595788493, 0x0000000000000000, 0x000001339973425e, 0x000005e4c5e5d9e5, 0x0000050696d88a96, 0x0000000000000000, 0x0000075a611477f4, },
    { 0x000006eed02a9fa6, 0x0000068166838e98, 0x0000000000000000, 0x000000eb6975e616, 0x000000ee3c1310b1, 0x000000aa67314a2c, 0x0000000000000000, 0x000000b4bda3ad1f, },
  },
  // compressed: 0x830e15fe2a129511d8354b7e259a20cf201e711e29f88773f092bfd897b8acc4
  {
    { 0x000000c558527359, 0x0000022afe150e83, 0x0000000000000001, 0x000000145e134b83, 0x0000060f6d0e55f4, 0x000004148f388f10, 0x0000000000000000, 0x000004547e0d1f6b, },
    { 0x00000373afd75cbc, 0x00000166bb0232a2, 0x0000000000000000, 0x0000060982c3cc0d, 0x000006fdc4428653, 0x000003f92f07387f, 0x0000000000000000, 0x000002d2f92506e8, },
    { 0x000004e4b970672b, 0x0000033c826895f9, 0x0000000000000000, 0x00000713d7993c90, 0x0000000336c026bf, 0x0000008959712fb1, 0x0000000000000000, 0x0000002a1893fbcd, },
  },
  // compressed: 0x3811470995f27b8e51a6754f39ef6f5dad08a725c479af102299b95b075a2b6b
  {
    { 0x0000063c9cdca868, 0x0000029509471138, 0x0000000000000001, 0x0000004b47a0b976, 0x000001ab061b0b46, 0x000004e212d38456, 0x0000000000000000, 0x000007d8eaa17ac8, },
    { 0x000006295a170930, 0x000006b4ca31cf7e, 0x0000000000000000, 0x000002e91aab17ee, 0x0000005fbc1fe3ee, 0x0000039992210af7, 0x0000000000000000, 0x00000555d00aa2b1, },
    { 0x00000720fd136ee1, 0x00000575bfbce53d, 0x0000000000000000, 0x0000029806cd55d0, 0x000000f14daef23c, 0x000000d656b40eb7, 0x0000000000000000, 0x000000e4b8fff895, },
  },
  // compressed: 0xb299cfd1156742e4340da20211d552739f10128b7b15d123a3f3b17c27c94c79
  {
    { 0x000003f71cd098c0, 0x00000715d1cf99b2, 0x0000000000000001, 0x00000426c2ac5053, 0x000006b8a4814ca6, 0x000002bdc589084f, 0x0000000000000000, 0x0000017885188810, },
    { 0x000003cc6cd23005, 0x00000441a69c884c, 0x0000000000000000, 0x000006ce4b095ed8, 0x0000055fae7df585, 0x0000031f3a323d11, 0x0000000000000000, 0x000004c8e852ad03, },
    { 0x000003f905b293b5, 0x000005cd4b54440a, 0x0000000000000000, 0x000006f26bb6b4cb, 0x00000099aa8c4bf0, 0x000000f299924ef9, 0x0000000000000000, 0x000000e0106af6df, },
  },
  // compressed: 0x013f77382767880bfbccfb95fac8ccb8b629adb9a3d52d8d6a0fad51987eef06
  {
    { 0x000007bb82584a34, 0x0000072738773f01, 0x0000000000000001, 0x0000071cc0577de5, 0x000001ce2429b101, 0x000002d1dcd694db, 0x0000000000000000, 0x00000780ec017038, },
    { 0x0000068f257a0373, 0x000007799f61710c, 0x0000000000000000, 0x000006bb8b99526e, 0x0000056d428b6316, 0x000002d0f6a8d2dd, 0x0000000000000000, 0x000002af86a24680, },
    { 0x0000011ead918f4a, 0x000002e33323ea57, 0x0000000000000000, 0x000005d503907940, 0x0000002752546cd3, 0x0000000ddefd30a3, 0x0000000000000000, 0x0000007852dbbf14, },
  },
  // compressed: 0x13a714d9f915adae12f98f8cf97b2fa930d7539f1723f8afba770c4993d399fa
  {
    { 0x0000052ebb1f2541, 0x000005f9d914a713, 0x0000000000000001, 0x0000052436bda3e8, 0x000001bee850d682, 0x0000018bcfa9eb98, 0x0000000000000000, 0x000002b19317ce70, },
    { 0x000005b723ff9d69, 0x000001ff2255d5a2, 0x0000000000000000, 0x00000500f291ea5d, 0x0000047717bfc71a, 0x000000c77baaff82, 0x0000000000000000, 0x0000002f7d2a5a96, },
    { 0x000006e254431d02, 0x000002a4bdefe632, 0x0000000000000000, 0x000001dea321055f, 0x000000151258e00e, 0x000000f533a72692, 0x0000000000000000, 0x00000050cec5a506, },
  },
  // compressed: 0x255be33c0936784e97aa6bb21d18e1823fb8c7cbd392c10c3a9d9d6a04daf1b2
  {
    { 0x0000062bce2ef5bd, 0x000006093ce35b25, 0x0000000000000001, 0x000002a66d597c6a, 0x000003cf9dddc4dc, 0x00000169e5e3dc1f, 0x0000000000000000, 0x00000639e104d811, },
    { 0x000000f78c6f8ab1, 0x0000057552e9cf06, 0x0000000000000000, 0x00000270a57551a2, 0x0000071767a154a1, 0x000001d9d3a0cc19, 0x0000000000000000, 0x000002d28a63f91d, },
    { 0x0000039261b2d19d, 0x0000060b846076c9, 0x0000000000000000, 0x0000023c464c0c13, 0x000000ed0de547ad, 0x00000065e3b408d5, 0x0000000000000000, 0x000000ac260bf153, },
  },
  // compressed: 0xd1ae92ec8d970c10e5736d4d43d543ca48ba47d8221b13832c4d5de353ecaa80
  {
    { 0x00000428e7b0c0d5, 0x0000078dec92aed1, 0x0000000000000001, 0x00000773003ad2aa, 0x000006d3eb808530, 0x000005916c23dd24, 0x0000000000000000, 0x000006432907691f, },
    { 0x000000eb8a6ce459, 0x000005ae7ca20192, 0x0000000000000000, 0x0000042cc10f763e, 0x0000057cc6ccaf68, 0x000005d4d2c83131, 0x0000000000000000, 0x000000654807821d, },
    { 0x000005c277a6ef6c, 0x000003290f550d35, 0x0000000000000000, 0x0000002cfca600ac, 0x000000061435de58, 0x0000000155d8a7c6, 0x0000000000000000, 0x000000417d383848, },
  },
  // compressed: 0xa6739624d88753e193e446f52dbc4359b5636fc3819a7f1cdec10a1f36b30a75
  {
    { 0x0000044ae2025e60, 0x000007d8249673a6, 0x0000000000000001, 0x00000283a2f81037, 0x000001ce7cad068e, 0x00000540e1b7b1da, 0x0000000000000000, 0x000000add61712b1, },
    { 0x0000039727041c1c, 0x000000dc927c2a70, 0x0000000000000000, 0x000007f97e23d146, 0x0000067e311105d6, 0x000000ac1de1c7f9, 0x0000000000000000, 0x00000075040b72fd, },
    { 0x000002c0ececbf2f, 0x000005650ef0b7d5, 0x0000000000000000, 0x000005bcbb688ef5, 0x000000d2ec98a8a0, 0x000000ea15666c3e, 0x0000000000000000, 0x000000a9f2d67f6e, },
  },
  // compressed: 0x7992662904f2ad0f4a727d7d04a2dd3af160578c82943d6f9e53b72bc5e97fbd
  {
    { 0x000007c616b11ecd, 0x0000020429669279, 0x0000000000000001, 0x000005f737b8856b, 0x00000088737673c2, 0x00000241462bb078, 0x0000000000000000, 0x000003a55072cf11, },
    { 0x000002ec8f22efb5, 0x000007ae4941f5be, 0x0000000000000000, 0x00000342f14e0665, 0x0000005dbf0b7a8a, 0x0000037539e6f3d9, 0x0000000000000000, 0x00000088242320ff, },
    { 0x00000625d92e73e9, 0x000004eb768811f5, 0x0000000000000000, 0x000001d741750c10, 0x000000f1cd073f7d, 0x0000007affd38a57, 0x0000000000000000, 0x000000e1e4d1e6a0, },
  },
  // compressed: 0x475f80b183458666197cdd60d1c535f506b04c1eb74e87e9d989d8fa5c340dfc
  {
    { 0x0000012070dcf355, 0x00000583b1805f47, 0x0000000000000001, 0x0000074b8c78338a, 0x000007769aa95b4c, 0x0000075b8f265803, 0x0000000000000000, 0x000000a95a2f9ea2, },
    { 0x0000079c22e46482, 0x000003af832cd0c8, 0x0000000000000000, 0x00000416bc2b23e3, 0x0000038c4b9b31dd, 0x000005889d9e9874, 0x0000000000000000, 0x000002ec7775cbc4, },
    { 0x000000e03325fb9f, 0x000003d4d7174583, 0x0000000000000000, 0x00000280d9aac59f, 0x000000809cad8073, 0x000000f81a68b9f5, 0x0000000000000000, 0x00000041aea8ec55, },
  },
  // compressed: 0x58b73bc76fc38f5e9abb3c36a543e5ac22c93b907d4a93a962eccef3461e8fab
  {
    { 0x000006b135b9f543, 0x0000036fc73bb758, 0x0000000000000001, 0x0000029cdf51f95d, 0x00000583ab89c5d4, 0x0000053ec81de491, 0x0000000000000000, 0x000006c59945b36d, },
    { 0x00000192ad93ae9f, 0x00000797734bd1f8, 0x0000000000000000, 0x000003fbd596b809, 0x000000b4ce1e9322, 0x000004eec62a9934, 0x0000000000000000, 0x000003a19531d106, },
    { 0x00000612cdf7c77a, 0x000002b3950e94d8, 0x0000000000000000, 0x000000ace54abb2c, 0x00000071715b50f2, 0x000000571e3c8de7, 0x0000000000000000, 0x0000000935d6659d, },
  },
  // compressed: 0x3179fc750b7d50aad325677a4b92ef0f30396b392b54821dfc74f63075e15e79
  {
    { 0x0000053c63dcfe7e, 0x0000050b75fc7931, 0x0000000000000001, 0x0000030a52ecbd81, 0x00000430f0a7be09, 0x000002159cb59c98, 0x0000000000000000, 0x00000686e5772518, },
    { 0x000000adc81aeecf, 0x000004e4ba754a0f, 0x0000000000000000, 0x00000695fce4a94b, 0x000005625fcb6676, 0x000007674fc1d825, 0x0000000000000000, 0x00000454477e6a24, },
    { 0x000004827165225e, 0x0000003fbe492de9, 0x0000000000000000, 0x00000575047dbb80, 0x000000a38ccbc191, 0x000000f2bdc2ea61, 0x0000000000000000, 0x000000d9a337e93b, },
  },
  // compressed: 0x86c3af652161fe1f101bd5b8882a2a08aa0b99207e62f676e7439e42a7b301de
  {
    { 0x0000019052179ca3, 0x0000012165afc386, 0x0000000000000001, 0x000003e3d39357a1, 0x00000554424cb88f, 0x0000013f104c85d5, 0x0000000000000000, 0x000005326f988f37, },
    { 0x00000593f0afd0ec, 0x000002a36203ffcc, 0x0000000000000000, 0x000003d294a7b6a1, 0x0000032e63880a2b, 0x000001e43e776f66, 0x0000000000000000, 0x0000073c9861a309, },
    { 0x0000015c7428182c, 0x00000020a8aa22e3, 0x0000000000000000, 0x00000259edb37566, 0x000000ea41e7b681, 0x000000bc03674e85, 0x0000000000000000, 0x000000e21259399d, },
  },
  // compressed: 0xcf1d0574acd86b851eaab75508a4f603eb3c74c9cbe74a3adeab3771bba57341
  {
    { 0x0000023f0364918c, 0x000000ac74051dcf, 0x0000000000000001, 0x00000631f0f9218a, 0x0000054f3340f2d2, 0x000003e5e4ba1e75, 0x0000000000000000, 0x000003347a5978bb, },
    { 0x0000056d638a7b0a, 0x000006f543d0ad7b, 0x0000000000000000, 0x00000788e102f8ad, 0x00000257ba7080b4, 0x0000037abde3a4ae, 0x0000000000000000, 0x000004e3a67f7931, },
    { 0x0000028ad013d0fe, 0x0000040fda902156, 0x0000000000000000, 0x00000169a5b8ac6b, 0x0000001d42b607a0, 0x00000082e74b76e2, 0x0000000000000000, 0x000000bf8acac294, },
  },
  // compressed: 0x8e989077e6e1924822d75c1c0f95d501ed3e92e59a81b0e31b65469d40c714b2
  {
    { 0x0000070dc46d7ae5, 0x000001e67790988e, 0x0000000000000001, 0x0000027406651770, 0x000007819886d6c3, 0x000000cd72c91f76, 0x0000000000000000, 0x000004760c2e911e, },
    { 0x0000071b91e26dca, 0x0000039ae449125c, 0x0000000000000000, 0x000004f286c26530, 0x00000454aa159549, 0x0000046651be3b08, 0x0000000000000000, 0x000004b833cd9b6b, },
    { 0x0000003f42ab3153, 0x0000040756543c71, 0x0000000000000000, 0x000000ee92819a28, 0x000000c4e2388298, 0x00000064298e813a, 0x0000000000000000, 0x000000b7d5280e7d, },
  },
  // compressed: 0xf8d243f363ce70b4f1e843058fba67006f7b11a2a151da352fbdf1445978d04a
  {
    { 0x0000070912c89be4, 0x00000663f343d2f8, 0x0000000000000001, 0x00000334c3318301, 0x000007017b4bd832, 0x000000d0d108bdb7, 0x0000000000000000, 0x0000059769ced446, },
    { 0x000005caf38c83b7, 0x0000007d1e368e19, 0x0000000000000000, 0x0000062d04d0b1c7, 0x00000761eecabfe9, 0x0000071bd2f35da5, 0x0000000000000000, 0x0000002853d34085, },
    { 0x000006b3ce2cc5f5, 0x000004019eea3c15, 0x0000000000000000, 0x0000037267011c1c, 0x0000007559ab8291, 0x00000095a0f0b289, 0x0000000000000000, 0x00000075fe1963b2, },
  },
  // compressed: 0x0535c5f40b43269283221f26139ce468c627d38f7833ef097f9ed92b739fcf2c
  {
    { 0x000007eb3a20405e, 0x0000030bf4c53505, 0x0000000000000001, 0x0000009ed603f5e4, 0x000007245694eafc, 0x000001bc47e993e3, 0x0000000000000000, 0x00000384d0171ddb, },
    { 0x000005aad930f8b8, 0x000003e4507244c8, 0x0000000000000000, 0x00000604018af81b, 0x000004d251d29252, 0x00000599e7f09ef3, 0x0000000000000000, 0x00000693a3753172, },
    { 0x0000063b8c47bfb6, 0x000001a392704c98, 0x0000000000000000, 0x0000044a2218a3c2, 0x000000221cfd0de9, 0x000000599f3ee657, 0x0000000000000000, 0x0000000b8aafc172, },
  },
  // compressed: 0xb00ec289b0bb76f75cd80ffaf65bf861fb2144634e3fb9b60512864108ef9fa8
  {
    { 0x000006311fc97e6f, 0x000003b089c20eb0, 0x0000000000000001, 0x00000336fed69abf, 0x0000075045f692ee, 0x000007a731a210fd, 0x0000000000000000, 0x000003b2ba9d3ff3, },
    { 0x0000073fb5db1f39, 0x000001fb0b9eeed7, 0x0000000000000000, 0x000006b929f9ec2c, 0x0000069875ae15b7, 0x00000061205b6b93, 0x0000000000000000, 0x000005ca31913789, },
    { 0x000005e8fc98c047, 0x00000587e16fdbe8, 0x0000000000000000, 0x0000066c5b939e0c, 0x000000dc2a982f1f, 0x000000513fde1083, 0x0000000000000000, 0x000000d5f7ec8552, },
  },
  // compressed: 0xcca813f97050e55d61f50c2b7b161d7d89d4ea90b65629dad91e80dbce93c092
  {
    { 0x0000060c62f5d2c1, 0x00000070f913a8cc, 0x0000000000000001, 0x0000079308b8190f, 0x0000056d06d6b870, 0x0000035b48756a44, 0x0000000000000000, 0x000002b96d63ebfe, },
    { 0x000001cf734fb51b, 0x0000019eac2bbcaa, 0x0000000000000000, 0x0000035c621f828f, 0x000005038c47deb6, 0x00000001ed9da295, 0x0000000000000000, 0x00000635ce6cee75, },
    { 0x00000263f0f692c0, 0x000005f47459ecac, 0x0000000000000000, 0x0000041a5a768284, 0x0000001b6970a372, 0x0000002581279db7, 0x0000000000000000, 0x00000067550f338c, },
  },
  // compressed: 0xb16c15fc88f54883276d0a1a9bbaa26db65aca875c2d26e2a689d5c8c1d02c21
  {
    { 0x0000051ebd085cf2, 0x00000588fc156cb1, 0x0000000000000001, 0x000005107f18c781, 0x000007f0a830019e, 0x000006ae43e52d5b, 0x0000000000000000, 0x000003151e9e99a0, },
    { 0x00000267e3f5e1fe, 0x0000014da4f0691e, 0x0000000000000000, 0x000007d3a51a5e9a, 0x00000621a866ec2b, 0x000005589a6e2262, 0x0000000000000000, 0x00000114ce3a70a8, },
    { 0x000001e3d46a259f, 0x000001b68aea6c68, 0x0000000000000000, 0x00000448bb37c949, 0x0000004678de53d1, 0x0000004259a18391, 0x0000000000000000, 0x0000003b6eef1223, },
  },
  // compressed: 0xb61a70dd694739b3a58dcf19d4deb8e252c82afd6141df15be247d018acae2fa
  {
    { 0x000002397c6bc26f, 0x00000769dd701ab6, 0x0000000000000001, 0x000007ed0920b962, 0x0000021d5fbcd198, 0x000000b0fe956429, 0x0000000000000000, 0x000000a792ab0532, },
    { 0x000002a0227bbe6a, 0x000001f1b4b66728, 0x0000000000000000, 0x0000033b53b6fd02, 0x0000062adfc7c74f, 0x000007d24be15df4, 0x0000000000000000, 0x00000622c83e491c, },
    { 0x000001ea5f8b314f, 0x0000038ae37b5067, 0x0000000000000000, 0x0000007a146330fc, 0x000000635b2f5a4d, 0x000000f5c5951402, 0x0000000000000000, 0x0000003da3f8a74c, },
  },
  // compressed: 0x2d2d091ca642fe8b8e38bfc998485073fb1237bf7b16193ead24aa574a663d50
  {
    { 0x0000018e4d89f26e, 0x000002a61c092d2d, 0x0000000000000001, 0x0000015b90a91537, 0x000007368242e22e, 0x0000033ddf9b897d, 0x0000000000000000, 0x0000011f064745fd, },
    { 0x00000616fcfe973d, 0x000007e711d17fc8, 0x0000000000000000, 0x000006fcbe594367, 0x000003c0aa323db7, 0x000002a24ad3e191, 0x0000000000000000, 0x0000021f8e3192a0, },
    { 0x000002ce0b7ca215, 0x000005cd41226326, 0x0000000000000000, 0x000002e6ea0fdf3c, 0x000000b62566de51, 0x000000a07acc94af, 0x0000000000000000, 0x0000006d20cd0bd3, },
  },
  // compressed: 0x1d78d84f3cbe4c54e4578b13d21dcf2f393d5bbe64ee27eba5c30548f0cc5d35
  {
    { 0x000005d8b8699e48, 0x0000063c4fd8781d, 0x0000000000000001, 0x0000004dcb3c75db, 0x000006e055ec10ad, 0x000007325f2d9e9c, 0x0000000000000000, 0x000002c45b2cc0cb, },
    { 0x000002eb8f8d6321, 0x0000016afc8a8997, 0x0000000000000000, 0x000006cacff977b3, 0x0000074b19e56011, 0x0000005c3a5eb27e, 0x0000000000000000, 0x000002e4f65b138b, },
    { 0x00000691c033e8c7, 0x000004bf3c77484e, 0x0000000000000000, 0x0000007ed97b9d5f, 0x000000b62224e108, 0x0000006abb99e090, 0x0000000000000000, 0x000000b08b0f644b, },
  },
  // compressed: 0xd67ea6660fc15548c49791cb6c61eb848b21b280d3ff4f8b54ac82b9a47be205
  {
    { 0x00000363f12f57a6, 0x0000010f66a67ed6, 0x0000000000000001, 0x0000067d1e5a864d, 0x0000040454c02ddb, 0x000007e9c05910c5, 0x0000000000000000, 0x0000004775b41567, },
    { 0x000007857dc67274, 0x00000232f8890ab8, 0x0000000000000000, 0x0000054210c7e0d4, 0x00000511eefdb481, 0x0000002ac548b4ff, 0x0000000000000000, 0x000004a55da6b611, },
    { 0x00000550d7456cce, 0x00000613ad85b32e, 0x0000000000000000, 0x00000796bab6c378, 0x0000007b1231f70f, 0x0000000bc4f74973, 0x0000000000000000, 0x000000ff1e6849ac, },
  },
  // compressed: 0xaf8648b207481a7be2fd42c41eed48954f65457aa43152af65f21003ba5c75fe
  {
    { 0x0000013624794ed1, 0x00000007b24886af, 0x0000000000000001, 0x00000752761a3023, 0x0000070b6711de61, 0x000000d23d22b2a7, 0x0000000000000000, 0x000002067ef22cac, },
    { 0x0000061ed161dac5, 0x0000005fbc4f6349, 0x0000000000000000, 0x000002decd135f89, 0x000002356c4aafdf, 0x0000010f265af523, 0x0000000000000000, 0x000000b3230e246f, },
    { 0x000007b86fc31da3, 0x0000065523b47b11, 0x0000000000000000, 0x00000699386a209a, 0x0000001954e0b386, 0x000000fceab97406, 0x0000000000000000, 0x0000008a6d855dce, },
  },
  // compressed: 0xc3b9cc21f3efe38cb857216574bf389a8b16630fed5f60dcb39744caf5d0156a
  {
    { 0x00000302599db7fa, 0x000007f321ccb9c3, 0x0000000000000001, 0x000001f109bfa8d5, 0x000004297f3880c6, 0x000007f687b18b45, 0x0000000000000000, 0x000004cd1b4bc42c, },
    { 0x000005f844dc0334, 0x0000042af7119c7d, 0x0000000000000000, 0x000004389e11c1bc, 0x00000247471fe1bf, 0x000004497b3dc605, 0x0000000000000000, 0x000005cdb7afb2f3, },
    { 0x000005bad39cdfc0, 0x00000668e2fdd194, 0x0000000000000000, 0x0000037093abe788, 0x000000f77bf00837, 0x000000d42ba1eb94, 0x0000000000000000, 0x000000ab840da806, },
  },
  // compressed: 0x2576de90adfa270ae3c831149ed12782cb594a215cdb990f251ce72e92b3d6dc
  {
    { 0x00000159b8443d37, 0x000002ad90de7625, 0x0000000000000001, 0x00000194d633ebc7, 0x00000260068f4f7e, 0x000005ae10a52ce5, 0x0000000000000000, 0x0000004f70668a15, },
    { 0x000001ec9f2e2a70, 0x000006391c6144ff, 0x0000000000000000, 0x000006f4f7de0795, 0x000004e9eb8599c1, 0x00000671c250f99d, 0x0000000000000000, 0x0000038842853f43, },
    { 0x0000000acf6dab5b, 0x000006089f467850, 0x0000000000000000, 0x000007844449b9e8, 0x0000004f1f9179ae, 0x000000b9ad67245d, 0x0000000000000000, 0x0000008d0c2a5235, },
  },
  // compressed: 0x6feb4cd55138402c676bfdcdea2922ed2b79e2185321adf485948853f3e22355
  {
    { 0x0000019c54a5efd2, 0x00000051d54ceb6f, 0x0000000000000001, 0x0000036e7bd0d4de, 0x000001c789ea7de7, 0x000000a98c713c95, 0x0000000000000000, 0x0000013e59e4261a, },
    { 0x000002f3f2ee3421, 0x000007ad6ce58807, 0x0000000000000000, 0x0000047e3c535f4a, 0x0000014edd3dc18b, 0x00000089485f4ad2, 0x0000000000000000, 0x000001b0f9888f5a, },
    { 0x000007d7141a83c1, 0x000007b488a7ab37, 0x0000000000000000, 0x0000043d8496ad96, 0x000000c6db6cd4b1, 0x000000aa47c5e6a7, 0x0000000000000000, 0x000000a5119ecaab, },
  },
  // compressed: 0x1c88d9f029b6920f710e57e513fbb1fcfbba4b48894fee5fd24152f4850cc792
  {
    { 0x000000c50a97289b, 0x00000629f0d9881c, 0x0000000000000001, 0x000005a5e538767f, 0x0000016307bb4494, 0x000007c4a425dd7d, 0x0000000000000000, 0x000007b4ea6a99a8, },
    { 0x0000002547f652b9, 0x000002e1ce21f256, 0x0000000000000000, 0x0000012c198d48b7, 0x000001646146dd6f, 0x000005241d25fee4, 0x0000000000000000, 0x000003629553c939, },
    { 0x00000563faaeebaa, 0x000007f2c7ec4f95, 0x0000000000000000, 0x00000580a64c1f4c, 0x000000c7e036aab5, 0x000000258e190be8, 0x0000000000000000, 0x00000086e2ca82d5, },
  },
  // compressed: 0x86adfdddfbb1d5e18d77b6e4babf81ad1fdd80991919786bb721971b5f98fe46
  {
    { 0x0000022836e64b9a, 0x000001fbddfdad86, 0x0000000000000001, 0x0000018588e2dfa7, 0x000001a7a3f9b23a, 0x0000048cccc06e8f, 0x0000000000000000, 0x0000074bec4e3a72, },
    { 0x000002a74e2c2601, 0x000006cef1bc3ab6, 0x0000000000000000, 0x000000ebdd53fea0, 0x000002dd23c84652, 0x000001721b76b781, 0x0000000000000000, 0x0000043294e6a0e5, },
    { 0x00000540da9343d2, 0x000006b606feeb92, 0x0000000000000000, 0x0000059ce7d007f4, 0x0000007d48db8e58, 0x0000008dfd30be37, 0x0000000000000000, 0x0000001116194fbe, },
  },
  // compressed: 0xc06cfefe540e6710941de5a8539dbb0edfa335f5230e9ffa93e85eaf005775bc
  {
    { 0x000005337c54aa9d, 0x00000654fefe6cc0, 0x0000000000000001, 0x00000296d7c70596, 0x000000eb4a88cdac, 0x00000711fa9ad1ef, 0x0000000000000000, 0x000003346a10e06b, },
    { 0x0000006df9a4c888, 0x000004a3b2820ce1, 0x0000000000000000, 0x000007603e6f13e7, 0x000000e1379ed8fa, 0x000005ee893fa9f0, 0x0000000000000000, 0x00000277aad64164, },
    { 0x000001db423af9f9, 0x0000043aee754ea3, 0x0000000000000000, 0x000006abe3f9ec2b, 0x000000fab60a8c22, 0x00000078eaae015e, 0x0000000000000000, 0x00000035cb8ac967, },
  },
  // compressed: 0x4b5902034cad09da845b6a7cd4e6fb13a4e28508c0e700456326d99811641aa0
  {
    { 0x000006863e708d5b, 0x0000054c0302594b, 0x0000000000000001, 0x0000053be2a1592b, 0x000006740f3a2ec8, 0x000003e00442f152, 0x0000000000000000, 0x0000049e6e212625, },
    { 0x000004b654bfb11c, 0x0000054b709b4135, 0x0000000000000000, 0x0000071883eb7b43, 0x000002f17860f307, 0x000005926634500e, 0x0000000000000000, 0x000007e0b2655794, },
    { 0x0000012796b71322, 0x0000004fef9b51f1, 0x0000000000000000, 0x000004af6eaaa98a, 0x000000bb39e3d031, 0x0000004034c82331, 0x0000000000000000, 0x00000075414186c3, },
  },
  // compressed: 0x93f6df08e55f1c948d830f66ab12d0c744a5775cdde926474003b208f790613e
  {
    { 0x00000621e149ef2e, 0x000007e508dff693, 0x0000000000000001, 0x00000632ac67b877, 0x000002ae4f3c5998, 0x000004eeae3bd2a2, 0x0000000000000000, 0x0000027bd87424d6, },
    { 0x000000ce2d20cf8d, 0x000001f071b2838b, 0x0000000000000000, 0x000007d841272915, 0x0000051a129b0aa7, 0x000003203404726e, 0x0000000000000000, 0x0000071d74b61742, },
    { 0x0000023383040940, 0x0000031f404aad98, 0x0000000000000000, 0x000005e8888a3d51, 0x000000ddc613e461, 0x0000007cc321ee11, 0x0000000000000000, 0x000000c99bd306c9, },
  },
  // compressed: 0xfa4f6cb682b9fe42c8051fc6101bb4b80f3b95875779222d07302044c17c7619
  {
    { 0x000006e4071f6450, 0x00000182b66c4ffa, 0x0000000000000001, 0x000007e08e9dc54b, 0x000006d20014a7d9, 0x000004abc3ca9d87, 0x0000000000000000, 0x000000a7ed652762, },
    { 0x000003ea3ee4e1fa, 0x000003e0b9085fd7, 0x0000000000000000, 0x000001c309a0b7c1, 0x0000045383184f2f, 0x000002030072d227, 0x0000000000000000, 0x0000001c3e8af0cb, },
    { 0x000005f4e3da3ef8, 0x000006e2d06c4318, 0x0000000000000000, 0x000001cbbbbcd65e, 0x0000005883501cb6, 0x00000032ecf98288, 0x0000000000000000, 0x00000072778f6ef9, },
  },
  // compressed: 0x158ccd68a8673bb1c96ecd38fa138556b4d20549f6b9ec7b96363dac9955bbee
  {
    { 0x00000645b73f4755, 0x000007a868cd8c15, 0x0000000000000001, 0x000005da306059bd, 0x0000029de2e060bd, 0x000004fb2482e95a, 0x0000000000000000, 0x0000026867d64b4d, },
    { 0x00000773615d3770, 0x000001add936276c, 0x0000000000000000, 0x000007ccbf485398, 0x0000024ee63f7b91, 0x000003d36967becb, 0x0000000000000000, 0x00000194c8c30660, },
    { 0x0000027d72d43620, 0x0000015a144fe8e3, 0x0000000000000000, 0x00000499b7af959d, 0x000000f819d77a19, 0x000000dd76ab3358, 0x0000000000000000, 0x000000f9d5a22ed5, },
  },
  // compressed: 0x22e64dc6081e1b6250918c7b3d3b2b470812b0271cb636dddc0a4dfe746381fb
  {
    { 0x000004db68564783, 0x00000608c64de622, 0x0000000000000001, 0x000003c104113fcc, 0x000001f0919771e9, 0x0000030e13d80904, 0x0000000000000000, 0x0000063aeb2fd20a, },
    { 0x000005825866dfc9, 0x000001922a0c4363, 0x0000000000000000, 0x0000014e6b0a52e3, 0x000004d75517fcb9, 0x000004d0adcdd36b, 0x0000000000000000, 0x000006f01638f279, },
    { 0x0000044cca1d0759, 0x0000011cacecf5ee, 0x0000000000000000, 0x00000170f1f43e23, 0x00000065ce7af882, 0x000000f702c6e9fc, 0x0000000000000000, 0x000000dead5c79d2, },
  },
  // compressed: 0xb9b4f686e1a37a47357925f3a05f6681bf364d668edb7345e9b02ac96fc9cbab
  {
    { 0x000006ed8c1e9273, 0x000003e186f6b4b9, 0x0000000000000001, 0x0000073e611f6329, 0x000003d16a797b93, 0x000005c733269b5f, 0x0000000000000000, 0x0000023ad237161a, },
    { 0x000002dacbaba712, 0x000004af26a8ef54, 0x0000000000000000, 0x00000039c82d813e, 0x000007b3d179b8d3, 0x000002ab0e94573d, 0x0000000000000000, 0x000002848cd50e00, },
    { 0x0000037e4dad0d18, 0x00000605997e83cc, 0x0000000000000000, 0x000007c0cec51aa2, 0x000000dfe4f53fd5, 0x000000579792df92, 0x0000000000000000, 0x000000e56b4b6dbc, },
  },
  // compressed: 0xc337a328462c713c07a33f63a3971c9a773924851803a46b087dde6faaa78534
  {
    { 0x00000774ed68e720, 0x0000044628a337c3, 0x0000000000000001, 0x0000027b7f55128e, 0x0000059caec8a00e, 0x0000018c42921cbb, 0x0000000000000000, 0x00000678b4704426, },
    { 0x000005e2957e26d2, 0x000007f460e78e25, 0x0000000000000000, 0x000000c5b2e4a691, 0x000007b7167fc516, 0x000005e7d086ba40, 0x0000000000000000, 0x0000068d142b373e, },
    { 0x000007e37426652f, 0x00000668725e8d8c, 0x0000000000000000, 0x000000dd2f2dd756, 0x000000c35422c1b2, 0x000000690b4f54df, 0x0000000000000000, 0x00000058d9c0a07d, },
  },
  // compressed: 0x1a9b4676e6174f891ee321e0e1ec0c34438a1203b8a9e00ea7933378532b8c8f
  {
    { 0x000007b19c632889, 0x000007e676469b1a, 0x0000000000000001, 0x0000001df2db5c75, 0x000002b64d7b490d, 0x000004dc01894521, 0x0000000000000000, 0x000001775c4ed6a7, },
    { 0x000005489e51b05b, 0x0000043c63d129e2, 0x0000000000000000, 0x000001a33bc5e346, 0x000006497a9e4eee, 0x000003393a70ee0a, 0x0000000000000000, 0x0000058ddf578e00, },
    { 0x0000017a5b3370a4, 0x000004d033b38780, 0x0000000000000000, 0x00000775038242a0, 0x0000001cef5a3b24, 0x0000001f1856a6f0, 0x0000000000000000, 0x0000009983ca98e4, },
  },
  // compressed: 0x9ce13a6bd8e19bb838bd807994a71e03f91334fe9fc3458677de327a23f29472
  {
    { 0x000000667543638e, 0x000001d86b3ae19c, 0x0000000000000001, 0x00000017f77d3efd, 0x00000753a054ddb3, 0x000001cfff1a09fc, 0x0000000000000000, 0x0000071ba78132ef, },
    { 0x000001c91f7e7f98, 0x00000017a717137c, 0x0000000000000000, 0x0000053e486dcb10, 0x000005142e4f5c9a, 0x0000032de778645c, 0x0000000000000000, 0x000006662a4bda9c, },
    { 0x000003d0987de191, 0x0000040c7a9e51e6, 0x0000000000000000, 0x0000027b477678e1, 0x000000c5de7fb9ce, 0x000000e529e446f4, 0x0000000000000000, 0x000000325190fa2a, },
  },
  // compressed: 0x29720866d547384ac65897b5caa2a92d1b29ce7560a8555794fa99441dece04a
  {
    { 0x0000055ab57e2130, 0x000007d566087229, 0x0000000000000001, 0x0000039ba2be7da7, 0x00000276845e964c, 0x000004303ae7148d, 0x0000000000000000, 0x0000024bc9e85fe2, },
    { 0x0000009ebea36192, 0x000002eb18c94708, 0x0000000000000000, 0x0000040fbab07ad9, 0x0000058f63042047, 0x0000019fa945755a, 0x0000000000000000, 0x0000023170eaebfa, },
    { 0x000005bfadfef659, 0x000004b6a68b2ad6, 0x0000000000000000, 0x00000219ac766033, 0x000000efb682ee88, 0x00000095c1d83a89, 0x0000000000000000, 0x0000002fe3668c3b, },
  },
  // compressed: 0x86286c033d6ba1099ae7e4e34e5dc7ba007b4194e758c7ab4dd243f4432ca878
  {
    { 0x0000019b3403ce52, 0x0000033d036c2886, 0x0000000000000001, 0x00000112702675c4, 0x000006bda2bb539a, 0x00000473ca20bd80, 0x0000000000000000, 0x000003ad7be2563f, },
    { 0x000004e21cb1c983, 0x0000049cf341342d, 0x0000000000000000, 0x00000528e9c0ad70, 0x000005a9626d1762, 0x0000043d24dabc75, 0x0000000000000000, 0x000001bb3904539a, },
    { 0x000004b28d8469ed, 0x000002eb1d753b8f, 0x0000000000000000, 0x000007bf44e7ad11, 0x0000007b37334275, 0x000000f1505887e8, 0x0000000000000000, 0x00000016924117b0, },
  },
  // compressed: 0x82070d0afb50fd03d6ee986e71edc8ea0898006f989363c14814d5a24da640be
  {
    { 0x000004b32d287241, 0x000000fb0a0d0782, 0x0000000000000001, 0x0000052e9dca709f, 0x0000017e79b46c07, 0x000001cc37804c04, 0x0000000000000000, 0x0000077b78971fca, },
    { 0x000002b09826b75b, 0x0000031ddac07faa, 0x0000000000000000, 0x000007ff97b2feb4, 0x0000072852187ac1, 0x00000551448c1639, 0x0000000000000000, 0x000005fbeb41f5ba, },
    { 0x000001ecf45dd712, 0x000003ab23b5c5ba, 0x0000000000000000, 0x000004948b426f1c, 0x0000002afdcf65c3, 0x0000007c814c9b45, 0x0000000000000000, 0x000000b44ee22b8a, },
  },
  // compressed: 0x554c85e521d9407bb231de6f387b3c276e2e124e506e63e3733ddd9218194e0f
  {
    { 0x00000015328300cc, 0x00000121e5854c55, 0x0000000000000001, 0x00000412ec4132ed, 0x000006beac36dc78, 0x0000072827091737, 0x0000000000000000, 0x000001ca2fb843ca, },
    { 0x000000f4f8556246, 0x000003c6364f681b, 0x0000000000000000, 0x00000456b7b877a3, 0x000007dfeee4f382, 0x000005d3d73e3636, 0x0000000000000000, 0x000006dd62786f49, },
    { 0x00000321fb1dff56, 0x0000009cf1ece1bf, 0x0000000000000000, 0x00000387d1816364, 0x0000008d13605562, 0x0000001e9c323125, 0x0000000000000000, 0x000000764865d793, },
  },
  // compressed: 0xefd8c78197890017288c396f085a2ba42fc63638622b22b4c1d0280333d11fb6
  {
    { 0x000004c2b78c2e59, 0x0000019781c7d8ef, 0x0000000000000001, 0x0000048165159986, 0x00000204f6e04b1e, 0x000005b11c1b6317, 0x0000000000000000, 0x0000040b6a7d0222, },
    { 0x0000002f92b777d9, 0x000007318502e011, 0x0000000000000000, 0x000000a1e89a4561, 0x000002dbbb98dff3, 0x0000028d0c1b4222, 0x0000000000000000, 0x0000032c486b1596, },
    { 0x0000043764dce0c7, 0x00000690ad6821bc, 0x0000000000000000, 0x000002e25ce445df, 0x000000d8ab83e556, 0x0000006c3fa26606, 0x0000000000000000, 0x00000079b08b524f, },
  },
  // compressed: 0xdf51192cd706f512f52ff8e86533eafb758e1b48a2b06a55adf24772ac98f945
  {
    { 0x000005addf6fd3b0, 0x000006d72c1951df, 0x0000000000000001, 0x00000728c55d3ecd, 0x000005ab6907236e, 0x00000051240dc73a, 0x0000000000000000, 0x0000016ab92a2667, },
    { 0x000002ebd6e3a2e2, 0x00000705fea25ea0, 0x0000000000000000, 0x0000052a66f48160, 0x00000291ad10f566, 0x0000047f2ad556ab, 0x0000000000000000, 0x000006d531bff46c, },
    { 0x00000101c8a9f9e3, 0x000007efa8cd97a3, 0x0000000000000000, 0x0000035b850d3119, 0x0000006c243d141b, 0x0000008bf33158e4, 0x0000000000000000, 0x00000047610d9e0c, },
  },
  // compressed: 0x8fd5bdb48060668d31ba348609a47cbd39bc2c013545fe4415164f0119fac516
  {
    { 0x00000118ea05195e, 0x00000080b4bdd58f, 0x0000000000000001, 0x0000016ee772f53b, 0x0000028496694799, 0x0000029a80965e1c, 0x0000000000000000, 0x000004e1ab4b0388, },
    { 0x0000002d20b86d6a, 0x000006974631accc, 0x0000000000000000, 0x0000039d12a1e8a8, 0x000006e8a74ea338, 0x000004f161544fe4, 0x0000000000000000, 0x00000473050affd2, },
    { 0x000002c7514508df, 0x000006f5f2902618, 0x0000000000000000, 0x000003263fe3172e, 0x00000003d76a7118, 0x0000002d8bf43202, 0x0000000000000000, 0x00000090c9de3030, },
  },
  // compressed: 0x30b8d00b3aa80dcd28341cb99beb4e86f43e15049b3e6fe650c26b7fed3ac0a6
  {
    { 0x0000033297639ab3, 0x0000003a0bd0b830, 0x0000000000000001, 0x0000022f581c7dce, 0x000005c41db11e07, 0x0000074d820a9f7a, 0x0000000000000000, 0x0000053ddcc4d21e, },
    { 0x0000051a71df02f8, 0x000003868519a1b5, 0x0000000000000000, 0x000005352db2c3cf, 0x000005baf6c5cc04, 0x000006bc250e66f3, 0x0000000000000000, 0x0000061d75490d94, },
    { 0x000004d11f1eac81, 0x000002193bae6ee4, 0x0000000000000000, 0x000000ea7a258120, 0x00000054f5b81869, 0x0000004d8075dafe, 0x0000000000000000, 0x000000f16a2d32b3, },
  },
  // compressed: 0x40cc69575ac85cf92bd34d573a95fee636a88655168acb1db421cd4b22c07ec5
  {
    { 0x00000254df5d180d, 0x0000005a5769cc40, 0x0000000000000001, 0x000006fe8f26908a, 0x0000051aa447388f, 0x0000050b2ac3541b, 0x0000000000000000, 0x0000049b7542677d, },
    { 0x0000053a8ca21f30, 0x000001ba657f2b99, 0x0000000000000000, 0x000002a75a6f3d15, 0x0000071e70927572, 0x000004d21b41dcb8, 0x0000000000000000, 0x000004f0a49bb8b7, },
    { 0x000005d418541ff3, 0x0000039bfa54e95d, 0x0000000000000000, 0x0000005aeecc77ed, 0x0000000462979206, 0x0000008afd804497, 0x0000000000000000, 0x000000f2ae58a69f, },
  },
  // compressed: 0x979574e000433b34c40464902326375fa4c98896abf693141c9af1e7b6c090f8
  {
    { 0x0000023ca35b2d6f, 0x00000300e0749597, 0x0000000000000001, 0x000000b7fdd75dc4, 0x000003c406cb7502, 0x00000355cb4464d2, 0x0000000000000000, 0x00000118f65a4242, },
    { 0x00000598372473b6, 0x0000048098868768, 0x0000000000000000, 0x00000702d37e9228, 0x0000060ef3f04333, 0x00000719a1c1493f, 0x0000000000000000, 0x000001a70aa2b58e, },
    { 0x000002ec2836eae4, 0x0000017cdc988e41, 0x0000000000000000, 0x0000068ecc0e616b, 0x000000e1bbf1b316, 0x000000f121816dcf, 0x0000000000000000, 0x0000008aed2d23d1, },
  },
  // compressed: 0xad43a65bdc3d0e396b1bb9e9d9fe5c88909d67561074ae8b787c5cb006f7c0ae
  {
    { 0x00000305345b2ddb, 0x000005dc5ba643ad, 0x0000000000000001, 0x00000694608f59d8, 0x000006f7eeaaf0be, 0x000002082b33cec8, 0x0000000000000000, 0x0000033715270a38, },
    { 0x0000005d736a9c7c, 0x000007236d6721c7, 0x0000000000000000, 0x000007a18f9f8742, 0x000001c1d8202235, 0x000005c7c788bae7, 0x0000000000000000, 0x000003f46a79050b, },
    { 0x0000051ea730d7b0, 0x0000022173fb67a6, 0x0000000000000000, 0x0000022537b87ef8, 0x000000216e8465e0, 0x0000005d81ee0d60, 0x0000000000000000, 0x000000badf53a4b4, },
  },
  // compressed: 0xdda6a3b2fe5a2cac650ef09d07ed6ca6ad9c9f18f6cb4c061ce7c98718a44fd7
  {
    { 0x00000185e46e6cbb, 0x000002feb2a3a6dd, 0x0000000000000001, 0x000001dade891efa, 0x000002fbfabe9323, 0x000005fb0c4fce56, 0x0000000000000000, 0x000004c114a70a88, },
    { 0x00000447ca48dbe8, 0x00000601ccb5858b, 0x0000000000000000, 0x000005dcfb1925a5, 0x000005f697a797ff, 0x0000049e71c064cc, 0x0000000000000000, 0x000002ab932f2355, },
    { 0x000000a9a73004bc, 0x00000699b3b41e77, 0x0000000000000000, 0x0000043ce9cfb448, 0x000000c8bce09eee, 0x000000ae9f48310f, 0x0000000000000000, 0x000000e841cae9b9, },
  },
  // compressed: 0x1c4b23943f6e3ef8101c429be6617bc8a554c493b0334b4575c0cdc3a90fa62b
  {
    { 0x00000138a034513c, 0x0000063f94234b1c, 0x0000000000000001, 0x0000011c21d364c9, 0x00000480c6a37253, 0x000001d849e22a52, 0x0000000000000000, 0x000000ece0038e4b, },
    { 0x0000073a73beecd4, 0x00000043821f07cd, 0x0000000000000000, 0x0000044944b47ac9, 0x0000001b3d328ae3, 0x000004dc075454b3, 0x0000000000000000, 0x0000035f3cf56f51, },
    { 0x0000003f9880bd1b, 0x00000721ed879a6d, 0x0000000000000000, 0x0000051768eeb194, 0x00000089de8c656b, 0x000000574c1f5387, 0x0000000000000000, 0x000000e0a9133889, },
  },
  // compressed: 0xcf6db1aa0b4e9538d7651578c06c16fa537db84d67e29ac78151079d71c546d1
  {
    { 0x000003c5b775ea51, 0x0000060baab16dcf, 0x0000000000000001, 0x00000168c8681fda, 0x0000008c7c55894b, 0x00000133a6dc3ea9, 0x0000000000000000, 0x000002305677b6bd, },
    { 0x000007078af67631, 0x000002acbae712a9, 0x0000000000000000, 0x0000033b69a2add5, 0x000002d6894e8efa, 0x00000075181c79ae, 0x0000000000000000, 0x000007a482999ca3, },
    { 0x0000044864c96898, 0x000007e859b301e0, 0x0000000000000000, 0x0000008bc1c8faa4, 0x000000e4d2f618a1, 0x000000a28d8ae33a, 0x0000000000000000, 0x000000421f3c5cee, },
  },
  // compressed: 0x24d3bbfe2786a02e9d2abdab09ffdf4ef5dda73743a4df603938aa55fa7184dc
  {
    { 0x0000008cf3d2c42b, 0x00000627febbd324, 0x0000000000000001, 0x000005db7b39cf58, 0x00000392c39d4569, 0x000002219bd3eefa, 0x0000000000000000, 0x000000c26909d149, },
    { 0x000000e83dffcd5b, 0x000007a553a5d410, 0x0000000000000000, 0x000005ce3a055a90, 0x000004c89d7f0903, 0x000002a383960dfa, 0x0000000000000000, 0x000005545c9e93f5, },
    { 0x000004cd0d884a0f, 0x0000053b7ffc26ae, 0x0000000000000000, 0x0000001e6a53f144, 0x00000042a2596558, 0x000000b908e3f4ab, 0x0000000000000000, 0x0000007e0c57ed75, },
  },
  // compressed: 0xa8252f20345f91099b9917814e59db1b459512b9e0be3eb33d8f0b5b3c9a63c7
  {
    { 0x0000040025281fc5, 0x00000734202f25a8, 0x0000000000000001, 0x0000068da17fa067, 0x0000012612ca0e66, 0x000007705c894aa2, 0x0000000000000000, 0x000007c653e2a6c0, },
    { 0x000000f9469fcadc, 0x000002f33361322b, 0x0000000000000000, 0x0000056a539d8d1c, 0x0000010986b46c6b, 0x000000b8f3db33eb, 0x0000000000000000, 0x00000429f19c8c75, },
    { 0x00000783bbb753f0, 0x0000046f6d653a04, 0x0000000000000000, 0x0000031a4b741f4b, 0x000000c784618b57, 0x0000008ec73478b6, 0x0000000000000000, 0x0000003185a95d3a, },
  },
  // compressed: 0xe315b8aaf66d29bf4bce7086d808870f0584133625c0ae05c160f06bd7ccf976
  {
    { 0x0000055fe9678090, 0x000005f6aab815e3, 0x0000000000000001, 0x0000009ea75ff17d, 0x000004ee2abff5c3, 0x000000129b09c202, 0x0000000000000000, 0x0000014d7389d75e, },
    { 0x000007e8b6ea3b7b, 0x00000619c977e52d, 0x0000000000000000, 0x000004e190cbdec1, 0x0000078e3a1b5e33, 0x000007060c105aec, 0x0000000000000000, 0x0000017912799fdf, },
    { 0x0000021178baef1f, 0x0000043e1c236219, 0x0000000000000000, 0x0000066bf86289e0, 0x000000e4bfc29c74, 0x000000edf399aed7, 0x0000000000000000, 0x00000020b8e3939c, },
  },
  // compressed: 0x4948e66cdd6031b3d12bb3a0c3c0ae22ad9d9f5a69af70c2422a9cee9dd5a8ea
  {
    { 0x000005b2b9ce83bb, 0x000000dd6ce64849, 0x0000000000000001, 0x000000ab015c2a6c, 0x0000050d17b65bdd, 0x000007b4ad4fced6, 0x0000000000000000, 0x000002965e14aaa6, },
    { 0x000004525a27f692, 0x000006657a36662c, 0x0000000000000000, 0x000004ec614bdc59, 0x000007552f3d969b, 0x000001c2a42c270a, 0x0000000000000000, 0x0000027b964fa368, },
    { 0x00000088490b8d2b, 0x0000048abb030e82, 0x0000000000000000, 0x000000b98cb4395e, 0x00000006b6f32752, 0x000000d551ab3bdd, 0x0000000000000000, 0x0000006e772638ba, },
  },
  // compressed: 0x0530b7edb017dada2021ce5a33a0b88852b75e6770883f277cdd89a646c65a91
  {
    { 0x0000063764bda849, 0x000007b0edb73005, 0x0000000000000001, 0x000007219c8ee83b, 0x00000600c69db7c8, 0x0000043833af5ba9, 0x0000000000000000, 0x000005b91a5c8691, },
    { 0x00000681856ec154, 0x000001c4241b5b42, 0x0000000000000000, 0x0000039a2af59e5d, 0x000002c68c97080a, 0x0000009dd7c273f8, 0x0000000000000000, 0x0000079c8c6ca549, },
    { 0x0000063889f63010, 0x00000222e280cd6b, 0x0000000000000000, 0x0000023dd7da3ef2, 0x000000bdcfff1f82, 0x00000022b58c8d4d, 0x0000000000000000, 0x00000079f3782678, },
  },
  // compressed: 0x1a9cb917759c3672c3623fc1aef574c70d8345f57d062aa2a6e16c086ec1fabf
  {
    { 0x000000ef47011b9b, 0x0000047517b99c1a, 0x0000000000000001, 0x000000153454e375, 0x00000222d36a5289, 0x0000033efaa2c186, 0x0000000000000000, 0x0000023806946e48, },
    { 0x0000045d18b5977d, 0x000007ec586e46d3, 0x0000000000000000, 0x0000033bd961b3c4, 0x0000018eb88d1533, 0x000006ce1a6a22a0, 0x0000000000000000, 0x000005e619a9f53e, },
    { 0x000007f634ba9f3c, 0x0000071dd3d6bb04, 0x0000000000000000, 0x000007e33d0b399b, 0x000000a6cde4a765, 0x0000007ff582dc10, 0x0000000000000000, 0x0000006a9462db62, },
  },
  // compressed: 0x64eed65713f6573704f9ab0644e6d2fd26c3aff74a541bc7a5e77e04b3d1b642
  {
    { 0x000002ecbaa99b58, 0x0000061357d6ee64, 0x0000000000000001, 0x0000006916c1ae74, 0x0000020e2890f4fa, 0x000002257bd7e193, 0x0000000000000000, 0x000003261038b8ce, },
    { 0x0000017b12bab6a5, 0x0000057f2086eafe, 0x0000000000000000, 0x00000713a3b066c5, 0x000000f78e28c175, 0x000007ee7a5c71b5, 0x0000000000000000, 0x00000339dddcb6a2, },
    { 0x0000036b2ae2482b, 0x000003f74b99101a, 0x0000000000000000, 0x000003d493b499e4, 0x000000fa5041f1af, 0x000000856da36608, 0x0000000000000000, 0x0000002a4cb19e1c, },
  },
  // compressed: 0xb5bbab2cf9bf5d1b61a2474d0e57dbaf6d82b5f887c0a94bb4d3da32cdfd7efa
  {
    { 0x00000316adbbce0f, 0x000007f92cabbbb5, 0x0000000000000001, 0x000006dfd8edd67d, 0x000006ba469c42f6, 0x00000043fc5ac136, 0x0000000000000000, 0x0000048c474fa2aa, },
    { 0x00000721c47c7f99, 0x000000f44c236bb7, 0x0000000000000000, 0x000005ebf0caf3e2, 0x000001ea3c8ea1ea, 0x000005ad3b44ba9c, 0x0000000000000000, 0x00000576e4f8748d, },
    { 0x0000007b109fe4d4, 0x000006bf6d5c3935, 0x0000000000000000, 0x00000718c808963d, 0x000000c2acada5a1, 0x000000f4fdfb9a65, 0x0000000000000000, 0x000000d3ad629642, },
  },
  // compressed: 0xcccab587e2f8d58ae787d2489448c2ce86973dfb97c952bf49c86ee14d4347e4
  {
    { 0x000000c1e139943d, 0x000000e287b5cacc, 0x0000000000000001, 0x000005f9b56c8a52, 0x0000040ae5950a65, 0x000004cbfd9ecbc3, 0x0000000000000000, 0x000002ad753204b1, },
    { 0x0000060cd77f26cd, 0x00000250fcf15abf, 0x0000000000000000, 0x0000067ac000199c, 0x0000047b9639986b, 0x000006ec849bf52c, 0x0000000000000000, 0x000004d7b5a16e8f, },
    { 0x0000033ba732a697, 0x0000033b09225123, 0x0000000000000000, 0x00000740a6d6d5ab, 0x0000000b1ce4491f, 0x000000c88e869bc2, 0x0000000000000000, 0x000000ecac454d2f, },
  },
  // compressed: 0xee5dc328f5e69a25ae9a6206024d1eaafe3d196d1731d75d2c0ba8496bc0d30f
  {
    { 0x0000046531259caa, 0x000006f528c35dee, 0x0000000000000001, 0x0000006bd94ccf04, 0x000000d010308f1a, 0x0000008bb68c9eff, 0x0000000000000000, 0x000007cfd8378913, },
    { 0x0000074496f7e5e1, 0x0000045355c4b35c, 0x0000000000000000, 0x000000376bf6beea, 0x0000068d71c9b980, 0x00000280b2c5dd73, 0x0000000000000000, 0x0000004b32364db9, },
    { 0x00000066d124756f, 0x000002a879340819, 0x0000000000000000, 0x00000334ec018fce, 0x000000e74bde9e36, 0x0000001fa780d693, 0x0000000000000000, 0x000000069b4d24f5, },
  },
  // compressed: 0x89094adcd1683ef62fb1a8270a9a1cdc3a10771a81c65ab8fd01c3aa937b004d
  {
    { 0x0000054349447af4, 0x000000d1dc4a0989, 0x0000000000000001, 0x000003a341fc4970, 0x000000ddca8f061c, 0x000003408d3b881d, 0x0000000000000000, 0x000006baf558a77b, },
    { 0x000003564a3de523, 0x0000051625fec7cd, 0x0000000000000000, 0x00000472327f5f27, 0x000001a252571fb6, 0x000004301fdb85ac, 0x0000000000000000, 0x000002c47bf702b0, },
    { 0x000006470f49c13d, 0x000003707268289e, 0x0000000000000000, 0x000005c2317c73a9, 0x000000029fd5f399, 0x0000009a00f72755, 0x0000000000000000, 0x0000003ad93fb054, },
  },
  // compressed: 0x823771b2b9b15d3b629901a2d4a5e27d280d9d1fc02139b3252f41a25c9df298
  {
    { 0x0000071c7882e37f, 0x000001b9b2713782, 0x0000000000000001, 0x00000459f89c73cd, 0x000000efa9e72c12, 0x000000e00fce8694, 0x0000000000000000, 0x000007a82fbb6901, },
    { 0x0000018efeb99a68, 0x000000332c476bb6, 0x0000000000000000, 0x00000516c40354e4, 0x00000295d8e7fb9f, 0x00000412f25b3392, 0x0000000000000000, 0x000006479f43b4b5, },
    { 0x0000015b158050da, 0x000001f78a975288, 0x0000000000000000, 0x0000035e5a43a4bc, 0x000000c08328a26b, 0x00000031e53ab944, 0x0000000000000000, 0x00000081333aeae9, },
  },
  // compressed: 0xf381bb5896bbade8b644dbed90649a7e08e676f74a401fed68404c3c45270f2c
  {
    { 0x00000355bddfe4fe, 0x0000039658bb81f3, 0x0000000000000001, 0x00000759c7b77b25, 0x000005d3e188d37a, 0x000000257bbb7304, 0x0000000000000000, 0x0000002241d5c30b, },
    { 0x000006fd5bc014c7, 0x0000036896dd15b7, 0x0000000000000000, 0x0000012f1d301aa1, 0x0000074aa737d4b9, 0x000004c4068ed1f4, 0x0000000000000000, 0x000003a38ee2f9c8, },
    { 0x000001167a015e01, 0x000001fa699243b7, 0x0000000000000000, 0x000005708415c134, 0x000000a61b3bd64c, 0x000000581e4e8a78, 0x0000000000000000, 0x000000d38de4213b, },
  },
  // compressed: 0x5d9f04cbd99ee7fa2b93fa2338d05eaed7260ae35cb6cb3bea9d7b8eb1885633
  {
    { 0x000004d945e12bbe, 0x000006d9cb049f5d, 0x0000000000000001, 0x000007ee97eb0e8d, 0x000005bce3479fa4, 0x0000032e7185136b, 0x0000000000000000, 0x0000038b5a70e808, },
    { 0x00000180d0fd59fd, 0x00000752657f5cf3, 0x0000000000000000, 0x000003cabe58b711, 0x000003614ade3420, 0x000007b9dea3bcbb, 0x0000000000000000, 0x0000076503dd4e35, },
    { 0x000004e4ee0e8a86, 0x000006b97b40e08f, 0x0000000000000000, 0x000000adc6e0adfb, 0x000000ee3392411e, 0x00000066ad11631c, 0x0000000000000000, 0x000000fe560ea897, },
  },
  // compressed: 0xca26e8f785b434f2f364fc8af43b16fa91ca66058648ce57e60b58f7d44f587f
  {
    { 0x0000037cc23d4478, 0x00000485f7e826ca, 0x0000000000000001, 0x000000d6ec48bee6, 0x000001273097c21a, 0x0000044302b36548, 0x0000000000000000, 0x0000014996b50b3c, },
    { 0x000006a7af7ab05e, 0x0000078c9e7e4696, 0x0000000000000000, 0x0000013d8e2bacb1, 0x000007d830bcf105, 0x00000580be657ce4, 0x0000000000000000, 0x000005cdba2ace4d, },
    { 0x000001c9d60535b8, 0x000007e858efd22b, 0x0000000000000000, 0x000003fa89e17f5a, 0x000000cb2f7d812a, 0x000000feb09fa9ee, 0x0000000000000000, 0x000000b38da4e047, },
  },
  // compressed: 0x8093c0cb469f49d2fe23aea111ddb8c3437188aec6d60a757b7520effbc89f62
  {
    { 0x0000012f4c72d638, 0x00000746cbc09380, 0x0000000000000001, 0x000002dd9750cce6, 0x00000349a73a89c9, 0x00000363574438a1, 0x0000000000000000, 0x00000363814d83e2, },
    { 0x00000505d192a735, 0x000005c47fda4933, 0x0000000000000000, 0x0000031009620f6c, 0x0000014905391d39, 0x0000020757b750ad, 0x0000000000000000, 0x0000067d25cfd83e, },
    { 0x000005ce7c60190c, 0x0000070ee3744686, 0x0000000000000000, 0x0000020147bb8081, 0x000000bea4b17a14, 0x000000c53f91f7de, 0x0000000000000000, 0x00000047cf3b33e5, },
  },
  // compressed: 0xbe150add8187e8f4607ee7378a7c3814d212de1e19f9ee1882c956a979d3554d
  {
    { 0x0000071c254d32f8, 0x00000781dd0a15be, 0x0000000000000001, 0x000001ad0ef0d9a7, 0x000005fbc5848967, 0x0000048c8f6f0969, 0x0000000000000000, 0x000000b1383d8f16, },
    { 0x00000239cc5161e8, 0x000004efcc1e9d10, 0x0000000000000000, 0x000003730d78738e, 0x0000036c51166262, 0x0000056c98218eef, 0x0000000000000000, 0x00000774ec102424, },
    { 0x000004ac609babd2, 0x00000050e1f228df, 0x0000000000000000, 0x000000bab6b5ddf2, 0x000000b3d86e01ac, 0x0000009aaba6f352, 0x0000000000000000, 0x0000007ac04dd9dc, },
  },
  // compressed: 0xc2de09556200aca241dd7fc660038766aee720956ef44a051fba314eca760ca8
  {
    { 0x000005c258a3757f, 0x000000625509dec2, 0x0000000000000001, 0x000006e5447c1595, 0x000005765580fc5e, 0x000002374a9073d7, 0x0000000000000000, 0x000002aaf28e6f3e, },
    { 0x0000019022954feb, 0x000007fba8345580, 0x0000000000000000, 0x00000576ec365f3c, 0x000002a81ed01708, 0x0000031ba1f054af, 0x0000000000000000, 0x00000038a9e250ed, },
    { 0x000004313c9f1787, 0x0000019a1c0d8319, 0x0000000000000000, 0x0000029de10e809c, 0x000000c7dd603dc5, 0x0000005018ed949c, 0x0000000000000000, 0x000000fc57effec4, },
  },
  // compressed: 0x8580ed6913049b3103bbbcdeedc3351c194ffd19d5345061e3cef60083e7afc0
  {
    { 0x0000005c53590c55, 0x0000041369ed8085, 0x0000000000000001, 0x00000197182b5ff4, 0x000007344aaacd1a, 0x0000026a8cfea78c, 0x0000000000000000, 0x000001c1de53fab3, },
    { 0x00000546c66d41b6, 0x0000079760663360, 0x0000000000000000, 0x000000f87eb723bf, 0x00000629b4ee0cfb, 0x0000076cee361503, 0x0000000000000000, 0x000007adbfdee040, },
    { 0x000004bdeda5844e, 0x00000470d70fb77a, 0x0000000000000000, 0x000004dada8d71b7, 0x00000008a16fbad4, 0x000000815fcf0601, 0x0000000000000000, 0x000000b9a722bccd, },
  },
  // compressed: 0x942bf3aa17ba7a87669262080b244223c51a92285c360747009fa1c37de308cb
  {
    { 0x00000484cea950cb, 0x00000217aaf32b94, 0x0000000000000001, 0x000006812c8ae04c, 0x00000025aae35d03, 0x0000032e14490d62, 0x0000000000000000, 0x000000e2793a8686, },
    { 0x00000180d4cafdb4, 0x000004524cd0ef57, 0x0000000000000000, 0x000005452e579a0b, 0x000000e8ff1717fd, 0x00000219f0047073, 0x0000000000000000, 0x00000026283e0252, },
    { 0x00000026c841733c, 0x0000048d08902c21, 0x0000000000000000, 0x0000071b31edcc4c, 0x000000bf30207cff, 0x0000009611c6fb87, 0x0000000000000000, 0x000000d7cd124f6c, },
  },
  // compressed: 0xdeff6d988d59ba572f9683739175713d4161e054aaed13da19a2d04f752b52f4
  {
    { 0x0000074e0b00b251, 0x0000018d986dffde, 0x0000000000000001, 0x000002362c51d277, 0x000002865cd3eb05, 0x000006d52a7030a0, 0x0000000000000000, 0x00000774013b859e, },
    { 0x000001aa2435fde7, 0x00000072c5eaf74b, 0x0000000000000000, 0x000003ce434ec35e, 0x000006d6974aef6d, 0x0000050a219da13e, 0x0000000000000000, 0x0000054cbf582858, },
    { 0x0000040c3290a915, 0x000004f5c5d645ce, 0x0000000000000000, 0x0000014869a7a7de, 0x000000f5d42592c7, 0x000000e8a456ea9f, 0x0000000000000000, 0x0000006a6521d149, },
  },
  // compressed: 0xbccf4462e4f185b58f6bba333f970fc5d3bfc3979ca35d3c6783327573413909
  {
    { 0x000001405c14c818, 0x000001e46244cfbc, 0x0000000000000001, 0x00000563c6d0f5f6, 0x00000066ac6a6f9c, 0x000001ce4be1dfe9, 0x0000000000000000, 0x000001cd821b52e8, },
    { 0x00000470cede7364, 0x0000074d71f6b0be, 0x0000000000000000, 0x000003addd8321f5, 0x000001882ed70cae, 0x000003283673c5da, 0x0000000000000000, 0x00000223ad012f92, },
    { 0x000000a88a30ae10, 0x000007143e5cfcce, 0x0000000000000000, 0x000000a0ba2f2ceb, 0x000000670e2a42b2, 0x000000127282e6ea, 0x0000000000000000, 0x0000004398335d83, },
  },
  // compressed: 0xc5f21cfad8cb98cd652cd5f9acd5ca619190eb98cd26e056237894998d6de7b0
  {
    { 0x0000061b9f613059, 0x000003d8fa1cf2c5, 0x0000000000000001, 0x00000679df95c740, 0x00000105e3b8845c, 0x00000366cc75c848, 0x0000000000000000, 0x00000764fbdb5967, },
    { 0x0000061cfd88d640, 0x000002a58cb9b319, 0x0000000000000000, 0x000000c39dded337, 0x0000047a7f741955, 0x0000014782356e02, 0x0000000000000000, 0x000000265c4611ac, },
    { 0x0000054300a6f960, 0x000005872b56b3e7, 0x0000000000000000, 0x0000039aa02a5cc3, 0x00000071c951f687, 0x00000061cedb1b33, 0x0000000000000000, 0x00000049c40995ca, },
  },
  // compressed: 0x2ca93b7e84f49cc1d4fd779e8af27349f50c69533ec00792ece65f6cde4c07b0
  {
    { 0x0000074450a64f5b, 0x000004847e3ba92c, 0x0000000000000001, 0x000005471f920bd0, 0x000000e571865112, 0x0000001f29b4867a, 0x0000000000000000, 0x000007129d04a436, },
    { 0x000006ea0a55ec68, 0x000006ffba98339e, 0x0000000000000000, 0x0000068b68f99f7d, 0x0000062df32794b8, 0x000005fe6ec9207c, 0x0000000000000000, 0x00000632e64cefef, },
    { 0x000005b675306f5f, 0x00000525cfca2a79, 0x0000000000000000, 0x000002f2ebe8028f, 0x0000008ade02beeb, 0x000000600e99bcd8, 0x0000000000000000, 0x000000d8ce54a1ea, },
  },
  // compressed: 0x57c649698498104a86fc2b5563e6dfea161564d0a4e51ef5c514ab33b1efbcbf
  {
    { 0x00000040563d75b7, 0x000000846949c657, 0x0000000000000001, 0x000002f104ed26b3, 0x000000205ebd05ba, 0x000002d268320a8b, 0x0000000000000000, 0x000006febd148347, },
    { 0x0000073cf591c9ca, 0x0000057f90c94213, 0x0000000000000000, 0x000004d25ee4f427, 0x00000410adf76986, 0x000002b14c5f51ee, 0x0000000000000000, 0x000001a529e8d3f7, },
    { 0x000001aea4c84db0, 0x000003ab7f998d54, 0x0000000000000000, 0x000004bf5305256e, 0x0000000619763329, 0x0000007f79df6267, 0x0000000000000000, 0x000000208e760718, },
  },
  // compressed: 0xb42397c6d2b12ae67991d9b9a47aaba95753f030edb689766c1c05d6588d4cb3
  {
    { 0x000004c0f96dab27, 0x000001d2c69723b4, 0x0000000000000001, 0x000004b73f99f998, 0x000002be10b59115, 0x00000376987829ab, 0x0000000000000000, 0x000007f2a2c71e29, },
    { 0x00000373cf4a0200, 0x000003322f3cc556, 0x0000000000000000, 0x0000055b44eaae1b, 0x000007d3f790346b, 0x00000051c6c7689b, 0x0000000000000000, 0x0000071e3e5f1034, },
    { 0x000005c7e0955b15, 0x000006a6adea92e7, 0x0000000000000000, 0x00000323ff76a3c2, 0x00000019abbeeba1, 0x00000066991ab1ac, 0x0000000000000000, 0x0000005547e52ff3, },
  },
  // compressed: 0x3f09b93b93eb7743cd974413af29b3e6287caf9b87c07ca7b4a18ddc0459df69
  {
    { 0x00000151a02c4436, 0x000003933bb9093f, 0x0000000000000001, 0x00000398c783fa9f, 0x000007dd7f2fe6ec, 0x00000043cdd7be14, 0x0000000000000000, 0x000007dd99ac6e39, },
    { 0x00000598f027a37a, 0x00000092f9a86efd, 0x0000000000000000, 0x000007b7c09f2b23, 0x0000047d41a5b687, 0x000000da1b4a77cc, 0x0000000000000000, 0x0000018292655fe4, },
    { 0x00000631c9e2e12d, 0x0000039acca6bc4d, 0x0000000000000000, 0x000000d6acfcfa94, 0x000000a67c83b61d, 0x000000d3beb209b9, 0x0000000000000000, 0x000000fbf5cc04a0, },
  },
  // compressed: 0x3e857ea92c876920a50288a3f701069760250fd5a5bf1881f4c0673f0ae4f3b5
  {
    { 0x000006fa09a40061, 0x0000072ca97e853e, 0x0000000000000001, 0x00000061a5eb141c, 0x000003d6190c097f, 0x000007d2ea8792b0, 0x0000000000000000, 0x0000021a49d31b5c, },
    { 0x0000003926cbcc6d, 0x0000010054a40d30, 0x0000000000000000, 0x00000647588ccaf0, 0x00000290b638bffd, 0x0000067c0f48118b, 0x0000000000000000, 0x0000029417f1f759, },
    { 0x0000017387b53ee5, 0x0000025c1807de8e, 0x0000000000000000, 0x0000035b002c9b87, 0x0000009d84c513f8, 0x0000006be7c8147e, 0x0000000000000000, 0x00000067e3341a9a, },
  },
  // compressed: 0xe77b8a8be3f399f39332f10dc3d497d2a2b230f2a599a8483fa13859a71a4bac
  {
    { 0x00000611ba5189f5, 0x000003e38b8a7be7, 0x0000000000000001, 0x0000057fb0d092e6, 0x0000065e9c5f0a64, 0x000004d2f9185951, 0x0000000000000000, 0x00000226d8a5ab3c, },
    { 0x0000046c45c21a5f, 0x00000626527e733e, 0x0000000000000000, 0x0000021d03b54433, 0x000001e3875426f2, 0x0000038a13f48a89, 0x0000000000000000, 0x0000036b439ddd36, },
    { 0x000002234f56a272, 0x0000034a5f530c37, 0x0000000000000000, 0x0000041365bcd0e5, 0x000000f38faf629f, 0x0000005896354eb2, 0x0000000000000000, 0x0000002d80454bdc, },
  },
  // compressed: 0x2dca90c67e3cd9af4afd8abcf5058fc1e5a182583a57f89bd69f8db0bee3ddda
  {
    { 0x00000744a1fc889b, 0x0000047ec690ca2d, 0x0000000000000001, 0x000005046136a091, 0x000005aac600920b, 0x0000039d2c4150f2, 0x0000000000000000, 0x000007165ed0e96c, },
    { 0x0000071ad8607973, 0x0000015fa955fb27, 0x0000000000000000, 0x000000ba3a5fb8f4, 0x0000004a03f3bfc1, 0x000000d9fd69bf85, 0x0000000000000000, 0x00000090555eaf46, },
    { 0x000005258fc01efb, 0x000007063c17d6f2, 0x0000000000000000, 0x000004ab1f9b7c49, 0x00000002e9843261, 0x000000b5bbc77d61, 0x0000000000000000, 0x000000bd77ed2761, },
  },
  // compressed: 0x2fc313fff33ba80fb9cb1ecb73a4c2c857d3e3ae023adbb15653c14a3120cfe8
  {
    { 0x00000780faee4747, 0x000003f3ff13c32f, 0x0000000000000001, 0x000005f15c782901, 0x00000083bace749f, 0x000005015771e9ab, 0x0000000000000000, 0x0000071e301169f6, },
    { 0x0000007e2dc2e69b, 0x000003d97721f507, 0x0000000000000000, 0x0000079677ed633e, 0x000003b0d018e4ec, 0x00000415356b1db3, 0x0000000000000000, 0x00000528ab3db516, },
    { 0x000007e39986463a, 0x000007230a91cf2c, 0x0000000000000000, 0x000006128410140d, 0x000000ecdcf787bf, 0x000000d19e406295, 0x0000000000000000, 0x000000b434c95846, },
  },
  // compressed: 0x1ffee08e7e53d2232b77ba2fb58a20202f89c5c1f156f3fe00a05c751e7bf36b
  {
    { 0x000007f702392146, 0x0000037e8ee0fe1f, 0x0000000000000001, 0x00000297a87d4de3, 0x0000037e7a7cf6fb, 0x00000378e0e2c497, 0x0000000000000000, 0x00000776931b7059, },
    { 0x00000619085ebfa3, 0x0000074ee5647a4a, 0x0000000000000000, 0x0000050d8c322aba, 0x000006a1337184c4, 0x000005ca000fef35, 0x0000000000000000, 0x0000012ba264337c, },
    { 0x0000063fe6ae4dfe, 0x00000480822ad4be, 0x0000000000000000, 0x0000042ff90b0b39, 0x000000787f035ad7, 0x000000d7e6f63cea, 0x0000000000000000, 0x000000f4a75a9dad, },
  },
  // compressed: 0x8626e539a4d9b0ca195849a04be1c3efb294b3a0b534a9cb0e92bd2ea577bb1c
  {
    { 0x00000428e02a5c1a, 0x000001a439e52686, 0x0000000000000001, 0x000006b158f3c4d1, 0x0000046afc793748, 0x0000025ad059ca59, 0x0000000000000000, 0x000000f36b7d7b5b, },
    { 0x0000045ef55aafd1, 0x0000012b0339561b, 0x0000000000000000, 0x000004e9361a6aa0, 0x00000299dd25a4f7, 0x000003d920ecba93, 0x0000000000000000, 0x000002ee63459d13, },
    { 0x000003766d98f487, 0x000003bf0f852e81, 0x0000000000000000, 0x000006b3b132badf, 0x000000830f7299ba, 0x0000003976ef4a5d, 0x0000000000000000, 0x000000d2eeec9d5a, },
  },
  // compressed: 0x59377da43871ddb4dff612c7d78f9ab761a31479411cf874f1257094035f5e73
  {
    { 0x00000715dfa999d4, 0x00000138a47d3759, 0x0000000000000001, 0x000007e5453dfcc9, 0x000004f69408eb06, 0x00000620bc8a51b0, 0x0000000000000000, 0x00000588cebe34e1, },
    { 0x0000074997112f14, 0x0000025edbf69bae, 0x0000000000000000, 0x000006ca31387af9, 0x00000417a76e4b8d, 0x000007025f174f81, 0x0000000000000000, 0x0000002415023404, },
    { 0x000000bd21b434b7, 0x000006de6a3f5f1c, 0x0000000000000000, 0x0000048d69679166, 0x000000144858a2ac, 0x000000e6bcbe0728, 0x0000000000000000, 0x000000abd8b2d503, },
  },
  // compressed: 0xee1481d7c1548a67644920ba079c587032f17f977c4bf79f2fca83f5feb0f198
  {
    { 0x0000066abf002cf9, 0x000004c1d78114ee, 0x0000000000000001, 0x000001b9c78fc401, 0x00000263f4392749, 0x000005be4bbff899, 0x0000000000000000, 0x00000451633c6df3, },
    { 0x0000006bc523b0d1, 0x000004092c8cf14a, 0x0000000000000000, 0x0000052abd5d906c, 0x000005ea504adf28, 0x0000003ca2f9ff74, 0x0000000000000000, 0x00000268f79e3a80, },
    { 0x000004a560ba85c3, 0x000001c162701ee8, 0x0000000000000000, 0x000003dd8acf3728, 0x00000061a5649264, 0x00000031e361fdeb, 0x0000000000000000, 0x0000008d721435f0, },
  },
  // compressed: 0x2aff9ceb57bc197925f48fc2fcf9e3d8ec02e4baf6f9e9b202acb27b50f928fe
  {
    { 0x00000480c23bfd05, 0x00000457eb9cff2a, 0x0000000000000001, 0x0000038e51e86631, 0x0000017677942103, 0x000004fb5d720176, 0x0000000000000000, 0x000001ca4f6b996f, },
    { 0x000002b54fd9390b, 0x000001fe84af2337, 0x0000000000000000, 0x0000077085aef876, 0x0000055866d29197, 0x0000032ac02b2e9f, 0x0000000000000000, 0x00000535b48b1ba4, },
    { 0x000007c6eece1b1f, 0x000003638fe7f30a, 0x0000000000000000, 0x000004d04175c52a, 0x000000d1c4fa9df9, 0x000000fc51f2a0f7, 0x0000000000000000, 0x0000000d0b80c3e5, },
  },
  // compressed: 0x038bf0a5921dd8e391b2772b9ae2259f5bb539c23c1be9404993fefcbafa152b
  {
    { 0x000002c7466ec11a, 0x00000592a5f08b03, 0x0000000000000001, 0x0000028b92329057, 0x000002979b50c887, 0x0000059e611cdaad, 0x0000000000000000, 0x000001f2581def86, },
    { 0x00000151ac5f41a2, 0x000006f6523c7b03, 0x0000000000000000, 0x00000114dedad53a, 0x000001e7237849c5, 0x000007e934940e91, 0x0000000000000000, 0x0000032ae442f5d5, },
    { 0x0000036d4e05f355, 0x0000067c978a68ad, 0x0000000000000000, 0x000006c17d45fbf6, 0x000000835ff64de2, 0x000000562bf575f9, 0x0000000000000000, 0x000000f7c048c6cf, },
  },
  // compressed: 0x37d495c2c731597a1bc101ec8e46c0790c3a8d767d585bf08580e28c8d84e7f5
  {
    { 0x000005d5ceeef17b, 0x000001c7c295d437, 0x0000000000000001, 0x0000022f3deeea97, 0x00000362aaf3f2ec, 0x0000043ebb469d06, 0x0000000000000000, 0x000004c3fe9911fc, },
    { 0x00000517a995b7e0, 0x00000038236f4b26, 0x0000000000000000, 0x000002b2fe6b52a0, 0x000007da25b829fe, 0x00000628085f05b5, 0x0000000000000000, 0x000002f56fa45264, },
    { 0x000005c6cadb1736, 0x000001e7011a3bb0, 0x0000000000000000, 0x000002029ecd9d4f, 0x000000e9c6c9edd4, 0x000000ebcf091b19, 0x0000000000000000, 0x0000004086200d2a, },
  },
  // compressed: 0x72cb4870078dccee117e12d1cf134a8e5c1fde835667e1541450b4aaf245f53c
  {
    { 0x0000007436eabfcc, 0x000005077048cb72, 0x0000000000000001, 0x0000006d9a8cf71a, 0x000003b4799d0cb2, 0x000003ab41ef0fae, 0x0000000000000000, 0x000003959f9c779b, },
    { 0x000007d851b78b91, 0x0000024fc23dd991, 0x0000000000000000, 0x0000041ea4eb3cfc, 0x000005b7537ee192, 0x0000034501454e16, 0x0000000000000000, 0x00000372515a65bb, },
    { 0x000001c49d4b7383, 0x00000239284f3f44, 0x0000000000000000, 0x0000069319801ee1, 0x00000058632c4421, 0x00000079ea8be555, 0x0000000000000000, 0x000000102ebb109b, },
  },
  // compressed: 0x6af4e54ba3028faca1e591e4ec403f18f2402f9c9288d5a4326e4748da321c30
  {
    { 0x00000173856ed5ee, 0x000002a34be5f46a, 0x0000000000000001, 0x0000015f27bee3d3, 0x000005eddd6ae970, 0x000004494e17a079, 0x0000000000000000, 0x000005799adb5096, },
    { 0x000004d0eeba64b8, 0x0000023cb43591e0, 0x0000000000000000, 0x000003d290794a20, 0x00000689d97ae3f5, 0x00000476e32a4d58, 0x0000000000000000, 0x000002b2ff648bf1, },
    { 0x0000064be53330c8, 0x00000060fd03b392, 0x0000000000000000, 0x0000051671eef7d2, 0x000000f30fee9270, 0x000000603865b490, 0x0000000000000000, 0x000000daa57fa792, },
  },
  // compressed: 0xa5f616e17c3f908788ff8e13999015cc5a95a30be3aceb3bf0dbf5deac50a57c
  {
    { 0x0000031a8772dc9a, 0x0000077ce116f6a5, 0x0000000000000001, 0x000006d0ac3fc00d, 0x0000053b5b76d36d, 0x0000067185d1caad, 0x0000000000000000, 0x00000506af44146f, },
    { 0x000004275b462b2d, 0x000001dff110f207, 0x0000000000000000, 0x0000033a5f0f3cfa, 0x00000135de8486b7, 0x0000075dbf03beba, 0x0000000000000000, 0x000007f2139039b2, },
    { 0x0000058b942b7905, 0x000003305642644e, 0x0000000000000000, 0x000001de30c60f08, 0x00000023f851a43b, 0x000000f94aa159bd, 0x0000000000000000, 0x00000033e159997f, },
  },
  // compressed: 0x1852f93d21af16998b57bdcbc6bafd807616ea0256b30e3b112f37e50a2096c0
  {
    { 0x0000014ae542bb6f, 0x000007213df95218, 0x0000000000000001, 0x000000891eb71ac6, 0x000002eec8ba8986, 0x000001ab01750b3b, 0x0000000000000000, 0x000003d2aa84b5ba, },
    { 0x0000063c49239dd4, 0x000007aaf17322d5, 0x0000000000000000, 0x000007b68e0667d4, 0x0000049ded395334, 0x00000372f113b0eb, 0x0000000000000000, 0x000004c5dcfea038, },
    { 0x000003ecd6fa1867, 0x00000203f6eb1b2e, 0x0000000000000000, 0x00000361ac11a5ae, 0x00000004bb6fd433, 0x000000812c4015ca, 0x0000000000000000, 0x000000a9760e8118, },
  },
  // compressed: 0xd85a29057217e0f6a64d4bb45e189e4afdb1bac2a8066bef8cf18ceb95074378
  {
    { 0x00000590870d804c, 0x0000077205295ad8, 0x0000000000000001, 0x000003ee2d67f793, 0x0000047af0e837e5, 0x00000354615d58fe, 0x0000000000000000, 0x000005ff34e00e6b, },
    { 0x00000050cde1ef03, 0x00000169b4dedc02, 0x0000000000000000, 0x000002790e95d61c, 0x0000037521870a76, 0x000000cf18cef6b0, 0x0000000000000000, 0x00000624aa300c31, },
    { 0x0000019dcfadfd43, 0x0000052a78617ad1, 0x0000000000000000, 0x000006eadb299e23, 0x0000008c3205f035, 0x000000f0860f2bd7, 0x0000000000000000, 0x0000002e2fc1c55d, },
  },
  // compressed: 0xeb7042d94cd6d39cc10ab6d08fb07036abed3606ae12bc46396660f0fe5c2494
  {
    { 0x00000575987dd20b, 0x0000064cd94270eb, 0x0000000000000001, 0x0000042c7191f7ef, 0x000004ae1da48f32, 0x00000157031b76d5, 0x0000000000000000, 0x0000001da09f8c42, },
    { 0x000006c173c0313a, 0x000006c158339a7a, 0x0000000000000000, 0x000001055593fb47, 0x0000041f4a855dc2, 0x0000060663946bc1, 0x0000000000000000, 0x000007008c1402aa, },
    { 0x000007dc07ae6751, 0x000004d9c2c23f42, 0x0000000000000000, 0x0000053cd1770290, 0x000000edf803a794, 0x0000002848b9fde0, 0x0000000000000000, 0x000000e56d860c25, },
  },
  // compressed: 0x7e6e9135621dfb6c1cf33593cc547a555328391c82b064aa1562d67de234bf2a
  {
    { 0x000004deab6e9936, 0x0000056235916e7e, 0x0000000000000001, 0x000001e7ddeb2cac, 0x0000059f90ff6f8b, 0x000000410e1c9429, 0x0000000000000000, 0x0000022e51e1bc54, },
    { 0x000006d3c893aa8f, 0x000006be638d9f63, 0x0000000000000000, 0x0000015e52593f93, 0x000007f3f5b280d3, 0x00000566215aa64b, 0x0000000000000000, 0x00000524f6ba61e1, },
    { 0x00000485472af64e, 0x00000555e953324c, 0x0000000000000000, 0x0000007313e8a944, 0x000000c5ececceb4, 0x000000557e69c4fb, 0x0000000000000000, 0x000000a7d4e5f2de, },
  },
  // compressed: 0x44f0464c44220c3209fefe27148611efa92bb15a930888248790cabc398f5113
  {
    { 0x000007f33e5f5710, 0x000002444c46f044, 0x0000000000000001, 0x00000251fbe6499e, 0x000007f97292e7db, 0x00000449ad5895d4, 0x0000000000000000, 0x00000267eb401e38, },
    { 0x000002d7cdf8986f, 0x000007dfc1264184, 0x0000000000000000, 0x000001638823d0b3, 0x000004791a1915ba, 0x000004a908724880, 0x0000000000000000, 0x0000005ea4e77f88, },
    { 0x00000545bd1f0ad1, 0x000007bc4618509f, 0x0000000000000000, 0x000001b520cd0d69, 0x000000adeba9eda4, 0x00000026a31e7379, 0x0000000000000000, 0x000000511d069f3f, },
  },
  // compressed: 0x65d64141d0ab6e69712d1b148fd005d8930c6d021129f230b5357b4a201c2bb9
  {
    { 0x0000075f2dedca67, 0x000003d04141d665, 0x0000000000000001, 0x00000253e5b38e71, 0x000004575482d717, 0x0000048881368649, 0x0000000000000000, 0x0000079e9b6014b3, },
    { 0x000000db31ac433c, 0x00000365ae2d2dd5, 0x0000000000000000, 0x000000bd15781415, 0x0000007f0d84c62d, 0x000007b35b530f22, 0x0000000000000000, 0x0000027e312acce3, },
    { 0x00000310e8892495, 0x0000076017423c50, 0x0000000000000000, 0x000003207b4520c4, 0x000000e65975a5cf, 0x0000007256384094, 0x0000000000000000, 0x000000753f8080ca, },
  },
  // compressed: 0x0970397900bb656f9b9357dea553f37e93d027586170ea4e3adec181d0f308d9
  {
    { 0x000006e90e28255d, 0x0000030079397009, 0x0000000000000001, 0x00000680fc71f8e5, 0x0000010a8f350a88, 0x00000030ac13e849, 0x0000000000000000, 0x00000287f0eebe48, },
    { 0x000003b8ae6e14f4, 0x000002f2736decb7, 0x0000000000000000, 0x000001bfa5bbab05, 0x00000313ec9e8321, 0x0000041de3a4eea7, 0x0000000000000000, 0x00000586470b7309, },
    { 0x0000004a27c9b009, 0x000005fbcd4e9779, 0x0000000000000000, 0x000005a365a59b64, 0x0000005fafba2b7b, 0x000000b211e7a103, 0x0000000000000000, 0x0000006f40424381, },
  },
  // compressed: 0xcd88945ef0ee8517293b57eb77522105e3b4228f8573b58bb4ac549b84706eed
  {
    { 0x000000e008253d61, 0x000006f05e9488cd, 0x0000000000000001, 0x0000003c9ee0a4ee, 0x00000659a6a92da5, 0x000001c2c7915a71, 0x0000000000000000, 0x000002c790a4f5bf, },
    { 0x0000010da0999a14, 0x000002e76522f0bd, 0x0000000000000000, 0x000005ecf0a0ca2b, 0x0000009845b034d2, 0x0000054acb48bb57, 0x0000000000000000, 0x00000454dec0e67c, },
    { 0x000000bcbc43daaa, 0x000004148549dfad, 0x0000000000000000, 0x0000056c5dfc3afe, 0x0000006fbf012d14, 0x000000dadce10936, 0x0000000000000000, 0x000000e8fd4b53f5, },
  },
  // compressed: 0x2ac769d36da59836c4ba08c44f6a29f8e54875194b25bbb476d462728b0d281b
  {
    { 0x000007ddab4d2f9e, 0x0000056dd369c72a, 0x0000000000000001, 0x000003ddcf666241, 0x000001c16aa7f50b, 0x000002a58cbaa472, 0x0000000000000000, 0x000004402031d128, },
    { 0x00000521250f47a0, 0x000001175886d314, 0x0000000000000000, 0x000007f8ee5b54b4, 0x00000749cccac643, 0x0000062d476b4bb2, 0x0000000000000000, 0x000007485690aaa4, },
    { 0x000006e5a96c3a9a, 0x000007e0a5a93f10, 0x0000000000000000, 0x000004196025dd31, 0x000000d0ea367615, 0x00000036501b16e4, 0x0000000000000000, 0x000000d2a43ab52e, },
  },
  // compressed: 0x1898827c177107fd2a3183cdb072753b3a554f1364fa3876045f3a5e4fb87901
  {
    { 0x000001c8ab6e8be4, 0x000001177c829818, 0x0000000000000001, 0x000001f5be7b3013, 0x000005487d163441, 0x0000053209a7aa9d, 0x0000000000000000, 0x0000010047ce8aaa, },
    { 0x000003abe5152756, 0x00000066255fa0ee, 0x0000000000000000, 0x0000026e6534d096, 0x000006c199bc7d21, 0x000003a5f047638f, 0x0000000000000000, 0x0000047724cc6598, },
    { 0x000007ee4a02f3f1, 0x000000edd5cac336, 0x0000000000000000, 0x0000030956e6766c, 0x000000f160d24602, 0x00000002f3709ebc, 0x0000000000000000, 0x0000006627152808, },
  },
  // compressed: 0xf31333c56ca9a1cacbdb8e1122ec914c06356a9580c434e9910aaf99375df9ad
  {
    { 0x0000002ec84edbbd, 0x0000016cc53313f3, 0x0000000000000001, 0x000005e0e9deb93a, 0x000002fd2609cdf8, 0x000002404ab51a83, 0x0000000000000000, 0x00000353227b0187, },
    { 0x0000075fc47f8301, 0x000001db79795435, 0x0000000000000000, 0x0000076861f292c4, 0x000003f08c524918, 0x000002f0a91e934c, 0x0000000000000000, 0x000007d2245cb87e, },
    { 0x000003d17bfd7a0c, 0x0000013247b08846, 0x0000000000000000, 0x000006df7423aac3, 0x000000d1b1046793, 0x0000005bf2ba6f33, 0x0000000000000000, 0x000000845795e4c8, },
  },
  // compressed: 0x58a37d3a86baeb24d10732f41f5d9436fd6341796e806657e6fe4bcb078793f2
  {
    { 0x0000043e4218d497, 0x000002863a7da358, 0x0000000000000001, 0x0000029f275c7d79, 0x000001ba2f2d8507, 0x000000373ca0b1fe, 0x0000000000000000, 0x00000442edd9abbb, },
    { 0x000004d411ffb417, 0x00000640fa249d77, 0x0000000000000000, 0x0000068f9d492c12, 0x000003ce0ff7ab4a, 0x000004bfee657668, 0x0000000000000000, 0x000005e225b3bb2f, },
    { 0x00000173ccdf80bd, 0x000004da51747fd0, 0x0000000000000000, 0x00000319a8e0882d, 0x000000d92312062b, 0x000000e5270e0f96, 0x0000000000000000, 0x000000fd7a5c90bd, },
  },
  // compressed: 0x18fc4c10e21e9e15a38fc3c7384ab3b9a23b9fda6e5ef8c449240f89ed51a2a8
  {
    { 0x000002021a22b23f, 0x000006e2104cfc18, 0x0000000000000001, 0x000000f08c4cb7b5, 0x000002c077d558b3, 0x000007376d4f9dd1, 0x0000000000000000, 0x0000064a55f12f80, },
    { 0x000005e8d3eaedc6, 0x00000071f462b3c3, 0x0000000000000000, 0x0000022d17731bde, 0x00000027fa4cfc24, 0x000000f2449c4f85, 0x0000000000000000, 0x000006468439590d, },
    { 0x000000b0df257d3a, 0x000002e6cd28e31f, 0x0000000000000000, 0x000004f11c80d536, 0x00000000a5bb37ad, 0x0000005144a3db12, 0x0000000000000000, 0x000000a0f3f0fc80, },
  },
  // compressed: 0x5a7fd23a8f9a48871f4512683de37cbdfbe859ee1c730f106401e0b33b1f1db7
  {
    { 0x000003a56f365f1d, 0x0000028f3ad27f5a, 0x0000000000000001, 0x000001fe2c752a69, 0x0000001714061b7e, 0x0000018e772cf47d, 0x0000000000000000, 0x000006773e778006, },
    { 0x00000112bb3a11c3, 0x00000248a3f0e913, 0x0000000000000000, 0x000006acc96329f5, 0x000004806a7901b3, 0x00000600164100f7, 0x0000000000000000, 0x0000046cbdba723e, },
    { 0x000003dff70dbb78, 0x000006f5f38cf5a0, 0x0000000000000000, 0x000003cc5b77b9f3, 0x00000065092c2963, 0x0000006e3a3e7767, 0x0000000000000000, 0x0000009348dc7610, },
  },
  // compressed: 0x56ba438a2374ae4c68dd5670c791c7e06985722c893d570036b7a37e0ebeffbf
  {
    { 0x000001b3203452a9, 0x000004238a43ba56, 0x0000000000000001, 0x00000743a55b7cb2, 0x0000005c53a34858, 0x000006c4963942b4, 0x0000000000000000, 0x000006cb6ce6ea8c, },
    { 0x000002331182d335, 0x000002dbad0995ce, 0x0000000000000000, 0x0000035b5b97c452, 0x000006d216511461, 0x0000023b73600573, 0x0000000000000000, 0x000003c5df9754f6, },
    { 0x000004df6f00694b, 0x000007831e471dc1, 0x0000000000000000, 0x000007e9a9d277e7, 0x0000002c7b56199c, 0x0000007fff7c1cfd, 0x0000000000000000, 0x000000ec66034153, },
  },
  // compressed: 0x53bf85f046c360eefd6a3e092800a1da0f3b0762f002d6c6fed79975f669f592
  {
    { 0x0000048eb5178377, 0x00000346f085bf53, 0x0000000000000001, 0x000000383d6faf65, 0x00000420ef9d29f8, 0x0000017831039d87, 0x0000000000000000, 0x0000030d07fdb28e, },
    { 0x000007f7bf392142, 0x000007cd5fbdcc18, 0x0000000000000000, 0x0000045dd15b82de, 0x000002f2a2ae68c7, 0x0000019d7fec6d60, 0x0000000000000000, 0x000007d0d4a834eb, },
    { 0x000005324678b821, 0x0000076a8400a024, 0x0000000000000000, 0x0000009edff81b53, 0x000000592fec453c, 0x00000025ead3eceb, 0x0000000000000000, 0x0000001298e41f0a, },
  },
  // compressed: 0x22e79f185d587b3762fd340a09a7b47f6db1c43286b4894f3a3b2b06a7ff2144
  {
    { 0x0000032e3224b906, 0x0000005d189fe722, 0x0000000000000001, 0x00000329c509c944, 0x0000035eef5d87d8, 0x00000243196258b6, 0x0000000000000000, 0x00000415dd4c6e35, },
    { 0x000000abaebc8ac8, 0x0000069fac46ef6b, 0x0000000000000000, 0x000004c000908f0a, 0x00000143cd7beddb, 0x000002b3b3a4f89b, 0x0000000000000000, 0x0000031803328602, },
    { 0x0000060f7604aa49, 0x000005fed29c2428, 0x0000000000000000, 0x0000012bc2d3785e, 0x000000b8398f3b3f, 0x0000008843ff4e0c, 0x0000000000000000, 0x0000001651caf044, },
  },
  // compressed: 0x0fe10276ed300e8c7149c6c0c826dcddaf4755ceffebb62426629348d4261cf6
  {
    { 0x0000017f44b50561, 0x000000ed7602e10f, 0x0000000000000001, 0x000003f7cd04b52f, 0x000000ffd72a839d, 0x000005ffe72aa3d7, 0x0000000000000000, 0x000000f1b8781119, },
    { 0x00000785b857ce50, 0x000000c92e3181c6, 0x0000000000000000, 0x000005df51bf4b7c, 0x00000252d64a6964, 0x0000013622624b6e, 0x0000000000000000, 0x00000613fb8c1aad, },
    { 0x0000040d27db9a6b, 0x00000777709b2303, 0x0000000000000000, 0x000001ffad7f92bf, 0x000000daef3d9ce2, 0x000000ec384da891, 0x0000000000000000, 0x000000669e686442, },
  },
  // compressed: 0x79bfd6be4670715096853a5cb92aafbebc8c1b9e21e4202df124b772e6e191d0
  {
    { 0x000001290f547051, 0x00000046bed6bf79, 0x0000000000000001, 0x00000412716851e3, 0x000003aea6645d1c, 0x00000210cf0dc65e, 0x0000000000000000, 0x00000526c3515dc9, },
    { 0x0000053b66048958, 0x00000750b2ca0e2e, 0x0000000000000000, 0x000000485522806b, 0x0000018cd73578b5, 0x000003724f12d20e, 0x0000000000000000, 0x000002b6044d30ba, },
    { 0x0000032722d5b538, 0x000002fabcaae570, 0x0000000000000000, 0x000005f2e04024fa, 0x0000000bccab4a51, 0x000000a123c3cce5, 0x0000000000000000, 0x000000ffe2a1ff6a, },
  },
  // compressed: 0x18f11f185614cafc5142691ff113a2c2acd0a4ac65eeb1bc02c3fe3f1da957c3
  {
    { 0x0000072699bbcdb9, 0x00000456181ff118, 0x0000000000000001, 0x00000198caf88d89, 0x000007edd10e9056, 0x00000732d6526856, 0x0000000000000000, 0x000003d5557afa81, },
    { 0x0000002fac5d8f8f, 0x000005284a3f9942, 0x0000000000000000, 0x00000511013a69a9, 0x000002491a35dd03, 0x000007ec302bcb1e, 0x0000000000000000, 0x000007f7e1420790, },
    { 0x0000055cc432a627, 0x0000030a884fc47d, 0x0000000000000000, 0x0000041d5948bdac, 0x0000003134ba1bbd, 0x00000086af523a7f, 0x0000000000000000, 0x000000ad2b6101be, },
  },
  // compressed: 0xfa6d87d21b14bad89f8a136ece2ab62343b47de20d5f20824f85fcd5be8e03f8
  {
    { 0x00000484acb9749b, 0x0000041bd2876dfa, 0x0000000000000001, 0x000000c2dfdcb43f, 0x000003a4f27e5ba1, 0x00000786f13eda21, 0x0000000000000000, 0x0000008961d47595, },
    { 0x000000b188f077f7, 0x0000027153fb1742, 0x0000000000000000, 0x0000071db20d91b2, 0x000003b91056ce75, 0x000007c854f82205, 0x0000000000000000, 0x000003788504e6ce, },
    { 0x0000022358784c8c, 0x0000048ed8ab39b8, 0x0000000000000000, 0x0000052b8c0e45d9, 0x000000b937def39b, 0x000000f0071d7dab, 0x0000000000000000, 0x00000009d4c69f29, },
  },
  // compressed: 0xf56c3a05b677b87811d82012eb1ed30b7d97ed0246d7b9e82a6f288cfc89d182
  {
    { 0x000001e47b3056a3, 0x000007b6053a6cf5, 0x0000000000000001, 0x0000060eb9cc6f86, 0x0000063ed99ea9f2, 0x000003a30176cbbe, 0x0000000000000000, 0x0000055f28e84eb1, },
    { 0x00000576cf8f8f54, 0x0000041b022f170e, 0x0000000000000000, 0x0000005181874f33, 0x00000435a1cb8253, 0x00000286f2ae8b9d, 0x0000000000000000, 0x000006af095165d7, },
    { 0x000006dd70364afe, 0x0000042f4c7bac48, 0x0000000000000000, 0x000001776956a818, 0x000000bfcf86f920, 0x00000005a313f918, 0x0000000000000000, 0x00000006dd27beee, },
  },
};

/* Ed25519 base point w-NAF table for fast const-time scalar multiplication.
   Table size 8x32 points, i.e. max w=4.
   Used by fd_ed25519_sign and similar. */
static const fd_ed25519_point_t fd_ed25519_base_point_const_time_table[32][8] = {
  { // 0
  // compressed: 0x853b8cf5c693bc2f190e8cfbc62d93cfc2423d6498480b2765bad4333a9dcf07
  {
    { 0x00000105d740913e, 0x000003c6f58c3b85, 0x0000000000000001, 0x00000205877aaa68, 0x0000021a3447c504, 0x0000044c321ea161, 0x0000000000000000, 0x000006e5eea1acc6, },
    { 0x00000017d673a207, 0x00000181c325f792, 0x0000000000000000, 0x0000055893d57922, 0x00000781267a5c18, 0x0000054ba65270b4, 0x0000000000000000, 0x000000c65a85a1b7, },
    { 0x000007f4e67c1745, 0x0000033e4cb71bee, 0x0000000000000000, 0x0000009b67a08f32, 0x00000089fa5f2531, 0x0000000f9f3a7467, 0x0000000000000000, 0x000000de22f6d13e, },
  },
  // compressed: 0xd7713c93fce72492b5f50f7a969d469f0207d6e1659aa65a2e2e7da83f060c59
  {
    { 0x0000056042b4d5a8, 0x000007fc933c71d7, 0x0000000000000001, 0x000000b3a59b7a5f, 0x000001b5d8b71bd5, 0x00000532f0eb0381, 0x0000000000000000, 0x00000042059eb518, },
    { 0x000004159ed15334, 0x000001feb6b2449c, 0x0000000000000000, 0x00000359ef087f55, 0x00000492555e09e2, 0x000007d2e2e5aa69, 0x0000000000000000, 0x00000250b73500fa, },
    { 0x0000023cae043139, 0x0000027d1a7659e8, 0x0000000000000000, 0x000004db05af7576, 0x000000d76b2b4cd3, 0x000000b2180c7f50, 0x0000000000000000, 0x000000e035eb627d, },
  },
  // compressed: 0x3097ee4ca8b025af8a4b86e830845a023267019f02501bc1f4f8809a1b4e16fa
  {
    { 0x000007e8a4fcd265, 0x000000a84cee9730, 0x0000000000000001, 0x0000033f0dd0d889, 0x0000018d10a5eb5e, 0x000000014f80b399, 0x0000000000000000, 0x000002a2c6796da6, },
    { 0x000000374faacc23, 0x000000c97155e4b6, 0x0000000000000000, 0x000006bb4c4295d2, 0x000005bda628131f, 0x0000000f8f4c11b5, 0x0000000000000000, 0x0000039b4c6d170e, },
    { 0x000004ef4d4ff797, 0x000000096a10c3a2, 0x0000000000000000, 0x00000162508c8870, 0x00000055722b0eaa, 0x000000f42c9c3735, 0x0000000000000000, 0x000000b4504d5e25, },
  },
  // compressed: 0x9f09fc8eb95173283825fd7df4c6656765920afb3d8d34ca2787e52103910ee8
  {
    { 0x0000050a056818bf, 0x000001b98efc099f, 0x0000000000000001, 0x000003e9c476ff09, 0x000001e683502839, 0x0000069efd854932, 0x0000000000000000, 0x0000067c8815a24a, },
    { 0x0000041f5532bfc0, 0x000007a4a7050e6a, 0x0000000000000000, 0x000003982e4b427f, 0x0000045a49ac3e8e, 0x00000658727ca348, 0x0000000000000000, 0x00000553e2b5ddbd, },
    { 0x000004c9fa25c559, 0x0000059d971bd1f7, 0x0000000000000000, 0x000001ba78e515ed, 0x0000004f267e98e8, 0x000000d01d220643, 0x0000000000000000, 0x000000ff3a197ec6, },
  },
  // compressed: 0x33bba50844bc12a202ed5ec7c348508d44ecbf5a0ceb1bddeb06e246f1cc4529
  {
    { 0x000002c3a447d6ba, 0x0000044408a5bb33, 0x0000000000000001, 0x000003f1812a8285, 0x0000008e5c325043, 0x000005862d5ff622, 0x0000000000000000, 0x000003858dded396, },
    { 0x000004e536eff230, 0x000003dda0544257, 0x0000000000000000, 0x000007ba3f97977b, 0x000001b55f3e33cf, 0x000006206ebdd1be, 0x0000000000000000, 0x000003bb69ab41b6, },
    { 0x000007540053452c, 0x0000023541230f1d, 0x0000000000000000, 0x0000049c38201f42, 0x0000002a94fce7d6, 0x000000528b99e28d, 0x0000000000000000, 0x00000087557cd2d6, },
  },
  // compressed: 0x31711577ebee0c3a88afc8008915279b36a759da68b66580bd38cca2b67be551
  {
    { 0x000006b67b7d8ca4, 0x000006eb77157131, 0x0000000000000001, 0x0000026702ea4b71, 0x000006739022a9dc, 0x000003346d2cd39b, 0x0000000000000000, 0x00000125841de0a2, },
    { 0x00000244e7293300, 0x00000115f107419d, 0x0000000000000000, 0x000004376030b586, 0x00000417884bb085, 0x000004c38bd8065b, 0x0000000000000000, 0x000000d61e353e4a, },
    { 0x0000055d6f8a109f, 0x0000026c9c562403, 0x0000000000000000, 0x000002f9c3800d06, 0x000000716c98835c, 0x000000a3caf76d45, 0x0000000000000000, 0x0000002171d2353e, },
  },
  // compressed: 0xbfa34e94d05c1a6bd2c09db33a357074492e54288252b2717e923c2869ea1bc6
  {
    { 0x0000049aaa3221b1, 0x000004d0944ea3bf, 0x0000000000000001, 0x000005c801b8b3a2, 0x00000327c90c961d, 0x00000141142a1724, 0x0000000000000000, 0x000000dd2c3bd6f9, },
    { 0x0000074474f74de5, 0x000003b81a4d634b, 0x0000000000000000, 0x000007d4935e306d, 0x000005317e09dea7, 0x000003c927e71b25, 0x0000000000000000, 0x000000f90a7529c4, },
    { 0x000001b280854cee, 0x000005d1c0d4eace, 0x0000000000000000, 0x000006cc0d7d1c14, 0x0000003addbaba5c, 0x0000008c37d4d250, 0x0000000000000000, 0x000000f53f7638d4, },
  },
  // compressed: 0x8f3edd046659b7592c7088e27703b36c23c3d95e669c33b12fe5bc6160e71589
  {
    { 0x000005edf39234d9, 0x0000016604dd3e8f, 0x0000000000000001, 0x000005d9c9a2911a, 0x000000d6371e11fd, 0x000006332f6ce191, 0x0000000000000000, 0x0000010c875b1519, },
    { 0x000006ab1f3c54eb, 0x0000010e058b36eb, 0x0000000000000000, 0x00000194fafcf83e, 0x000000e01c32c274, 0x000003ce52fb1339, 0x0000000000000000, 0x000004c4e9563641, },
    { 0x00000658f5da0386, 0x000005b2cc0ddf8a, 0x0000000000000000, 0x000002e28dc5e22f, 0x0000007520494264, 0x000000122bcec0c3, 0x0000000000000000, 0x0000004d20f8b85d, },
  },
  },
  { // 1
  // compressed: 0x1d9c2f630eddcc2e1531897696b6d051587a63a86bb7df5239ef0ea0497dd36d
  {
    { 0x0000035449aa515e, 0x0000050e632f9c1d, 0x0000000000000001, 0x000004172106e4c7, 0x000007f4ada168e2, 0x000003b5d431bd2c, 0x0000000000000000, 0x0000075234a69f93, },
    { 0x000000d0475dab6c, 0x0000012622a5d99b, 0x0000000000000000, 0x000001afed2d8888, 0x000005315b9850c1, 0x000000eef3952dfb, 0x0000000000000000, 0x00000064bb0b4739, },
    { 0x000002a197127c2f, 0x0000014742da59da, 0x0000000000000000, 0x000003ed4f5a024a, 0x00000061aedade07, 0x000000dba6fa9340, 0x0000000000000000, 0x000000218d2e225d, },
  },
  // compressed: 0x05c85883a02aa60c4742207ae34a3d6adced113ba6d36474ef060855af9bbf03
  {
    { 0x000004277dbe5fde, 0x000002a08358c805, 0x0000000000000001, 0x00000128cc586604, 0x000007e4231822c8, 0x000001d31d88f6ee, 0x0000000000000000, 0x000006f6e609347a, },
    { 0x000005afd44c9278, 0x0000040848e194c5, 0x0000000000000000, 0x0000032e8fc7e27c, 0x0000066fe090e00d, 0x000000806ef7464d, 0x0000000000000000, 0x0000006e22ca0b63, },
    { 0x00000099753eb466, 0x000001a8f52b8de8, 0x0000000000000000, 0x000005bd61cfb2d1, 0x0000004bcc3957da, 0x000000077f375eaa, 0x0000000000000000, 0x000000acdaf0c68b, },
  },
  // compressed: 0xd02f5ac6854205a1c36716f32a11646c58ee1a7340e20a682ab29347f3a5fb14
  {
    { 0x0000049f9cc10834, 0x00000285c65a2fd0, 0x0000000000000001, 0x000006166985f7d4, 0x00000607bfbfe96d, 0x00000120398d772c, 0x0000000000000000, 0x0000015b3db0898f, },
    { 0x000003788a22c6f4, 0x000002ccf87420a8, 0x0000000000000000, 0x000001000ae79ae8, 0x000004c35d91cb5e, 0x0000013b22a680ae, 0x0000000000000000, 0x000007c526c2fc3f, },
    { 0x000006f2395b56a2, 0x000001b19044abcc, 0x0000000000000000, 0x00000164f97a1327, 0x000000672eb794bd, 0x00000029f74be68f, 0x0000000000000000, 0x000000290539d507, },
  },
  // compressed: 0xb8ec714e2f0be721e377a440b9dd56e6804f1dcece5665bf7e7b5d53c43bfc05
  {
    { 0x0000038497dd95c2, 0x0000032f4e71ecb8, 0x0000000000000001, 0x000003ae52afdedd, 0x000006b09e42f445, 0x00000367670ea7c0, 0x0000000000000000, 0x00000641d4df40ca, },
    { 0x000001d6b4ffe86f, 0x0000048efc643ce1, 0x0000000000000000, 0x0000076619e49716, 0x000007581739e0c5, 0x000005d7b7ebf655, 0x0000000000000000, 0x00000651f0433a4b, },
    { 0x000005b1d138c2a9, 0x000003995b76e502, 0x0000000000000000, 0x000004d2558e33b4, 0x0000005fb38e3cbe, 0x0000000bf87788a6, 0x0000000000000000, 0x0000006e6ece8eb8, },
  },
  // compressed: 0x90652414cb9540633555c116401412ef60bc10890c14389e8c7c90305790f5eb
  {
    { 0x000001fd40d1add9, 0x000005cb14246590, 0x0000000000000001, 0x000000f1e1415b8a, 0x000000290af81dd7, 0x0000020644885e30, 0x0000000000000000, 0x000003dc4d514d28, },
    { 0x0000069a04e5f753, 0x0000002aa6ac6812, 0x0000000000000000, 0x00000074efc1f4ef, 0x0000018f9994363f, 0x00000107c8c9e381, 0x0000000000000000, 0x00000635a566f52d, },
    { 0x000002cc1c59be5b, 0x000003bc4851005b, 0x0000000000000000, 0x00000019027fdeeb, 0x0000003f7d4ad876, 0x000000d7eb20ae61, 0x0000000000000000, 0x00000004a439ecf4, },
  },
  // compressed: 0xe45e2f77206714b1ce9a0796b194f8e84a82ac004d22f84ac46ccdf7d9531700
  {
    { 0x0000060b0a9d5294, 0x00000720772f5ee4, 0x0000000000000001, 0x0000032d963ddb34, 0x000003445ff083e7, 0x0000012680564125, 0x0000000000000000, 0x000000fcd048f942, },
    { 0x000003eb4cca27fd, 0x000000f359d6228c, 0x0000000000000000, 0x000002e70b078d24, 0x00000382cedd4618, 0x000004d6cc44af82, 0x0000000000000000, 0x0000048edb6aad7d, },
    { 0x0000023e639d703f, 0x000003a3e252c658, 0x0000000000000000, 0x000004777a1f6ad2, 0x0000007f4014fce2, 0x000000002ea7b3ef, 0x0000000000000000, 0x000000256bfc5f40, },
  },
  // compressed: 0x921e6fad267c2bdf13894b5023d3664bc38b1c75c09d408cb8c79607c2937eef
  {
    { 0x000003c496fce34d, 0x00000426ad6f1e92, 0x0000000000000001, 0x00000604aea6ae05, 0x00000130ff9462b0, 0x000006e03a8e45e1, 0x0000000000000000, 0x0000045af77fb5b3, },
    { 0x0000066b7dae3e1f, 0x00000171227be56f, 0x0000000000000000, 0x000004939323eb5e, 0x0000031206fd2047, 0x0000016c7b88c409, 0x0000000000000000, 0x0000060215161a80, },
    { 0x000005cee609aeb7, 0x0000052d9b4c8d41, 0x0000000000000000, 0x000003048d47c6fb, 0x000000e936edf2df, 0x000000defd27840f, 0x0000000000000000, 0x0000001f9d821e03, },
  },
  // compressed: 0x454e24c49dd2f23d0aded893740e022b4d210c827e06c86c0ab9ea6f16793741
  {
    { 0x000000a649fe1e44, 0x0000029dc4244e45, 0x0000000000000001, 0x000007548c1af8f0, 0x0000062d443fe869, 0x0000033f410610a6, 0x0000000000000000, 0x0000007c8f036c9c, },
    { 0x000005aeefcc89ab, 0x0000031bc147be5a, 0x0000000000000000, 0x0000045336811636, 0x000004511f302441, 0x000006ab90a6cc80, 0x0000000000000000, 0x000006d1213f760b, },
    { 0x00000087f2ba88c6, 0x000004ac0839d24f, 0x0000000000000000, 0x000007383de9f091, 0x000000920354e307, 0x000000826ef22cdf, 0x0000000000000000, 0x000000837710f6e4, },
  },
  },
  { // 2
  // compressed: 0xae91667c594c237ec8b4850a3d9d8864e7fa4a350cc9e2da1d9e6a0c071e870a
  {
    { 0x00000544744346be, 0x000004597c6691ae, 0x0000000000000001, 0x000005994bbc8989, 0x0000050c509db01f, 0x000004861aa57d73, 0x0000000000000000, 0x000006f10ceacf1e, },
    { 0x000006a564a81d0f, 0x000000b6990fc469, 0x0000000000000000, 0x000003a84c066036, 0x000004dbdf77c3a8, 0x000006a9e1ddae2c, 0x0000000000000000, 0x0000005d4640d61a, },
    { 0x00000075236b5056, 0x000005922274f42a, 0x0000000000000000, 0x000001cdaeb8e96f, 0x0000009d6e51825f, 0x000000150e3c0e18, 0x0000000000000000, 0x0000007dce601e4d, },
  },
  // compressed: 0x18751e844779fa43d7469c6359fac6e5742b05e31d5e06a13090b8cfa2c647fd
  {
    { 0x000005e49e7dd6b7, 0x00000147841e7518, 0x0000000000000001, 0x000000148ef0d6e0, 0x000003aec970c3e5, 0x0000070ef18295ba, 0x0000000000000000, 0x00000108135dc0ab, },
    { 0x00000163d59eba4a, 0x00000388dae87f4f, 0x0000000000000000, 0x0000028de787fb5a, 0x000001125c23c999, 0x00000389030a1065, 0x0000000000000000, 0x0000049ec8071ec6, },
    { 0x0000020058457184, 0x000003971be9658e, 0x0000000000000000, 0x00000674f9d26a45, 0x0000002702aec52f, 0x000000fa8f8d459f, 0x0000000000000000, 0x0000002919eb1a69, },
  },
  // compressed: 0x6d75e49a7d2f57e27f48f388bb45c3568da860696d0bd19fb9a1ae4eadeb8fa7
  {
    { 0x000002f67934f027, 0x0000077d9ae4756d, 0x0000000000000001, 0x0000001f8c933966, 0x0000061544b08c2a, 0x000005b6b4b05446, 0x0000000000000000, 0x0000014890ce9e29, },
    { 0x000000815528d492, 0x000006690ffc4ae5, 0x0000000000000000, 0x000005219316354d, 0x000005dbbd45ca1b, 0x000002ea1b99fd10, 0x0000000000000000, 0x000001c677b39115, },
    { 0x0000011a6612fbda, 0x0000055b0d16ee23, 0x0000000000000000, 0x0000023086527080, 0x0000007fe5f43d7a, 0x0000004f1fd75a9d, 0x0000000000000000, 0x0000008209ba05fd, },
  },
  // compressed: 0xb86a09db064e2181354fe40cc9b6a821f52a9e402ac1246581a4fc8ea4b56501
  {
    { 0x0000075e1124422a, 0x00000606db096ab8, 0x0000000000000001, 0x00000474a0846a76, 0x00000080fd295b33, 0x00000095204f157a, 0x0000000000000000, 0x000004832c5515c7, },
    { 0x0000046756ae5657, 0x00000489e6b02429, 0x0000000000000000, 0x000005ef981e3214, 0x000002f53d594cb6, 0x000007ca4816524c, 0x0000000000000000, 0x000007ec8b8695e2, },
    { 0x00000287e830ce62, 0x00000486a2db2433, 0x0000000000000000, 0x0000044bbfe61334, 0x000000590c76015f, 0x00000002cb6b491d, 0x0000000000000000, 0x000000b236cfb37f, },
  },
  // compressed: 0x5db5189f71b3b9991e648ca1fae565e4ed059fc2361108618b123070864f9b48
  {
    { 0x0000051c80b49bfa, 0x000003719f18b55d, 0x0000000000000001, 0x0000002d3aeb92ef, 0x000001e04f780e44, 0x0000009b614f82f6, 0x0000000000000000, 0x000005f38c85d512, },
    { 0x0000067d914625e1, 0x0000018c83d33736, 0x0000000000000000, 0x000002d50c3a4642, 0x000000f7bcb72703, 0x0000030128b61081, 0x0000000000000000, 0x000006cbebf3d7ea, },
    { 0x00000165e5457aaf, 0x000007919797ea86, 0x0000000000000000, 0x00000385894ed184, 0x0000007bc05d8f95, 0x00000091369f0ce0, 0x0000000000000000, 0x00000093ebf77492, },
  },
  // compressed: 0x2e579c1e8c625d15414788c5ac864d8aeb635751f652a3915b516788c2a6a106
  {
    { 0x000002108a5bcfd4, 0x0000028c1e9c572e, 0x0000000000000001, 0x000001d47c1764b6, 0x00000260983e068e, 0x0000017b28abb1f5, 0x0000000000000000, 0x000005300c567b68, },
    { 0x0000048e7d661293, 0x00000108e822abac, 0x0000000000000000, 0x000000316a2e511a, 0x000007a6e7492c29, 0x0000067515b91a35, 0x0000000000000000, 0x000002742c69f031, },
    { 0x000003710375c2f1, 0x00000629361ab316, 0x0000000000000000, 0x000005c950450381, 0x000000ac0950db97, 0x0000000d434d8510, 0x0000000000000000, 0x00000041313d13fc, },
  },
  // compressed: 0x2eecea858b277416df2bcb7a07dc21565af4cb61164c0a64d39505f750990bf3
  {
    { 0x000007fd3a2dcc7f, 0x0000078b85eaec2e, 0x0000000000000001, 0x00000535874ec552, 0x000004326903f1d0, 0x0000060b30e5fa2d, 0x0000000000000000, 0x0000037d0b601ae7, },
    { 0x000001fb124932ee, 0x000001657be2ce84, 0x0000000000000000, 0x0000048df1b92965, 0x00000267e29a279d, 0x000000595d3640a4, 0x0000000000000000, 0x00000303dccf7cb4, },
    { 0x000000ca15f0b295, 0x0000015887701deb, 0x0000000000000000, 0x000003179b233e60, 0x0000000807da3a19, 0x000000e61732a1ee, 0x0000000000000000, 0x000000b7ae8a8610, },
  },
  // compressed: 0x2a79e7152193c485c9ddcdbda2894cc662d7a3ada83d1e9d2cf8673012dbb75b
  {
    { 0x0000019528b24cc2, 0x0000032115e7792a, 0x0000000000000001, 0x00000467c6ca62be, 0x0000033727e0391b, 0x000006d456d1ebb1, 0x0000000000000000, 0x0000003bcdeaa3b8, },
    { 0x000006b8302ff35a, 0x000001bbb930b892, 0x0000000000000000, 0x0000032a5dc12c3e, 0x0000000ad8366b8b, 0x0000067f82c9d1e3, 0x0000000000000000, 0x0000070e0d218236, },
    { 0x000001fdad51958c, 0x0000031932268af7, 0x0000000000000000, 0x00000013b0875884, 0x0000002674f000e7, 0x000000b76fb62460, 0x0000000000000000, 0x000000e81b94dab1, },
  },
  },
  { // 3
  // compressed: 0x3c437804578c1a239d4381c20e27b5b79f07d9e3ea99aadbd9032b6c25f5032c
  {
    { 0x0000060752cfce4e, 0x000004570478433c, 0x0000000000000001, 0x000000757b53a47d, 0x000005955caa2ce2, 0x000004f571ec83cf, 0x0000000000000000, 0x000006bb92bf7bfc, },
    { 0x0000058116fbe91d, 0x0000002873a46351, 0x0000000000000000, 0x0000018b0f2f21e3, 0x000003ea38d05710, 0x000002b03d9dbaa9, 0x0000000000000000, 0x0000016bbaf31903, },
    { 0x0000030fffebcc1b, 0x000006ded49c3b0a, 0x0000000000000000, 0x000004c1ec04c33c, 0x0000002c3a4bf52c, 0x0000005807ea4ad8, 0x0000000000000000, 0x000000d328d17b7b, },
  },
  // compressed: 0x4819a96ae63dddd8ccd2c02fc26450482feafd346624489b3a2e4a6c4e1c3ea9
  {
    { 0x00000746f4dafecf, 0x000005e66aa91948, 0x0000000000000001, 0x0000034b925112e1, 0x000006ed2523d9bf, 0x000002331a7ef517, 0x0000000000000000, 0x000004d7a30e1888, },
    { 0x000007fadef7a3e5, 0x0000001a599b1ba7, 0x0000000000000000, 0x0000042bb406edc2, 0x00000105785d31ff, 0x000004a2e3a9b482, 0x0000000000000000, 0x00000032823b0458, },
    { 0x000005f3bc045291, 0x00000521419308bf, 0x0000000000000000, 0x000005c0dde2d772, 0x000000a4a43348e7, 0x000000527c389cd8, 0x0000000000000000, 0x000000b6c0b888fe, },
  },
  // compressed: 0x4cf0e7f0c6fee93b6249e3759e576a861ae61d1e16ef4255d5bd5accf4fe12af
  {
    { 0x0000005920c47c89, 0x000006c6f0e7f04c, 0x0000000000000001, 0x000002b2dfc0c740, 0x000002b2817177bb, 0x0000078b0f0ef30d, 0x0000000000000000, 0x00000220bc67fb34, },
    { 0x00000771f9972cb0, 0x000004692c477d3f, 0x0000000000000000, 0x0000013480e148a4, 0x000002eb3ee00012, 0x000005abdd55542e, 0x0000000000000000, 0x00000243790c6cf1, },
    { 0x0000079fc0403248, 0x00000219a95e79d7, 0x0000000000000000, 0x0000004341b9fd03, 0x000000494edb9d51, 0x0000005e25fde998, 0x0000000000000000, 0x000000bcc0f64a31, },
  },
  // compressed: 0x14cf96a51c432ca000e4d3ae402dc4e3db260f2e802645d26870459e13331f20
  {
    { 0x0000058f6cdf1818, 0x0000031ca596cf14, 0x0000000000000001, 0x0000076b08039d51, 0x000007a7b3730eb7, 0x000003401707936d, 0x0000000000000000, 0x000007581712d254, },
    { 0x0000044b144b1663, 0x0000027c80140588, 0x0000000000000000, 0x0000078000dfaa4f, 0x000004dd5f7e1b3f, 0x00000457068d2452, 0x0000000000000000, 0x00000460375d5220, },
    { 0x000000d73e9d3f0d, 0x0000078f10b502bb, 0x0000000000000000, 0x00000062c5259005, 0x000000a0cf5956d9, 0x000000403e66273c, 0x0000000000000000, 0x00000072f97510c4, },
  },
  // compressed: 0xe77913c8fbc31578f12ae1dd209461a6d5fda885f8c0a9ff52c2e1c122401b77
  {
    { 0x00000093f05959b2, 0x000003fbc81379e7, 0x0000000000000001, 0x00000186513a2fa7, 0x00000248b90eaf13, 0x0000007c42d47eea, 0x0000000000000000, 0x0000018d8f5141d9, },
    { 0x0000052f2ec61826, 0x000004255e2f02b8, 0x0000000000000000, 0x00000299e11b0fbb, 0x000006e6c3a222fd, 0x0000061c252ffa9c, 0x0000000000000000, 0x00000171a76d06bc, },
    { 0x00000388ea8637a6, 0x0000069986508377, 0x0000000000000000, 0x000007d6b26dc7e7, 0x0000004673a640ec, 0x000000ee36804583, 0x0000000000000000, 0x0000006634312433, },
  },
  // compressed: 0xaf72759d3a2f51269e4a076888e2cb5bc4f78011c1c1ed847ba649f69f61c91a
  {
    { 0x00000745fb4f80c6, 0x0000073a9d7572af, 0x0000000000000001, 0x00000042524b1068, 0x0000040dc820ec8e, 0x000000e088c07be2, 0x0000000000000000, 0x000000c225312864, },
    { 0x000000eeb9fea2cd, 0x000000e953c4ca25, 0x0000000000000000, 0x0000039d30fe4567, 0x000003dfe21e3d4e, 0x0000049a67b84edc, 0x0000000000000000, 0x0000008b111fc9d7, },
    { 0x00000270db1f7987, 0x0000016f2f8a21a0, 0x0000000000000000, 0x00000141a0d0efba, 0x000000622cf8d707, 0x0000003592c33fec, 0x0000000000000000, 0x000000c2486c683e, },
  },
  // compressed: 0x38262d1ae349638b35fdd39b00b7df9da46ba0a3b8f18b7f4504d97831aa2295
  {
    { 0x000001db874e898d, 0x000001e31a2d2638, 0x0000000000000001, 0x0000075369614938, 0x00000633e807cdde, 0x000000dc51d035d2, 0x0000000000000000, 0x000001c8db237913, },
    { 0x000000fb841b33a8, 0x0000027fa6b16c69, 0x0000000000000000, 0x000005ada2058705, 0x000005eff40793d2, 0x000005904457f8bf, 0x0000000000000000, 0x0000024306ce8c83, },
    { 0x00000027fa97c5b0, 0x000002777edc026f, 0x0000000000000000, 0x0000076bf9026adc, 0x0000008dd7c4613c, 0x0000002a455462f1, 0x0000000000000000, 0x0000008bfce1ea0a, },
  },
  // compressed: 0x911495c82049f262a20c633fc807f005b8d4c9f5d245bb6f45227ab56d9f6116
  {
    { 0x000005a6960c0b8c, 0x00000120c8951491, 0x0000000000000001, 0x0000024401a308fd, 0x000000e79e85c7ea, 0x000002e97ae4ea5c, 0x0000000000000000, 0x0000072321e8de3e, },
    { 0x000001c5e41b490e, 0x00000461944c5e49, 0x0000000000000000, 0x000004b9558109e9, 0x000006392d407fb5, 0x000007a22456fbb4, 0x0000000000000000, 0x000003d38c6deb8d, },
    { 0x0000016da341dbbc, 0x00000017c01f20fd, 0x0000000000000000, 0x000006a088670dda, 0x000000851a2c4741, 0x0000002cc33edb6a, 0x0000000000000000, 0x0000003b02b25ac1, },
  },
  },
  { // 4
  // compressed: 0xe8c5857b9fb66587b2ba68d18b67f06f9b0f331d7ce7703a7c8eafb0516d5fba
  {
    { 0x00000756a60dac5f, 0x0000069f7b85c5e8, 0x0000000000000001, 0x000005b67178b252, 0x00000796a66707be, 0x000003be0e9987cd, 0x0000000000000000, 0x0000051059f208b8, },
    { 0x0000057b8aec26d0, 0x000005175650ecb6, 0x0000000000000000, 0x000003da2c0eda41, 0x000006cdcf07f193, 0x000002f8e7c3a70e, 0x0000000000000000, 0x000007fe366f62a4, },
    { 0x0000045f80bdabae, 0x000005bfc19e2f45, 0x0000000000000000, 0x0000001c70d3e754, 0x000000404694ef13, 0x00000074bedaa361, 0x0000000000000000, 0x000000f9ad046a79, },
  },
  // compressed: 0xf3f4ac6860cd65a6d3e3d73c182dd942d92560339d385957ffd82c2b3b25f03e
  {
    { 0x0000045bd887fab6, 0x0000056068acf4f3, 0x0000000000000001, 0x000000cf4a465030, 0x0000000974b73000, 0x0000044e99b012ec, 0x0000000000000000, 0x000007457a55a0ce, },
    { 0x000000076dc17c34, 0x000002fc7a74ccb9, 0x0000000000000000, 0x000000aef57a2d76, 0x000005c0943d9921, 0x000002cd8ff57593, 0x0000000000000000, 0x0000028281282cfa, },
    { 0x000000aa11a8cae9, 0x0000050b64b460f3, 0x0000000000000000, 0x000007e925ad0457, 0x0000005071910c77, 0x0000007de04a7656, 0x0000000000000000, 0x00000043b9714c0d, },
  },
  // compressed: 0xba3177befa008d9a89189e627e6003827fd9f3433702ccb28b676f6cbf0d845d
  {
    { 0x000004468c9d9fc8, 0x000000fabe7731ba, 0x0000000000000001, 0x0000000d309fe18b, 0x000006a6097717ce, 0x0000011ba1f9ecbf, 0x0000000000000000, 0x0000054cbed71055, },
    { 0x00000554796b8c00, 0x000003c3113351a0, 0x0000000000000000, 0x0000042cb8ee0dc7, 0x00000231dab125b4, 0x000006f678bb2cc0, 0x0000000000000000, 0x000004196dd57bbb, },
    { 0x000000950025bb50, 0x000006080d81f98a, 0x0000000000000000, 0x000005bac0b69ae7, 0x0000001787a10329, 0x000000bb081b7ed8, 0x0000000000000000, 0x0000007484ec4655, },
  },
  // compressed: 0xcb7e44db72c1f83bbd2d28c61fc4cf5ffe15aa75c0ffac80f9a9e124e8c97007
  {
    { 0x0000032c8a7084fa, 0x00000172db447ecb, 0x0000000000000001, 0x0000019a45b5b5fd, 0x00000010ce2c722e, 0x000007e03ad50aff, 0x0000000000000000, 0x0000048c981f1f44, },
    { 0x0000073ca8a96848, 0x00000505b7a77f18, 0x0000000000000000, 0x0000074f2499ec3b, 0x000006debd1be9f0, 0x0000061a9f980acf, 0x0000000000000000, 0x00000500b1ee7300, },
    { 0x0000062628678f7e, 0x0000017f3f107f18, 0x0000000000000000, 0x000006182613a46c, 0x0000003fe2ef9d42, 0x0000000ee193d049, 0x0000000000000000, 0x00000073e4c9fa82, },
  },
  // compressed: 0xe17b09feab4a9bd12919e0dfe1fc6da4fff1a62c9408c9c34ef1352c2721c665
  {
    { 0x00000417dbe7e29c, 0x000002abfe097be1, 0x0000000000000001, 0x000001f8ce3193dd, 0x000005c749acbdd4, 0x0000044a165378ff, 0x0000000000000000, 0x0000049e970e7f41, },
    { 0x000003827394f5a6, 0x00000403253a3369, 0x0000000000000000, 0x000004b8177ce571, 0x00000089840a0e91, 0x0000035f14ec3c90, 0x0000000000000000, 0x000001ce2720419a, },
    { 0x000006f650dda8ae, 0x00000691b7f3877f, 0x0000000000000000, 0x0000053440cd5a84, 0x0000002e25ae68d1, 0x000000cb8c424e58, 0x0000000000000000, 0x00000045f3001563, },
  },
  // compressed: 0xacfd6e9add9f02424149a534bece12b97bf3bd87b9640f64b4ca9885d3a471c1
  {
    { 0x0000068a3e9ef8cb, 0x000007dd9a6efdac, 0x0000000000000001, 0x000000aa99c94c8c, 0x000004582f921247, 0x0000025cc3def9bd, 0x0000000000000000, 0x000000eed6ed29c9, },
    { 0x00000208e2ac0b46, 0x000004a928284053, 0x0000000000000000, 0x0000001700ff44eb, 0x000007626e5553d4, 0x0000018cab4640f6, 0x0000000000000000, 0x000004bd1abfbd29, },
    { 0x0000078fa7008a95, 0x000006e44b3af8d2, 0x0000000000000000, 0x0000008c01bdbec0, 0x00000027e82d9ac8, 0x00000082e349a70b, 0x0000000000000000, 0x000000a10429f4ae, },
  },
  // compressed: 0xd603d053bb151a4665c9f3bc882810b25a3a686c7576c52747b46cc8a45877ba
  {
    { 0x000001153ed6fe4b, 0x000005bb53d003d6, 0x0000000000000001, 0x000001f693ae5076, 0x00000323160a57ca, 0x0000033ab6341d2d, 0x0000000000000000, 0x000006487988af32, },
    { 0x000003aef898404d, 0x000006792ca8c342, 0x0000000000000000, 0x000007aa94ca9022, 0x000002ba74bcbde2, 0x000006cb44727c57, 0x0000000000000000, 0x0000067f49412248, },
    { 0x00000299699ce544, 0x000002c840a222f3, 0x0000000000000000, 0x00000476b8877c77, 0x00000045f2c1d8df, 0x00000074eeb14990, 0x0000000000000000, 0x000000bb3fa2bf1b, },
  },
  // compressed: 0x1e52d7ee2a4d243f15962e4328903a8ed4169c2e77ba64e1d898eb47fa87c1bb
  {
    { 0x000000d36d63727f, 0x0000052aeed7521e, 0x0000000000000001, 0x00000115ea86c20c, 0x000007e2e6577125, 0x0000053b974e0b6a, 0x0000000000000000, 0x0000015a9d3300c4, },
    { 0x000000f6a6606281, 0x000005d2c2a7e489, 0x0000000000000000, 0x000000da24ada8e0, 0x000000fbed3a9e18, 0x000006b98d8e164b, 0x0000000000000000, 0x000006fba03d7783, },
    { 0x000005a8de6bbf5f, 0x00000238ea40a10c, 0x0000000000000000, 0x000002662adf2db1, 0x000000665e6b229f, 0x00000077830ff48f, 0x0000000000000000, 0x0000008a1b039d20, },
  },
  },
  { // 5
  // compressed: 0x3f74ae1c96d874d0ed631ceef5186df829edf4e75bc5bd9708b13a6679d2bacc
  {
    { 0x000006a1a6205275, 0x000000961cae743f, 0x0000000000000001, 0x00000024a0d71fcd, 0x000000aaf447ae59, 0x000002adf3fa7694, 0x0000000000000000, 0x000003a5af9d320c, },
    { 0x00000791d06dcf76, 0x0000038c7dba0e9b, 0x0000000000000000, 0x000005115f101a32, 0x00000345be16f56d, 0x000003ab10897bdc, 0x0000000000000000, 0x00000007233b1a39, },
    { 0x000002a93c875d04, 0x000007e1b463d7b8, 0x0000000000000000, 0x0000071497082bec, 0x0000005bc4ba974c, 0x0000009975a4f2cc, 0x0000000000000000, 0x000000faff79dfc4, },
  },
  // compressed: 0x9490c2f3c55d7ccdab05912a9aa281c758301c42361dc680d7d4d8dc96d19ccf
  {
    { 0x0000066a266b2801, 0x000005c5f3c29094, 0x0000000000000001, 0x000007d86a7b3768, 0x000007de0d81bb16, 0x0000069b210e182c, 0x0000000000000000, 0x00000656ae0e060b, },
    { 0x00000673e2df5de3, 0x00000220b579af8b, 0x0000000000000000, 0x0000022f4c633252, 0x00000375a8df68a2, 0x0000058d4d780c61, 0x0000000000000000, 0x000007a0307ba029, },
    { 0x00000219b1a31355, 0x0000031e068a68aa, 0x0000000000000000, 0x000007434160906b, 0x000000b2ea86bd0f, 0x0000009f39a32db9, 0x0000000000000000, 0x000000f99ba10870, },
  },
  // compressed: 0x93cc606718840c9b992ab31a7a00aecd18da0b6286ec8da844ca908184ca93b5
  {
    { 0x0000022c6d260417, 0x000004186760cc93, 0x0000000000000001, 0x0000009a5e849aa7, 0x000000da7db4633b, 0x000006433105ed0c, 0x0000000000000000, 0x0000022da9fedde8, },
    { 0x0000004817bb94c8, 0x0000066553336190, 0x0000000000000000, 0x0000031f59b24263, 0x0000050cf53a9c0c, 0x0000010ca44a88de, 0x0000000000000000, 0x000002d63e68c525, },
    { 0x000006b854f54252, 0x00000336b801e86a, 0x0000000000000000, 0x00000753630cd597, 0x0000008517a1dac3, 0x0000006b27950903, 0x0000000000000000, 0x0000004e730611b4, },
  },
  // compressed: 0x5324700a4c0ea1b9de1b7dd56658a20ff7da27cdb5d9b9fffd332c4945292cd7
  {
    { 0x00000528435ed413, 0x0000064c0a702453, 0x0000000000000001, 0x00000745d6cd30be, 0x0000058d3ced01f7, 0x000004dae693ed7b, 0x0000000000000000, 0x00000418552eed06, },
    { 0x0000071999285871, 0x000007a37bd73421, 0x0000000000000000, 0x00000755df78eff8, 0x000000c3355bb07a, 0x000002c33fdffb9d, 0x0000000000000000, 0x000005bca80a22c8, },
    { 0x000006f543cd80c9, 0x0000043e89619b55, 0x0000000000000000, 0x000003937fa34f8e, 0x0000004d2b2f5d7d, 0x000000ae58528a92, 0x0000000000000000, 0x000000ff30a93180, },
  },
  // compressed: 0x6363bf0f521556d3a6fb4dcf455a0408c2a03f87bc4fc2eee7129bd63c65f2b0
  {
    { 0x000006889f0be117, 0x000005520fbf6363, 0x0000000000000001, 0x00000138aac10c85, 0x000001cf91fe490e, 0x000007de439fd061, 0x0000000000000000, 0x0000000f0737d638, },
    { 0x0000029451070939, 0x000001bf74da6ac2, 0x0000000000000000, 0x000004ed79714119, 0x0000031f3043da3c, 0x000001b12e7eec24, 0x0000000000000000, 0x000006473daa920c, },
    { 0x0000020016b46ded, 0x000000201169173d, 0x0000000000000000, 0x000001185e6d836c, 0x000000ed85d88e14, 0x00000061e4ca79ad, 0x0000000000000000, 0x0000005e24e7e2b2, },
  },
  // compressed: 0xc00ba755d78b4830e742d4f1a4b5d606626159bc9ea6d1ea84f7c5ed9719acb8
  {
    { 0x0000047c8ae01e11, 0x000003d755a70bc0, 0x0000000000000001, 0x00000517a751b13b, 0x0000054143b94797, 0x0000034f5e2cb0b1, 0x0000000000000000, 0x00000008a2a6ef24, },
    { 0x0000055573e8e73f, 0x000002885ce60911, 0x0000000000000000, 0x00000370b180ccd6, 0x000005b69f241d98, 0x0000045f784ead1a, 0x0000000000000000, 0x0000069e69cacacc, },
    { 0x000003f549d24129, 0x0000001b5ad693c7, 0x0000000000000000, 0x000005d1f41a19fa, 0x000000bb3cae55b0, 0x0000007158332fdb, 0x0000000000000000, 0x00000045bf9b397f, },
  },
  // compressed: 0xa1e03b10b459ec5669f959d2ecbae32e32cdf51394b27c7972e4cd247887e98f
  {
    { 0x000002e0c30d0cd9, 0x000001b4103be0a1, 0x0000000000000001, 0x000004d10aba913b, 0x000002c619154b0f, 0x0000014a09fae699, 0x0000000000000000, 0x000006ffb2bc7c0a, },
    { 0x000007686671bb7a, 0x0000033f2d2add8b, 0x0000000000000000, 0x000005b581cfdb66, 0x0000048c1c78f6b2, 0x000004de472797cb, 0x0000000000000000, 0x00000700a1766083, },
    { 0x000006b639997eb2, 0x000000bb8eebb349, 0x0000000000000000, 0x0000053a8f3608b9, 0x000000d6522d80a8, 0x0000001fd30ef049, 0x0000000000000000, 0x00000098607e60ff, },
  },
  // compressed: 0x0045d90d5803fc2993ecbb6fa47ad2ecf8a7e2c25f150a13d5a106b71a156bc1
  {
    { 0x000003d617b28c85, 0x000003580dd94500, 0x0000000000000001, 0x000007efe9c136b0, 0x000003c60f352e5f, 0x000002afe17153fc, 0x0000000000000000, 0x000007ed0dabf055, },
    { 0x000006e77d5a6147, 0x0000077d92653f80, 0x0000000000000000, 0x00000489640ad51a, 0x000002ab7c4c6c6e, 0x0000006a1d5130a1, 0x0000000000000000, 0x0000077e8d2afe62, },
    { 0x000007174ddedce5, 0x000003b349ea91be, 0x0000000000000000, 0x000006f41f973563, 0x0000001ac371ef16, 0x00000082d62a356e, 0x0000000000000000, 0x000000323455ee84, },
  },
  },
  { // 6
  // compressed: 0xfb0e464f432be69fd60736a6d403d3de24daa0b70e2152f0935b5400be7d7ea3
  {
    { 0x0000074bc53c1431, 0x000003434f460efb, 0x0000000000000001, 0x000005ed6701b430, 0x000001b7dad91f73, 0x000000875bd06d12, 0x0000000000000000, 0x0000078ac1f23f91, },
    { 0x0000065dbbd9c2de, 0x000006c0fad3fcc5, 0x0000000000000000, 0x0000017fa20026ae, 0x000005cc908b8b9c, 0x00000545b93f0522, 0x0000000000000000, 0x000001155e375320, },
    { 0x000004ae5c973881, 0x0000037b4c0f5298, 0x0000000000000000, 0x0000008c42539a7c, 0x000000fc5c1c8a16, 0x00000046fcfb7c00, 0x0000000000000000, 0x000000e35f4d3362, },
  },
  // compressed: 0xd6503b471c3c42ea10ef383b1f7ae85195bec9b25fbf849b1c9af878bc1f7380
  {
    { 0x0000079b3953b61d, 0x0000041c473b50d6, 0x0000000000000001, 0x0000071848f81880, 0x000007fed4fbacff, 0x000007afd964df4a, 0x0000000000000000, 0x00000041b5dd0af1, },
    { 0x000004283cccb9cd, 0x0000071de21d4847, 0x0000000000000000, 0x000001d8233c8618, 0x0000031c28e0f435, 0x00000789a1c9b84b, 0x0000000000000000, 0x00000615808b6dae, },
    { 0x0000031960e7aabe, 0x00000547a1e87cec, 0x0000000000000000, 0x000006fe5830897b, 0x000000042285d385, 0x00000000e63f78f1, 0x0000000000000000, 0x000000989ade668f, },
  },
  // compressed: 0x70198f98fcdd0c2f1bf5b9b02762916bbe769177c4b6c76ea89f8fa80095bfb8
  {
    { 0x000004cfc17d1fc9, 0x000005fc988f1970, 0x0000000000000001, 0x0000013c37e8876f, 0x00000095fbf7066f, 0x000003623bc8bb5f, 0x0000000000000000, 0x000002c11c92093b, },
    { 0x0000000782831efd, 0x0000073ea365e19b, 0x0000000000000000, 0x00000228c583fa59, 0x00000647a22dbde7, 0x000000f9fa86ec7b, 0x0000000000000000, 0x000000d49695080f, },
    { 0x000005b1d7d69945, 0x000001ae45889ec2, 0x0000000000000000, 0x0000028bd8796863, 0x000000327fbb554f, 0x000000717f2a0151, 0x0000000000000000, 0x000000d4df733d7e, },
  },
  // compressed: 0xc623e4b6b522b1ee8eff86f210709d938c5dcf1d832aa99010ebc5429fda6f93
  {
    { 0x000001bb560855eb, 0x000002b5b6e423c6, 0x0000000000000001, 0x000007b1a305bdd1, 0x0000009bc7b8d660, 0x000005418ee7aec6, 0x0000000000000000, 0x00000452e1ddac45, },
    { 0x0000027e13ad48d8, 0x000000dff1ddd624, 0x0000000000000000, 0x00000705811f299b, 0x000001896ead71d1, 0x0000045eb1090a92, 0x0000000000000000, 0x0000068dcba2a87d, },
    { 0x000004905aece3e2, 0x0000024e75c043ca, 0x0000000000000000, 0x0000003cd92e767f, 0x000000ebeed22946, 0x00000026dfb53e85, 0x0000000000000000, 0x000000044306a217, },
  },
  // compressed: 0x7f7a304301715a9d5fa47dc49ede63b0d37a92be52febb226c4240fd41c48713
  {
    { 0x000006385ead2d14, 0x0000010143307a7f, 0x0000000000000001, 0x000003d187978af8, 0x0000037308108f1e, 0x000007295f493d69, 0x0000000000000000, 0x000004245da3be50, },
    { 0x0000078b06095eec, 0x000007b48bf3ab4e, 0x0000000000000000, 0x000001c88276ba78, 0x00000006c030d13a, 0x0000040426c22bbf, 0x0000000000000000, 0x000001edc920d7b4, },
    { 0x000006823b620329, 0x000006c18f7a7b11, 0x0000000000000000, 0x000001c8ad68f5fc, 0x000000d40e39c2f7, 0x000000270f8883fa, 0x0000000000000000, 0x00000062e364d55e, },
  },
  // compressed: 0xd1478ab2d8b70da6f1a47017d614bfa658bddd5393f8a1d4e9434234634a516c
  {
    { 0x0000019097564ca8, 0x000007d8b28a47d1, 0x0000000000000001, 0x0000004f3a156341, 0x0000071bd243a8a8, 0x00000449a9eedeac, 0x0000000000000000, 0x000006a620878187, },
    { 0x000006bc233525e6, 0x000006149e34c1b6, 0x0000000000000000, 0x0000014065a46444, 0x0000070835a4f55f, 0x000004243e9d4a1f, 0x0000000000000000, 0x00000124aaafce0d, },
    { 0x000003fdeee13089, 0x0000029afc53585d, 0x0000000000000000, 0x000003edcf83a6e8, 0x000000443fa90e79, 0x000000d8a294c668, 0x0000000000000000, 0x00000091b54b2df7, },
  },
  // compressed: 0x93974cc85d1df614068241efe3f94199ac7762348fb8f5cda9798a0efa37c8d8
  {
    { 0x000006665ca59cc7, 0x0000055dc84c9793, 0x0000000000000001, 0x0000008596fc9058, 0x00000384690f0be7, 0x000004479a313bd6, 0x0000000000000000, 0x000003bea49aeb35, },
    { 0x00000715940dd951, 0x0000003040c29ec3, 0x0000000000000000, 0x000002d403619f2d, 0x00000584af731afc, 0x000000a79a9cdf5b, 0x0000000000000000, 0x00000257f0adcc2e, },
    { 0x000002a11c952cb8, 0x0000026507e78fbd, 0x0000000000000000, 0x0000007772efcded, 0x000000cedbadf995, 0x000000b1906ff41d, 0x0000000000000000, 0x000000389ee7e58d, },
  },
  // compressed: 0x84347cfc6e706eb361cfc1c3b4c9df73e5c71c78c9791deb5c67af7ddb9a45f0
  {
    { 0x000007bd305fa0bb, 0x0000006efc7c3484, 0x0000000000000001, 0x0000034991b42bb3, 0x000001c197f19c24, 0x000004e4bc0e63f2, 0x0000000000000000, 0x000007728fc63c6e, },
    { 0x000000cc75a1cf49, 0x00000039ec366dce, 0x0000000000000000, 0x0000005b9943723b, 0x00000764c42f421c, 0x000002f675ceb1d7, 0x0000000000000000, 0x00000621fd39fdf9, },
    { 0x0000020a75338153, 0x000005cf7f26d30f, 0x0000000000000000, 0x0000015c9a588d2c, 0x000000f2b5901a37, 0x000000e08b35b6fb, 0x0000000000000000, 0x000000bfc2c50919, },
  },
  },
  { // 7
  // compressed: 0x08b27c5d2d857928e7f27d6870dddeb891786821abff0bdc35aa7d6743c0442b
  {
    { 0x0000014fe194961a, 0x0000052d5d7cb208, 0x0000000000000001, 0x000007ab074eb78e, 0x000007e91da87916, 0x000007d590b43c48, 0x0000000000000000, 0x000005e6a427c833, },
    { 0x00000639a9e9cb24, 0x000007be5ce50f30, 0x0000000000000000, 0x0000035e8ce34390, 0x000001172329300c, 0x000007daa35dc0bf, 0x0000000000000000, 0x0000039a4e43eacb, },
    { 0x00000526f9f71c35, 0x000006e37b75c1a1, 0x0000000000000000, 0x000007eb1b463a67, 0x0000008f13a88df9, 0x00000056898086ce, 0x0000000000000000, 0x000000c18a5dde57, },
  },
  // compressed: 0x116dae7cc2c52b70ab8ca4549b69c744b22e49ba5640bcef6d67b6d94872d7f0
  {
    { 0x000001bc3bfd8bf1, 0x000005c27cae6d11, 0x0000000000000001, 0x0000004b3ec2a05b, 0x000003586a98147a, 0x0000002b5d249759, 0x0000000000000000, 0x000001f2384742e8, },
    { 0x0000066aa3416bb1, 0x00000491956e0578, 0x0000000000000000, 0x000002f03c15515d, 0x000004fcaab0e4c1, 0x0000036676defbc4, 0x0000000000000000, 0x0000076f41379451, },
    { 0x000006c1ae48df27, 0x000001131da66d52, 0x0000000000000000, 0x00000661a67bd3b4, 0x0000002179386259, 0x000000e1aee491b3, 0x0000000000000000, 0x000000c6eab7a752, },
  },
  // compressed: 0xb7acf1971810c73dd8bb65c15e7dda5d0f02a10f9c5b8e50562ac537177563a7
  {
    { 0x0000003e2ad10853, 0x0000001897f1acb7, 0x0000000000000001, 0x000002d36eb419a9, 0x000000fedf34dc48, 0x000005ce07d08107, 0x0000000000000000, 0x000001186a1e24ab, },
    { 0x000004c6ad36abf4, 0x000004b77b07b8e2, 0x0000000000000000, 0x0000068c14a05280, 0x00000416f849ff9f, 0x00000452a56508e5, 0x0000000000000000, 0x000005166e7cfa86, },
    { 0x000000d5bdd6427b, 0x0000057769f57b05, 0x0000000000000000, 0x000003c2d139f9de, 0x0000001b19838917, 0x0000004ec6ea2e6f, 0x0000000000000000, 0x000000e185bb14f5, },
  },
  // compressed: 0x137eedb87d96d4917a8176d70a2f25746425850de08209e4e53ca5163861b832
  {
    { 0x000004509f6fec0e, 0x0000067db8ed7e13, 0x0000000000000001, 0x000007bee448cd64, 0x000000f9b3f04dae, 0x0000017006c292b2, 0x0000000000000000, 0x0000026cd0726d97, },
    { 0x000000ca31acac32, 0x000006d02f523a92, 0x0000000000000000, 0x00000710da0f3cfe, 0x000001484959733c, 0x00000253ce5e4098, 0x0000000000000000, 0x000005a4f41f89fd, },
    { 0x000003b8b9faa51b, 0x000001d094bc2b5d, 0x0000000000000000, 0x000001ab20e99c21, 0x0000005c1f58c6c7, 0x0000006570c2702d, 0x0000000000000000, 0x00000082f242b8e6, },
  },
  // compressed: 0x34cd6b28b933aee4dcd69d55b67eefb71f8ed3b31f148b2786c241226685fa31
  {
    { 0x000004e7d7dced2a, 0x000003b9286bcd34, 0x0000000000000001, 0x000004422e3622f4, 0x00000019d4836c81, 0x0000020fd9e9c70f, 0x0000000000000000, 0x000003f0959c4891, },
    { 0x000002738e118e12, 0x000003badb9c95c6, 0x0000000000000000, 0x0000066a05b5f04d, 0x00000599d76e13be, 0x0000041c286278b1, 0x0000000000000000, 0x000001524899bc1b, },
    { 0x0000025fee2b0d1f, 0x000006dfbdfad956, 0x0000000000000000, 0x0000070480a61e60, 0x000000e006894619, 0x00000063f50acc44, 0x0000000000000000, 0x0000004976462553, },
  },
  // compressed: 0x6b5cf8f52a0cf8419467fa04c3847268ad1bbaa399df4589165debfff92a1d8d
  {
    { 0x0000051732de67c3, 0x0000042af5f85c6b, 0x0000000000000001, 0x000002a132621edf, 0x000001a1bb67de69, 0x000007ccd1dd0dd6, 0x0000000000000000, 0x000004bdd3cd60c9, },
    { 0x000003692916351d, 0x0000074cf2883f01, 0x0000000000000000, 0x0000044caf353b51, 0x000001880088ebd4, 0x000006b5d168945d, 0x0000000000000000, 0x00000531d7640041, },
    { 0x000000f2d2506118, 0x000005a1ca130c13, 0x0000000000000000, 0x000004c2e08a8564, 0x0000001fdc7d0e3c, 0x0000001a3a55f3ff, 0x0000000000000000, 0x0000002d59af2e30, },
  },
  // compressed: 0xadb68778c5c659c9bafe905fad9ee19404f542a3624ee216001716184bd34e96
  {
    { 0x000002af2d9b1d3d, 0x000006c57887b6ad, 0x0000000000000001, 0x0000014c192fe69a, 0x0000003c8b59cb1b, 0x0000073151a17a82, 0x0000000000000000, 0x00000369dcd26f13, },
    { 0x000006448b4e5bee, 0x0000021fd7592b38, 0x0000000000000000, 0x00000222a2690fdb, 0x000003023093ecea, 0x0000016170016e24, 0x0000000000000000, 0x0000073f3eb877bf, },
    { 0x0000058d18a8da90, 0x00000253867ab57e, 0x0000000000000000, 0x00000586b8b3a8ea, 0x000000247c1ded72, 0x0000002c9da69630, 0x0000000000000000, 0x000000f1b41f8c20, },
  },
  // compressed: 0x943a0c68f1809fa2e6e7e91a157ef7717379014858f10011dd8db316b3a44a05
  {
    { 0x00000528e52bc66a, 0x000000f1680c3a94, 0x0000000000000001, 0x0000068d19267cb8, 0x000007de036145ee, 0x000000ac2400bcb9, 0x0000000000000000, 0x000006953337760b, },
    { 0x0000060351cb7e2b, 0x0000053cfcd453f0, 0x0000000000000000, 0x000004a9b5fbf908, 0x000006b173a2419a, 0x00000338ddd1100f, 0x0000000000000000, 0x000007da7602aeb1, },
    { 0x000004b11f8c61c3, 0x000005c7ddf8546b, 0x0000000000000000, 0x0000042ca1e2719b, 0x0000005a4bbdd64a, 0x0000000a9549662d, 0x0000000000000000, 0x000000268c214d56, },
  },
  },
  { // 8
  // compressed: 0x15f5d177e7652acdf160aa8f87918954e506bcdabc3bb7b1fbc97ca9cb784865
  {
    { 0x000006c78df6b0fe, 0x000005e777d1f515, 0x0000000000000001, 0x00000405055ce6a1, 0x0000050eb8bd78dc, 0x000005de6d5e0372, 0x0000000000000000, 0x0000028bd53ed20a, },
    { 0x000006bea36a2271, 0x0000054c1e39a54c, 0x0000000000000000, 0x00000235a532d3dc, 0x0000020d65009207, 0x000007cc9fbb1b73, 0x0000000000000000, 0x000006cb2ba3a1af, },
    { 0x0000054e5f6a2795, 0x0000055226461e3e, 0x0000000000000000, 0x000004daf29da049, 0x0000004205fb7456, 0x000000ca90f19752, 0x0000000000000000, 0x00000015ae4bb653, },
  },
  // compressed: 0x856f059b0cbcc7fed7fff5e768527d53faae124362c6af77d99f3902535f67cf
  {
    { 0x000007b1834e2457, 0x0000040c9b056f85, 0x0000000000000001, 0x000006360415171e, 0x00000505fbe8af6b, 0x000003312189577d, 0x0000000000000000, 0x00000756e84a2888, },
    { 0x000001c378bb884c, 0x000006bffaffd8f7, 0x0000000000000000, 0x00000309077865a6, 0x000002036501af07, 0x00000399fd977afc, 0x0000000000000000, 0x00000286561870a6, },
    { 0x000006d9d512d5c3, 0x0000014df549a39f, 0x0000000000000000, 0x00000334afbc4626, 0x00000095df9ff6e3, 0x0000009ecebea604, 0x0000000000000000, 0x000000179976e545, },
  },
  // compressed: 0x9612fe504c5e6d187e9fe8fe827b39e0b0317050c5f6c73bc2378f1069fd7866
  {
    { 0x0000062feab1a9c8, 0x0000064c50fe1296, 0x0000000000000001, 0x00000231636863c2, 0x00000018ddadb6f9, 0x00000362a83818d8, 0x0000000000000000, 0x0000064fbc4f577e, },
    { 0x0000028fb9a30bd2, 0x00000513efc30dab, 0x0000000000000000, 0x000005a67e42b0df, 0x0000056b73eb092e, 0x000000f37c23bc7f, 0x0000000000000000, 0x000002d47014f73c, },
    { 0x0000021b9f98d594, 0x00000380e5ee0bfb, 0x0000000000000000, 0x0000001fda31215c, 0x0000008049e156b3, 0x000000ccf1fad221, 0x0000000000000000, 0x0000005a85c4211d, },
  },
  // compressed: 0x9375530f0d7b71214c061e130b694e919fe02a75ae87b61b6e3c429ba7f30bc2
  {
    { 0x0000031594dfd29b, 0x0000030d0f537593, 0x0000000000000001, 0x000002651c5b2b47, 0x000007838422a808, 0x000003d73a95704f, 0x0000000000000000, 0x00000658de189ad8, },
    { 0x000007e98d52fea2, 0x000003c0c9842e2f, 0x0000000000000000, 0x0000036370102717, 0x0000052d322eba13, 0x00000423c6e1bb68, 0x0000000000000000, 0x000000cf1e07bff0, },
    { 0x00000185566174c4, 0x0000064539a42c4c, 0x0000000000000000, 0x00000219c6dbb0c4, 0x000000ced64c1171, 0x0000008417e74f36, 0x0000000000000000, 0x000000e8ba5ff538, },
  },
  // compressed: 0x6a4ed32157df3660d0b37b992788dbb1fa6a75c8c309c2d339c81d4ce55be186
  {
    { 0x0000021e2bc9c8bd, 0x0000075721d34e6a, 0x0000000000000001, 0x000005871932994a, 0x000003876f80aaed, 0x000004e1e43ab57d, 0x0000000000000000, 0x000002a4ed5be502, },
    { 0x000000f3b037ea4b, 0x000007767a0c06db, 0x0000000000000000, 0x0000063b560b6e4b, 0x000000cf5d0d511c, 0x000001dc839d3c20, 0x0000000000000000, 0x000000ec1f77dc41, },
    { 0x000007a96c982099, 0x000002c76e209e65, 0x0000000000000000, 0x000004c8d472d73a, 0x00000035c479d72c, 0x0000000dc2b7ca98, 0x0000000000000000, 0x000000b1bdb0c24f, },
  },
  // compressed: 0xa8c9c2b6a85bfb2d8c592cf58eefee4873152df107918033d85b1d536b69ba08
  {
    { 0x00000793f266c55c, 0x000003a8b6c2c9a8, 0x0000000000000001, 0x000006eec3efc57a, 0x0000017c5e1361d4, 0x00000083f8968ab9, 0x0000000000000000, 0x0000051ff8d338e5, },
    { 0x000000a9c93b02e6, 0x0000058b3185bf6b, 0x0000000000000000, 0x000007e9022efda7, 0x0000005f6f95ce38, 0x000001d5bd833809, 0x0000000000000000, 0x000007cfe54ea3d7, },
    { 0x0000032325db1731, 0x00000523bbbe3bd4, 0x0000000000000000, 0x0000041381545f53, 0x0000005fe73bd0a9, 0x0000001174d2d6a6, 0x0000000000000000, 0x000000240c676928, },
  },
  // compressed: 0x0a1012494731bd8206be6f7e6d7b23dec679ea1119761ee1de3b39cbe33b4307
  {
    { 0x0000007891610042, 0x000001474912100a, 0x0000000000000001, 0x000004c05ce997f4, 0x000001caca785260, 0x0000030c88f53ce3, 0x0000000000000000, 0x000000fead3b423e, },
    { 0x0000057f5d017293, 0x000005f7c0d057a6, 0x0000000000000000, 0x0000038a347fef28, 0x0000055918570be7, 0x00000393bdee11e7, 0x0000000000000000, 0x0000076da9f58338, },
    { 0x0000013b9ec4f3b3, 0x000003788dedb5f9, 0x0000000000000000, 0x0000015d74f792c1, 0x0000006ba6153369, 0x0000000e8677c796, 0x0000000000000000, 0x0000005b0e7dbcf5, },
  },
  // compressed: 0x81f95d4ee10262aaf5e1155017590da26c1de2bad375a218530260018a614385
  {
    { 0x0000016443373409, 0x000002e14e5df981, 0x0000000000000001, 0x000005f4974c23c1, 0x000007737ad32403, 0x000002e9dd710eb6, 0x0000000000000000, 0x0000065c514d5d16, },
    { 0x000005503b22af46, 0x000002bc3eb54c40, 0x0000000000000000, 0x000001c8d261bd57, 0x000007fa7b6b093f, 0x0000060025318a27, 0x0000000000000000, 0x0000007960d04202, },
    { 0x000003eae2dfbbd2, 0x0000028835645d40, 0x0000000000000000, 0x000002a9bc289677, 0x0000005cee6ca8e0, 0x0000000a86c31402, 0x0000000000000000, 0x0000009628866c5a, },
  },
  },
  { // 9
  // compressed: 0xcb9c521ce9547c96fb35c6649226f63065191278f4af47275c6ff6ea18840317
  {
    { 0x000007c7b66e1f7a, 0x000004e91c529ccb, 0x0000000000000001, 0x000003d320324ce4, 0x000006fe389f578e, 0x000007fa3c090cb2, 0x0000000000000000, 0x000000c5a72d09b2, },
    { 0x00000185efd99896, 0x000000c6bf72cf8a, 0x0000000000000000, 0x000001117898c62f, 0x000005a63f73ef06, 0x00000766f5c2747a, 0x0000000000000000, 0x00000228dc9b21ef, },
    { 0x0000011055f897d4, 0x000004c3d89a4993, 0x0000000000000000, 0x000002a0410ba291, 0x000000b05e88cea5, 0x0000002e070831d5, 0x0000000000000000, 0x000000185438979b, },
  },
  // compressed: 0x4569bd694881c4ed228d1cbe7d906d0dabc55cd512d23bc683dc14a3309b6ada
  {
    { 0x000007d06f1f0447, 0x0000014869bd6945, 0x0000000000000001, 0x00000524d396463d, 0x000001397dd96947, 0x000001096aae62d5, 0x0000000000000000, 0x0000053c8e5e2fd2, },
    { 0x000000f80b3a49b8, 0x00000391a45db890, 0x0000000000000000, 0x000003449e1a1d82, 0x00000764877d15b0, 0x0000014dc83c63bd, 0x0000000000000000, 0x000007bafc3a50c3, },
    { 0x000006c89a78fb6e, 0x00000435b641f6f8, 0x0000000000000000, 0x0000004aed8a2b0d, 0x000000f8ab17a38d, 0x000000b4d5366146, 0x0000000000000000, 0x00000008094b9415, },
  },
  // compressed: 0xd16f412a1b9ebc628b5950e328f7c6b567695d3dd83f340498eef8e716755239
  {
    { 0x000000070aa743d6, 0x0000061b2a416fd1, 0x0000000000000001, 0x0000032d1a5d9a9c, 0x00000235b347e96f, 0x000007ec1eaeb4b3, 0x0000000000000000, 0x00000778aa6ab7f5, },
    { 0x000004cbdd1183e8, 0x0000020b316c5793, 0x0000000000000000, 0x0000000b85422ffb, 0x000005d9633574b0, 0x0000078ee9804343, 0x0000000000000000, 0x0000022d016efd4b, },
    { 0x00000332eb432d6c, 0x000006d71bdca38d, 0x0000000000000000, 0x00000271dd16f344, 0x0000008c72b7fb95, 0x00000072a4ea2dcf, 0x0000000000000000, 0x000000ecaf3453d0, },
  },
  // compressed: 0xf234b45213b53c33e180de93492832d8ce350d75872851b5c177272abb14c582
  {
    { 0x0000067e49c02a17, 0x0000051352b434f2, 0x0000000000000001, 0x000005da8bf1b645, 0x00000788f611260d, 0x00000443ba869ae7, 0x0000000000000000, 0x0000036bd4d86929, },
    { 0x000005346fe8b6d1, 0x000003d01c266796, 0x0000000000000000, 0x000006a96a6d097a, 0x0000005bdb13ed65, 0x000002777c1b5512, 0x0000000000000000, 0x0000054805931391, },
    { 0x0000048f35468af2, 0x00000360c8a1264f, 0x0000000000000000, 0x000007ee2f4dfbda, 0x000000874709b93c, 0x000000058a297654, 0x0000000000000000, 0x00000022c12412c2, },
  },
  // compressed: 0xcd4d9b361656387a63355c65a72cc0752180f1d4f91bc27d42e0e691747d632f
  {
    { 0x0000066929dacfaa, 0x00000616369b4dcd, 0x0000000000000001, 0x000003461af67bbe, 0x000001e5229eaaac, 0x000005fcea78c010, 0x0000000000000000, 0x000000cffcd34cfd, },
    { 0x0000026b31f689a2, 0x00000386ac6f470a, 0x0000000000000000, 0x000005712c3a9693, 0x00000698e0be9ef6, 0x0000066e0427dc21, 0x0000000000000000, 0x000004e2a9a71dee, },
    { 0x000007694a7d3210, 0x000005d700b29d95, 0x0000000000000000, 0x000007580c0deb22, 0x0000006a3c24b78a, 0x0000005ec6fae923, 0x0000000000000000, 0x000000fe305a0dcf, },
  },
  // compressed: 0x2275218e724b4509d8b884d4f4e858aa3c90467f4d2558d317521c2443c0ac44
  {
    { 0x00000664ab0168ec, 0x000003728e217522, 0x0000000000000001, 0x000003bb4f7a5777, 0x000004e9a3e6876d, 0x000002a6bfa3481e, 0x0000000000000000, 0x000000e364b5a342, },
    { 0x000005b8a86f4f91, 0x000000971b0128a9, 0x0000000000000000, 0x000000627c238fad, 0x000003e93b009551, 0x000001c5217d3582, 0x0000000000000000, 0x000002d71bd4adca, },
    { 0x0000032d69295457, 0x000002a963a3d352, 0x0000000000000000, 0x0000022cd7fb5246, 0x000000cfa9591868, 0x0000008959808648, 0x0000000000000000, 0x000000aada390625, },
  },
  // compressed: 0x21e81bb15667f081ddf3a31023f8af0f5d46996a55d0b2f8057f8ccc38be7a09
  {
    { 0x000000e30c8d3982, 0x00000756b11be821, 0x0000000000000001, 0x000001877ea52da4, 0x000001e583b9b237, 0x0000002ab54ca32e, 0x0000000000000000, 0x00000404fbe675e9, },
    { 0x0000047f4682fde8, 0x0000047e7bb03e0c, 0x0000000000000000, 0x00000383a8618939, 0x00000024eff4f21f, 0x000000c7f05f8b2d, 0x0000000000000000, 0x000006e84bd022c3, },
    { 0x000000c7dc1cf856, 0x0000043ebfe08c42, 0x0000000000000000, 0x000001310da5566f, 0x000000e8d8d8da3b, 0x00000012f57c7199, 0x0000000000000000, 0x000000aefc294697, },
  },
  // compressed: 0x2bd74dbdbecefe9411220f06da4f6af4ffd1c8c077594a12959200fbb8045370
  {
    { 0x000000ac61a73b0a, 0x000006bebd4dd72b, 0x0000000000000001, 0x000005354d296ec6, 0x0000074135b68074, 0x000004bbe06468ff, 0x0000000000000000, 0x000002c65a5ea176, },
    { 0x00000234bebe1c4d, 0x000001e442329fd9, 0x0000000000000000, 0x000005a63b16c7a3, 0x00000578f42c1e13, 0x00000009295124a5, 0x0000000000000000, 0x000006353fd670b9, },
    { 0x000007cbebe840de, 0x000007d1a93f6818, 0x0000000000000000, 0x000003cf0c14f97e, 0x000000c1f4fdd2df, 0x000000e0a60971f6, 0x0000000000000000, 0x00000042731c1942, },
  },
  },
  { // 10
  // compressed: 0x0156b7b4f9aa982772ad8d5c1372ac5e23a0b76161aaced24e7d8fe984b2bf9b
  {
    { 0x0000058a382b33f3, 0x000002f9b4b75601, 0x0000000000000001, 0x000007e9c7d96561, 0x00000281d29ed9b7, 0x00000530b0dbd011, 0x0000000000000000, 0x0000014ceca83777, },
    { 0x0000011816913ea0, 0x000001b5ae44f315, 0x0000000000000000, 0x000000f006ccacee, 0x000002232e68f93b, 0x000000f7d4ed2cea, 0x0000000000000000, 0x000000957cc65053, },
    { 0x0000016b8ae82eb5, 0x0000057ab1c84d72, 0x0000000000000000, 0x0000032cac4951cb, 0x000000b547db3b2b, 0x000000377f6509d3, 0x0000000000000000, 0x000000940fc29cbd, },
  },
  // compressed: 0x9ba477c4cd580b2417f04764deda38fdad6ac8a7328d921981a0af84ed7aafd0
  {
    { 0x000002cb980df999, 0x000000cdc477a49b, 0x0000000000000001, 0x0000060115f65be5, 0x000006ef492e3bfe, 0x0000069953e43556, 0x0000000000000000, 0x000002c085d6eb6c, },
    { 0x000005d8ee29dc82, 0x000000fe02e4816b, 0x0000000000000000, 0x00000421364dc9fb, 0x00000313402bba5e, 0x000002fa08119928, 0x0000000000000000, 0x000006bd00678020, },
    { 0x0000068c575dbcf1, 0x000007f4e36b7991, 0x0000000000000000, 0x000004a660988485, 0x0000007e1758723a, 0x000000a15ef5db09, 0x0000000000000000, 0x0000003243462d75, },
  },
  // compressed: 0x8bc1f3d99aad5ad79cc1b160ef0e6a56d90e5c25ac0b9a3ef5c762a0ec9d047b
  {
    { 0x0000077edfb870fc, 0x0000059ad9f3c18b, 0x0000000000000001, 0x0000037a35444483, 0x000000ea1b6126fb, 0x000005d612ae076c, 0x0000000000000000, 0x000002618962eec3, },
    { 0x000006d677b12845, 0x00000638339aeb55, 0x0000000000000000, 0x000005b7d27b997c, 0x0000073aeb00738f, 0x0000062c7f53e9a0, 0x0000000000000000, 0x00000150e6478600, },
    { 0x000004b0a5afad3d, 0x00000559a83bbd82, 0x0000000000000000, 0x000005d621e4cc3f, 0x000000c8b1be83c4, 0x000000f6093bd940, 0x0000000000000000, 0x000000c127b99785, },
  },
  // compressed: 0x4b038460beeede6b54b80f78b6c2993195062db6ab763397907d648bc98031ee
  {
    { 0x0000028585e0706d, 0x000006be6084034b, 0x0000000000000001, 0x000006e7a128b071, 0x00000170b8c7a29d, 0x00000355db16834a, 0x0000000000000000, 0x000007415910b098, },
    { 0x000004e72663fe73, 0x000001f70a8d7bdd, 0x0000000000000000, 0x00000511755dcf56, 0x0000027a97c43b9f, 0x00000647d9097337, 0x0000000000000000, 0x0000017bd18f7b4d, },
    { 0x000004db429762cf, 0x000004c6670ad9e0, 0x0000000000000000, 0x000002930565b64e, 0x000000afa3d41090, 0x000000dc63019316, 0x0000000000000000, 0x0000006c7d333bbb, },
  },
  // compressed: 0xc6ae4be2dc48182f60afbcba55729b7631e9ef3c6e3ccb9055b3f9c69b971f23
  {
    { 0x000003c135ee1fc4, 0x000000dce24baec6, 0x0000000000000001, 0x0000064bcc2af3c6, 0x00000400dac66998, 0x000006371e77f498, 0x0000000000000000, 0x00000004e0a7da33, },
    { 0x0000049919f2d508, 0x00000795ec05e309, 0x0000000000000000, 0x00000411a3eb863b, 0x000003a052bb42f6, 0x0000079b35590cb3, 0x0000000000000000, 0x00000792413b78d7, },
    { 0x0000025dbacd5423, 0x000005da6dc956ea, 0x0000000000000000, 0x000002c12ec0c3f8, 0x00000091dd36f0d2, 0x000000463f2f378d, 0x0000000000000000, 0x0000000f37f53610, },
  },
  // compressed: 0x4542d5a280edc9f35239f677788ba00a755408d163ac6dd76b63709415fbf41e
  {
    { 0x00000251da300df4, 0x00000580a2d54245, 0x0000000000000001, 0x000006e65b167bec, 0x00000096859ab240, 0x00000631e8842a3a, 0x0000000000000000, 0x0000079a4c0810cc, },
    { 0x0000052b561c7207, 0x000006c72a5e793d, 0x0000000000000000, 0x00000219b850a9cb, 0x00000017194ed3cf, 0x0000070636bd76da, 0x0000000000000000, 0x000000bff5672b2d, },
    { 0x00000210e5908cf6, 0x0000042a822de1df, 0x0000000000000000, 0x0000056564290a5b, 0x0000000718efed09, 0x0000003de9f62b28, 0x0000000000000000, 0x000000aebdd25494, },
  },
  // compressed: 0x01d8a40a45bc465dd8b933a52712afc3c206892b263b9e381b582f387e1e0aa0
  {
    { 0x000000908a182fcf, 0x000004450aa4d801, 0x0000000000000001, 0x00000167eaf93ac5, 0x000006aba97b99ef, 0x0000059315c48361, 0x0000000000000000, 0x000002ecab38cbfa, },
    { 0x00000113b7ba9810, 0x000006773b0ba8d7, 0x0000000000000000, 0x000004ca580a31b7, 0x0000053fd0005bab, 0x000002f581b389e3, 0x0000000000000000, 0x000001e4e38fe2b8, },
    { 0x000000c385c30a65, 0x0000030ebc489e94, 0x0000000000000000, 0x000005c6f2626c15, 0x00000087a9ce2259, 0x00000040143cfc70, 0x0000000000000000, 0x0000000a1d94a4ca, },
  },
  // compressed: 0xea68e6607639ac9797b43a15febb199b9fa7ec34b579b14c57ae31a19fc05161
  {
    { 0x000002de453f0c9c, 0x0000017660e668ea, 0x0000000000000001, 0x0000040dfdf05d96, 0x00000564f6c23d9e, 0x000004da9a7653cf, 0x0000000000000000, 0x000005c3890b8b84, },
    { 0x0000060773786863, 0x0000075692f2f587, 0x0000000000000000, 0x0000069dcf475eab, 0x0000058f4c6fcd97, 0x0000031ae574cb17, 0x0000000000000000, 0x000000f030b11b2b, },
    { 0x000007a7d4117bfd, 0x0000066c66eff854, 0x0000000000000000, 0x0000077498bb80aa, 0x000000961dcd8438, 0x000000c2a3813f42, 0x0000000000000000, 0x0000003fde49f500, },
  },
  },
  { // 11
  // compressed: 0x866b9730f5afd2220446d2c206b8908de5bae54d6c89a1dc170c34c8e65f0028
  {
    { 0x000003fb1aa73196, 0x000007f530976b86, 0x0000000000000001, 0x0000029f34528688, 0x00000584fd9d0bd9, 0x000004b626f2dd72, 0x0000000000000000, 0x000005e6b36ca59b, },
    { 0x000002ec8306faca, 0x00000248c0845a55, 0x0000000000000000, 0x0000020fb42d5df7, 0x0000048613ead200, 0x00000340c17dca18, 0x0000000000000000, 0x00000316dfaf75bb, },
    { 0x0000003e5254c0ff, 0x0000063642e01b0b, 0x0000000000000000, 0x000001706ffe5094, 0x000000a89a92525f, 0x0000005000bfcd90, 0x0000000000000000, 0x000000e5c8e5261e, },
  },
  // compressed: 0x27762ad335f6f307f066655f864daa7a5044d02897e7853c3864e00f007fee9f
  {
    { 0x0000008c9781084f, 0x00000635d32a7627, 0x0000000000000001, 0x000005da03dbf7e5, 0x0000075301f7ef01, 0x000003cb94682228, 0x0000000000000000, 0x000002e6e9254476, },
    { 0x000000a1dc24d2a4, 0x000004acde00fe7e, 0x0000000000000000, 0x00000699b7aeca60, 0x0000033a34cfd9da, 0x000006064383c85e, 0x0000000000000000, 0x000000405437b4ad, },
    { 0x000002c540a82c8d, 0x000001eaa936197d, 0x0000000000000000, 0x000002936bc92450, 0x000000b53a5d184e, 0x0000003fdcfe001f, 0x0000000000000000, 0x00000001f280a3dc, },
  },
  // compressed: 0x5397af07bb93efd7a766b73dcfd03e58c51e0b6ebf9869ce5204d45dd2ffb747
  {
    { 0x00000323c3d330b2, 0x000003bb07af9753, 0x0000000000000001, 0x0000039cbc08dd12, 0x000000b637215c1e, 0x0000045fb7058f62, 0x0000000000000000, 0x00000215ed8fe0df, },
    { 0x000000e360d1a6ad, 0x000006ecd4fafdf2, 0x0000000000000000, 0x000005d85370ff7f, 0x000006ab10db36c3, 0x00000540452ce699, 0x0000000000000000, 0x00000264bb60d572, },
    { 0x000003c8722e6ec1, 0x00000560fb433cf6, 0x0000000000000000, 0x0000062819aceb87, 0x0000000faf38fd17, 0x0000008f6fffa4bb, 0x0000000000000000, 0x000000386a4146bd, },
  },
  // compressed: 0x59c06b21406fa8cd7ed8bc121d23bb1f9009c7179e6a95b4552ed1663b0c7538
  {
    { 0x000003a6bccba34a, 0x00000740216bc059, 0x0000000000000001, 0x000001409422e51a, 0x00000300cc4171cb, 0x0000054f0be384c8, 0x0000000000000000, 0x000007f3ba267014, },
    { 0x0000070433701a4a, 0x0000079b0fd9b50d, 0x0000000000000000, 0x000003bece2d25de, 0x000000ee66f90c3b, 0x00000512e55b4956, 0x0000000000000000, 0x0000030487c21014, },
    { 0x000000f9870e84e0, 0x0000007eec8c744a, 0x0000000000000000, 0x0000072f031cf0ad, 0x000000387a0aeeba, 0x00000070ea1876cd, 0x0000000000000000, 0x0000000c43c58fa6, },
  },
  // compressed: 0xf3f0dbb09617aeb796e17ce1b9afdf54b4a3aae9713092259d2e00a19c588edd
  {
    { 0x000000cc8259838d, 0x00000796b0dbf0f3, 0x0000000000000001, 0x000005950842a94b, 0x0000041bb2ac0f18, 0x00000038f4d551da, 0x0000000000000000, 0x0000021c5da8f177, },
    { 0x000003f35b95f30c, 0x0000079c32d6f5c2, 0x0000000000000000, 0x000001e5c7d817e3, 0x0000053a5bc65264, 0x00000002e9d25923, 0x0000000000000000, 0x000001cbf860a961, },
    { 0x00000243a923071a, 0x000001537ebee785, 0x0000000000000000, 0x000006cb4f0d8d62, 0x000000000fac12f7, 0x000000bb1cb13942, 0x0000000000000000, 0x0000002b07aef078, },
  },
  // compressed: 0xc7289dcc044703908fc52cf79e671b1d26875bbe5f2be1160a58c5834e0658c9
  {
    { 0x000002ef5da27ae1, 0x00000704cc9d28c7, 0x0000000000000001, 0x000004265066e80d, 0x0000050933048b3d, 0x000005afdf2dc393, 0x0000000000000000, 0x0000053c0608897e, },
    { 0x000004e02e9d9dd4, 0x00000598b1f20068, 0x0000000000000000, 0x000007918d61a512, 0x000006d8f70c9a62, 0x0000045580a16e12, 0x0000000000000000, 0x0000043b3881b53d, },
    { 0x00000165f0e85155, 0x000000746d9e7bdc, 0x0000000000000000, 0x000007f30fde14c1, 0x0000004a54be5d03, 0x00000092b00c9d07, 0x0000000000000000, 0x0000000f382e17b0, },
  },
  // compressed: 0x56d0d5c050cdd6cd3b5703bb6d68f79a48efc3f33f72a63ccc8a7b31d7c068e7
  {
    { 0x000004e464fa6fff, 0x00000550c0d5d056, 0x0000000000000001, 0x000005e5f155c1b3, 0x0000011228dc7521, 0x0000011ff9e1f7a4, 0x0000000000000000, 0x000006ee36b59300, },
    { 0x000000bca460a0dd, 0x0000006ae779bad9, 0x0000000000000000, 0x0000076f723296c4, 0x0000049fb0035794, 0x000007b8acc3ca67, 0x0000000000000000, 0x000004d52f4c22cb, },
    { 0x000002fb8d0c7988, 0x0000026bdda1b6ec, 0x0000000000000000, 0x00000105efce9e65, 0x000000dbd80bc695, 0x000000ced181ae62, 0x0000000000000000, 0x000000a288bc29bb, },
  },
  // compressed: 0x55a4be2bab473189299107924fa2538ca7f730be48f9494b3dd44f6e0890e992
  {
    { 0x0000034b3b144951, 0x000007ab2bbea455, 0x0000000000000001, 0x000006b37fdfbb2e, 0x000004938b31c2ed, 0x000004a45f187bd3, 0x0000000000000000, 0x000003621d2dcc1f, },
    { 0x00000177966aea05, 0x000000f225312628, 0x0000000000000000, 0x0000039d5f3e2192, 0x000001295c8b8bd6, 0x000004fd43d4b49f, 0x0000000000000000, 0x000003e99afdf113, },
    { 0x000006399ffdad11, 0x000006314e893e48, 0x0000000000000000, 0x0000067e6a4d7848, 0x0000002630de63c7, 0x00000025d32010dc, 0x0000000000000000, 0x000000ef65c7e0ba, },
  },
  },
  { // 12
  // compressed: 0xa4b0dd129c6398d56b8624c0309fd1a560e4fc58032f7cd18a5e092e1595a107
  {
    { 0x000001c59c2ec4de, 0x0000039c12ddb0a4, 0x0000000000000001, 0x00000702389e5fc8, 0x0000036c8bd47c84, 0x00000781ac7e7230, 0x0000000000000000, 0x000006aee2a09321, },
    { 0x0000009e79652df5, 0x00000490cd7ab30c, 0x0000000000000000, 0x000001bc877506d1, 0x0000053255d1c770, 0x00000095e8ad17c2, 0x0000000000000000, 0x000002f0137afa1f, },
    { 0x000002f22d86fd3e, 0x00000297467cc300, 0x0000000000000000, 0x000006410cec0b3e, 0x000000c76f2bf8f5, 0x0000000f432a2a5c, 0x0000000000000000, 0x0000007d1fd07a06, },
  },
  // compressed: 0x3cd1efe88d4c70083137e0338e1ac5dfe3cd6012a55d9da5868c25a69908d622
  {
    { 0x000005b90570a294, 0x0000048de8efd13c, 0x0000000000000001, 0x000003c070cdd196, 0x00000570b0ddfec2, 0x000006d2893066f1, 0x0000000000000000, 0x000003de75a00930, },
    { 0x00000108a925f162, 0x00000406e6210e09, 0x0000000000000000, 0x000007b1534c473b, 0x000002c4007de1c5, 0x00000258c86a59d5, 0x0000000000000000, 0x00000779e5eb3884, },
    { 0x00000253c909c19c, 0x0000077f146a38cf, 0x0000000000000000, 0x00000183fa2a2db1, 0x000000eb7476f2ff, 0x00000045ac11334c, 0x0000000000000000, 0x0000001209a0f70e, },
  },
  // compressed: 0xb940f948662d32f4390c2dbd0c2f950631f981a0ad9776166c2af7baceaa4062
  {
    { 0x000007d4ddba919c, 0x0000056648f940b9, 0x0000000000000001, 0x0000049c5ba295a0, 0x00000631d6c36628, 0x000003d6d040fc98, 0x0000000000000000, 0x000005d3f3e498b5, },
    { 0x00000191b55699c3, 0x000005a1873e8645, 0x0000000000000000, 0x000006fa4b5f068e, 0x000001dde072c63c, 0x00000772a6c16769, 0x0000000000000000, 0x00000340cac66f13, },
    { 0x0000073cc76cfb1d, 0x0000041a54bc32f4, 0x0000000000000000, 0x0000035a51f16f28, 0x00000087c4287f78, 0x000000c481559d75, 0x0000000000000000, 0x000000ad7b5e471b, },
  },
  // compressed: 0xb23b9dc16cd31013b9862362b76b2a065c4fa1d791859b7c54571e7e5031aa83
  {
    { 0x000001e3f53533eb, 0x0000036cc19d3bb2, 0x0000000000000001, 0x00000648ffd4ce1f, 0x000002290ead2ab9, 0x000002c8ebd0a7ae, 0x0000000000000000, 0x000002c10e849abe, },
    { 0x00000727a806c557, 0x00000470d722621a, 0x0000000000000000, 0x00000591839e9d8e, 0x000007413189e0e1, 0x000001e57547c9b8, 0x0000000000000000, 0x000006b485988d22, },
    { 0x000000ce15a355ba, 0x00000018a9aedd88, 0x0000000000000000, 0x0000038117abc152, 0x0000003a4950db06, 0x000000075462a0fc, 0x0000000000000000, 0x0000008764c3b935, },
  },
  // compressed: 0x6413956c8b3d51197bf40b002671fe9467954fd5dd108d0264099442e2d5b482
  {
    { 0x0000061988bb79bb, 0x0000058b6c951364, 0x0000000000000001, 0x000005cb28d18df2, 0x00000771301ef519, 0x0000006eeaa7cab3, 0x0000000000000000, 0x00000249b64121c4, },
    { 0x00000746b3bcab63, 0x0000017e8f632a27, 0x0000000000000000, 0x0000059ca116942a, 0x00000276bc2b02c2, 0x00000140964028d1, 0x0000000000000000, 0x000005d3410c49cf, },
    { 0x000006827b41f705, 0x00000653f9c49800, 0x0000000000000000, 0x000007ab31191861, 0x00000064c0ab9eb6, 0x0000000569abc485, 0x0000000000000000, 0x0000004f4d90135c, },
  },
  // compressed: 0x54693dc40a272ccdb2ca666a573e4add6c03d7692459fa7999258c3d60031522
  {
    { 0x000003cd1f0db188, 0x0000070ac43d6954, 0x0000000000000001, 0x000005f9390be1d0, 0x000007d18afaac2d, 0x0000049234eb81b6, 0x0000000000000000, 0x000006333d4a787a, },
    { 0x0000034b7d1174dd, 0x000004d95659a584, 0x0000000000000000, 0x0000019c7e2b3dd9, 0x0000060a17ef22ed, 0x000000c259979fa5, 0x0000000000000000, 0x0000010f43682891, },
    { 0x000000df4f5ce99d, 0x0000037528f95da9, 0x0000000000000000, 0x000002a5088111ca, 0x000000596ce2e9fe, 0x000000442a06c07b, 0x0000000000000000, 0x000000f63be96e71, },
  },
  // compressed: 0x8cf5f80718222e5fd40994d49f5c55e330a6b61f8da8aab23de052d345826968
  {
    { 0x000002e0b3b2a224, 0x0000021807f8f58c, 0x0000000000000001, 0x000005852a18187a, 0x000007f106bfbd87, 0x000004468fdb5318, 0x0000000000000000, 0x0000014087fb6241, },
    { 0x000002a22c1c925e, 0x000002813a8be5c4, 0x0000000000000000, 0x000003b59afb762b, 0x000007c599215eb8, 0x0000052e03db2aaa, 0x0000000000000000, 0x000002f01cf44bae, },
    { 0x000001f1b27818ad, 0x0000038d55727f52, 0x0000000000000000, 0x000003cf92ab4e1b, 0x000000c3f9de4cb1, 0x000000d0d3048ba6, 0x0000000000000000, 0x0000008d9e988e7b, },
  },
  // compressed: 0x408149f1a76e3c2154482b39f87e1e7cbace29568cc38824bbc58c0de5aa6590
  {
    { 0x000005ed9ec4e5f9, 0x000006a7f1498140, 0x0000000000000001, 0x00000525df200d57, 0x000003f965f2e56e, 0x000001c62b14e75d, 0x0000000000000000, 0x000003d8f0c1a018, },
    { 0x0000020660684ca4, 0x000005690a84278d, 0x0000000000000000, 0x0000014ce9438588, 0x000006b5f4072b1a, 0x000000cc5bb2488c, 0x0000000000000000, 0x000001ce7160a07e, },
    { 0x000000397b68045a, 0x000001f079fbe0e4, 0x0000000000000000, 0x00000170ecb75aff, 0x0000005270f79a29, 0x00000020cb55ca1b, 0x0000000000000000, 0x000000d34331cc9e, },
  },
  },
  { // 13
  // compressed: 0xedcac5dc344401e133fb843c965ded47e7a086ed76950170e4f967d27b69b225
  {
    { 0x000002e0d91a78bc, 0x00000434dcc5caed, 0x0000000000000001, 0x000007fb13986864, 0x000005332028385c, 0x000002bb76c35073, 0x0000000000000000, 0x0000061def939daf, },
    { 0x00000212ccf20c56, 0x0000009f667c2028, 0x0000000000000000, 0x000003b8f713ace7, 0x0000013a1bf9df54, 0x0000067f9e470019, 0x0000000000000000, 0x000004e4cd2e04ec, },
    { 0x0000011f26227321, 0x0000051fb57658f2, 0x0000000000000000, 0x000000f297ef6505, 0x000000e6d3cd5249, 0x0000004b64d2f7a4, 0x0000000000000000, 0x0000002840d07b6a, },
  },
  // compressed: 0xd05accc16fbbee348bac4696e90c1b6a53de6ba649dab0d3c181d061413be8b1
  {
    { 0x0000051e249dd197, 0x0000036fc1cc5ad0, 0x0000000000000001, 0x000007129e062b4f, 0x00000197e65d562e, 0x00000524d335ef29, 0x0000000000000000, 0x000000a5b78c341f, },
    { 0x0000031820568f17, 0x000000d591669dd7, 0x0000000000000000, 0x000006415b12fd18, 0x0000008a72dfb02d, 0x000005081c1d3b0d, 0x0000000000000000, 0x000005503175bece, },
    { 0x0000018830d40179, 0x000005a86c33a659, 0x0000000000000000, 0x00000527923d3ca4, 0x000000c16c77d7ea, 0x00000063d07682c3, 0x0000000000000000, 0x000000ab9e3d6c5a, },
  },
  // compressed: 0x528cf57de3b5763036cc99e7ddb93ad720ee1349e31c83bd3301ba62aafb561a
  {
    { 0x0000001065c23d58, 0x000005e37df58c52, 0x0000000000000001, 0x000003505c9dc9ec, 0x000007d48962afd3, 0x00000671a489f710, 0x0000000000000000, 0x0000072b209a3b28, },
    { 0x00000290338b0f22, 0x0000033986c60ed6, 0x0000000000000000, 0x00000786e35287cd, 0x000000891d4e2402, 0x000003a0133bd831, 0x0000000000000000, 0x00000458a5c9873a, },
    { 0x0000062e7421b542, 0x0000035ceae7779e, 0x0000000000000000, 0x000004c0955eee9d, 0x000000cd34cac8ae, 0x00000034adf754c5, 0x0000000000000000, 0x000000278906cf33, },
  },
  // compressed: 0x80d08b5d6afbdcc442481a57ecc4ebde6553e5b883e8b2d427b8e5c87dc8bdd0
  {
    { 0x000005465ab3e1b9, 0x0000036a5d8bd080, 0x0000000000000001, 0x000007836edfe111, 0x00000332765adcdb, 0x00000441dc72a9b2, 0x0000000000000000, 0x0000056192db9dcb, },
    { 0x00000627ec28474b, 0x0000034908589b9f, 0x0000000000000000, 0x000002357b2c0da6, 0x0000037b60719f83, 0x0000065b827d4b2e, 0x0000000000000000, 0x000005fd5ae64b03, },
    { 0x000003f04f061f1f, 0x0000077baf13b15c, 0x0000000000000000, 0x000000c8d4f857c0, 0x000000cdf019274c, 0x000000a17b90fb91, 0x0000000000000000, 0x0000003baac888e4, },
  },
  // compressed: 0x9ac8ba0800e697c2e0c3e1ea11ea4c7d7c97e79fe18be3f3cd05a3630f453aba
  {
    { 0x000007f83362127d, 0x0000060008bac89a, 0x0000000000000001, 0x00000731d8394627, 0x000002a1a4910645, 0x000005f0cff3cbbe, 0x0000000000000000, 0x000006368bccb7c0, },
    { 0x000001af82b1f48f, 0x000004387c1852fc, 0x0000000000000000, 0x00000294a200f1e5, 0x000001f732e6e714, 0x000002305cdf3e38, 0x0000000000000000, 0x0000029a87bd1e36, },
    { 0x000006f27dab11c7, 0x000001f533a847ab, 0x0000000000000000, 0x000000e274c60f7a, 0x0000001cc8b22443, 0x00000074748a1ec7, 0x0000000000000000, 0x00000063191b2727, },
  },
  // compressed: 0x98d31dab299e665d3b9e2d34581692fccd7359f3fd1d8555f60a9525c3419ad0
  {
    { 0x000005032afffe19, 0x00000629ab1dd398, 0x0000000000000001, 0x000006dca6f925e9, 0x000001f1dd42cc77, 0x000006fef9acb9e6, 0x0000000000000000, 0x000001404ec19f44, },
    { 0x0000049b6cde4e8b, 0x000005b3c76bacd3, 0x0000000000000000, 0x00000363e677b80d, 0x000001d5314bc98d, 0x00000150af655851, 0x0000000000000000, 0x0000021138982ec1, },
    { 0x000004327cf125fc, 0x000007f2485960d0, 0x0000000000000000, 0x000005e4fbcfd190, 0x0000004498f8cf34, 0x000000a13483864b, 0x0000000000000000, 0x0000000b7fe04651, },
  },
  // compressed: 0xe412c50ddda08168fefaa544c80de74f40524a8f6b8e741feaa301eecd7762d7
  {
    { 0x0000037023cae00b, 0x000000dd0dc512e4, 0x0000000000000001, 0x000002bc234f305f, 0x00000024e90d0e44, 0x00000735c7a52920, 0x0000000000000000, 0x0000028a1a731506, },
    { 0x00000599eb26c642, 0x000004bf5fcd1034, 0x0000000000000000, 0x000000bbc103de71, 0x000002a44a796741, 0x0000001a3ea1f748, 0x0000000000000000, 0x0000071b7a15e82a, },
    { 0x000001512b3c2b46, 0x0000013f9c372112, 0x0000000000000000, 0x000006695dfef450, 0x000000f0171987f4, 0x000000aec4ef9bdc, 0x0000000000000000, 0x000000bfe830e4c4, },
  },
  // compressed: 0x4095b613e847dbe5e11026433b2a5df376127838e9261fac69cba0a08cdbd4a9
  {
    { 0x0000000c1789db9d, 0x000007e813b69540, 0x0000000000000001, 0x000002af333353d0, 0x000004a6035e81ae, 0x000003749c3c093b, 0x0000000000000000, 0x000002c564447bf8, },
    { 0x000004ef1ea731c1, 0x000004c21c3cbb68, 0x0000000000000000, 0x000002613cbb35a1, 0x000002966befa988, 0x0000020cb69ac1f2, 0x0000000000000000, 0x000002cbefa3c576, },
    { 0x0000069d808097cf, 0x000003cd74a8ed0c, 0x0000000000000000, 0x000000e19a7696b3, 0x00000020d407b84b, 0x00000053a9b71941, 0x0000000000000000, 0x000000956714a20a, },
  },
  },
  { // 14
  // compressed: 0x9cc0dd5fefd1cfd6ce5d57f7fd3e2be8c23416205d6bd5259b2bed04bbc641b0
  {
    { 0x000003256768d593, 0x000001ef5fddc09c, 0x0000000000000001, 0x000002f9d956e148, 0x000005eae505670e, 0x000005ae900b1a61, 0x0000000000000000, 0x0000045dafb6012e, },
    { 0x00000459427b4f85, 0x000002ebb9dad9fa, 0x0000000000000000, 0x000006ad65c1fe5e, 0x0000008a690f1a80, 0x000006d2b9b25d56, 0x0000000000000000, 0x00000049a7b1a469, },
    { 0x0000066307015d10, 0x000003a0acfbf7dd, 0x0000000000000000, 0x000002b79e5dd67c, 0x000000539ba35b81, 0x00000060838d7609, 0x0000000000000000, 0x00000020977ad028, },
  },
  // compressed: 0x63f17fd65f9a5da98156c74c9de62be957f220de4c02f8b7f52d07fb202a4fa0
  {
    { 0x0000053168f1ed67, 0x0000025fd67ff163, 0x0000000000000001, 0x0000033d30ebb079, 0x000006218269796f, 0x000001266f10792b, 0x0000000000000000, 0x00000618c7b6ae18, },
    { 0x000005e7784a3e1f, 0x000000ead0352bb3, 0x0000000000000000, 0x000004a5c6190287, 0x000002a714944dc5, 0x00000072df5b7f80, 0x0000000000000000, 0x0000079161f653c3, },
    { 0x000000b204773761, 0x000007a4af9a7533, 0x0000000000000000, 0x000005d624556af5, 0x000000b7d198ae12, 0x000000409e5441f6, 0x0000000000000000, 0x0000004ae1f62f84, },
  },
  // compressed: 0x5a24b80b55a92e19d150908fa8fbe6c835c9a4882dea8679688601de915f1ca4
  {
    { 0x0000067f2cb61575, 0x000001550bb8245a, 0x0000000000000001, 0x0000072940de6caa, 0x0000021532da92b1, 0x00000516c452649a, 0x0000000000000000, 0x0000066e91ad80e8, },
    { 0x000002c04d87df46, 0x0000020a1a2325d5, 0x0000000000000000, 0x0000032e67451b02, 0x00000030acde8c71, 0x000000186687986e, 0x0000000000000000, 0x000004df0e516d7f, },
    { 0x000003d7e5bdd873, 0x000007239beea23e, 0x0000000000000000, 0x0000063efcb3c08b, 0x0000007b96cbd4a6, 0x0000004838bf23bc, 0x0000000000000000, 0x00000010841dbabf, },
  },
  // compressed: 0xce10f4044ec3580385066e275a5b13b62115b9ebc770965d9c88db21f354d604
  {
    { 0x000000ab8362fa4a, 0x0000034e04f410ce, 0x0000000000000001, 0x00000116ddbdb5d5, 0x0000030bfe1cf315, 0x00000063f5dc8a90, 0x0000000000000000, 0x0000040b999a5149, },
    { 0x00000347cdd9bfe4, 0x000005c0d0a06b18, 0x0000000000000000, 0x000004bba5abcfb8, 0x000001769fde3179, 0x000005b889c5d967, 0x0000000000000000, 0x00000191ad71cb60, },
    { 0x0000055f84635388, 0x000006d84d6d689d, 0x0000000000000000, 0x000000a5537ada36, 0x0000001b34a7df78, 0x00000009aca9e643, 0x0000000000000000, 0x00000094f49e4c31, },
  },
  // compressed: 0x4b2a37af91b2c324f24781717082da93f29e8986648584dd33eee023423196ca
  {
    { 0x000000025fb15f95, 0x00000291af372a4b, 0x0000000000000001, 0x0000074408a4ffd6, 0x0000004280700889, 0x000002b24344cf79, 0x0000000000000000, 0x0000045b1e8159f9, },
    { 0x0000038371fe94e3, 0x00000028fe449876, 0x0000000000000000, 0x000002aedb34dd04, 0x00000531848cdfcf, 0x0000060ee33dd848, 0x0000000000000000, 0x000006bcc5177334, },
    { 0x000000f7d97cd1ad, 0x0000024f6a09c1c6, 0x0000000000000000, 0x000001ce385dfa70, 0x000000236a1899bb, 0x000000952c628447, 0x0000000000000000, 0x0000009e979c9b9c, },
  },
  // compressed: 0x6f0b9dc46e61e2301723ecca8f7156e4a64f6bf29b40eb48375f5961e5ce4230
  {
    { 0x0000065ae2242584, 0x0000016ec49d0b6f, 0x0000000000000001, 0x00000079449bac41, 0x000004eb8e751e7a, 0x0000004df935a7d3, 0x0000000000000000, 0x00000310afc20d3e, },
    { 0x000006b153d4e3f9, 0x0000058462e61c4c, 0x0000000000000000, 0x0000044621484fce, 0x000001c01e6d21a0, 0x00000595f3748eb4, 0x0000000000000000, 0x000001ce1d64cae7, },
    { 0x0000009ba9c95a4b, 0x0000039159c63f2b, 0x0000000000000000, 0x000002156b8db6f3, 0x000000e7f9ba296e, 0x00000060859dcac2, 0x0000000000000000, 0x000000713ce81935, },
  },
  // compressed: 0x28ac0e57f678bdc9e19c9127320b5be5ed919ba1ab3efc65903626d6e525c425
  {
    { 0x000003ae34dcb9ce, 0x000000f6570eac28, 0x0000000000000001, 0x000006a6f1d7de6e, 0x0000003eb1631c0d, 0x00000755d0cdc8f6, 0x0000000000000000, 0x000003132745363b, },
    { 0x0000011a15ac9f96, 0x000002339c3937af, 0x0000000000000000, 0x000000c46107e7c0, 0x000005a678845b3f, 0x0000026369065fc3, 0x0000000000000000, 0x000004847598c14f, },
    { 0x0000065d400c8f8d, 0x000007956c2cc89e, 0x0000000000000000, 0x000004fbe5d89e38, 0x000000c2a8a6f28c, 0x0000004b884bcbac, 0x0000000000000000, 0x000000ca7341122a, },
  },
  // compressed: 0x194abb14d4dbc4dd8e4f42983cbcb2196971ca36d79fa84890bd19f00e32658f
  {
    { 0x00000774c3d2f773, 0x000003d414bb4a19, 0x0000000000000001, 0x000001b1cafde0c6, 0x000006747cdccf19, 0x000007eb9b6538b4, 0x0000000000000000, 0x00000786fd7949cd, },
    { 0x0000008d08bd3a43, 0x00000049f1dbb89b, 0x0000000000000000, 0x0000076a303a90da, 0x000004d186c624e5, 0x0000019bd9048a89, 0x0000000000000000, 0x0000033072a59a8a, },
    { 0x0000070541510497, 0x00000466caf0f261, 0x0000000000000000, 0x0000013cff9b8c58, 0x000000238bc9558b, 0x0000001eca641de0, 0x0000000000000000, 0x00000099578f7bd8, },
  },
  },
  { // 15
  // compressed: 0x89d2783f8f788fc09f4d40a12ca730fe9dcc65cffc8b77f22120cb5a1698e47e
  {
    { 0x00000624089c0a2e, 0x0000008f3f78d289, 0x0000000000000001, 0x000000e39111a1c3, 0x000006953b27d095, 0x000005fe67b2e64e, 0x0000000000000000, 0x0000076157397e8c, },
    { 0x000007c8e70473d2, 0x00000009b3f811ef, 0x0000000000000000, 0x0000020e912f7aa1, 0x000001c858217dbe, 0x000004b2021f2778, 0x0000000000000000, 0x000003602a6e7d2a, },
    { 0x0000031d231300eb, 0x000007f8c29cb285, 0x0000000000000000, 0x000004acae435202, 0x000000c73727e064, 0x000000fdc9302cb5, 0x0000000000000000, 0x0000001dbe92790b, },
  },
  // compressed: 0x13417684d2c4676735f8f5f73f4090a0debee6cafacf8f1c69a3dfd1540cc004
  {
    { 0x00000158599b5a68, 0x000004d284764113, 0x0000000000000001, 0x000007818b465cf8, 0x000006ba115b3f83, 0x000007fd65735f6f, 0x0000000000000000, 0x000007d68263eb2b, },
    { 0x000005bc41d5d990, 0x000006bf06acecf8, 0x0000000000000000, 0x0000001dff09b845, 0x000001d4fb44fe41, 0x000005fa3691c8fc, 0x0000000000000000, 0x000006176f4aee8b, },
    { 0x000007a95d3c3fae, 0x000002824100ffdf, 0x0000000000000000, 0x000005c683cd6852, 0x000000807725c603, 0x000000098018a9a3, 0x0000000000000000, 0x0000006ab7625564, },
  },
  // compressed: 0x18738c5ac7da01a311aaceb39d0390ed2d3fae3bbf7c076f8ead52e0f8ea1875
  {
    { 0x000004cc7493bbf4, 0x000002c75a8c7318, 0x0000000000000001, 0x000001c41b7f6c32, 0x000002867d02f3c2, 0x0000065f9dd71f96, 0x0000000000000000, 0x00000494e4d8e8ec, },
    { 0x000004761874e3cc, 0x000001d54234603b, 0x0000000000000000, 0x000007065314910b, 0x000002ec3120a6bc, 0x0000052ad8e6f077, 0x0000000000000000, 0x000001755c41815a, },
    { 0x00000796f61367b2, 0x000007b6400e76cf, 0x0000000000000000, 0x0000043cb582f3d0, 0x0000001f37026430, 0x000000ea31d5f1c0, 0x0000000000000000, 0x0000008f870e3776, },
  },
  // compressed: 0xb06650c8505de6fbb099a2b3b0c4ec62e0e81a44ea5437e55f8dd4e82ca0fe08
  {
    { 0x0000039771ec4f48, 0x00000550c85066b0, 0x0000000000000001, 0x0000057668deead0, 0x0000008d23e1e335, 0x00000275220d7470, 0x0000000000000000, 0x000007e6aec4eb32, },
    { 0x0000018badca288a, 0x00000453361f7ccb, 0x0000000000000000, 0x0000050ba47049bb, 0x000004699dcf762c, 0x00000548d5fe5375, 0x0000000000000000, 0x0000075d537b514c, },
    { 0x000007e016c5f726, 0x0000018bb312c2ce, 0x0000000000000000, 0x000007219114812d, 0x0000000171370aec, 0x00000011fd4059d1, 0x0000000000000000, 0x0000008e70534e9e, },
  },
  // compressed: 0xc90239ad3a53d9238f5803efceddc264b42fe1cf9073251590d3e4444d8b666c
  {
    { 0x000002754679c418, 0x0000033aad3902c9, 0x0000000000000001, 0x000007217a78820c, 0x000007925623f585, 0x000001c867f097da, 0x0000000000000000, 0x000002d3c64776bd, },
    { 0x00000431be105a5b, 0x0000006b11e47b2a, 0x0000000000000000, 0x000004e7d2e76919, 0x0000033c6b4355ee, 0x0000064d39015257, 0x0000000000000000, 0x000000a433fa96c6, },
    { 0x00000398ef5f62c9, 0x000001930b773bbc, 0x0000000000000000, 0x000007dda82aca04, 0x00000040f0d09890, 0x000000d8cd169a89, 0x0000000000000000, 0x000000e8234c0a9f, },
  },
  // compressed: 0xb475b1183de59a5702a192f359317168f535ef1ebaec55848f398c4572a8c99e
  {
    { 0x00000532b99dc86d, 0x0000053d18b175b4, 0x0000000000000001, 0x000004d400a2509b, 0x000000966e617244, 0x0000065d0f779afa, 0x0000000000000000, 0x0000064df8cabab0, },
    { 0x0000075e22a9acb3, 0x00000254204af35c, 0x0000000000000000, 0x0000011056971cd4, 0x000000134ffb34c7, 0x000000c398f8455e, 0x0000000000000000, 0x000004d646057e7c, },
    { 0x000000113371d580, 0x000005a1c4c567ce, 0x0000000000000000, 0x0000066e075c082f, 0x000000f826cae9f7, 0x0000003d9350e48b, 0x0000000000000000, 0x00000075bb114b8f, },
  },
  // compressed: 0x46303959d498c285ec59f65f98357e8f3a6ef6f22aa22c1d20a706a43111ba61
  {
    { 0x00000770b635dcf2, 0x000000d459393046, 0x0000000000000001, 0x000000f116959029, 0x000001345f5b68c3, 0x00000115797b371d, 0x0000000000000000, 0x0000051f133c1983, },
    { 0x00000583f795712a, 0x000006cb3d90b853, 0x0000000000000000, 0x000007d7b1347a14, 0x00000079e7485530, 0x0000006a7201d2ca, 0x0000000000000000, 0x0000058ece77bf15, },
    { 0x0000040b7fbdb3d9, 0x0000023df8d6617f, 0x0000000000000000, 0x00000408edadb2e9, 0x000000493253f999, 0x000000c374226348, 0x0000000000000000, 0x000000ac40621977, },
  },
  // compressed: 0xd685e277f4b5466693618f6c67ffe840dd94b5ab1173eca64dec8c65f346c8fe
  {
    { 0x000003434934d643, 0x000005f477e285d6, 0x0000000000000001, 0x0000073f1da22ec7, 0x000003c7e1fa0e11, 0x00000188d5daca6e, 0x0000000000000000, 0x000007e7d14c4fdc, },
    { 0x000002445eaa5132, 0x000001ec326cc8d6, 0x0000000000000000, 0x00000039a2736bd1, 0x000001d97308f6d8, 0x000000cec4da6ec7, 0x0000000000000000, 0x000001b9dd5214c8, },
    { 0x000002e76fe01a94, 0x00000503a3fd9db2, 0x0000000000000000, 0x0000004c3c75ddb0, 0x0000006eced4549b, 0x000000fd908de6cb, 0x0000000000000000, 0x000000db55ee4673, },
  },
  },
  { // 16
  // compressed: 0xa28eadacbf043b5884e88b14e843b729dbc510083b581e2baabbb38ee54954ab
  {
    { 0x00000562eb3dbe47, 0x000004bfacad8ea2, 0x0000000000000001, 0x000004d26adc9cfe, 0x00000298a2ba394c, 0x0000041d840862ed, 0x0000000000000000, 0x000000fffcbce305, },
    { 0x000007b4170be74e, 0x0000017d108b0760, 0x0000000000000000, 0x0000011ba16f1302, 0x0000027d55100c3e, 0x0000033bbaa2b1e5, 0x0000000000000000, 0x000002dd693da0fe, },
    { 0x000007dfa8e1523a, 0x000004a6dd0fa052, 0x0000000000000000, 0x000000f06eacfe2d, 0x0000002609d3ce2c, 0x00000056a893cb1d, 0x0000000000000000, 0x00000088d1bc5af8, },
  },
  // compressed: 0xce0763f8c6d89a4b280c5d43313511212c777a65c566a8d4527324637e42a65d
  {
    { 0x0000055e9419469e, 0x000000c6f86307ce, 0x0000000000000001, 0x00000688deac22ca, 0x0000036b223fccb1, 0x00000362b2bd3b96, 0x0000000000000000, 0x0000061c46acac07, },
    { 0x000003b8ea8a3766, 0x000003a18509735b, 0x0000000000000000, 0x000005c3ff035298, 0x0000044bd6393a5b, 0x00000247352d4a86, 0x0000000000000000, 0x000001f2ca888ad8, },
    { 0x000000cf9b71308f, 0x0000008444d4c50d, 0x0000000000000000, 0x000006e419bbdeee, 0x000000d99cf8dff6, 0x000000bb4c84fcc6, 0x0000000000000000, 0x000000b1e5357fcf, },
  },
  // compressed: 0xf6cd0e71bf645a4b3c292c4638e54cb1b93a0bd556d0433670485b182437f96a
  {
    { 0x000007ab8de73e68, 0x000004bf710ecdf6, 0x0000000000000001, 0x0000024509c6a888, 0x00000585df00acc1, 0x0000002b6a859d5c, 0x0000000000000000, 0x000003119e19944f, },
    { 0x000007ced4bd21d9, 0x0000058527896b4c, 0x0000000000000000, 0x000002b12e664400, 0x00000741e36f0495, 0x000005b48703643d, 0x0000000000000000, 0x000002ec18f83e23, },
    { 0x000001500dbe7cdd, 0x000006c53394e118, 0x0000000000000000, 0x0000074b80d84d2d, 0x000000aeec53894f, 0x000000d5f26e4830, 0x0000000000000000, 0x000000e03e4b7619, },
  },
  // compressed: 0x13c1be7cd9f6189de4dbbf74e6064a84d6604eac22b5f520515e9550c05b0af2
  {
    { 0x000000f8e4616ced, 0x000006d97cbec113, 0x0000000000000001, 0x000001439b805a35, 0x0000030ffa5e52ce, 0x000002915627306b, 0x0000000000000000, 0x000003f9ae1149a3, },
    { 0x000004b50fb87516, 0x000007fb7c93a31e, 0x0000000000000000, 0x000000557f8187e1, 0x00000440be961e30, 0x00000155e5120f5b, 0x0000000000000000, 0x000004ef0ec69141, },
    { 0x000003dc01983a78, 0x00000211281b99d2, 0x0000000000000000, 0x000003a13a2cdd89, 0x0000005c19257f7b, 0x000000e414b780a1, 0x0000000000000000, 0x0000001d37397628, },
  },
  // compressed: 0xeebeb15dd59bee8db93f720a37abc3c991d7681cbff1a844de3cfd1c19446db6
  {
    { 0x0000048ffb5720ad, 0x000003d55db1beee, 0x0000000000000001, 0x00000743f2bc8c14, 0x000000a931aaa1df, 0x000000df8e346bc8, 0x0000000000000000, 0x000007873453fdcb, },
    { 0x00000721a1df775a, 0x00000647f731bdd3, 0x0000000000000000, 0x000000ad8773c782, 0x00000337bd8d4813, 0x000007d3cde44a8f, 0x0000000000000000, 0x00000593244ccb82, },
    { 0x000007ba0645af6f, 0x000007270eacdc29, 0x0000000000000000, 0x000004bb689bf2d6, 0x000000442209d67e, 0x0000006cda883239, 0x0000000000000000, 0x00000082cf49cd78, },
  },
  // compressed: 0xee8fcef86526bec22cd680e814ff67e9ee4e362f7e6e2ef1f6d27ecb7033b334
  {
    { 0x0000052876f62700, 0x00000665f8ce8fee, 0x0000000000000001, 0x000001ee8681d6cc, 0x0000018190fe0342, 0x0000073f179b2777, 0x0000000000000000, 0x000002e0ac404441, },
    { 0x000006cd1d6c8773, 0x0000001ac59857c4, 0x0000000000000000, 0x000000b4ea79b8b2, 0x0000055246a1b4b4, 0x000007ed2f6f12e6, 0x0000000000000000, 0x000007e65e4ed748, },
    { 0x0000017476750039, 0x000003a59ffc53a2, 0x0000000000000000, 0x00000738084273b6, 0x000000f27176fc44, 0x000000696666e196, 0x0000000000000000, 0x00000022edf8dc5b, },
  },
  // compressed: 0xb80e774989e290dba340f4ac2accfb989b87d7defe4f3521b60669f2543e6a9f
  {
    { 0x000004d05b9c619b, 0x0000028949770eb8, 0x0000000000000001, 0x00000199d30734ea, 0x0000028175f4a6e2, 0x000007ff6f6bc3cd, 0x0000000000000000, 0x00000711fbacc14a, },
    { 0x000004b0901695ed, 0x00000688147b721c, 0x0000000000000000, 0x000002cb9acc1498, 0x000007d5f343d4fa, 0x000006906b621354, 0x0000000000000000, 0x000003900d1e2333, },
    { 0x000000b77f27d2ca, 0x00000663ef30aab3, 0x0000000000000000, 0x000005030216d8c4, 0x00000011f87498ce, 0x0000003ed47ca9e4, 0x0000000000000000, 0x0000009e5f5a022d, },
  },
  // compressed: 0x38b63bb71dd92c96089c12fcaa7705e68916b6f3399b616f81ee44295f995134
  {
    { 0x0000024194ae4e54, 0x0000011db73bb638, 0x0000000000000001, 0x000004d09fea7d7c, 0x000005969b46824c, 0x0000059cf9db0b44, 0x0000000000000000, 0x0000055523942e20, },
    { 0x000002fded8897d6, 0x000002538112c59b, 0x0000000000000000, 0x0000026b9ed22a5f, 0x000002ef7aba61e6, 0x0000044ee816f619, 0x0000000000000000, 0x000002893b7258e9, },
    { 0x0000017d50714461, 0x0000079815deabf0, 0x0000000000000000, 0x0000012a05b252c2, 0x00000088a909492e, 0x00000068a332be52, 0x0000000000000000, 0x0000002171394c08, },
  },
  },
  { // 17
  // compressed: 0x6ef0455abe413975655f9c6dedae7cd0b651ff729c6b7711a94d0defd9d1d217
  {
    { 0x000007499718289c, 0x000001be5a45f06e, 0x0000000000000001, 0x00000718073f3e6a, 0x000007e58a61f78a, 0x000005ce397fa8db, 0x0000000000000000, 0x000003961e530011, },
    { 0x00000267e4c7ab28, 0x0000038becaea728, 0x0000000000000000, 0x000002420d24fe55, 0x0000037518e0262b, 0x000000d4da911776, 0x0000000000000000, 0x0000065c6a722e3b, },
    { 0x0000044bafe31491, 0x00000341f2bbb5b6, 0x0000000000000000, 0x000003f4ff94675d, 0x0000004170f1aaef, 0x0000002fa5a3b3de, 0x0000000000000000, 0x000000e4429ec798, },
  },
  // compressed: 0xc9293bf4b9b79d1d758f514f4a8205d6c49d2f31bd72c0f2b045155a85ac249f
  {
    { 0x000007405307a693, 0x000007b9f43b29c9, 0x0000000000000001, 0x000000328e9505aa, 0x00000053b9bb084c, 0x0000015e9897cee2, 0x0000000000000000, 0x0000022e037d92d1, },
    { 0x0000066cf2b69c6f, 0x00000231eea3b3b6, 0x0000000000000000, 0x000002841dc49ac1, 0x0000071cbc9d6fbd, 0x000001545b0f2c07, 0x0000000000000000, 0x000006395e6c7ffe, },
    { 0x000006ae9c535cbc, 0x000003581609293d, 0x0000000000000000, 0x0000011d23074430, 0x000000bfbe918b02, 0x0000003e49590ab4, 0x0000000000000000, 0x0000000174e73c55, },
  },
  // compressed: 0x26bb88eaf52644aefb3b9784d9790636504e69260c039f5c26d218d5e77d2972
  {
    { 0x000000de5c8790d6, 0x000006f5ea88bb26, 0x0000000000000001, 0x000005c7be0cb939, 0x000005b07cda4c91, 0x000001861334a728, 0x0000000000000000, 0x0000048681144984, },
    { 0x000000545beb25d3, 0x000002e77f75c884, 0x0000000000000000, 0x0000046610090483, 0x000002d78f3115a3, 0x0000018d2265c9f0, 0x0000000000000000, 0x00000271945d3dfc, },
    { 0x00000396fedf4d17, 0x000000d819e76612, 0x0000000000000000, 0x000000cbc66d362d, 0x0000000650747ccf, 0x000000e452fbcfaa, 0x0000000000000000, 0x0000000bc252d08c, },
  },
  // compressed: 0x50452c24c8bbbfadd98130d0ec0cc8bc92dfc8f5a66635844cce5882d325cf78
  {
    { 0x000006b32d9c495a, 0x000003c8242c4550, 0x0000000000000001, 0x0000038e31489d68, 0x000005d749dae8f0, 0x000003537ae46fc9, 0x0000000000000000, 0x0000054bf8277d02, },
    { 0x000005772f97505d, 0x000006103b35b7f7, 0x0000000000000000, 0x0000057e10e2b5cd, 0x00000698d9bb02da, 0x0000058ce4c84356, 0x0000000000000000, 0x000003ff832c9a75, },
    { 0x0000033bbf23f3c4, 0x000002f32033b340, 0x0000000000000000, 0x000006aa1472ae70, 0x0000007380193826, 0x000000f19e4ba704, 0x0000000000000000, 0x00000000d6a40ed6, },
  },
  // compressed: 0x2d08ceb9167ecbf529bc7a414cf10734aba7f42bce6bb3d4ce759f1a56e9e27d
  {
    { 0x000007e19d95781c, 0x00000616b9ce082d, 0x0000000000000001, 0x000004f4b6a55ecb, 0x000004e9b828b59c, 0x000005e715fa53d5, 0x0000000000000000, 0x0000022069f74d40, },
    { 0x000004621c453c19, 0x00000757853eb96f, 0x0000000000000000, 0x000000bb733bce1a, 0x0000047612257df3, 0x000001f75ced4b36, 0x0000000000000000, 0x000006029eddbc9c, },
    { 0x000006da077c6259, 0x000004d01fc53105, 0x0000000000000000, 0x000005200549fd76, 0x0000009aafc68877, 0x000000fbc5d2ac35, 0x0000000000000000, 0x000000d655215e34, },
  },
  // compressed: 0x0ad8b25b24f3eb779b07b92f471b30d83373ee4cf2e647c609216c27c81258c6
  {
    { 0x000004fc9ae61e97, 0x000003245bb2d80a, 0x0000000000000001, 0x000006b22a1062d9, 0x00000721f376e896, 0x0000037926773999, 0x0000000000000000, 0x0000053def14b46b, },
    { 0x000007ebfa2d247e, 0x00000720f36efd7e, 0x0000000000000000, 0x0000063b82c9a877, 0x000002d3e4aa764a, 0x000006c2109c647e, 0x0000000000000000, 0x00000316790180d4, },
    { 0x0000055cd4a07780, 0x00000760c06d1cbe, 0x0000000000000000, 0x000005c197edd4e0, 0x000000bfb1e9d3a2, 0x0000008cb025904e, 0x0000000000000000, 0x0000000b66585639, },
  },
  // compressed: 0x9581d57a2ca4fcf7ccf333436e2814329d970b340d9dc2b6e1077356481a77b1
  {
    { 0x000006ccd24da8fd, 0x0000042c7ad58195, 0x0000000000000001, 0x00000524e14dd482, 0x000007f93efce6b0, 0x000006869a05cbce, 0x0000000000000000, 0x000000241415ad79, },
    { 0x000003fdf079180b, 0x0000067e799eff94, 0x0000000000000000, 0x0000057496c65618, 0x00000471e99dbbee, 0x000007307e1b6c29, 0x0000000000000000, 0x000007336eba3d16, },
    { 0x000006873c6ab017, 0x000004c850a1b90c, 0x0000000000000000, 0x000007b6cd455068, 0x00000076aaad46f6, 0x00000062ee3490ac, 0x0000000000000000, 0x0000009f80f3a4f4, },
  },
  // compressed: 0x0dc5860c448b34dc51e694ccc9cb3713b93c3e644df7226408cde3bac27011a4
  {
    { 0x000000b089bf2f7f, 0x000003440c86c50d, 0x0000000000000001, 0x000003860ac473b4, 0x0000004e3c407229, 0x000003a6b21f1e5c, 0x0000000000000000, 0x0000003075e36257, },
    { 0x000003fd34ea3927, 0x0000029cca3b8691, 0x0000000000000000, 0x0000027c86a7ff35, 0x00000798e92ffffc, 0x0000063cd086422f, 0x0000000000000000, 0x0000007000d4ae75, },
    { 0x000004925ef5940b, 0x0000044cdf2f2732, 0x0000000000000000, 0x000007c24477b804, 0x000000248acf9d95, 0x0000004822e18575, 0x0000000000000000, 0x0000007f0c252cd9, },
  },
  },
  { // 18
  // compressed: 0x138d0436fafc189cdd9d8973b39d1529aad0929f0b359fdcd4198a87ee7ef526
  {
    { 0x000004c9782a0dde, 0x000004fa36048d13, 0x0000000000000001, 0x000004d55687efb1, 0x0000032d98f791c6, 0x00000285cfc96855, 0x0000000000000000, 0x0000051a27ad1233, },
    { 0x0000063070aab341, 0x00000133bbb3831f, 0x0000000000000000, 0x0000075e2f619565, 0x0000073613d7f628, 0x000000a19d4dc9f3, 0x0000000000000000, 0x000003a306985c15, },
    { 0x000001547736cba9, 0x000000a45676cdce, 0x0000000000000000, 0x0000054603458891, 0x000000a0954eecf2, 0x0000004deafddd0f, 0x0000000000000000, 0x0000008083287b3b, },
  },
  // compressed: 0xddaa6ca24377214bceb78a6424b4a647e3c9fb037a4f1dcb19d000984231d912
  {
    { 0x000006ba43ebcc96, 0x00000743a26caadd, 0x0000000000000001, 0x00000799d337594f, 0x000002f70e3be663, 0x000007bd01fde4f1, 0x0000000000000000, 0x0000042a71aff9ca, },
    { 0x0000055395f8781d, 0x00000156f9c9642e, 0x0000000000000000, 0x000007548f6018ce, 0x0000004340fd9fa9, 0x0000000d019cb1d4, 0x0000000000000000, 0x0000059a01244182, },
    { 0x00000235d272709b, 0x0000051e9ad09192, 0x0000000000000000, 0x00000578f14502c8, 0x000000284143b2ed, 0x00000025b2628530, 0x0000000000000000, 0x000000369f246286, },
  },
  // compressed: 0xb16698a43030cf3359485f21d2731f25f6f4de5140aa82abf6239a6fd591f1df
  {
    { 0x0000009d89150951, 0x00000030a49866b1, 0x0000000000000001, 0x00000433ac2d9068, 0x0000021fcbaf9810, 0x0000052028ef7a7b, 0x0000000000000000, 0x000001402ac9f59e, },
    { 0x0000052d2d47cb82, 0x000003e90b2679e6, 0x0000000000000000, 0x00000130a47033da, 0x00000132dae20eae, 0x000001a23f6ab82a, 0x0000000000000000, 0x000000f36cbef457, },
    { 0x000000e73bea44b7, 0x000000947dcf4885, 0x0000000000000000, 0x000004a20eade57f, 0x0000004736ae54fe, 0x000000bfe323aadf, 0x0000000000000000, 0x0000000418a4d4eb, },
  },
  // compressed: 0x89cc42f059ef31e9b64b128e9d9c582c9759c7ae8ae1c8ad0cc502560afe2c45
  {
    { 0x000004f89ed8dbbc, 0x00000759f042cc89, 0x0000000000000001, 0x000007a0647877df, 0x0000066e51f0d83a, 0x000000c55763accb, 0x0000000000000000, 0x00000512f8fd88e4, },
    { 0x000007948d8ef306, 0x0000024976dd263d, 0x0000000000000000, 0x0000040f93f0d41e, 0x00000313877a9524, 0x0000002c50cadc8e, 0x0000000000000000, 0x000004b877bab17e, },
    { 0x00000323caabe771, 0x000004b162727638, 0x0000000000000000, 0x000006ef11909c39, 0x0000000555988c2a, 0x0000008a59fc14ac, 0x0000000000000000, 0x00000099f6faf660, },
  },
  // compressed: 0x12ef8997c29986e20d1957df71cd6e2bd070c9ec57c843c3c53a4d43bc4c1d5b
  {
    { 0x0000056cb89b75fe, 0x000001c29789ef12, 0x0000000000000001, 0x00000615cc0a9f26, 0x0000051b9f71a64f, 0x0000042bf664b868, 0x0000000000000000, 0x000004c599b4d382, },
    { 0x0000055b900e5687, 0x000002e321bc50d3, 0x0000000000000000, 0x000001b99cb6df64, 0x00000075364b8c3a, 0x000004d3ac5c343c, 0x0000000000000000, 0x00000592dd113014, },
    { 0x000005531a536671, 0x000000adbb35c77d, 0x0000000000000000, 0x000004e93c38aee2, 0x0000002968c45672, 0x000000b63a997886, 0x0000000000000000, 0x0000005f31ee24b0, },
  },
  // compressed: 0x01a7544f44ae122eded7cba9f03efefce05d83750d89bfce544561e7e962801d
  {
    { 0x0000074cb50f9e56, 0x000006444f54a701, 0x0000000000000001, 0x00000285a9907c5a, 0x00000610c11807b3, 0x00000486bac1aef0, 0x0000000000000000, 0x000006fdef9a5a74, },
    { 0x000001c264019294, 0x0000017afbc5c255, 0x0000000000000000, 0x00000721ec4caf5b, 0x0000006aaf99a2ac, 0x00000614554cebf8, 0x0000000000000000, 0x00000725ff38d0e1, },
    { 0x0000056c7fd2a63a, 0x000003f3f8fbc2a7, 0x0000000000000000, 0x000004683aa2d646, 0x00000074d5c493b0, 0x0000003b00c5d3ce, 0x0000000000000000, 0x000000531719d15d, },
  },
  // compressed: 0xde65210aea727a83f679cf0bb407ab3f70ae3877c7361652dcd7a7031827a66b
  {
    { 0x00000153eff70cb2, 0x000002ea0a2165de, 0x0000000000000001, 0x000004b583693335, 0x000002bd1853e7b5, 0x00000363bb9c5738, 0x0000000000000000, 0x0000054d525912b9, },
    { 0x000002ae0ec5524f, 0x000001ef3ed06f4e, 0x0000000000000000, 0x000006bfdfb84ddd, 0x000005ce48594184, 0x0000027d7dc52163, 0x0000000000000000, 0x000005e1c6aa293a, },
    { 0x0000012e2724a9e4, 0x000000feac1ed02f, 0x0000000000000000, 0x00000756a04f7d8e, 0x000000697150809a, 0x000000d74c4e3007, 0x0000000000000000, 0x000000e3ac57ba8c, },
  },
  // compressed: 0xf55ef7b1dab52dcdf565b016cf957fd785f0493fea1f57143d2b2b262136331c
  {
    { 0x00000428d378df80, 0x000005dab1f75ef5, 0x0000000000000001, 0x0000055467d9ca81, 0x000007fcfb80ed2d, 0x000007f51fa4f842, 0x0000000000000000, 0x0000044971d6311d, },
    { 0x000001f4968ca679, 0x0000060cbeb9a5b6, 0x0000000000000000, 0x0000053186f50dfc, 0x00000172ba4e3645, 0x000002b2b3d14571, 0x0000000000000000, 0x0000069d98cda6d0, },
    { 0x000003db6d0de428, 0x0000075dfe573c5a, 0x0000000000000000, 0x000004e62df1d4ac, 0x000000e9abe62fe6, 0x00000038666c424c, 0x0000000000000000, 0x00000095d7988a8f, },
  },
  },
  { // 19
  // compressed: 0x10b654739e8d400b6e5ba85b53326b8007a2584a033ae6db2cdfa1c9ddd93b97
  {
    { 0x0000071b276d01c9, 0x0000059e7354b610, 0x0000000000000001, 0x0000071efe5872df, 0x0000014db8eb7dd4, 0x00000501a52c5103, 0x0000000000000000, 0x000003c764b39d70, },
    { 0x000000918e025e00, 0x0000050b6dc16811, 0x0000000000000000, 0x0000072318256a01, 0x000003db79253081, 0x0000021df2cdbe63, 0x0000000000000000, 0x000001ea319e6ed2, },
    { 0x0000079ee2eb161b, 0x00000601acc94d6e, 0x0000000000000000, 0x000001635960bb50, 0x000000bb11f7f2b4, 0x0000002e77b3bb93, 0x0000000000000000, 0x0000000dc39a2763, },
  },
  // compressed: 0x53035b9e62af2b4747048d27900baa3b27bf4396465f780c137b838d1a6a3aff
  {
    { 0x000005516f166f23, 0x000007629e5b0353, 0x0000000000000001, 0x000004395d3d800b, 0x0000070a50268447, 0x000007a34b21df93, 0x0000000000000000, 0x000004182c96319c, },
    { 0x0000056d57c81a15, 0x000001a088e8e575, 0x0000000000000000, 0x0000003dbedefcc8, 0x000006162663fe35, 0x00000037b130c785, 0x0000000000000000, 0x0000051307e68cd7, },
    { 0x0000004638ca4c7e, 0x000004eea82e409e, 0x0000000000000000, 0x00000656a3555724, 0x0000006100c06a4d, 0x000000fe74d4351b, 0x0000000000000000, 0x00000061a1fbda5c, },
  },
  // compressed: 0x5047b8681e97b49ccfbb6466297295a02b41fa7226e78d5cd989c551430815c6
  {
    { 0x0000051af21233b3, 0x0000071e68b84750, 0x0000000000000001, 0x000001c0aeb9a02e, 0x0000043fc7a4cd3b, 0x00000393397d2095, 0x0000000000000000, 0x00000280b2cc9976, },
    { 0x00000189b39c0b29, 0x0000049779f39692, 0x0000000000000000, 0x0000006995d79203, 0x0000009986869651, 0x000004589d95c8de, 0x0000000000000000, 0x000004a5dfe0e6df, },
    { 0x0000046f6f9e3bc3, 0x0000068255c8a599, 0x0000000000000000, 0x000001571c443458, 0x0000001524284058, 0x0000008c2a1086a3, 0x0000000000000000, 0x00000077941a512b, },
  },
  // compressed: 0xbf01cc9eb68e689c6f8944a6ad83bcf0e29f7a5f5f952dca4182f28d03b4a84e
  {
    { 0x000001bc3c5d62a4, 0x000006b69ecc01bf, 0x0000000000000001, 0x0000060af1cad202, 0x000006d10987daa2, 0x000002afafbd4ff1, 0x0000000000000000, 0x000003a2a4f88d2f, },
    { 0x0000060f4c081e06, 0x000000912df38d11, 0x0000000000000000, 0x0000019dd0655da8, 0x000000f13cd98183, 0x00000728241ca2d9, 0x0000000000000000, 0x000002ca46391217, },
    { 0x00000467f22cfb3f, 0x000003c2f20eb699, 0x0000000000000000, 0x00000518c14c1692, 0x000000ac63bdbb5d, 0x0000009d5168071b, 0x0000000000000000, 0x000000499c1260a8, },
  },
  // compressed: 0x850bf3fd55a1cf3fa42e37368e16f7d244f89264de64e0b280424f32a7289954
  {
    { 0x000000f5fd06c106, 0x00000155fdf30b85, 0x0000000000000001, 0x000002a763ee1a2e, 0x0000047f3746579f, 0x0000026f32497c22, 0x0000000000000000, 0x0000019de8bfa6b4, },
    { 0x000001021e43fd12, 0x000006e5d487f9f4, 0x0000000000000000, 0x000003ffbd5e4dc6, 0x0000006d74b82780, 0x000004f4280b2e06, 0x0000000000000000, 0x000005cff6abc3bd, },
    { 0x000002d711a0d576, 0x0000034bdc5a38d8, 0x0000000000000000, 0x000006ba4792df49, 0x00000083a9c78514, 0x000000a932514e64, 0x0000000000000000, 0x0000009236cdbd81, },
  },
  // compressed: 0xa164dad08e4af0754b28e267af2c22eda47b7b1f79a33482678b01b7b0b8f6cc
  {
    { 0x0000013dc7ea32a7, 0x0000028ed0da64a1, 0x0000000000000001, 0x00000021991a73bd, 0x000007a965fc6ca3, 0x000001bc8fbdbdd2, 0x0000000000000000, 0x0000018dc23bb831, },
    { 0x000002db73131eb6, 0x00000445096ebe09, 0x0000000000000000, 0x000006418f587075, 0x000005ee4acac0ab, 0x00000018b678234a, 0x0000000000000000, 0x00000078a99c13d3, },
    { 0x0000078f57e331f8, 0x000003b488b2bd9f, 0x0000000000000000, 0x000006ac9ef0077c, 0x00000011e671a190, 0x00000099ed71616e, 0x0000000000000000, 0x000000a61a9505d6, },
  },
  // compressed: 0x9ebf9a6c4573696d80a80049fcb27f2550b8cfc812f4ac2b5bbdbf0ce0e7b38d
  {
    { 0x00000630e1f94825, 0x000003456c9abf9e, 0x0000000000000001, 0x0000043ee2096363, 0x00000191e6427fc5, 0x000002096467dc28, 0x0000000000000000, 0x0000022109a21d8d, },
    { 0x0000056a6b400986, 0x00000015100dad2e, 0x0000000000000000, 0x000006b96d67acdf, 0x000001770b9c7482, 0x000003fbd5b2bacf, 0x0000000000000000, 0x0000061a1db0fbe0, },
    { 0x000005f8b5e09a32, 0x00000095fecbf124, 0x0000000000000000, 0x0000020758b1fd86, 0x000000cbd4ea7e20, 0x0000001b67cfc019, 0x0000000000000000, 0x0000000549d83243, },
  },
  // compressed: 0x5f79cff16261c8f5f257ee2619868c117835061c85242117cf7f06ec5d2bd136
  {
    { 0x0000059a3b24b8a2, 0x00000162f1cf795f, 0x0000000000000001, 0x0000079179154557, 0x0000037445d0381b, 0x000002428e031abc, 0x0000000000000000, 0x000003746f8bcdd6, },
    { 0x000005f4170b9cc4, 0x000005cafe5eb90c, 0x0000000000000000, 0x0000070741424da4, 0x000007809bfcccbe, 0x00000067fcf17212, 0x0000000000000000, 0x0000028285936bdb, },
    { 0x000006e15deb3116, 0x000000463218649b, 0x0000000000000000, 0x00000357923d73f1, 0x0000007a2878a224, 0x0000006da256bbd8, 0x0000000000000000, 0x0000005dea2f10b7, },
  },
  },
  { // 20
  // compressed: 0x512f5b30fbbfee96b8969588ad38f9d325ddd546c72df5f095003abb90829657
  {
    { 0x0000074e8c58aedc, 0x000007fb305b2f51, 0x0000000000000001, 0x000000430a20e101, 0x000004ab74c038c5, 0x000006e3a36aee92, 0x0000000000000000, 0x000004d437717768, },
    { 0x000006083488c6f2, 0x000002b2d712ddd7, 0x0000000000000000, 0x0000061d88fee357, 0x0000043a8a6e185d, 0x000003a0095f0f52, 0x0000000000000000, 0x000002aa3e1cf750, },
    { 0x000002e7bc8beeaf, 0x0000074fe4e2b622, 0x0000000000000000, 0x000007ce4d963493, 0x0000005e36f1f562, 0x000000af2d052176, 0x0000000000000000, 0x000000fb887c6bb8, },
  },
  // compressed: 0x18973e275c2a785a94fd4e5e99c676353e7d231f05d82e0f990ad5821db84f84
  {
    { 0x00000665887dd9c3, 0x0000025c273e9718, 0x0000000000000001, 0x000000c5a907e3d9, 0x000006fc77903cd8, 0x000004028f91be9f, 0x0000000000000000, 0x0000029a5900dda4, },
    { 0x0000060a6ab0b2cc, 0x000001dfb28b4f05, 0x0000000000000000, 0x0000018c6b383be3, 0x000000cc12fc6e08, 0x00000550a990f2ed, 0x0000000000000000, 0x0000030dd2eca704, },
    { 0x000007243e6cc52e, 0x000000d5db1a6579, 0x0000000000000000, 0x0000055eccdc7739, 0x000000fdee402ceb, 0x000000089f703b05, 0x0000000000000000, 0x000000fef3047f38, },
  },
  // compressed: 0xba87f568f01f9c6adec850004e892708e75bed7d5599bf3cf0d6061c43b0a964
  {
    { 0x00000239a3b513e8, 0x000007f068f587ba, 0x0000000000000001, 0x000006a15b7d2919, 0x0000009b7ac85e99, 0x000004aabef6adf3, 0x0000000000000000, 0x00000721c4d22ea3, },
    { 0x000003f51b10669a, 0x000002191bcd5383, 0x0000000000000000, 0x0000075046a5d67a, 0x0000004d9b412b54, 0x0000006d6f03cbf9, 0x0000000000000000, 0x0000018346c7156c, },
    { 0x00000704d9c352e4, 0x000004209e253801, 0x0000000000000000, 0x000006c2d3da8354, 0x000000149c06e7af, 0x000000c953608638, 0x0000000000000000, 0x0000000e34fa159c, },
  },
  // compressed: 0x3144e12052350ccc4151b1090795650d365f9d201b62f59ad3557761f7bc69fc
  {
    { 0x000005aac887ba0b, 0x0000055220e14431, 0x0000000000000001, 0x000007eb04e8295f, 0x000000016077bb45, 0x0000010d904eaf9b, 0x0000000000000000, 0x000004d18b8bcc6b, },
    { 0x000004ac5dda60e5, 0x0000062a28398186, 0x0000000000000000, 0x0000021e6fa0fe1a, 0x000006a7e9ccf543, 0x000007755d39af56, 0x0000000000000000, 0x000002ca51de951a, },
    { 0x0000040498a416fe, 0x0000003596541c26, 0x0000000000000000, 0x000004436c6094bd, 0x000000587798e28d, 0x000000f8d379eec2, 0x0000000000000000, 0x000000deb534e645, },
  },
  // compressed: 0xbe44d9a3ebd429e79eaf788040099e8d039c86477a562545243b8dee8096ab82
  {
    { 0x0000000c2f41c6c5, 0x000004eba3d944be, 0x0000000000000001, 0x00000285dde50d9a, 0x000003b81e628e4f, 0x0000033d23c34e01, 0x0000000000000000, 0x0000078eec8f7b6c, },
    { 0x000007df73717420, 0x00000715f3dce53a, 0x0000000000000000, 0x00000734493df491, 0x0000047afca4efa4, 0x000000d3b2445255, 0x0000000000000000, 0x0000046bb34fa091, },
    { 0x000007127de70433, 0x0000063678250201, 0x0000000000000000, 0x000004866889383e, 0x000000929c4345c2, 0x00000005572d01dd, 0x0000000000000000, 0x000000d6baed97d4, },
  },
  // compressed: 0x2225781e1741f9e0d336690374aee6f146c7fcd0a23e8b403e31dd039c86fb16
  {
    { 0x0000056cec0cd994, 0x000001171e782522, 0x0000000000000001, 0x0000019733b60962, 0x0000048a47a15a3b, 0x00000751687e63a3, 0x0000000000000000, 0x000003f684c8e81f, },
    { 0x00000203b7510aea, 0x00000526da7c1f28, 0x0000000000000000, 0x0000057c266511c3, 0x00000277354af016, 0x000005d313e408b3, 0x0000000000000000, 0x0000070d0754811f, },
    { 0x00000591cb71bd73, 0x000003c79ab9d00d, 0x0000000000000000, 0x00000093f1cad362, 0x00000015c667ed0a, 0x0000002df70d3807, 0x0000000000000000, 0x0000007f03c7171e, },
  },
  // compressed: 0x24c8175f357fdb0aa49942d7c323b974f7eaf8cb8b3e7cd53ddcde4cd3e2d30a
  {
    { 0x000007cc7ed9affe, 0x000007355f17c824, 0x0000000000000001, 0x000007c5336e249d, 0x0000076925862382, 0x00000745e5fc757b, 0x0000000000000000, 0x0000068004f77f0e, },
    { 0x000004b0e96ff221, 0x0000005334815b6f, 0x0000000000000000, 0x00000639fb2de181, 0x00000750993a8397, 0x000005edc3dd57c3, 0x0000000000000000, 0x000007a1ebef2d6f, },
    { 0x0000015172e28491, 0x000005d2e48f0f5d, 0x0000000000000000, 0x000001d17b78670c, 0x000000a0a21f8209, 0x00000015a7c5a699, 0x0000000000000000, 0x00000024f82b17e1, },
  },
  // compressed: 0x74b951aec48fa2de96fe4d74d373991da84838870b68406295df67d17924d84e
  {
    { 0x000004422e9879a2, 0x000007c4ae51b974, 0x0000000000000001, 0x0000052260c5d975, 0x000007e0a5a75665, 0x00000405c39c2454, 0x0000000000000000, 0x0000061854fb329e, },
    { 0x00000146c8fec32f, 0x000001bfd2dbd451, 0x0000000000000000, 0x00000036171fdc76, 0x000006f4f689b413, 0x0000067df9562406, 0x0000000000000000, 0x0000039236d8808a, },
    { 0x000006912b77514b, 0x0000007665cf4dd1, 0x0000000000000000, 0x00000140d4bbf3ad, 0x0000006a9df0fa0f, 0x0000009db048f3a2, 0x0000000000000000, 0x000000605b25a40a, },
  },
  },
  { // 21
  // compressed: 0x77f1e0e4b66fbc2d936abda429bfe104e8f67a78d466195e60d026b45e5fdc8e
  {
    { 0x000001a2bca4283d, 0x000007b6e4e0f177, 0x0000000000000001, 0x000007d653da8e67, 0x0000065c61347d43, 0x0000036a3c3d7b74, 0x0000000000000000, 0x0000031d81abc511, },
    { 0x000000c7bb2f0278, 0x000007ad5265b78d, 0x0000000000000000, 0x0000053ec82a8a77, 0x000001cae4caec7b, 0x0000026d0605e196, 0x0000000000000000, 0x000001cba72bf872, },
    { 0x000003b58bc24686, 0x0000001386fca692, 0x0000000000000000, 0x000007a7707bb092, 0x00000021cba76ede, 0x0000001db8bebd68, 0x0000000000000000, 0x0000008b68d8a26c, },
  },
  // compressed: 0xe4e37f8add4d9dce300e6276566413ab58990eb37b4f594bdf291232ef0a1cdc
  {
    { 0x000002bf314f7fa1, 0x000005dd8a7fe3e4, 0x0000000000000001, 0x000003bcfa79db8f, 0x000002a591d45f42, 0x000007bdd9874cac, 0x0000000000000000, 0x00000332ce419243, },
    { 0x0000019e8a152805, 0x00000441c619d3a9, 0x0000000000000000, 0x000003eb3666e103, 0x000004b713b1dbbd, 0x000001229df4b594, 0x0000000000000000, 0x000000ab5bb087a7, },
    { 0x000003895fc7723a, 0x000002ac4d9159d9, 0x0000000000000000, 0x0000058122047b09, 0x00000042ef7f46db, 0x000000b83815de64, 0x0000000000000000, 0x00000095cc3270fb, },
  },
  // compressed: 0x83fb5b98447e1161363196712a46e0fc4b9025d44834ac83643da45bbe5a6875
  {
    { 0x000006aa5344a32e, 0x00000644985bfb83, 0x0000000000000001, 0x00000133eb61f2b2, 0x000005cba50986b0, 0x000002246a12c825, 0x0000000000000000, 0x000002883d7b32b4, },
    { 0x000003680f11bb7e, 0x000002c626cc222f, 0x0000000000000000, 0x000007e92a4dd2c1, 0x000003f3e035eb0e, 0x00000243d6483ac3, 0x0000000000000000, 0x0000030e6aadf727, },
    { 0x000001f623aad2d0, 0x000007f38118a9c6, 0x0000000000000000, 0x00000550f43ea327, 0x0000003401b2362f, 0x000000ead0b57cb7, 0x0000000000000000, 0x00000026aa536c47, },
  },
  // compressed: 0xfe832ee2bc16c7f5c18509e819eb2bb4ae4a251437a69dec13a6901505ea7259
  {
    { 0x000003d7add1d518, 0x000006bce22e83fe, 0x0000000000000001, 0x00000420dc8f7811, 0x000000f8388a3acd, 0x0000031b8a12a557, 0x0000000000000000, 0x000006b2599b021a, },
    { 0x00000023e2231e1b, 0x00000130b83eb8e2, 0x0000000000000000, 0x000001a9f501fa95, 0x000004a3a018732e, 0x0000010a613ec9da, 0x0000000000000000, 0x000005f3bdbc01b2, },
    { 0x0000065e7de2233f, 0x000002d0afac67a0, 0x0000000000000000, 0x0000026a6b4a52b1, 0x000000f36b7034cb, 0x000000b2e5d40a2b, 0x0000000000000000, 0x0000009efd392b20, },
  },
  // compressed: 0xfe9952353d44c871d7eaebdb1c3bcd8b6694a4f19e499280c8ad44a1c4ee4219
  {
    { 0x000003bc5781302e, 0x0000043d355299fe, 0x0000000000000001, 0x00000319ae234992, 0x000004d729fdece3, 0x000004cf78d24a33, 0x0000000000000000, 0x0000024a129e0891, },
    { 0x000005bb81ec4ce9, 0x0000057d5aee3908, 0x0000000000000000, 0x00000547d24fb58a, 0x00000638e4c8c299, 0x0000044adc880924, 0x0000000000000000, 0x0000079ca75553ce, },
    { 0x00000361483ce626, 0x0000022f34ec736f, 0x0000000000000000, 0x000000b06cf64433, 0x000000633275b25c, 0x0000003285dd8942, 0x0000000000000000, 0x0000005414ca629d, },
  },
  // compressed: 0x3a791c3ccd1a36cf3bbc355aacbc9e2faba6cda8e960e860131aea6d9bc35d05
  {
    { 0x0000037ff7f927c2, 0x000002cd3c1c793a, 0x0000000000000001, 0x0000027cc28d5bb6, 0x000001d108aad7bb, 0x00000074d466d355, 0x0000000000000000, 0x0000046772519644, },
    { 0x00000214c6a5b6f2, 0x000006b78779e6c3, 0x0000000000000000, 0x000001bff5762324, 0x000007c2ded5982f, 0x000006a1a1360e86, 0x0000000000000000, 0x000002a24b6a83c7, },
    { 0x0000036dd07c185f, 0x000004be7af2b168, 0x0000000000000000, 0x0000041f893af1dd, 0x00000099edc430c8, 0x0000000abb8736db, 0x0000000000000000, 0x000000243460ee21, },
  },
  // compressed: 0xc98374c73e7159d6af962bb877e0bf88d3bc971023289e289b3aed6c4ab97bd2
  {
    { 0x0000055e9f034a97, 0x0000013ec77483c9, 0x0000000000000001, 0x0000012a995b482e, 0x00000348caa8e9d8, 0x00000411884bde69, 0x0000000000000000, 0x000002ef17b26c72, },
    { 0x0000069785bc9b6b, 0x00000572d5facb2e, 0x0000000000000000, 0x00000707002ac7b3, 0x0000040e52d46054, 0x000006d3a9b289e2, 0x0000000000000000, 0x0000027a9f748503, },
    { 0x000007854ff024c0, 0x00000622ff81dee0, 0x0000000000000000, 0x000004d01741f1b8, 0x000000667f8ed8f4, 0x000000a4f77294d9, 0x0000000000000000, 0x000000d7120d3641, },
  },
  // compressed: 0x77dbc7b58cfa824055c134c7f88686067ea5e7f6d9c8e629cf9b63a708d37384
  {
    { 0x000000416270220d, 0x0000028cb5c7db77, 0x0000000000000001, 0x0000012603589e05, 0x0000026728397782, 0x0000046cfb73d2bf, 0x0000000000000000, 0x000007ba7300d4a7, },
    { 0x0000048b69d02554, 0x000006982aa8105f, 0x0000000000000000, 0x0000039892595dcf, 0x0000073eb73ffadc, 0x00000639bcf29e6c, 0x0000000000000000, 0x0000004341a02a1e, },
    { 0x000006656a27ebe4, 0x0000001a1a1be31c, 0x0000000000000000, 0x000004ad2d08491b, 0x0000004778420754, 0x00000008e7a6114e, 0x0000000000000000, 0x000000205ee77fbc, },
  },
  },
  { // 22
  // compressed: 0x9a1c51b5e0dab4a206ffff2b2960c87a344250f55d371f982da14eda25d76b3f
  {
    { 0x000001ab7f5745c6, 0x000002e0b5511c9a, 0x0000000000000001, 0x0000057b106058ac, 0x0000016d16fbd7d4, 0x000003aefaa8211a, 0x0000000000000000, 0x0000047cc9014996, },
    { 0x000000f8d21d6317, 0x000007ffe0d4569b, 0x0000000000000000, 0x000000d20bee69b1, 0x000005c013db7271, 0x000004ea12d981f3, 0x0000000000000000, 0x0000060d6d06466f, },
    { 0x00000408ea2bb95e, 0x000001eb2180a4af, 0x0000000000000000, 0x00000765015e79bf, 0x0000006cb2fa4bd4, 0x0000007ed7ae4bb4, 0x0000000000000000, 0x000000f6fd9833b4, },
  },
  // compressed: 0x9bfa7ca7514aae6d5086a3e754362682db822d8fcdffbb09bacaf51b66dcbe83
  {
    { 0x0000073c695c690d, 0x00000251a77cfa9b, 0x0000000000000001, 0x0000030d078975f5, 0x00000222257095e9, 0x000007e6c796c16d, 0x0000000000000000, 0x00000211f171b772, },
    { 0x000000520dcf1846, 0x00000470ca0db5c9, 0x0000000000000000, 0x0000013e530c4b19, 0x00000743956951d4, 0x0000075caba09bbf, 0x0000000000000000, 0x000007066a1a0cab, },
    { 0x0000037494b99819, 0x0000060898d9539e, 0x0000000000000000, 0x00000124a5095246, 0x000000846b5aec02, 0x000000077db8cc37, 0x0000000000000000, 0x0000001cf9c5619b, },
  },
  // compressed: 0xf9704bd9dffea6fe2dbafcc151c030f189ab2f7f7ed48248b5eeec8a135652e1
  {
    { 0x0000043ac48c85a3, 0x000006dfd94b70f9, 0x0000000000000001, 0x0000064e4870cb0d, 0x000003ee9d74a6a4, 0x0000023f3f97d5c4, 0x0000000000000000, 0x0000075d3af44c2e, },
    { 0x0000042735b8928c, 0x0000079745bfd4df, 0x0000000000000000, 0x000000b16d65577e, 0x0000034674a09db1, 0x000006ceeb54882d, 0x0000000000000000, 0x0000014dee49abe4, },
    { 0x000003f4d877d0f1, 0x000007c4c3014707, 0x0000000000000000, 0x0000073596f3c2a9, 0x000000ccdc14bb1f, 0x000000c2a4ac2715, 0x0000000000000000, 0x000000fe179021aa, },
  },
  // compressed: 0xa0137273ad9dac83982ef72ebaf8f69f5769ec43dd2e1e3175abc5de7d903a9d
  {
    { 0x000003a426f4136f, 0x000005ad737213a0, 0x0000000000000001, 0x000003313ed081dc, 0x000007eca7a31e14, 0x0000076ea1f634ab, 0x0000000000000000, 0x0000009e018190e5, },
    { 0x0000040606b7200d, 0x000006e5d3107593, 0x0000000000000000, 0x00000366901742d2, 0x000006edbf5cbc8d, 0x0000045ab75311e2, 0x0000000000000000, 0x000001bfde301280, },
    { 0x000002359cda795f, 0x0000067fdbe2e8bb, 0x0000000000000000, 0x000004a4ca7eb614, 0x0000001a3f1b79f1, 0x0000003a7520fbbd, 0x0000000000000000, 0x0000000002368946, },
  },
  // compressed: 0x5ca70a6a691f56166abd52585c72bfc1ad66799a7fdda811261085d2a288d963
  {
    { 0x0000006c3fc66c0c, 0x000007696a0aa75c, 0x0000000000000001, 0x00000753afbd232e, 0x0000059c134726b8, 0x000006bfcd3cb356, 0x0000000000000000, 0x000004d9c27395c8, },
    { 0x000002c1ba47fbf4, 0x00000257ad42cac3, 0x0000000000000000, 0x0000031ed0600240, 0x000000357e17ae38, 0x0000005102611a8d, 0x0000000000000000, 0x0000068a066f8166, },
    { 0x00000575038e3937, 0x00000706fdc97161, 0x0000000000000000, 0x000007a4af3ae3f7, 0x00000075891b22dd, 0x000000c7b31145a5, 0x0000000000000000, 0x00000067f5aa5646, },
  },
  // compressed: 0xe8cf22c4d0c82c8dcb3aa1057b4f2b076fa5f6ece6b6fea3e2710ab9cc55c33c
  {
    { 0x000001c6c5e41e16, 0x000000d0c422cfe8, 0x0000000000000001, 0x00000443903e9131, 0x000006697982f3a3, 0x00000373767b52b7, 0x0000000000000000, 0x000000d25d5d4922, },
    { 0x000007eee6aa80c9, 0x000004275971a599, 0x0000000000000000, 0x000002c6f9dd36d2, 0x0000056dca7b2acf, 0x000000a71e2a3feb, 0x0000000000000000, 0x000002e7568c87cd, },
    { 0x0000002be190c0cc, 0x0000041cad3dec16, 0x0000000000000000, 0x000002e292532de9, 0x0000002d81e85344, 0x0000007986ab9972, 0x0000000000000000, 0x000000c63d5e84d7, },
  },
  // compressed: 0xe80d70a3b975d9475205f8e2fbc58072e15de432278f6553b5805f667f2c1fc3
  {
    { 0x00000410da66fe9f, 0x000005b9a3700de8, 0x0000000000000001, 0x00000344858f7b19, 0x000003b08f7cdfc1, 0x0000079399722ef0, 0x0000000000000000, 0x0000020d104854eb, },
    { 0x000002dcb4d67d20, 0x00000700aa48fb2e, 0x0000000000000000, 0x0000054a295ac04c, 0x000002919b5bc3d9, 0x000005f80b553658, 0x0000000000000000, 0x00000253b2689004, },
    { 0x00000617752d49b0, 0x000005ca0317ef8b, 0x0000000000000000, 0x00000452acd4be87, 0x000000ab32c9163d, 0x000000863e58fecc, 0x0000000000000000, 0x000000f608e2bf22, },
  },
  // compressed: 0xc6bae6c480c276b30b9b1d6dddd30e9744f90b4558959ab023e2cd57faacd0c8
  {
    { 0x00000528acf6ae43, 0x00000280c4e6bac6, 0x0000000000000001, 0x000006e47dabe671, 0x000003b4dbf59622, 0x000002ac2285fca2, 0x0000000000000000, 0x0000073f74cb01ca, },
    { 0x0000038f56907db7, 0x000003b361766ed8, 0x0000000000000000, 0x000005e746f6c1e4, 0x0000076583fc0404, 0x000004de223b09a9, 0x0000000000000000, 0x000006d3bdb4208c, },
    { 0x00000218d5f22df5, 0x0000025c3b4f75b4, 0x0000000000000000, 0x000003c746865d88, 0x000000b366f7eb85, 0x00000091a159f4af, 0x0000000000000000, 0x0000002c46832266, },
  },
  },
  { // 23
  // compressed: 0x4086f31fd69c49dda0253606c39bcd29c33dd73d02d8e25131923b207a70254a
  {
    { 0x000001def6267ff6, 0x000004d61ff38640, 0x0000000000000001, 0x0000068a53f6ed6a, 0x0000029ff4d27958, 0x000004011eeb9ee1, 0x0000000000000000, 0x000002261d7100b0, },
    { 0x0000058108773c93, 0x000006c4b41ba933, 0x0000000000000000, 0x0000022e142556ec, 0x0000050500623a01, 0x000003b923151e2d, 0x0000000000000000, 0x000000e49fc40001, },
    { 0x000005ddcb29edd0, 0x000004a7366f0c18, 0x0000000000000000, 0x000004c109096077, 0x00000059bfbfd9ab, 0x000000944ae0f440, 0x0000000000000000, 0x000000ae4312da49, },
  },
  // compressed: 0x4edad0a191505d28083efeb5a76faa4bb39393e17c17e563fd30b0c4af35c903
  {
    { 0x00000517fd181bae, 0x00000091a1d0da4e, 0x0000000000000001, 0x000006c6492b0c3d, 0x0000067499032312, 0x000003be70c9c9d9, 0x0000000000000000, 0x000005c26eb11d1e, },
    { 0x0000072c76816dca, 0x000007c7c1050baa, 0x0000000000000000, 0x00000440bf932e4e, 0x000003c13da5509b, 0x000003030fd63e51, 0x0000000000000000, 0x0000008c7a2dcd29, },
    { 0x00000640898a7cae, 0x0000052ea9be9ed7, 0x0000000000000000, 0x0000011f330b137f, 0x000000af1dbae9ec, 0x00000007926b5f89, 0x0000000000000000, 0x0000007d8556b205, },
  },
  // compressed: 0xcbd132ae093a21a7d5c2f540df872b0f29ab1ee8c6a4ae0b5eacdb6a6cf61b8e
  {
    { 0x0000027be4d87bb9, 0x00000209ae32d1cb, 0x0000000000000001, 0x000005e9792c887e, 0x000006e839e5cdc1, 0x00000263740f5594, 0x0000000000000000, 0x000004e6dd572f8f, },
    { 0x000007235db4341a, 0x000006b85ab4e427, 0x0000000000000000, 0x0000024dabbc557a, 0x000000fcace99a0d, 0x000005bac5e0baea, 0x0000000000000000, 0x00000688f5fbfba6, },
    { 0x000006a62d37ad84, 0x0000043cae1f7d03, 0x0000000000000000, 0x000000680800632e, 0x0000005bab84b440, 0x0000001c37ecd8d5, 0x0000000000000000, 0x000000e60a9166b5, },
  },
  // compressed: 0x34e3d6a14b095b80193f350977f13ebf2b702206cb063f42dd4578d877225a58
  {
    { 0x000001a3cba8b8ee, 0x0000014ba1d6e334, 0x0000000000000001, 0x0000078233d48962, 0x000007a955c61c28, 0x0000036583113815, 0x0000000000000000, 0x000007d29b9f20ff, },
    { 0x0000022be2d886aa, 0x000006a7e3300b61, 0x0000000000000000, 0x00000704aff4314b, 0x000001db8ca760f4, 0x000007845dd423f0, 0x0000000000000000, 0x000006f981fa78e6, },
    { 0x0000019689bc76c8, 0x000006fcfbc5dc24, 0x0000000000000000, 0x0000059a6312d7b1, 0x0000006086887682, 0x000000b0b444efb0, 0x0000000000000000, 0x000000ecac4f12a1, },
  },
  // compressed: 0x9dcf86eaa37370e1dc5f1507b7fb8c3a8e8a8331fce7534816f613b684f4bb28
  {
    { 0x00000759d51fc8c0, 0x000003a3ea86cf9d, 0x0000000000000001, 0x0000075c6f136c7c, 0x0000004fd5ab8747, 0x000003fe18c1c547, 0x0000000000000000, 0x0000056909ef3799, },
    { 0x000000d6de471879, 0x000002abfb9c2e0e, 0x0000000000000000, 0x000003a237de4c25, 0x000003846a626bf1, 0x0000013f6164853e, 0x0000000000000000, 0x0000008f75d527e9, },
    { 0x0000066fb74bf414, 0x000000ea33eedc1c, 0x0000000000000000, 0x000006bfab441fdb, 0x0000007e82c15183, 0x0000005177e9096c, 0x0000000000000000, 0x0000003cf3966b03, },
  },
  // compressed: 0x8181e0f5d853e977d9de9d29440ca584e52545860c2d6cdcf4f2d1392db58ac7
  {
    { 0x000006c3eef7e3f1, 0x000003d8f5e08181, 0x0000000000000001, 0x000004d39252d159, 0x00000472de7cef7e, 0x00000686432292f2, 0x0000000000000000, 0x000005a05360e4b7, },
    { 0x000003c21f002686, 0x000003bbdb2efd2a, 0x0000000000000000, 0x0000035900ecd4d4, 0x000003b38317ff90, 0x0000051f2f4dc6c2, 0x0000000000000000, 0x00000212214b82c6, },
    { 0x0000020a2da9fffa, 0x00000612943110a6, 0x0000000000000000, 0x000007977786f21c, 0x000000cbaf2a3674, 0x0000008f156a5a73, 0x0000000000000000, 0x0000002db0f48234, },
  },
  // compressed: 0x83054ed5e2d5a4fbfa99bd2ed7af1fe28f77e96e73c27a49de6d5a7a570b999f
  {
    { 0x0000065a42066215, 0x000005e2d54e0583, 0x0000000000000001, 0x000006ad1be8f7d6, 0x000006d8eb7cca5b, 0x00000139b774bbc7, 0x0000000000000000, 0x0000034f2906f029, },
    { 0x00000344983677af, 0x000007b33f5f749a, 0x0000000000000000, 0x0000054f31f46689, 0x00000738ca657c05, 0x000005a6dde497ac, 0x0000000000000000, 0x000004d6d3e77c65, },
    { 0x0000061e6f8f3431, 0x000007887ebf5cba, 0x0000000000000000, 0x000001f47943aeb3, 0x00000051f0f902cb, 0x0000003f3216aef4, 0x0000000000000000, 0x0000008b105fc2a6, },
  },
  // compressed: 0xe46f3c942999acd8a29283a361f1f9b5f39ac8be13db992674f005e43c84cf7d
  {
    { 0x0000045d757983d6, 0x00000129943c6fe4, 0x0000000000000001, 0x000006484a4732c0, 0x0000042bcc2f0947, 0x00000589df644d79, 0x0000000000000000, 0x00000461c8aee370, },
    { 0x0000054234cccd26, 0x00000072545b1593, 0x0000000000000000, 0x000002c6532d921a, 0x0000026f6dd7ddd1, 0x0000005f0742699d, 0x0000000000000000, 0x0000027191bb3be2, },
    { 0x0000058adbb4445e, 0x000006d7e7c5868e, 0x0000000000000000, 0x00000754850ff729, 0x000000d11fcb71ec, 0x000000fb9f0879c8, 0x0000000000000000, 0x000000ce72d0fce6, },
  },
  },
  { // 24
  // compressed: 0xc01a0cc89dcc6da636a4381bf45ca097c6d7db95bef3eba7ab7d7e8df6b8a07d
  {
    { 0x00000014385675a6, 0x0000049dc80c1ac0, 0x0000000000000001, 0x00000153c3b5da76, 0x000005a82e6fd465, 0x000001df4aedebe3, 0x0000000000000000, 0x00000010ff592cb0, },
    { 0x000007b53d1def04, 0x0000071486d4cdb9, 0x0000000000000000, 0x00000233d37a81e3, 0x000004dc0b34cd1e, 0x000007e7daba7ebf, 0x0000000000000000, 0x00000674b4b03cc6, },
    { 0x00000689927cc2ab, 0x0000025e8173d06c, 0x0000000000000000, 0x00000076b1bdcc84, 0x0000008c22b5743a, 0x000000fb4171ed1a, 0x0000000000000000, 0x000000b4bf10fd06, },
  },
  // compressed: 0xb943a6a0d328969e6420c3e600cbc3b532ec2d7c8902539b0cc7d1d5e27ae3c3
  {
    { 0x000001cf70a13d11, 0x000000d3a0a643b9, 0x0000000000000001, 0x00000706eda6e133, 0x000003ea525e523f, 0x00000144be16f619, 0x0000000000000000, 0x0000047c1b131c08, },
    { 0x000001ba1891ec60, 0x000000640c93d2c5, 0x0000000000000000, 0x0000042758070fc7, 0x000004d1434f7029, 0x0000051c70c9b530, 0x0000000000000000, 0x0000055e9bebd5ad, },
    { 0x0000033f3ae054d4, 0x000002d70f2c039b, 0x0000000000000000, 0x0000059cc0754666, 0x0000006cd36cadc8, 0x00000087c6f5c5ab, 0x0000000000000000, 0x000000d443cd9a9f, },
  },
  // compressed: 0xe3b29966122941ef01138d704708d371bdb08211d0325432368b1e00071b37c5
  {
    { 0x0000070a3046e65f, 0x000001126699b2e3, 0x0000000000000001, 0x0000008d5ef8790b, 0x0000069e46415baa, 0x0000016808c1585e, 0x0000000000000000, 0x000004e930d0b75c, },
    { 0x00000246a49e38c2, 0x000001a2603de825, 0x0000000000000000, 0x00000126fcb4db61, 0x0000015ff5769dbb, 0x000001e8b3632543, 0x0000000000000000, 0x00000652179ac034, },
    { 0x00000561c4a8a803, 0x000005c74c211dc2, 0x0000000000000000, 0x00000149e3c37184, 0x000000b0d7f3e343, 0x0000008a6e360e00, 0x0000000000000000, 0x0000001d5f606f21, },
  },
  // compressed: 0x1dae750f5e80405130cc6226e3fb02ec6d3992ea1edfeb2cb35b43c54433aec4
  {
    { 0x000005c13748042f, 0x0000005e0f75ae1d, 0x0000000000000001, 0x000001b9bba543ee, 0x0000039c39a43686, 0x0000078f75491cb6, 0x0000000000000000, 0x000002e327c9b055, },
    { 0x000001754232c0aa, 0x00000459860a2810, 0x0000000000000000, 0x0000012e28539e51, 0x0000002c6611c81f, 0x00000435bb32cebd, 0x0000000000000000, 0x0000014678f1d82e, },
    { 0x0000008669079a08, 0x000007b00bef8c99, 0x0000000000000000, 0x000003cdd83a756b, 0x000000613598ceb4, 0x000000895c66898a, 0x0000000000000000, 0x000000c5aa4436ff, },
  },
  // compressed: 0x3c7af73a26d485754d14e9fe117baedf3d19f759807006a537209283539af294
  {
    { 0x0000019c18d0936d, 0x000004263af77a3c, 0x0000000000000001, 0x000006dc25b2d7f5, 0x000002976da54318, 0x000000402cfb8c9e, 0x0000000000000000, 0x0000025be1f6a631, },
    { 0x00000183418a4985, 0x0000052289aeb0ba, 0x0000000000000000, 0x000006a6081bee2f, 0x00000754562a3750, 0x00000122037a5067, 0x0000000000000000, 0x000006e093eda923, },
    { 0x00000721aed5b228, 0x0000077eb9ec47fb, 0x0000000000000000, 0x00000087e5c36e66, 0x000000b81dfbc978, 0x00000029e534a707, 0x0000000000000000, 0x000000bce46cb8f7, },
  },
  // compressed: 0x3eb3082f0639937dbe329fdfe559965bfdbd9e1fad3dffacb74973cb5505b2f0
  {
    { 0x000004074571217f, 0x000001062f08b33e, 0x0000000000000001, 0x000003c555112c4c, 0x000003ddfa0c8f19, 0x000006d68fcf5efe, 0x0000000000000000, 0x000003c2af281da3, },
    { 0x0000029b2b6aeb7f, 0x000003e657cfb267, 0x0000000000000000, 0x00000103f9b7ca22, 0x0000034eabc9a0a3, 0x000007349b7acff3, 0x0000000000000000, 0x0000006404a44667, },
    { 0x000004dde59d741a, 0x0000056e5967977e, 0x0000000000000000, 0x0000059a2108ea6a, 0x000000efe220988f, 0x000000e1640aab96, 0x0000000000000000, 0x0000001c68731e94, },
  },
  // compressed: 0x28194b3e090b931840f6f3730ee1e37d6f5d3973da1732f43e9c37cad6de8a6f
  {
    { 0x000002d93ecebde8, 0x000003093e4b1928, 0x0000000000000001, 0x0000023dfdb7b29a, 0x0000030fd82db6c6, 0x000003ed399caeb7, 0x0000000000000000, 0x000006817ef34a4f, },
    { 0x00000045e0f6cfa4, 0x0000067ec8031261, 0x0000000000000000, 0x00000356523c6802, 0x00000362372743fa, 0x00000379c3ef4321, 0x0000000000000000, 0x0000053de97f9967, },
    { 0x00000426cfa1049e, 0x000005f78f8439cf, 0x0000000000000000, 0x00000121ee5f8688, 0x000000bca80a6d14, 0x000000df15bdad94, 0x0000000000000000, 0x000000f01bce5d91, },
  },
  // compressed: 0x7227f400f3ea1f67aa418c2a2aeb728f92323797d77fa129a687b532adc6ef1d
  {
    { 0x00000545089ae7bc, 0x000002f300f42772, 0x0000000000000001, 0x0000061aef5195a7, 0x000002a8852408dc, 0x000007ebcb9b9949, 0x0000000000000000, 0x000003fdbd72ed17, },
    { 0x000007e9a0c15c50, 0x00000188354ce3fd, 0x0000000000000000, 0x00000762bdb5eb77, 0x00000128ce438ac1, 0x000003587a629a17, 0x0000000000000000, 0x000005d28672991f, },
    { 0x000000e2377b3c71, 0x0000023dcbaca8aa, 0x0000000000000000, 0x000000523049de45, 0x0000001d6517ece3, 0x0000003bdf8d5a65, 0x0000000000000000, 0x0000008cfa4037f1, },
  },
  },
  { // 25
  // compressed: 0xa9e77a56bdf41ebcbd9844d6b24c623fc84e1f2cd26410e4014038baa5c5f9ae
  {
    { 0x0000019a74ef4fad, 0x000004bd567ae7a9, 0x0000000000000001, 0x000005f6fa9e74cd, 0x000000e984d23d80, 0x00000269160fa764, 0x0000000000000000, 0x000001e878f7cc87, },
    { 0x000004611452bfd2, 0x0000009317b783de, 0x0000000000000000, 0x000005e4cf56dfad, 0x0000023c797964e0, 0x00000384001e4106, 0x0000000000000000, 0x0000045f2938255b, },
    { 0x000004ea09efb3da, 0x000000fd8932cb59, 0x0000000000000000, 0x000003c609e2f392, 0x000000e388789eb7, 0x0000005df38b4b74, 0x0000000000000000, 0x000000b4eb194721, },
  },
  // compressed: 0x94dc611d8b91e08c6630819a4636ed8dd3aae8af29a8e6d43fd439f62780738a
  {
    { 0x00000710d9462495, 0x0000018b1d61dc94, 0x0000000000000001, 0x0000022f57ffe1cc, 0x0000005fd05a43e5, 0x00000414d7f45569, 0x0000000000000000, 0x000007a524fd8afe, },
    { 0x000007aa007456e4, 0x000000260cd19c12, 0x0000000000000000, 0x00000073087301e9, 0x000006b72ece3d40, 0x0000039d43fd4e6a, 0x0000000000000000, 0x0000026a69c105c3, },
    { 0x000000eaa31b4b55, 0x00000637b4d91a6a, 0x0000000000000000, 0x000004019c343786, 0x0000005b75c48967, 0x00000014e7004fec, 0x0000000000000000, 0x0000004d3194c6a2, },
  },
  // compressed: 0x0ed93d5e2f703d2e8653d2e418093f9e6aa94d02f63e775e3233fa4a0c4b003c
  {
    { 0x0000018832b0ba78, 0x0000002f5e3dd90e, 0x0000000000000001, 0x000006ac06f4b82b, 0x000005c8d0148fe6, 0x0000077b0126d4b5, 0x0000000000000000, 0x0000032fe366a3c3, },
    { 0x0000039ff17ceca6, 0x0000024a70c5c7ae, 0x0000000000000000, 0x000000d89e735528, 0x000004aeb0708a81, 0x000007a33325e773, 0x0000000000000000, 0x000001fd2173ed32, },
    { 0x000000e060c7de49, 0x00000278fc246393, 0x0000000000000000, 0x000004728a1296a0, 0x0000003f687b9893, 0x0000007800961895, 0x0000000000000000, 0x000000d687fa039a, },
  },
  // compressed: 0xf30e763e5842c7b590b90aeeb952dc753f922b07c22714bff0d9f06f2d0b4273
  {
    { 0x0000054b4697c544, 0x000002583e760ef3, 0x0000000000000001, 0x000006cb9e851e06, 0x000004f5d5233c2d, 0x000003e10395c91f, 0x0000000000000000, 0x0000044b4cfdf9b9, },
    { 0x000001fff7f8f4eb, 0x000001573216b8e8, 0x0000000000000000, 0x000004471895e59e, 0x0000052f7142868b, 0x0000070d9f0bf142, 0x0000000000000000, 0x0000034bc9eda8ab, },
    { 0x00000057f7e1237c, 0x000005d7714ae7b8, 0x0000000000000000, 0x0000063d64e44f18, 0x000000b4d1ae20b6, 0x000000e684165adf, 0x0000000000000000, 0x0000007b6ac65fd4, },
  },
  // compressed: 0xd5259882b190492e91899a3e87ebeaedf84a704c393df0ee0e2bdf95a47e1959
  {
    { 0x0000062bf75dd9d8, 0x000000b1829825d5, 0x0000000000000001, 0x00000019e4e55aae, 0x00000098a4cf3939, 0x0000069ca638257c, 0x0000000000000000, 0x000006e0b78acd52, },
    { 0x000004eb34be8ddd, 0x000003513225c932, 0x0000000000000000, 0x000005f25d209c2c, 0x00000575f131bf2d, 0x000005f2b0eeef03, 0x0000000000000000, 0x00000570cc0c7ce2, },
    { 0x000004345ec7d8e5, 0x000003b7abae1cfa, 0x0000000000000000, 0x0000039ded0de9f8, 0x000000086435be93, 0x000000b232fd492b, 0x0000000000000000, 0x0000008bd5fb83e9, },
  },
  // compressed: 0xedb1cccf24460eb695035cbd92c2db59c98104dc1d9da03140d9565deace73bf
  {
    { 0x000001858045d72b, 0x00000624cfccb1ed, 0x0000000000000001, 0x000007d10a4e8dc6, 0x00000332b59116e3, 0x0000068eee0240e4, 0x0000000000000000, 0x0000003f8aabd77d, },
    { 0x000005e0ca2d3080, 0x0000038072b6c1c8, 0x0000000000000000, 0x000001366736f4f7, 0x0000062dade941a3, 0x0000056d94031a09, 0x0000000000000000, 0x000006218db60c12, },
    { 0x000001308bea8b3c, 0x000005676f0a4af5, 0x0000000000000000, 0x000002f95c01f913, 0x000000b4bdd79006, 0x0000007ee79dd4ba, 0x0000000000000000, 0x0000004c0b11224c, },
  },
  // compressed: 0x42e576c63c8e814cadccce03932c425e089f12b4cacc07ecb84344b210faed0d
  {
    { 0x000004a68360ff04, 0x0000063cc676e542, 0x0000000000000001, 0x000007d5b82b522a, 0x0000053989439aa8, 0x000006655a094f84, 0x0000000000000000, 0x000001793760cfe9, },
    { 0x0000043cde8b3ee0, 0x000001d995a99031, 0x0000000000000000, 0x000004b83d7dc76c, 0x00000615d57831b2, 0x000004443b8ec07c, 0x0000000000000000, 0x000007a9408a5b4d, },
    { 0x0000070f64ff79d9, 0x0000017908b24c0f, 0x0000000000000000, 0x000004dbc58d1a7e, 0x000000a95a185c9c, 0x0000001bdbf42164, 0x0000000000000000, 0x000000c5d965754e, },
  },
  // compressed: 0x7428b6af36280792a504e179855ecd5f4aa130c6ad01ad5a983f6675503d91e1
  {
    { 0x0000015261152b3d, 0x00000036afb62874, 0x0000000000000001, 0x000005361a3231da, 0x000004685cb5a638, 0x000000d6e31850a5, 0x0000000000000000, 0x000000a89fcaca67, },
    { 0x000003bafa3cbdaf, 0x0000042094b240e5, 0x0000000000000000, 0x000004004e01b8c5, 0x0000066d8be7482c, 0x00000663f985aad0, 0x0000000000000000, 0x00000405d5c02d80, },
    { 0x0000052588d5f43b, 0x0000017f357a15e7, 0x0000000000000000, 0x000003e91d60ca50, 0x0000005cb3f23352, 0x000000c3227aa0ea, 0x0000000000000000, 0x0000007bb7854263, },
  },
  },
  { // 26
  // compressed: 0x14bb9627a257aaf321da079bb7ba3a881c39a03118e24be5f90532d838fbe7de
  {
    { 0x000007f9ce5ec54b, 0x000007a22796bb14, 0x0000000000000001, 0x000005cb41446a8e, 0x000003e3f87c4a8a, 0x0000010c18d01c8e, 0x0000000000000000, 0x00000046931e463c, },
    { 0x000005e261b35b81, 0x000000fb443e754a, 0x0000000000000000, 0x00000126ff2a71bf, 0x0000004b36b02800, 0x000003205f9e54be, 0x0000000000000000, 0x000004a0d0946af9, },
    { 0x0000040e70a9ae30, 0x00000220eaeade6c, 0x0000000000000000, 0x00000296b3f6a50d, 0x000000f12d062958, 0x000000bdcff671b0, 0x0000000000000000, 0x000000c3a0c67937, },
  },
  // compressed: 0xdf73fcf8bc28a3adfc37f0a65d6984ee09a9c238dbb47f63dc7b06f82dac235b
  {
    { 0x00000135ffdb2566, 0x000000bcf8fc73df, 0x0000000000000001, 0x00000153ee80527b, 0x000001402a9f7601, 0x0000026d9c615484, 0x0000000000000000, 0x000003820a874167, },
    { 0x0000016d176c6e89, 0x00000606ff95b465, 0x0000000000000000, 0x000003cdb1b35a57, 0x000002ed7f56f1b3, 0x00000067bdc637fb, 0x0000000000000000, 0x0000015dedc0e711, },
    { 0x00000716f5ae25e0, 0x000007ba11a5769b, 0x0000000000000000, 0x000007a23c66abeb, 0x000000dd2cbfb08f, 0x000000b647585bf0, 0x0000000000000000, 0x000000f3737773bb, },
  },
  // compressed: 0x74739f8eae7d99d11608bbcff8a232a00a5f446d12ba6ccd34b8cc0a4611a81b
  {
    { 0x000005406a3126c2, 0x000005ae8e9f7374, 0x0000000000000001, 0x000001fb0c429954, 0x00000214f2dcbd41, 0x0000050936a22f85, 0x0000000000000000, 0x000004c5387322dd, },
    { 0x00000118727d766a, 0x0000076102da332f, 0x0000000000000000, 0x000005d9ecee102d, 0x000007d21476c0c6, 0x000004cb834cd6cb, 0x0000000000000000, 0x0000024faf22eaab, },
    { 0x000003498e0ea1a3, 0x00000280ca8be33e, 0x0000000000000000, 0x000003851802b35d, 0x000000a0cbe2b193, 0x0000003750228c15, 0x0000000000000000, 0x0000007303e73cb1, },
  },
  // compressed: 0xde6fe66da5df45c83a48402c00a552e132f6b4c763e1d2e9651bbcdc2e45f4b0
  {
    { 0x0000027559230a93, 0x000007a56de66fde, 0x0000000000000001, 0x00000782c5759740, 0x000004a28a549e5a, 0x000000b1e3da7b19, 0x0000000000000000, 0x00000639e0752738, },
    { 0x000004de8ba31f71, 0x00000009075908bb, 0x0000000000000000, 0x00000397d990ada4, 0x000002cd0fd3a85a, 0x000003c1b65e9d2e, 0x0000000000000000, 0x000003f24698844f, },
    { 0x000004745a3da583, 0x000003854a9400b1, 0x0000000000000000, 0x000007e84d15a7e6, 0x00000071b8106e0b, 0x00000061e88a5db9, 0x0000000000000000, 0x000000c65b3434b2, },
  },
  // compressed: 0xa7840ced11fd09bf3a699f0d8171f0637987cf572d8c9021a24bf68af27d5a3a
  {
    { 0x00000315b807cba6, 0x00000511ed0c84a7, 0x0000000000000001, 0x000004be511beac7, 0x00000381b714b385, 0x00000616abe7c3bc, 0x0000000000000000, 0x000007cf802fcd32, },
    { 0x0000029e1afed76d, 0x000003ed2757e13f, 0x0000000000000000, 0x000004d99e5b9b5a, 0x000006d4a57bb1d9, 0x00000764ba221908, 0x0000000000000000, 0x00000481f63e19cf, },
    { 0x000004608f1f7ef1, 0x0000058fc1c60436, 0x0000000000000000, 0x000006914e01d7b4, 0x0000001649e9108f, 0x00000074b4fbe515, 0x0000000000000000, 0x00000069f9ee88ea, },
  },
  // compressed: 0x98aacf78ab1dbba5f2720b1967a2ed5c8e60920a11c90993b074b32f04a31901
  {
    { 0x0000004c789767ca, 0x000005ab78cfaa98, 0x0000000000000001, 0x0000009ce8c2177d, 0x0000044141fcafd4, 0x0000048885493047, 0x0000000000000000, 0x00000472d9415158, },
    { 0x00000328cfb832fc, 0x0000016e5e54b763, 0x0000000000000000, 0x000002ba182cf45b, 0x000007a63f755de8, 0x000003374b09309c, 0x0000000000000000, 0x00000620a73f5659, },
    { 0x000002e1c5372ce3, 0x00000173b6899c64, 0x0000000000000000, 0x0000019a7697d9a2, 0x0000007a77b82c9b, 0x000000023346085f, 0x0000000000000000, 0x000000ad8111e3db, },
  },
  // compressed: 0x028ff324ac5f1b58bd0ce3bafee90ba9f092cf8a0269219a8f035983a47e8b83
  {
    { 0x0000051110a86e17, 0x000007ac24f38f02, 0x0000000000000001, 0x0000002199316ff8, 0x000001bb128394c4, 0x000004814567c978, 0x0000000000000000, 0x000002d5ad7798ba, },
    { 0x000006b65f466da7, 0x0000046197ab036b, 0x0000000000000000, 0x000004f1a9f3e9df, 0x00000108b87f9153, 0x0000059038f9a216, 0x0000000000000000, 0x0000069eb650971a, },
    { 0x0000035fce20c82d, 0x000002a42fa7faeb, 0x0000000000000000, 0x000000bd274a0baa, 0x00000012ce98d732, 0x0000000716fd4906, 0x0000000000000000, 0x000000dcbc6204b2, },
  },
  // compressed: 0x226206630efb04333fbaac87890635fba361108c772419bd208683d143ad58b0
  {
    { 0x000002f587e593fb, 0x0000030e63066222, 0x0000000000000001, 0x000007fde57663d0, 0x000000f00a661f36, 0x0000023bc60830d1, 0x0000000000000000, 0x0000055ed64ca7cd, },
    { 0x000003a7ce362d8c, 0x0000059747e6609f, 0x0000000000000000, 0x000005d4c2064781, 0x0000028dba8b491c, 0x00000038620bd192, 0x0000000000000000, 0x0000063dc99bdc78, },
    { 0x0000052667b77b29, 0x000007ecd41a261e, 0x0000000000000000, 0x000000170f7ce288, 0x00000011ea228f13, 0x00000060b15a87a3, 0x0000000000000000, 0x0000004ca93f49df, },
  },
  },
  { // 27
  // compressed: 0x6e663faf498546dba50e4af104cf7fd7470cbaa4f73ff23d853cce32e1df103a
  {
    { 0x000002461e6bf9d6, 0x00000549af3f666e, 0x0000000000000001, 0x0000068aea17cea0, 0x00000251323a69ec, 0x000007fbd25d0623, 0x0000000000000000, 0x0000017e98f96078, },
    { 0x000006f4b02e83ab, 0x00000141d4bb68d0, 0x0000000000000000, 0x000003f83fbc0fe9, 0x0000001e0ffd4557, 0x000004e3c853df23, 0x0000000000000000, 0x000001e5d1517532, },
    { 0x0000048c16cff1dd, 0x0000075dff3c13c5, 0x0000000000000000, 0x000004bf545518e8, 0x000000324dc3b8c8, 0x0000007421bfc265, 0x0000000000000000, 0x0000003f43a03b0c, },
  },
  // compressed: 0xab94dfd100acdc38e90d08d1dd2b712e62e2d5fd3ee9137fe5019aee18edfc73
  {
    { 0x000005947d599832, 0x00000400d1df94ab, 0x0000000000000001, 0x0000010863139cb3, 0x000003ba2702c990, 0x0000049f7eeaf131, 0x0000000000000000, 0x0000076456b1c499, },
    { 0x0000062aa419900a, 0x00000101bd271b95, 0x0000000000000000, 0x00000407d9a0d63d, 0x0000075cf3399f6f, 0x000001a01e57f13e, 0x0000000000000000, 0x00000064f448d77c, },
    { 0x00000079195b68df, 0x000000b9c4af7744, 0x0000000000000000, 0x000002924f699f16, 0x000000ee6ac778d4, 0x000000e7f9da31dd, 0x0000000000000000, 0x0000003e84d6e037, },
  },
  // compressed: 0x5225a191c8357ef1769c5e5753816bb73e729b0d6f4083fa38e4a73f1bbb768b
  {
    { 0x0000064c41911c01, 0x000005c891a12552, 0x0000000000000001, 0x000001f97f92939b, 0x00000535f9878a23, 0x0000003786cdb91f, 0x0000000000000000, 0x00000231ccddc00b, },
    { 0x0000044584bdf924, 0x000003d38ede2fc6, 0x0000000000000000, 0x000000956dc11718, 0x0000031b0905875d, 0x0000027e438fa834, 0x0000000000000000, 0x0000072a95522e56, },
    { 0x000007c68edee05e, 0x000002ddae054d5d, 0x0000000000000000, 0x000006f99dc72f51, 0x0000009c35ea4e3a, 0x00000016ed76367f, 0x0000000000000000, 0x000000f6dbac3d6e, },
  },
  // compressed: 0xc7d201abf9ab3057183b1440dc76fb1681b2cba065be6c86fe6aff9b659bfa53
  {
    { 0x000001e850f33d92, 0x000003f9ab01d2c7, 0x0000000000000001, 0x000000e994885455, 0x000006dec6fe2ded, 0x00000732d065d940, 0x0000000000000000, 0x0000039f5e6b2d78, },
    { 0x0000019ab9f6f5b8, 0x00000287630ae615, 0x0000000000000000, 0x000005da9cad8299, 0x000001d2f4fad962, 0x000007f6afe866cb, 0x0000000000000000, 0x00000461f50181bb, },
    { 0x000005e663e93d82, 0x0000045beddb7100, 0x0000000000000000, 0x00000610e9759996, 0x000000e07d379d5e, 0x000000a7f536cb37, 0x0000000000000000, 0x000000731b27cb89, },
  },
  // compressed: 0xf2e3e7d2607c87c3b18b8230a0aa343b38f19e73e7263e287705c302909c9ce9
  {
    { 0x0000016733e248f3, 0x00000460d2e7e3f2, 0x0000000000000001, 0x000007235946f1cc, 0x00000678508581bb, 0x00000373b9cf789c, 0x0000000000000000, 0x00000123c0da74ba, },
    { 0x000007e14be3897a, 0x00000051763870ef, 0x0000000000000000, 0x000004bb2fbe60d4, 0x00000191b13d43f8, 0x00000430577283e2, 0x0000000000000000, 0x000004dd90728cdd, },
    { 0x000002f6784a1c56, 0x000000ecd2aa80c2, 0x0000000000000000, 0x000006485c62d733, 0x000000a76136bbbe, 0x000000d339392005, 0x0000000000000000, 0x000000a395e618df, },
  },
  // compressed: 0xc754ac189af97a730fb31cc5dc783390c70ce14c33bc892b9ae9f889c129ae12
  {
    { 0x000007427674e00a, 0x0000019a18ac54c7, 0x0000000000000001, 0x000000cb1f0d01cf, 0x0000031ee7999266, 0x00000619a6708663, 0x0000000000000000, 0x00000290e84e2711, },
    { 0x0000074f7e74c174, 0x0000039661ee6f5f, 0x0000000000000000, 0x0000069ef5d533d8, 0x0000003fdaa37585, 0x0000078e99a2b89b, 0x0000000000000000, 0x000006ba5ea55ca7, },
    { 0x0000018c3a15c285, 0x00000640cde37314, 0x0000000000000000, 0x0000003747bf30e8, 0x000000aa09545247, 0x000000255c538313, 0x0000000000000000, 0x000000bfa29fd2b1, },
  },
  // compressed: 0x8ecb93bf5efe423c5f56d43651a8dfbee82042889e85f0e028d12507963fd77d
  {
    { 0x000005df2845ab2c, 0x0000065ebf93cb8e, 0x0000000000000001, 0x000004fe68059829, 0x000001eb200171a3, 0x000002cf44211074, 0x0000000000000000, 0x0000029d5a2bd614, },
    { 0x000007fd3276bb85, 0x0000028acbe7885f, 0x0000000000000000, 0x000005e47cb621a4, 0x000006474d14daaf, 0x0000025d128e0f08, 0x0000000000000000, 0x000003470a413672, },
    { 0x0000001a5246c429, 0x000002fb7ea144db, 0x0000000000000000, 0x000005d5cc19cb6e, 0x000000127fe4dcb0, 0x000000fbae7f2c0e, 0x0000000000000000, 0x0000005eb379790d, },
  },
  // compressed: 0x01c391b660d541701ee7d7ad3f1b20858555331163e1c216b12808013d5ea5aa
  {
    { 0x000005429917135f, 0x00000560b691c301, 0x0000000000000001, 0x000002e60c07444f, 0x0000046cdf3bd568, 0x000000b18899aac2, 0x0000000000000000, 0x000006417edae432, },
    { 0x000007a07af0708f, 0x000002fce3ce083a, 0x0000000000000000, 0x00000043a21daa32, 0x0000051af4a7e774, 0x000000828b116c2e, 0x0000000000000000, 0x00000768664352b4, },
    { 0x000006b46e447d59, 0x00000614806cfeb7, 0x0000000000000000, 0x0000010b1538b5d1, 0x000000a8b1685c5c, 0x000000554abc7a02, 0x0000000000000000, 0x00000027d2009514, },
  },
  },
  { // 28
  // compressed: 0x7f873b19c9002ebb6b50dce090a8e3ec9f64de36c0b7f3ec1a9ede98080446df
  {
    { 0x00000045832fcedb, 0x000000c9193b877f, 0x0000000000000001, 0x00000116297bf48d, 0x000006e55ba7ff7b, 0x000003e01b6f324f, 0x0000000000000000, 0x000002aba34b5ee3, },
    { 0x0000057f0c6e73b1, 0x0000038a0d7765c0, 0x0000000000000000, 0x0000060d0697206e, 0x000003ce45e32bc0, 0x000005e9e1aecf3b, 0x0000000000000000, 0x0000055e835e1971, },
    { 0x000007e8e35b26b9, 0x000007b38ea24383, 0x0000000000000000, 0x000002a744ec8b53, 0x000000e726fd1029, 0x000000be8c081131, 0x0000000000000000, 0x00000059f149d123, },
  },
  // compressed: 0xa26bd0177e48b52c6b1950391c38d224308a9785819c65d7f6a4d691287f6ffa
  {
    { 0x0000058707110f67, 0x0000007e17d06ba2, 0x0000000000000001, 0x0000058d6a9aef49, 0x000005266139b543, 0x00000640c2cbc518, 0x0000000000000000, 0x0000029628cf5fea, },
    { 0x00000716a92db27f, 0x000002032d6596a9, 0x0000000000000000, 0x000007b7216fa13f, 0x00000252a097cb16, 0x0000056a4f6d7659, 0x0000000000000000, 0x0000045941d4c21b, },
    { 0x0000037530274df0, 0x0000009348e070e5, 0x0000000000000000, 0x000003c3b982f96c, 0x00000040937adcb0, 0x000000f4defe5123, 0x0000000000000000, 0x000000c02355bf8a, },
  },
  // compressed: 0x90f8cb02c8d0de63aa6aff0dca98d0fb99edb6b9fd0a4d621e0b3479b718ce69
  {
    { 0x0000026dcf95f83c, 0x000000c802cbf890, 0x0000000000000001, 0x00000528b29879cb, 0x000003f9ccc7bd2d, 0x0000057edcdb76cc, 0x0000000000000000, 0x000002210c4f91a9, },
    { 0x000005120e2becf2, 0x000007ed554c7bda, 0x0000000000000000, 0x000007d2125a3dea, 0x0000062f9e0d6a1e, 0x00000340b1e624d0, 0x0000000000000000, 0x000007101f1127e0, },
    { 0x000005f1fa1585c4, 0x000007ef42632837, 0x0000000000000000, 0x000003746ab8f351, 0x000000df8b983616, 0x000000d39c316ef2, 0x0000000000000000, 0x0000002ab2d675ca, },
  },
  // compressed: 0xca24517e1631ff09df45c7d98b15e40be556f57e227d2b2938d1b6af41e2a43a
  {
    { 0x000001d23f9179a2, 0x000001167e5124ca, 0x0000000000000001, 0x000000bf2a3305f5, 0x0000075aa9f90a45, 0x000006913f7aab72, 0x0000000000000000, 0x000000d12aa4e975, },
    { 0x000002dbb9e8c4e7, 0x000000e8bbe13fe6, 0x0000000000000000, 0x00000524d8659827, 0x000005f4dda1307d, 0x0000036d138292b7, 0x0000000000000000, 0x0000007a36c083ab, },
    { 0x000003fe0c48c65f, 0x0000042f90562f67, 0x0000000000000000, 0x0000052160fe3e8b, 0x0000001a446ed0f6, 0x0000007549c4835f, 0x0000000000000000, 0x00000065f954dc8d, },
  },
  // compressed: 0xdfcc872773a40732f8e313f20819e3174e960df6d7ecb2d5e90b60c236636ff4
  {
    { 0x0000068dc57d9af5, 0x000004732787ccdf, 0x0000000000000001, 0x00000345ab6c971c, 0x0000026f1177f251, 0x0000066bfb06cb27, 0x0000000000000000, 0x0000054501a20c36, },
    { 0x00000617be4f78ad, 0x0000027c7f0640f4, 0x0000000000000000, 0x0000006e63e7e95e, 0x000003d6a5caac01, 0x00000600be9d5b2e, 0x0000000000000000, 0x0000056629333596, },
    { 0x000004f82f4bb677, 0x0000005f8c6423c8, 0x0000000000000000, 0x0000078a23adca65, 0x0000008c4fd39dfd, 0x000000e8dec66d84, 0x0000000000000000, 0x000000f6922e00fd, },
  },
  // compressed: 0xdda253dd281b34543ffc42df5b9017aaf4f8d24dd992f50f7dd38ce00f62031d
  {
    { 0x0000035cab84b064, 0x00000328dd53a2dd, 0x0000000000000001, 0x000002cda2b4e554, 0x000006223d8ae706, 0x0000016ca6e97c7a, 0x0000000000000000, 0x0000025f3eea3cec, },
    { 0x000006778285b0bf, 0x0000005f87ea8683, 0x0000000000000000, 0x000003a30ff84046, 0x0000044fd7b476ad, 0x000000cd37d0ff59, 0x0000000000000000, 0x0000068ec4c2eabb, },
    { 0x00000125e0434a27, 0x000002a85e416f7d, 0x0000000000000000, 0x0000067b43f50845, 0x000000245746edf0, 0x0000003a06c41fc1, 0x0000000000000000, 0x000000058e17ea56, },
  },
  // compressed: 0xe1728d45bf32e5acb53cb77ce068e75be7bd8bee947dcf56033ab4fee39706eb
  {
    { 0x0000044b5d0b2fbb, 0x000002bf458d72e1, 0x0000000000000001, 0x0000004adf62a3c0, 0x0000030f60e840ae, 0x000006ca7745def3, 0x0000000000000000, 0x000004ac24f86954, },
    { 0x00000110595450fd, 0x000006e796b59ca6, 0x0000000000000000, 0x000005b48bb6d91e, 0x000001ef5e0e044a, 0x00000343a0356cf7, 0x0000000000000000, 0x000001b2fae9c9cb, },
    { 0x00000105715e401d, 0x0000056f9da381f2, 0x0000000000000000, 0x000004fbc003bc1d, 0x0000004c669e1481, 0x000000d60d2fc7fd, 0x0000000000000000, 0x0000003986fe8688, },
  },
  // compressed: 0xb9aecec9f15666d76a65e518f8155b1c34234c843228e7263868192f776f34ba
  {
    { 0x0000065a5cc7324f, 0x000006f1c9ceaeb9, 0x0000000000000001, 0x00000112e2da6ac8, 0x000005edae22d60c, 0x000004194226119a, 0x0000000000000000, 0x0000036ec7633931, },
    { 0x000000d5244a11ea, 0x000004acad5aecca, 0x0000000000000000, 0x0000050a3dba5aaa, 0x0000000314afb18a, 0x0000019683826e72, 0x0000000000000000, 0x0000077c5d096074, },
    { 0x0000074187130394, 0x000000716c57e063, 0x0000000000000000, 0x000003a6f40cc6c7, 0x000000d8d0138207, 0x0000007468deee5e, 0x0000000000000000, 0x0000000b22373edd, },
  },
  },
  { // 29
  // compressed: 0xefea2e51f3ac495349cbc11cd341c1208d689aa9070c1824172d4bc6d1f95ed5
  {
    { 0x00000183f5df0ebb, 0x000004f3512eeaef, 0x0000000000000001, 0x000000ba3b73bd08, 0x0000018505d9cc70, 0x00000603d4cd3446, 0x0000000000000000, 0x000007cc5a04a379, },
    { 0x0000058995982673, 0x00000039692a6935, 0x0000000000000000, 0x000005f7e186d4ee, 0x00000270c622cf11, 0x000004b2d1724180, 0x0000000000000000, 0x0000001749d5737f, },
    { 0x00000703cdd63d44, 0x0000048305074c73, 0x0000000000000000, 0x000001892bbc228e, 0x000000d679d9f354, 0x000000aabdf3a38c, 0x0000000000000000, 0x000000cebe9bc267, },
  },
  // compressed: 0x1db3da3bd9f62fa1fe2d659d0fd825078794be9af34f9c01433ccd82b850f460
  {
    { 0x000002036b1782fc, 0x000006d93bdab31d, 0x0000000000000001, 0x000006c321e5c0ca, 0x000006ecb4b2039f, 0x000007f9cd5f4a43, 0x0000000000000000, 0x0000060c3a8011d0, },
    { 0x000005b07681c58a, 0x000004a5bfd425fe, 0x0000000000000000, 0x00000337f440296b, 0x0000064c520d0dcb, 0x000004d3c43019c4, 0x0000000000000000, 0x000006dac804e5f1, },
    { 0x0000019205b205b2, 0x0000041c97603e75, 0x0000000000000000, 0x0000013f2da7275c, 0x00000027b33bee02, 0x000000c1e8a17105, 0x0000000000000000, 0x000000380dbd3cab, },
  },
  // compressed: 0xaa696dff402bd5ffbb4940dc180b533497984da32f5c4a5e2dba327d8e6f0978
  {
    { 0x000002d6a33ec4e2, 0x00000340ff6d69aa, 0x0000000000000001, 0x000002650dfa5ce7, 0x000001e2b194228a, 0x00000617d1a6cc4b, 0x0000000000000000, 0x0000063eb801b92d, },
    { 0x000005dc11d321ef, 0x00000009377ffaa5, 0x0000000000000000, 0x000006a8f1941555, 0x000002db60d9ca14, 0x0000032ba2d5e4a5, 0x0000000000000000, 0x00000091abe4f09c, },
    { 0x0000059823e4e2f8, 0x000004d14c2c6371, 0x0000000000000000, 0x000007e71278a922, 0x00000099e7143fd8, 0x000000f012df1cfa, 0x0000000000000000, 0x0000006e795a744c, },
  },
  // compressed: 0xadbbdd89fba8bef1cbaeae61bc2ccb3b9d8d9b1fbba7588f86a61251da7e5421
  {
    { 0x0000034d82c9f57c, 0x000000fb89ddbbad, 0x0000000000000001, 0x00000139fd5986d3, 0x000006d9a0c66dad, 0x000003dd8fcdc6ce, 0x0000000000000000, 0x00000203dd988cdc, },
    { 0x00000268a6d6528c, 0x000005d5d97e37d5, 0x0000000000000000, 0x00000147019bdfbd, 0x000004419fc9e9c4, 0x0000012a6868f58a, 0x0000000000000000, 0x00000254df4b72ba, },
    { 0x0000007f2ff78492, 0x000004ef2cb2f186, 0x0000000000000000, 0x000007d09cb22544, 0x0000000081e7b28a, 0x00000042a8fdb4a2, 0x0000000000000000, 0x000000c6aa146694, },
  },
  // compressed: 0x497b54724558ba9be008c4e2fac605f38df134c769fae8607a767daaaf2ba9b9
  {
    { 0x000006edb569cf37, 0x0000004572547b49, 0x0000000000000001, 0x00000713e693274e, 0x0000004875b5eb2e, 0x00000534e39a78c6, 0x0000000000000000, 0x000002b075c559cd, },
    { 0x000004a5dc2ca0fa, 0x000000811c13774b, 0x0000000000000000, 0x0000037a6eb3a498, 0x00000778f51ea7c0, 0x000007d767a60e8f, 0x0000000000000000, 0x0000049c4cd70525, },
    { 0x0000045e10a6c032, 0x000007cc171beb8b, 0x0000000000000000, 0x0000017d8e15dda3, 0x0000007dd4c58fb5, 0x0000007352575f54, 0x0000000000000000, 0x000000d086d40ccb, },
  },
  // compressed: 0x7c1020e817d3561e65e90a84446826c57afc0f32c6a1e0c1721461919c6673d3
  {
    { 0x000005e8202f3f27, 0x00000317e820107c, 0x0000000000000001, 0x000004ab9a0e5257, 0x000004ead1c6120b, 0x000000e31907fe3d, 0x0000000000000000, 0x000002c42d968f65, },
    { 0x0000072eb6178046, 0x0000015d2ca3cada, 0x0000000000000000, 0x000001567f8ba502, 0x000003789f991a4e, 0x00000611472c1e0a, 0x0000000000000000, 0x00000787d11afcaf, },
    { 0x0000031d70038993, 0x0000031499a11210, 0x0000000000000000, 0x000002423c821327, 0x0000002f6dcfed15, 0x000000a6e6cd3922, 0x0000000000000000, 0x00000039696b4cf1, },
  },
  // compressed: 0xe707a0a262aa746bb1c771f0b0e011f323e20b0038e40757ac6eef822dfdc02d
  {
    { 0x0000006b394afc6c, 0x00000262a2a007e7, 0x0000000000000001, 0x000007841119744e, 0x0000018b25e56c1a, 0x0000021c0005f111, 0x0000000000000000, 0x000000a7dfe4a9fd, },
    { 0x0000034bf636cc98, 0x00000638f62d6e95, 0x0000000000000000, 0x000000e8e49305df, 0x000007434a24f8d0, 0x000006f6eac5707e, 0x0000000000000000, 0x000001f1cf5c58ac, },
    { 0x0000003223789263, 0x000007cc4782c3c1, 0x0000000000000000, 0x000007e5a57a58ac, 0x000000661794f1bc, 0x0000005b81fa5b05, 0x0000000000000000, 0x00000078637c366d, },
  },
  // compressed: 0x7242cbf993bc68c198dbcec71f71b8ae7a8dac34aa520e7fbb557d7e09c1ce41
  {
    { 0x0000064d08948aee, 0x00000493f9cb4272, 0x0000000000000001, 0x000001d7a26d808a, 0x000006d7535650ac, 0x000001551a5646bd, 0x0000000000000000, 0x000001b66dd0ef93, },
    { 0x000007438df61e90, 0x000001db73182d17, 0x0000000000000000, 0x000003c2adbef2c3, 0x0000062d4bb7975c, 0x000007d55bb7f0e5, 0x0000000000000000, 0x0000028777d73d7c, },
    { 0x0000001f7067ba46, 0x000002bae1c47f1f, 0x0000000000000000, 0x000006ec7f527876, 0x0000006616c22684, 0x000000839d8212fc, 0x0000000000000000, 0x0000004d6899b23e, },
  },
  },
  { // 30
  // compressed: 0x8303736293f2b7e12c8acaebff79524b1413d4bf8a77fcda0f61729c1410ebfd
  {
    { 0x000000478f387475, 0x0000029362730383, 0x0000000000000001, 0x0000076a8766ee7a, 0x000001226ccf902a, 0x000003c55fea098a, 0x0000000000000000, 0x0000009c0785f25a, },
    { 0x000007d9678a3e09, 0x00000151459c36fe, 0x0000000000000000, 0x00000279a1d96c55, 0x0000010a5d69aab1, 0x0000072610fdafc7, 0x0000000000000000, 0x000002ce2ea58800, },
    { 0x000006c976f3d272, 0x0000012d49e7ffaf, 0x0000000000000000, 0x0000059b2fb01155, 0x00000058e13cd838, 0x000000fbd6202938, 0x0000000000000000, 0x00000011cd1d3fec, },
  },
  // compressed: 0xf9f2b80ad5092d2fdf2359c58d21b9acb96c767326348f4af519f738d73bb1cc
  {
    { 0x0000000a4bc130ad, 0x000001d50ab8f2f9, 0x0000000000000001, 0x00000475e515b64a, 0x000006cc280544df, 0x0000021339bb365c, 0x0000000000000000, 0x0000009f9fba8da8, },
    { 0x0000017a938695aa, 0x000003247be5e5a1, 0x0000000000000000, 0x00000152071ef091, 0x000003a3b09a25c3, 0x000007719f54a8f3, 0x0000000000000000, 0x000002e2ee8c20d3, },
    { 0x00000234e36d24f4, 0x000006b2e4863715, 0x0000000000000000, 0x000002965406eb6d, 0x0000005e3e7f0fdd, 0x000000996277ae71, 0x0000000000000000, 0x0000003343c6a781, },
  },
  // compressed: 0xbdbd96d5cd7221b440fcee984345e093b50941b44753b19f34ae660299d36bf3
  {
    { 0x00000560bafa05c3, 0x000002cdd596bdbd, 0x0000000000000001, 0x000005509334b3b4, 0x0000038c606b3239, 0x000001a3da2084da, 0x0000000000000000, 0x00000798212e41ba, },
    { 0x000004abcc2fa38e, 0x000005df8816842e, 0x0000000000000000, 0x0000002cae70aa65, 0x000000c3486e3529, 0x0000066ae349fb15, 0x0000000000000000, 0x000007fab5ccc5f5, },
    { 0x000006cf8682831b, 0x0000064f81150e63, 0x0000000000000000, 0x0000051bf4452d82, 0x00000082a8d62384, 0x000000e6d7a73204, 0x0000000000000000, 0x00000082452b4570, },
  },
  // compressed: 0xc6ea93e26152652edbac332103925a846b990079cb75094680dd5a198dbb6087
  {
    { 0x00000388f57ed6e9, 0x00000261e293eac6, 0x0000000000000001, 0x00000217cde6818a, 0x00000109d9856939, 0x000002e5bc804cb5, 0x0000000000000000, 0x00000347a3656658, },
    { 0x0000071904a33933, 0x000006759b65ccaa, 0x0000000000000000, 0x00000534108827c3, 0x000002d2e345cee3, 0x000005add8046097, 0x0000000000000000, 0x000003ac5f22cbf2, },
    { 0x0000054e4f2c99b7, 0x000006116a480c84, 0x0000000000000000, 0x0000055c55b6a7b5, 0x00000029c2a7d76a, 0x0000000ec1771a32, 0x0000000000000000, 0x000000d6697d3786, },
  },
  // compressed: 0xd3f271656569fc117a730e5345e8c9c63550fed4a2e73ae30bd36d2eb6c7b901
  {
    { 0x000007643a78c0b2, 0x000001656571f2d3, 0x0000000000000001, 0x000005e55ac89d29, 0x0000062f24e0dad1, 0x000003d16a7f281a, 0x0000000000000000, 0x000007efe173b60f, },
    { 0x000005c04f9e7be5, 0x000001ce6f423f8d, 0x0000000000000000, 0x00000414ec71016a, 0x0000022dd2dec7d1, 0x000006dd30be33ae, 0x0000000000000000, 0x000004bade83d36e, },
    { 0x00000530fa5c7bc8, 0x0000071b27a1154c, 0x0000000000000000, 0x000004520c907d16, 0x0000004025831e12, 0x00000003738f6c5c, 0x0000000000000000, 0x000000115eb6f09c, },
  },
  // compressed: 0x4b2ccc89d21473e28d1787a211bde44bce6433fad628d5186e82d9afd5c123e4
  {
    { 0x000001dc881f2533, 0x000004d289cc2c4b, 0x0000000000000001, 0x000000d9edfcb36a, 0x000006fdb39a20fa, 0x0000046b7d19b267, 0x0000000000000000, 0x0000019c7cf2e9e6, },
    { 0x0000026476c50693, 0x000000e2f1bc4e62, 0x0000000000000000, 0x000000dcbf3990bf, 0x000003a168d897ad, 0x0000059826e18d52, 0x0000000000000000, 0x000003e2dcce49de, },
    { 0x00000274149769de, 0x0000012f92f4468a, 0x0000000000000000, 0x0000048af30a3cdd, 0x000000656f3ae22c, 0x000000c84783ab5f, 0x0000000000000000, 0x0000009014bdf782, },
  },
  // compressed: 0x1f22ce42e44c61b62839054ccc9d196e03be1cdca4b43f66068e1c69471db3a4
  {
    { 0x0000070b01622071, 0x000004e442ce221f, 0x0000000000000001, 0x000006edc015f8c3, 0x00000030f7ad55e6, 0x000002526e0e5f01, 0x0000000000000000, 0x00000309a7513c6b, },
    { 0x000003b5f8a16a3c, 0x000000a72516cc29, 0x0000000000000000, 0x00000527ef854a83, 0x0000037bf312c6bb, 0x000001c8e06663fb, 0x0000000000000000, 0x000005da094f0af6, },
    { 0x0000041ad4173e2c, 0x000005b866773130, 0x0000000000000000, 0x0000004693f9f9f1, 0x0000008f544ec019, 0x00000049663a8ed2, 0x0000000000000000, 0x000000a8b6b0ba29, },
  },
  // compressed: 0xe121b3e3d0e40462951eff287a63aa3b9ebd995bfdcf0c0b71d0c8643edc22cd
  {
    { 0x0000075ea0d43a0f, 0x000004d0e3b321e1, 0x0000000000000001, 0x00000589d63b5f39, 0x000001a66a3cf397, 0x000007feadccdecf, 0x0000000000000000, 0x000001694a9d7d02, },
    { 0x0000037dd7ccf7e4, 0x000007e3d2ac409c, 0x0000000000000000, 0x00000179ec3f968c, 0x000003a545442891, 0x0000048d0710b0cc, 0x0000000000000000, 0x00000371436febac, },
    { 0x000002b79a38d022, 0x000000eea98de8a3, 0x0000000000000000, 0x00000572b9a8fd5f, 0x0000001ec5f38665, 0x0000009a45b87cc9, 0x0000000000000000, 0x000000381f40346c, },
  },
  },
  { // 31
  // compressed: 0x506a938c0e2b0869b6c5dac135a0c9f934b6dfc4543eb76f40c12b1d9b4105c0
  {
    { 0x000004b622943dff, 0x0000030e8c936a50, 0x0000000000000001, 0x000006bdb9be82f0, 0x000007f9cbc0433c, 0x0000072a626fdb1a, 0x0000000000000000, 0x000007c88caa7d47, },
    { 0x000001f6741a58c0, 0x00000358b6cd2105, 0x0000000000000000, 0x000000959214007f, 0x000001ca6bf5d254, 0x000002bc1406fb73, 0x0000000000000000, 0x0000040ab42f8499, },
    { 0x000002f232fb3913, 0x000003e72680d707, 0x0000000000000000, 0x000000822706bce9, 0x0000001f46c29e76, 0x000000800a83363a, 0x0000000000000000, 0x0000003f744315de, },
  },
  // compressed: 0x94017b3e04573e4f7fafda08ee3e1da8f1dedc99abc639c8d56177ff135d536c
  {
    { 0x00000448fac8f53e, 0x000007043e7b0194, 0x0000000000000001, 0x000004e93e8a35af, 0x0000063eb615af00, 0x00000355ccee6f78, 0x0000000000000000, 0x0000063b794d5855, },
    { 0x000004c6e8356a92, 0x00000355efe9e7ca, 0x0000000000000000, 0x000000fd02c997a6, 0x00000486e4274fd6, 0x000007761d5c839c, 0x0000000000000000, 0x000000ac13b19319, },
    { 0x00000607dba269ee, 0x000006a074fbb823, 0x0000000000000000, 0x000004b81e051162, 0x000000725c759551, 0x000000d8a6ba27fe, 0x0000000000000000, 0x0000004bc2ffc9aa, },
  },
  // compressed: 0xa721f176f57f5f91e387cd2f27324ac326e51b4dde2fbacc9b8969898f82ba6b
  {
    { 0x000003d71e04f676, 0x000007f576f121a7, 0x0000000000000001, 0x0000046690fe3901, 0x000004581a348fd5, 0x000007ef268df293, 0x0000000000000000, 0x0000048a57c2306a, },
    { 0x00000041f2a14513, 0x000001b0fc722bef, 0x0000000000000000, 0x0000032f5abc5a37, 0x000001fb3515186d, 0x0000069899bccba2, 0x0000000000000000, 0x000006b7be4971d6, },
    { 0x0000048238714b59, 0x0000030d28c89cbf, 0x0000000000000000, 0x00000132d5286282, 0x0000004aaea28855, 0x000000d775051f12, 0x0000000000000000, 0x000000ab3aa09efe, },
  },
  // compressed: 0xfd66d2f6e791489c1b7807039ba144073be261601d8f38880ed54b35a3a63e92
  {
    { 0x00000378b3eb54d5, 0x000001e7f6d266fd, 0x0000000000000001, 0x0000009041e32d96, 0x000007b17c94005d, 0x0000078eb030f11d, 0x0000000000000000, 0x00000138ec1922ec, },
    { 0x000002a78f94ee70, 0x000000ef03738912, 0x0000000000000000, 0x0000062b090231a3, 0x000007e32170a26c, 0x000004bd50e88388, 0x0000000000000000, 0x0000018a1541eab4, },
    { 0x00000075a74d9a95, 0x0000041d12866c0c, 0x0000000000000000, 0x000006e7b78f0b60, 0x000000035625ab00, 0x000000247d4d466a, 0x0000000000000000, 0x0000009472c3c592, },
  },
  // compressed: 0x1e3f23f344d6270316f0fc340e269a4979b9daf216a7b5831f11d49badeeac68
  {
    { 0x000003e0f8e6bba0, 0x00000644f3233f1e, 0x0000000000000001, 0x0000010ef3d7c210, 0x0000012ff09d23b5, 0x0000038b796d5cbc, 0x0000000000000000, 0x000004f8dbf39f11, },
    { 0x000007fc614e3b87, 0x0000079e02c064fa, 0x0000000000000000, 0x000005a081871699, 0x000001db763a9924, 0x0000054111f83b5a, 0x0000000000000000, 0x0000008f5973860d, },
    { 0x0000035b3be0d1fb, 0x00000526689838d3, 0x0000000000000000, 0x000004c239b892de, 0x00000059ad79c7f6, 0x000000d159dd5b37, 0x0000000000000000, 0x000000b2aec1ab6a, },
  },
  // compressed: 0x902702fdebcb2a88605711c40533af89f473347de392f4652b5a5154dfc5b2ac
  {
    { 0x000007e104aa6397, 0x000003ebfd022790, 0x0000000000000001, 0x0000058c63fd2aca, 0x00000044bec84a2c, 0x00000171be9a39fa, 0x0000000000000000, 0x000001b77c65d81d, },
    { 0x000004ff996c2537, 0x0000022aec110559, 0x0000000000000000, 0x00000529dffd614b, 0x000003291a93f8bc, 0x00000515a2b65f49, 0x0000000000000000, 0x0000048131f2723f, },
    { 0x0000023e58002292, 0x00000226bccc1710, 0x0000000000000000, 0x00000348af0598b9, 0x000000e13f487db9, 0x00000059658bbea8, 0x0000000000000000, 0x000000e1e053d9e1, },
  },
  // compressed: 0xb9b0105eaaaf6a2aa91a04ef70a3f0781fd63aaa77fb3e77e1d94ba7a2a5ecc4
  {
    { 0x000007b32eed3e33, 0x000007aa5e10b0b9, 0x0000000000000001, 0x000000327b95d543, 0x000004e98caf81b3, 0x000005bbd51d6b0f, 0x0000000000000000, 0x0000018e3070e295, },
    { 0x000002b03ce8c260, 0x0000008355254d55, 0x0000000000000000, 0x00000681e3a4ba89, 0x00000314858c9444, 0x000004bd9e1773ef, 0x0000000000000000, 0x000007de9e4de1c5, },
    { 0x000002b810bcce91, 0x000005e3c28dc3bc, 0x0000000000000000, 0x000005c34e0c028c, 0x00000016fabb14d8, 0x00000089d94b454e, 0x0000000000000000, 0x0000004e4448a258, },
  },
  // compressed: 0xfc75a9428abb7bbf58a3ad9677395c8c48aaedcd6fc77fe2a620bcf6d75f7319
  {
    { 0x000002af49c5342e, 0x0000038a42a975fc, 0x0000000000000001, 0x000000d042c84266, 0x00000646fe642714, 0x000003b7e6f6d524, 0x0000000000000000, 0x000000e832d24bdc, },
    { 0x000004df5a035792, 0x000005b46b17ef77, 0x0000000000000000, 0x0000032a8fdc7572, 0x000004cc543efa28, 0x000003c20a6e27fc, 0x0000000000000000, 0x000005f895f2503a, },
    { 0x000007ffbb6046cb, 0x0000023170e5de5a, 0x0000000000000000, 0x000007ae12383dfc, 0x000000236bbe3148, 0x00000032e6bfafed, 0x0000000000000000, 0x0000001fdf222323, },
  },
  },
};

