XDP system installation
=======================

Installation guide for `XDP`/`AF_XDP` based networking.

Prerequisites
-------------

This guide assumes the steps in [getting-started.md](./getting-started.md)
have been completed.

Requires recent Linux kernel and headers (version >=4.18). `XDP` and related
technologies are being actively developed and usually have noticeable
improvements in the most recent kernels (>=6.2).

Introduction to `XDP` and `AF_XDP`
------------------------------

**What sysadmins should know:**

`XDP` and `AF_XDP` are Linux kernel technologies for fast userspace
networking.  They present an alternative to `send`/`recv` sockets-based
networking that are generally more efficient and expose lower-level
properties of your hardware to the Firedancer application.

Despite their similar names, there is an important distinction in the
purpose of `XDP` vs `AF_XDP`:
- `XDP` is a facility to redirect traffic away from regular kernel networking.
- `AF_XDP` is a mechanism for traffic forwarding between
the kernel and userland.

So to put the two together, we install an `XDP` program to intercept all
incoming traffic on a network interface. This program filters out all
traffic targeted at Firedancer and sends it to `AF_XDP`. Firedancer then
reads incoming packets from `AF_XDP`. Packets going out from Firedancer
get sent back to `AF_XDP`, which forwards directly to the driver (skipping
`XDP`).

```
  ┌─────┐  ┌────────┐  ┌─────┐ XDP_PASS ┌─────────┐
  │ NIC <──> Driver ├──> XDP ├──────────> sockets │
  └─────┘  └───▲────┘  └─┬───┘          └─────────┘
               │         │
               │         │ XDP_REDIRECT
               │         │
               │      ┌──▼────────┐      ┌────────────┐
               │      │ AF_XDP RX ├──────> Firedancer │
               │      └───────────┘      └─────┬──────┘
               │      ┌───────────┐            │
               └──────┤ AF_XDP TX <────────────┘
                      └───────────┘
```

See also [fd_xsk.h](../src/tango/xdp/fd_xsk.h)

`XDP` and `AF_XDP` require the `CAP_SYS_ADMIN` and `CAP_NET_ADMIN`
capabilities for configuration.  `CAP_SYS_ADMIN` is also required at
runtime, but this capability is dropped by sandboxing code once the
socket has been configured.

XDP installation
----------------

### Preparation

Confirm your kernel release version.

```bash
$ uname -sr
Linux 4.18.0-348.23.1.el8_5.x86_64
```
