﻿<%@ Control Language="C#" Inherits="System.Web.Mvc.ViewUserControl<IEnumerable<MvcEnterprise.Models.DataSet1+ArticleRow>>" %>
<%
	string viewType=ViewData["ViewType"].ToString();
	string viewName = ViewData["ViewName"].ToString();
	if (viewName.ToLower() == "articleview") viewName = string.Empty;
	var items = Model;
	if (viewType == "OneImgAndList" || viewType == "List")
	{
		if (viewType == "OneImgAndList")
		{
			var imgItem = items.FirstOrDefault(m => !string.IsNullOrEmpty(m.SmallPic));
			if (imgItem != null)
			{
				items = items.SkipWhile(m => m == imgItem);
%>
<div class="OneImgAndList">
	<a title="<%= imgItem.ArticleName %>" href='<%= Url.Action("ArticleView",new {ID = imgItem.ID, viewName = viewName}) %>'>
		<img src="<%= imgItem.SmallPic %>" alt="<%= Html.Encode(imgItem.ArticleName) %>" class="OneImgAndListSmallImg" /></a>
	<p style="_width: 99%; font-weight: bold" class="ellipsis"><a class="ellipsis" title="<%= imgItem.ArticleName %>"
		href='<%= Url.Action("ArticleView",new {ID = imgItem.ID, viewName = viewName}) %>'><%= imgItem.ArticleName%></a>
	</p>
	<p style="word-wrap: break-word; word-break: break-all"><%= imgItem.Content.StripHTML().Trim().Substr(0, 60)%>...
	</p>
</div>
<%
			}
		}
%>
<ul class="ListTitle">
	<%foreach (var item in items)
   {%>
	<li><a href='<%= Url.Action("ArticleView",new {ID = item.ID, viewName = viewName}) %>' title='<%= item.ArticleName %>'>
		<%= item.ArticleName %></a>&emsp;</li>
	<%}%>
</ul>
	<%
	}
	else if (viewType == "Img")
	{
%>
<div style="height: 5px; overflow: hidden"></div>
<ul class="Article">
	<%foreach (var item in items)
   {%>
	<li>
		<div class="prodImg">
			<a href="<%= Url.Action("ArticleView",new {ID = item.ID, viewName = viewName}) %>" title="<%= item.ArticleName %>">
				<img alt="<%= Html.Encode(item.ArticleName) %>" src="<%= item.SmallPic %>" /></a>
		</div>
		<div class="prodName">
			<a href="<%= Url.Action("ArticleView",new {ID = item.ID, viewName = viewName}) %>" title="<%= item.ArticleName %>">
				<%= item.ArticleName %> </a>
		</div>
	</li>
	<%}%>
</ul>
<br class="clearfloat" />
<%
	}
%>
