<?php

/**
 * @copyright Copyright (C) 2015-2017 AIZAWA Hina
 * @license https://github.com/fetus-hina/stat.ink/blob/master/LICENSE MIT
 * @author AIZAWA Hina <hina@fetus.jp>
 */

namespace app\models;

use yii\db\ActiveQuery;
use yii\db\ActiveRecord;

/**
 * This is the model class for table "schedule_map2".
 *
 * @property integer $schedule_id
 * @property integer $map_id
 *
 * @property Map2 $map
 * @property Schedule2 $schedule
 */
class ScheduleMap2 extends ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'schedule_map2';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['schedule_id', 'map_id'], 'required'],
            [['schedule_id', 'map_id'], 'integer'],
            [['map_id'], 'exist', 'skipOnError' => true,
                'targetClass' => Map2::class,
                'targetAttribute' => ['map_id' => 'id'],
            ],
            [['schedule_id'], 'exist', 'skipOnError' => true,
                'targetClass' => Schedule2::class,
                'targetAttribute' => ['schedule_id' => 'id'],
            ],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'schedule_id' => 'Schedule ID',
            'map_id' => 'Map ID',
        ];
    }

    /**
     * @return ActiveQuery
     */
    public function getMap()
    {
        return $this->hasOne(Map2::class, ['id' => 'map_id']);
    }

    /**
     * @return ActiveQuery
     */
    public function getSchedule()
    {
        return $this->hasOne(Schedule2::class, ['id' => 'schedule_id']);
    }
}
