<?php

/**
 * @copyright Copyright (C) 2015-2023 AIZAWA Hina
 * @license https://github.com/fetus-hina/stat.ink/blob/master/LICENSE MIT
 * @author AIZAWA Hina <hina@fetus.jp>
 */

declare(strict_types=1);

use app\components\db\Migration;
use yii\db\Connection;

final class m230205_000149_medal3_canonical extends Migration
{
    /**
     * @inheritdoc
     */
    public function safeUp()
    {
        $this->addColumn(
            '{{%medal3}}',
            'canonical_id',
            (string)$this->pkRef('{{%medal_canonical3}}')->null(),
        );

        $this->execute($this->createInsertSQL());

        return true;
    }

    /**
     * @inheritdoc
     */
    public function safeDown()
    {
        $this->dropColumn('{{%medal3}}', 'canonical_id');

        return true;
    }

    /**
     * @inheritdoc
     */
    protected function vacuumTables(): array
    {
        return [
            '{{%medal3}}',
        ];
    }

    private function createInsertSQL(): string
    {
        $db = $this->db;
        assert($db instanceof Connection);

        $insertDataList = [];
        foreach ($this->getData() as $key => $textList) {
            $canonicalId = $this->key2id('{{%medal_canonical3}}', $key);
            foreach ($textList as $t) {
                $insertDataList[] = sprintf('(%s, %d)', $db->quoteValue($t), $canonicalId);
            }
        }

        return vsprintf('INSERT INTO %s ( %s ) VALUES %s ON CONFLICT ON CONSTRAINT medal3_name_key DO UPDATE SET %s', [
            $db->quoteTableName('{{%medal3}}'),
            implode(
                ', ',
                array_map(
                    fn (string $c): string => $db->quoteColumnName($c),
                    ['name', 'canonical_id'],
                ),
            ),
            implode(', ', $insertDataList),
            vsprintf('%2$s = %1$s.%2$s', [
                $db->quoteTableName('excluded'),
                $db->quoteColumnName('canonical_id'),
            ]),
        ]);
    }

    /**
     * @return array<string, string[]>
     */
    private function getData(): array
    {
        return [
            'base_defender_no_1' => [
                '#1 Base Defender',
                '1. Platz: Basisverteidiger',
                'Baluardo nº 1',
                'Basis verdedigd: nr. 1',
                'N.º 1 en defender la base',
                'Защитник базы № 1',
                '№ 1 en défense de la base',
                'ホーム防衛 No.1',
                '本阵防守 No.1',
                '本陣防守 No.1',
                '홈 방어 No.1',
            ],
            'big_bubbler_user_no_1' => [
                '#1 Big Bubbler User',
                '1. Platz: Kugelschild Pro',
                'Gran bolla scudo: asso nº 1',
                'Joekelschild gebruikt: nr. 1',
                'N.º 1 en megaburbuja',
                'Мастер шарощита',
                '№ 1 du super bouclier',
                '№ 1 du Super bouclier',
                'グレートバリア No.1',
                '巨大防护罩 No.1',
                '巨大防護罩 No.1',
                '그레이트 배리어 No.1',
            ],
            'booyah_bomb_user_no_1' => [
                '#1 Booyah Bomb User',
                '1. Platz: Cool-Kugel',
                'Coole bom gebruikt: nr. 1',
                'Granbotto: asso nº 1',
                'N.º 1 en bola genializante',
                'Мастер йо-хо-плюхера',
                "№ 1 de l'Excellinator",
                '№ 1 du jolizator',
                'ナイスダマ No.1',
                '讚氣彈 No.1',
                '赞气弹 No.1',
                '나이스옥 No.1',
            ],
            'checkpoint_breaker_no_1' => [
                '#1 Checkpoint Breaker',
                '1. Platz: Wegbereiter',
                'Apricheckpoint nº 1',
                'Checkpoint bereikt: nr. 1',
                'N.º 1 en superar controles',
                'Таран № 1',
                '№ 1 du point de contrôle',
                'カンモン突破 No.1',
                '关卡突破 No.1',
                '關卡突破 No.1',
                '관문 돌파 No.1',
            ],
            'clam_carrier_no_1' => [
                '#1 Clam Carrier',
                '1. Platz: Muschel-Transport',
                'N.º 1 en portar almejas',
                'Portavongole nº 1',
                'Schelpen gedragen: nr. 1',
                'Устроносчик № 1',
                '№ 1 en transport de palourdes',
                'ガチアサリ運んだ時間 No.1',
                '真格蛤蜊运送时间 No.1',
                '真格蛤蜊運送時間 No.1',
                '랭크 바지락 운반 시간 No.1',
            ],
            'clam_stopper_no_1' => [
                '#1 Clam Stopper',
                '1. Platz: Muschelstopper',
                'Fermavongole nº 1',
                'N.º 1 en frenar almejas',
                'N.º 1 en parar almejas',
                'Schelpen gestopt: nr. 1',
                'Устростоппер № 1',
                '№ 1 en arrêt de palourde',
                'ガチアサリブロック No.1',
                '真格蛤蜊拦截 No.1',
                '真格蛤蜊攔截 No.1',
                '랭크 바지락 저지 No.1',
            ],
            'crab_tank_user_no_1' => [
                '#1 Crab Tank User',
                '1. Platz: Krabbenpanzer',
                'Granchio armato: asso nº 1',
                'Krabbentank gebruikt: nr. 1',
                'N.º 1 en cangrejobot',
                'Мастер кработанка',
                "№ 1 du crabe d'assaut",
                "№ 1 du Crabe d'assaut",
                'カニタンク No.1',
                '螃蟹坦克 No.1',
                '크랩 탱크 No.1',
            ],
            'damage_taker_no_1' => [
                '#1 Damage Taker',
                '1. Platz: Schaden eingesteckt',
                'Assorbidanni nº 1',
                'N.º 1 en daño soportado',
                'Schade opgelopen: nr. 1',
                'Магнит урона № 1',
                '№ 1 des dégâts subis',
                '承受伤害 No.1',
                '耐えたダメージ No.1',
                '耐受傷害 No.1',
                '버틴 대미지 No.1',
            ],
            'enemy_base_inker_no_1' => [
                '#1 Enemy-Base Inker',
                '1. Platz: Gegnerstart gefärbt',
                'Inchiostratraguardo nº 1',
                'N.º 1 en entintar en lado rival',
                'Vijandelijke basis geverfd: nr. 1',
                'Заливщик на передовой № 1',
                "№ 1 en encrage chez l'adversaire",
                'アウェイ塗り No.1',
                '敌阵涂墨 No.1',
                '敵陣塗墨 No.1',
                '어웨이 색칠 No.1',
            ],
            'enemy_splatter_no_1' => [
                '#1 Enemy Splatter',
                '1. Platz: Meiste Abschüsse',
                'N.º 1 en liquidar rivales',
                'N.º 1 en reventar rivales',
                'Splattanemici nº 1',
                'Vijanden uitgeschakeld: nr. 1',
                'Плюхоспец № 1',
                '№ 1 pour liquider',
                'トドメ数 No.1',
                '击倒数 No.1',
                '擊倒數 No.1',
                '마무리 횟수 No.1',
            ],
            'ground_traveler_no_1' => [
                '#1 Ground Traveler',
                '1. Platz: Distanzläufer',
                'Afstand afgelegd: nr. 1',
                'Maratoneta nº 1',
                'N.º 1 en distancia recorrida',
                'Марафонец № 1',
                '№ 1 de la distance parcourue',
                '移动距离 No.1',
                '移動距離 No.1',
                '이동 거리 No.1',
            ],
            'home_base_inker_no_1' => [
                '#1 Home-Base Inker',
                '1. Platz: Team-Start gefärbt',
                'Basis geverfd: nr. 1',
                'Inchiostrabase nº 1',
                'N.º 1 en entintar en lado propio',
                'Заливщик в тылу № 1',
                '№ 1 en encrage à domicile',
                'ホーム塗り No.1',
                '本阵涂墨 No.1',
                '本陣塗墨 No.1',
                '홈 색칠 No.1',
            ],
            'ink_consumer_no_1' => [
                '#1 Ink Consumer',
                '1. Platz: Tintenverbrauch',
                'Consumainchiostro nº 1',
                'Inkt gebruikt: nr. 1',
                'N.º 1 en consumo de tinta',
                'N.º 1 en recargar tinta',
                'Краскострел № 1',
                "№ 1 en consommation d'encre",
                'インク消費量 No.1',
                '墨汁消耗量 No.1',
                '잉크 소비량 No.1',
            ],
            'inkjet_user_no_1' => [
                '#1 Inkjet User',
                '1. Platz: Tintendüser',
                'Inktjet gebruikt: nr. 1',
                'Jet splat: asso nº 1',
                'N.º 1 en propulsor',
                'Мастер красколета',
                '№ 1 du chromo-jet',
                '№ 1 du Chromo-jet',
                'ジェットパック No.1',
                '喷射背包 No.1',
                '噴射背包 No.1',
                '제트 팩 No.1',
            ],
            'ink_storm_user_no_1' => [
                '#1 Ink Storm User',
                '1. Platz: Tintenschauer',
                'N.º 1 en atormentador',
                'Pioggia di colore: asso nº 1',
                'Spetterbui gebruikt: nr. 1',
                'Мастер тучи краски',
                "№ 1 de la pluie d'encre",
                "№ 1 de la Pluie d'encre",
                'アメフラシ No.1',
                '墨雨云 No.1',
                '墨雨雲 No.1',
                '먹구름 No.1',
            ],
            'ink_vac_user_no_1' => [
                '#1 Ink Vac User',
                '1. Platz: Tintegrator',
                'Inktdief gebruikt: nr. 1',
                'N.º 1 en aspiratinta',
                'Vampinchiostro: asso nº 1',
                'Мастер краскососа',
                "№ 1 de l'aspirencre",
                "№ 1 de l'Aspirencre",
                'キューインキ No.1',
                '吸墨机 No.1',
                '吸墨機 No.1',
                '흡입기 No.1',
            ],
            'killer_wail_5_1_user_no_1' => [
                '#1 Killer Wail 5.1 User',
                '1. Platz: Heulboje 5.1',
                'Megalofoon 5.1 gebruikt: nr. 1',
                'N.º 1 en berreón 5.1',
                'N.º 1 en tintófono 5.1',
                'Tintofono 5.1: asso nº 1',
                'Мастер мегалофона 5.1',
                '№ 1 du haut-perceur 5.1',
                '№ 1 du Laser perçant 5.1',
                'メガホンレーザー5.1ch No.1',
                '喇叭镭射5.1ch No.1',
                '喇叭雷射5.1ch No.1',
                '메가폰 레이저 5.1ch No.1',
            ],
            'overall_splatter_no_1' => [
                '#1 Overall Splatter',
                '1. Platz: Gesamtleistung',
                'Algemeen: nr. 1',
                'N.º 1 en combate',
                'Splattatutto nº 1',
                'Плюхатор № 1',
                '№ 1 au combat',
                'バトル No.1',
                '对战 No.1',
                '對戰 No.1',
                '배틀 No.1',
            ],
            'popular_target_no_1' => [
                '#1 Popular Target',
                '1. Platz: Beliebtes Ziel',
                'Bersaglio facile nº 1',
                'Cible privilégiée № 1',
                'Geliefd doelwit: nr. 1',
                'N.º 1 en atraer atención',
                'Цель № 1',
                '夺目时间 No.1',
                '奪目時間 No.1',
                '注目された時間 No.1',
                '주목받은 시간 No.1',
            ],
            'rainmaker_carrier_no_1' => [
                '#1 Rainmaker Carrier',
                '1. Platz: Goldfischträger',
                'Bazookarper gedragen: nr. 1',
                'N.º 1 en portar el pez dorado',
                'Portabazookarp nº 1',
                'Хранитель мегакарпа № 1',
                '№ 1 en transport de Bazookarpe',
                'ガチホコ運んだ時間 No.1',
                '真格魚虎運送時間 No.1',
                '真格鱼虎运送时间 No.1',
                '랭크 피시 운반 시간 No.1',
            ],
            'rainmaker_stopper_no_1' => [
                '#1 Rainmaker Stopper',
                '1. Platz: Goldfischstopper',
                'Bazookarper gestopt: nr. 1',
                'Fermabazookarp nº 1',
                'N.º 1 en frenar el pez dorado',
                'N.º 1 en parar el pez dorado',
                'Мегакарп-стоппер № 1',
                '№ 1 en arrêt de Bazookarpe',
                'ガチホコブロック No.1',
                '真格魚虎攔截 No.1',
                '真格鱼虎拦截 No.1',
                '랭크 피시 저지 No.1',
            ],
            'reefslider_user_no_1' => [
                '#1 Reefslider User',
                '1. Platz: Haihammer',
                'Motosqualo: asso nº 1',
                'N.º 1 en flotiburón',
                'Opblaashaai gebruikt: nr. 1',
                'Мастер мотокулы',
                '№ 1 du cavalsquale',
                '№ 1 du Cavalsquale',
                'サメライド No.1',
                '鯊魚坐騎 No.1',
                '鲨鱼坐骑 No.1',
                '샤크 라이드 No.1',
            ],
            'score_booster_no_1' => [
                '#1 Score Booster',
                '1. Platz: Zähler-Fortschritt',
                'Asso della distanza nº 1',
                'N.º 1 en aumento de contador',
                'N.º 1 en avanzar el contador',
                'Scorebijdrage: nr. 1',
                'Башневоз № 1',
                '№ 1 en progression',
                'カウント進行 No.1',
                '計數推進 No.1',
                '计数推进 No.1',
                '카운트 진행 No.1',
            ],
            'splat_assister_no_1' => [
                '#1 Splat Assister',
                '1. Platz: Abschuss-Assistenz',
                'Geholpen bij uitschakeling: nr. 1',
                'N.º 1 en apoyo en combate',
                'N.º 1 en ayuda',
                'Splattassistente nº 1',
                'Плюх-соратник № 1',
                '№ 1 du coup de main',
                'アシスト数 No.1',
                '助攻数 No.1',
                '助攻數 No.1',
                '어시스트 횟수 No.1',
            ],
            'splat_zone_guard_no_1' => [
                '#1 Splat Zone Guard',
                '1. Platz: Splatterzonen gehalten',
                'Guardia zona splat nº 1',
                'N.º 1 en defender la zona',
                'N.º 1 en defender territorio',
                'Spetterzone verdedigd: nr. 1',
                'Защитник зоны контроля № 1',
                '№ 1 en Défense de zone',
                '№ 1 en défense de zone',
                'ガチエリア前線キープ No.1',
                '真格区域前线把控 No.1',
                '真格區域前線把控 No.1',
                '랭크 에어리어 전선 유지 No.1',
            ],
            'splat_zone_hero_no_1' => [
                '#1 Splat Zone Hero',
                '1. Platz: Splatterzonen-Held',
                'Idolo della zona splat nº 1',
                'N.º 1 en dominar la zona',
                'N.º 1 en pintazonas',
                'Spetterzonekanjer: nr. 1',
                'Звезда зоны контроля № 1',
                '№ 1 en héroïsme de zone',
                'ガチエリア関与 No.1',
                '真格区域干涉 No.1',
                '真格區域干涉 No.1',
                '랭크 에어리어 관여 No.1',
            ],
            'splat_zone_inker_no_1' => [
                '#1 Splat Zone Inker',
                '1. Platz: Splatterzonen gefärbt',
                'Attaccante zona splat nº 1',
                'N.º 1 en entintar la zona',
                'N.º 1 en ganar territorio',
                'Spetterzone geverfd: nr. 1',
                'Хозяин зоны контроля № 1',
                '№ 1 en encrage de zone',
                'ガチエリア塗り No.1',
                '真格区域涂墨 No.1',
                '真格區域塗墨 No.1',
                '랭크 에어리어 색칠 No.1',
            ],
            'super_jump_spot_no_1' => [
                '#1 Super Jump Spot',
                '1. Platz: Supersprung-Ziel',
                'Doel van supersprongen: nr. 1',
                'N.º 1 en atraer supersaltos',
                'Obiettivo super salto nº 1',
                'Навигатор суперпрыжков № 1',
                '№ 1 du super saut',
                '同伴跳跃目标 No.1',
                '同伴跳躍目標 No.1',
                '味方のジャンプ先 No.1',
                '아군의 집결지 No.1',
            ],
            'tacticooler_user_no_1' => [
                '#1 Tacticooler User',
                '1. Platz: Tranktank',
                'N.º 1 en dispensabebidas',
                'Reddingsbar gebruikt: nr. 1',
                'Rinfrigorente: asso nº 1',
                'Мастер тоникулера',
                '№ 1 du districool',
                '№ 1 du Districool',
                'エナジースタンド No.1',
                '能量站 No.1',
                '에너지 스탠드 No.1',
            ],
            'tenta_missiles_user_no_1' => [
                '#1 Tenta Missiles User',
                '1. Platz: Schwarmraketen',
                'Lanciarazzi: asso nº 1',
                'N.º 1 en lanzamisiles',
                'Spetterraketten gebruikt: nr. 1',
                'Мастер каракатницы',
                '№ 1 du multi-missile',
                '№ 1 du Multi-missile',
                'マルチミサイル No.1',
                '多重导弹 No.1',
                '多重導彈 No.1',
                '멀티 미사일 No.1',
            ],
            'tower_stopper_no_1' => [
                '#1 Tower Stopper',
                '1. Platz: Turm angehalten',
                'Fermatorre nº 1',
                'N.º 1 en frenar la torre',
                'N.º 1 en parar la torre',
                'Toren verdedigd: nr. 1',
                'Блокировщик башни № 1',
                '№ 1 en arrêt de la plateforme',
                '№ 1 en arrêt du stand',
                'ガチヤグラブロック No.1',
                '真格塔楼拦截 No.1',
                '真格塔樓攔截 No.1',
                '랭크 타워 저지 No.1',
            ],
            'triple_inkstrike_user_no_1' => [
                '#1 Triple Inkstrike User',
                '1. Platz: Tri-Tintferno',
                'N.º 1 en tornado triple',
                'Tri-tornado gebruikt: nr. 1',
                'Triplo tornado: asso nº 1',
                'Мастер тройного торнадо',
                '№ 1 du trimissile tornade',
                '№ 1 du Trimissile tornade',
                'トリプルトルネード No.1',
                '三重龍捲風 No.1',
                '三重龙卷风 No.1',
                '트리플 토네이도 No.1',
            ],
            'trizooka_user_no_1' => [
                '#1 Trizooka User',
                '1. Platz: Trizooka',
                'N.º 1 en cañón triple',
                'N.º 1 en tintazuca triple',
                'Trizooka gebruikt: nr. 1',
                'Ultraturbinator: asso nº 1',
                'Мастер «Трезубца»',
                '№ 1 du lance-rafales',
                '№ 1 du Lance-tornades',
                'ウルトラショット No.1',
                '終極發射 No.1',
                '终极发射 No.1',
                '울트라 샷 No.1',
            ],
            'turf_inker_no_1' => [
                '#1 Turf Inker',
                '1. Platz: Revier gefärbt',
                'Grond geverfd: nr. 1',
                'Inchiostratutto nº 1',
                'N.º 1 en entintar',
                'N.º 1 en entintar territorio',
                'Заливщик № 1',
                '№ 1 en encrage de territoire',
                '塗りポイント No.1',
                '塗墨點數 No.1',
                '涂墨点数 No.1',
                '색칠 포인트 No.1',
            ],
            'ultra_stamp_user_no_1' => [
                '#1 Ultra Stamp User',
                '1. Platz: Ultra-Stempel',
                'Mega timbro: asso nº 1',
                'N.º 1 en ultraselladora',
                'Ultrastempel gebruikt: nr. 1',
                'Мастер припечати',
                "№ 1 de l'ultra-tamponneur",
                "№ 1 de l'Ultra-étampeur",
                'ウルトラハンコ No.1',
                '終極印章 No.1',
                '终极印章 No.1',
                '울트라 스탬프 No.1',
            ],
            'wave_breaker_user_no_1' => [
                '#1 Wave Breaker User',
                '1. Platz: Schauerwelle',
                'Golfbeker gebruikt: nr. 1',
                'N.º 1 en emiteondas',
                'Sonar esplosivo: asso nº 1',
                'Мастер волноплюхера',
                '№ 1 du sonar paf',
                '№ 1 du Sonar paf',
                'ホップソナー No.1',
                '弹跳声呐 No.1',
                '彈跳聲納 No.1',
                '홉 소나 No.1',
            ],
            'zipcaster_user_no_1' => [
                '#1 Zipcaster User',
                '1. Platz: Haftsprung',
                'Molluscatto: asso nº 1',
                'N.º 1 en gancho tentacular',
                'Tentakabel gebruikt: nr. 1',
                'Мастер краскотроса',
                '№ 1 du Super Mollusque',
                'ショクワンダー No.1',
                '触手喷射 No.1',
                '觸手噴射 No.1',
                '쇼크 원더 No.1',
            ],
            'clam_carrier_no_2' => [
                '#2 Clam Carrier',
                '2. Platz: Muschel-Transport',
                'N.º 2 en portar almejas',
                'Portavongole nº 2',
                'Schelpen gedragen: nr. 2',
                'Устроносчик № 2',
                '№ 2 en transport de palourdes',
                'ガチアサリ運んだ時間 No.2',
                '真格蛤蜊运送时间 No.2',
                '真格蛤蜊運送時間 No.2',
                '랭크 바지락 운반 시간 No.2',
            ],
            'enemy_base_inker_no_2' => [
                '#2 Enemy-Base Inker',
                '2. Platz: Gegnerstart gefärbt',
                'Inchiostratraguardo nº 2',
                'N.º 2 en entintar en lado rival',
                'Vijandelijke basis geverfd: nr. 2',
                'Заливщик на передовой № 2',
                "№ 2 en encrage chez l'adversaire",
                'アウェイ塗り No.2',
                '敌阵涂墨 No.2',
                '敵陣塗墨 No.2',
                '어웨이 색칠 No.2',
            ],
            'enemy_splatter_no_2' => [
                '#2 Enemy Splatter',
                '2. Platz: Meiste Abschüsse',
                'N.º 2 en liquidar rivales',
                'N.º 2 en reventar rivales',
                'Splattanemici nº 2',
                'Vijanden uitgeschakeld: nr. 2',
                'Плюхоспец № 2',
                '№ 2 pour liquider',
                'トドメ数 No.2',
                '击倒数 No.2',
                '擊倒數 No.2',
                '마무리 횟수 No.2',
            ],
            'home_base_inker_no_2' => [
                '#2 Home-Base Inker',
                '2. Platz: Team-Start gefärbt',
                'Basis geverfd: nr. 2',
                'Inchiostrabase nº 2',
                'N.º 2 en entintar en lado propio',
                'Заливщик в тылу № 2',
                '№ 2 en encrage à domicile',
                'ホーム塗り No.2',
                '本阵涂墨 No.2',
                '本陣塗墨 No.2',
                '홈 색칠 No.2',
            ],
            'overall_splatter_no_2' => [
                '#2 Overall Splatter',
                '2. Platz: Gesamtleistung',
                'Algemeen: nr. 2',
                'N.º 2 en combate',
                'Splattatutto nº 2',
                'Плюхатор № 2',
                '№ 2 au combat',
                'バトル No.2',
                '对战 No.2',
                '對戰 No.2',
                '배틀 No.2',
            ],
            'popular_target_no_2' => [
                '#2 Popular Target',
                '2. Platz: Beliebtes Ziel',
                'Bersaglio facile nº 2',
                'Cible privilégiée № 2',
                'Geliefd doelwit: nr. 2',
                'N.º 2 en atraer atención',
                'Цель № 2',
                '夺目时间 No.2',
                '奪目時間 No.2',
                '注目された時間 No.2',
                '주목받은 시간 No.2',
            ],
            'score_booster_no_2' => [
                '#2 Score Booster',
                '2. Platz: Zähler-Fortschritt',
                'Asso della distanza nº 2',
                'N.º 2 en aumento de contador',
                'N.º 2 en avanzar el contador',
                'Scorebijdrage: nr. 2',
                'Башневоз № 2',
                '№ 2 en progression',
                'カウント進行 No.2',
                '計數推進 No.2',
                '计数推进 No.2',
                '카운트 진행 No.2',
            ],
            'splat_assister_no_2' => [
                '#2 Splat Assister',
                '2. Platz: Abschuss-Assistenz',
                'Geholpen bij uitschakeling: nr. 2',
                'N.º 2 en apoyo en combate',
                'N.º 2 en ayuda',
                'Splattassistente nº 2',
                'Плюх-соратник № 2',
                '№ 2 du coup de main',
                'アシスト数 No.2',
                '助攻数 No.2',
                '助攻數 No.2',
                '어시스트 횟수 No.2',
            ],
            'splat_zone_guard_no_2' => [
                '#2 Splat Zone Guard',
                '2. Platz: Splatterzonen gehalten',
                'Guardia zona splat nº 2',
                'N.º 2 en defender la zona',
                'N.º 2 en defender territorio',
                'Spetterzone verdedigd: nr. 2',
                'Защитник зоны контроля № 2',
                '№ 2 en Défense de zone',
                '№ 2 en défense de zone',
                'ガチエリア前線キープ No.2',
                '真格区域前线把控 No.2',
                '真格區域前線把控 No.2',
                '랭크 에어리어 전선 유지 No.2',
            ],
            'splat_zone_inker_no_2' => [
                '#2 Splat Zone Inker',
                '2. Platz: Splatterzonen gefärbt',
                'Attaccante zona splat nº 2',
                'N.º 2 en entintar la zona',
                'N.º 2 en ganar territorio',
                'Spetterzone geverfd: nr. 2',
                'Хозяин зоны контроля № 2',
                '№ 2 en encrage de zone',
                'ガチエリア塗り No.2',
                '真格区域涂墨 No.2',
                '真格區域塗墨 No.2',
                '랭크 에어리어 색칠 No.2',
            ],
            'super_jump_spot_no_2' => [
                '#2 Super Jump Spot',
                '2. Platz: Supersprung-Ziel',
                'Doel van supersprongen: nr. 2',
                'N.º 2 en atraer supersaltos',
                'Obiettivo super salto nº 2',
                'Навигатор суперпрыжков № 2',
                '№ 2 du super saut',
                '同伴跳跃目标 No.2',
                '同伴跳躍目標 No.2',
                '味方のジャンプ先 No.2',
                '아군의 집결지 No.2',
            ],
            'turf_inker_no_2' => [
                '#2 Turf Inker',
                '2. Platz: Revier gefärbt',
                'Grond geverfd: nr. 2',
                'Inchiostratutto nº 2',
                'N.º 2 en entintar',
                'N.º 2 en entintar territorio',
                'Заливщик № 2',
                '№ 2 en encrage de territoire',
                '塗りポイント No.2',
                '塗墨點數 No.2',
                '涂墨点数 No.2',
                '색칠 포인트 No.2',
            ],
            'first_splat' => [
                'Eerste uitschakeling!',
                'Erster Abschuss!',
                'First Splat!',
                'Primera liquidación',
                'Primera reventada',
                'Primo splat!',
                'Prix de la 1re victime',
                'Первый плюх!',
                'ファーストスプラット',
                '先泼制人',
                '先潑制人',
                '퍼스트 스플랫',
            ],
            'record_score_setter' => [
                'Fissarecord',
                'Pro du record de progression',
                'Record-Score Setter',
                'Recordbreker',
                'Récord de contador',
                'Zähler-Rekord',
                'Рекордный башневоз',
                'ベストカウント更新',
                '刷新最佳計數',
                '刷新最佳计数',
                '베스트 카운트 경신',
            ],
        ];
    }
}
