<?php

/**
 * @copyright Copyright (C) 2015-2024 AIZAWA Hina
 * @license https://github.com/fetus-hina/stat.ink/blob/master/LICENSE MIT
 * @author ADe <loezone@gmail.com>
 * @author AIZAWA Hina <hina@fetus.jp>
 * @author Gosin <canling0@gmail.com>
 */

declare(strict_types=1);

return [
    '(combined)' => '(組合)',
    '(default)' => '(預設)',
    '(For advanced users)' => '提供給進階使用者',
    '(incomplete)' => '(不完全)',
    '(unknown result)' => '(未知結果)',
    '* This exclusion is an attempt to minimize overcounting in weapon usage statistics.' => '* 這個排除是爲了儘量減少武器使用統計中的重複計數。',
    '1x Battle' => '',
    '3+9 Format' => '3+9格式',
    '3, 9 Format' => '3，9格式',
    '7 players for each battle (excluded the battle uploader)' => '每場對戰的七名玩家 (不包含上傳者)',
    '10x Battle' => '10倍比賽',
    '24H Win %' => '最近一天勝率',
    '50% (reference)' => '',
    '57 Format' => '57格式',
    '100x Battle' => '100倍比賽',
    '100x Battle WINNER!' => '100倍比賽 WINNER!!!',
    '333x Battle' => '333倍比賽',
    '333x Battle WINNER!' => '333倍比賽 WINNER!!!',
    '<a href="http://www.emoji-cheat-sheet.com/" target="_blank">Cheat sheet</a>. If omitted, the default icon will be used.' => '如果未指定，預設將使用圖示',
    '<code>@id</code> (without <code>@</code>), case sensitive.' => '',
    '<div class="input-group"><span class="input-group-addon">From:</span>{input}</div>' => '<div class="input-group"><span class="input-group-addon">從:</span>{input}</div>',
    '<div class="input-group"><span class="input-group-addon">To:</span>{input}</div>' => '<div class="input-group"><span class="input-group-addon">到:</span>{input}</div>',
    'Ability' => '裝備能力',
    'Ability Effect' => '技能效果',
    'About Incoming Webhook' => '關於串接Webhook',
    'About support for color-blindness' => '關於色盲輔助',
    'Active Players' => '活躍玩家',
    'Activity' => '活動',
    'Add' => '新增',
    'Add <code>/slack</code> to the end of the created webhook URL.' => '在建立的 webhook 網址末端新增<code>/slack</code>',
    'Add Slack Integration' => '新增整合Slack',
    'Advanced Options' => '進階選項',
    'Aggregated: {rules}' => '合計: {rules}',
    'Aliases' => '別名',
    'All' => '',
    'All Players' => '所有玩家',
    'Always enable horizontal scroll' => '始終啟用水平滾動',
    'Anarchy Power' => '',
    'Anonymize, don\'t link from other user\'s results' => '匿名化，不連結到其他用戶的結果',
    'Anonymized' => '匿名化',
    'Another account' => '另一個賬戶',
    'Any Result' => '所有結果',
    'Any Time' => '所有時間',
    'API Info: Abilities (Splatoon 3)' => 'API資訊：技能(斯普拉遁3)',
    'API Info: Boss Salmonids (Splatoon 3)' => 'API資訊：巨大鮭魚(斯普拉遁3)',
    'API Info: Gears: {0}' => 'API資訊：裝備：{0}',
    'API Info: Known Occurrences (Splatoon 3)' => 'API資訊：特殊狀況(斯普拉遁3)',
    'API Info: Medals (Splatoon 3)' => 'API資訊：徽章(斯普拉遁3)',
    'API Info: Stages (Splatoon 2)' => 'API資訊：場地(斯普拉遁2)',
    'API Info: Stages (Splatoon 3)' => 'API資訊：場地(斯普拉遁3)',
    'API Info: Titles (Splatoon 3)' => 'API資訊：稱號(斯普拉遁3)',
    'API Info: Uniforms (Splatoon 3)' => 'API資訊：制服(斯普拉遁3)',
    'API Info: Weapons' => 'API資訊：武器',
    'API Info: Weapons (Splatoon 2)' => 'API資訊：武器(斯普拉遁2)',
    'API Info: Weapons (Splatoon 3)' => 'API資訊：武器(斯普拉遁3)',
    'API Token' => 'API密鑰',
    'Apply' => '應用',
    'Apps for {version}' => '支援{version}的應用',
    'Area' => '面積',
    'Are you sure you want to regenerate your API token?' => '確認重新生成API密鑰嗎？',
    'Assist' => '助攻',
    'Assists' => '助攻',
    'Assists/min' => '助攻/分鐘',
    'Attacker Team Win Rate' => '',
    'Auto (cookie)' => '自動(cookie)',
    'Auto (Identicon)' => '自動(Identicon)',
    'Automated' => '自動統計資料',
    'Average' => '平均',
    'Average:' => '平均：',
    'Average Gear Abilities' => '',
    'Avg.' => '平均',
    'Avg. game in {time}' => '{time}時間內平均對戰數',
    'Avg. K.O. in {time}' => '{time}時間內平均完勝數',
    'Avg. Uses' => '平均使用數',
    'Avg Assists' => '平均助攻數',
    'Avg Deaths' => '平均死亡數',
    'Avg Inked' => '平均塗地量',
    'Avg K+A' => '平均擊殺+助攻',
    'Avg Kills' => '平均擊殺數',
    'Avg KR' => '平均殺死比',
    'Avg Specials' => '平均特殊武器數',
    'Back' => '返回',
    'Badge Progress' => '徽章進度',
    'Badges' => '徽章',
    'Bad Guys' => '對方',
    'Bad guys are in control' => '對方控制中',
    'Bad guys winning' => '對方領先',
    'Based on deaths' => '基於死亡數',
    'Based on kills' => '基於擊殺數',
    'Battle Count' => '對戰數',
    'Battle End' => '對戰結束於',
    'Battle results (CSV)' => '對戰結果 (CSV)',
    'Battles' => '對戰',
    'Battles:' => '對戰',
    'Battles:{0} / Win %:{1} / Avg Kills:{2} / Avg Deaths:{3} / Kill Ratio:{4}' => '對戰：{0} / 勝率%：{1} / 平均擊殺數：{2} / 平均死亡數：{3} / 殺死比：{4}',
    'Battles and Users' => '對戰與用戶',
    'Battle Start' => '對戰開始於',
    'between {down} and {up} {name}' => '在{down}和{up}之間 {name}',
    'Bin Width' => '',
    'Black out' => '隱藏名字',
    'Black out except private battle' => '隱藏除了私人比賽以外的名字',
    'Black out except private battle and teammate on league battle (4 players)' => '隱藏除了私人比賽和聯盟比賽(四人)之外的名字',
    'Black out except private battle and teammate on squad battle (tri or quad)' => '隱藏除了私人比賽與小隊作戰(三人或四人)之外的名字',
    'Black out other players' => '隱藏其他所有玩家的名字',
    'Black out other players (details)' => '隱藏其他所有玩家(細節)',
    'Black out other players (images)' => '隱藏其他所有玩家(圖片)',
    'Black out other players from the details list' => '隱藏細節列表中的其他所有玩家',
    'Black out other players from the result image' => '隱藏結果圖片中的其他所有玩家',
    'Blog' => '網誌',
    'Boy' => '男生',
    'Brand' => '品牌',
    'Calendar' => '日曆',
    'Capture Environment' => '擷取環境',
    'Cash' => '現金',
    'Category' => '類型',
    'Cause of Death' => '死因',
    'Challenge Power' => '',
    'Challenge Power Distribution' => '',
    'Change Icon' => '更換頭像',
    'Change Password' => '更改密碼',
    'Change Screen Name' => '',
    'Channel' => '頻道',
    'Check with Setup Analyzer' => '使用設定分析器來檢查',
    'Click to copy' => '點擊複製',
    'Close' => '關閉',
    'Clout' => '貢獻度',
    'Clout (Normal)' => '貢獻度 (一般)',
    'Clout (Pro)' => '貢獻度 (挑戰)',
    'Color-Blind Support' => '色盲輔助',
    'Color 1' => '顏色 1',
    'Color 2' => '顏色 2',
    'Color Scheme' => '主題配色',
    'combos' => '組合',
    'Compare Number Of Uses' => '比較使用數',
    'Compare number of uses' => '比較使用數',
    'Completed!' => '完成!',
    'Connectivity' => '連線狀態',
    'Consider to be Defeated' => '判定為敗北',
    'Continue' => '繼續',
    'Copied!' => '已複製',
    'Correction' => '更正',
    'Correction Value' => '更正內容',
    'Correlation Coefficient' => '相關係數',
    'Correlation with Win %' => '相關勝利%',
    'Could not be updated.' => '未能完成更新。',
    'Could not find specified battle.' => '未能發現指定對戰。',
    'Could not get your twitter icon at this time.' => '未能獲取twitter頭像。',
    'Could not update your icon. Please try again.' => '未能更新頭像。請稍後再試。',
    'Count (Bad Guys)' => '計數(對方)',
    'Count (Good Guys)' => '計數(我方)',
    'Create new webhook' => '建立新的 webhook',
    'CSV (IkaLog compat.)' => 'CSV(相容IkaLog)',
    'CSV format' => 'CSV格式',
    'Current' => '現在',
    'Current/Last Splatfest' => '這次/上次祭典',
    'Current Password' => '現在的密碼',
    'Current Period' => '當前時段',
    'Current Stages' => '當前場地',
    'Current Time:' => '當前時間',
    'd' => '死亡',
    'D/min' => '死亡數/分鐘',
    'Daily Report' => '每日報告',
    'Data Sent' => '資料上傳於',
    'Date' => '',
    'Date Time' => '日期時間',
    'Dead' => '死亡',
    'Deaths' => '死亡',
    'Deaths (average):' => '死亡(平均)',
    'Deaths (median):' => '死亡(中位數)',
    'Deaths/min' => '死亡數/分鐘',
    'Deaths Per Battle' => '每場死亡數',
    'Deaths per minute' => '每分鐘死亡數',
    'Default Color' => '預設顏色',
    'Default Order' => '',
    'Defeat' => '失敗',
    'Defeat (Exempted)' => '失敗 (不計算)',
    'Delete' => '刪除',
    'Delete This Battle' => '刪除此對戰',
    'Delete This Job' => '刪除此打工',
    'Detail' => '細節',
    'Detailed' => '',
    'Detailed List' => '細節列表',
    'Details' => '細節',
    'Deviation' => '標準差',
    'Disabled' => '關閉',
    'Disconnected' => '通訊斷線',
    'Discord' => '',
    'Don\'t anonymize, display in-game name' => '不隱藏遊戲中的顯示姓名',
    'Don\'t anonymize, display stat.ink\'s name' => '不隱藏stat.ink的顯示姓名',
    'Don\'t group' => '不分組',
    'Do not close this window.' => '不要關閉本窗口。',
    'Downloads' => '下載',
    'Download Stats' => '下載統計',
    'Draw' => '平手',
    'e.g. YouTube video, like "{0}"' => '比如說YouTube影片"{0}"',
    'Earlier Turf-Inked data is currently wrong. It will be fixed in the near future.' => '之前的塗地資料有誤，將來會進行修復。',
    'Edit' => '編輯',
    'Edit Your Battle: #{0}' => '編輯你的對戰: #{0}',
    'Effects' => '效果',
    'Elapsed' => '用時',
    'Elapsed Time' => '對戰用時',
    'Elapsed Time (seconds)' => '對戰用時(秒)',
    'Email' => '電子郵件',
    'Empirical Estimates' => '經驗預估',
    'Enabled' => '啟用',
    'Enable machine-translation' => '啟用機器翻譯',
    'Enable noise reduction (count)' => '啟用降噪(計數)',
    'Enable noise reduction (position of the objective)' => '啟用降噪(根據目標位置)',
    'Encounter Ratio' => '遭遇比值',
    'Enemy Weapon' => '對方武器',
    'Equip %' => '',
    'Error' => '錯誤',
    'Error bars' => '誤差棒',
    'Error bars: 95% confidence interval (estimated)' => '',
    'Error bars: 95% confidence interval (estimated) & 99% confidence interval (estimated)' => '誤差棒: 95% 的信賴區間(預測) & 99% 的信賴區間(預測)',
    'Estimated Error' => '',
    'Estimated Vote %' => '',
    'Estimated X Power' => '預估X戰力',
    'Europe' => '歐洲',
    'Europe/Oceania' => '歐洲/大洋洲',
    'Even you set them up in the input fields below they will not work.' => '就算你輸入在欄位下方也不會作動',
    'Excluded: Private Battles' => '排除私人比賽',
    'Excluded: Private Battles and Squad Battles (when Rank S or S+)' => '排除私人比賽與小隊作戰(S或S+級別)',
    'Excluded: The uploader, All players (Private Battle), Uploader\'s teammates (Squad Battle or Splatfest Battle)' => '排除上傳者，私人比賽的所有玩家，上傳者的隊友(小組對戰或是祭典對戰)',
    'Export' => '匯出',
    'Extra Data' => '額外資訊',
    'Favorite Weapon' => '最喜愛的武器',
    'Favorite Weapons' => '最喜愛的武器',
    'Favorite Weapons of This Site Member' => '該站用戶最喜愛的武器',
    'Feedback or suggestions are welcome. Please contact me via GitHub or Twitter.' => '歡迎提供意見與建議，請透過Github或是Twitter聯繫。',
    'fest.ink' => 'fest.ink',
    'Fest Power' => '祭典戰力',
    'Fest Power (Normal)' => '祭典戰力 (一般)',
    'Fest Power (Pro)' => '祭典戰力 (挑戰)',
    'Few' => '少量',
    'Filter' => '篩選器',
    'Filter Query' => '篩選標準',
    'Final Count' => '最終計數',
    'For the actual distribution, see the charts for each mode.' => '',
    'for {title}' => '該稱號 {title}',
    'Freshness' => '新鮮度',
    'Friend Code' => '好友代碼',
    'Friend Code (Switch)' => '好友代碼(Switch)',
    'Game Mode' => '遊戲模式',
    'Game Version' => '遊戲版本',
    'Gear' => '裝備',
    'GeoIP guessed {timezone}' => '可能時區{timezone}',
    'Getting Started' => '使用介紹',
    'Girl' => '女生',
    'GNU Social, Mastodon etc.' => 'GNU Social, Mastodon等社交軟件',
    'Good Guys' => '我方',
    'Good guys are in control' => '我方控制中',
    'Good guys winning' => '我方領先',
    'Group by main weapon' => '根據主武器分組',
    'Group by reskins' => '根據武器貼牌分組',
    'Group by weapon type' => '根據武器類型分組',
    'Guessed:' => '猜測：',
    'Guessed by your IP:' => '根據你的IP猜測：',
    'Guess the region' => '猜測區域',
    'Guest' => '訪客',
    'Has disconnected player' => '有玩家斷線',
    'Hasn\'t disconnected player' => '沒有玩家斷線',
    'Hawaii Time' => '夏威夷時間',
    'Hide your data on the top page' => '',
    'Highest (current period)' => '最高(當前時段內)',
    'Highest (this teammates)' => '最高(該名隊友)',
    'Highest First' => '',
    'History' => '歷史',
    'However, statistics information will be opened.' => '然而統計資訊會公開',
    'I agree. Delete this battle.' => '我確認刪除這場對戰。',
    'I agree to the terms above.' => '我同意以上條款',
    'Icon' => '圖示',
    'Idea: {source}' => '主意: {source}',
    'If omitted, the channel set in the webhook configuration will be used.' => '如果省略，webhook的頻道設定將會被使用',
    'If omitted, the name set in the webhook configuration will be used.' => '如果省略，webhook的名稱設定將會被使用',
    'If there are any unsubmitted data, they have not been included in this tally.' => '如果有未上傳的數據資料，則不計入本次統計',
    'If you already have an account, please click here.' => '如果已有帳戶，請點擊這裏。',
    'If you change the screen name with this form, the change will take effect immediately.' => '',
    'If you delete this battle, it will be gone forever.' => '如果刪除該對戰，將無法復原資料。',
    'If you have pages that you are sharing with URLs, most of them will be broken links.' => '',
    'If you have registered your login information in Password Manager, do not forget to update it.' => '',
    'If you know our API Token' => '',
    'If you misuse this feature, you will be banned.' => '如果有濫用行爲，你會被黑名單。',
    'Ika-Nakama' => 'Ika-Nakama',
    'Ika-Nakama User ID' => 'Ika-Nakama 用戶ID',
    'IkaLog' => 'IkaLog',
    'IkaLog Download Page' => 'IkaLog下載頁面',
    'IkaRec' => 'IkaRec',
    'IkaRec 2' => 'IkaRec 2',
    'Image Sharing' => '分享圖片',
    'Includes battles with unknown event power' => '',
    'Incomplete Data' => '不完整資料',
    'Ink Color' => '墨水顏色',
    'Inked' => '已塗地',
    'Inked/min' => '塗地面積/分鐘',
    'Inking Performance' => '塗地效率',
    'Inking Performance vs Win %' => '塗地效率對勝率',
    'Inkling' => '魷魚族',
    'Input new battle results' => '輸入新的對戰資料',
    'In session' => '進行中',
    'Integrate' => '連接',
    'Internal ID' => '內部ID',
    'Interval' => '間隔',
    'In the chart, "{representative}" means greater than or equal to {min} and less than {max}.' => '圖表中的 "{representative}" 代表大於等於 {min} 以及小於 {max}',
    'Invalid {0} or {1}.' => '無效的{0}或{1}。',
    'IQR' => '四分位距',
    'Items marked with these icons will only work with its corresponding version.' => '',
    'It looks this data is corrupt.' => '檔案疑似損毀',
    'Japan' => '日本',
    'Japan Time' => '日本時間',
    'Join us' => '加入我們',
    'JSON (IkaLog compat.)' => 'JSON(相容IkaLog)',
    'JSON (stat.ink format, gzipped)' => 'JSON(stat.ink格式，gzipped壓縮後)',
    'JSON format' => 'JSON格式',
    'JSON format (All langs)' => 'JSON格式(全語言)',
    'Judge' => '裁判',
    'Just scaled for easy contrast, the Y-axis value does not directly indicate the number of people.' => 'Y軸的值不直接顯示人數，以方便縮放來進行對比',
    'Just {result} {rule} at {stage}' => '在{stage}， 結果是{result} {rule}',
    'k' => '擊殺數',
    'K+A/D' => '擊殺+助攻/死亡',
    'K+A/min' => '擊殺+助攻/分鐘',
    'K-D' => '擊殺-死亡',
    'K/D vs Win %' => '擊殺率與勝率',
    'K/min' => '擊殺數/分鐘',
    'Keep doing it.' => '勤奮地參加對戰或是打工吧～',
    'Kill or Assist' => '擊殺或助攻',
    'Kill Rate' => '擊殺率',
    'Kill Ratio' => '擊殺比值',
    'Kills' => '擊殺數',
    'Kills (average):' => '擊殺數(平均)',
    'Kills (median):' => '擊殺數(中位數)',
    'Kills / Deaths' => '擊殺數/死亡數',
    'Kills/min' => '擊殺數/分鐘',
    'Kills and Deaths' => '擊殺數和死亡數',
    'Kills per minute' => '每分鐘擊殺數',
    'Knockout' => '完勝',
    'KNOCKOUT!' => '完勝！',
    'Knockout Rate' => '完勝率',
    'KR' => '擊殺率',
    'Lack of data' => '',
    'Language' => '語言',
    'Language (used for OStatus)' => '語言(OStatus使用)',
    'Last 24 Hours' => '最近24小時',
    'Last 24h: {winpct} win ({win}/{count}), Avg. {kill}k/{death}d' => '最近24小時： {winpct} 勝 ({win}/{count}), 平均{kill}殺/{death}死',
    'Last Month (UTC)' => '最近一個月(UTC時間)',
    'Last {n} Battles' => '最近{n}場對戰',
    'Last {n} Periods' => '最近{n}段時間',
    'Latest' => '最新',
    'Launch' => '發布',
    'League Power' => '聯盟戰力',
    'Legend' => '標註',
    'Legends' => '標註',
    'less than {min} {name}' => '少於{min} {name}',
    'Level' => '等級',
    'Level (After)' => '等級(對戰結束後)',
    'Link' => '連結',
    'Link from other user\'s results' => '連結到其他用戶的結果',
    'Links' => '連結',
    'List' => '列表',
    'Loading...' => '載入中……',
    'Loaned Weapons' => '',
    'Lobby' => '大廳',
    'Lobby (Icon)' => '大廳(圖示)',
    'Location' => '位置',
    'Login' => '登入',
    'Login History' => '登入歷史記錄',
    'Login history will be deleted in {term}.' => '登入歷史記錄會於{term}內刪除。',
    'Login Method' => '登入方法',
    'Log in with other services' => '使用其他服務登入',
    'Log in with Twitter' => '使用Twitter登入',
    'Logout' => '登出',
    'Lose' => '敗',
    'Lost' => '敗',
    'lost' => '敗',
    'Low ink' => '低墨水量',
    'Luminance' => '亮度',
    'Luminance Difference' => '亮度差',
    'Mains' => '主要',
    'Main Weapon' => '主武器',
    'Make empty this field when you are using Discord.' => '如果你在使用Discord，請將此欄位留空',
    'Many' => '許多',
    'Masked' => '已隱藏',
    'Max.' => '最大',
    'max={max} min={min} average={avg} median={median} mode={mode}' => '最大值={max} 最小值={min} 平均值={avg} 中位值={median} 衆數={mode}',
    'max={max} min={min} median={median}' => '最大值={max} 最小值={min} 平均值={median}',
    'max={max} min={min} median={median} stddev={stddev}' => '最大值={max} 最小值={min} 平均值={median} 標準差={stddev}',
    'Maximum' => '最大值',
    'Max Inked' => '最大塗地面積',
    'Max Kill Combo' => '最多擊殺數',
    'Max Kill Streak' => '最多連續擊殺數',
    'Medal' => '徽章',
    'Medals' => '徽章',
    'Median' => '中位數',
    'Minimum' => '最小值',
    'MMMM y' => 'y\'年\'M\'月\'',
    'Mobile' => '手機',
    'Mode' => '模式',
    'Mode (Icon)' => '模式(圖示)',
    'Mode (Short)' => '模式(簡寫)',
    'Mode{translate_hint_stats}' => '',
    'Monthly Report' => '每月報告',
    'more...' => '更多……',
    'more than {max} {name}' => '多於{max} {name}',
    'Moving Avg. ({0} Battles)' => '移動平均值({0}場對戰)',
    'My team\'s league power' => '我的聯盟能力值',
    'My team\'s splatfest power' => '我的祭典能力值',
    'My Team Count' => '我的隊伍計數',
    'My Team Score' => '我的隊伍分數',
    'My Team Splatfest Power' => '我的隊伍祭典能力值',
    'Name' => '名字',
    'Name (for display)' => '名字(顯示用)',
    'Neutral' => '中性',
    'New battle' => '新對戰',
    'New Password' => '新密碼',
    'New Password (again)' => '新密碼(再輸入一次)',
    'New Screen Name (Login Name)' => '',
    'Next' => '下一個',
    'Next Battle' => '下一場對戰',
    'Next Month' => '下個月',
    'Next Stages' => '下一輪場地',
    'Nintendo Network ID' => '任天堂網絡ID',
    'Nintendo Switch Online app' => 'NSO app',
    'No' => '沒有',
    'No battles' => '沒有對戰',
    'No black out' => '不隱藏',
    'No Data' => '沒有資料',
    'No one in control' => '無人控制',
    'No redirects from old URLs will be made.' => '',
    'Normal Distribution' => '常態分佈/正態分佈',
    'North America/Oceania' => '北美/大洋洲',
    'Not configured.' => '無設定',
    'Not Draws' => '不是平手',
    'Note' => '備註',
    'Note (private)' => '備註(私人)',
    'Note (public)' => '備註(公開)',
    'Not enough data is available.' => '',
    'Not Winning' => '不是勝利',
    'Number of weapons seen' => '',
    'Octoling' => '章魚圈',
    'Official Results' => '官方結果',
    'Official Twitter' => '官方Twitter',
    'Open Source Licenses' => '開源代碼授權',
    'Others' => '其它',
    'Overall Estimates' => '實際分佈',
    'Password' => '密碼',
    'Password (again)' => '密碼(再輸入一次)',
    'PC' => 'PC',
    'Peak' => '最高牌位',
    'Period' => '期間',
    'Permalink' => '永久連結',
    'Played With' => '',
    'Player Distribution' => '',
    'Players' => '玩家',
    'Players:' => '玩家：',
    'Please copy an API key below and paste to IkaLog, IkaRec or other apps that are compatible with {0}.' => '請複製以下API密鑰並粘貼到IkaLog，IkaRec或其它相容{0}的應用中。',
    'Please copy this URL:' => '請複製該網址',
    'Please do not use this feature to destroy evidence.' => '請不要使用該功能來摧毀證據。',
    'Please keep it secret.' => '請確保這個私密不被公開。',
    'Please log in with your new password.' => '',
    'Please refer to the respective projects for any problems or questions regarding the operation of each application.' => '',
    'Please tell us about your capture environment and communication between your Wii U and User Agent (e.g. IkaLog). This information will be public.' => '請告訴我們你的擷取環境和Wii U與客戶端(比如IkaLog)的連線方式。這些內容會被公開。',
    'Please wait.' => '請等待。',
    'PNG/JPEG file up to {0}' => '最多允許{0}的PNG/JPEG文件',
    'Points' => '點數',
    'Position' => '位置',
    'Power' => '',
    'Powered by' => '本站使用以下技術運行',
    'Power Level' => '能力值',
    'Prev.' => '上一個',
    'Prev. Battle' => '上一場對戰',
    'Prev. Month' => '上個月',
    'Previous Period' => '上一個時段',
    'Primary Ability' => '主要技能',
    'Primary ability is counted as {value_1_0} and secondary is counted as {value_0_3}.' => '',
    'Privacy Policy' => '隱私政策',
    'Profile and Settings' => '用戶與設定',
    'Progress' => '進度',
    'Q<sub>1/4</sub>' => '前25%',
    'Q<sub>3/4</sub>' => '前75%',
    'Rank' => '牌位',
    'Rank (After)' => '牌位(之後)',
    'Rank (after the battle)' => '牌位(對戰之後)',
    'Rank-up Battle' => '升階對戰',
    'Rank: Current' => '當前牌位：',
    'Rank: Peak' => '最高牌位：',
    'Rank in Team' => '隊中排名',
    'Rare Weapon' => '熊先生商會武器',
    'Rate' => '擊殺率',
    'Ratio' => '擊殺比值',
    'Recent Battles' => '最近對戰',
    'Recent Results' => '最近結果',
    'Recent Use %' => '最近使用 %',
    'Regardless of your time zone setting, it is grouped using UTC.' => '',
    'Regenerate your API token' => '重新生成你的API密鑰',
    'Region (used for Splatfest)' => '地區(祭典時使用)',
    'Register' => '註冊',
    'Regression Line' => '迴歸分析',
    'Relative Time' => '相對時間',
    'Released' => '發佈於',
    'Remember me' => '記住我',
    'Remote Follow' => '遠程關注',
    'Replay Code' => '對戰記憶代碼',
    'Reset icon' => '重置頭像',
    'Reset to default icon' => '重置爲預設頭像',
    'Reset your password' => '',
    'Reskin of' => '貼牌',
    'Result' => '結果',
    'Results of {name}\'s Battle' => '{name}場對戰的結果',
    'Room' => '房間',
    'Room info (Private)' => '房間資訊(是否私人比賽)',
    'S/min' => '特殊武器/分鐘',
    'Salmon Run CSV' => '鮭魚打工CSV',
    'Salmon Run JSON (gzipped)' => '鮭魚打工JSON(gzip壓縮)',
    'Salmon Run results (CSV)' => '鮭魚打工結果(CSV)',
    'Samples' => '範例',
    'Save!' => '保存！',
    'Schedule' => '行程安排',
    'Scheduled' => '已安排',
    'Schema' => '配色',
    'Schema information' => '配色資訊',
    'Screen Name' => '螢幕名字',
    'Screen Name (Login Name)' => '螢幕名字(登入名)',
    'Search' => '搜尋',
    'Search {date}' => '搜尋 {date}',
    'Search {from} - {to}' => '搜尋 從{from}到{to}',
    'Season' => '季',
    'Secondary Abilities' => '次要技能',
    'Seconds' => '',
    'Sent an email to your email address. Please check your mailbox and get the verification code.' => '已發送驗證郵件到你的信箱。請檢查信箱取得驗證碼。',
    'Series Progress' => '系列進度',
    'Session History' => '登入資訊',
    'Set the name, icon, and channel in the settings within Discord.' => '在 Discord 的設定內建立名稱、圖像、頻道',
    'Settings' => '設定',
    'Show All Players' => '顯示所有玩家',
    'Show moving averages' => '顯示移動平均值',
    'Show your API Token' => '顯示你的API密鑰',
    'Show your data on the top page' => '',
    'Significant?' => '重要?',
    'Simplified List' => '簡化列表',
    'Since the acquisition of Twitter by Elon Musk, the environment for third-party applications has deteriorated rapidly and extremely.' => '',
    'Slack' => '',
    'Slack Integration' => 'Slack整合',
    'Source: {source}' => '源頭：{source}',
    'Source Code' => '原始碼',
    'Sp' => '特武',
    'Special' => '特殊武器',
    'Special %' => '特殊武器 %',
    'Special (Icon)' => '特殊武器(圖示)',
    'Special:' => '特殊武器：',
    'Special Battle' => '特殊對戰',
    'Special Battle (Fest)' => '特殊對戰(祭典)',
    'Special Charged' => '特殊武器發動',
    'Specials' => '特殊武器',
    'Specials/min' => '特殊武器/分鐘',
    'Special Uses' => '特殊武器使用數',
    'Species' => '物種',
    'Specify Period' => '指定時間段',
    'Splatfest' => '祭典',
    'Splatfest Power' => '祭典戰力',
    'Splatfest Power (Normal)' => '祭典戰力 (一般)',
    'Splatfest Power (Pro)' => '祭典戰力 (挑戰)',
    'Splatfest Region:' => '祭典區域',
    'Splatfest Stats' => '',
    'Splatfest Title' => '祭典稱號',
    'Splatfest Title (After)' => '祭典稱號(之後)',
    'SplatNet' => 'SplatNet',
    'SplatNet #' => 'SplatNet編號',
    'SplatNet 2' => 'SplatNet 2',
    'SplatNet Battle #' => 'SplatNet對戰編號',
    'Splatoon' => '斯普拉遁',
    'Splatoon 2' => '斯普拉遁2',
    'Splatoon 3' => '斯普拉遁3',
    'Splatoon Official Website (Japan)' => '斯普拉遁官方網站(日本)',
    'Splatoon Official Website (UK)' => '斯普拉遁官方網站(英國)',
    'Splatoon Official Website (US/Canada)' => '斯普拉遁官方網站(美國/加拿大)',
    'Stack' => '疊加',
    'Stacked' => '',
    'Stage' => '場地',
    'Stage (Short)' => '場地(簡寫)',
    'Stages' => '場地',
    'Standard Deviation' => '標準差',
    'Stats' => '統計',
    'Stats (by Mode)' => '統計 (按模式)',
    'Stats (by Mode and Stage)' => '統計 (依照模式與場地)',
    'Stats (by Stage)' => '統計 (按場地)',
    'Stats (by Weapon)' => '統計 (依照武器)',
    'Stats (Cause of Death)' => '統計 (死因)',
    'Stats (Medals)' => '統計 (徽章)',
    'Stats (Ranked Battle)' => '統計 (排名對戰)',
    'Stats (Splatfest)' => '統計 (祭典)',
    'Stats (Turf War)' => '統計 (占地對戰)',
    'Stats (vs. Weapon)' => '統計 (對方武器)',
    'Stats (Win %)' => '統計 (勝利 %)',
    'Stats (X Power)' => '',
    'Stats ({rule})' => '統計 ({rule})',
    'Stats: FestPwr diff vs Win %' => '統計：祭典能力差值與勝率',
    'Stats: Stages' => '統計：場地',
    'Stats: User Activity' => '統計：用戶活動',
    'Std Dev' => '標準差',
    'Stealth Jump Equipment Rate' => '',
    'streak' => '連續',
    'Sub:' => '次要武器:',
    'Subs' => '次要武器',
    'Sub Weapon' => '次要武器',
    'Sub Weapon (Icon)' => '次要武器(圖示)',
    'Summarize' => '總結',
    'Summary: Based on the current filter' => '總結：基於目前篩選狀態',
    'Synergy Bonus' => '整齊獎勵',
    'Systematic error of win %' => '系統性勝率誤差',
    'Tablet' => '平板',
    'Target Player\'s Team' => '目標玩家的隊伍',
    'Team' => '隊伍',
    'Team Icon' => '隊伍(圖示)',
    'Team ID' => '隊伍ID',
    'Team Inked' => '隊伍塗地面積',
    'Team {theme}' => '隊伍{theme}',
    'Test' => '測試',
    'Thanks to {user} for their contribution.' => '',
    'The abilities valid only for the primary means the rate of mounting.' => '',
    'The correction value specified by the user is applied.' => '',
    'The data contains a large error margins.' => '此資料的誤差範圍較大',
    'The data is intended to be analyzed using spreadsheet software (Excel, etc.) or programs to analyze.' => '此資料設計為被電子試算表 (如 Excel) 等相關軟體來分析',
    'The data is not something you will know immediately after downloading.' => '此資料非為下載完即可立即解讀',
    'The estimated distribution of the overall game, as estimated from the official results.' => '根據官方結果的整體遊戲的預估分佈',
    'The estimated location may be inaccurate.' => '預估的位置可能不準確',
    'The filter specifying XP and version, aggregates data for the overall <code>x.y</code>, ignoring the <code>z</code> in version <code>x.y.z</code>.' => '',
    'The future of Twitter integration is completely uncertain, and as a {site} developer I can\'t recommend this feature at this time.' => '',
    'The icon will be:' => '該圖示會變成：',
    'Their team\'s league power' => '對方隊伍的聯盟戰力',
    'Their team\'s splatfest power' => '對方隊伍的祭典戰力',
    'Their Team Count' => '對方隊伍計數',
    'Their Team Score' => '對方隊伍分數',
    'Their Team Splatfest Power' => '對方隊伍祭典能力值',
    'Themes from {name}' => '來自於{name}的主題',
    'The old name will be available immediately for reuse.' => '',
    'The password will be encrypted.' => '密碼會被加密',
    'The post will be in the language set here.' => '資料將會以這邊設定的語言顯示',
    'There are no data.' => '沒有資料',
    'There is no user associated with the specified twitter account.' => '沒有用戶綁定該Twitter帳號。',
    'These battles were recorded with an outdated version of IkaLog. Please upgrade to the latest version.' => '這些對戰是由舊版的IkaLog記錄。 請更新到最新版本。',
    'The width of the histogram bins is automatically adjusted by Scott\'s rule-based algorithm.' => '',
    'This battle was recorded with an outdated version of IkaLog. Please upgrade to the latest version.' => '該對戰是由舊版的IkaLog記錄。請更新到最新版本。',
    'This chart assumes simple normal distribution of the Power to make it easier to compare each mode.' => '',
    'This data is based on {siteName} users and differs significantly from overall game statistics.' => '此資料僅基於 {siteName} 用戶，與整體遊戲的統計數據會有相當大的差異',
    'This data is basically not informative.' => '這個資料基本上沒有訊息',
    'This data was totaled after normalization to 5 minute intervals for each battle.' => '該資料的彙整是根據每場對戰五分鐘的間隔來做正規化處理。',
    'This document is under a <a href="http://creativecommons.org/licenses/by/4.0/deed.en">Creative Commons Attribution 4.0 International License</a>.' => '該文檔基於<a href="http://creativecommons.org/licenses/by/4.0/deed.zh">Creative Commons Attribution 4.0 International License</a>共享。',
    'This feature is disabled by default.' => '',
    'This information will be public. Integration for "log in with twitter" can be done from the profile page.' => '這些資訊會被公開。可以從用戶頁面整合Twitter帳號。',
    'This is a Discord-specific behavior.' => '這是Discord端的特定行為',
    'This is a wild guess based on past results and {siteName} posts.' => '這猜測的資料是基於過去的結果和{siteName}的文章',
    'This Month (UTC)' => '本月(UTC)',
    'This option is provided for deleting an incorrectly-reported battle.' => '該選項用於刪除錯誤上傳的對戰。',
    'This should be a random string of at least {n} characters and should not be the same as any other site' => '',
    'This twitter account has already been integrated with another user.' => '已經有用戶綁定該Twitter帳號。',
    'This website doesn\'t support Internet Explorer. Please use a modern browser, for example Chrome or Firefox.' => '本網站不支援IE。請使用近代的網絡瀏覽器，比如Chrome或Firefox。',
    'This website has color-blind support. Please check "Color-Blind Support" in the "Username/Guest" menu of the navbar to enable it.' => '本網站提供色盲輔助。請在導航欄的“用戶/訪客”選單下勾選“色盲輔助”。',
    'This website is an open source project. It is under the MIT License. The source code is available on GitHub.' => '本網站是開源項目。基於MIT授權。原始碼可在GitHub查看。',
    'This website is an UNOFFICIAL SERVICE. It is not related to the Splatoon development team or Nintendo.' => '本網站不是官方服務。與任天堂的斯普拉遁團隊沒有關係。',
    'This will be made public as part of URL' => '',
    'This {attribute} is already in use.' => '該{attribute}已經啟用。',
    'Time' => '時間',
    'Time is up' => '時間到',
    'Times' => '時間',
    'Time was up' => '時間到',
    'Time Zone' => '時區',
    'Title' => '稱號',
    'Title (After)' => '稱號(之後)',
    'To change your password using this feature, contact the administrator first.' => '',
    'Today' => '今天',
    'Top {percentile}%' => '高端 {percentile}%',
    'Total' => '總計',
    'Total Clout' => '影響力總計',
    'Total Clout (After the battle)' => '影響力總計 (對戰之後)',
    'Total Inked' => '塗地總計',
    'To use Discord integration, make a webhook on your Discord server first.' => '要與Slack做整合，你需要先去Discord設定webhook',
    'To use Slack integration, you need to configure Slack\'s "Incoming Webhook" first.' => '要與Slack做整合，你需要先去Slack設定webhook',
    'Trends' => '趨勢',
    'Try to secure the Ultra Signal' => '嘗試守護超級信號',
    'Turf Inked' => '塗地面積',
    'Turf inked (including bonus)' => '塗地面積(包含獎勵)',
    'Turf Inked + Bonus' => '塗地面積和獎勵',
    'TV' => '電視',
    'Twitter @name' => 'Twitter @暱稱',
    'TZ' => '時區',
    'Ultra Signals' => '超級信號',
    'Uniform' => '制服',
    'Unknown' => '未知',
    'Unknown Result' => '未知結果',
    'Unlink account' => '取消綁定',
    'Update' => '更新',
    'Update Your Email Address' => '更新你的電子郵件地址',
    'Update Your Icon' => '更新頭像',
    'Update Your Password' => '更新密碼',
    'Update Your Profile' => '更新檔案',
    'Update Your Screen Name' => '',
    'Upload icon' => '上傳頭像',
    'Upload new image' => '上傳新圖片',
    'URL related to this battle' => '這場對戰的網址',
    'Use %' => '使用 %',
    'Use % and Win %' => '使用 % 和 贏 %',
    'Used in global stats' => '用於全域統計',
    'Use full width of the screen' => '使用全部的螢幕寬度',
    'Use profile icon of your twitter account' => '使用Twitter登入頭像',
    'User Agents in last 24 hours' => '最近一天的客戶端',
    'User Count' => '用戶總數',
    'User Name' => '用戶名字',
    'Users' => '用戶',
    'Use your profile icon' => '使用檔案頭像',
    'Verification Code' => '驗證碼',
    'Verify' => '驗證',
    'Version' => '版本',
    'Version {0}' => '版本 {0}',
    'Victory' => '勝利',
    'Victory or Defeat' => '勝利或敗北',
    'View Settings' => '顯示設定',
    'Vote %' => '',
    'We\'ll send an email when you log in to the website or change your password.' => '登入網站或是更改密碼後我們會給你發送一封郵件。',
    'Weapon' => '武器',
    'Weapon (Icon)' => '武器(圖示)',
    'Weapon (Short)' => '武器(短名)',
    'Weapon icons were created by {0}.' => '武器圖示由{0}創建。',
    'Weapons' => '武器',
    'Weapon Stats' => '',
    'Weapon Trends' => '武器趨勢',
    'Weapon | {weapon}' => '武器 | {weapon}',
    'Weapon | {weapon} | {rule}' => '武器 | {weapon} | {rule}',
    'Webhook URL' => 'Webhook網址',
    'Win' => '勝',
    'Win %' => '勝率',
    'Win % (Total)' => '勝率(總計)',
    'Win % ({0} Battles)' => '勝率({0}場對戰)',
    'Winning Percentage' => '勝率',
    'Winning Percentage based on K/D' => '基於擊殺率的勝率',
    'Wins' => '',
    'Win streak (Bad guys)' => '連贏(對方)',
    'Win streak (Good guys)' => '連贏(我方)',
    'Win Streak: {count}' => '連贏數：{count}',
    'Won' => '勝',
    'won' => '勝',
    'Won / Lost' => '勝/敗',
    'X Power' => 'X戰力',
    'X Power (after)' => 'X戰力(之後)',
    'Yes' => '是',
    'Yesterday' => '昨天',
    'You' => '你',
    'You can\'t use an IDN (Internationalized Domain Names) email address' => '你不能使用IDN(國際化域名)的郵件地址',
    'You can delete this battle.' => '你可以刪除該對戰。',
    'You cannot use the same {attribute} as your current one.' => '',
    'You can register (estimated) unsent values here to correct the values displayed.' => '你可在填寫未上傳的資料來修改顯示的資料',
    'You can specify Discord\'s Slack compatible endpoint URL as well.' => '你也可以指定Discord和Slack相容的網址',
    'You must agree to the above to delete this battle.' => '你必須同意以上內容以便刪除該對戰。',
    'Your Battles' => '你的對戰',
    'Your browser does not support this action.' => '你的瀏覽器不支援該行爲。',
    'Your current icon:' => '你現在的頭像',
    'Your current image will be deleted and reset to auto-generated image.' => '你現在的頭像會被刪除並且重置爲自動生成的圖片。',
    'Your data will no longer appear in the public list on the top page.' => '',
    'Your page will still be public, but it will be harder to access.' => '',
    'Your password has been changed successfully.' => '',
    'Your profile icon has been updated.' => '你的頭像已更新',
    '[Outdated]' => '[已過時]',
    '{0} etc.' => '{0}等類似武器',
    '{0}×{1} or less resolution' => '{0}×{1} 或更低的分辨率',
    '{attribute} must be at most 15 alphanumeric or underscore characters.' => '{attribute} 最多是15個字母或數字或底線。',
    '{decimal5_7} Format' => '{decimal5_7} 格式',
    '{from} - {to}' => '',
    '{lower}-{upper} percentile' => '{lower}-{upper} 百分位數',
    '{n,plural,=1{battle} other{battles}}' => '對戰',
    '{name}\'s Badge Progress' => '{name}的徽章進度',
    '{name}\'s Battle' => '{name}的對戰',
    '{name}\'s Battle Report' => '{name}的對戰報告',
    '{name}\'s Battles' => '{name}的對戰',
    '{name}\'s Battle Stats (by Mode)' => '{name}的對戰統計 (按模式)',
    '{name}\'s Battle Stats (by Mode and Stage)' => '{name}的對戰統計 (按模式和場地)',
    '{name}\'s Battle Stats (by Stage)' => '{name}的對戰統計 (按場地)',
    '{name}\'s Battle Stats (by Weapon)' => '{name}的對戰統計 (按武器)',
    '{name}\'s Battle Stats (Cause of Death)' => '{name}的對戰統計 (死因)',
    '{name}\'s Battle Stats (Medals)' => '{name}的對戰統計 (徽章)',
    '{name}\'s Battle Stats (Ranked Battle)' => '{name}的對戰統計 (排名模式)',
    '{name}\'s Battle Stats (Splatfest)' => '{name}的對戰統計 (祭典)',
    '{name}\'s Battle Stats (Turf War)' => '{name}的對戰統計 (塗地模式)',
    '{name}\'s Battle Stats (vs. Weapon)' => '{name}的對戰統計 (對方武器)',
    '{name}\'s Battle Stats (Winning Rate)' => '{name}的對戰統計 (勝率)',
    '{name}\'s Battle Stats ({rule})' => '{name}的對戰統計 ({rule})',
    '{name}\'s Favorite Weapon' => '{name}的最愛的武器',
    '{name}\'s Monthly Report - {date}' => '{name}的每月報告 - {date}',
    '{name}\'s Splat Log' => '{name}的塗地記錄',
    '{name}\'s X Power' => '',
    '{nFormatted} remaining' => '{nFormatted}剩餘場次',
    '{nFormatted} {n, plural, =1{battle} other{battles}}' => '{nFormatted}次對戰',
    '{nFormatted} {n, plural, =1{time} other{times}}' => '{nFormatted}次',
    '{number, plural, =1{1 death} other{# deaths}} in {battle, plural, =1{1 battle} other{# battles}}' => '{battle}次對戰中死亡{number}次',
    '{number, plural, =1{1 egg} other{# eggs}} in {battle, plural, =1{1 shift} other{# shifts}}' => '{battle}次打工中收穫{number}顆鮭魚卵',
    '{number, plural, =1{1 kill} other{# kills}}' => '{number}次擊殺',
    '{number, plural, =1{1 kill} other{# kills}} in {battle, plural, =1{1 battle} other{# battles}}' => '{battle}次對戰中擊殺{number}次',
    '{number, plural, =1{1 time} other{# times}} in {battle, plural, =1{1 shift} other{# shifts}}' => '{battle}次打工的{number}次',
    '{package} is used for icons and other images.' => '',
    '{pct_point} percentage point' => '{pct_point}百分點數',
    '{pct}% CI' => '{pct}% 信賴區間',
    '{pct} % loss' => '{pct}%失敗率',
    '{pct}% Significant?' => '{pct}% 重要?',
    '{pct} ({dupf} DU/F)' => '{pct} ({dupf} 單位距離/幀)',
    '{percentile} Percentile' => '{percentile}百分位數',
    '{point, plural, =1{1 point} other{# points}} in {battle, plural, =1{1 battle} other{# battles}}' => '{battle}次對戰中獲得{point}點',
    '{point, plural, other{#p}}' => '{point}點',
    '{point}p' => '{point}點',
    '{rule}: Current' => '{rule}:現在',
    '{rule}: Peak' => '{rule}: 最高',
    '{sec,plural,=1{# second} other{# seconds}}' => '{sec}秒',
    '{sec} seconds' => '{sec}秒',
    '{sec} seconds ({pct} %)' => '{sec} 秒 ({pct} %)',
    '{sec} seconds, {cnt} times' => '{sec} 秒, {cnt} 次',
    '{siteName} Discord Community' => '{siteName}Discord社群',
    '{theme} Theme' => '{theme}主題',
    '{title} Official Website' => '{title}官方網站',
    '~{estPower}' => '約{estPower}',
    '~{point}p' => '約{point}點',
    '×{times}' => '',
];
