<?php

/**
 * @copyright Copyright (C) 2015-2024 AIZAWA Hina
 * @license https://github.com/fetus-hina/stat.ink/blob/master/LICENSE MIT
 * @author AIZAWA Hina <hina@fetus.jp>
 * @author Gosin <canling0@gmail.com>
 * @author imspace <spacemeowx2@gmail.com>
 * @author Weihao Jiang <weihau.chiang@gmail.com>
 * @author Yifan Liu <yifanliu00@gmail.com>
 */

declare(strict_types=1);

return [
    '(combined)' => '（组合）',
    '(default)' => '（默认）',
    '(For advanced users)' => '（针对高级用户）',
    '(incomplete)' => '（不完全）',
    '(unknown result)' => '（未知结果）',
    '* This exclusion is an attempt to minimize overcounting in weapon usage statistics.' => '※这个排除是为了尽量减少武器使用统计中的重复计数。',
    '1x Battle' => '1倍比赛',
    '3+9 Format' => '3+9格式',
    '3, 9 Format' => '3，9格式',
    '7 players for each battle (excluded the battle uploader)' => '每场比赛除上传者外的7名玩家',
    '10x Battle' => '10倍比赛',
    '24H Win %' => '24小时胜率',
    '50% (reference)' => '50%（参照用）',
    '57 Format' => '57格式',
    '100x Battle' => '100倍比赛',
    '100x Battle WINNER!' => '100倍比赛 WINNER!!!',
    '333x Battle' => '333倍比赛',
    '333x Battle WINNER!' => '333倍比赛 WINNER!!!',
    '<a href="http://www.emoji-cheat-sheet.com/" target="_blank">Cheat sheet</a>. If omitted, the default icon will be used.' => '<a href="http://www.emoji-cheat-sheet.com/" target="_blank">速查表</a>。省略时使用默认的图标。',
    '<code>@id</code> (without <code>@</code>), case sensitive.' => '<code>@id</code> (※无<code>@</code>), 区分大小写',
    '<div class="input-group"><span class="input-group-addon">From:</span>{input}</div>' => '<div class="input-group"><span class="input-group-addon">从:</span>{input}</div>',
    '<div class="input-group"><span class="input-group-addon">To:</span>{input}</div>' => '<div class="input-group"><span class="input-group-addon">到:</span>{input}</div>',
    'Ability' => '装备能力',
    'Ability Effect' => '装备能力效果',
    'About Incoming Webhook' => '关于传入 Webhook',
    'About support for color-blindness' => '关于色盲辅助',
    'Active Players' => '活跃玩家',
    'Activity' => '活动',
    'Add' => '添加',
    'Add <code>/slack</code> to the end of the created webhook URL.' => '请在生成的Webhook URL的末尾添加 <code>/slack</code> 。',
    'Add Slack Integration' => '集成到Slack',
    'Advanced Options' => '高级选项',
    'Aggregated: {rules}' => '统计对象：{rules}',
    'Aliases' => '别名',
    'All' => '全部',
    'All Players' => '全部玩家',
    'Always enable horizontal scroll' => '始终启用水平滚动',
    'Anarchy Power' => '蛮颓战力',
    'Anonymize, don\'t link from other user\'s results' => '匿名化，不链接到其他用户的结果',
    'Anonymized' => '匿名化',
    'Another account' => '另一个账户',
    'Any Result' => '所有结果',
    'Any Time' => '所有时间',
    'API Info: Abilities (Splatoon 3)' => 'API信息：技能(Splatoon 3)',
    'API Info: Boss Salmonids (Splatoon 3)' => 'API信息：巨大鲑鱼(Splatoon 3)',
    'API Info: Gears: {0}' => 'API信息：装备：{0}',
    'API Info: Known Occurrences (Splatoon 3)' => 'API信息：特殊状况(Splatoon 3)',
    'API Info: Medals (Splatoon 3)' => 'API信息：表彰（Splatoon 3）',
    'API Info: Stages (Splatoon 2)' => 'API信息：场地（Splatoon 2）',
    'API Info: Stages (Splatoon 3)' => 'API信息：场地（Splatoon 3）',
    'API Info: Titles (Splatoon 3)' => 'API信息：称号（Splatoon 3）',
    'API Info: Uniforms (Splatoon 3)' => 'API信息：工作服（Splatoon 3）',
    'API Info: Weapons' => 'API信息：武器',
    'API Info: Weapons (Splatoon 2)' => 'API信息：武器（Splatoon 2）',
    'API Info: Weapons (Splatoon 3)' => 'API信息：武器（Splatoon 3）',
    'API Token' => 'API密钥',
    'Apply' => '应用',
    'Apps for {version}' => '支持{version}的应用',
    'Area' => '面积',
    'Are you sure you want to regenerate your API token?' => '确认重新生成API密钥吗？',
    'Assist' => '助攻',
    'Assists' => '助攻',
    'Assists/min' => '助攻/分钟',
    'Attacker Team Win Rate' => '进攻队伍胜率',
    'Auto (cookie)' => '自动（cookie）',
    'Auto (Identicon)' => '自动（Identicon）',
    'Automated' => '自动统计数据',
    'Average' => '平均',
    'Average:' => '平均：',
    'Average Gear Abilities' => '',
    'Avg.' => '平均',
    'Avg. game in {time}' => '平均对战时间：{time}',
    'Avg. K.O. in {time}' => '平均完胜时间：{time}',
    'Avg. Uses' => '平均使用数',
    'Avg Assists' => '平均助攻数',
    'Avg Deaths' => '平均死亡数',
    'Avg Inked' => '平均涂地数',
    'Avg K+A' => '平均杀敌+助攻',
    'Avg Kills' => '平均杀敌数',
    'Avg KR' => '平均杀死比',
    'Avg Specials' => '平均特殊武器数',
    'Back' => '返回',
    'Badge Progress' => '徽章进度',
    'Badges' => '徽章',
    'Bad Guys' => '对方',
    'Bad guys are in control' => '对方控制中',
    'Bad guys winning' => '对方占据上风',
    'Based on deaths' => '基于死亡数',
    'Based on kills' => '基于杀敌数',
    'Battle Count' => '对战数',
    'Battle End' => '对战结束',
    'Battle results (CSV)' => '对战结果（CSV）',
    'Battles' => '对战',
    'Battles:' => '对战：',
    'Battles:{0} / Win %:{1} / Avg Kills:{2} / Avg Deaths:{3} / Kill Ratio:{4}' => '对战：{0} / 胜率%：{1} / 平均杀敌数：{2} / 平均死亡数：{3} / 杀死比：{4}',
    'Battles and Users' => '对战与用户',
    'Battle Start' => '对战开始',
    'between {down} and {up} {name}' => '在{down}和{up}之间 {name}',
    'Bin Width' => '组距',
    'Black out' => '隐藏名字',
    'Black out except private battle' => '隐藏除了私房对战以外的名字',
    'Black out except private battle and teammate on league battle (4 players)' => '隐藏除了私房和组排（四人）之外的名字',
    'Black out except private battle and teammate on squad battle (tri or quad)' => '隐藏除了私房与组排（三人或四人）之外的名字',
    'Black out other players' => '隐藏其他玩家的名字',
    'Black out other players (details)' => '隐藏其他玩家（细节）',
    'Black out other players (images)' => '隐藏其他玩家（图片）',
    'Black out other players from the details list' => '隐藏细节列表中的其他玩家',
    'Black out other players from the result image' => '隐藏结果图片中的其他玩家',
    'Blog' => '博客',
    'Boy' => '男生',
    'Brand' => '品牌',
    'Calendar' => '日历',
    'Capture Environment' => '录屏环境',
    'Cash' => '现金',
    'Category' => '类别',
    'Cause of Death' => '死因',
    'Challenge Power' => '活动战力',
    'Challenge Power Distribution' => '活动战力分布',
    'Change Icon' => '改变头像',
    'Change Password' => '更改密码',
    'Change Screen Name' => '更改登录名',
    'Channel' => '频道',
    'Check with Setup Analyzer' => '使用设置分析器检查',
    'Click to copy' => '点击复制',
    'Close' => '关闭',
    'Clout' => '贡献度',
    'Clout (Normal)' => '贡献度（普通）',
    'Clout (Pro)' => '贡献度（专业）',
    'Color-Blind Support' => '色盲辅助',
    'Color 1' => '色彩 1',
    'Color 2' => '色彩 2',
    'Color Scheme' => '配色方案',
    'combos' => '组合',
    'Compare Number Of Uses' => '比较使用数',
    'Compare number of uses' => '比较使用数',
    'Completed!' => '完成！',
    'Connectivity' => '连接状态',
    'Consider to be Defeated' => '判定为失败',
    'Continue' => '继续',
    'Copied!' => '已复制',
    'Correction' => '更正',
    'Correction Value' => '更正值',
    'Correlation Coefficient' => '相关系数',
    'Correlation with Win %' => '与胜率的相关性',
    'Could not be updated.' => '未能完成更新。',
    'Could not find specified battle.' => '未能发现指定对战。',
    'Could not get your twitter icon at this time.' => '未能获取twitter头像。',
    'Could not update your icon. Please try again.' => '未能更新头像。请稍后再试。',
    'Count (Bad Guys)' => '计数（对方）',
    'Count (Good Guys)' => '计数（我方）',
    'Create new webhook' => '创建新的Webhook',
    'CSV (IkaLog compat.)' => 'CSV（兼容IkaLog）',
    'CSV format' => 'CSV格式',
    'Current' => '现在',
    'Current/Last Splatfest' => '这次/上次祭典',
    'Current Password' => '现在的密码',
    'Current Period' => '当前时段',
    'Current Stages' => '当前场地',
    'Current Time:' => '当前时间',
    'd' => '死亡',
    'D/min' => '死亡数/分钟',
    'Daily Report' => '日报',
    'Data Sent' => '数据上传于',
    'Date' => '日期',
    'Date Time' => '日期时间',
    'Dead' => '死亡',
    'Deaths' => '死亡',
    'Deaths (average):' => '死亡（平均）',
    'Deaths (median):' => '死亡（中值）',
    'Deaths/min' => '死亡数/分钟',
    'Deaths Per Battle' => '每场死亡数',
    'Deaths per minute' => '每分钟死亡数',
    'Default Color' => '默认颜色',
    'Default Order' => '默认顺序',
    'Defeat' => '败',
    'Defeat (Exempted)' => '败（不计入）',
    'Delete' => '删除',
    'Delete This Battle' => '删除这场对战',
    'Delete This Job' => '删除这场打工',
    'Detail' => '详细',
    'Detailed' => '详细',
    'Detailed List' => '详细列表',
    'Details' => '详细',
    'Deviation' => '标准差',
    'Disabled' => '关闭',
    'Disconnected' => '通讯断线',
    'Discord' => 'Discord',
    'Don\'t anonymize, display in-game name' => '不隐藏游戏中的显示姓名',
    'Don\'t anonymize, display stat.ink\'s name' => '不隐藏stat.ink的显示姓名',
    'Don\'t group' => '不分组',
    'Do not close this window.' => '不要关闭本窗口。',
    'Downloads' => '下载',
    'Download Stats' => '下载统计',
    'Draw' => '平',
    'e.g. YouTube video, like "{0}"' => '比如说YouTube视频"{0}"',
    'Earlier Turf-Inked data is currently wrong. It will be fixed in the near future.' => '之前的涂地数据有误，将来会进行修复。',
    'Edit' => '编辑',
    'Edit Your Battle: #{0}' => '编辑你的对战: #{0}',
    'Effects' => '效果',
    'Elapsed' => '用时',
    'Elapsed Time' => '对战用时',
    'Elapsed Time (seconds)' => '对战用时（秒）',
    'Email' => '电子邮件',
    'Empirical Estimates' => '经验估计',
    'Enabled' => '启用',
    'Enable machine-translation' => '启用机器翻译',
    'Enable noise reduction (count)' => '启用噪声消减（计数）',
    'Enable noise reduction (position of the objective)' => '启用噪声消减（根据目标位置）',
    'Encounter Ratio' => '遭遇比例',
    'Enemy Weapon' => '敌方武器',
    'Equip %' => '装备率 (%)',
    'Error' => '错误',
    'Error bars' => '误差线',
    'Error bars: 95% confidence interval (estimated)' => '误差线：95%置信区间（估计）',
    'Error bars: 95% confidence interval (estimated) & 99% confidence interval (estimated)' => '误差线：95%置信区间（估计）和99%置信区间（估计）',
    'Estimated Error' => '估计误差',
    'Estimated Vote %' => '估算投票率',
    'Estimated X Power' => '估算X能力值',
    'Europe' => '欧洲',
    'Europe/Oceania' => '欧洲/大洋洲',
    'Even you set them up in the input fields below they will not work.' => '即便在下面的输入框中进行设置也不会生效。',
    'Excluded: Private Battles' => '排除私房对战',
    'Excluded: Private Battles and Squad Battles (when Rank S or S+)' => '排除私房对战与小队作战（S或S+级别）',
    'Excluded: The uploader, All players (Private Battle), Uploader\'s teammates (Squad Battle or Splatfest Battle)' => '排除上传者，私房对战的所有玩家，上传者的队友（小组对战或是祭典对战）',
    'Export' => '导出',
    'Extra Data' => '额外信息',
    'Favorite Weapon' => '最喜爱的武器',
    'Favorite Weapons' => '最喜爱的武器',
    'Favorite Weapons of This Site Member' => '该站用户最喜爱的武器',
    'Feedback or suggestions are welcome. Please contact me via GitHub or Twitter.' => '欢迎提供意见与建议，请通过Github或是Twitter联系。',
    'fest.ink' => '祭典墨水',
    'Fest Power' => '祭典能力值',
    'Fest Power (Normal)' => '祭典能力值（普通）',
    'Fest Power (Pro)' => '祭典能力值（专业）',
    'Few' => '少量',
    'Filter' => '筛选器',
    'Filter Query' => '筛选标准',
    'Final Count' => '最终计数',
    'For the actual distribution, see the charts for each mode.' => '实际分布请参见各模式的图表。',
    'for {title}' => '该称号 {title}',
    'Freshness' => '新鲜度',
    'Friend Code' => '好友码',
    'Friend Code (Switch)' => '好友码（Switch）',
    'Game Mode' => '游戏模式',
    'Game Version' => '游戏版本',
    'Gear' => '装备',
    'GeoIP guessed {timezone}' => '根据GeoIP猜测：{timezone}',
    'Getting Started' => '使用介绍',
    'Girl' => '女生',
    'GNU Social, Mastodon etc.' => 'GNU Social, Mastodon等社交软件',
    'Good Guys' => '我方',
    'Good guys are in control' => '我方控制中',
    'Good guys winning' => '我方占据上风',
    'Group by main weapon' => '根据主武器分组',
    'Group by reskins' => '根据武器贴牌分组',
    'Group by weapon type' => '根据武器类型分组',
    'Guessed:' => '猜测：',
    'Guessed by your IP:' => '根据你的IP地址猜测：',
    'Guess the region' => '猜测地区',
    'Guest' => '客人',
    'Has disconnected player' => '有玩家掉线',
    'Hasn\'t disconnected player' => '没有玩家掉线',
    'Hawaii Time' => '夏威夷时间',
    'Hide your data on the top page' => '在首页隐藏你的数据',
    'Highest (current period)' => '最高（当前时段内）',
    'Highest (this teammates)' => '最高（该名队友）',
    'Highest First' => '降序',
    'History' => '历史',
    'However, statistics information will be opened.' => '然而统计信息会公开',
    'I agree. Delete this battle.' => '我确认删除这场对战。',
    'I agree to the terms above.' => '我同意以上条款',
    'Icon' => '图标',
    'Idea: {source}' => '灵感：{source}',
    'If omitted, the channel set in the webhook configuration will be used.' => '如果忽略该值，将会使用Webhook配置中设定的频道。',
    'If omitted, the name set in the webhook configuration will be used.' => '如果忽略该值，将会使用Webhook配置中设定的名字。',
    'If there are any unsubmitted data, they have not been included in this tally.' => '该统计中不包含未提交的数据。',
    'If you already have an account, please click here.' => '如果已有帐户，请点击这里。',
    'If you change the screen name with this form, the change will take effect immediately.' => '如果使用这个表单更改登录名，更改将立即生效。',
    'If you delete this battle, it will be gone forever.' => '如果删除该对战，将无法恢复。',
    'If you have pages that you are sharing with URLs, most of them will be broken links.' => '如果你使用链接分享了页面，大多数情况链接将失效。',
    'If you have registered your login information in Password Manager, do not forget to update it.' => '如果你使用密码管理器，请不要忘记更新其中的账号信息。',
    'If you know our API Token' => '如果你有API令牌',
    'If you misuse this feature, you will be banned.' => '如果有滥用行为，你将会被封禁。',
    'Ika-Nakama' => 'Ika-Nakama',
    'Ika-Nakama User ID' => 'Ika-Nakama 用户ID',
    'IkaLog' => 'IkaLog',
    'IkaLog Download Page' => 'IkaLog下载页面',
    'IkaRec' => 'IkaRec',
    'IkaRec 2' => 'IkaRec 2',
    'Image Sharing' => '分享图片',
    'Includes battles with unknown event power' => '包含未知活动战力的对战',
    'Incomplete Data' => '不完整数据',
    'Ink Color' => '墨水颜色',
    'Inked' => '已涂地',
    'Inked/min' => '涂墨点数/分钟',
    'Inking Performance' => '涂地效率',
    'Inking Performance vs Win %' => '涂地效率与胜率',
    'Inkling' => '鱿鱼族',
    'Input new battle results' => '输入新对战数据',
    'In session' => '进行中',
    'Integrate' => '连接',
    'Internal ID' => '内部ID',
    'Interval' => '间隔',
    'In the chart, "{representative}" means greater than or equal to {min} and less than {max}.' => '在图表中，“{representative}”表示大于等于{min}且小于{max}。',
    'Invalid {0} or {1}.' => '无效的{0}或{1}。',
    'IQR' => '四分位距',
    'Items marked with these icons will only work with its corresponding version.' => '标有这些图标的项目只在其对应的版本中有效。',
    'It looks this data is corrupt.' => '数据似乎已损坏。',
    'Japan' => '日本',
    'Japan Time' => '日本时间',
    'Join us' => '加入我们',
    'JSON (IkaLog compat.)' => 'JSON（兼容IkaLog）',
    'JSON (stat.ink format, gzipped)' => 'JSON（兼容stat.ink，gzip压缩）',
    'JSON format' => 'JSON格式',
    'JSON format (All langs)' => 'JSON格式（全语言）',
    'Judge' => '裁判',
    'Just scaled for easy contrast, the Y-axis value does not directly indicate the number of people.' => '为了直观对比而被缩放，Y轴数值并不直接表示人数。',
    'Just {result} {rule} at {stage}' => '在{stage}， 结果是{result} {rule}',
    'k' => '杀敌数',
    'K+A/D' => '',
    'K+A/min' => '',
    'K-D' => '',
    'K/D vs Win %' => '杀死率与胜率',
    'K/min' => '杀敌数/分钟',
    'Keep doing it.' => '勤奋地参加对战或是打工吧～',
    'Kill or Assist' => '杀敌或助攻',
    'Kill Rate' => '杀敌率',
    'Kill Ratio' => '杀死比例',
    'Kills' => '杀敌数',
    'Kills (average):' => '杀敌数（平均）',
    'Kills (median):' => '杀敌数（中值）',
    'Kills / Deaths' => '杀敌数/死亡数',
    'Kills/min' => '杀敌数/分钟',
    'Kills and Deaths' => '杀敌数和死亡数',
    'Kills per minute' => '每分钟杀敌数',
    'Knockout' => '完胜',
    'KNOCKOUT!' => '完胜！',
    'Knockout Rate' => '完胜率',
    'KR' => '杀死比',
    'Lack of data' => '数据不足',
    'Language' => '语言',
    'Language (used for OStatus)' => '语言（用于OStatus）',
    'Last 24 Hours' => '最近24小时',
    'Last 24h: {winpct} win ({win}/{count}), Avg. {kill}k/{death}d' => '最近24小时： {winpct} 胜 ({win}/{count}), 平均{kill}杀/{death}死',
    'Last Month (UTC)' => '最近一个月（UTC时间）',
    'Last {n} Battles' => '最近{n}场对战',
    'Last {n} Periods' => '最近{n}段时间',
    'Latest' => '最新',
    'Launch' => '游戏发布',
    'League Power' => '组排能力',
    'Legend' => '标注',
    'Legends' => '标注',
    'less than {min} {name}' => '少于{min} {name}',
    'Level' => '级别',
    'Level (After)' => '级别（对战结束后）',
    'Link' => '链接',
    'Link from other user\'s results' => '链接到其他用户的结果',
    'Links' => '链接',
    'List' => '列表',
    'Loading...' => '载入中……',
    'Loaned Weapons' => '发放的武器',
    'Lobby' => '大厅',
    'Lobby (Icon)' => '大厅（图标）',
    'Location' => '位置',
    'Login' => '登录',
    'Login History' => '登录历史记录',
    'Login history will be deleted in {term}.' => '登录历史记录会于{term}内删除。',
    'Login Method' => '登录方法',
    'Log in with other services' => '使用其他服务登录',
    'Log in with Twitter' => '使用Twitter登录',
    'Logout' => '注销',
    'Lose' => '败',
    'Lost' => '败',
    'lost' => '败',
    'Low ink' => '墨水量少',
    'Luminance' => '亮度',
    'Luminance Difference' => '亮度差',
    'Mains' => '主武器',
    'Main Weapon' => '主武器',
    'Make empty this field when you are using Discord.' => '如果使用Discord，请在此留空。',
    'Many' => '许多',
    'Masked' => '已隐藏',
    'Max.' => '最大',
    'max={max} min={min} average={avg} median={median} mode={mode}' => '最大值={max} 最小值={min} 平均值={avg} 中位值={median} 众数={mode}',
    'max={max} min={min} median={median}' => '最大值={max} 最小值={min} 平均值={median}',
    'max={max} min={min} median={median} stddev={stddev}' => '最大值={max} 最小值={min} 平均值={median} 标准差={stddev}',
    'Maximum' => '最大值',
    'Max Inked' => '最大涂墨点数',
    'Max Kill Combo' => '最多杀敌数',
    'Max Kill Streak' => '最多连续杀敌数',
    'Medal' => '表彰',
    'Medals' => '获得的表彰',
    'Median' => '中位数',
    'Minimum' => '最小值',
    'MMMM y' => 'y\'年\'M\'月\'',
    'Mobile' => '手机',
    'Mode' => '模式',
    'Mode (Icon)' => '模式（图标）',
    'Mode (Short)' => '模式（简写）',
    'Mode{translate_hint_stats}' => '',
    'Monthly Report' => '月报',
    'more...' => '更多……',
    'more than {max} {name}' => '多于{max} {name}',
    'Moving Avg. ({0} Battles)' => '移动平均值（{0}场对战）',
    'My team\'s league power' => '我的组排能力值',
    'My team\'s splatfest power' => '我的祭典能力值',
    'My Team Count' => '我的队伍计数',
    'My Team Score' => '我的队伍分数',
    'My Team Splatfest Power' => '我的队伍祭典能力值',
    'Name' => '名字',
    'Name (for display)' => '名字（显示用）',
    'Neutral' => '中性',
    'New battle' => '新对战',
    'New Password' => '新密码',
    'New Password (again)' => '新密码（重复一次）',
    'New Screen Name (Login Name)' => '新登录名',
    'Next' => '下一个',
    'Next Battle' => '下一场对战',
    'Next Month' => '下月',
    'Next Stages' => '下一批场地',
    'Nintendo Network ID' => '任天堂网络ID',
    'Nintendo Switch Online app' => '任天堂Switch在线应用',
    'No' => '没有',
    'No battles' => '没有对战',
    'No black out' => '不隐藏名字',
    'No Data' => '没有数据',
    'No one in control' => '无人控制',
    'No redirects from old URLs will be made.' => '不会从旧的URL跳转',
    'Normal Distribution' => '正态分布',
    'North America/Oceania' => '北美/大洋洲',
    'Not configured.' => '未设置',
    'Not Draws' => '非平局',
    'Note' => '备注',
    'Note (private)' => '备注（私密）',
    'Note (public)' => '备注（公开）',
    'Not enough data is available.' => '数据不足',
    'Not Winning' => '非胜利',
    'Number of weapons seen' => '',
    'Octoling' => '章鱼圈',
    'Official Results' => '官方结果',
    'Official Twitter' => '官方Twitter',
    'Open Source Licenses' => '开源代码许可证',
    'Others' => '其它',
    'Overall Estimates' => '整体估计',
    'Password' => '密码',
    'Password (again)' => '确认密码',
    'PC' => 'PC',
    'Peak' => '巅峰',
    'Period' => '期间',
    'Permalink' => '永久链接',
    'Played With' => '一起游玩的玩家',
    'Player Distribution' => '玩家分布',
    'Players' => '玩家',
    'Players:' => '玩家：',
    'Please copy an API key below and paste to IkaLog, IkaRec or other apps that are compatible with {0}.' => '请复制以下API密钥并粘贴到IkaLog，IkaRec或其它兼容{0}的应用中。',
    'Please copy this URL:' => '请复制该网址：',
    'Please do not use this feature to destroy evidence.' => '请不要使用该功能来消除失败记录。',
    'Please keep it secret.' => '请确保这个私密不被公开。',
    'Please log in with your new password.' => '请用你的新密码登录。',
    'Please refer to the respective projects for any problems or questions regarding the operation of each application.' => '如有任何关于应用的问题或疑问，请参照其各自的项目。',
    'Please tell us about your capture environment and communication between your Wii U and User Agent (e.g. IkaLog). This information will be public.' => '请告诉我们你的录屏环境和Wii U与客户端（比如IkaLog）的沟通方式。这些内容会被公开。',
    'Please wait.' => '请等待。',
    'PNG/JPEG file up to {0}' => '最多允许{0}的PNG/JPEG文件',
    'Points' => '点数',
    'Position' => '位置',
    'Power' => '战力',
    'Powered by' => 'Powered by',
    'Power Level' => '真格战力',
    'Prev.' => '上一个',
    'Prev. Battle' => '上一场对战',
    'Prev. Month' => '上个月',
    'Previous Period' => '上一个时段',
    'Primary Ability' => '主要技能',
    'Primary ability is counted as {value_1_0} and secondary is counted as {value_0_3}.' => '',
    'Privacy Policy' => '隐私政策',
    'Profile and Settings' => '用户与设置',
    'Progress' => '进度',
    'Q<sub>1/4</sub>' => '前25%',
    'Q<sub>3/4</sub>' => '前75%',
    'Rank' => '段位',
    'Rank (After)' => '段位（之后）',
    'Rank (after the battle)' => '段位（对战之后）',
    'Rank-up Battle' => '晋级赛',
    'Rank: Current' => '当前段位：',
    'Rank: Peak' => '最高段位：',
    'Rank in Team' => '队中排名',
    'Rare Weapon' => '稀有武器',
    'Rate' => '杀敌率',
    'Ratio' => '杀死比',
    'Recent Battles' => '最近对战',
    'Recent Results' => '最近结果',
    'Recent Use %' => '最近使用率',
    'Regardless of your time zone setting, it is grouped using UTC.' => '以UTC时间计算，与你的时区设置无关。',
    'Regenerate your API token' => '重新生成你的API密钥',
    'Region (used for Splatfest)' => '地区（祭典时使用）',
    'Register' => '注册',
    'Regression Line' => '回归线',
    'Relative Time' => '相对时间',
    'Released' => '发布于',
    'Remember me' => '记住我',
    'Remote Follow' => '远程关注',
    'Replay Code' => '对战记忆代码',
    'Reset icon' => '重置头像',
    'Reset to default icon' => '重置为默认头像',
    'Reset your password' => '重置密码',
    'Reskin of' => '贴牌',
    'Result' => '结果',
    'Results of {name}\'s Battle' => '{name}的对战结果',
    'Room' => '房间',
    'Room info (Private)' => '房间信息（是否私房）',
    'S/min' => '特殊武器/分钟',
    'Salmon Run CSV' => '鲑鱼跑CSV',
    'Salmon Run JSON (gzipped)' => '鲑鱼跑JSON（gzip）',
    'Salmon Run results (CSV)' => '鲑鱼跑结果（CSV）',
    'Samples' => '样本数',
    'Save!' => '保存！',
    'Schedule' => '日程安排',
    'Scheduled' => '已安排',
    'Schema' => '',
    'Schema information' => '配色信息',
    'Screen Name' => '登录名',
    'Screen Name (Login Name)' => '登录名',
    'Search' => '搜索',
    'Search {date}' => '搜索 {date}',
    'Search {from} - {to}' => '搜索 从{from}到{to}',
    'Season' => '赛季',
    'Secondary Abilities' => '次要技能',
    'Seconds' => '秒',
    'Sent an email to your email address. Please check your mailbox and get the verification code.' => '已发送验证邮件到你的邮箱。请检查邮箱获取验证码。',
    'Series Progress' => '挑战进度',
    'Session History' => '登录信息',
    'Set the name, icon, and channel in the settings within Discord.' => '请在Discord的设置中设定名字、头像和频道。',
    'Settings' => '设置',
    'Show All Players' => '显示所有玩家',
    'Show moving averages' => '显示移动平均值',
    'Show your API Token' => '显示你的API密钥',
    'Show your data on the top page' => '在首页显示你的数据',
    'Significant?' => '是否显著？',
    'Simplified List' => '简化列表',
    'Since the acquisition of Twitter by Elon Musk, the environment for third-party applications has deteriorated rapidly and extremely.' => '自从Twitter被Elon Musk收购以来，第三方应用的环境迅速恶化。',
    'Slack' => 'Slack',
    'Slack Integration' => 'Slack集成支持',
    'Source: {source}' => '来源：{source}',
    'Source Code' => '源代码',
    'Sp' => '',
    'Special' => '特殊武器',
    'Special %' => '特殊武器 %',
    'Special (Icon)' => '特殊武器（图标）',
    'Special:' => '特殊武器：',
    'Special Battle' => '特殊对战',
    'Special Battle (Fest)' => '特殊对战（祭典）',
    'Special Charged' => '特殊武器蓄满',
    'Specials' => '特殊武器',
    'Specials/min' => '特殊武器/分钟',
    'Special Uses' => '特殊武器使用',
    'Species' => '物种',
    'Specify Period' => '指定时间段',
    'Splatfest' => '祭典',
    'Splatfest Power' => '祭典能力值',
    'Splatfest Power (Normal)' => '祭典能力值（普通）',
    'Splatfest Power (Pro)' => '祭典能力值（专业）',
    'Splatfest Region:' => '祭典地区',
    'Splatfest Stats' => '祭典统计',
    'Splatfest Title' => '祭典称号',
    'Splatfest Title (After)' => '祭典称号（之后）',
    'SplatNet' => 'SplatNet',
    'SplatNet #' => 'SplatNet编号',
    'SplatNet 2' => 'SplatNet 2',
    'SplatNet Battle #' => 'SplatNet对战编号',
    'Splatoon' => '斯普拉遁',
    'Splatoon 2' => '斯普拉遁 2',
    'Splatoon 3' => '斯普拉遁 3',
    'Splatoon Official Website (Japan)' => 'Splatoon官方站点（日本）',
    'Splatoon Official Website (UK)' => 'Splatoon官方站点（英国）',
    'Splatoon Official Website (US/Canada)' => 'Splatoon官方站点（美国/加拿大）',
    'Stack' => '叠加',
    'Stacked' => '叠加',
    'Stage' => '场地',
    'Stage (Short)' => '场地（简写）',
    'Stages' => '场地',
    'Standard Deviation' => '标准差',
    'Stats' => '统计',
    'Stats (by Mode)' => '统计（按模式）',
    'Stats (by Mode and Stage)' => '统计（按模式与场地）',
    'Stats (by Stage)' => '统计（按场地）',
    'Stats (by Weapon)' => '统计（按武器）',
    'Stats (Cause of Death)' => '统计（死因）',
    'Stats (Medals)' => '统计（表彰）',
    'Stats (Ranked Battle)' => '统计（排名对战）',
    'Stats (Splatfest)' => '统计（祭典）',
    'Stats (Turf War)' => '统计（涂地对战)',
    'Stats (vs. Weapon)' => '统计（敌方武器）',
    'Stats (Win %)' => '统计（胜率）',
    'Stats (X Power)' => '统计（X战力）',
    'Stats ({rule})' => '统计（{rule}）',
    'Stats: FestPwr diff vs Win %' => '统计：祭典能力差值与胜率',
    'Stats: Stages' => '统计：场地',
    'Stats: User Activity' => '统计：用户活动',
    'Std Dev' => '标准差',
    'Stealth Jump Equipment Rate' => '隐身跳跃装备率',
    'streak' => '连续',
    'Sub:' => '副武器：',
    'Subs' => '副武器',
    'Sub Weapon' => '副武器',
    'Sub Weapon (Icon)' => '副武器（图标）',
    'Summarize' => '总结',
    'Summary: Based on the current filter' => '汇总报告：基于当前筛选标准',
    'Synergy Bonus' => '整齐奖励',
    'Systematic error of win %' => '胜率系统误差',
    'Tablet' => '平板',
    'Target Player\'s Team' => '指定玩家的队伍',
    'Team' => '队伍',
    'Team Icon' => '队伍（图标）',
    'Team ID' => '队伍ID',
    'Team Inked' => '队伍涂墨点数',
    'Team {theme}' => '队伍{theme}',
    'Test' => '测试',
    'Thanks to {user} for their contribution.' => '感谢 {user} 的贡献。',
    'The abilities valid only for the primary means the rate of mounting.' => '',
    'The correction value specified by the user is applied.' => '已应用用户指定的修正值。',
    'The data contains a large error margins.' => '数据包含大量的误差。',
    'The data is intended to be analyzed using spreadsheet software (Excel, etc.) or programs to analyze.' => '该数据旨在用于电子表格软件（Excel等）或程序的分析。',
    'The data is not something you will know immediately after downloading.' => '下载此数据后，并不能即刻获取直观结论。',
    'The estimated distribution of the overall game, as estimated from the official results.' => '根据官方结果估计的整体游戏分布。',
    'The estimated location may be inaccurate.' => '估计的位置可能不准确。',
    'The filter specifying XP and version, aggregates data for the overall <code>x.y</code>, ignoring the <code>z</code> in version <code>x.y.z</code>.' => '',
    'The future of Twitter integration is completely uncertain, and as a {site} developer I can\'t recommend this feature at this time.' => 'Twitter集成的未来完全不明朗，{site}的开发者目前不推荐这个功能。',
    'The icon will be:' => '该图标会变成：',
    'Their team\'s league power' => '对方队伍的组排能力值',
    'Their team\'s splatfest power' => '对方队伍的祭典能力值',
    'Their Team Count' => '对方队伍计数',
    'Their Team Score' => '对方队伍分数',
    'Their Team Splatfest Power' => '对方队伍祭典能力值',
    'Themes from {name}' => '来自于{name}的主题',
    'The old name will be available immediately for reuse.' => '旧名字将会立即可被他人使用。',
    'The password will be encrypted.' => '密码会被加密',
    'The post will be in the language set here.' => '将以此处设定的语言发布',
    'There are no data.' => '没有数据',
    'There is no user associated with the specified twitter account.' => '没有用户绑定该Twitter帐号。',
    'These battles were recorded with an outdated version of IkaLog. Please upgrade to the latest version.' => '这些对战是由旧版的IkaLog记录。 请更新到最新版本。',
    'The width of the histogram bins is automatically adjusted by Scott\'s rule-based algorithm.' => '直方图的宽度由基于Scott\'s rule的算法自动进行调整。',
    'This battle was recorded with an outdated version of IkaLog. Please upgrade to the latest version.' => '该对战是由旧版的IkaLog记录。请更新到最新版本。',
    'This chart assumes simple normal distribution of the Power to make it easier to compare each mode.' => '为了方便比较每个模式，此表格假设战力是简单正态分布的。',
    'This data is based on {siteName} users and differs significantly from overall game statistics.' => '此数据基于{siteName}用户，与整体游戏统计数据有很大差异。',
    'This data is basically not informative.' => '此数据基本上没有参考价值。',
    'This data was totaled after normalization to 5 minute intervals for each battle.' => '该数据是根据每场对战五分钟的间隔做归一化处理后汇总的。',
    'This document is under a <a href="http://creativecommons.org/licenses/by/4.0/deed.en">Creative Commons Attribution 4.0 International License</a>.' => '该文档基于<a href="http://creativecommons.org/licenses/by/4.0/deed.zh">Creative Commons Attribution 4.0 International License</a>共享。',
    'This feature is disabled by default.' => '该功能默认关闭。',
    'This information will be public. Integration for "log in with twitter" can be done from the profile page.' => '这些信息会被公开。可以从用户页面绑定Twitter帐号。',
    'This is a Discord-specific behavior.' => '这是Discord特有的表现。',
    'This is a wild guess based on past results and {siteName} posts.' => '这是根据过去的结果和 {siteName} 的帖子的大胆的猜测。',
    'This Month (UTC)' => '本月（UTC）',
    'This option is provided for deleting an incorrectly-reported battle.' => '该选项用于删除错误上传的对战。',
    'This should be a random string of at least {n} characters and should not be the same as any other site' => '这应该是一个至少{n}个字符的随机字符串，并且不能与其他站点相同',
    'This twitter account has already been integrated with another user.' => '已经有用户绑定该Twitter帐号。',
    'This website doesn\'t support Internet Explorer. Please use a modern browser, for example Chrome or Firefox.' => '本网站不支持IE。请使用现代网络浏览器，比如Chrome或Firefox。',
    'This website has color-blind support. Please check "Color-Blind Support" in the "Username/Guest" menu of the navbar to enable it.' => '本网站提供色盲辅助。请在导航栏的“用户/游客”菜单下勾选“色盲辅助”。',
    'This website is an open source project. It is under the MIT License. The source code is available on GitHub.' => '本网站是开源项目（基于MIT开源协议）。源代码可在GitHub查看。',
    'This website is an UNOFFICIAL SERVICE. It is not related to the Splatoon development team or Nintendo.' => '本网站不是官方服务。与任天堂及其Splatoon开发团队没有关系。',
    'This will be made public as part of URL' => '将会作为URL的一部分被公开',
    'This {attribute} is already in use.' => '该{attribute}已经启用。',
    'Time' => '时间',
    'Time is up' => '时间到',
    'Times' => '次数',
    'Time was up' => '时间到',
    'Time Zone' => '时区',
    'Title' => '称号',
    'Title (After)' => '称号（之后）',
    'To change your password using this feature, contact the administrator first.' => '请联系管理员来使用该功能更改密码。',
    'Today' => '今天',
    'Top {percentile}%' => 'TOP {percentile}%',
    'Total' => '总计',
    'Total Clout' => '贡献度总计',
    'Total Clout (After the battle)' => '贡献度总计（对战之后）',
    'Total Inked' => '涂地总计',
    'To use Discord integration, make a webhook on your Discord server first.' => '要使用Discord集成，首先在你的Discord服务器上创建一个Webhook。',
    'To use Slack integration, you need to configure Slack\'s "Incoming Webhook" first.' => '要使用Slack集成，你需要先配置Slack的传入Webhook。',
    'Trends' => '趋势',
    'Try to secure the Ultra Signal' => '尝试保护超级信号',
    'Turf Inked' => '涂墨点数',
    'Turf inked (including bonus)' => '涂墨点数（包含奖励）',
    'Turf Inked + Bonus' => '涂墨点数和奖励',
    'TV' => '电视',
    'Twitter @name' => 'Twitter @昵称',
    'TZ' => '时区',
    'Ultra Signals' => '超级信号',
    'Uniform' => '工作服',
    'Unknown' => '未知',
    'Unknown Result' => '未知结果',
    'Unlink account' => '取消绑定',
    'Update' => '更新',
    'Update Your Email Address' => '更新你的电子邮件地址',
    'Update Your Icon' => '更新头像',
    'Update Your Password' => '更新密码',
    'Update Your Profile' => '更新档案',
    'Update Your Screen Name' => '更新登录名',
    'Upload icon' => '上传头像',
    'Upload new image' => '上传新图片',
    'URL related to this battle' => '这场对战的网址',
    'Use %' => '使用 %',
    'Use % and Win %' => '使用 % 和 赢 %',
    'Used in global stats' => '用于全局统计',
    'Use full width of the screen' => '使用全部的屏幕宽度',
    'Use profile icon of your twitter account' => '使用Twitter登录头像',
    'User Agents in last 24 hours' => '最近一天的客户端',
    'User Count' => '用户总数',
    'User Name' => '用户名字',
    'Users' => '用户',
    'Use your profile icon' => '使用档案头像',
    'Verification Code' => '验证码',
    'Verify' => '验证',
    'Version' => '版本',
    'Version {0}' => '版本 {0}',
    'Victory' => '胜',
    'Victory or Defeat' => '胜利或失败',
    'View Settings' => '显示设置',
    'Vote %' => '投票率',
    'We\'ll send an email when you log in to the website or change your password.' => '登录网站或是更改密码后我们会给你发送一封邮件。',
    'Weapon' => '武器',
    'Weapon (Icon)' => '武器（图标）',
    'Weapon (Short)' => '武器（简写）',
    'Weapon icons were created by {0}.' => '武器图标由{0}创建。',
    'Weapons' => '武器',
    'Weapon Stats' => '武器统计',
    'Weapon Trends' => '武器趋势',
    'Weapon | {weapon}' => '武器 | {weapon}',
    'Weapon | {weapon} | {rule}' => '武器 | {weapon} | {rule}',
    'Webhook URL' => 'Webhook URL',
    'Win' => '胜',
    'Win %' => '胜率',
    'Win % (Total)' => '胜率（总计）',
    'Win % ({0} Battles)' => '胜率（{0}场对战）',
    'Winning Percentage' => '胜率',
    'Winning Percentage based on K/D' => '基于杀死率的胜率',
    'Wins' => '胜利数',
    'Win streak (Bad guys)' => '连胜（对方）',
    'Win streak (Good guys)' => '连胜（我方）',
    'Win Streak: {count}' => '连胜数：{count}',
    'Won' => '胜',
    'won' => '胜',
    'Won / Lost' => '胜/败',
    'X Power' => 'X战力',
    'X Power (after)' => 'X战力（之后）',
    'Yes' => '是',
    'Yesterday' => '昨天',
    'You' => '你',
    'You can\'t use an IDN (Internationalized Domain Names) email address' => '你不能使用IDN（国际化域名）邮箱地址',
    'You can delete this battle.' => '你可以删除该对战。',
    'You cannot use the same {attribute} as your current one.' => '你不能使用与现在相同的{attribute}。',
    'You can register (estimated) unsent values here to correct the values displayed.' => '你可以在这里记录（推测的）未上传的数据来更正显示的值。',
    'You can specify Discord\'s Slack compatible endpoint URL as well.' => '你也可以指定Discord的Slack兼容URL。',
    'You must agree to the above to delete this battle.' => '你必须同意以上内容方可删除该对战。',
    'Your Battles' => '我的主页',
    'Your browser does not support this action.' => '你的浏览器不支持该行为。',
    'Your current icon:' => '你现在的头像',
    'Your current image will be deleted and reset to auto-generated image.' => '你现在的头像会被删除并且重置为自动生成的图片。',
    'Your data will no longer appear in the public list on the top page.' => '你的数据将不再出现在首页的公开列表中。',
    'Your page will still be public, but it will be harder to access.' => '你的个人主页仍然是公开的，但是将更难被找到。',
    'Your password has been changed successfully.' => '你的密码已成功更改。',
    'Your profile icon has been updated.' => '你的头像已更新',
    '[Outdated]' => '[已过时]',
    '{0} etc.' => '{0}等',
    '{0}×{1} or less resolution' => '{0}×{1} 或更低的分辨率',
    '{attribute} must be at most 15 alphanumeric or underscore characters.' => '{attribute} 最多是15个字母或数字或下划线。',
    '{decimal5_7} Format' => '{decimal5_7} 格式',
    '{from} - {to}' => '{from}～{to}',
    '{lower}-{upper} percentile' => '{lower}～{upper} 百分位数',
    '{n,plural,=1{battle} other{battles}}' => '对战',
    '{name}\'s Badge Progress' => '{name}的徽章进度',
    '{name}\'s Battle' => '{name}的对战',
    '{name}\'s Battle Report' => '{name}的对战报告',
    '{name}\'s Battles' => '{name}的对战',
    '{name}\'s Battle Stats (by Mode)' => '{name}的对战统计（按模式）',
    '{name}\'s Battle Stats (by Mode and Stage)' => '{name}的对战统计（按模式和场地）',
    '{name}\'s Battle Stats (by Stage)' => '{name}的对战统计（按场地）',
    '{name}\'s Battle Stats (by Weapon)' => '{name}的对战统计（按武器）',
    '{name}\'s Battle Stats (Cause of Death)' => '{name}的对战统计（死因）',
    '{name}\'s Battle Stats (Medals)' => '{name}的对战统计（表彰）',
    '{name}\'s Battle Stats (Ranked Battle)' => '{name}的对战统计（排名模式）',
    '{name}\'s Battle Stats (Splatfest)' => '{name}的对战统计（祭典）',
    '{name}\'s Battle Stats (Turf War)' => '{name}的对战统计（涂地模式）',
    '{name}\'s Battle Stats (vs. Weapon)' => '{name}的对战统计（对方武器）',
    '{name}\'s Battle Stats (Winning Rate)' => '{name}的对战统计（胜率）',
    '{name}\'s Battle Stats ({rule})' => '{name}的对战统计（{rule}）',
    '{name}\'s Favorite Weapon' => '{name}的最爱的武器',
    '{name}\'s Monthly Report - {date}' => '{name}的每月报告 - {date}',
    '{name}\'s Splat Log' => '{name}的斯普拉遁记录',
    '{name}\'s X Power' => '{name}的X战力',
    '{nFormatted} remaining' => '剩余{nFormatted}',
    '{nFormatted} {n, plural, =1{battle} other{battles}}' => '{nFormatted}次对战',
    '{nFormatted} {n, plural, =1{time} other{times}}' => '{nFormatted}次',
    '{number, plural, =1{1 death} other{# deaths}} in {battle, plural, =1{1 battle} other{# battles}}' => '{battle}次对战中死亡{number}次',
    '{number, plural, =1{1 egg} other{# eggs}} in {battle, plural, =1{1 shift} other{# shifts}}' => '{battle}次打工中收获{number}枚鲑鱼卵',
    '{number, plural, =1{1 kill} other{# kills}}' => '{number}次击杀',
    '{number, plural, =1{1 kill} other{# kills}} in {battle, plural, =1{1 battle} other{# battles}}' => '{battle}次对战中杀敌{number}次',
    '{number, plural, =1{1 time} other{# times}} in {battle, plural, =1{1 shift} other{# shifts}}' => '{battle}次打工的{number}次',
    '{package} is used for icons and other images.' => '{package} 用于图标和其他图片。',
    '{pct_point} percentage point' => '{pct_point}百分点数',
    '{pct}% CI' => '{pct}%置信区间',
    '{pct} % loss' => '{pct}%失败率',
    '{pct}% Significant?' => '{pct}%显著？',
    '{pct} ({dupf} DU/F)' => '{pct} ({dupf} 单位距离/帧)',
    '{percentile} Percentile' => '{percentile}百分位数',
    '{point, plural, =1{1 point} other{# points}} in {battle, plural, =1{1 battle} other{# battles}}' => '{battle}次对战中获得{point}点',
    '{point, plural, other{#p}}' => '{point}点',
    '{point}p' => '{point}点',
    '{rule}: Current' => '{rule}:现在',
    '{rule}: Peak' => '{rule}: 最高',
    '{sec,plural,=1{# second} other{# seconds}}' => '{sec}秒',
    '{sec} seconds' => '{sec}秒',
    '{sec} seconds ({pct} %)' => '{sec} 秒 ({pct} %)',
    '{sec} seconds, {cnt} times' => '{sec} 秒, {cnt} 次',
    '{siteName} Discord Community' => '{siteName} Discord社区',
    '{theme} Theme' => '{theme}主题',
    '{title} Official Website' => '{title}官方站点',
    '~{estPower}' => '约{estPower}',
    '~{point}p' => '约{point}点',
    '×{times}' => '×{times}',
];
