<?php

/**
 * @copyright Copyright (C) 2015-2024 AIZAWA Hina
 * @license https://github.com/fetus-hina/stat.ink/blob/master/LICENSE MIT
 * @author AIZAWA Hina <hina@fetus.jp>
 * @author Gosin <canling0@gmail.com>
 * @author imspace <spacemeowx2@gmail.com>
 * @author Yifan Liu <yifanliu00@gmail.com>
 */

declare(strict_types=1);

return [
    'Ability' => '技能',
    'Ability information' => '技能信息',
    'About UUID, refer [RFC 4122](https://tools.ietf.org/html/rfc4122).' => '关于 UUID， 参考[RFC 4122](https://tools.ietf.org/html/rfc4122).',
    'Accepts `1`-`50` (otherwise)' => '接受 `1`-`50` (其它)',
    'Accepts `1`-`1000` (if `only` = `splatnet_number`)' => '接受 `1`-`1000` (如果 `only` = `splatnet_number`)',
    'All battle statistics' => '所有对战统计',
    'An API Token with bearer auth format.' => '一个有使用者授权格式的API密钥',
    'A play data of this post owner' => '该上传者的比赛数据',
    'As the number of supported languages changes, the position of items may change.' => '随着支持语言的增加，物品的位置可能会改变',
    'A unique ID to identify the results' => '一个唯一的ID用来区分结果',
    'Average inked per battle' => '平均每场涂墨点数',
    'Battle results page URL' => '对战结果网址',
    'Be sure to check the header on the first line (or use JSON version) if you use this data for automatic processing.' => '如果使用该数据来进行自动处理，一定要检查第一行的header（或者使用JSON版本）',
    'Boss' => '关主',
    'Boss appearances' => '关主出现次数',
    'Boss information' => '关主信息',
    'Brand' => '品牌',
    'Brand information' => '品牌信息',
    'Call [`GET {url}`]({link}) and retrieve already posted shift numbers.' => '用 [`GET {url}`]({link}) 来获取已经上传的打工次数',
    'Change the result set' => '改变结果集合',
    'Choose `no` if this user\'s posts may be arbitrarily selected.' => '如果该用户的上传数据可以任意选择，请选择 `no`。',
    'Cleared the shift' => '完成打工',
    'Client application should specify a UUID to detect duplicated shift.' => '客户端软件要设置UUID来区分重复的打工。',
    'Common ability' => '常见技能',
    'Created' => '创建于',
    'Crew members\' (except `my_data`) data, typically have 3 elements' => '打工成员数据（除自己的数据以外），通常还有三个 ',
    'Crew members rescued' => '救援队友数量',
    'Current date time will be used if omitted' => '如果忽略，就会使用当前日期',
    'Current rank' => '现在的排名',
    'Current X-power' => '现在的X能量',
    'Date and time when ready to play' => '开始对战的日期和时间',
    'Deaths per battle' => '每场死亡数',
    'Deaths per minute' => '每分钟死亡数',
    'Do not rely on this behavior.' => '不要依赖该行为',
    'Effects' => '效果',
    'End time of this shift' => '本次打工结束时间',
    'Event' => '事件',
    'Event information' => '事件信息',
    'Example:' => '例子：',
    'Failed the shift' => '打工失败',
    'Fail reason' => '失败原因',
    'Fetch data from SplatNet 2.' => '从SplatNet 2获取数据',
    'Filter by brand' => '根据品牌过滤',
    'Filter by gear category' => '根据装备类型过滤',
    'Filter by permanent ID' => '根据永久ID过滤',
    'Filter by primary ability' => '根据主技能过滤',
    'Filter by stage' => '根据场地过滤',
    'Filter by user' => '根据用户过滤',
    'Filter unposted shifts and post to us.' => '根据未上传的打工过滤并上传',
    'Found same data' => '发现相同数据',
    'Gear category' => '装备类别',
    'Gender' => '性别',
    'Gender information' => '性别信息',
    'Generate a UUID version 3 or 5 on your side with your own namespace' => '使用你自己的命名空间来自行生成UUID 第三版或第五版',
    'Generate a UUID version 4 on your side' => '自行生成第四版的UUID',
    'Generate a UUID version 5 with namespace `{ns}`.' => '使用该命名空间 `{ns}` 生成第五版的UUID',
    'Get gears' => '获得装备',
    'Get gears in CSV format' => '获得装备（CSV格式）',
    'Get modes' => '获得模式',
    'Get Salmon Run results' => '获得鲑鱼打工结果',
    'Get Salmon Run results (with Auth)' => '获得鲑鱼打工结果（有授权）',
    'Get Salmon Run stats (card data)' => '获得鲑鱼打工统计（卡片数据）',
    'Get stages' => '获得场地',
    'Get stages (obsoleted)' => '获得数据（废弃）',
    'Get the Salmon Run results' => '获得鲑鱼打工结果',
    'Get user\'s battle stats' => '获得用户的对战统计',
    'Get weapons' => '获得武器',
    'Get weapons in CSV format' => '获得武器（CSV格式）',
    'Golden Egg appearances' => '金鲑鱼卵出现次数',
    'Golden Eggs collected' => '金鲑鱼卵收集数量',
    'Golden Eggs delivered' => '金鲑鱼卵送回数量',
    'Hazard Level, 200.0 = "Hazard Level MAX!!"' => '危险系数，200.0 = 最危险！',
    'Highest rank ever' => '历史最高排名',
    'Highest X-power ever' => '历史最高X能量',
    'How many appearance' => '出现多少次',
    'How many bosses appearances' => '关主出现多少次',
    'How many cleared waves' => '打通几波',
    'How many times special weapon used in each wave' => '每波用了多少次特殊武器',
    'How many times the special weapon was used in each wave' => '',
    'How to create the UUID:' => '如何创建UUID',
    'HTML version' => 'HTML版本',
    'If automated.' => '如果自动输入',
    'If it is a weapon that only looks different, like the Hero series, this points to the original weapon.' => '如果只是武器外观不同，比如说英雄系列，这个会指向原版武器。',
    'If manual input.' => '如果手动输入',
    'If not appearances the boss, you can send `0` or omit the boss.' => '如果该关主没有出现，你可以输入`0`或者忽略该关主。',
    'If not kills the boss, you can send `0` or omit the boss.' => '如果没有杀死该关主，你可以输入`0`或者忽略该关主。',
    'If omitted, we will automatically generate a random UUID.' => '如果忽略，我们会随机生成UUID。',
    'If the value is not correct as a UUID, we will use that value as a seed to generate a UUID.' => '如果该值不是正确的UUID，我们会以它为种子生成一个UUID',
    'If you omitted the <code>id</code>, you will get a latest data.' => '如果忽略了 <code>id</code>, 你会得到最新的数据.',
    'If your client doesn\'t/cannot detect this data, omit this field or send just `null`.' => '如果你的客户端没有该数据，忽略它或者是设为`null`。',
    'If you specified other player\'s <code>id</code> value, you will get the 404 error.' => '如果你设置了其他玩家的<code>id</code>， 你会得到一个404错误。',
    'IkaLog environment. This probably doesn\'t make sense in Splatoon 2' => 'IkaLog环境下。 对Splatoon 2来说这个可能无意义。',
    'Information about each wave' => '每波的信息',
    'Is automated posting process?' => '是自动化上传吗？',
    'Is player cleared the shift?' => '玩家完成打工了吗？',
    'Is the post with automated process?' => '这次上传是自动化的过程吗？',
    'It can be obtained from the [user settings page](https://stat.ink/profile).' => '可以从[用户设置页面](https://stat.ink/profile)获取',
    'Kill ratio' => '杀死比',
    'Kills per battle' => '每场杀敌数',
    'Kills per minute' => '每分钟杀敌数',
    'Last updated at' => '最后一次更新于',
    'Main Power Up effects information' => '主能力加强信息',
    'Maximum inked' => '最大涂墨点数',
    'Max records to get' => '获取最大土地面积',
    'Mode' => '模式',
    'Mode information' => '模式信息',
    'Name of the user agent' => '用户代理信息',
    'Name of your client' => '你的客户端名称',
    'Newer to older (default in most case)' => '从新到旧（多数情况下默认）',
    'Nintendo Network ID' => '任天堂网络ID',
    'Nintendo Switch Friend Code' => '任天堂好友码',
    'Note: this value may not be in SplatNet JSON.' => '注意：SplatNet的JSON数据中可能没有该值。',
    'Nothing send (Disabled duplicate detection)' => '没有任何发送（关闭重复检查）',
    'Number of battles' => '对战数量',
    'Number of cleared waves. 3 if cleared, 0 if failed in wave 1.' => '完成打工数。 如果完成是3，如果第一波就失败是0。',
    'Number of kills the boss salmonid' => '杀死的巨大鲑鱼数',
    'Number of times rescued by other players' => '被队友救援数',
    'Number of times rescued other players' => '救援队友数',
    'Number of times the player kills each boss' => '杀死每种巨大鲑鱼数',
    'Number of times the player kills {boss}' => '杀死巨大鲑鱼 {boss} 数',
    'Obsoleted and no longer used' => '废弃并且不再使用',
    'Older to newer' => '从旧到新',
    'Otherwise' => '否则',
    'Permanent ID' => '永久ID',
    'Permanent ID of the results' => '结果的永久ID',
    'Per rule information' => '每个规则信息',
    'Player\'s data' => '玩家的数据',
    'Player\'s in-game name' => '玩家的游戏昵称',
    'Player name' => '玩家名字',
    'Player results' => '游戏结果',
    'Posted time' => '发布时间',
    'Post Salmon Run results' => '发布鲑鱼打工结果',
    'Post Salmon Run stats (card data)' => '发布鲑鱼打工统计（卡片数据）',
    'Power Eggs collected' => '收集的鲑鱼卵数',
    'Primary ability' => '主要技能',
    'Profile page URL' => '个人主页',
    'Public URL' => '公开网址',
    'Quota' => '打工目标',
    'Quotas calculated by Hazard Level' => '根据危险系数计算的打工目标',
    'Ranked + league battle statistics' => '排名 + 组队的数据统计',
    'Reason' => '原因',
    'Redirect' => '重定向',
    'Refer "category1"' => '参考 "类别1"',
    'Refer to [RFC 4122](https://tools.ietf.org/html/rfc4122) for format details.' => '格式细节请参考[RFC 4122](https://tools.ietf.org/html/rfc4122)',
    'Result order' => '结果顺序',
    'Returns all of gear information in CSV (RFC 4180) format.' => '返回所有装备信息（CSV (RFC 4180)格式）',
    'Returns all of weapon information in CSV (RFC 4180) format.' => '返回所有武器信息（CSV (RFC 4180)格式）',
    'Returns an array of gear information' => '返回装备信息列表',
    'Returns an array of mode information' => '返回模式信息列表',
    'Returns an array of stage information' => '返回场地信息列表',
    'Returns an array of weapon information' => '返回武器信息列表',
    'Returns only SplatNet\'s ID Numbers' => '仅返回SplatNet的ID数',
    'Returns Salmon Run results.' => '返回鲑鱼打工结果',
    'Returns Salmon Run stats.' => '返回鲑鱼打工统计',
    'Returns specified user\'s stats (e.g., how many kills)' => '返回指定的玩家统计（比如杀敌数）。',
    'Returns the Salmon Run results.' => '返回鲑鱼打工结果',
    'Salmon Run fail reason' => '鲑鱼打工失败原因',
    'Salmon Run results page URL' => '鲑鱼打工结果网址',
    'Salmon Run stats' => '鲑鱼打工统计',
    'Salmon Run title (consider gender)' => '鲑鱼打工称号（考虑性别）',
    'Salmon Run title (doesn\'t consider gender)' => '鲑鱼打工称号（不考虑性别）',
    'Salmon Run title information' => '鲑鱼打工称号信息',
    'Set `null`, empty string or omit the field if no event.' => '如果没有事件，设为`null`， 空白字符串或是忽略该区。',
    'Sex code defined in ISO 5218' => 'ISO 5218定义的性别码',
    'Shift number in SplatNet 2' => 'SplatNet 2中的打工班次号',
    'Shifts (jobs) worked' => '鲑鱼打工次数',
    'Special weapon' => '特殊武器',
    'Special weapon information' => '特殊武器信息',
    'Species' => '物种',
    'SplatNet\'s `principal_id`' => 'SplatNet 的 `principal_id`',
    'SplatNet 2 based Application' => '以SplatNet 2为基础的应用',
    'SplatNet number big to small (default if "only" = "splatnet_number")' => 'SplatNet数从大到小（如果"only" = "splatnet_number"时的默认设置）',
    'SplatNet number small to big' => 'SplatNet数从小到大',
    'SplatNet specified ID' => 'SplatNet指定ID',
    'Stage' => '场地',
    'Stage information' => '场地信息',
    'Standalone Application (e.g., user\'s input or screen capture)' => '独立应用（比如用户的输入或录屏）',
    'Start time of this shift' => '打工开始时间',
    'stat.ink API for Splatoon 2' => '针对Splatoon 2的stat.ink API',
    'Stat.ink user ID' => 'Stat.ink用户ID',
    'Statistics for {rule}' => '针对{rule}的统计',
    'Sub weapon' => '副武器',
    'Sub weapon information' => '副武器信息',
    'Successful' => '成功',
    'Teammates\' play data' => '队友数据',
    'The API endpoint will return `302 Found` if job has same UUID posted in last 24 hours.' => '如果最近一天内发现同样UUID的打工，API会返回`302 已找到`。',
    'The API Token is issued for each user by stat.ink system.' => 'stat.ink会给每个用户单独生成API密钥。',
    'The time when this rotation (play window) started in unix time format.' => '对战排班起始时间使用UNIX时间格式。',
    'The time when this shift ended in unix time format.' => '打工结束时间使用UNIX时间格式。',
    'The time when this shift started in unix time format.' => '打工开始时间使用UNIX时间格式。',
    'The value of <code>id</code> is obtained in the Location header of the POST API.' => '<code>id</code>的值来自于POST API的头部位置的报文。',
    'This API has been obsoleted.' => '该API已经废弃使用。',
    'This is helpful for unintended duplication, but it is helpless for complate detect duplication.' => '这仅对简单重复有效，但是对复杂的重复检测无能为力。',
    'This parameter is required if you set `only` = `splatnet_number`.' => '如果设置`only` = `splatnet_number`，那么必需提供该参数。',
    'This parameter is required if `{name}` set.' => '如果设置了`{name}`， 那么必需提供该参数。',
    'This points to the main weapon.' => '这个指向主武器。',
    'Title' => '称号',
    'Title (after the shift)' => '称号（打工之后）',
    'Title (before the shift)' => '称号（打工之前）',
    'Title points (after the shift)' => '称号分数（打工之前）',
    'Title points (before the shift)' => '称号分数（打工之后）',
    'Total area' => '涂地总面积',
    'Total deaths' => '死亡总数',
    'Total inked' => '涂地总分',
    'Total kills' => '杀敌总数',
    'Total points' => '总分数',
    'Turf War statistics' => '涂地对战统计',
    'Twitter screen name' => 'Twitter显示名称',
    'Uncommon ability' => '罕见技能',
    'Unique ID (UUID)' => '唯一ID（UUID）',
    'Unique ID of the player' => '该玩家的唯一ID',
    'Unknown result' => '未知结果',
    'URL for API call' => 'API呼叫地址',
    'URL for API call that created' => 'API呼叫生成的地址',
    'URL that related to this post. (e.g., YouTube video)' => '相关网址（比如YouTube视频地址）',
    'Use "`splatnet_number`@`principal_id`" format. (Example: `{example}`)' => '使用"`splatnet_number`@`principal_id`"格式（比如：`{example}`）',
    'User\'s private note' => '用户私人笔记',
    'User\'s screen name' => '用户的显示昵称',
    'User agent information' => '用户代理信息',
    'User information' => '用户信息',
    'User name' => '用户名字',
    'User note' => '用户笔记',
    'User profile' => '用户档案',
    'User registered at' => '用户注册于',
    'Use [`{path}`]({link}) instead of this.' => '请使用这个[`{path}`]({link})',
    'Value' => '值',
    'Version of the user agent' => '用户代理版本',
    'Version of your client' => '你的客户端版本',
    'Water level' => '水位',
    'Water level information' => '水位信息',
    'Wave informations' => '阶段信息',
    'Weapon' => '武器',
    'Weapon category' => '武器类别',
    'Weapon category information' => '武器类别信息',
    'Weapons loaned in each wave' => '每个阶段提供的武器',
    'We recommend posting by the following procedure:' => '我们推荐按照以下步骤发布。',
    'What special weapon assigned' => '分配了何种特殊武器',
    'When this data was acquired' => '数据获取时间',
    'When this data was acquired in Unix timestamp' => '数据获取时间（UNIX时间戳）',
    'When this data was sent' => '数据发送时间',
    'Which rotation (play window, schedule)' => '哪次排班（打工窗口，安排）',
    'Winning percentage' => '成功率',
    'You\'ll get `newer_than` &lt; `id` &lt; `older_than`.' => '你会获得`newer_than` &lt; `id`&lt; `older_than`。',
    'You can only get data for user who is authenticated by API token.' => '你只能获得该用户API密钥授权的数据。',
    '[Ika-Nakama](https://ikanakama.ink/) profile URL' => '[Ika-Nakama](https://ikanakama.ink/)档案网址',
    '`3` if cleared. `0` if failed in wave 1.' => '如果完成打工就是`3`。如果第一阶段就失败则为`0`。',
    '`40` if Profreshional `40` of `999`' => '`40`就是专业的`40`分之`999`。',
    '`null` or empty string if cleared or unknown' => '如果完成打工或未知即为`null`或空白字符。',
    '{boss} appearances' => '{boss}出现数',
];
