<?php

/**
 * @copyright Copyright (C) 2015-2024 AIZAWA Hina
 * @license https://github.com/fetus-hina/stat.ink/blob/master/LICENSE MIT
 * @author AIZAWA Hina <hina@fetus.jp>
 * @author cake monotone <cake.monotone@gmail.com>
 * @author niLPotential <niLPotential@proton.me>
 */

declare(strict_types=1);

return [
    '(combined)' => '(결합된)',
    '(default)' => '(기본)',
    '(For advanced users)' => '(고급 유저용)',
    '(incomplete)' => '(미완성)',
    '(unknown result)' => '(알 수 없는 결과)',
    '* This exclusion is an attempt to minimize overcounting in weapon usage statistics.' => '* 무기 사용률 통계에서 실제 이상으로 집계되는 것을 최소화하기 위함입니다.',
    '1x Battle' => '',
    '3+9 Format' => '3+9 포맷',
    '3, 9 Format' => '3, 9 포맷',
    '7 players for each battle (excluded the battle uploader)' => '매 매치마다 (업로더를 제외한) 7 플레이어',
    '10x Battle' => '10배 매치',
    '24H Win %' => '24시간 내 승률',
    '50% (reference)' => '',
    '57 Format' => '57 포맷',
    '100x Battle' => '100배 매치',
    '100x Battle WINNER!' => '100배 매치 WINNER!',
    '333x Battle' => '333배 매치',
    '333x Battle WINNER!' => '333배 매치 WINNER!!!',
    '<a href="http://www.emoji-cheat-sheet.com/" target="_blank">Cheat sheet</a>. If omitted, the default icon will be used.' => '',
    '<code>@id</code> (without <code>@</code>), case sensitive.' => '',
    '<div class="input-group"><span class="input-group-addon">From:</span>{input}</div>' => '',
    '<div class="input-group"><span class="input-group-addon">To:</span>{input}</div>' => '',
    'Ability' => '기어 파워',
    'Ability Effect' => '기어파워 효과',
    'About Incoming Webhook' => 'Incoming Webhook에 대해서',
    'About support for color-blindness' => '색각 서포트에 대해서',
    'Active Players' => '',
    'Activity' => '',
    'Add' => '추가',
    'Add <code>/slack</code> to the end of the created webhook URL.' => '',
    'Add Slack Integration' => 'Slack Integration 추가',
    'Advanced Options' => '고급 옵션',
    'Aggregated: {rules}' => '',
    'Aliases' => '',
    'All' => '',
    'All Players' => '모든 플레이어',
    'Always enable horizontal scroll' => '횡스크롤을 항상 활성화합니다',
    'Anarchy Power' => '',
    'Anonymize, don\'t link from other user\'s results' => '',
    'Anonymized' => '익명화되었습니다',
    'Another account' => '다른 어카운트',
    'Any Result' => '모든 결과',
    'Any Time' => '모든 기간',
    'API Info: Abilities (Splatoon 3)' => 'API 정보: 기어파워 (Splatton 3)',
    'API Info: Boss Salmonids (Splatoon 3)' => 'API 정보: 거물연어 (Splatoon 3)',
    'API Info: Gears: {0}' => 'API 정보: 기어: {0}',
    'API Info: Known Occurrences (Splatoon 3)' => 'API 정보: 특수한 상황 (Splatoon 3)',
    'API Info: Medals (Splatoon 3)' => 'API 정보: 메달 (Splatoon 3)',
    'API Info: Stages (Splatoon 2)' => 'API 정보: 스테이지 (Splatoon 2)',
    'API Info: Stages (Splatoon 3)' => 'API 정보: 스테이지 (Splatoon 3)',
    'API Info: Titles (Splatoon 3)' => 'API 정보: 칭호 (Splatoon 3)',
    'API Info: Uniforms (Splatoon 3)' => 'API Info: 작업복 (Splatoon 3)',
    'API Info: Weapons' => 'API 정보: 무기',
    'API Info: Weapons (Splatoon 2)' => 'API 정보: 무기 (Splatoon 2)',
    'API Info: Weapons (Splatoon 3)' => 'API 정보: 무기 (Splatoon 3)',
    'API Token' => 'API 키',
    'Apply' => '적용',
    'Apps for {version}' => '{version} 앱',
    'Area' => '면적',
    'Are you sure you want to regenerate your API token?' => 'API 키를 재생성 하시겠습니까? (연동했던 앱[IkaLog, IkaRec 등]이 더이상 작동하지 않게됩니다)',
    'Assist' => '어시스트',
    'Assists' => '어시스트',
    'Assists/min' => '분 당 어시스트',
    'Attacker Team Win Rate' => '',
    'Auto (cookie)' => '자동 (cookie)',
    'Auto (Identicon)' => '자동 (Identicon)',
    'Automated' => '자동화',
    'Average' => '평균',
    'Average:' => '평균:',
    'Average Gear Abilities' => '',
    'Avg.' => '평균',
    'Avg. game in {time}' => '평균 시합 시간: {time}',
    'Avg. K.O. in {time}' => '평균 KO 시간: {time}',
    'Avg. Uses' => '평균 사용 횟수',
    'Avg Assists' => '평균 어시스트',
    'Avg Deaths' => '평균 데스',
    'Avg Inked' => '평균 칠한 면적',
    'Avg K+A' => '평균 킬+어시',
    'Avg Kills' => '평균 킬',
    'Avg KR' => '평균 킬뎃 비율',
    'Avg Specials' => '평균 스페셜',
    'Back' => '돌아가기',
    'Badge Progress' => '뱃지 수집률',
    'Badges' => '뱃지',
    'Bad Guys' => '상대 팀',
    'Bad guys are in control' => '상대 팀이 확보',
    'Bad guys winning' => '상대 팀이 유리',
    'Based on deaths' => '데스 수 기반 집계',
    'Based on kills' => '킬 수 기반 집계',
    'Battle Count' => '배틀 수',
    'Battle End' => '배틀 종료',
    'Battle results (CSV)' => '배틀 결과 (CSV)',
    'Battles' => '배틀',
    'Battles:' => '배틀:',
    'Battles:{0} / Win %:{1} / Avg Kills:{2} / Avg Deaths:{3} / Kill Ratio:{4}' => '배틀 수:{0} / 승률 %:{1} / 평균 킬:{2} / 평균 데스:{3} / 킬데스비율:{4}',
    'Battles and Users' => '배틀과 유저',
    'Battle Start' => '배틀 시작',
    'between {down} and {up} {name}' => '{down} {name}부터 {up} {name}',
    'Bin Width' => '',
    'Black out' => '',
    'Black out except private battle' => '',
    'Black out except private battle and teammate on league battle (4 players)' => '',
    'Black out except private battle and teammate on squad battle (tri or quad)' => '',
    'Black out other players' => '',
    'Black out other players (details)' => '',
    'Black out other players (images)' => '',
    'Black out other players from the details list' => '',
    'Black out other players from the result image' => '',
    'Blog' => '블로그',
    'Boy' => '보이',
    'Brand' => '브랜드',
    'Calendar' => '캘린더',
    'Capture Environment' => '캡쳐 환경',
    'Cash' => '돈',
    'Category' => '카테고리',
    'Cause of Death' => '죽은 원인',
    'Challenge Power' => '',
    'Challenge Power Distribution' => '',
    'Change Icon' => '아이콘 변경',
    'Change Password' => '비밀번호 변경',
    'Change Screen Name' => '',
    'Channel' => '채널',
    'Check with Setup Analyzer' => '',
    'Click to copy' => '클릭해서 복사',
    'Close' => '닫기',
    'Clout' => '공헌도',
    'Clout (Normal)' => '공헌도 (오픈)',
    'Clout (Pro)' => '공헌도 (챌린지)',
    'Color-Blind Support' => '색각 서포트',
    'Color 1' => '색깔 1',
    'Color 2' => '색깔 2',
    'Color Scheme' => '컬러 스킴',
    'combos' => '콤보',
    'Compare Number Of Uses' => '사용률 비교',
    'Compare number of uses' => '사용률 비교',
    'Completed!' => '완료!',
    'Connectivity' => '연결상태',
    'Consider to be Defeated' => '패배로 취급되는',
    'Continue' => '계속',
    'Copied!' => '복사되었습니다',
    'Correction' => '',
    'Correction Value' => '',
    'Correlation Coefficient' => '상관계수',
    'Correlation with Win %' => '',
    'Could not be updated.' => '갱신에 실패하였습니다',
    'Could not find specified battle.' => '배틀을 찾지 못했습니다.',
    'Could not get your twitter icon at this time.' => 'Twitter 아이콘을 얻어오지 못하였습니다.',
    'Could not update your icon. Please try again.' => '아이콘 업데이트에 실패했습니다. 다시 한번 시도해주십시오',
    'Count (Bad Guys)' => '카운트 (상대 팀)',
    'Count (Good Guys)' => '카운트 (우리 팀)',
    'Create new webhook' => '새로운 Webhook 생성',
    'CSV (IkaLog compat.)' => 'CSV (IkaLog 호환)',
    'CSV format' => 'CSV 포맷',
    'Current' => '현재',
    'Current/Last Splatfest' => '현재/이전의 페스 기간',
    'Current Password' => '현재 비밀번호',
    'Current Period' => '현재 기간',
    'Current Stages' => '현재 스테이지',
    'Current Time:' => '현재 시간',
    'd' => '뎃',
    'D/min' => '데스/분',
    'Daily Report' => '데일리 리포트',
    'Data Sent' => '데이터 등록 일시',
    'Date' => '',
    'Date Time' => '일시',
    'Dead' => 'Death',
    'Deaths' => '데스 수',
    'Deaths (average):' => '데스 수 (평균)',
    'Deaths (median):' => '데스 수 (중앙값)',
    'Deaths/min' => '데스/분',
    'Deaths Per Battle' => '배틀 1판 당 데스 수',
    'Deaths per minute' => '1분 동안의 데스 수',
    'Default Color' => '기본 컬러',
    'Default Order' => '',
    'Defeat' => '패배',
    'Defeat (Exempted)' => '패배 (무효)',
    'Delete' => '삭제',
    'Delete This Battle' => '이 배틀 삭제',
    'Delete This Job' => '이 알바 삭제',
    'Detail' => '상세',
    'Detailed' => '',
    'Detailed List' => '상세 리스트 표시',
    'Details' => '상세',
    'Deviation' => '편차',
    'Disabled' => '비활성화',
    'Disconnected' => '통신 끊김',
    'Discord' => '디스코드',
    'Don\'t anonymize, display in-game name' => '익명화하지 않고, 인게임 닉네임을 링크합니다',
    'Don\'t anonymize, display stat.ink\'s name' => '익명화하지 않고, stat.ink의 이름을 링크합니다',
    'Don\'t group' => '',
    'Do not close this window.' => '이 창을 닫지 마십시오.',
    'Downloads' => '다운로드',
    'Download Stats' => '통계를 다운로드',
    'Draw' => '무승부',
    'e.g. YouTube video, like "{0}"' => '',
    'Earlier Turf-Inked data is currently wrong. It will be fixed in the near future.' => '',
    'Edit' => '수정',
    'Edit Your Battle: #{0}' => '배틀 내용 수정: #{0}',
    'Effects' => '효과',
    'Elapsed' => '시간',
    'Elapsed Time' => '시합시간',
    'Elapsed Time (seconds)' => '시합시간 (초)',
    'Email' => '이메일',
    'Empirical Estimates' => '',
    'Enabled' => '활성화',
    'Enable machine-translation' => '기계번역 사용하기',
    'Enable noise reduction (count)' => '',
    'Enable noise reduction (position of the objective)' => '',
    'Encounter Ratio' => '적 조우률',
    'Enemy Weapon' => '상대 무기',
    'Equip %' => '',
    'Error' => '에러',
    'Error bars' => '오차 바',
    'Error bars: 95% confidence interval (estimated)' => '',
    'Error bars: 95% confidence interval (estimated) & 99% confidence interval (estimated)' => '',
    'Estimated Error' => '',
    'Estimated Vote %' => '추정 투표율',
    'Estimated X Power' => '추정 X 파워',
    'Europe' => '유럽',
    'Europe/Oceania' => '유럽/오세아니아',
    'Even you set them up in the input fields below they will not work.' => '',
    'Excluded: Private Battles' => '프라이빗 배틀 제외됨',
    'Excluded: Private Battles and Squad Battles (when Rank S or S+)' => '',
    'Excluded: The uploader, All players (Private Battle), Uploader\'s teammates (Squad Battle or Splatfest Battle)' => '',
    'Export' => '내보내기',
    'Extra Data' => '추가 데이터',
    'Favorite Weapon' => '자주 사용하는 무기',
    'Favorite Weapons' => '자주 사용하고 있는 무기',
    'Favorite Weapons of This Site Member' => '이 사이트 유저들이 자주 사용하는 무기',
    'Feedback or suggestions are welcome. Please contact me via GitHub or Twitter.' => '피드백과 제안은 항상 열려있습니다. 깃허브 또는 트위터로 연락주세요.',
    'fest.ink' => '',
    'Fest Power' => '페스티벌 파워',
    'Fest Power (Normal)' => '',
    'Fest Power (Pro)' => '',
    'Few' => '',
    'Filter' => '필터',
    'Filter Query' => '필터 쿼리',
    'Final Count' => '최종 카운트',
    'For the actual distribution, see the charts for each mode.' => '',
    'for {title}' => '',
    'Freshness' => '컨디션',
    'Friend Code' => '친구 코드',
    'Friend Code (Switch)' => '친구 코드 (스위치)',
    'Game Mode' => '게임 모드',
    'Game Version' => '게임 버전',
    'Gear' => '기어',
    'GeoIP guessed {timezone}' => '',
    'Getting Started' => '시작하기',
    'Girl' => '걸',
    'GNU Social, Mastodon etc.' => '',
    'Good Guys' => '우리 팀',
    'Good guys are in control' => '우리 팀이 확보',
    'Good guys winning' => '우리 팀이 유리',
    'Group by main weapon' => '',
    'Group by reskins' => '',
    'Group by weapon type' => '',
    'Guessed:' => '',
    'Guessed by your IP:' => '',
    'Guess the region' => '',
    'Guest' => '게스트',
    'Has disconnected player' => '통신 끊긴 플레이어가 있음',
    'Hasn\'t disconnected player' => '통신 끊긴 플레이어가 없음',
    'Hawaii Time' => '',
    'Hide your data on the top page' => '',
    'Highest (current period)' => '',
    'Highest (this teammates)' => '',
    'Highest First' => '',
    'History' => '',
    'However, statistics information will be opened.' => '하지만, 통계 자료는 공개됩니다.',
    'I agree. Delete this battle.' => '이 배틀을 삭제하는 데 동의합니다.',
    'I agree to the terms above.' => '이 약관에 동의합니다.',
    'Icon' => '아이콘',
    'Idea: {source}' => '',
    'If omitted, the channel set in the webhook configuration will be used.' => '',
    'If omitted, the name set in the webhook configuration will be used.' => '',
    'If there are any unsubmitted data, they have not been included in this tally.' => '',
    'If you already have an account, please click here.' => '이미 계정이 있다면 여기를 클릭하세요.',
    'If you change the screen name with this form, the change will take effect immediately.' => '',
    'If you delete this battle, it will be gone forever.' => '이 배틀을 삭제하면 영원히 사라집니다.',
    'If you have pages that you are sharing with URLs, most of them will be broken links.' => '',
    'If you have registered your login information in Password Manager, do not forget to update it.' => '',
    'If you know our API Token' => '',
    'If you misuse this feature, you will be banned.' => '이 기능을 오남용하면 밴될 것입니다.',
    'Ika-Nakama' => '',
    'Ika-Nakama User ID' => '',
    'IkaLog' => '',
    'IkaLog Download Page' => '',
    'IkaRec' => '',
    'IkaRec 2' => '',
    'Image Sharing' => '',
    'Includes battles with unknown event power' => '',
    'Incomplete Data' => '',
    'Ink Color' => '잉크 색깔',
    'Inked' => '칠한 면적',
    'Inked/min' => '칠한 면적/분',
    'Inking Performance' => '칠 성능',
    'Inking Performance vs Win %' => '칠 성능과 승률',
    'Inkling' => '잉클링',
    'Input new battle results' => '배틀 등록',
    'In session' => '개최중',
    'Integrate' => '연동',
    'Internal ID' => '내부ID',
    'Interval' => '',
    'In the chart, "{representative}" means greater than or equal to {min} and less than {max}.' => '',
    'Invalid {0} or {1}.' => '',
    'IQR' => '',
    'Items marked with these icons will only work with its corresponding version.' => '',
    'It looks this data is corrupt.' => '',
    'Japan' => '일본',
    'Japan Time' => '',
    'Join us' => '',
    'JSON (IkaLog compat.)' => '',
    'JSON (stat.ink format, gzipped)' => '',
    'JSON format' => '',
    'JSON format (All langs)' => '',
    'Judge' => '심판',
    'Just scaled for easy contrast, the Y-axis value does not directly indicate the number of people.' => '',
    'Just {result} {rule} at {stage}' => '',
    'k' => '킬',
    'K+A/D' => '킬+어시/데스',
    'K+A/min' => '킬+어시/분',
    'K-D' => '킬-데스',
    'K/D vs Win %' => 'K/D 대 승률',
    'K/min' => '킬/분',
    'Keep doing it.' => '',
    'Kill or Assist' => '킬+어시스트',
    'Kill Rate' => '킬 Rate',
    'Kill Ratio' => '킬뎃비율',
    'Kills' => '킬 수',
    'Kills (average):' => '킬 수 (평균)',
    'Kills (median):' => '킬 수 (중앙값)',
    'Kills / Deaths' => '킬 / 데스',
    'Kills/min' => '킬/분',
    'Kills and Deaths' => '킬과 데스',
    'Kills per minute' => '1분당 킬 수',
    'Knockout' => '녹아웃',
    'KNOCKOUT!' => '녹아웃!',
    'Knockout Rate' => '녹아웃 비율',
    'KR' => '킬뎃 비율',
    'Lack of data' => '',
    'Language' => '언어',
    'Language (used for OStatus)' => '언어 (OStatus로 사용)',
    'Last 24 Hours' => '최근 24시간',
    'Last 24h: {winpct} win ({win}/{count}), Avg. {kill}k/{death}d' => '최근 24시간: 승률 {winpct} ({count}전 {win}승), 평균 {kill}k/{death}d',
    'Last Month (UTC)' => '지난 달 (UTC)',
    'Last {n} Battles' => '최근 {n} 배틀',
    'Last {n} Periods' => '최근 {n} 스테이지',
    'Latest' => '최신',
    'Launch' => '',
    'League Power' => '리그 파워',
    'Legend' => '범례',
    'Legends' => '범례',
    'less than {min} {name}' => '{min} {name} 미만',
    'Level' => '랭크',
    'Level (After)' => '랭크 (After)',
    'Link' => '링크',
    'Link from other user\'s results' => '다른 유저의 결과로부터의 링크',
    'Links' => '링크',
    'List' => '',
    'Loading...' => '로딩...',
    'Loaned Weapons' => '',
    'Lobby' => '로비',
    'Lobby (Icon)' => '로비 (아이콘)',
    'Location' => '장소',
    'Login' => '로그인',
    'Login History' => '로그인 이력',
    'Login history will be deleted in {term}.' => '로그인 이력은 {term} 이후에 삭제됩니다.',
    'Login Method' => '로그인 방법',
    'Log in with other services' => '다른 서비스로 로그인',
    'Log in with Twitter' => '트위터로 로그인',
    'Logout' => '로그아웃',
    'Lose' => '패배',
    'Lost' => '패배',
    'lost' => '패배했습니다',
    'Low ink' => '잉크 부족',
    'Luminance' => '휘도',
    'Luminance Difference' => '휘도 차',
    'Mains' => '메인',
    'Main Weapon' => '메인 웨펀',
    'Make empty this field when you are using Discord.' => '디스코드를 사용할 때는 이 칸을 비워두세요.',
    'Many' => '',
    'Masked' => '',
    'Max.' => '최대',
    'max={max} min={min} average={avg} median={median} mode={mode}' => '',
    'max={max} min={min} median={median}' => '',
    'max={max} min={min} median={median} stddev={stddev}' => '',
    'Maximum' => '최대',
    'Max Inked' => '최대 칠한 면적',
    'Max Kill Combo' => '최대 킬 콤보',
    'Max Kill Streak' => '최대 연속 킬',
    'Medal' => '표창',
    'Medals' => '표창',
    'Median' => '중앙값',
    'Minimum' => '최소',
    'MMMM y' => 'y\'년\'M\'월\'',
    'Mobile' => '모바일',
    'Mode' => '룰',
    'Mode (Icon)' => '룰 (아이콘)',
    'Mode (Short)' => '룰 (Short)',
    'Mode{translate_hint_stats}' => '',
    'Monthly Report' => '월간 리포트',
    'more...' => '더보기',
    'more than {max} {name}' => '',
    'Moving Avg. ({0} Battles)' => '',
    'My team\'s league power' => '우리 팀의 리그 파워',
    'My team\'s splatfest power' => '우리 팀의 페스티벌 파워',
    'My Team Count' => '',
    'My Team Score' => '',
    'My Team Splatfest Power' => '우리 팀 페스티벌 파워',
    'Name' => '이름',
    'Name (for display)' => '닉네임',
    'Neutral' => '중립',
    'New battle' => '배틀 등록',
    'New Password' => '새로운 패스워드',
    'New Password (again)' => '새로운 패스워드 (확인)',
    'New Screen Name (Login Name)' => '',
    'Next' => '다음',
    'Next Battle' => '다음 배틀',
    'Next Month' => '다음 달',
    'Next Stages' => '다음 스테이지',
    'Nintendo Network ID' => '닌텐도 네트워크 ID',
    'Nintendo Switch Online app' => '닌텐도 스위치 온라인 앱',
    'No' => '아니오',
    'No battles' => '배틀이 없습니다',
    'No black out' => '',
    'No Data' => '데이터가 없습니다',
    'No one in control' => '중립',
    'No redirects from old URLs will be made.' => '',
    'Normal Distribution' => '정규 분포',
    'North America/Oceania' => '북미/오세아니아',
    'Not configured.' => '미설정',
    'Not Draws' => '무승부 제외',
    'Note' => '메모',
    'Note (private)' => '메모 (비공개)',
    'Note (public)' => '메모 (공개)',
    'Not enough data is available.' => '',
    'Not Winning' => '승리 제외',
    'Number of weapons seen' => '',
    'Octoling' => '옥토링',
    'Official Results' => '공식 결과',
    'Official Twitter' => '공식 트위터',
    'Open Source Licenses' => '오픈 소스 라이선스',
    'Others' => '그 외',
    'Overall Estimates' => '',
    'Password' => '비밀번호',
    'Password (again)' => '비밀번호 (확인)',
    'PC' => 'PC',
    'Peak' => '최고',
    'Period' => '기간',
    'Permalink' => '고유 링크',
    'Played With' => '',
    'Player Distribution' => '',
    'Players' => '플레이어',
    'Players:' => '플레이어:',
    'Please copy an API key below and paste to IkaLog, IkaRec or other apps that are compatible with {0}.' => 'IkaLog, IkaRec 또는 다른 대응 앱에 연동하려면, 이 API키를 복사해서 앱에 등록해주십시오.',
    'Please copy this URL:' => '이 URL을 복사해주십시오:',
    'Please do not use this feature to destroy evidence.' => '패배 기록을 숨기기 위해 사용하지 마십시오.',
    'Please keep it secret.' => '이 키는 공개되지 않도록 주의해주십시오.',
    'Please log in with your new password.' => '',
    'Please refer to the respective projects for any problems or questions regarding the operation of each application.' => '',
    'Please tell us about your capture environment and communication between your Wii U and User Agent (e.g. IkaLog). This information will be public.' => '',
    'Please wait.' => '잠시만 기다려주십시오.',
    'PNG/JPEG file up to {0}' => '{0}까지의 PNG/JPEG 파일',
    'Points' => '포인트',
    'Position' => '위치',
    'Power' => '',
    'Powered by' => 'Powered by',
    'Power Level' => '',
    'Prev.' => '이전',
    'Prev. Battle' => '이전 배틀',
    'Prev. Month' => '이전 달',
    'Previous Period' => '지난 기간',
    'Primary Ability' => '메인',
    'Primary ability is counted as {value_1_0} and secondary is counted as {value_0_3}.' => '',
    'Privacy Policy' => '프라이버시 정책',
    'Profile and Settings' => '프로필과 설정',
    'Progress' => '진척률',
    'Q<sub>1/4</sub>' => '제1사분위수',
    'Q<sub>3/4</sub>' => '제3사분위수',
    'Rank' => '랭크',
    'Rank (After)' => '랭크 (After)',
    'Rank (after the battle)' => '랭크 (배틀 후)',
    'Rank-up Battle' => '승급전',
    'Rank: Current' => '랭크: 현재',
    'Rank: Peak' => '랭크: 최고',
    'Rank in Team' => '팀 내 순위',
    'Rare Weapon' => 'Mr. Bear 표 무기',
    'Rate' => '',
    'Ratio' => '비율',
    'Recent Battles' => '최근 배틀',
    'Recent Results' => '최근 성적',
    'Recent Use %' => '최근 사용률',
    'Regardless of your time zone setting, it is grouped using UTC.' => '당신의 시간대 설정과 무관하게, UTC로 분류됩니다.',
    'Regenerate your API token' => 'API 키 재생성',
    'Region (used for Splatfest)' => '페스 지역',
    'Register' => '회원가입',
    'Regression Line' => '회귀선',
    'Relative Time' => '상대 시간',
    'Released' => '릴리즈',
    'Remember me' => '로그인 유지',
    'Remote Follow' => '',
    'Replay Code' => '배틀 메모리 코드',
    'Reset icon' => '아이콘 리셋',
    'Reset to default icon' => '디폴트 아이콘으로 리셋',
    'Reset your password' => '',
    'Reskin of' => '',
    'Result' => '결과',
    'Results of {name}\'s Battle' => '{name}의 배틀 결과',
    'Room' => '방',
    'Room info (Private)' => '방 정보 (프라이빗)',
    'S/min' => '스페셜/분',
    'Salmon Run CSV' => '새먼런 CSV',
    'Salmon Run JSON (gzipped)' => '새먼런 결과 JSON (gzip)',
    'Salmon Run results (CSV)' => '새먼런 결과 (CSV)',
    'Samples' => '',
    'Save!' => '저장',
    'Schedule' => '스케줄',
    'Scheduled' => '개최예정',
    'Schema' => '',
    'Schema information' => '스키마 정보',
    'Screen Name' => '',
    'Screen Name (Login Name)' => '로그인 ID',
    'Search' => '검색',
    'Search {date}' => '{date}를 검색',
    'Search {from} - {to}' => '{from}부터 {to}까지 검색',
    'Season' => '시즌',
    'Secondary Abilities' => '서브',
    'Seconds' => '',
    'Sent an email to your email address. Please check your mailbox and get the verification code.' => '당신의 이메일 주소로 메일을 전송했습니다. 메일의 인증코드를 확인해주십시오',
    'Series Progress' => '챌린지 상태',
    'Session History' => '개최이력',
    'Set the name, icon, and channel in the settings within Discord.' => '',
    'Settings' => '설정',
    'Show All Players' => '모든 플레이어를 표시',
    'Show moving averages' => '',
    'Show your API Token' => 'API 키를 표시',
    'Show your data on the top page' => '',
    'Significant?' => '',
    'Simplified List' => '간단한 리스트로 표시',
    'Since the acquisition of Twitter by Elon Musk, the environment for third-party applications has deteriorated rapidly and extremely.' => '',
    'Slack' => '슬랙',
    'Slack Integration' => '슬랙 연동',
    'Source: {source}' => '소스: {source}',
    'Source Code' => '소스 코드',
    'Sp' => '',
    'Special' => '스페셜',
    'Special %' => '스페셜 게이지',
    'Special (Icon)' => '스페셜 (아이콘)',
    'Special:' => '스페셜',
    'Special Battle' => '',
    'Special Battle (Fest)' => '',
    'Special Charged' => '스페셜 충전됨',
    'Specials' => '스페셜',
    'Specials/min' => '스페셜/분',
    'Special Uses' => '',
    'Species' => '종족',
    'Specify Period' => '',
    'Splatfest' => '페스',
    'Splatfest Power' => '페스 파워',
    'Splatfest Power (Normal)' => '페스 파워 (오픈)',
    'Splatfest Power (Pro)' => '페스 파워 (챌린지)',
    'Splatfest Region:' => '페스 지역:',
    'Splatfest Stats' => '',
    'Splatfest Title' => '페스 칭호',
    'Splatfest Title (After)' => '페스 칭호 (After)',
    'SplatNet' => '',
    'SplatNet #' => '',
    'SplatNet 2' => '',
    'SplatNet Battle #' => '',
    'Splatoon' => '스플래툰',
    'Splatoon 2' => '스플래툰 2',
    'Splatoon 3' => '스플래툰 3',
    'Splatoon Official Website (Japan)' => '스플래툰 공식 사이트 (일본)',
    'Splatoon Official Website (UK)' => '스플래툰 공식 사이트 (영국)',
    'Splatoon Official Website (US/Canada)' => '스플래툰 공식 사이트 (북미)',
    'Stack' => '',
    'Stacked' => '',
    'Stage' => '스테이지',
    'Stage (Short)' => '스테이지 (Short)',
    'Stages' => '스테이지',
    'Standard Deviation' => '표준편차',
    'Stats' => '통계',
    'Stats (by Mode)' => '통계 (룰 별)',
    'Stats (by Mode and Stage)' => '통계 (스테이지, 룰 별)',
    'Stats (by Stage)' => '통계 (스테이지 별)',
    'Stats (by Weapon)' => '통계 (무기 별)',
    'Stats (Cause of Death)' => '통계 (죽은 원인)',
    'Stats (Medals)' => '',
    'Stats (Ranked Battle)' => '통계 (랭크 배틀)',
    'Stats (Splatfest)' => '통계 (페스)',
    'Stats (Turf War)' => '통계 (영역 배틀)',
    'Stats (vs. Weapon)' => '통계 (적 무기)',
    'Stats (Win %)' => '통계 (승률)',
    'Stats (X Power)' => '통계 (X 파워)',
    'Stats ({rule})' => '통계 ({rule})',
    'Stats: FestPwr diff vs Win %' => '통계: 페스파워 차이, 승률',
    'Stats: Stages' => '통계: 스테이지',
    'Stats: User Activity' => '통계: 유저활동',
    'Std Dev' => '표준편차',
    'Stealth Jump Equipment Rate' => '',
    'streak' => '연승',
    'Sub:' => '서브',
    'Subs' => '',
    'Sub Weapon' => '서브 웨펀',
    'Sub Weapon (Icon)' => '서브 웨펀 (아이콘)',
    'Summarize' => '요약',
    'Summary: Based on the current filter' => '현 필터 기반 요약',
    'Synergy Bonus' => '세트 보너스',
    'Systematic error of win %' => '승률의 계통오차',
    'Tablet' => '태블릿',
    'Target Player\'s Team' => '지정한 플레이어의 팀',
    'Team' => '팀',
    'Team Icon' => '팀 아이콘',
    'Team ID' => '팀 ID',
    'Team Inked' => '팀으로 칠한 면적',
    'Team {theme}' => '{theme} 팀',
    'Test' => '테스트',
    'Thanks to {user} for their contribution.' => '',
    'The abilities valid only for the primary means the rate of mounting.' => '',
    'The correction value specified by the user is applied.' => '',
    'The data contains a large error margins.' => '',
    'The data is intended to be analyzed using spreadsheet software (Excel, etc.) or programs to analyze.' => '',
    'The data is not something you will know immediately after downloading.' => '',
    'The estimated distribution of the overall game, as estimated from the official results.' => '',
    'The estimated location may be inaccurate.' => '',
    'The filter specifying XP and version, aggregates data for the overall <code>x.y</code>, ignoring the <code>z</code> in version <code>x.y.z</code>.' => '',
    'The future of Twitter integration is completely uncertain, and as a {site} developer I can\'t recommend this feature at this time.' => '',
    'The icon will be:' => '아이콘은 다음과 같게 됩니다:',
    'Their team\'s league power' => '상대 팀의 리그 파워',
    'Their team\'s splatfest power' => '상대 팀의 페스티벌 파워',
    'Their Team Count' => '',
    'Their Team Score' => '',
    'Their Team Splatfest Power' => '상대 팀의 페스티벌 파워',
    'Themes from {name}' => '',
    'The old name will be available immediately for reuse.' => '',
    'The password will be encrypted.' => '비밀번호는 암호화되어 저장됩니다.',
    'The post will be in the language set here.' => '',
    'There are no data.' => '데이터가 없습니다.',
    'There is no user associated with the specified twitter account.' => '해당 트위터 계정으로 등록된 유저가 없습니다.',
    'These battles were recorded with an outdated version of IkaLog. Please upgrade to the latest version.' => '해당 배틀들은 구버전 IkaLog로 기록됐습니다. 최신 버전으로 업데이트 바랍니다.',
    'The width of the histogram bins is automatically adjusted by Scott\'s rule-based algorithm.' => '',
    'This battle was recorded with an outdated version of IkaLog. Please upgrade to the latest version.' => '해당 배틀은 구버전 IkaLog로 기록됐습니다. 최신 버전으로 업데이트 바랍니다.',
    'This chart assumes simple normal distribution of the Power to make it easier to compare each mode.' => '',
    'This data is based on {siteName} users and differs significantly from overall game statistics.' => '이 데이터는 {siteName} 유저들 기반이고 게임 전체 통계와는 큰 차이가 있습니다.',
    'This data is basically not informative.' => '기본적으로 이 데이터는 유용하지 않습니다.',
    'This data was totaled after normalization to 5 minute intervals for each battle.' => '',
    'This document is under a <a href="http://creativecommons.org/licenses/by/4.0/deed.en">Creative Commons Attribution 4.0 International License</a>.' => '',
    'This feature is disabled by default.' => '',
    'This information will be public. Integration for "log in with twitter" can be done from the profile page.' => '',
    'This is a Discord-specific behavior.' => '',
    'This is a wild guess based on past results and {siteName} posts.' => '이는 지난 결과와 {siteName} 게시물에 기반한 어림짐작입니다.',
    'This Month (UTC)' => '이번 달 (UTC)',
    'This option is provided for deleting an incorrectly-reported battle.' => '이 옵션은 잘못 기록된 배틀을 삭제하기 위함입니다.',
    'This should be a random string of at least {n} characters and should not be the same as any other site' => '',
    'This twitter account has already been integrated with another user.' => '해당 트위터 계정은 이미 다른 유저와 등록되어 있습니다.',
    'This website doesn\'t support Internet Explorer. Please use a modern browser, for example Chrome or Firefox.' => '이 사이트는 인터넷 익스플로러를 지원하지 않습니다. 크롬이나 파이어폭스 등을 사용해주세요.',
    'This website has color-blind support. Please check "Color-Blind Support" in the "Username/Guest" menu of the navbar to enable it.' => '',
    'This website is an open source project. It is under the MIT License. The source code is available on GitHub.' => '이 사이트는 오픈 소스 프로젝트입니다. 소스 코드는 깃허브에 있습니다.',
    'This website is an UNOFFICIAL SERVICE. It is not related to the Splatoon development team or Nintendo.' => '이 사이트는 비공식 서비스입니다. 스플래툰 개발팀 또는 닌텐도와 무관합니다.',
    'This will be made public as part of URL' => '',
    'This {attribute} is already in use.' => '',
    'Time' => '',
    'Time is up' => '',
    'Times' => '횟수',
    'Time was up' => '',
    'Time Zone' => '시간대',
    'Title' => '칭호',
    'Title (After)' => '칭호 (After)',
    'To change your password using this feature, contact the administrator first.' => '',
    'Today' => '오늘',
    'Top {percentile}%' => '',
    'Total' => '총합',
    'Total Clout' => '공헌도 총합',
    'Total Clout (After the battle)' => '공헌도 총합 (배틀 후)',
    'Total Inked' => '칠한 면적 총합',
    'To use Discord integration, make a webhook on your Discord server first.' => '',
    'To use Slack integration, you need to configure Slack\'s "Incoming Webhook" first.' => '',
    'Trends' => '',
    'Try to secure the Ultra Signal' => '',
    'Turf Inked' => '칠한 면적',
    'Turf inked (including bonus)' => '칠한 면적 (승리 보너스 포함)',
    'Turf Inked + Bonus' => '칠한 면적 + 승리 보너스',
    'TV' => 'TV',
    'Twitter @name' => '',
    'TZ' => '',
    'Ultra Signals' => '슈퍼 시그널',
    'Uniform' => '작업복',
    'Unknown' => '알 수 없음',
    'Unknown Result' => '알 수 없는 결과',
    'Unlink account' => '계정 연동 해제',
    'Update' => '업데이트',
    'Update Your Email Address' => '이메일 주소 수정',
    'Update Your Icon' => '아이콘 수정',
    'Update Your Password' => '비밀번호 수정',
    'Update Your Profile' => '프로필 수정',
    'Update Your Screen Name' => '',
    'Upload icon' => '아이콘 업로드',
    'Upload new image' => '새 이미지 업로드',
    'URL related to this battle' => '이 배틀과 관련된 URL',
    'Use %' => '사용률',
    'Use % and Win %' => '사용률과 승률',
    'Used in global stats' => '전체 통계에 사용',
    'Use full width of the screen' => '화면의 전체 너비 사용',
    'Use profile icon of your twitter account' => '트위터 계정의 프로필 아이콘 사용',
    'User Agents in last 24 hours' => '',
    'User Count' => '유저 수',
    'User Name' => '유저 이름',
    'Users' => '유저들',
    'Use your profile icon' => '프로필 아이콘 사용',
    'Verification Code' => '인증 코드',
    'Verify' => '인증',
    'Version' => '버전',
    'Version {0}' => '버전 {0}',
    'Victory' => '승리',
    'Victory or Defeat' => '승리 또는 패배',
    'View Settings' => '설정 보기',
    'Vote %' => '득표율',
    'We\'ll send an email when you log in to the website or change your password.' => '웹사이트에 로그인하거나 비밀번호를 변경하면 이메일을 보내겠습니다',
    'Weapon' => '무기',
    'Weapon (Icon)' => '무기 (아이콘)',
    'Weapon (Short)' => '무기 (Short)',
    'Weapon icons were created by {0}.' => '무기 아이콘은 {0}님이 만드신 것을 사용하고 있습니다.',
    'Weapons' => '무기',
    'Weapon Stats' => '',
    'Weapon Trends' => '무기 트렌드',
    'Weapon | {weapon}' => '무기 | {weapon}',
    'Weapon | {weapon} | {rule}' => '무기 | {weapon} | {rule}',
    'Webhook URL' => 'Webhook URL',
    'Win' => '승리',
    'Win %' => '승률',
    'Win % (Total)' => '승률 (전체)',
    'Win % ({0} Battles)' => '승률 ({0}전)',
    'Winning Percentage' => '승률',
    'Winning Percentage based on K/D' => 'K/D 기반 승률분포',
    'Wins' => '',
    'Win streak (Bad guys)' => '연승 (상대 팀)',
    'Win streak (Good guys)' => '연승 (우리 팀)',
    'Win Streak: {count}' => '{count}연승',
    'Won' => '승리',
    'won' => '이겼습니다',
    'Won / Lost' => '승리/패배',
    'X Power' => 'X 파워',
    'X Power (after)' => 'X 파워 (After)',
    'Yes' => '네',
    'Yesterday' => '어제',
    'You' => '당신',
    'You can\'t use an IDN (Internationalized Domain Names) email address' => '',
    'You can delete this battle.' => '이 배틀은 삭제할 수 있습니다.',
    'You cannot use the same {attribute} as your current one.' => '',
    'You can register (estimated) unsent values here to correct the values displayed.' => '',
    'You can specify Discord\'s Slack compatible endpoint URL as well.' => '',
    'You must agree to the above to delete this battle.' => '이 배틀을 삭제하기 위해서는 위 내용에 동의해야 합니다.',
    'Your Battles' => '',
    'Your browser does not support this action.' => '',
    'Your current icon:' => '현재 아이콘',
    'Your current image will be deleted and reset to auto-generated image.' => '현재 이미지가 삭제되고 자동 생성된 이미지로 돌아갑니다.',
    'Your data will no longer appear in the public list on the top page.' => '',
    'Your page will still be public, but it will be harder to access.' => '',
    'Your password has been changed successfully.' => '',
    'Your profile icon has been updated.' => '프로필 아이콘이 수정됐습니다.',
    '[Outdated]' => '',
    '{0} etc.' => '{0} 등',
    '{0}×{1} or less resolution' => '{0}×{1} 이하 해상도',
    '{attribute} must be at most 15 alphanumeric or underscore characters.' => '',
    '{decimal5_7} Format' => '',
    '{from} - {to}' => '',
    '{lower}-{upper} percentile' => '',
    '{n,plural,=1{battle} other{battles}}' => '',
    '{name}\'s Badge Progress' => '',
    '{name}\'s Battle' => '{name}의 배틀',
    '{name}\'s Battle Report' => '{name}의 배틀 리포트',
    '{name}\'s Battles' => '{name}의 배틀',
    '{name}\'s Battle Stats (by Mode)' => '{name}의 배틀 통계 (룰 별)',
    '{name}\'s Battle Stats (by Mode and Stage)' => '{name}의 배틀 통계 (스테이지, 룰)',
    '{name}\'s Battle Stats (by Stage)' => '{name}의 배틀 통계 (스테이지 별)',
    '{name}\'s Battle Stats (by Weapon)' => '{name}의 배틀 통계 (무기 별)',
    '{name}\'s Battle Stats (Cause of Death)' => '{name}의 배틀 통계 (죽은 원인)',
    '{name}\'s Battle Stats (Medals)' => '',
    '{name}\'s Battle Stats (Ranked Battle)' => '{name}의 배틀 통계 (랭크 배틀)',
    '{name}\'s Battle Stats (Splatfest)' => '{name}의 배틀 통계 (페스)',
    '{name}\'s Battle Stats (Turf War)' => '{name}의 배틀 통계 (영역 배틀)',
    '{name}\'s Battle Stats (vs. Weapon)' => '{name}의 배틀 통계 (상대 무기)',
    '{name}\'s Battle Stats (Winning Rate)' => '{name}의 배틀 통계 (승률)',
    '{name}\'s Battle Stats ({rule})' => '{name}의 배틀 통계 ({rule})',
    '{name}\'s Favorite Weapon' => '{name}의 자주 사용하는 무기',
    '{name}\'s Monthly Report - {date}' => '{name}의 월간 리포트 - {date}',
    '{name}\'s Splat Log' => '{name}의 Splat Log',
    '{name}\'s X Power' => '',
    '{nFormatted} remaining' => '',
    '{nFormatted} {n, plural, =1{battle} other{battles}}' => '{nFormatted}전',
    '{nFormatted} {n, plural, =1{time} other{times}}' => '{nFormatted}회',
    '{number, plural, =1{1 death} other{# deaths}} in {battle, plural, =1{1 battle} other{# battles}}' => '{number, plural, other{#회}} / {battle, plural, other{#전}}',
    '{number, plural, =1{1 egg} other{# eggs}} in {battle, plural, =1{1 shift} other{# shifts}}' => '{number}개/{battle}회',
    '{number, plural, =1{1 kill} other{# kills}}' => '',
    '{number, plural, =1{1 kill} other{# kills}} in {battle, plural, =1{1 battle} other{# battles}}' => '',
    '{number, plural, =1{1 time} other{# times}} in {battle, plural, =1{1 shift} other{# shifts}}' => '',
    '{package} is used for icons and other images.' => '',
    '{pct_point} percentage point' => '',
    '{pct}% CI' => '',
    '{pct} % loss' => '',
    '{pct}% Significant?' => '',
    '{pct} ({dupf} DU/F)' => '',
    '{percentile} Percentile' => '',
    '{point, plural, =1{1 point} other{# points}} in {battle, plural, =1{1 battle} other{# battles}}' => '',
    '{point, plural, other{#p}}' => '',
    '{point}p' => '{point} p',
    '{rule}: Current' => '{rule}: 현재',
    '{rule}: Peak' => '{rule}: 최대',
    '{sec,plural,=1{# second} other{# seconds}}' => '{sec} 초',
    '{sec} seconds' => '{sec} 초',
    '{sec} seconds ({pct} %)' => '{sec} 초 ({pct} %)',
    '{sec} seconds, {cnt} times' => '{sec} 초, 최대 {cnt} 회',
    '{siteName} Discord Community' => '{siteName} 디스코드',
    '{theme} Theme' => '{theme} 테마',
    '{title} Official Website' => '{title} 공식 사이트',
    '~{estPower}' => '약{estPower}',
    '~{point}p' => '약{point}p',
    '×{times}' => '{times}배',
];
