<?php

/**
 * @copyright Copyright (C) 2015-2024 AIZAWA Hina
 * @license https://github.com/fetus-hina/stat.ink/blob/master/LICENSE MIT
 * @author AIZAWA Hina <hina@fetus.jp>
 * @author eli fessler <eliwf8@gmail.com>
 * @author Allen Pestaluky <allenwp@live.ca>
 */

declare(strict_types=1);

return [
    '(For advanced users)' => '（上級者向け）',
    '(combined)' => '(統合済み)',
    '(default)' => '(既定)',
    '(incomplete)' => '(不完全)',
    '(unknown result)' => '(結果不明)',
    '* This exclusion is an attempt to minimize overcounting in weapon usage statistics.' => '※できる限り重複カウントしないように除外設定を行っていますが、連戦やナワバリフレンド合流の影響により重複カウントしやすい状況が発生します。',
    '100x Battle WINNER!' => '100倍マッチ WINNER!',
    '100x Battle' => '100倍マッチ',
    '10x Battle' => '10倍マッチ',
    '1x Battle' => '通常マッチ',
    '24H Win %' => '24H勝率',
    '3+9 Format' => '3+9形式',
    '3, 9 Format' => '3, 9形式',
    '333x Battle WINNER!' => '333倍マッチ WINNER!!!',
    '333x Battle' => '333倍マッチ',
    '50% (reference)' => '50% (参照用)',
    '57 Format' => '57形式',
    '7 players for each battle (excluded the battle uploader)' => 'バトルごとに、投稿者を除いた7人のプレーヤー',
    '<a href="http://www.emoji-cheat-sheet.com/" target="_blank">Cheat sheet</a>. If omitted, the default icon will be used.' => '<a href="http://www.emoji-cheat-sheet.com/" target="_blank">チートシート</a>。省略するとデフォルトのアイコンが使用されます。',
    '<code>@id</code> (without <code>@</code>), case sensitive.' => '<code>@id</code> (※<code>@</code>なし), 大文字小文字を区別',
    '<div class="input-group"><span class="input-group-addon">From:</span>{input}</div>' => '<div class="input-group">{input}<span class="input-group-addon">から</span></div>',
    '<div class="input-group"><span class="input-group-addon">To:</span>{input}</div>' => '<div class="input-group">{input}<span class="input-group-addon">まで</span></div>',
    'API Info: Abilities (Splatoon 3)' => 'API情報: ギアパワー (Splatoon 3)',
    'API Info: Boss Salmonids (Splatoon 3)' => 'API情報: オオモノシャケ (Splatoon 3)',
    'API Info: Gears: {0}' => 'API情報: ギア: {0}',
    'API Info: Known Occurrences (Splatoon 3)' => 'API情報: 特殊な状況 (Splatoon 3)',
    'API Info: Medals (Splatoon 3)' => 'API情報: 表彰 (Splatoon 3)',
    'API Info: Stages (Splatoon 2)' => 'API情報: ステージ (Splatoon 2)',
    'API Info: Stages (Splatoon 3)' => 'API情報: ステージ (Splatoon 3)',
    'API Info: Titles (Splatoon 3)' => 'API情報: 称号 (Splatoon 3)',
    'API Info: Uniforms (Splatoon 3)' => 'API情報: バイト服 (Splatoon 3)',
    'API Info: Weapons (Splatoon 2)' => 'API情報: ブキ (Splatoon 2)',
    'API Info: Weapons (Splatoon 3)' => 'API情報: ブキ (Splatoon 3)',
    'API Info: Weapons' => 'API情報: ブキ',
    'API Token' => 'APIキー',
    'Ability Effect' => 'ギアパワー効果',
    'Ability' => 'ギアパワー',
    'About Incoming Webhook' => 'Incoming Webhookについて',
    'About support for color-blindness' => '色覚サポートについて',
    'Active Players' => 'アクティブプレーヤー',
    'Activity' => 'アクティビティー',
    'Add <code>/slack</code> to the end of the created webhook URL.' => '作成されたWebhook URLの末尾に <code>/slack</code> を追加してください。',
    'Add Slack Integration' => 'Slack連携を追加',
    'Add' => '追加',
    'Advanced Options' => '高度なオプション',
    'Aggregated: {rules}' => '集計対象: {rules}',
    'Aliases' => 'エイリアス',
    'All Players' => 'すべてのプレーヤー',
    'All' => 'すべて',
    'Always enable horizontal scroll' => '常にテーブルの横スクロールを有効にする',
    'Anarchy Power' => 'バンカラパワー',
    'Anonymize, don\'t link from other user\'s results' => '匿名化し、他の利用者のページからはリンクしない',
    'Anonymized' => '匿名化されています',
    'Another account' => '別のアカウント',
    'Any Result' => 'すべての結果',
    'Any Time' => 'すべての期間',
    'Apply' => '適用',
    'Apps for {version}' => '{version}用アプリ',
    'Are you sure you want to regenerate your API token?' => 'APIキーを再生成してもよろしいですか？（連携したアプリ[IkaLog, IkaRec etc.]が動作しなくなります）',
    'Area' => '面積',
    'Assist' => 'アシスト',
    'Assists' => 'アシスト',
    'Assists/min' => 'アシスト/分',
    'Attacker Team Win Rate' => '攻撃チームの勝率',
    'Auto (Identicon)' => '自動 (Identicon)',
    'Auto (cookie)' => '自動 (クッキー)',
    'Automated' => '自動化',
    'Average Gear Abilities' => '平均ギアパワー',
    'Average' => '平均',
    'Average:' => '平均:',
    'Avg Assists' => '平均アシスト',
    'Avg Deaths' => '平均Death',
    'Avg Inked' => '平均塗った面積',
    'Avg K+A' => '平均K+A',
    'Avg KR' => '平均キルレ',
    'Avg Kills' => '平均Kill',
    'Avg Specials' => '平均スペシャル',
    'Avg. K.O. in {time}' => '平均KO時間: {time}',
    'Avg. Uses' => '平均使用数',
    'Avg. game in {time}' => '平均試合時間: {time}',
    'Avg.' => '平均',
    'Back' => '戻る',
    'Bad Guys' => '相手のチーム',
    'Bad guys are in control' => '相手のチームが確保',
    'Bad guys winning' => '相手のチームが優勢',
    'Badge Progress' => 'バッジ取得状況',
    'Badges' => 'バッジ',
    'Based on deaths' => 'デス数に基づく集計',
    'Based on kills' => 'キル数に基づく集計',
    'Battle Count' => 'バトル数',
    'Battle End' => 'バトル終了',
    'Battle Start' => 'バトル開始',
    'Battle results (CSV)' => 'バトルのリザルト情報 (CSV)',
    'Battles and Users' => 'バトルとユーザ',
    'Battles' => 'バトル',
    'Battles:' => 'バトル:',
    'Battles:{0} / Win %:{1} / Avg Kills:{2} / Avg Deaths:{3} / Kill Ratio:{4}' => 'バトル数:{0}　勝率:{1}　平均キル:{2}　平均デス:{3}　キルレ:{4}',
    'Bin Width' => '階級の幅',
    'Black out except private battle and teammate on league battle (4 players)' => 'プライベートバトルの時と、リーグマッチ(4人)の味方は黒塗りしない',
    'Black out except private battle and teammate on squad battle (tri or quad)' => 'プライベートバトルの時と、タッグマッチ(3,4人)の味方は黒塗りしない',
    'Black out except private battle' => 'プライベートバトルでは黒塗りしない',
    'Black out other players (details)' => '他のプレーヤを黒塗りする（詳細）',
    'Black out other players (images)' => '他のプレーヤを黒塗りする（画像）',
    'Black out other players from the details list' => '詳細リストの他のプレーヤ名を黒塗りして隠す',
    'Black out other players from the result image' => '結果画面の他のプレーヤを黒塗りして隠す',
    'Black out other players' => '他のプレーヤを黒塗りする',
    'Black out' => '黒塗りする',
    'Blog' => 'ブログ',
    'Boy' => 'ボーイ',
    'Brand' => 'ブランド',
    'CSV (IkaLog compat.)' => 'CSV (IkaLog互換)',
    'CSV format' => 'CSV形式',
    'Calendar' => 'カレンダー',
    'Capture Environment' => 'キャプチャ環境',
    'Cash' => 'おカネ',
    'Category' => 'カテゴリー',
    'Cause of Death' => '死因',
    'Challenge Power Distribution' => 'イベントパワー分布',
    'Challenge Power' => 'イベントパワー',
    'Change Icon' => 'アイコンを変更',
    'Change Password' => 'パスワードの変更',
    'Change Screen Name' => 'ログイン名の変更',
    'Channel' => 'チャンネル',
    'Check with Setup Analyzer' => 'セットアップアナライザで確認',
    'Click to copy' => 'クリックしてURLをコピー',
    'Close' => '閉じる',
    'Clout (Normal)' => '貢献度(レギュラー)',
    'Clout (Pro)' => '貢献度(チャレンジ)',
    'Clout' => '貢献度',
    'Color 1' => '色 1',
    'Color 2' => '色 2',
    'Color Scheme' => 'カラースキーム',
    'Color-Blind Support' => '色覚サポート',
    'Compare Number Of Uses' => '使用率の比較',
    'Compare number of uses' => '使用率を比較する',
    'Completed!' => '完了!',
    'Connectivity' => '接続状態',
    'Consider to be Defeated' => 'みなし敗北',
    'Continue' => '継続',
    'Copied!' => 'コピーしました',
    'Correction Value' => '補正値',
    'Correction' => '補正',
    'Correlation Coefficient' => '相関係数',
    'Correlation with Win %' => '勝率との相関',
    'Could not be updated.' => '更新できませんでした。',
    'Could not find specified battle.' => '指定されたバトルが見つかりませんでした。',
    'Could not get your twitter icon at this time.' => 'Twitterのアイコンを取得できませんでした。',
    'Could not update your icon. Please try again.' => 'アイコンのアップデートに失敗しました。やり直してください。',
    'Count (Bad Guys)' => 'カウント（相手のチーム）',
    'Count (Good Guys)' => 'カウント（自分のチーム）',
    'Create new webhook' => '新しいWebhookの作成',
    'Current Password' => '現在のパスワード',
    'Current Period' => '現在のステージ',
    'Current Stages' => '現在のステージ',
    'Current Time:' => '現在日時:',
    'Current' => '現在',
    'Current/Last Splatfest' => '現在/前回のフェス期間',
    'D/min' => '死/分',
    'Daily Report' => '日報',
    'Data Sent' => 'データ送信',
    'Date Time' => '日時',
    'Date' => '日付',
    'Dead' => 'Death',
    'Deaths (average):' => 'デス数（平均）:',
    'Deaths (median):' => 'デス数（中央値）:',
    'Deaths Per Battle' => 'バトルあたりのデス数',
    'Deaths per minute' => '1分あたりのデス数',
    'Deaths' => 'デス数',
    'Deaths/min' => 'デス/分',
    'Default Color' => '既定のテーマ',
    'Default Order' => '既定の順序',
    'Defeat (Exempted)' => '敗北(免除)',
    'Defeat' => '敗北',
    'Delete This Battle' => 'バトルの削除',
    'Delete This Job' => 'バイトの削除',
    'Delete' => '削除',
    'Detail' => '詳細',
    'Detailed List' => '詳細なリストで表示',
    'Detailed' => '詳細',
    'Details' => '詳細',
    'Deviation' => '偏差値',
    'Disabled' => '無効',
    'Disconnected' => '通信切断',
    'Discord' => 'Discord',
    'Do not close this window.' => 'このウィンドウを閉じないでください。',
    'Don\'t anonymize, display in-game name' => '匿名化せず、ゲーム中の名前でリンクする',
    'Don\'t anonymize, display stat.ink\'s name' => '匿名化せず、stat.inkの登録名でリンクする',
    'Don\'t group' => 'ブキをまとめない',
    'Download Stats' => '統計情報ダウンロード',
    'Downloads' => 'ダウンロード',
    'Draw' => '引き分け',
    'Earlier Turf-Inked data is currently wrong. It will be fixed in the near future.' => '古い塗り面積データは現在間違って集計されています。この問題は近いうちに直します。',
    'Edit Your Battle: #{0}' => 'バトル詳細を編集: #{0}',
    'Edit' => '編集',
    'Effects' => '効果',
    'Elapsed Time (seconds)' => '試合時間（秒）',
    'Elapsed Time' => '試合時間',
    'Elapsed' => '時間',
    'Email' => 'Eメール',
    'Empirical Estimates' => '経験則による推定',
    'Enable machine-translation' => '機械翻訳を使用する',
    'Enable noise reduction (count)' => 'エリアのカウントにノイズ軽減を適用する',
    'Enable noise reduction (position of the objective)' => 'ヤグラ・ホコの位置のグラフにノイズ軽減を適用する',
    'Enabled' => '有効',
    'Encounter Ratio' => '敵遭遇率',
    'Enemy Weapon' => '相手のブキ',
    'Equip %' => '装備率 (%)',
    'Error bars' => 'エラーバー',
    'Error bars: 95% confidence interval (estimated) & 99% confidence interval (estimated)' => 'エラーバー: 95%信頼区間（推定）と99%信頼区間（推定）',
    'Error bars: 95% confidence interval (estimated)' => 'エラーバー: 95%信頼区間（推定）',
    'Error' => 'エラー',
    'Estimated Error' => '推定誤差',
    'Estimated Vote %' => '推定投票率',
    'Estimated X Power' => '概算Xパワー',
    'Europe' => '欧州',
    'Europe/Oceania' => '欧州・オセアニア',
    'Even you set them up in the input fields below they will not work.' => '下の入力蘭に設定しても動作しません。',
    'Excluded: Private Battles and Squad Battles (when Rank S or S+)' => '集計除外: プライベートマッチと S, S+ 時のタッグマッチ',
    'Excluded: Private Battles' => '集計除外: プライベートマッチ',
    'Excluded: The uploader, All players (Private Battle), Uploader\'s teammates (Squad Battle or Splatfest Battle)' => '集計除外: プライベートマッチと、投稿ユーザ、タッグマッチ・フェスマッチ時の投稿者のチームメンバー',
    'Export' => 'エクスポート',
    'Extra Data' => '追加情報',
    'Favorite Weapon' => 'よく使うブキ',
    'Favorite Weapons of This Site Member' => 'このサイトの登録者がよく使うブキ',
    'Favorite Weapons' => 'よく使っているブキ',
    'Feedback or suggestions are welcome. Please contact me via GitHub or Twitter.' => 'バグの報告・改善の提案などがありましたら、 GitHubのプロジェクトに報告・提案するか、ツイッターアカウントへご連絡ください。',
    'Fest Power (Normal)' => 'パワー(レギュラー)',
    'Fest Power (Pro)' => 'パワー(チャレンジ)',
    'Fest Power' => 'パワー',
    'Few' => '少',
    'Filter Query' => 'フィルタクエリ',
    'Filter' => 'フィルタ',
    'Final Count' => '最終カウント',
    'For the actual distribution, see the charts for each mode.' => '実際の分布は各ルールのグラフを参照してください。',
    'Freshness' => 'チョーシ',
    'Friend Code (Switch)' => 'フレンドコード (Switch)',
    'Friend Code' => 'フレンドコード',
    'GNU Social, Mastodon etc.' => 'マストドン他',
    'Game Mode' => 'ゲームモード',
    'Game Version' => 'ゲームバージョン',
    'Gear' => 'ギア',
    'GeoIP guessed {timezone}' => 'GeoIPによる推定: {timezone}',
    'Getting Started' => 'このサイトについて',
    'Girl' => 'ガール',
    'Good Guys' => '自分のチーム',
    'Good guys are in control' => '自分のチームが確保',
    'Good guys winning' => '自分のチームが優勢',
    'Group by main weapon' => 'メインの性能でまとめる',
    'Group by reskins' => 'おなじブキをまとめる',
    'Group by weapon type' => '種類でまとめる',
    'Guess the region' => '地域を推定する',
    'Guessed by your IP:' => 'IPアドレスからの推測:',
    'Guessed:' => '推定：',
    'Guest' => 'ゲスト',
    'Has disconnected player' => '切断プレーヤーあり',
    'Hasn\'t disconnected player' => '切断プレーヤーなし',
    'Hawaii Time' => 'ハワイ時間',
    'Hide your data on the top page' => 'トップページにデータを表示しない',
    'Highest (current period)' => '最高値（現スケジュール）',
    'Highest (this teammates)' => '最高値（現チームメイト）',
    'Highest First' => '多い順',
    'History' => '履歴',
    'However, statistics information will be opened.' => '一般的な統計情報については公開することがあります。',
    'I agree to the terms above.' => '文章を理解し、同意の上削除します',
    'I agree. Delete this battle.' => '同意して削除します。',
    'IQR' => '四分位範囲',
    'Icon' => 'アイコン',
    'Idea: {source}' => 'アイデア: {source}',
    'If omitted, the channel set in the webhook configuration will be used.' => '省略するとWebhookに設定されたChannelが使用されます。',
    'If omitted, the name set in the webhook configuration will be used.' => '省略するとWebhookに設定された名前が使用されます。',
    'If there are any unsubmitted data, they have not been included in this tally.' => '未送信のデータが存在する場合、この集計には含まれていません。',
    'If you already have an account, please click here.' => 'すでにアカウントをお持ちであればこちらをクリックしてログインしてください。',
    'If you change the screen name with this form, the change will take effect immediately.' => 'このフォームでログイン名の変更を行うと、変更はすぐに有効になります。',
    'If you delete this battle, it will be gone forever.' => 'この操作を元に戻すことはできません。',
    'If you have pages that you are sharing with URLs, most of them will be broken links.' => 'もしURLを使って共有したページがある場合、そのほとんどはリンク切れになります。',
    'If you have registered your login information in Password Manager, do not forget to update it.' => 'パスワード マネージャーにログイン情報を登録している場合は、更新するのを忘れないでください。',
    'If you know our API Token' => 'APIキーをお持ちの方',
    'If you misuse this feature, you will be banned.' => '不適切な使用を確認した場合、アカウントを削除し以後のご利用をお断りする場合があります。',
    'Ika-Nakama User ID' => 'イカナカマ',
    'Ika-Nakama' => 'イカナカマ',
    'IkaLog Download Page' => 'IkaLogダウンロードページ',
    'IkaLog' => 'IkaLog',
    'IkaRec 2' => 'イカレコ2',
    'IkaRec' => 'イカレコ',
    'Image Sharing' => '画像の共有',
    'In session' => '開催中',
    'In the chart, "{representative}" means greater than or equal to {min} and less than {max}.' => 'グラフ中の "{representative}" は {min} 以上 {max} 未満を意味します。',
    'Includes battles with unknown event power' => 'イベントパワーが不明なバトルを含む',
    'Incomplete Data' => '不完全なデータ',
    'Ink Color' => 'インク色',
    'Inked' => '塗面積',
    'Inked/min' => '塗/分',
    'Inking Performance vs Win %' => '塗り性能と勝率',
    'Inking Performance' => '塗り性能',
    'Inkling' => 'インクリング',
    'Input new battle results' => 'バトルの登録',
    'Integrate' => '連携',
    'Internal ID' => '内部ID',
    'Interval' => '間隔',
    'Invalid {0} or {1}.' => '{0}または{1}が違います。',
    'It looks this data is corrupt.' => 'このデータは破損しています。',
    'Items marked with these icons will only work with its corresponding version.' => 'これらのアイコンがついている項目は、対応するバージョンでのみ動作します。',
    'JSON (IkaLog compat.)' => 'JSON (IkaLog互換)',
    'JSON (stat.ink format, gzipped)' => 'JSON (stat.ink形式, gzip圧縮)',
    'JSON format (All langs)' => 'JSON形式 (全言語)',
    'JSON format' => 'JSON形式',
    'Japan Time' => '日本時間',
    'Japan' => '日本',
    'Join us' => '利用してみる',
    'Judge' => 'ジャッジ',
    'Just scaled for easy contrast, the Y-axis value does not directly indicate the number of people.' => '対比しやすいようにスケールしているだけで、Y軸の値は直接人数を示しません。',
    'Just {result} {rule} at {stage}' => '{stage}での{rule}で{result}。',
    'K+A/D' => 'K+A/D',
    'K+A/min' => 'K+A/分',
    'K-D' => 'K-D',
    'K/D vs Win %' => 'KDと勝率',
    'K/min' => '殺/分',
    'KNOCKOUT!' => 'ノックアウト!',
    'KR' => 'キルレ',
    'Keep doing it.' => 'バトルやバイトにはげむのだー',
    'Kill Rate' => 'キルレート',
    'Kill Ratio' => 'キルレシオ',
    'Kill or Assist' => 'キル＋アシスト',
    'Kills (average):' => 'キル数（平均）:',
    'Kills (median):' => 'キル数（中央値）:',
    'Kills / Deaths' => 'キル / デス',
    'Kills and Deaths' => 'キルとデス',
    'Kills per minute' => '1分あたりのキル数',
    'Kills' => 'キル数',
    'Kills/min' => 'キル/分',
    'Knockout Rate' => 'ノックアウト率',
    'Knockout' => 'ノックアウト',
    'Lack of data' => 'データ不足',
    'Language (used for OStatus)' => '言語（OStatusで使用）',
    'Language' => '言語',
    'Last 24 Hours' => '最近24時間',
    'Last 24h: {winpct} win ({win}/{count}), Avg. {kill}k/{death}d' => '最近24時間: 勝率 {winpct} ({count}戦{win}勝), 平均 {kill}k/{death}d',
    'Last Month (UTC)' => '先月（ガチマ集計期間）',
    'Last {n} Battles' => '最近{n}バトル',
    'Last {n} Periods' => '最近{n}ステージ',
    'Latest' => '最新',
    'Launch' => 'ローンチ',
    'League Power' => 'リーグパワー',
    'Legend' => '凡例',
    'Legends' => '凡例',
    'Level (After)' => 'ランク(後)',
    'Level' => 'ランク',
    'Link from other user\'s results' => '他の利用者の結果詳細からのリンク',
    'Link' => 'リンク',
    'Links' => 'リンク',
    'List' => '一覧',
    'Loading...' => '読み込み中',
    'Loaned Weapons' => '支給ブキ',
    'Lobby (Icon)' => 'ロビー（アイコン）',
    'Lobby' => 'ロビー',
    'Location' => '場所',
    'Log in with Twitter' => 'Twitterでログイン',
    'Log in with other services' => '他のサービスのアカウントでログイン',
    'Login History' => 'ログイン履歴',
    'Login Method' => 'ログイン方法',
    'Login history will be deleted in {term}.' => 'ログイン履歴は{term}で削除されます。',
    'Login' => 'ログイン',
    'Logout' => 'ログアウト',
    'Lose' => '敗北',
    'Lost' => '敗北',
    'Low ink' => 'インク切れ',
    'Luminance Difference' => '輝度差',
    'Luminance' => '輝度',
    'MMMM y' => 'y\'年\'M\'月\'',
    'Main Weapon' => 'メインウェポン',
    'Mains' => 'メイン',
    'Make empty this field when you are using Discord.' => 'Discordを使用する場合、このフィールドは入力しないでください。',
    'Many' => '多',
    'Masked' => '設定によって隠されています',
    'Max Inked' => '最大塗った面積',
    'Max Kill Combo' => '最大キルコンボ',
    'Max Kill Streak' => '最大ストリーク',
    'Max.' => '最大',
    'Maximum' => '最大',
    'Medal' => '表彰',
    'Medals' => '表彰',
    'Median' => '中央値',
    'Minimum' => '最小',
    'Mobile' => 'モバイル',
    'Mode (Icon)' => 'ルール（アイコン）',
    'Mode (Short)' => 'ルール（短）',
    'Mode' => 'ルール',
    'Mode{translate_hint_stats}' => '最頻値',
    'Monthly Report' => '月報',
    'Moving Avg. ({0} Battles)' => '移動平均（{0}戦）',
    'My Team Count' => '自チームカウント',
    'My Team Score' => '自チームのスコア',
    'My Team Splatfest Power' => '自分のチームのフェスパワー',
    'My team\'s league power' => '自チーム概算ガチパワー',
    'My team\'s splatfest power' => '自チームフェスパワー',
    'Name (for display)' => '名前（表示用）',
    'Name' => '名前',
    'Neutral' => '拮抗',
    'New Password (again)' => '新しいパスワード（確認用）',
    'New Password' => '新しいパスワード',
    'New Screen Name (Login Name)' => '新しいログイン名',
    'New battle' => 'バトル登録',
    'Next Battle' => '次のバトル',
    'Next Month' => '次の月',
    'Next Stages' => '次のステージ',
    'Next' => '次',
    'Nintendo Network ID' => 'ニンテンドーネットワークID',
    'Nintendo Switch Online app' => 'Nintendo Switch Online アプリ',
    'No Data' => 'データがありません',
    'No battles' => 'バトルはありません',
    'No black out' => '黒塗りしない',
    'No one in control' => '中立',
    'No redirects from old URLs will be made.' => '古いURLからのリダイレクトは行いません。',
    'No' => 'いいえ',
    'Normal Distribution' => '正規分布',
    'North America/Oceania' => '北米・オセアニア',
    'Not Draws' => '引き分け以外',
    'Not Winning' => '勝利していない',
    'Not configured.' => '構成されていません。',
    'Not enough data is available.' => '十分なデータがありません。',
    'Note (private)' => 'メモ（非公開）',
    'Note (public)' => 'メモ（公開）',
    'Note' => 'メモ',
    'Number of weapons seen' => '確認されたブキの数',
    'Octoling' => 'オクトリング',
    'Official Results' => '公式の結果',
    'Official Twitter' => '公式ツイッター',
    'Open Source Licenses' => 'オープンソースライセンス',
    'Others' => 'その他',
    'Overall Estimates' => '全体の推定',
    'PC' => 'PC',
    'PNG/JPEG file up to {0}' => '{0} までのPNGまたはJPEGファイル',
    'Password (again)' => 'パスワード（確認用）',
    'Password' => 'パスワード',
    'Peak' => '最高',
    'Period' => '期間',
    'Permalink' => '固定リンク',
    'Played With' => '一緒に遊んだ人',
    'Player Distribution' => 'プレーヤーの分布',
    'Players' => 'プレーヤー',
    'Players:' => 'プレーヤー:',
    'Please copy an API key below and paste to IkaLog, IkaRec or other apps that are compatible with {0}.' => 'IkaLog、イカレコ、その他の対応アプリと連携するには、このAPIキーをコピーしてアプリに登録してください。',
    'Please copy this URL:' => 'このURLをコピーしてください:',
    'Please do not use this feature to destroy evidence.' => '敗戦の記録を隠すために使用しないでください。',
    'Please keep it secret.' => 'このキーは公開しないよう注意してください。',
    'Please log in with your new password.' => '新しいパスワードでログインしてください。',
    'Please refer to the respective projects for any problems or questions regarding the operation of each application.' => '各アプリケーションの動作に関する問題や疑問は、それぞれのプロジェクトを参照してください。',
    'Please tell us about your capture environment and communication between your Wii U and User Agent (e.g. IkaLog). This information will be public.' => '認識精度向上のため、WiiUとIkaLogの間の接続や設定をどのように行っているかについて教えてください。この情報は開発者以外も閲覧することができますので個人情報等は記載しないでください。',
    'Please wait.' => 'しばらくおまちください。',
    'Points' => 'ポイント',
    'Position' => '位置',
    'Power Level' => 'ガチパワー',
    'Power' => 'パワー',
    'Powered by' => 'Powered by',
    'Prev. Battle' => '前のバトル',
    'Prev. Month' => '前の月',
    'Prev.' => '前',
    'Previous Period' => '一つ前のステージ',
    'Primary Ability' => 'メイン',
    'Primary ability is counted as {value_1_0} and secondary is counted as {value_0_3}.' => 'メインを{value_1_0}、サブを{value_0_3}として計算しています。',
    'Privacy Policy' => 'プライバシーポリシー',
    'Profile and Settings' => 'プロフィールと設定',
    'Progress' => '進捗',
    'Q<sub>1/4</sub>' => '第1四分位数',
    'Q<sub>3/4</sub>' => '第3四分位数',
    'Rank (After)' => 'ウデマエ(後)',
    'Rank (after the battle)' => 'ウデマエ（バトル後）',
    'Rank in Team' => 'チーム内順位',
    'Rank' => 'ウデマエ',
    'Rank-up Battle' => '昇格戦',
    'Rank: Current' => 'ウデマエ: 現在',
    'Rank: Peak' => 'ウデマエ: 最高',
    'Rare Weapon' => 'クマさんブキ',
    'Rate' => 'レート',
    'Ratio' => 'レシオ',
    'Recent Battles' => '最近のバトル',
    'Recent Results' => '最近の成績',
    'Recent Use %' => '最近の利用率',
    'Regardless of your time zone setting, it is grouped using UTC.' => 'タイムゾーン設定に関わらず、UTC(協定世界時)で集計されています。',
    'Regenerate your API token' => 'APIキーの再生成',
    'Region (used for Splatfest)' => 'フェスのリージョン（地域）',
    'Register' => 'ユーザ登録',
    'Regression Line' => '回帰直線',
    'Relative Time' => '相対時間',
    'Released' => 'リリース',
    'Remember me' => '自動ログイン（共用PCではオフにしてください）',
    'Remote Follow' => 'リモートフォロー',
    'Replay Code' => 'リプレイコード',
    'Reset icon' => 'アイコンを戻す',
    'Reset to default icon' => 'デフォルトアイコンに戻す',
    'Reset your password' => 'パスワードのリセット',
    'Reskin of' => '同一性能',
    'Result' => '結果',
    'Results of {name}\'s Battle' => '{name}さんのバトル結果',
    'Room info (Private)' => '部屋情報（プラベ）',
    'Room' => '部屋',
    'S/min' => 'スペ/分',
    'Salmon Run CSV' => 'サーモンランCSV',
    'Salmon Run JSON (gzipped)' => 'サーモンランJSON (gzip圧縮)',
    'Salmon Run results (CSV)' => 'サーモンランのリザルト情報 (CSV)',
    'Samples' => 'サンプル数',
    'Save!' => '保存',
    'Schedule' => 'スケジュール',
    'Scheduled' => '開催予定',
    'Schema information' => 'スキーマ情報',
    'Schema' => 'スキーマ',
    'Screen Name (Login Name)' => 'ログイン名',
    'Screen Name' => 'ログイン名',
    'Search {date}' => '{date}を検索',
    'Search {from} - {to}' => '{from}から{to}までを検索',
    'Search' => '検索',
    'Season' => 'シーズン',
    'Secondary Abilities' => 'サブ',
    'Seconds' => '秒',
    'Sent an email to your email address. Please check your mailbox and get the verification code.' => '指定されたメールアドレスにメールを送信しました。メールを確認して確認コードを取得してください。',
    'Series Progress' => 'チャレンジ状況',
    'Session History' => '開催履歴',
    'Set the name, icon, and channel in the settings within Discord.' => 'ユーザ名・アイコン・チャンネルは Discord 内の設定で行ってください。',
    'Settings' => '設定',
    'Show All Players' => '全員を表示',
    'Show moving averages' => '移動平均線を表示',
    'Show your API Token' => 'APIキーを表示',
    'Show your data on the top page' => 'トップページにデータを表示する',
    'Significant?' => '有意?',
    'Simplified List' => 'シンプルなリストで表示',
    'Since the acquisition of Twitter by Elon Musk, the environment for third-party applications has deteriorated rapidly and extremely.' => 'イーロン・マスクによるTwitterの買収以来、サードパーティアプリケーションを取り巻く環境は急速かつ極端に悪化しています。',
    'Slack Integration' => 'Slack連携',
    'Slack' => 'Slack',
    'Source Code' => 'ソースコード',
    'Source: {source}' => 'ソース: {source}',
    'Sp' => 'SP',
    'Special %' => 'スペシャルゲージ',
    'Special (Icon)' => 'スペシャル（アイコン）',
    'Special Battle (Fest)' => 'レアバトル（フェス）',
    'Special Battle' => 'レアバトル',
    'Special Charged' => 'スペシャル満タン',
    'Special Uses' => 'スペシャル使用回数',
    'Special' => 'スペシャル',
    'Special:' => 'スペシャル:',
    'Specials' => 'スペシャル',
    'Specials/min' => 'スペシャル/分',
    'Species' => '種族',
    'Specify Period' => '期間を指定する',
    'SplatNet #' => 'イカリングの番号',
    'SplatNet 2' => 'イカリング2',
    'SplatNet Battle #' => 'イカリングのバトル番号',
    'SplatNet' => 'イカリング',
    'Splatfest Power (Normal)' => 'フェスパワー(レギュラー)',
    'Splatfest Power (Pro)' => 'フェスパワー(チャレンジ)',
    'Splatfest Power' => 'フェスパワー',
    'Splatfest Region:' => 'フェス地域：',
    'Splatfest Stats' => 'フェス統計',
    'Splatfest Title (After)' => 'フェス称号（後）',
    'Splatfest Title' => 'フェス称号',
    'Splatfest' => 'フェス',
    'Splatoon 2' => 'Splatoon 2',
    'Splatoon 3' => 'Splatoon 3',
    'Splatoon Official Website (Japan)' => 'スプラトゥーン公式サイト（日本）',
    'Splatoon Official Website (UK)' => 'スプラトゥーン公式サイト（英国）',
    'Splatoon Official Website (US/Canada)' => 'スプラトゥーン公式サイト（北米）',
    'Splatoon' => 'Splatoon',
    'Stack' => '積み重ねる',
    'Stacked' => '積み重ね',
    'Stage (Short)' => 'ステージ（短）',
    'Stage' => 'ステージ',
    'Stages' => 'ステージ',
    'Standard Deviation' => '標準偏差',
    'Stats (Cause of Death)' => '統計（死因）',
    'Stats (Medals)' => '統計（表彰）',
    'Stats (Ranked Battle)' => '統計（ガチマッチ）',
    'Stats (Splatfest)' => '統計（フェス）',
    'Stats (Turf War)' => '統計（ナワバリバトル）',
    'Stats (Win %)' => '統計（勝率）',
    'Stats (X Power)' => '統計（Xパワー）',
    'Stats (by Mode and Stage)' => '統計（ステージとルール）',
    'Stats (by Mode)' => '統計（ルール別）',
    'Stats (by Stage)' => '統計（ステージ別）',
    'Stats (by Weapon)' => '統計（ブキ別）',
    'Stats (vs. Weapon)' => '統計（敵のブキ）',
    'Stats ({rule})' => '統計（{rule}）',
    'Stats' => '統計',
    'Stats: FestPwr diff vs Win %' => '統計: フェスパワー差と勝率',
    'Stats: Stages' => '統計: ステージ',
    'Stats: User Activity' => '統計: このサイトのユーザとバトル数',
    'Std Dev' => '標準偏差',
    'Stealth Jump Equipment Rate' => 'ステジャン装備率',
    'Sub Weapon (Icon)' => 'サブウェポン（アイコン）',
    'Sub Weapon' => 'サブウェポン',
    'Sub:' => 'サブ:',
    'Subs' => 'サブ',
    'Summarize' => '集計',
    'Summary: Based on the current filter' => '現在のフィルタに基づくサマリ',
    'Synergy Bonus' => 'おそろいボーナス',
    'Systematic error of win %' => '勝率の系統誤差',
    'TV' => 'テレビ',
    'TZ' => '時間帯',
    'Tablet' => 'タブレット',
    'Target Player\'s Team' => '指定プレーヤーのチーム',
    'Team ID' => 'チームID',
    'Team Icon' => 'チームアイコン',
    'Team Inked' => 'チームで塗った面積',
    'Team {theme}' => '{theme}チーム',
    'Team' => 'チーム',
    'Test' => 'テスト',
    'Thanks to {user} for their contribution.' => '{user} の貢献に感謝します。',
    'The abilities valid only for the primary means the rate of mounting.' => 'メイン専用のギアパワーは、装着率を表しています。',
    'The correction value specified by the user is applied.' => 'ユーザーが指定した補正値が適用されています。',
    'The data contains a large error margins.' => 'データには大きな誤差を含みます。',
    'The data is intended to be analyzed using spreadsheet software (Excel, etc.) or programs to analyze.' => '表計算ソフト(Excel等)やプログラムを駆使して何かを解析することを前提としたデータです。',
    'The data is not something you will know immediately after downloading.' => 'ダウンロード後、すぐに何かがわかるデータではありません。',
    'The estimated distribution of the overall game, as estimated from the official results.' => '公式の結果から推測した、ゲーム全体の推定分布です。',
    'The estimated location may be inaccurate.' => '場所の推定精度はあまりよくありません。',
    'The filter specifying XP and version, aggregates data for the overall <code>x.y</code>, ignoring the <code>z</code> in version <code>x.y.z</code>.' => 'XPとバージョンを指定したフィルターは、バージョン <code>x.y.z</code> の <code>z</code> を無視して、<code>x.y</code> 全体のデータを集計しています。',
    'The future of Twitter integration is completely uncertain, and as a {site} developer I can\'t recommend this feature at this time.' => 'Twitter連携の将来の見通しは不透明であり、{site}の開発者としてはこの機能の利用はおすすめしません。',
    'The icon will be:' => 'アイコンは次のようになります:',
    'The old name will be available immediately for reuse.' => '古い名前はすぐに再利用可能になります。',
    'The password will be encrypted.' => 'パスワードは暗号化されて保存されます。',
    'The post will be in the language set here.' => 'ここで設定された言語で投稿されます。',
    'The width of the histogram bins is automatically adjusted by Scott\'s rule-based algorithm.' => 'ヒストグラムの階級幅は、「スコットの選択」をベースにしたアルゴリズムによって自動的に調整されています。',
    'Their Team Count' => '相手チームカウント',
    'Their Team Score' => '相手チームのスコア',
    'Their Team Splatfest Power' => '相手のチームのフェスパワー',
    'Their team\'s league power' => '敵チーム概算ガチパワー',
    'Their team\'s splatfest power' => '敵チームフェスパワー',
    'Themes from {name}' => '{name}からのテーマ',
    'There are no data.' => 'データがありません。',
    'There is no user associated with the specified twitter account.' => '指定されたTwitterアカウントに関連づけられたユーザが見つかりません。',
    'These battles were recorded with an outdated version of IkaLog. Please upgrade to the latest version.' => '古いIkaLogで記録されました。情報が正しく解析されないため、最新のIkaLogへアップデートしてください。',
    'This Month (UTC)' => '今月（ガチマ集計期間）',
    'This battle was recorded with an outdated version of IkaLog. Please upgrade to the latest version.' => 'このバトルは古いIkaLogで記録されました。情報が正しく解析されないため、最新のIkaLogへアップデートしてください。',
    'This chart assumes simple normal distribution of the Power to make it easier to compare each mode.' => 'このグラフは、各ルールを比較しやすくするために、パワーの単純な正規分布を仮定しています。',
    'This data is based on {siteName} users and differs significantly from overall game statistics.' => 'このデータは{siteName}の利用者を集計したもので、ゲーム全体の統計とは大きく異なります。',
    'This data is basically not informative.' => 'このデータは基本的には参考になりません。',
    'This data was totaled after normalization to 5 minute intervals for each battle.' => 'データは5分間に正規化して集計しています。',
    'This document is under a <a href="http://creativecommons.org/licenses/by/4.0/deed.en">Creative Commons Attribution 4.0 International License</a>.' => 'この文章は<a href="http://creativecommons.org/licenses/by/4.0/deed.ja">クリエイティブ・コモンズ 表示 4.0 国際 ライセンス</a>の下に提供されています。',
    'This feature is disabled by default.' => 'この機能はデフォルトで無効になっています。',
    'This information will be public. Integration for "log in with twitter" can be done from the profile page.' => 'この情報は公開されます。ツイッターでログインするための設定はプロフィールページから行えます。',
    'This is a Discord-specific behavior.' => 'これは Discord の仕様によるものです。',
    'This is a wild guess based on past results and {siteName} posts.' => '過去の結果と{siteName}の投稿に基づいた、大胆な推測です。',
    'This option is provided for deleting an incorrectly-reported battle.' => '削除機能は誤認識したデータを削除するために提供しています。',
    'This should be a random string of at least {n} characters and should not be the same as any other site' => '少なくとも{n}文字のランダムな文字列で、他のサイトと同じものにしないでください',
    'This twitter account has already been integrated with another user.' => 'このTwitterアカウントはすでに別のユーザーに関連づけられています。',
    'This website doesn\'t support Internet Explorer. Please use a modern browser, for example Chrome or Firefox.' => 'Internet Explorer はサポートしていませんので、Chrome , Firefox などのモダンブラウザを使用してください。',
    'This website has color-blind support. Please check "Color-Blind Support" in the "Username/Guest" menu of the navbar to enable it.' => '色覚サポートを実装しています。有効にするには上部ナビゲーションの「ユーザ名/ゲスト」部分から「色覚サポート」を選択してください。',
    'This website is an UNOFFICIAL SERVICE. It is not related to the Splatoon development team or Nintendo.' => 'このサイトは非公式(unofficial)サービスです。任天堂株式会社とは一切関係ありません。',
    'This website is an open source project. It is under the MIT License. The source code is available on GitHub.' => 'このサイトのソースコードはオープンソース(MIT License)で公開されています。',
    'This will be made public as part of URL' => 'URLの一部として公開されます',
    'This {attribute} is already in use.' => '指定した{attribute}は既に使用されています。',
    'Time Zone' => 'タイムゾーン',
    'Time is up' => 'タイムアップ',
    'Time was up' => 'タイムアップ',
    'Time' => '時間',
    'Times' => '回数',
    'Title (After)' => '称号（後）',
    'Title' => '称号',
    'To change your password using this feature, contact the administrator first.' => 'この機能を使ってパスワードを変更するには、まず管理者に連絡してください。',
    'To use Discord integration, make a webhook on your Discord server first.' => 'Discord連携を利用するには、あらかじめお使いのDiscordサーバーでWebhookを作成する必要があります。',
    'To use Slack integration, you need to configure Slack\'s "Incoming Webhook" first.' => 'Slack連携を利用するには、あらかじめSlackのIncoming Webhookを設定する必要があります。',
    'Today' => '今日',
    'Top {percentile}%' => '上位{percentile}%',
    'Total Clout (After the battle)' => '合計貢献度（後）',
    'Total Clout' => '合計貢献度',
    'Total Inked' => '合計塗った面積',
    'Total' => '合計',
    'Trends' => 'トレンド',
    'Try to secure the Ultra Signal' => 'スーパーシグナルへの挑戦',
    'Turf Inked + Bonus' => '塗った面積+勝利ボーナス',
    'Turf Inked' => '塗った面積',
    'Turf inked (including bonus)' => '塗った面積（勝利ボーナス込み）',
    'Twitter @name' => 'ツイッター @id',
    'URL related to this battle' => '関連ページURL',
    'Ultra Signals' => 'スーパーシグナル',
    'Uniform' => 'バイト服',
    'Unknown Result' => '不明な結果',
    'Unknown' => '不明',
    'Unlink account' => '関連づけを解除',
    'Update Your Email Address' => 'メールアドレスの更新',
    'Update Your Icon' => 'アイコンの更新',
    'Update Your Password' => 'パスワードの更新',
    'Update Your Profile' => 'プロフィールの更新',
    'Update Your Screen Name' => 'ログイン名の変更',
    'Update' => '更新',
    'Upload icon' => 'アイコンをアップロード',
    'Upload new image' => '新しい画像をアップロード',
    'Use % and Win %' => '使用率と勝率',
    'Use %' => '使用率',
    'Use full width of the screen' => '画面の横幅いっぱいを使う',
    'Use profile icon of your twitter account' => 'Twitterアカウントのプロフィール画像を使用',
    'Use your profile icon' => 'プロフィール画像を使用',
    'Used in global stats' => '全体統計に使用',
    'User Agents in last 24 hours' => '最近24時間の使用クライアント',
    'User Count' => 'ユーザ数',
    'User Name' => 'ユーザ名',
    'Users' => 'ユーザ',
    'Verification Code' => '確認コード',
    'Verify' => '確認',
    'Version {0}' => 'バージョン{0}',
    'Version' => 'バージョン',
    'Victory or Defeat' => '勝利/敗北',
    'Victory' => '勝利',
    'View Settings' => '表示設定',
    'Vote %' => '投票率',
    'We\'ll send an email when you log in to the website or change your password.' => 'ログイン時やパスワード変更時にメールを送信してお知らせします。',
    'Weapon (Icon)' => 'ブキ（アイコン）',
    'Weapon (Short)' => 'ブキ（短）',
    'Weapon Stats' => 'ブキ統計',
    'Weapon Trends' => 'ブキトレンド',
    'Weapon icons were created by {0}.' => 'ブキアイコンは{0}様が作成されたものを使用しています。',
    'Weapon | {weapon} | {rule}' => 'ブキ | {weapon} | {rule}',
    'Weapon | {weapon}' => 'ブキ | {weapon}',
    'Weapon' => 'ブキ',
    'Weapons' => 'ブキ',
    'Webhook URL' => 'Webhook URL',
    'Win % (Total)' => '勝率（全体）',
    'Win % ({0} Battles)' => '勝率（{0}戦）',
    'Win %' => '勝率',
    'Win Streak: {count}' => '{count} 連勝',
    'Win streak (Bad guys)' => '連勝（敵）',
    'Win streak (Good guys)' => '連勝（味方）',
    'Win' => '勝利',
    'Winning Percentage based on K/D' => 'K/Dに基づく勝率分布',
    'Winning Percentage' => '勝率',
    'Wins' => '勝利数',
    'Won / Lost' => '勝敗を気にしない',
    'Won' => '勝利',
    'X Power (after)' => 'Xパワー(後)',
    'X Power' => 'Xパワー',
    'Yes' => 'はい',
    'Yesterday' => '昨日',
    'You can delete this battle.' => 'このバトルを削除できます。',
    'You can register (estimated) unsent values here to correct the values displayed.' => 'このサイトに送信されていない（推定の）値をここで登録することで、表示される値を補正することができます。',
    'You can specify Discord\'s Slack compatible endpoint URL as well.' => 'DiscordのSlack互換エンドポイントURLも指定できます。',
    'You can\'t use an IDN (Internationalized Domain Names) email address' => 'IDN（国際化ドメイン名）のアドレスを使用することはできません。',
    'You cannot use the same {attribute} as your current one.' => '現在の{attribute}と同じものは使用できません。',
    'You must agree to the above to delete this battle.' => 'バトルを削除するには、文章を読んで同意してください。',
    'You' => 'あなた',
    'Your Battles' => '自分のページを表示',
    'Your browser does not support this action.' => 'ご使用の環境ではサポートされていません',
    'Your current icon:' => '現在のアイコン:',
    'Your current image will be deleted and reset to auto-generated image.' => '現在の画像を削除し、自動生成の画像に戻します。',
    'Your data will no longer appear in the public list on the top page.' => 'トップページの一般公開リストにあなたのデータが表示されなくなります。',
    'Your page will still be public, but it will be harder to access.' => 'あなたのページは引き続き公開されますが、アクセスが難しくなります。',
    'Your password has been changed successfully.' => '新しいパスワードを設定しました。',
    'Your profile icon has been updated.' => 'プロフィール画像を更新しました。',
    '[Outdated]' => '[古いバージョン]',
    'between {down} and {up} {name}' => '{down}{name}から{up}{name}',
    'combos' => 'コンボ',
    'd' => 'D',
    'e.g. YouTube video, like "{0}"' => 'YouTubeやニコニコ動画の動画URLを指定します（例えば「{0}」）',
    'fest.ink' => 'イカフェスレート',
    'for {title}' => '{title}用',
    'k' => 'K',
    'less than {min} {name}' => '{min}{name}未満',
    'lost' => '負けました',
    'max={max} min={min} average={avg} median={median} mode={mode}' => '最大={max} 最小={min} 平均={avg} 中央値={median} 最頻値={mode}',
    'max={max} min={min} median={median} stddev={stddev}' => '最大={max} 最小={min} 中央値={median} 標準偏差={stddev}',
    'max={max} min={min} median={median}' => '最大={max} 最小={min} 中央値={median}',
    'more than {max} {name}' => '{max}{name}をこえる',
    'more...' => '続きを見る...',
    'streak' => 'ストリーク',
    'won' => '勝ちました',
    '{0} etc.' => '{0} 他',
    '{0}×{1} or less resolution' => '{0}×{1} ピクセル以下の画素数（解像度）',
    '{attribute} must be at most 15 alphanumeric or underscore characters.' => '{attribute}は半角英数とアンダースコア15文字以内で入力してください。',
    '{decimal5_7} Format' => '{decimal5_7}形式',
    '{from} - {to}' => '{from}～{to}',
    '{lower}-{upper} percentile' => '{lower}～{upper}パーセンタイル',
    '{n,plural,=1{battle} other{battles}}' => 'バトル',
    '{nFormatted} remaining' => '残り {nFormatted}',
    '{nFormatted} {n, plural, =1{battle} other{battles}}' => '{nFormatted}戦',
    '{nFormatted} {n, plural, =1{time} other{times}}' => '{nFormatted}回',
    '{name}\'s Badge Progress' => '{name}さんのバッジ取得状況',
    '{name}\'s Battle Report' => '{name}さんのバトルレポート',
    '{name}\'s Battle Stats (Cause of Death)' => '{name}さんの統計（死因）',
    '{name}\'s Battle Stats (Medals)' => '{name}さんの統計（表彰）',
    '{name}\'s Battle Stats (Ranked Battle)' => '{name}さんの統計（ガチマッチ）',
    '{name}\'s Battle Stats (Splatfest)' => '{name}さんの統計（フェス）',
    '{name}\'s Battle Stats (Turf War)' => '{name}さんの統計（ナワバリバトル）',
    '{name}\'s Battle Stats (Winning Rate)' => '{name}さんの統計（勝率）',
    '{name}\'s Battle Stats (by Mode and Stage)' => '{name}さんの統計（ステージとルール）',
    '{name}\'s Battle Stats (by Mode)' => '{name}さんの統計（ルール別）',
    '{name}\'s Battle Stats (by Stage)' => '{name}さんの統計（ステージ別）',
    '{name}\'s Battle Stats (by Weapon)' => '{name}さんの統計（ブキ別）',
    '{name}\'s Battle Stats (vs. Weapon)' => '{name}さんの統計（相手のブキ）',
    '{name}\'s Battle Stats ({rule})' => '{name}さんの統計（{rule}）',
    '{name}\'s Battle' => '{name}さんのバトル',
    '{name}\'s Battles' => '{name}さんのバトル',
    '{name}\'s Favorite Weapon' => '{name}のよく使うブキ',
    '{name}\'s Monthly Report - {date}' => '{name}さんの月間レポート - {date}',
    '{name}\'s Splat Log' => '{name}さんのイカログ',
    '{name}\'s X Power' => '{name}さんのXパワー',
    '{number, plural, =1{1 death} other{# deaths}} in {battle, plural, =1{1 battle} other{# battles}}' => '{number, plural, other{#回}} / {battle, plural, other{#戦}}',
    '{number, plural, =1{1 egg} other{# eggs}} in {battle, plural, =1{1 shift} other{# shifts}}' => '{number}個/{battle}回',
    '{number, plural, =1{1 kill} other{# kills}} in {battle, plural, =1{1 battle} other{# battles}}' => '{number, plural, other{#回}} / {battle, plural, other{#戦}}',
    '{number, plural, =1{1 kill} other{# kills}}' => '{number, plural, other{# キル}}',
    '{number, plural, =1{1 time} other{# times}} in {battle, plural, =1{1 shift} other{# shifts}}' => '{number}回/{battle}回',
    '{package} is used for icons and other images.' => 'アイコンやその他の画像には {package} を使用しています。',
    '{pct_point} percentage point' => '{pct_point} パーセントポイント',
    '{pct} % loss' => '{pct} % 減少',
    '{pct} ({dupf} DU/F)' => '{pct} ({dupf} DU/F)',
    '{pct}% CI' => '{pct}%信頼区間',
    '{pct}% Significant?' => '{pct}% 有意?',
    '{percentile} Percentile' => '{percentile}パーセンタイル',
    '{point, plural, =1{1 point} other{# points}} in {battle, plural, =1{1 battle} other{# battles}}' => '{point, plural, other{#p}} / {battle, plural, other{#戦}}',
    '{point, plural, other{#p}}' => '{point, plural, other{#ポイント}}',
    '{point}p' => '{point} p',
    '{rule}: Current' => '{rule}: 現在',
    '{rule}: Peak' => '{rule}: 最高',
    '{sec,plural,=1{# second} other{# seconds}}' => '{sec} 秒',
    '{sec} seconds ({pct} %)' => '{sec} 秒 ({pct} %)',
    '{sec} seconds' => '{sec} 秒',
    '{sec} seconds, {cnt} times' => '{sec} 秒, 最大 {cnt} 回',
    '{siteName} Discord Community' => '{siteName} Discordコミュニティ',
    '{theme} Theme' => '{theme}テーマ',
    '{title} Official Website' => '{title} 公式サイト',
    '~{estPower}' => '約{estPower}',
    '~{point}p' => '約{point}p',
    '×{times}' => '×{times}',
];
