<?php

/**
 * @copyright Copyright (C) 2015-2020 AIZAWA Hina
 * @license https://github.com/fetus-hina/stat.ink/blob/master/LICENSE MIT
 * @author AIZAWA Hina <hina@fetus.jp>
 */

declare(strict_types=1);

return [
    'A play data of this post owner' => '投稿者のプレイデータ',
    'A unique ID to identify the results' => '結果を識別するためのユニーク ID',
    'Ability information' => 'ギアパワー情報',
    'Ability' => 'ギアパワー',
    'About UUID, refer [RFC 4122](https://tools.ietf.org/html/rfc4122).' => 'UUID については [RFC 4122](https://tools.ietf.org/html/rfc4122) を参照してください。',
    'Accepts `1`-`1000` (if `only` = `splatnet_number`)' => '受入範囲: `1`～`1000` (`only` = `splatnet_number`)',
    'Accepts `1`-`50` (otherwise)' => '受入範囲: `1`～`50` (その他の場合)',
    'All battle statistics' => 'すべてのバトルの統計',
    'An API Token with bearer auth format.' => 'Bearer 認証フォーマットされた API トークン',
    'As the number of supported languages changes, the position of items may change.' => 'サポートする言語が変化すると、項目の場所がずれる場合があります。',
    'Average inked per battle' => 'バトルあたりの塗った面積（平均塗面積）',
    'Battle results page URL' => 'バトル結果一覧のURL',
    'Be sure to check the header on the first line (or use JSON version) if you use this data for automatic processing.' => '自動処理に使用する場合は、1行目のヘッダを確認してください。もしくは、JSON バージョンを利用してください。',
    'Boss appearances' => 'ボス出現数',
    'Boss information' => 'オオモノシャケ情報',
    'Boss' => 'オオモノシャケ',
    'Brand information' => 'ブランド情報',
    'Brand' => 'ブランド',
    'Call [`GET {url}`]({link}) and retrieve already posted shift numbers.' => '[`GET {url}`]({link}) を呼び出して、すでに登録済みのバイト番号を取得します。',
    'Change the result set' => '結果セットを変更します',
    'Choose `no` if this user\'s posts may be arbitrarily selected.' => 'このユーザの投稿が恣意的に選択されている可能性があれば `no` を選択してください。',
    'Cleared the shift' => 'クリアした',
    'Client application should specify a UUID to detect duplicated shift.' => 'クライアントアプリケーションは、重複したバイトの登録を防ぐため、この値を送信するようにしてください。',
    'Common ability' => 'つきやすいギアパワー',
    'Created' => '作成',
    'Crew members rescued' => '助けた回数',
    'Crew members\' (except `my_data`) data, typically have 3 elements' => '仲間のデータ（自分のデータを除く）。典型的には3要素',
    'Current X-power' => '現在のXパワー',
    'Current date time will be used if omitted' => '省略した場合、現在の日時を使用します',
    'Current rank' => '現在のウデマエ',
    'Date and time when ready to play' => 'プレイ可能になった日時',
    'Deaths per battle' => 'バトルあたりのデス数（平均デス）',
    'Deaths per minute' => '1分あたりのデス数',
    'Do not rely on this behavior.' => 'この挙動に依存しないでください。',
    'Effects' => '効果',
    'End time of this shift' => 'このバイトの終了時間',
    'Event information' => 'イベント情報',
    'Event' => 'イベント',
    'Example:' => '例:',
    'Fail reason' => '失敗理由',
    'Failed the shift' => '失敗した',
    'Fetch data from SplatNet 2.' => 'イカリング2からデータを取得します。',
    'Filter by brand' => 'ブランドでフィルタする',
    'Filter by gear category' => 'ギア種類でフィルタする',
    'Filter by permanent ID' => '永続的 ID でフィルタします',
    'Filter by primary ability' => 'メインギアパワーでフィルタする',
    'Filter by stage' => 'ステージでフィルタします',
    'Filter by user' => 'ユーザでフィルタします',
    'Filter unposted shifts and post to us.' => '未登録のバイトを抽出して、投稿します。',
    'Found same data' => '同じデータを発見',
    'Gear category' => 'ギア種類',
    'Gender information' => '性別情報',
    'Gender' => '性別',
    'Generate a UUID version 3 or 5 on your side with your own namespace' => 'Version 3 か 5 の UUID を生成して送信します（名前空間はあなたのアプリケーションで独自に定義してください）',
    'Generate a UUID version 4 on your side' => 'Version 4 UUID を生成して送信します',
    'Generate a UUID version 5 with namespace `{ns}`.' => '名前空間 `{ns}` を使用して、Version 5 UUID を生成します',
    'Get Salmon Run results (with Auth)' => 'サーモンラン結果を取得（認証あり）',
    'Get Salmon Run results' => 'サーモンラン結果を取得',
    'Get Salmon Run stats (card data)' => 'サーモンランのポイントカード情報を取得',
    'Get gears in CSV format' => 'ギアをCSV形式で取得',
    'Get gears' => 'ギアを取得',
    'Get modes' => 'ルールを取得',
    'Get stages (obsoleted)' => 'ステージを取得（廃止）',
    'Get stages' => 'ステージを取得',
    'Get the Salmon Run results' => 'サーモンラン結果を取得（1件）',
    'Get user\'s battle stats' => 'ユーザのバトル統計を取得',
    'Get weapons in CSV format' => 'ブキをCSV形式で取得',
    'Get weapons' => 'ブキを取得',
    'Golden Egg appearances' => '金イクラ出現数',
    'Golden Eggs collected' => '集めた金イクラ',
    'Golden Eggs delivered' => '金イクラ納品数',
    'HTML version' => 'HTML版',
    'Hazard Level, 200.0 = "Hazard Level MAX!!"' => 'キケン度、200.0 = キケン度MAX',
    'Highest X-power ever' => 'これまでで最高のXパワー',
    'Highest rank ever' => 'これまでで最高のウデマエ',
    'How many appearance' => '出現数',
    'How many bosses appearances' => 'オオモノシャケの出現数',
    'How many cleared waves' => 'クリアした WAVE 数',
    'How many times special weapon used in each wave' => 'WAVE 毎に何回スペシャルを使用したか',
    'How many times the special weapon was used in each wave' => '各 WAVE でスペシャルウェポンを使用した回数',
    'How to create the UUID:' => 'UUID の作り方:',
    'If automated.' => '自動化されている',
    'If it is a weapon that only looks different, like the Hero series, this points to the original weapon.' => 'ヒーローシリーズのように見た目が異なるだけのブキの場合に、オリジナルのブキを示します。',
    'If manual input.' => '自動化されていない',
    'If not appearances the boss, you can send `0` or omit the boss.' => 'ボスの出現がない場合、 `0` を送信するか、ボス自体を省略することができます。',
    'If not kills the boss, you can send `0` or omit the boss.' => 'キルしていないボスは、`0` を送信するか、ボス自体を省略することができます。',
    'If omitted, we will automatically generate a random UUID.' => '省略された場合、自動的にランダムな UUID を生成します。',
    'If the value is not correct as a UUID, we will use that value as a seed to generate a UUID.' => 'UUID として正しくない形式が与えられた場合、その値を元に UUID が生成されます。',
    'If you omitted the <code>id</code>, you will get a latest data.' => '<code>id</code> を省略した場合、最新の情報を取得します。',
    'If you specified other player\'s <code>id</code> value, you will get the 404 error.' => '他人の <code>id</code> を指定した場合、 404 エラーが返ります。',
    'If your client doesn\'t/cannot detect this data, omit this field or send just `null`.' => 'クライアントがこのデータを検出しない/できない場合、フィールドごと省略するか、単に `null` を送信してください。',
    'IkaLog environment. This probably doesn\'t make sense in Splatoon 2' => 'IkaLog 環境。Splatoon 2 では意味をなさないことが大半でしょう。',
    'Information about each wave' => '各 WAVE の情報',
    'Is automated posting process?' => '自動化された投稿プロセスか',
    'Is player cleared the shift?' => 'バイトをクリアしたか',
    'Is the post with automated process?' => '自動化された投稿プロセスか',
    'It can be obtained from the [user settings page](https://stat.ink/profile).' => 'API トークンは、[ユーザ設定ページ](https://stat.ink/profile)から取得できます。',
    'Kill ratio' => 'キルレシオ',
    'Kills per battle' => 'バトルあたりのキル数（平均キル）',
    'Kills per minute' => '1分あたりのキル数',
    'Last updated at' => '最終更新日時',
    'Main Power Up effects information' => 'メイン性能アップの効果情報',
    'Max records to get' => '最大取得レコード数',
    'Maximum inked' => '最大塗った面積',
    'Mode information' => 'ルール情報',
    'Mode' => 'ルール',
    'Name of the user agent' => 'ユーザエージェントの名前',
    'Name of your client' => 'クライアントの名前',
    'Newer to older (default in most case)' => '新しいものから古いもの（ほとんどの場合でデフォルト）',
    'Nintendo Network ID' => 'ニンテンドーネットワーク ID',
    'Nintendo Switch Friend Code' => 'Nintendo Switch フレンドコード',
    'Note: this value may not be in SplatNet JSON.' => 'メモ: この値はイカリング2のJSONには含まれていません。',
    'Nothing send (Disabled duplicate detection)' => '何も送信しない（重複検出は無効になります）',
    'Number of battles' => 'バトル数',
    'Number of cleared waves. 3 if cleared, 0 if failed in wave 1.' => 'クリアした WAVE 数。クリアすれば 3、WAVE 1 で全滅すれば 0。',
    'Number of kills the boss salmonid' => 'オオモノシャケをたおした回数',
    'Number of times rescued by other players' => '他のプレイヤーによって助けられた回数',
    'Number of times rescued other players' => '他のプレイヤーを助けた回数',
    'Number of times the player kills each boss' => 'このプレイヤーがボスを倒した回数',
    'Number of times the player kills {boss}' => 'このプレイヤーが{boss}を倒した回数',
    'Obsoleted and no longer used' => '廃止されました',
    'Older to newer' => '古いものから新しいもの',
    'Otherwise' => 'その他の場合',
    'Per rule information' => 'ルール別の情報',
    'Permanent ID of the results' => '結果の永続的 ID',
    'Permanent ID' => '永続的 ID',
    'Player name' => 'プレイヤー名',
    'Player results' => 'プレイヤーのリザルト',
    'Player\'s data' => '自分のデータ',
    'Player\'s in-game name' => 'プレーヤーのゲーム内での名前',
    'Post Salmon Run results' => 'サーモンラン結果を送信',
    'Post Salmon Run stats (card data)' => 'サーモンランのポイントカード情報を送信',
    'Posted time' => '投稿時間',
    'Power Eggs collected' => '集めたイクラの数',
    'Primary ability' => 'メインギアパワー',
    'Profile page URL' => 'プロフィールページのURL',
    'Public URL' => '公開URL',
    'Quota' => 'ノルマ',
    'Quotas calculated by Hazard Level' => 'キケン度から計算したノルマ',
    'Ranked + league battle statistics' => 'ガチマッチ+リーグマッチ統計',
    'Reason' => '理由',
    'Redirect' => 'リダイレクト',
    'Refer "category1"' => 'category1を参照してください',
    'Refer to [RFC 4122](https://tools.ietf.org/html/rfc4122) for format details.' => 'フォーマットの詳細は [RFC 4122](https://tools.ietf.org/html/rfc4122) を参照してください。',
    'Result order' => '結果の並び順',
    'Returns Salmon Run results.' => 'サーモンランの結果を返します。',
    'Returns Salmon Run stats.' => 'サーモンランの統計情報を返します。',
    'Returns all of gear information in CSV (RFC 4180) format.' => 'すべてのギアの情報を CSV (RFC 4180) 形式で返します。',
    'Returns all of weapon information in CSV (RFC 4180) format.' => 'すべてのブキの情報を CSV (RFC 4180) 形式で返します。',
    'Returns an array of gear information' => 'ギア情報を配列で返します',
    'Returns an array of mode information' => 'ルール情報を配列で返します',
    'Returns an array of stage information' => 'ステージ情報を配列で返します',
    'Returns an array of weapon information' => 'ブキ情報を配列で返します',
    'Returns only SplatNet\'s ID Numbers' => 'イカリング2の番号のみを返します',
    'Returns specified user\'s stats (e.g., how many kills)' => 'ユーザの統計情報（例えばキル数）を返します',
    'Returns the Salmon Run results.' => 'サーモンランの結果を返します。',
    'Salmon Run fail reason' => '失敗理由',
    'Salmon Run results page URL' => 'サーモンラン結果一覧のURL',
    'Salmon Run stats' => 'サーモンラン統計情報',
    'Salmon Run title (consider gender)' => 'サーモンラン称号（性別考慮）',
    'Salmon Run title (doesn\'t consider gender)' => 'サーモンラン称号（性別未考慮）',
    'Salmon Run title information' => 'サーモンラン称号情報',
    'Set `null`, empty string or omit the field if no event.' => 'イベントでない場合は、`null`や空文字列を送信するか、フィールドごと省略してください。',
    'Sex code defined in ISO 5218' => 'ISO 5218 で定義された性別コード',
    'Shift number in SplatNet 2' => 'イカリング2でのバイト番号',
    'Shifts (jobs) worked' => 'バイト回数',
    'Special weapon information' => 'スペシャルの情報',
    'Special weapon' => 'スペシャルウェポン',
    'Species' => '種族',
    'SplatNet 2 based Application' => 'イカリング2ベースのアプリケーション',
    'SplatNet number big to small (default if "only" = "splatnet_number")' => 'イカリングの番号が大きいものから小さいもの ("only" = "splatnet_number" のデフォルト)',
    'SplatNet number small to big' => 'イカリングの番号が小さいものから大きいもの',
    'SplatNet specified ID' => 'イカリング定義のID',
    'SplatNet\'s `principal_id`' => 'イカリングの `principal_id`',
    'Stage information' => 'ステージ情報',
    'Stage' => 'ステージ',
    'Standalone Application (e.g., user\'s input or screen capture)' => 'スタンドアロンアプリケーション（例: ユーザ入力やスクリーンキャプチャ）',
    'Start time of this shift' => 'このバイトの開始時間',
    'Stat.ink user ID' => 'stat.ink ユーザ ID',
    'Statistics for {rule}' => '{rule}の統計情報',
    'Sub weapon information' => 'サブウェポンの情報',
    'Sub weapon' => 'サブウェポン',
    'Successful' => '成功',
    'Teammates\' play data' => 'チームメイトのプレイデータ',
    'The API Token is issued for each user by stat.ink system.' => 'API トークンは、stat.ink のシステムによってユーザごとに発行されます。',
    'The API endpoint will return `302 Found` if job has same UUID posted in last 24 hours.' => '24 時間以内に同一の UUID が送信された場合、`302 Found` が返ります。',
    'The time when this rotation (play window) started in unix time format.' => 'バイト期間（プレイ期間）が開始された日時を UNIX タイムスタンプで指定します。',
    'The time when this shift ended in unix time format.' => 'このバイトが終了した日時を UNIX タイムスタンプで指定します。',
    'The time when this shift started in unix time format.' => 'このバイトが開始された日時を UNIX タイムスタンプで指定します。',
    'The value of <code>id</code> is obtained in the Location header of the POST API.' => '<code>id</code> は POST API の Location ヘッダから取得できます。',
    'This API has been obsoleted.' => 'この API は廃止されました。',
    'This is helpful for unintended duplication, but it is helpless for complate detect duplication.' => 'この UUID は意図しない重複の検出に役立ちますが、完全な検出は行いません。',
    'This parameter is required if `{name}` set.' => '`{name}`が設定されている場合、このパラメータは必須です。',
    'This parameter is required if you set `only` = `splatnet_number`.' => '`only` に `splatnet_number` が指定されている時、このパラメータは必須です。',
    'This points to the main weapon.' => 'メインウェポンを示します',
    'Title (after the shift)' => '称号（バイト後）',
    'Title (before the shift)' => '称号（バイト前）',
    'Title points (after the shift)' => '称号ポイント（バイト後）',
    'Title points (before the shift)' => '称号ポイント（バイト前）',
    'Title' => '称号',
    'Total area' => '総面積',
    'Total deaths' => '合計デス数',
    'Total inked' => '合計塗った面積',
    'Total kills' => '合計キル数',
    'Total points' => '累計ポイント',
    'Turf War statistics' => 'ナワバリバトル統計',
    'Twitter screen name' => 'Twitterのユーザ名',
    'URL for API call that created' => '作成したデータの API 呼び出し用 URL',
    'URL for API call' => 'API呼び出し用URL',
    'URL that related to this post. (e.g., YouTube video)' => 'この投稿に関連する URL（例えば YouTube 動画）',
    'Uncommon ability' => 'つきにくいギアパワー',
    'Unique ID (UUID)' => 'ユニークID (UUID)',
    'Unique ID of the player' => 'プレイヤーのユニーク ID',
    'Unknown result' => '結果不明',
    'Use "`splatnet_number`@`principal_id`" format. (Example: `{example}`)' => '"`splatnet_number`@`principal_id`" の形式を利用してください（例：`{example}`）',
    'Use [`{path}`]({link}) instead of this.' => '替わりに、 [`{path}`]({link}) を使用してください。',
    'User agent information' => 'ユーザエージェント情報',
    'User information' => 'ユーザ情報',
    'User name' => 'ユーザ名',
    'User note' => 'ユーザによるメモ',
    'User profile' => 'ユーザプロフィール情報',
    'User registered at' => 'ユーザ登録日時',
    'User\'s private note' => '非公開メモ',
    'User\'s screen name' => 'ユーザのログイン名',
    'Value' => '値',
    'Version of the user agent' => 'ユーザエージェントのバージョン',
    'Version of your client' => 'クライアントのバージョン',
    'Water level information' => '海面レベル情報',
    'Water level' => '水の高さ',
    'Wave informations' => 'WAVE情報',
    'We recommend posting by the following procedure:' => '次の手順に従って処理してください:',
    'Weapon category information' => 'ブキカテゴリー情報',
    'Weapon category' => 'ブキカテゴリー',
    'Weapon' => 'ブキ',
    'Weapons loaned in each wave' => '各 WAVE で支給されたブキ',
    'What special weapon assigned' => '割り当てられたスペシャルウェポン',
    'When this data was acquired in Unix timestamp' => 'いつの時点のデータかを Unix タイムスタンプで指定します',
    'When this data was acquired' => 'いつの時点のデータか',
    'When this data was sent' => 'データがいつ送信されたか',
    'Which rotation (play window, schedule)' => 'どのバイト期間のプレイか',
    'Winning percentage' => '勝率',
    'You can only get data for user who is authenticated by API token.' => 'API トークンで認証されたユーザ自身のデータのみが取得可能です。',
    'You\'ll get `newer_than` &lt; `id` &lt; `older_than`.' => '`newer_than` &lt; `id` &lt; `older_than` の範囲を取得します',
    '[Ika-Nakama](https://ikanakama.ink/) profile URL' => '[イカナカマ](https://ikanakama.ink/)プロフィールページURL',
    '`3` if cleared. `0` if failed in wave 1.' => 'クリアしたら `3`、WAVE 1 で落ちたら `0`',
    '`40` if Profreshional `40` of `999`' => 'たつじん `40`/`999` なら `40` を指定します。',
    '`null` or empty string if cleared or unknown' => 'クリアした場合や不明な場合は `null` か空文字列を指定します。',
    'stat.ink API for Splatoon 2' => 'Splatoon 2 用 stat.ink API',
    '{boss} appearances' => '{boss}出現数',
];
