<?php

/**
 * @copyright Copyright (C) 2015-2024 AIZAWA Hina
 * @license https://github.com/fetus-hina/stat.ink/blob/master/LICENSE MIT
 * @author 7185 <7185@users.noreply.github.com>
 * @author AIZAWA Hina <hina@fetus.jp>
 * @author codl <codl@codl.fr>
 * @author Hitomi <119537233+Hitomi11212@users.noreply.github.com>
 * @author ultrasonicytb <ultrasonic2408@gmail.com>
 */

declare(strict_types=1);

return [
    '(combined)' => '(combiné)',
    '(default)' => '(par défaut)',
    '(For advanced users)' => '(Pour des utilisateurs avancés)',
    '(incomplete)' => '(incomplet)',
    '(unknown result)' => '(résultat inconnu)',
    '* This exclusion is an attempt to minimize overcounting in weapon usage statistics.' => '* Cette exclusion est une tentative de minimisation d\'un surcomptage dans les statistiques d\'utilisation d\'armes.',
    '1x Battle' => 'Match x1',
    '3+9 Format' => 'Format 3+9',
    '3, 9 Format' => 'Format 3, 9',
    '7 players for each battle (excluded the battle uploader)' => '7 joueur pour chaque matchs (exclut l\'auteur de téléchargement du match',
    '10x Battle' => 'Match ×10',
    '24H Win %' => '% Victoire 24H',
    '50% (reference)' => '50% (référence)',
    '57 Format' => 'Format 57',
    '100x Battle' => 'Match ×100',
    '100x Battle WINNER!' => 'Match ×100 remporté !',
    '333x Battle' => 'Match ×333',
    '333x Battle WINNER!' => 'Match ×333 remporté !',
    '<a href="http://www.emoji-cheat-sheet.com/" target="_blank">Cheat sheet</a>. If omitted, the default icon will be used.' => '<a href="http://www.emoji-cheat-sheet.com/" target="_blank">Cheat sheet</a>. Si négligé, l\'icône par défaut sera utilisée.',
    '<code>@id</code> (without <code>@</code>), case sensitive.' => '<code>@id</code> (sans le <code>@</code>), casse sensible',
    '<div class="input-group"><span class="input-group-addon">From:</span>{input}</div>' => '<div class="input-group"><span class="input-group-addon">De:</span>{input}</div>',
    '<div class="input-group"><span class="input-group-addon">To:</span>{input}</div>' => '<div class="input-group"><span class="input-group-addon">À:</span>{input}</div>',
    'Ability' => 'Bonus',
    'Ability Effect' => 'Effet du bonus',
    'About Incoming Webhook' => 'À propos du Webhook',
    'About support for color-blindness' => 'À propos du support pour les daltoniens',
    'Active Players' => 'Joueurs actifs',
    'Activity' => 'Activité',
    'Add' => 'Ajouter',
    'Add <code>/slack</code> to the end of the created webhook URL.' => 'Ajoute <code>slack</code> à la fin de de l\'URL webhook crée ',
    'Add Slack Integration' => 'Ajouter l\'intégration Slack',
    'Advanced Options' => 'Options Avancées',
    'Aggregated: {rules}' => 'Agrégé: {rules}',
    'Aliases' => 'Alias',
    'All' => 'Tous',
    'All Players' => 'Tous les joueurs',
    'Always enable horizontal scroll' => 'Toujours activer le défilement horizontal',
    'Anarchy Power' => 'Power Anarchie',
    'Anonymize, don\'t link from other user\'s results' => 'Anonymiser, ne pas lier aux résultats d\'autres joueurs',
    'Anonymized' => 'Anonymisé',
    'Another account' => 'Autre compte',
    'Any Result' => 'Tous résultats',
    'Any Time' => 'Tout temps',
    'API Info: Abilities (Splatoon 3)' => 'Info de l\'API : Bonus (Splatoon 3)',
    'API Info: Boss Salmonids (Splatoon 3)' => 'Info de l\'API : Salmonoboss (Splatoon 3)',
    'API Info: Gears: {0}' => 'Info de l\'API : Équipements : {0}',
    'API Info: Known Occurrences (Splatoon 3)' => 'Info de l\'API : Fréquence connu (Splatoon 3)',
    'API Info: Medals (Splatoon 3)' => 'Info de l\'API : Médailles (Splatoon 3)',
    'API Info: Stages (Splatoon 2)' => 'Info de l\'API : Stages (Splatoon 2)',
    'API Info: Stages (Splatoon 3)' => 'Info de l\'API : Stages (Splatoon 3)',
    'API Info: Titles (Splatoon 3)' => 'Info de l\'API : Titres (Splatoon 3)',
    'API Info: Uniforms (Splatoon 3)' => 'Info de l\'API : Uniformes (Splatoon 3)',
    'API Info: Weapons' => 'Info de l\'API : Armes',
    'API Info: Weapons (Splatoon 2)' => 'Info de l\'API : Armes (Splatoon 2)',
    'API Info: Weapons (Splatoon 3)' => 'Info de l\'API : Armes (Splatoon 3)',
    'API Token' => 'Jeton d\'API',
    'Apply' => 'Appliquer',
    'Apps for {version}' => 'Applications pour {version}',
    'Area' => 'Lieu',
    'Are you sure you want to regenerate your API token?' => 'Êtes-vous sûr de vouloir regénerer votre jeton d\'API ?',
    'Assist' => 'Assistance',
    'Assists' => 'Assistances',
    'Assists/min' => 'Assistances/min',
    'Attacker Team Win Rate' => 'Taux de victoire de l\'équipe attaquante',
    'Auto (cookie)' => 'Auto (cookie)',
    'Auto (Identicon)' => 'Au (Identicon)',
    'Automated' => 'Automatique',
    'Average' => 'Moyenne',
    'Average:' => 'Moyenne :',
    'Average Gear Abilities' => '',
    'Avg.' => 'Moy.',
    'Avg. game in {time}' => 'Moy. match in {time}',
    'Avg. K.O. in {time}' => 'Moy. K.O. in {time}',
    'Avg. Uses' => 'Moy. Utilisation',
    'Avg Assists' => 'Moy Assists',
    'Avg Deaths' => 'Moy Morts',
    'Avg Inked' => 'Moy Encre',
    'Avg K+A' => 'Moy K+A',
    'Avg Kills' => 'Moy Kills',
    'Avg KR' => 'Moy KR',
    'Avg Specials' => 'Moy Spécial',
    'Back' => 'Retour',
    'Badge Progress' => 'Progression de l\'obtention du badge',
    'Badges' => 'Badges',
    'Bad Guys' => 'Adversaires',
    'Bad guys are in control' => 'L\'équipe adverse mène',
    'Bad guys winning' => 'L\'équipe adverse gagne',
    'Based on deaths' => 'Basé sur les morts',
    'Based on kills' => 'Basé sur les kills',
    'Battle Count' => 'Décompte de match',
    'Battle End' => 'Match fini',
    'Battle results (CSV)' => 'Résultats de matchs (CSV)',
    'Battles' => 'Matchs',
    'Battles:' => 'Matchs :',
    'Battles:{0} / Win %:{1} / Avg Kills:{2} / Avg Deaths:{3} / Kill Ratio:{4}' => 'Matchs : {0} / % Victoire : {1} / Moy Kills : {2} / Moy Morts : {3} / Kill Ratio : {4}',
    'Battles and Users' => 'Matchs et utilisateurs',
    'Battle Start' => 'Début du match',
    'between {down} and {up} {name}' => 'entre {down} et {up} {name}',
    'Bin Width' => 'Largeur du bac',
    'Black out' => 'Assombrir/retirer',
    'Black out except private battle' => 'Assombrir/retirer sauf pour les matchs privés',
    'Black out except private battle and teammate on league battle (4 players)' => 'Assombrir/retirer sauf pour les matchs privés et coequipiers en ligue (4 Joueurs)',
    'Black out except private battle and teammate on squad battle (tri or quad)' => 'Assombrir/retirer sauf pour les matchs privés et coequipiers en groupe (3 ou 4 Joueurs)',
    'Black out other players' => 'Assombrir/retirer les autres joueurs',
    'Black out other players (details)' => 'Assombrir/retirer les autres joueurs (infos)',
    'Black out other players (images)' => 'Assombrir/retirer les autres joueurs (images)',
    'Black out other players from the details list' => 'Assombrir/retirer les autres joueurs de la liste d\'infos',
    'Black out other players from the result image' => 'Assombrir/retirer les autres joueurs de l\'image des resultats',
    'Blog' => 'Blog',
    'Boy' => 'Garçon',
    'Brand' => 'Marque',
    'Calendar' => 'Calendrier',
    'Capture Environment' => 'Evironnement d\'enrgistrement',
    'Cash' => 'Argent',
    'Category' => 'Catégorie',
    'Cause of Death' => 'Cause de la mort',
    'Challenge Power' => 'Challenge Power',
    'Challenge Power Distribution' => 'Distribution du Challenge Power',
    'Change Icon' => 'Changer d\'icône',
    'Change Password' => 'Changer de mot de passe',
    'Change Screen Name' => '',
    'Channel' => 'Chaîne',
    'Check with Setup Analyzer' => 'Verifier avec le Setup Analyser',
    'Click to copy' => 'Cliquez pour copier',
    'Close' => 'Fermer',
    'Clout' => 'Contribution',
    'Clout (Normal)' => 'Contribution (Normal)',
    'Clout (Pro)' => 'Contribution (Défi)',
    'Color-Blind Support' => 'Mode daltoniens',
    'Color 1' => 'Couleur 1',
    'Color 2' => 'Couleur 2',
    'Color Scheme' => 'Palette de couleurs',
    'combos' => 'combos',
    'Compare Number Of Uses' => 'Comparer le Nombre d\'Utilisation',
    'Compare number of uses' => 'Comparer le nombre d\'utilisation',
    'Completed!' => 'Complété !',
    'Connectivity' => 'Connectivité',
    'Consider to be Defeated' => 'Considéré comme une défaite',
    'Continue' => 'Continuer',
    'Copied!' => 'Copié !',
    'Correction' => 'Correction',
    'Correction Value' => 'Valeur de corrrection',
    'Correlation Coefficient' => 'Coefficient de corrélation',
    'Correlation with Win %' => 'Corrélation avec le % de victoire',
    'Could not be updated.' => 'N\'a pas pu être mis à jour.',
    'Could not find specified battle.' => 'N\'a pas pu trouver le match demandé.',
    'Could not get your twitter icon at this time.' => 'N\'a pas pu récupérer votre icône Twitter pour le moment.',
    'Could not update your icon. Please try again.' => 'N\'a pas pu mettre à jour votre icône. Veuillez réessayer.',
    'Count (Bad Guys)' => 'Progression (Adversaires)',
    'Count (Good Guys)' => 'Progression (Ton équipe)',
    'Create new webhook' => 'Créer un nouveau Webhook',
    'CSV (IkaLog compat.)' => 'CSV (compatible IkaLog)',
    'CSV format' => 'Format CSV',
    'Current' => 'Actuel',
    'Current/Last Splatfest' => 'Actuel/Dernier Splatfest',
    'Current Password' => 'Mot de passe actuel',
    'Current Period' => 'Période Actuelle',
    'Current Stages' => 'Stages Actuels',
    'Current Time:' => 'Heure :',
    'd' => 'm',
    'D/min' => 'm/min',
    'Daily Report' => 'Rapport journalier',
    'Data Sent' => 'Données envoyées',
    'Date' => 'Date',
    'Date Time' => 'Date et heure',
    'Dead' => 'Mort',
    'Deaths' => 'Morts',
    'Deaths (average):' => 'Morts (moyenne)',
    'Deaths (median):' => 'Morts (médiane)',
    'Deaths/min' => 'Morts/min',
    'Deaths Per Battle' => 'Morts par matchs',
    'Deaths per minute' => 'Morts par minutes',
    'Default Color' => 'Couleur par défaut',
    'Default Order' => '',
    'Defeat' => 'Défaite',
    'Defeat (Exempted)' => 'Défaite (non comptée)',
    'Delete' => 'Supprimer',
    'Delete This Battle' => 'Supprimer ce match',
    'Delete This Job' => 'Supprimé ce travail',
    'Detail' => 'Détail',
    'Detailed' => 'Détaillé',
    'Detailed List' => 'Liste détaillée',
    'Details' => 'Détails',
    'Deviation' => 'Déviation',
    'Disabled' => 'Désactivé',
    'Disconnected' => 'Déconnecté',
    'Discord' => 'Discord',
    'Don\'t anonymize, display in-game name' => 'Ne pas anonymiser, afficher le nom in-game',
    'Don\'t anonymize, display stat.ink\'s name' => 'Ne pas anonymiser, afficher le nom stat.ink',
    'Don\'t group' => 'Ne pas grouper',
    'Do not close this window.' => 'Ne pas fermer cette page.',
    'Downloads' => 'Téléchargements',
    'Download Stats' => 'Données à télécharger',
    'Draw' => 'Match nul',
    'e.g. YouTube video, like "{0}"' => 'ex : Vidéo YouTube, comme "{0}"',
    'Earlier Turf-Inked data is currently wrong. It will be fixed in the near future.' => 'Les dernières données d\'encrage sont erronées. Elles seront bientôt corrigées.',
    'Edit' => 'Modifier',
    'Edit Your Battle: #{0}' => 'Modifier votre match : #{0}',
    'Effects' => 'Effets',
    'Elapsed' => 'Écoulé',
    'Elapsed Time' => 'Temps écoulé',
    'Elapsed Time (seconds)' => 'Temps écoulé (secondes)',
    'Email' => 'E-mail',
    'Empirical Estimates' => 'Estimation Empirique',
    'Enabled' => 'Activé',
    'Enable machine-translation' => 'Activer la traduction automatique',
    'Enable noise reduction (count)' => 'Activer la réduction de bruit (compte)',
    'Enable noise reduction (position of the objective)' => 'Activer la réduction de bruit (position de l\'objectif)',
    'Encounter Ratio' => 'Ratio de rencontre',
    'Enemy Weapon' => 'Arme Adverse',
    'Equip %' => 'Equip %',
    'Error' => 'Erreur',
    'Error bars' => 'Barres d\'erreur',
    'Error bars: 95% confidence interval (estimated)' => 'Barres d\'erreur: Intervalle de confiance à 95 %(estimé)',
    'Error bars: 95% confidence interval (estimated) & 99% confidence interval (estimated)' => 'Barres d\'erreur: Intervalle de confiance à 95 %(estimé) et Intervalle de confiance à 99%',
    'Estimated Error' => 'Erreur estimé',
    'Estimated Vote %' => 'Vote Estimé en %',
    'Estimated X Power' => 'X Power Estimé',
    'Europe' => 'Europe',
    'Europe/Oceania' => 'Europe/Oceanie',
    'Even you set them up in the input fields below they will not work.' => 'Même si vous les configurez dans les champs de saisie ci-dessous, ils ne fonctionneront pas.',
    'Excluded: Private Battles' => 'Exclu : Matchs Privés',
    'Excluded: Private Battles and Squad Battles (when Rank S or S+)' => 'Exclus : Matchs Privés et Matchs en groupe (Quand le rang est S ou S+)',
    'Excluded: The uploader, All players (Private Battle), Uploader\'s teammates (Squad Battle or Splatfest Battle)' => 'Exclus : L\'uploader, Tous les joueurs (Matchs Privés), Coéquipiers de l\'uploader (Match en Groupe ou Matchs Splatfest)',
    'Export' => 'Exporter',
    'Extra Data' => 'Données Supplémentaires',
    'Favorite Weapon' => 'Arme préférée',
    'Favorite Weapons' => 'Armes préférées',
    'Favorite Weapons of This Site Member' => 'Armes préférées de ce joueur',
    'Feedback or suggestions are welcome. Please contact me via GitHub or Twitter.' => 'Les commentaires et suggestions sont les bienvenues. Veuillez me contacter via GitHub ou Twitter',
    'fest.ink' => 'fest.ink',
    'Fest Power' => 'Fest Power',
    'Fest Power (Normal)' => 'Fest Power (Normal)',
    'Fest Power (Pro)' => 'Fest Power (Défi)',
    'Few' => 'Peu',
    'Filter' => 'Filtre',
    'Filter Query' => 'Requête de Filtre',
    'Final Count' => 'Progression Finale',
    'For the actual distribution, see the charts for each mode.' => 'Pour la distribution actuel, consultez les graphiques de chaque mode.',
    'for {title}' => 'pour {title}',
    'Freshness' => 'Titre d\'arme',
    'Friend Code' => 'Code ami',
    'Friend Code (Switch)' => 'Code ami (Switch)',
    'Game Mode' => 'Mode de jeu',
    'Game Version' => 'Version du jeu',
    'Gear' => 'Équipement',
    'GeoIP guessed {timezone}' => 'GeoIP Devinée {timezone}',
    'Getting Started' => 'Premiers pas',
    'Girl' => 'Fille',
    'GNU Social, Mastodon etc.' => 'GNU Social, Mastodon, etc',
    'Good Guys' => 'Ton équipe',
    'Good guys are in control' => 'Ton équipe mène',
    'Good guys winning' => 'Ton équipe gagne',
    'Group by main weapon' => 'Grouper par arme principale',
    'Group by reskins' => 'Grouper par reskins',
    'Group by weapon type' => 'Grouper par type d\'arme',
    'Guessed:' => 'Deviné :',
    'Guessed by your IP:' => 'Deviné grâce à ton IP :',
    'Guess the region' => 'Devine la région.',
    'Guest' => 'Invité',
    'Has disconnected player' => 'À une déconnexion',
    'Hasn\'t disconnected player' => 'N\'a pas de déconnexion',
    'Hawaii Time' => 'Heure d\'Hawaii',
    'Hide your data on the top page' => 'Cacher vos données en haut de la page ',
    'Highest (current period)' => 'Maximum (Rotation actuelle)',
    'Highest (this teammates)' => 'Maximum (ces coéquipiers)',
    'Highest First' => '',
    'History' => 'Historique',
    'However, statistics information will be opened.' => 'Cependant, les information à propos des statistiques vont être ouvertes.',
    'I agree. Delete this battle.' => 'Je suis sûr. Supprimer ce match.',
    'I agree to the terms above.' => 'J\'accepte les conditions ci-dessus.',
    'Icon' => 'Icône',
    'Idea: {source}' => 'Idée: {source}',
    'If omitted, the channel set in the webhook configuration will be used.' => 'Si négligé, le salon mis dans la configuration du webhook sera utilisé',
    'If omitted, the name set in the webhook configuration will be used.' => 'Si négligé, le nom mis dans la configuration du webhook sera utilisé',
    'If there are any unsubmitted data, they have not been included in this tally.' => 'S\'il y a des données non soumises, elles n\'ont pas été incluses dans ce décompte.',
    'If you already have an account, please click here.' => 'Si vous avez déjà un compte, Cliquez ici.',
    'If you change the screen name with this form, the change will take effect immediately.' => '',
    'If you delete this battle, it will be gone forever.' => 'Voulez-vous vraiment effacer ce match ? Cette action sera irreversible.',
    'If you have pages that you are sharing with URLs, most of them will be broken links.' => '',
    'If you have registered your login information in Password Manager, do not forget to update it.' => '',
    'If you know our API Token' => 'Si vous connaissez votre jeton API',
    'If you misuse this feature, you will be banned.' => 'Si vous abusez de cette fonctionnalité, vous serez banni.',
    'Ika-Nakama' => 'Ika-Nakama',
    'Ika-Nakama User ID' => 'ID d\'utilisateur d\'Ika-Nakama',
    'IkaLog' => 'Ikalog',
    'IkaLog Download Page' => 'Page de téléchargement d\'IkaLog',
    'IkaRec' => 'IkaRec',
    'IkaRec 2' => 'IkaRec 2',
    'Image Sharing' => 'Partage d\'image',
    'Includes battles with unknown event power' => 'Comprend des batailles avec un power d\'événement inconnue',
    'Incomplete Data' => 'Données incomplètes',
    'Ink Color' => 'Coleur d\'encre',
    'Inked' => 'Encré',
    'Inked/min' => 'Encré/min',
    'Inking Performance' => 'Performance d\'encrage',
    'Inking Performance vs Win %' => 'Performance d\'encrage vs % Victoire',
    'Inkling' => 'Inkling',
    'Input new battle results' => 'Ajouter des nouveaux résultats de matchs',
    'In session' => 'En partie',
    'Integrate' => 'Intégrer',
    'Internal ID' => 'Identifiant interne',
    'Interval' => 'Intervalle',
    'In the chart, "{representative}" means greater than or equal to {min} and less than {max}.' => 'Sur ce diagramme, "{representative}" correspond aux points superieurs ou égaux à {min} et inférieurs à {max}.',
    'Invalid {0} or {1}.' => 'Invalide {0} ou {1}',
    'IQR' => 'OQR',
    'Items marked with these icons will only work with its corresponding version.' => 'Les Articles marqué par ces icônes ne marcheront uniquement avec leur version correspondante',
    'It looks this data is corrupt.' => 'On dirait que cette donnée est corrompue',
    'Japan' => 'Japon',
    'Japan Time' => 'Heure Japonaise',
    'Join us' => 'Rejoignez-nous',
    'JSON (IkaLog compat.)' => 'JSON (compatible IkaLog)',
    'JSON (stat.ink format, gzipped)' => 'JSON (format stat.ink, compressé en gzip)',
    'JSON format' => 'Format JSON',
    'JSON format (All langs)' => 'Format Json (Toutes Langues)',
    'Judge' => 'Arbitre',
    'Just scaled for easy contrast, the Y-axis value does not directly indicate the number of people.' => 'Juste une mise à l\'échelle pour faciliter le contraste, la valeur de l\'axe Y n\'indique pas directement le nombre de personnes',
    'Just {result} {rule} at {stage}' => 'Juste {result} {rule} at {stage}',
    'k' => 'K',
    'K+A/D' => 'K+A/D',
    'K+A/min' => 'K+A/min',
    'K-D' => 'K-D',
    'K/D vs Win %' => 'K/D vs % Victoire',
    'K/min' => 'K/min',
    'Keep doing it.' => 'Continue ',
    'Kill or Assist' => 'Kill ou assist',
    'Kill Rate' => 'Taux de Kills',
    'Kill Ratio' => 'Ratio de Kills',
    'Kills' => 'Kills',
    'Kills (average):' => 'Kills (moyenne) :',
    'Kills (median):' => 'Kills (médiane) :',
    'Kills / Deaths' => 'Kills / Morts',
    'Kills/min' => 'Kills/min',
    'Kills and Deaths' => 'Kills et Morts',
    'Kills per minute' => 'Kills par minutes',
    'Knockout' => 'K.-O.',
    'KNOCKOUT!' => 'K.-O. !',
    'Knockout Rate' => 'Fréquence de K.-O.',
    'KR' => '% K.-O',
    'Lack of data' => 'Manque de données',
    'Language' => 'Langue',
    'Language (used for OStatus)' => 'Langue (utilisée pour OStatus)',
    'Last 24 Hours' => 'Les dernières 24 heures',
    'Last 24h: {winpct} win ({win}/{count}), Avg. {kill}k/{death}d' => 'Dernières 24h : {winpct} Victoire ({win}/{count}), Moy. {kill}k/{death}d',
    'Last Month (UTC)' => 'Mois Dernier (UTC)',
    'Last {n} Battles' => 'Les {n} derniers matchs',
    'Last {n} Periods' => 'Les {n} derniers',
    'Latest' => 'Dernier',
    'Launch' => 'Lancement',
    'League Power' => 'Ligue Power',
    'Legend' => 'Légende',
    'Legends' => 'Légendes',
    'less than {min} {name}' => 'moins que {min} {name}',
    'Level' => 'Niveau',
    'Level (After)' => 'Niveau (après)',
    'Link' => 'Lien',
    'Link from other user\'s results' => 'Liens des résultats d\'autres utilisateurs',
    'Links' => 'Liens',
    'List' => 'Liste',
    'Loading...' => 'Chargement...',
    'Loaned Weapons' => 'Arme emprunté',
    'Lobby' => 'Salon',
    'Lobby (Icon)' => 'Salon (icône)',
    'Location' => 'Localisation',
    'Login' => 'Connexion',
    'Login History' => 'Historique de Connexion',
    'Login history will be deleted in {term}.' => 'L\'historique de connexion sera effacé dans {term}',
    'Login Method' => 'Méthode de Connexion',
    'Log in with other services' => 'Se connecter avec d\'autres services',
    'Log in with Twitter' => 'Se connecter avec Twitter',
    'Logout' => 'Déconnexion',
    'Lose' => 'Défaite',
    'Lost' => 'Défaite',
    'lost' => 'défaite',
    'Low ink' => 'Encre faible',
    'Luminance' => 'Luminance',
    'Luminance Difference' => 'Différence de luminance',
    'Mains' => 'Principales',
    'Main Weapon' => 'Arme principale',
    'Make empty this field when you are using Discord.' => 'Ne rien mettre sur ce champ quand vous utilisez Discord.',
    'Many' => 'Plusieurs',
    'Masked' => 'Masqué',
    'Max.' => 'Max.',
    'max={max} min={min} average={avg} median={median} mode={mode}' => 'max={max} min={min} moyenne={avg} médiane={median} mode={mode}',
    'max={max} min={min} median={median}' => 'max={max} min={min} médiane={median}',
    'max={max} min={min} median={median} stddev={stddev}' => 'max={max} min={min} médiane={median} écart type={stddev}',
    'Maximum' => 'Maximum',
    'Max Inked' => 'Encrage Max',
    'Max Kill Combo' => 'Kill Combo Max',
    'Max Kill Streak' => 'Série de Kills Max',
    'Medal' => 'Médaille',
    'Medals' => 'Médailles',
    'Median' => 'Médiane',
    'Minimum' => 'Minimum',
    'MMMM y' => 'M / Mois / y / Année',
    'Mobile' => 'Mobile',
    'Mode' => 'Mode',
    'Mode (Icon)' => 'Mode (icône)',
    'Mode (Short)' => 'Mode (court)',
    'Mode{translate_hint_stats}' => 'Mode{translate_hint_stats}',
    'Monthly Report' => 'Rapport mensuel',
    'more...' => 'plus...',
    'more than {max} {name}' => 'plus que {max} {name}',
    'Moving Avg. ({0} Battles)' => 'Moy. mobile({0} Matchs)',
    'My team\'s league power' => 'Ligue Power de mon équipe',
    'My team\'s splatfest power' => 'Splatfest Power de mon équipe',
    'My Team Count' => 'Progression de mon équipe',
    'My Team Score' => 'Mon score d\'équipe',
    'My Team Splatfest Power' => 'Splatfest Power de mon équipe',
    'Name' => 'Nom',
    'Name (for display)' => 'Pseudo',
    'Neutral' => 'Neutre',
    'New battle' => 'Nouveau match',
    'New Password' => 'Nouveau mot de passe',
    'New Password (again)' => 'Retapez votre mot de passe',
    'New Screen Name (Login Name)' => '',
    'Next' => 'Suivant',
    'Next Battle' => 'Match suivant',
    'Next Month' => 'Mois suivant',
    'Next Stages' => 'Stages suivants',
    'Nintendo Network ID' => 'ID Network Nintendo',
    'Nintendo Switch Online app' => 'Application Nintendo Switch Online',
    'No' => 'Non',
    'No battles' => 'Pas de matchs',
    'No black out' => 'Pas d\'assombrissment/suppression',
    'No Data' => 'Pas de données',
    'No one in control' => 'Personne ne mène',
    'No redirects from old URLs will be made.' => '',
    'Normal Distribution' => 'Normal distribution',
    'North America/Oceania' => 'Amérique du Nord/Oceanie',
    'Not configured.' => 'Pas configuré',
    'Not Draws' => 'Pas match nul',
    'Note' => 'Note',
    'Note (private)' => 'Note (privé)',
    'Note (public)' => 'Note (publique)',
    'Not enough data is available.' => 'Pas assez de données disponible',
    'Not Winning' => 'Pas victoire',
    'Number of weapons seen' => 'Nombre d\'arme vu',
    'Octoling' => 'Octaling',
    'Official Results' => 'Résultats officiel',
    'Official Twitter' => 'Twitter officiel',
    'Open Source Licenses' => 'Licences Open Source',
    'Others' => 'Autres',
    'Overall Estimates' => 'Estimation global',
    'Password' => 'Mot de passe',
    'Password (again)' => 'Retapez le mot de passe',
    'PC' => 'PC',
    'Peak' => 'Record',
    'Period' => 'Période',
    'Permalink' => 'Permalien',
    'Played With' => '',
    'Player Distribution' => 'Distribution du joueur',
    'Players' => 'Joueurs',
    'Players:' => 'Joueurs :',
    'Please copy an API key below and paste to IkaLog, IkaRec or other apps that are compatible with {0}.' => 'Veuillez copier une clé d\'API ci-dessous et la coller dans IkaLog, IkaRec ou d\'autres application qui sont compatibles {0}.',
    'Please copy this URL:' => 'Veuillez copier cet URL :',
    'Please do not use this feature to destroy evidence.' => 'Veuillez ne pas utiliser cette fonctionnalité pour supprimer des preuves.',
    'Please keep it secret.' => 'Veuillez le garder secret.',
    'Please log in with your new password.' => 'Veuillez vous connectez avec votre nouveau mot de passe',
    'Please refer to the respective projects for any problems or questions regarding the operation of each application.' => 'Merci de vous référer aux projets respectifs pour tout problème ou question concernant le fonctionnement de chaque application.',
    'Please tell us about your capture environment and communication between your Wii U and User Agent (e.g. IkaLog). This information will be public.' => 'Veuillez nous parler de votre environnement de enregistrement et de communication entre votre Wii U et l\'user Agent (ex : IkaLog). Cette information sera publique.',
    'Please wait.' => 'Veuillez patienter.',
    'PNG/JPEG file up to {0}' => 'Fichier PNG/JPEG jusqu\'à {0}',
    'Points' => 'Points',
    'Position' => 'Position',
    'Power' => 'Power',
    'Powered by' => 'Propulsé par',
    'Power Level' => 'Niveau du Power',
    'Prev.' => 'Précédent',
    'Prev. Battle' => 'Match précédent',
    'Prev. Month' => 'Mois précédent',
    'Previous Period' => 'Rotation précédante',
    'Primary Ability' => 'Bonus principal',
    'Primary ability is counted as {value_1_0} and secondary is counted as {value_0_3}.' => '',
    'Privacy Policy' => 'Politique de confidentialité',
    'Profile and Settings' => 'Profil et paramètres',
    'Progress' => 'Progres',
    'Q<sub>1/4</sub>' => '1er quartil',
    'Q<sub>3/4</sub>' => '3ème quartil',
    'Rank' => 'Rang',
    'Rank (After)' => 'Rang (après)',
    'Rank (after the battle)' => 'Rang (après la bataille)',
    'Rank-up Battle' => 'Match de rang supérieur',
    'Rank: Current' => 'Rang actuel',
    'Rank: Peak' => 'Record de rang',
    'Rank in Team' => 'Rang dans l\'équipe',
    'Rare Weapon' => 'Arme rare',
    'Rate' => 'Taux',
    'Ratio' => 'Ratio',
    'Recent Battles' => 'Matchs récents',
    'Recent Results' => 'Résultats récents',
    'Recent Use %' => '% D\'utilisation récente',
    'Regardless of your time zone setting, it is grouped using UTC.' => 'Quel que soit votre paramètre de fuseau horaire, il est regroupé en UTC.',
    'Regenerate your API token' => 'Regénérer votre Jeton d\'API',
    'Region (used for Splatfest)' => 'Région (utilisé pour les Splatfest)',
    'Register' => 'Créer un compte',
    'Regression Line' => 'Régression linéaire',
    'Relative Time' => 'Temps relatif',
    'Released' => 'Publié',
    'Remember me' => 'Se souvenir de moi',
    'Remote Follow' => 'Enlever le suivi',
    'Replay Code' => 'Code de la vidéo du match',
    'Reset icon' => 'Réinitialiser l\'icône',
    'Reset to default icon' => 'Réinitialiser vers l\'icône par défaut',
    'Reset your password' => 'Réinitialiser le mot de passe',
    'Reskin of' => 'Reskin de',
    'Result' => 'Résultat',
    'Results of {name}\'s Battle' => 'Résultats du match de {name}',
    'Room' => 'Salon',
    'Room info (Private)' => 'Infos du salon (Privé)',
    'S/min' => 'Spécial/min',
    'Salmon Run CSV' => 'Salmon run CSV',
    'Salmon Run JSON (gzipped)' => 'Salmon Run Json (compressé) ',
    'Salmon Run results (CSV)' => 'Résultat Salmon Run (CSV)',
    'Samples' => 'Échantillons',
    'Save!' => 'Sauvegarder !',
    'Schedule' => 'Planning',
    'Scheduled' => 'Programmé',
    'Schema' => 'Schéma',
    'Schema information' => 'Informations sur le schéma',
    'Screen Name' => 'Pseudo',
    'Screen Name (Login Name)' => 'Pseudo',
    'Search' => 'Recherche',
    'Search {date}' => 'Rechercher {date}',
    'Search {from} - {to}' => 'Rechercher {from} - {to}',
    'Season' => 'Saison',
    'Secondary Abilities' => 'Bonus additionnels',
    'Seconds' => 'Secondes',
    'Sent an email to your email address. Please check your mailbox and get the verification code.' => 'Un email a été envoyé. Veuillez vérifier votre boîte de réception et récupérez le code de vérification',
    'Series Progress' => 'Progression des Séries',
    'Session History' => 'Historique de Session',
    'Set the name, icon, and channel in the settings within Discord.' => 'Définissez le nom, l\'icône et la chaîne dans les paramètres avec Discord',
    'Settings' => 'Paramètres',
    'Show All Players' => 'Afficher tous les joueurs',
    'Show moving averages' => 'Montrer les moyennes mobiles',
    'Show your API Token' => 'Afficher votre Jeton d\'API',
    'Show your data on the top page' => 'Montrer vos données en haut de la page',
    'Significant?' => 'Significatif ?',
    'Simplified List' => 'Liste Simplifiée',
    'Since the acquisition of Twitter by Elon Musk, the environment for third-party applications has deteriorated rapidly and extremely.' => 'Depuis le rachat de Twitter par Elon Musk, l’environnement des applications tierces s’est rapidement et extrêmement dégradé.',
    'Slack' => 'Slack',
    'Slack Integration' => 'Intégration Slack',
    'Source: {source}' => 'Source: {source}',
    'Source Code' => 'Code Source',
    'Sp' => 'Sp',
    'Special' => 'Arme spéciale',
    'Special %' => '% Spécial',
    'Special (Icon)' => 'Spécial (icône)',
    'Special:' => 'Spécial :',
    'Special Battle' => 'Match Spécial',
    'Special Battle (Fest)' => 'Match Spécial (Fest)',
    'Special Charged' => 'Spécial Chargé',
    'Specials' => 'Spéciaux',
    'Specials/min' => 'Spéciaux/min',
    'Special Uses' => 'Utilisation du spécial',
    'Species' => 'Espèces',
    'Specify Period' => 'Spécifiez la Rotation',
    'Splatfest' => 'Splatfest',
    'Splatfest Power' => 'Power du Splatfest',
    'Splatfest Power (Normal)' => 'Power du Splatfest (Normal)',
    'Splatfest Power (Pro)' => 'Power du Splatfest(Pro)',
    'Splatfest Region:' => 'Splatfest Region:',
    'Splatfest Stats' => 'Splatfest Stats',
    'Splatfest Title' => 'Titre Splatfest',
    'Splatfest Title (After)' => 'Titre Splatfest (après)',
    'SplatNet' => 'SplatNet',
    'SplatNet #' => 'SplatNet #',
    'SplatNet 2' => 'SplatNet 2',
    'SplatNet Battle #' => 'Match SplatNet #',
    'Splatoon' => 'Splatoon',
    'Splatoon 2' => 'Splatoon 2',
    'Splatoon 3' => 'Splatoon 3',
    'Splatoon Official Website (Japan)' => 'Site Web de Splatoon Officiel (Japon)',
    'Splatoon Official Website (UK)' => 'Site Web de Splatoon Officiel (UK)',
    'Splatoon Official Website (US/Canada)' => 'Site Web de Splatoon Officiel (US/Canada)',
    'Stack' => 'Empiler',
    'Stacked' => 'Empilé',
    'Stage' => 'Stage',
    'Stage (Short)' => 'Stage (court)',
    'Stages' => 'Stages',
    'Standard Deviation' => 'Déviation Standard',
    'Stats' => 'Stats',
    'Stats (by Mode)' => 'Stats (par mode)',
    'Stats (by Mode and Stage)' => 'Stats (par mode et stage)',
    'Stats (by Stage)' => 'Stats (par stage)',
    'Stats (by Weapon)' => 'Stats (par arme)',
    'Stats (Cause of Death)' => 'Stats (par morts)',
    'Stats (Medals)' => 'Stats (Médailles)',
    'Stats (Ranked Battle)' => 'Stats (Match Anarchy)',
    'Stats (Splatfest)' => 'Stats (Splatfest)',
    'Stats (Turf War)' => 'Stats (Guerre de Territoire)',
    'Stats (vs. Weapon)' => 'Stats (contre. Arme)',
    'Stats (Win %)' => 'Stats',
    'Stats (X Power)' => 'Stats (X Power)',
    'Stats ({rule})' => 'Stats ({rule})',
    'Stats: FestPwr diff vs Win %' => 'Stats : FestPwr diff vs % Victoire',
    'Stats: Stages' => 'Stats : Stages',
    'Stats: User Activity' => 'Stats : Activité',
    'Std Dev' => 'Écart type',
    'Stealth Jump Equipment Rate' => 'Taux d\'équipement du bonus Réception Réussie',
    'streak' => 'série',
    'Sub:' => 'Sec :',
    'Subs' => 'Secondaires',
    'Sub Weapon' => 'Arme secondaire',
    'Sub Weapon (Icon)' => 'Arme secondaire (icône)',
    'Summarize' => 'Résumer',
    'Summary: Based on the current filter' => 'Résumé : Basé sur le filtre actuel',
    'Synergy Bonus' => 'Bonus de synergie',
    'Systematic error of win %' => 'Erreur systématique du % victoire',
    'Tablet' => 'Tablette',
    'Target Player\'s Team' => 'Viser l\'équipe du joueur',
    'Team' => 'Équipe',
    'Team Icon' => 'Icône de l\'équipe',
    'Team ID' => 'Identifiant de l\'équipe',
    'Team Inked' => 'Encrage de l\'équipe',
    'Team {theme}' => 'Équipe {theme}',
    'Test' => 'Test',
    'Thanks to {user} for their contribution.' => 'Merci à {user} pour sa participation',
    'The abilities valid only for the primary means the rate of mounting.' => '',
    'The correction value specified by the user is applied.' => '',
    'The data contains a large error margins.' => 'Les données contiennent de grandes marges d\'erreur.',
    'The data is intended to be analyzed using spreadsheet software (Excel, etc.) or programs to analyze.' => 'Les données sont destinées à être analysées à l\'aide de logiciels tableurs (Excel, etc.) ou de programmes à analyser.',
    'The data is not something you will know immediately after downloading.' => 'Les données ne sont pas quelque chose que vous connaîtrez immédiatement après le téléchargement.',
    'The estimated distribution of the overall game, as estimated from the official results.' => 'La répartition estimée de l\'ensemble du jeu, est estimée à partir des résultats officiels.',
    'The estimated location may be inaccurate.' => 'La localisation peut-être imprécise.',
    'The filter specifying XP and version, aggregates data for the overall <code>x.y</code>, ignoring the <code>z</code> in version <code>x.y.z</code>.' => '',
    'The future of Twitter integration is completely uncertain, and as a {site} developer I can\'t recommend this feature at this time.' => 'L\'avenir de l\'intégration de Twitter est totalement incertain et, en tant que développeur de {site}, je ne peux pas recommander cette fonctionnalité pour le moment.',
    'The icon will be:' => 'L\'icône sera :',
    'Their team\'s league power' => 'Ligue Power de leur équipe',
    'Their team\'s splatfest power' => 'Splatfest Power de leur équipe',
    'Their Team Count' => 'Progression de leur équipe',
    'Their Team Score' => 'Score de leur équipe',
    'Their Team Splatfest Power' => 'Splatfest Power de leur équipe',
    'Themes from {name}' => 'Thèmes de {name}',
    'The old name will be available immediately for reuse.' => '',
    'The password will be encrypted.' => 'Le mot de passe sera chiffré.',
    'The post will be in the language set here.' => 'Le post sera mis dans la langue mise ici.',
    'There are no data.' => 'Il n\'y a pas de données',
    'There is no user associated with the specified twitter account.' => 'Il n\'y a pas de joueur associé à ce compte Twitter',
    'These battles were recorded with an outdated version of IkaLog. Please upgrade to the latest version.' => 'Ces matchs ont été enregistrés avec une version obsolète d\'IkaLog. Veuillez mettre l\'application à jour.',
    'The width of the histogram bins is automatically adjusted by Scott\'s rule-based algorithm.' => 'La largeur des cases de l\'histogramme est automatiquement ajustée par l\'algorithme basé sur des règles de Scott.',
    'This battle was recorded with an outdated version of IkaLog. Please upgrade to the latest version.' => 'Ce match a été enregistré avec une version obsolète d\'IkaLog. Veuillez mettre l\'application à jour.',
    'This chart assumes simple normal distribution of the Power to make it easier to compare each mode.' => 'Ce graphique suppose une distribution normale simple du Power pour faciliter la comparaison de chaque mode.',
    'This data is based on {siteName} users and differs significantly from overall game statistics.' => 'Ces données viennent de la base d\'utilisateurs de {siteName} et ne correspondent pas aux statistiques globales du jeu.',
    'This data is basically not informative.' => 'Ces données ne sont pas informatives',
    'This data was totaled after normalization to 5 minute intervals for each battle.' => 'Ces données ont été totalisées après une normalisation de chaque match à 5 minutes d\'intervalle chacun.',
    'This document is under a <a href="http://creativecommons.org/licenses/by/4.0/deed.en">Creative Commons Attribution 4.0 International License</a>.' => 'Ce document est sous la licence <a href="http://creativecommons.org/licenses/by/4.0/deed.fr">CC By 4.0</a>.',
    'This feature is disabled by default.' => 'Cette fonctionnalité est désactivée par défaut.',
    'This information will be public. Integration for "log in with twitter" can be done from the profile page.' => 'Cette information sera publique. L\'intégration pour "Se connecter avec Twitter" peut être fait via le profil.',
    'This is a Discord-specific behavior.' => 'Il s\'agit d\'un comportement spécifique à Discord.',
    'This is a wild guess based on past results and {siteName} posts.' => 'Il s\'agit d\'une supposition farfelue basée sur les résultats passés et les publications de {siteName}.',
    'This Month (UTC)' => 'Ce Mois (UTC)',
    'This option is provided for deleting an incorrectly-reported battle.' => 'Cette option est fournie pour supprimer un match mal envoyé.',
    'This should be a random string of at least {n} characters and should not be the same as any other site' => 'Il doit s\'agir d\'une chaîne de caractère aléatoire d\'au moins {n} caractères et ne doit pas être identique à n\'importe quel autre site.',
    'This twitter account has already been integrated with another user.' => 'Ce compte Twitter a déjà été attaché a un autre joueur.',
    'This website doesn\'t support Internet Explorer. Please use a modern browser, for example Chrome or Firefox.' => 'Ce site ne prend pas en charge Internet Explorer. Veuillez utiliser un navigateur plus moderne, Firefox ou Chrome par exemple.',
    'This website has color-blind support. Please check "Color-Blind Support" in the "Username/Guest" menu of the navbar to enable it.' => 'Ce site prend en charge le daltonisme. Pour activer l\'option veuillez sélectionner : "Mode daltoniens" dans la barre de navigation (Sous Invité/Pseudo).',
    'This website is an open source project. It is under the MIT License. The source code is available on GitHub.' => 'Ce site est un projet Open Source. Il est sous la licence MIT. Le code source est disponible sur Github.',
    'This website is an UNOFFICIAL SERVICE. It is not related to the Splatoon development team or Nintendo.' => 'Ce site N\'EST PAS lié à Nintendo ou à l\'équipe de développement de Splatoon. C\'est un projet Non Officiel',
    'This will be made public as part of URL' => 'Ceci sera rendu public dans le cadre de l\'URL',
    'This {attribute} is already in use.' => 'Cet {attribute} est déjà en cours d\'utilisation.',
    'Time' => 'Temps',
    'Time is up' => 'Temps écoulé',
    'Times' => 'Temps',
    'Time was up' => 'Le temps a écoulé',
    'Time Zone' => 'Fuseau horaire',
    'Title' => 'Titre',
    'Title (After)' => 'Titre (après)',
    'To change your password using this feature, contact the administrator first.' => 'Pour modifier votre mot de passe à l\'aide de cette fonctionnalité, contactez d\'abord l\'administrateur.',
    'Today' => 'Aujourd\'hui',
    'Top {percentile}%' => 'Top {percentile}%',
    'Total' => 'Total',
    'Total Clout' => 'Total de contribution',
    'Total Clout (After the battle)' => 'Total de contribution (Après le match)',
    'Total Inked' => 'Encrage total',
    'To use Discord integration, make a webhook on your Discord server first.' => 'Pour utiliser l\'intégration Discord, créez d\'abord un webhook sur votre serveur Discord',
    'To use Slack integration, you need to configure Slack\'s "Incoming Webhook" first.' => 'Pour utiliser l\'intégration Slack, vous avez besoin de configurer le "Webhook d\'entrée" avant.',
    'Trends' => 'Tendances',
    'Try to secure the Ultra Signal' => 'Tentatives d\'activation de la Tridenfusée',
    'Turf Inked' => 'Surface encrée',
    'Turf inked (including bonus)' => 'Surface encrée (y compris bonus)',
    'Turf Inked + Bonus' => 'Surface encrée + bonus',
    'TV' => 'TV',
    'Twitter @name' => 'Twitter @nom',
    'TZ' => 'TZ',
    'Ultra Signals' => 'Tridenfusée',
    'Uniform' => 'Uniforme',
    'Unknown' => 'Inconnu',
    'Unknown Result' => 'Résultat inconnu',
    'Unlink account' => 'Délier le compte',
    'Update' => 'Modifier',
    'Update Your Email Address' => 'Modifier votre adresse email',
    'Update Your Icon' => 'Modifier votre icône',
    'Update Your Password' => 'Modifier votre mot de passe',
    'Update Your Profile' => 'Modifier votre profil',
    'Update Your Screen Name' => '',
    'Upload icon' => 'Uploader icône',
    'Upload new image' => 'Uploader une nouvelle image',
    'URL related to this battle' => 'URL lié à ce match',
    'Use %' => '% d\'utilisation',
    'Use % and Win %' => '% d\'utilisation et % Victoire',
    'Used in global stats' => 'Utilisé dans les stats globales',
    'Use full width of the screen' => 'Utiliser toute la largeur de l\'écran',
    'Use profile icon of your twitter account' => 'Utiliser la photo de profil Twitter',
    'User Agents in last 24 hours' => 'User Agents des 24 dernières heures',
    'User Count' => 'Compte Utilisateur',
    'User Name' => 'Nom d\'utilisateur',
    'Users' => 'Utilisateurs',
    'Use your profile icon' => 'Utiliser votre photo de profil',
    'Verification Code' => 'Code de vérification',
    'Verify' => 'Vérifier',
    'Version' => 'Version',
    'Version {0}' => 'Version {0}',
    'Victory' => 'Victoire',
    'Victory or Defeat' => 'Victoire ou défaite',
    'View Settings' => 'Voir les paramètres',
    'Vote %' => 'Vote %',
    'We\'ll send an email when you log in to the website or change your password.' => 'Nous allons envoyer un email quand vous vous connecterez ou que vous changerez votre mot de passe.',
    'Weapon' => 'Arme',
    'Weapon (Icon)' => 'Arme (icône)',
    'Weapon (Short)' => 'Arme (court)',
    'Weapon icons were created by {0}.' => 'Les images d\'armes ont été créées par {0}.',
    'Weapons' => 'Armes',
    'Weapon Stats' => 'Stats de l\'arme',
    'Weapon Trends' => 'Tendances d\'armes',
    'Weapon | {weapon}' => 'Arme | {weapon}',
    'Weapon | {weapon} | {rule}' => 'Arme | {weapon} | {rule}',
    'Webhook URL' => 'URL du webhook',
    'Win' => 'Victoire',
    'Win %' => '% Victoire',
    'Win % (Total)' => '% Victoire (Total)',
    'Win % ({0} Battles)' => '% Victoire ({0} matchs)',
    'Winning Percentage' => 'Pourcentage de Victoires',
    'Winning Percentage based on K/D' => 'Pourcentage de Victoires basé sur le K/D',
    'Wins' => 'Victoires',
    'Win streak (Bad guys)' => 'Suite de Victoires (Adversaires)',
    'Win streak (Good guys)' => 'Suite de Victoires (Ton équipe)',
    'Win Streak: {count}' => 'Suite de Victoires : {count}',
    'Won' => 'Victoire',
    'won' => 'victoire',
    'Won / Lost' => 'Victoire / Échec',
    'X Power' => 'X Power',
    'X Power (after)' => 'X Power (après)',
    'Yes' => 'Oui',
    'Yesterday' => 'Hier',
    'You' => 'Toi',
    'You can\'t use an IDN (Internationalized Domain Names) email address' => 'Vous ne pouvez pas utiliser une adresse email IDN (Nom de domaine internationalisé)',
    'You can delete this battle.' => 'Vous pouvez supprimer ce match.',
    'You cannot use the same {attribute} as your current one.' => '',
    'You can register (estimated) unsent values here to correct the values displayed.' => 'Vous pouvez enregistrer ici les valeurs (estimées) non envoyées pour corriger les valeurs affichées.',
    'You can specify Discord\'s Slack compatible endpoint URL as well.' => 'Vous pouvez aussi spécifier l\'endpoint URL Slack compatible avec Discord.',
    'You must agree to the above to delete this battle.' => 'Vous devez accepter ci-dessus pour pouvoir supprimer ce match.',
    'Your Battles' => 'Vos matchs',
    'Your browser does not support this action.' => 'Votre navigateur ne prend pas en charge cette action',
    'Your current icon:' => 'Votre icône actuelle :',
    'Your current image will be deleted and reset to auto-generated image.' => 'Votre image actuelle sera supprimée et remplacée par une image générée automatiquement',
    'Your data will no longer appear in the public list on the top page.' => 'Vos données n\'apparaîtront plus dans la liste publique sur la première page.',
    'Your page will still be public, but it will be harder to access.' => 'Votre page sera toujours publique, mais elle sera plus difficile d\'accès.',
    'Your password has been changed successfully.' => 'Votre mot de passe à bien été changé',
    'Your profile icon has been updated.' => 'Votre photo de profil a été modifiée',
    '[Outdated]' => '[Obsolète]',
    '{0} etc.' => '{0} etc.',
    '{0}×{1} or less resolution' => '{0}×{1} ou moins de résolution',
    '{attribute} must be at most 15 alphanumeric or underscore characters.' => '{attribute}',
    '{decimal5_7} Format' => 'Format {decimal5_7}',
    '{from} - {to}' => '{from} - {to}',
    '{lower}-{upper} percentile' => '{lower}-{upper} centile',
    '{n,plural,=1{battle} other{battles}}' => '{n,plural,=1{match} other{matchs}}',
    '{name}\'s Badge Progress' => 'Progression de badge de {name}',
    '{name}\'s Battle' => 'Match de {name}',
    '{name}\'s Battle Report' => 'Rapport de matchs de {name}',
    '{name}\'s Battles' => 'Matchs de {name}',
    '{name}\'s Battle Stats (by Mode)' => 'Stats de matchs de {name} (Par mode)',
    '{name}\'s Battle Stats (by Mode and Stage)' => 'Stats de matchs de {name} (Par mode et stages)',
    '{name}\'s Battle Stats (by Stage)' => 'Stats de matchs de {name} (Par stages)',
    '{name}\'s Battle Stats (by Weapon)' => 'Stats de matchs de {name} (Par armes)',
    '{name}\'s Battle Stats (Cause of Death)' => 'Stats de matchs de {name} (Morts)',
    '{name}\'s Battle Stats (Medals)' => 'Stats de match de {name} (Médailles)',
    '{name}\'s Battle Stats (Ranked Battle)' => 'Stats de matchs de {name} (Match pro)',
    '{name}\'s Battle Stats (Splatfest)' => 'Stats de matchs de {name} (Splatfest)',
    '{name}\'s Battle Stats (Turf War)' => 'Stats de matchs de {name} (Guerre de territoire)',
    '{name}\'s Battle Stats (vs. Weapon)' => 'Stats de matchs de {name} (vs. Arme)',
    '{name}\'s Battle Stats (Winning Rate)' => 'Stats de matchs de {name} (par taux de victoires)',
    '{name}\'s Battle Stats ({rule})' => 'Stats de matchs de {name} ({rule})',
    '{name}\'s Favorite Weapon' => 'Arme préférée de {name}',
    '{name}\'s Monthly Report - {date}' => 'Rapport mensuel de {name} - {date}',
    '{name}\'s Splat Log' => 'Splat Log de {name}',
    '{name}\'s X Power' => 'X power de {name}',
    '{nFormatted} remaining' => '{nFormatted} restant',
    '{nFormatted} {n, plural, =1{battle} other{battles}}' => '{nFormatted} {n, plural, =1{match} other{matchs}}',
    '{nFormatted} {n, plural, =1{time} other{times}}' => '{nFormatted} temps',
    '{number, plural, =1{1 death} other{# deaths}} in {battle, plural, =1{1 battle} other{# battles}}' => '{number, plural, =1{1 mort} other{# morts}} dans {battle, plural, =1{1 match} other{# matchs}}',
    '{number, plural, =1{1 egg} other{# eggs}} in {battle, plural, =1{1 shift} other{# shifts}}' => '{number, plural, =1{1 oeuf} other{# oeufs}} dans {battle, plural, =1{1 job} other{# jobs}}',
    '{number, plural, =1{1 kill} other{# kills}}' => '{number, plural, =1{1 kill} other{# kills}}',
    '{number, plural, =1{1 kill} other{# kills}} in {battle, plural, =1{1 battle} other{# battles}}' => '{number, plural, =1{1 kill} other{# kills}} dans {battle, plural, =1{1 match} other{# matchs}}',
    '{number, plural, =1{1 time} other{# times}} in {battle, plural, =1{1 shift} other{# shifts}}' => '{number, plural, =1{1 fois} other{# fois}} dans {battle, plural, =1{1 job} other{# jobs}}',
    '{package} is used for icons and other images.' => '{package} est utilisé pour les icônes et les autres images',
    '{pct_point} percentage point' => '{pct_point} pourcentage',
    '{pct}% CI' => '{pct}% CI',
    '{pct} % loss' => '{pct} % défaite',
    '{pct}% Significant?' => '{pct}% signifiant',
    '{pct} ({dupf} DU/F)' => '{pct} ({dupf}DU/F) ',
    '{percentile} Percentile' => '{percentile} Centile',
    '{point, plural, =1{1 point} other{# points}} in {battle, plural, =1{1 battle} other{# battles}}' => '{point, plural, =1{1 point} other{# points}} dans {battle, plural, =1{1 match} other{# matchs}}',
    '{point, plural, other{#p}}' => '{point, plural, other{#p}}',
    '{point}p' => '{point} p.',
    '{rule}: Current' => '{rule} : Actuel',
    '{rule}: Peak' => '{rule} : Max',
    '{sec,plural,=1{# second} other{# seconds}}' => '{sec,plural,=1{# seconde} other{# secondes}}',
    '{sec} seconds' => '{sec} secondes',
    '{sec} seconds ({pct} %)' => '{sec} secondes ({pct} %)',
    '{sec} seconds, {cnt} times' => '{sec} secondes, {cnt} fois',
    '{siteName} Discord Community' => '{siteName} Discord Community',
    '{theme} Theme' => 'Thème {theme}',
    '{title} Official Website' => 'Site Officiel de {title}',
    '~{estPower}' => '~{estPower}',
    '~{point}p' => '~{point}p',
    '×{times}' => '×{times}',
];
