<?php

/**
 * @copyright Copyright (C) 2015-2021 AIZAWA Hina
 * @license https://github.com/fetus-hina/stat.ink/blob/master/LICENSE MIT
 * @author AIZAWA Hina <hina@fetus.jp>
 */

declare(strict_types=1);

return [
    '(combined)' => '(вместе)',
    '(default)' => '(по умолчанию)',
    '(For only Splatoon 1 at this time)' => '(На данный момент только для Splatoon 1).',
    '(incomplete)' => '(неполный)',
    '(unknown result)' => '(неизвестный результат)',
    '* This exclusion is an attempt to minimize overcounting in weapon usage statistics.' => '* Это исключение является попыткой минимизировать перерасход в статистике использования оружия.',
    '3+9 Format' => 'формат 3+9',
    '3, 9 Format' => '3, 9 Формат',
    '10x Battle' => '10х Битва',
    '24H Win %' => '24H Выигрыш %',
    '57 Format' => '57 Формат',
    '100x Battle' => '100-кратная битва',
    '<div class="input-group"><span class="input-group-addon">From:</span>{input}</div>' => '<div class="input-group"><span class="input-group-addon">От:</span> {input} </div>',
    '<div class="input-group"><span class="input-group-addon">To:</span>{input}</div>' => '<div class="input-group"><span class="input-group-addon">To:</span> {input} </div>',
    'Ability Effect' => 'Эффект способности',
    'About support for color-blindness' => 'О поддержке дальтонизма',
    'Active Players' => 'Активные игроки',
    'Activity' => 'Деятельность',
    'Add' => 'Добавить',
    'Add Slack Integration' => 'Добавить слабую интеграцию',
    'All Players' => 'Все игроки',
    'Always enable horizontal scroll' => 'Всегда включайте горизонтальную прокрутку',
    'Anonymize, don\'t link from other user\'s results' => 'Анонимизировать, не ссылаться на результаты других пользователей',
    'Anonymized' => 'Анонимизированный',
    'Another account' => 'Другой аккаунт',
    'Any Time' => 'В любое время',
    'API Info: Gears: {0}' => 'Информация API: Шестерни: {0}',
    'API Info: Stages (Splatoon 2)' => 'Информация API: Этапы (Splatoon 2)',
    'API Info: Weapons' => 'API Информация: Оружие',
    'API Info: Weapons (Splatoon 2)' => 'Информация API: Оружие (Сплатун 2)',
    'API Token' => 'API-жетон',
    'Apply' => 'Подать заявку на сайте .',
    'Apps for {version}' => 'Заявки на {version}',
    'Area' => 'Область',
    'Are you sure you want to regenerate your API token?' => 'Вы уверены, что хотите восстановить Ваш API токен?',
    'Assist' => 'Помогите .',
    'Assists' => 'Помогает',
    'Auto (cookie)' => 'Автоматический (cookie)',
    'Auto (Identicon)' => 'Авто (Идентикон)',
    'Automated' => 'Автоматизированный',
    'Average' => 'Средний',
    'Average:' => 'Средний:',
    'Avg.' => 'Авг.',
    'Avg. game in {time}' => 'Avg. игра в {time}',
    'Avg. K.O. in {time}' => 'Авг. К.О. в {time}',
    'Avg Assists' => 'Авг помогает',
    'Avg Deaths' => 'Авг Смерть',
    'Avg Inked' => 'Авг-инкинг',
    'Avg Kills' => 'Авг Убивает',
    'Avg KR' => 'Авг-КР',
    'Avg Specials' => 'Авг Скидки',
    'Back' => 'Назад',
    'Bad Guys' => 'плохие парни',
    'Bad guys are in control' => 'Плохие парни контролируют',
    'Bad guys winning' => 'Плохие парни выигрывают',
    'Based on deaths' => 'Основываясь на количестве смертей',
    'Based on kills' => 'Основываясь на убийствах',
    'Battle Count' => 'Граф Боев',
    'Battle End' => 'Боевой конец',
    'Battles' => 'Бои',
    'Battles:' => 'Бои:',
    'Battles:{0} / Win %:{1} / Avg Kills:{2} / Avg Deaths:{3} / Kill Ratio:{4}' => 'Бои: {0} / Выиграть %: {1} / Avg Kills: {2} / Avg Deaths: {3} / Kill Ratio: {4}',
    'Battles and Users' => 'Бои и пользователи',
    'Battle Start' => 'Начало боя',
    'between {down} and {up} {name}' => 'между {down} и {up} {name}',
    'Black out' => 'Потерять сознание',
    'Black out except private battle' => 'Отрубитесь, кроме частной битвы',
    'Black out except private battle and teammate on league battle (4 players)' => 'Отключение от сети, кроме личного боя и товарища по команде в лиге (4 игрока).',
    'Black out except private battle and teammate on squad battle (tri or quad)' => 'Потерял сознание, за исключением личного боя и товарища по команде в бою с командой (три или четыре).',
    'Black out other players' => 'Отключите других игроков',
    'Black out other players (details)' => 'Отключите других игроков (подробности)',
    'Black out other players (images)' => 'Отключите другие игроки (изображения)',
    'Black out other players from the details list' => 'Вычеркнуть других игроков из списка деталей',
    'Black out other players from the result image' => 'Вычеркнуть других игроков из картинки результата',
    'Blog' => 'Блог',
    'Boy' => 'Мальчик',
    'Brand' => 'Бренд',
    'Calendar' => 'Календарь',
    'Capture Environment' => 'Среда захвата',
    'Cash' => 'Наличными',
    'Category' => 'Категория',
    'Cause of Death' => 'Причина смерти',
    'Change Icon' => 'Значок смены',
    'Change Password' => 'Изменить пароль',
    'Channel' => 'Канал',
    'Click to copy' => 'Нажмите, чтобы скопировать',
    'Close' => 'Закрыть',
    'Clout' => 'Клаут',
    'Clout (Normal)' => 'Клаут (нормальный)',
    'Clout (Pro)' => 'Клаут (Про)',
    'Color-Blind Support' => 'Поддержка цветных полосок',
    'Color Scheme' => 'Цветовая схема',
    'combos' => 'комбо',
    'Compare Number Of Uses' => 'Сравнить количество использования',
    'Compare number of uses' => 'Сравнить количество применений',
    'Connectivity' => 'Связь',
    'Continue' => 'Продолжить работу по адресу .',
    'Copied!' => 'Принято!',
    'Correlation Coefficient' => 'Коэффициент корреляции',
    'Could not be updated.' => 'Не может быть обновлена.',
    'Could not find specified battle.' => 'Не смог найти указанную битву.',
    'Could not get your twitter icon at this time.' => 'В данный момент Вы не можете получить иконку в твиттере.',
    'Could not update your icon. Please try again.' => 'Не удалось обновить иконку, попробуйте еще раз.',
    'Count (Bad Guys)' => 'Граф (Плохие парни)',
    'Count (Good Guys)' => 'Граф (Хорошие парни)',
    'CSV (IkaLog compat.)' => 'CSV (IkaLog compat).',
    'CSV format' => 'формат CSV',
    'Current' => 'Текущий',
    'Current/Last Splatfest' => 'Текущий/последний праздник',
    'Current Password' => 'Текущий пароль',
    'Current Period' => 'текущий период',
    'Current Stages' => 'Текущие этапы',
    'Current Time:' => 'Текущее время:',
    'd' => 'd',
    'D/min' => 'Д/мин',
    'Daily Report' => 'Ежедневный отчёт',
    'Data Sent' => 'Отправленные данные',
    'Date Time' => 'Дата Время',
    'Dead' => 'Мертвый',
    'Deaths' => 'Смерть',
    'Deaths (average):' => 'Смертность (средняя):',
    'Deaths (median):' => 'Смерть (медиана):',
    'Deaths/min' => 'Смерть/мин',
    'Deaths Per Battle' => 'Смерть в битве',
    'Deaths per minute' => 'Смертность в минуту',
    'Default Color' => 'Цвет по умолчанию',
    'Delete' => 'Удалить',
    'Detail' => 'Подробности',
    'Detailed List' => 'Подробный список',
    'Details' => 'Подробности',
    'Deviation' => 'Отклонение',
    'Disabled' => 'Инвалид',
    'Don\'t anonymize, display in-game name' => 'Не анонимизируйте, отображайте внутриигровое имя',
    'Don\'t anonymize, display stat.ink\'s name' => 'Не анонимизируйте, отображайте имя stat.ink',
    'Don\'t group' => 'Не группируйтесь',
    'Do not close this window.' => 'Не закрывайте это окно.',
    'Downloads' => 'Загрузки',
    'Download Stats' => 'Скачать статистику',
    'e.g. YouTube video, like "{0}"' => 'например, видео на YouTube, как " {0} ".',
    'Earlier Turf-Inked data is currently wrong. It will be fixed in the near future.' => 'Ранние данные Turf-Inked в настоящее время ошибочны и будут исправлены в ближайшем будущем.',
    'Edit' => 'Редактирование',
    'Edit Your Battle: #{0}' => 'Edit Your Battle: # {0}',
    'Effects' => 'Эффекты',
    'Elapsed' => 'Прошло',
    'Elapsed Time' => 'Истекшее время',
    'Elapsed Time (seconds)' => 'Истекшее время (секунды)',
    'Email' => 'Электронный адрес',
    'Enabled' => 'Включен',
    'Enable machine-translation' => 'Включить машинный перевод',
    'Enable noise reduction (count)' => 'Включить шумоподавление (счет)',
    'Enable noise reduction (position of the objective)' => 'Включите шумоподавление (положение объекта).',
    'Encounter Ratio' => 'Коэффициент встречи',
    'Enemy Weapon' => 'Вражеское оружие',
    'Error' => 'Ошибка',
    'Estimated X Power' => 'Расчетная мощность X',
    'Europe' => 'Европа',
    'Europe/Oceania' => 'Европа/Океания',
    'Excluded: Private Battles' => 'Исключены: Частные бои',
    'Excluded: Private Battles and Squad Battles (when Rank S or S+)' => 'Исключены: частные бои и отрядные сражения (при ранге S или S+).',
    'Excluded: The uploader, All players (Private Battle), Uploader\'s teammates (Squad Battle or Splatfest Battle)' => 'Исключены: Загрузчик, Все игроки (Приватный бой), товарищи по команде Загрузчика (Бой в отряде или Бой на плацдарме)',
    'Export' => 'Экспорт',
    'Extra Data' => 'Дополнительные данные',
    'Favorite Weapon' => 'Любимое оружие',
    'Favorite Weapons' => 'Любимое оружие',
    'Favorite Weapons of This Site Member' => 'Любимое оружие Члена этого сайта',
    'Feedback or suggestions are welcome. Please contact me via GitHub or Twitter.' => 'Приветствуются отзывы и предложения, пожалуйста, свяжитесь со мной через GitHub или Twitter.',
    'fest.ink' => 'праздничные чернила',
    'Fest Power' => 'Фест Могущество',
    'Fest Power (Normal)' => 'Фест-мощность (нормальная)',
    'Fest Power (Pro)' => 'Fest Power (Pro)',
    'Few' => 'Мало',
    'Filter' => 'Фильтр',
    'Filter Query' => 'Запрос фильтра',
    'Final Count' => 'Окончательный подсчёт',
    'for {title}' => 'для {title}',
    'Freshness' => 'Свежесть',
    'Friend Code' => 'Кодекс друга',
    'Friend Code (Switch)' => 'Дружеский код (переключатель)',
    'Game Mode' => 'Игровой режим',
    'Game Version' => 'Версия игры',
    'Gear' => 'Gear',
    'GeoIP guessed {timezone}' => 'GeoIP угадал {timezone}',
    'Getting Started' => 'Начало работы',
    'Girl' => 'Девушка',
    'GNU Social, Mastodon etc.' => 'GNU Social, Mastodon и т.д.',
    'Good Guys' => 'Хорошие ребята',
    'Good guys are in control' => 'Хорошие парни контролируют',
    'Good guys winning' => 'Хорошие ребята выигрывают',
    'Group by main weapon' => 'Группировка по основному оружию',
    'Group by reskins' => 'Группировка по группам',
    'Group by weapon type' => 'Группа по типу оружия',
    'Guessed:' => 'Угадал:',
    'Guessed by your IP:' => 'Угадывается по Вашему IP-адресу:',
    'Guess the region' => 'Угадайте регион',
    'Guest' => 'Гость',
    'Has disconnected player' => 'отключённый плеер',
    'Hasn\'t disconnected player' => 'Не отключённый плеер',
    'Hawaii Time' => 'Гавайское время',
    'Highest (current period)' => 'Самый высокий (текущий период)',
    'Highest (this teammates)' => 'Самый высокий (этот товарищ по команде)',
    'History' => 'История',
    'However, statistics information will be opened.' => 'Однако, будет открыта статистическая информация.',
    'I agree. Delete this battle.' => 'Я согласен. Удалить эту битву.',
    'I agree to the terms above.' => 'Я согласен с вышеизложенными условиями.',
    'Icon' => 'иконка',
    'If you already have an account, please click here.' => 'Если у Вас уже есть аккаунт, пожалуйста, нажмите здесь.',
    'If you delete this battle, it will be gone forever.' => 'Если Вы удалите эту битву, она исчезнет навсегда.',
    'If you misuse this feature, you will be banned.' => 'Если Вы злоупотребите этой функцией, Вы будете заблокированы.',
    'Ika-Denwa' => 'Ика-Денва',
    'Ika-Nakama' => 'Ика-Накама',
    'Ika-Nakama 2' => 'Ика-Накама 2',
    'Ika-Nakama 2 User ID' => 'Ика-Накама 2 Идентификатор пользователя',
    'Ika-Nakama User ID' => 'Ика-Накама Идентификатор пользователя',
    'IkaLog' => 'ИкаЛог',
    'IkaLog Download Page' => 'Страница скачивания IkaLog',
    'IkaRec' => 'IkaRec',
    'IkaRec 2' => 'ИкаРек 2',
    'Image Sharing' => 'Обмен изображениями',
    'Incomplete Data' => 'Неполные данные',
    'Inked' => 'Введенный',
    'Inked/min' => 'чернила/мин',
    'Inking Performance' => 'Производительность чернил',
    'Inking Performance vs Win %' => 'Производительность чернил против выигрыша %',
    'Inkling' => 'Инклинг',
    'Input new battle results' => 'Введите новые результаты битвы',
    'In session' => 'Во время сеанса',
    'Integrate' => 'Интегрировать',
    'Internal ID' => 'Внутренний идентификатор',
    'Interval' => 'Интервал',
    'Invalid {0} or {1}.' => 'Недействительный {0} или {1} .',
    'IQR' => 'IQR',
    'Japan' => 'Япония',
    'Japan Time' => 'японское время',
    'Join us' => 'Присоединяйтесь к нам',
    'JSON (IkaLog compat.)' => 'JSON (IkaLog compat).',
    'JSON (stat.ink format, gzipped)' => 'JSON (stat.ink формат, gzipped)',
    'JSON format' => 'JSON формат',
    'Judge' => 'Судья',
    'Just {result} {rule} at {stage}' => 'Просто {result} {rule} по адресу {stage}',
    'k' => 'k',
    'K/min' => 'к/мин',
    'Kill or Assist' => 'Убить или помочь',
    'Kill Rate' => 'Убийственная ставка',
    'Kill Ratio' => 'Соотношение убийств',
    'Kills' => 'Убивает',
    'Kills (average):' => 'Убивает (в среднем):',
    'Kills (median):' => 'Убивает (медиана):',
    'Kills / Deaths' => 'Убийства / Смерть',
    'Kills/min' => 'Убийства/минуты',
    'Kills and Deaths' => 'Убийства и смерть',
    'Kills per minute' => 'Убийства в минуту',
    'KNOCKOUT' => 'KNOCKOUT',
    'Knockout' => 'Нокаут',
    'Knockout Ratio' => 'Нокаут-соотношение',
    'KR' => 'KR',
    'Language' => 'Язык',
    'Language (used for OStatus)' => 'Язык (используется для OStatus)',
    'Last 24 Hours' => 'Последние 24 часа',
    'Last 24h: {winpct} win ({win}/{count}), Avg. {kill}k/{death}d' => 'Последние 24 часа: {winpct} win ( {win} / {count} ), Avg. {kill} k/ {death} d',
    'Last Month (UTC)' => 'Последний месяц (UTC)',
    'Last {n} Battles' => 'Последний {n} Бои',
    'Last {n} Periods' => 'Последний {n} Периоды',
    'Latest' => 'Последний сайт',
    'League Power' => 'власть лиги',
    'Legend' => 'Легенда',
    'Legends' => 'Легенды',
    'less than {min} {name}' => 'не особо {min} {name}',
    'Level' => 'Уровень',
    'Level (After)' => 'Уровень (после)',
    'Link' => 'Ссылка',
    'Link from other user\'s results' => 'Ссылка на результаты других пользователей',
    'Links' => 'Ссылки',
    'List' => 'Список',
    'Loading...' => 'Погрузка...',
    'Lobby' => 'Лобби',
    'Lobby (Icon)' => 'Лобби (иконка)',
    'Location' => 'Местоположение',
    'Login' => 'Вход',
    'Login History' => 'История входа',
    'Login history will be deleted in {term}.' => 'История входа будет удалена в {term} .',
    'Login Method' => 'Способ авторизации',
    'Log in with other services' => 'Вход в систему с другими сервисами',
    'Log in with Twitter' => 'Войти в систему через Twitter',
    'Logout' => 'Выход из системы',
    'Lose' => 'Проиграть',
    'Lost' => 'Потерянный',
    'lost' => 'потерянный',
    'Low ink' => 'Низкие чернила',
    'Main Weapon' => 'Главное оружие',
    'Many' => 'Многие',
    'Masked' => 'Маска',
    'max={max} min={min} average={avg} median={median} mode={mode}' => 'max= {max} min= {min} average= {avg} median= {median} mode= mode= min= average= median= median= mode= mode= {mode}',
    'max={max} min={min} median={median}' => 'max= {max} min= {min} median= {median}',
    'Maximum' => 'Максимум',
    'Max Inked' => 'Макс Чернила',
    'Max Kill Combo' => 'Max Kill Combo',
    'Max Kill Streak' => 'Макс Убийственная полоса',
    'Median' => 'Медиан',
    'Minimum' => 'Минимум',
    'MMMM y' => 'ММММ у',
    'Mobile' => 'Мобильный',
    'Mode' => 'Режим',
    'Mode (Icon)' => 'Режим (иконка)',
    'Mode (Short)' => 'Режим (Короткий)',
    'more...' => 'более...',
    'more than {max} {name}' => 'сверх {max} {name}',
    'Moving Avg. ({0} Battles)' => 'Перемещение Авг. ( {0} Битвы)',
    'My team\'s league power' => 'Сила лиги моей команды',
    'My team\'s splatfest power' => 'Мощь моей команды',
    'My Team Count' => 'Количество моих сотрудников',
    'My Team Score' => 'Мой командный балл',
    'My Team Splatfest Power' => 'Моя команда Splatfest Power',
    'Name' => 'Имя',
    'Name (for display)' => 'Имя (для отображения)',
    'Neutral' => 'Нейтральный',
    'New battle' => 'Новая битва',
    'New Password' => 'Новый пароль',
    'New Password (again)' => 'Новый пароль (снова)',
    'Next' => 'Следующий',
    'Next Battle' => 'Следующая битва',
    'Next Month' => 'Следующий месяц',
    'Next Stages' => 'Следующие этапы',
    'Nintendo Network ID' => 'Nintendo Network ID',
    'Nintendo Switch Online app' => 'Приложение Nintendo Switch Online',
    'No' => 'Нет',
    'No battles' => 'Никаких сражений',
    'No black out' => 'Нет отключения',
    'No Data' => 'Нет Данные',
    'No one in control' => 'Никто не контролирует',
    'North America/Oceania' => 'Северная Америка/Океания',
    'Note' => 'Примечание',
    'Note (private)' => 'Примечание (личное)',
    'Note (public)' => 'Примечание (публичное)',
    'Octoling' => 'Октолинг',
    'Official Twitter' => 'Официальный Твиттер',
    'Open Source Licenses' => 'Лицензии с открытым исходным кодом',
    'Others' => 'Другие',
    'Password' => 'Пароль',
    'Password (again)' => 'Пароль (снова)',
    'PC' => 'ПК',
    'Peak' => 'Пик',
    'Period' => 'Период',
    'Permalink' => 'Пермалинк',
    'Players' => 'Игроки',
    'Players:' => 'Игроки:',
    'Please copy an API key below and paste to IkaLog, IkaRec or other apps that are compatible with {0}.' => 'Пожалуйста, скопируйте API ключ ниже и вставьте в IkaLog, IkaRec или другие приложения, совместимые с {0} .',
    'Please copy this URL:' => 'Пожалуйста, скопируйте этот URL-адрес:',
    'Please do not use this feature to destroy evidence.' => 'Пожалуйста, не используйте эту функцию для уничтожения улик.',
    'Please keep it secret.' => 'Пожалуйста, держите это в секрете.',
    'Please tell us about your capture environment and communication between your Wii U and User Agent (e.g. IkaLog). This information will be public.' => 'Пожалуйста, расскажите нам о Вашей среде съемки и связи между Вашим Wii U и Агентом пользователя (например, IkaLog). Эта информация будет общедоступна.',
    'Please wait.' => 'Пожалуйста, подождите.',
    'PNG/JPEG file up to {0}' => 'PNG/JPEG файл до {0}',
    'Points' => 'Баллы',
    'Position' => 'Позиция',
    'Powered by' => 'Движимый',
    'Power Level' => 'Уровень мощности',
    'Prev.' => 'Прев.',
    'Prev. Battle' => 'Прев. битва',
    'Prev. Month' => 'Прев. месяц',
    'Previous Period' => 'Предыдущий период',
    'Primary Ability' => 'Первичная способность',
    'Privacy Policy' => 'Политика конфиденциальности',
    'Profile and Settings' => 'Профиль и настройки',
    'Q<sub>1/4</sub>' => 'Q1/4',
    'Q<sub>3/4</sub>' => 'Q3/4',
    'Rank' => 'Рейтинг',
    'Rank (After)' => 'Звание (после)',
    'Rank (after the battle)' => 'Звание (после боя)',
    'Rank: Current' => 'Рейтинг: Текущий',
    'Rank: Peak' => 'Звание: Пик',
    'Rank in Team' => 'Звание в команде',
    'Rate' => 'Тариф',
    'Ratio' => 'Соотношение',
    'Recent Battles' => 'Недавние сражения',
    'Recent Results' => 'Последние результаты',
    'Recent Use %' => 'Недавнее использование %',
    'Recommended to Android users:' => 'Рекомендуется пользователям Android:',
    'Regenerate your API token' => 'Регенерировать Ваш API токен',
    'Region (used for Splatfest)' => 'Регион (используется для Splatfest)',
    'Register' => 'Зарегистрироваться',
    'Relative Time' => 'относительное время',
    'Released' => 'Выпущен',
    'Remember me' => 'Помните меня',
    'Remote Follow' => 'Удаленное отслеживание',
    'Reset icon' => 'Значок сброса',
    'Reset to default icon' => 'Сброс к иконке по умолчанию',
    'Reskin of' => 'Сходство с',
    'Result' => 'Результат',
    'Results of {name}\'s Battle' => 'Результаты битвы {name} \'s Battle',
    'Room' => 'Комната',
    'Room info (Private)' => 'Информация о номере (личный)',
    'S/min' => 'в минуту',
    'Salmon Run CSV' => 'ЦСВ лосося',
    'Save!' => 'Спасти!',
    'Schedule' => 'Расписание',
    'Scheduled' => 'Запланировано',
    'Schema information' => 'Информация о схеме',
    'Screen Name' => 'Имя экрана',
    'Screen Name (Login Name)' => 'Имя экрана (Логин)',
    'Search' => 'Поиск',
    'Search {date}' => 'Поиск {date}',
    'Search {from} - {to}' => 'Поиск {from} - {to}',
    'Secondary Abilities' => 'Вторичные способности',
    'Sent an email to your email address. Please check your mailbox and get the verification code.' => 'Отправьте электронное письмо на Ваш электронный адрес. Пожалуйста, проверьте Ваш почтовый ящик и получите проверочный код.',
    'Session History' => 'История сессии',
    'Settings' => 'Настройки',
    'Show All Players' => 'Показать всех игроков',
    'Show moving averages' => 'Показывать скользящие средние',
    'Show your API Token' => 'Показать Ваш жетон API',
    'Simplified List' => 'Упрощенный список',
    'Slack Integration' => 'Слабая интеграция',
    'Source: {source}' => 'Источник: {source}',
    'Source Code' => 'Исходный код',
    'Special' => 'Специальное предложение',
    'Special %' => 'Специальный %',
    'Special (Icon)' => 'Специальный (иконка)',
    'Special:' => 'Специальное предложение:',
    'Special Battle' => 'Особая битва',
    'Special Battle (Fest)' => 'Специальный бой (Фест)',
    'Special Charged' => 'Специально заряженный',
    'Specials' => 'Скидки',
    'Specials/min' => 'Скидки/минуты',
    'Species' => 'Виды',
    'Specify Period' => 'Указать период',
    'Splatfest' => 'Splatfest',
    'Splatfest Power' => 'Splatfest Power',
    'Splatfest Power (Normal)' => 'Splatfest Power (Нормальная)',
    'Splatfest Power (Pro)' => 'Splatfest Power (Pro)',
    'Splatfest Region:' => 'Регион Сплатфеста:',
    'Splatfest Title' => 'Название фестиваля',
    'Splatfest Title (After)' => 'Название (после) Splatfest Title (Splatfest Title)',
    'SplatNet' => 'SplatNet',
    'SplatNet #' => 'SplatNet #',
    'SplatNet 2' => 'SplatNet 2',
    'SplatNet Battle #' => 'Битва SplatNet #',
    'Splatoon Official Website (Japan)' => 'Официальный сайт Splatoon (Япония)',
    'Splatoon Official Website (UK)' => 'Официальный сайт Splatoon (Великобритания)',
    'Splatoon Official Website (US/Canada)' => 'Официальный сайт Splatoon (США/Канада)',
    'Staaaay Fresh!' => 'Staaaay Fresh!',
    'Stack' => 'Стек',
    'Stage' => 'Этап',
    'Stage (Short)' => 'Этап (короткий)',
    'Stages' => 'Этапы',
    'Standard Deviation' => 'Стандартное отклонение',
    'Stats' => 'Статистика',
    'Stats (by Mode)' => 'Статистика (по режимам)',
    'Stats (by Mode and Stage)' => 'Статистика (по режимам и этапам)',
    'Stats (by Stage)' => 'Статистика (по этапам)',
    'Stats (by Weapon)' => 'Статистика (по оружию)',
    'Stats (Cause of Death)' => 'Статистика (Причина смерти)',
    'Stats (Ranked Battle)' => 'Статистика (Рейтинговый бой)',
    'Stats (Splatfest)' => 'Статистика (Splatfest)',
    'Stats (Turf War)' => 'Статистика (Война за дерновины)',
    'Stats (vs. Weapon)' => 'Статистика (против оружия)',
    'Stats ({rule})' => 'Статистика ( {rule} )',
    'Stats: FestPwr diff vs Win %' => 'Статистика: FestPwr diff vs Win %',
    'Stats: K/D vs Win %' => 'Статистика: K/D против Выигрыша %',
    'Stats: Knockout Ratio' => 'Статистика: Соотношение нокаутов',
    'Stats: Stages' => 'Статистика: Этапы',
    'Stats: User Activity' => 'Статистика: Активность пользователя',
    'Stats: Weapons' => 'Статистика: Оружие',
    'Std Dev' => 'стандартное устройство',
    'streak' => 'полоса',
    'Sub:' => 'Sub:',
    'Sub Weapon' => 'Подводное оружие',
    'Sub Weapon (Icon)' => 'Подводное оружие (иконка)',
    'Summarize' => 'Резюме',
    'Summary: Based on the current filter' => 'Резюме: На основе текущего фильтра',
    'Synergy Bonus' => 'Бонус за синергетику',
    'Systematic error of win %' => 'Систематическая ошибка выигрыша %',
    'Tablet' => 'Планшет',
    'Target Player\'s Team' => 'Команда целевого игрока',
    'Team' => 'Команда',
    'Team Icon' => 'Иконка команды',
    'Team ID' => 'Team ID',
    'Team Inked' => 'Команда Inked',
    'Team {theme}' => 'Команда {theme}',
    'Test' => 'Тест',
    'The estimated location may be inaccurate.' => 'Предполагаемое местоположение может быть неточным.',
    'The icon will be:' => 'Иконка будет:',
    'Their team\'s league power' => 'Сила лиги их команды',
    'Their team\'s splatfest power' => 'Сила брызг их команды',
    'Their Team Count' => 'Количество их команд',
    'Their Team Score' => 'Их командный балл',
    'Their Team Splatfest Power' => 'Их Командная сила Splatfest',
    'Themes from {name}' => 'Темы из {name}',
    'The password will be encrypted.' => 'Пароль будет зашифрован.',
    'There are no data.' => 'Нет никаких данных.',
    'There is no user associated with the specified twitter account.' => 'Нет пользователя, связанного с указанным аккаунтом в твиттере.',
    'These battles were recorded with an outdated version of IkaLog. Please upgrade to the latest version.' => 'Эти бои были записаны устаревшей версией IkaLog. Пожалуйста, обновите до последней версии.',
    'This battle was recorded with an outdated version of IkaLog. Please upgrade to the latest version.' => 'Эта битва была записана устаревшей версией IkaLog. Пожалуйста, обновите ее до последней версии.',
    'This data was totaled after normalization to 5 minute intervals for each battle.' => 'Эти данные были суммированы после нормализации до 5-минутных интервалов для каждого боя.',
    'This document is under a <a href="http://creativecommons.org/licenses/by/4.0/deed.en">Creative Commons Attribution 4.0 International License</a>.' => 'Этот документ находится под <a href="http://creativecommons.org/licenses/by/4.0/deed.en">международной лицензией Creative Commons Attribution 4.0</a>.',
    'This information will be public. Integration for "log in with twitter" can be done from the profile page.' => 'Эта информация будет публичной. Интеграция для "входа с твиттером" может быть осуществлена со страницы профиля.',
    'This Month (UTC)' => 'Этот месяц (UTC)',
    'This option is provided for deleting an incorrectly-reported battle.' => 'Эта опция предусмотрена для удаления ошибочно сообщенной битвы.',
    'This twitter account has already been integrated with another user.' => 'Этот аккаунт Twitter уже интегрирован с другим пользователем.',
    'This website doesn\'t support Internet Explorer. Please use a modern browser, for example Chrome or Firefox.' => 'Этот сайт не поддерживает Internet Explorer, пожалуйста, используйте современный браузер, например Chrome или Firefox.',
    'This website has color-blind support. Please check "Color-Blind Support" in the "Username/Guest" menu of the navbar to enable it.' => 'Этот сайт имеет поддержку цветного слепого цвета. Пожалуйста, проверьте "Поддержка цветного слепого цвета" в меню "Имя пользователя/Гость" на навигационной панели, чтобы включить ее.',
    'This website is an open source project. It is under the MIT License. The source code is available on GitHub.' => 'Этот сайт является проектом с открытым исходным кодом и находится под лицензией MIT. Исходный код доступен на GitHub.',
    'This website is an UNOFFICIAL SERVICE. It is not related to the Splatoon development team or Nintendo.' => 'Данный веб-сайт является ЮНОФИЦИАЛЬНЫМ СЕРВИСОМ и не имеет отношения к команде разработчиков Splatoon или Nintendo.',
    'This {attribute} is already in use.' => 'Этот {attribute} уже используется.',
    'Time' => 'Время',
    'Time is up' => 'Время вышло.',
    'Times' => 'Таймс',
    'Time was up' => 'Время вышло.',
    'Time Zone' => 'Часовой пояс',
    'Title' => 'Название',
    'Title (After)' => 'Название (после)',
    'Today' => 'Сегодня',
    'Total' => 'Всего',
    'Total Clout' => 'Общее влияние',
    'Total Clout (After the battle)' => 'Тотальное Клаутирование (после битвы)',
    'Total Inked' => 'Всего введено',
    'Trends' => 'Тенденции',
    'Turf Inked' => 'Чернила для газона',
    'Turf inked (including bonus)' => 'Чернила для газона (включая бонус)',
    'Turf Inked + Bonus' => 'Чернила для газона + бонус',
    'TV' => 'TV',
    'Twitter @name' => 'Твиттер @ имя',
    'TZ' => 'TZ',
    'Unknown' => 'Неизвестный',
    'Unlink account' => 'Нелинковый счёт',
    'Update' => 'Обновление',
    'Update Your Email Address' => 'Обновление адреса электронной почты',
    'Update Your Icon' => 'Обновите Вашу иконку',
    'Update Your Password' => 'Обновите Ваш пароль',
    'Update Your Profile' => 'Обновить Ваш профиль',
    'Upload icon' => 'Значок загрузки',
    'Upload new image' => 'Загрузить новое изображение',
    'URL related to this battle' => 'URL-адрес, связанный с этой битвой',
    'Use %' => 'Использование %',
    'Use % and Win %' => 'Использовать % и выиграть %',
    'Used in global stats' => 'Используется в мировой статистике',
    'Use full width of the screen' => 'Используйте всю ширину экрана',
    'Use profile icon of your twitter account' => 'Использовать иконку профиля вашего твиттер-аккаунта',
    'User Agents in last 24 hours' => 'Агенты пользователя за последние 24 часа',
    'User Count' => 'Количество пользователей',
    'User Name' => 'Имя пользователя',
    'Users' => 'Пользователи',
    'Use your profile icon' => 'Используйте иконку вашего профиля',
    'Verification Code' => 'Код верификации',
    'Verify' => 'Проверить',
    'Version' => 'Версия',
    'Version {0}' => 'Версия {0}',
    'View Settings' => 'Просмотр настроек',
    'We\'ll send an email when you log in to the website or change your password.' => 'Мы отправим Вам электронное сообщение, когда Вы войдете на сайт или измените пароль.',
    'Weapon' => 'Оружие',
    'Weapon (Icon)' => 'Оружие (икона)',
    'Weapon (Short)' => 'Оружие (короткое)',
    'Weapon icons were created by {0}.' => 'Оружейные иконки были созданы по адресу {0} .',
    'Weapons' => 'Оружие',
    'Weapon Trends' => 'Тенденции в области оружия',
    'Weapon | {weapon}' => 'Оружие | {weapon}',
    'Weapon | {weapon} | {rule}' => 'Оружие | {weapon} | {rule}',
    'Webhook URL' => 'URL веб-крюка',
    'Win' => 'Выиграть',
    'Win %' => 'Выиграть %',
    'Win % (Total)' => 'Выиграть % (Всего)',
    'Win % ({0} Battles)' => 'Выиграть % ( {0} Бои)',
    'Winning Percentage' => 'Выигрышный процент',
    'Winning Percentage based on K/D' => 'Процент выигрыша на основе K/D',
    'Win streak (Bad guys)' => 'Полоса побед (Плохие парни)',
    'Win streak (Good guys)' => 'Полоса побед (Хорошие парни)',
    'Win Streak: {count}' => 'Win Streak: {count}',
    'Won' => 'Выиграл',
    'won' => 'выигранный',
    'Won / Lost' => 'Выиграл / Потерял',
    'X Power' => 'X Power',
    'X Power (after)' => 'X Питание (после)',
    'Yes' => 'Да',
    'Yesterday' => 'Вчера',
    'You' => 'Вы',
    'You can\'t use an IDN (Internationalized Domain Names) email address' => 'Вы не можете использовать адрес электронной почты ИДИ (интернационализированные доменные имена)',
    'You can delete this battle.' => 'Вы можете удалить эту битву.',
    'You must agree to the above to delete this battle.' => 'Вы должны согласиться с вышеизложенным, чтобы удалить эту битву.',
    'Your Battles' => 'Ваши битвы',
    'Your browser does not support this action.' => 'Ваш браузер не поддерживает это действие.',
    'Your current icon:' => 'Ваша текущая иконка:',
    'Your current image will be deleted and reset to auto-generated image.' => 'Ваше текущее изображение будет удалено и сброшено на автоматически сгенерированное.',
    'Your profile icon has been updated.' => 'Иконка Вашего профиля обновлена.',
    '[Outdated]' => '[Устарело]',
    '{0} etc.' => '{0} и т.д.',
    '{0}×{1} or less resolution' => '{0} × {1} или менее разрешение',
    '{attribute} must be at most 15 alphanumeric or underscore characters.' => '{attribute} должен содержать не более 15 буквенно-цифровых символов или символов подчеркивания.',
    '{decimal5_7} Format' => '{decimal5_7} Формат',
    '{lower}-{upper} percentile' => '{lower} - {upper} процентиль',
    '{n,plural,=1{battle} other{battles}}' => '{n,plural,=1{battle} other{battles}}',
    '{name}\'s Battle' => '{name} \'s Битва',
    '{name}\'s Battle Report' => '{name} \'s Battle Report',
    '{name}\'s Battles' => '{name} \'s Бои',
    '{name}\'s Battle Stats (by Mode)' => '{name} \'s Боевая статистика (по режимам)',
    '{name}\'s Battle Stats (by Mode and Stage)' => '{name} \'s Боевая статистика (по режимам и этапам)',
    '{name}\'s Battle Stats (by Stage)' => '{name} \'s Боевая статистика (по этапам)',
    '{name}\'s Battle Stats (by Weapon)' => '{name} \'s Боевая статистика (по оружию)',
    '{name}\'s Battle Stats (Cause of Death)' => '{name} \'s Battle Stats (Причина смерти)',
    '{name}\'s Battle Stats (Ranked Battle)' => '{name} \'s Battle Stats (Ranked Battle - Боевая статистика)',
    '{name}\'s Battle Stats (Splatfest)' => '{name} \'s Боевая статистика (Splatfest)',
    '{name}\'s Battle Stats (Turf War)' => '{name} \'s Battle Stats (Война за газоны)',
    '{name}\'s Battle Stats (vs. Weapon)' => '{name} \'s Боевая статистика (против оружия)',
    '{name}\'s Battle Stats ({rule})' => '{name} \'s Battle Stats ( {rule} )',
    '{name}\'s Favorite Weapon' => '{name} \'s Любимое оружие',
    '{name}\'s Splat Log' => '{name} \'s Splat Log',
    '{nFormatted} {n, plural, =1{battle} other{battles}}' => '{nFormatted} {n, plural, =1{battle} other{battles}}',
    '{nFormatted} {n, plural, =1{time} other{times}}' => '{nFormatted} {n, plural, =1{time} other{times}}',
    '{number, plural, =1{1 death} other{# deaths}} in {battle, plural, =1{1 battle} other{# battles}}' => '{number, plural, =1{1 death} other{# deaths}} в {battle, plural, =1{1 battle} other{# battles}}',
    '{number, plural, =1{1 egg} other{# eggs}} in {battle, plural, =1{1 shift} other{# shifts}}' => '{number, plural, =1{1 egg} other{# eggs}} в {battle, plural, =1{1 shift} other{# shifts}}',
    '{number, plural, =1{1 kill} other{# kills}}' => '{number, plural, =1{1 kill} other{# kills}}',
    '{number, plural, =1{1 kill} other{# kills}} in {battle, plural, =1{1 battle} other{# battles}}' => '{number, plural, =1{1 kill} other{# kills}} в {battle, plural, =1{1 battle} other{# battles}}',
    '{number, plural, =1{1 time} other{# times}} in {battle, plural, =1{1 shift} other{# shifts}}' => '{number, plural, =1{1 time} other{# times}} в {battle, plural, =1{1 shift} other{# shifts}}',
    '{pct_point} percentage point' => '{pct_point} процентный пункт',
    '{pct} % loss' => '{pct} % потеря',
    '{pct} ({dupf} DU/F)' => '{pct} ( {dupf} DU/F)',
    '{percentile} Percentile' => '{percentile} Процент',
    '{point, plural, =1{1 point} other{# points}} in {battle, plural, =1{1 battle} other{# battles}}' => '{point, plural, =1{1 point} other{# points}} в {battle, plural, =1{1 battle} other{# battles}}',
    '{point, plural, other{#p}}' => '{point, plural, other{#p}}',
    '{point}p' => '{point} стр',
    '{rule}: Current' => '{rule} : Текущий',
    '{rule}: Peak' => '{rule} : Пик',
    '{sec,plural,=1{# second} other{# seconds}}' => '{sec,plural,=1{# second} other{# seconds}}',
    '{sec} seconds' => '{sec} секунды',
    '{sec} seconds ({pct} %)' => '{sec} секунд ( {pct} %)',
    '{sec} seconds, {cnt} times' => '{sec} секунд, {cnt} раз',
    '{theme} Theme' => '{theme} Тема',
    '{title} Official Website' => '{title} Официальный сайт',
    '~{estPower}' => '~ {estPower}',
    '~{point}p' => '~ {point} p',
];
