<?php

/**
 * @copyright Copyright (C) 2015-2021 AIZAWA Hina
 * @license https://github.com/fetus-hina/stat.ink/blob/master/LICENSE MIT
 * @author AIZAWA Hina <hina@fetus.jp>
 */

declare(strict_types=1);

return [
    '(combined)' => '(combiné)',
    '(default)' => '(par défaut)',
    '(For only Splatoon 1 at this time)' => '(Pour seulement Splatoon 1 à l\'heure actuelle)',
    '(incomplete)' => '(incomplet)',
    '(unknown result)' => '(résultat inconnu)',
    '* This exclusion is an attempt to minimize overcounting in weapon usage statistics.' => '* Cette exclusion est une tentative de minimiser le surdénombrement dans les statistiques d\'utilisation des armes.',
    '3+9 Format' => 'Format 3+9',
    '3, 9 Format' => '3, 9 Format',
    '10x Battle' => '10x Bataille',
    '24H Win %' => '24H Gagne %',
    '57 Format' => '57 Format',
    '100x Battle' => 'Bataille 100x',
    '<div class="input-group"><span class="input-group-addon">From:</span>{input}</div>' => '<div class="input-group"><span class="input-group-addon">De :</span> {input} </div>',
    '<div class="input-group"><span class="input-group-addon">To:</span>{input}</div>' => '<div class="input-group"><span class="input-group-addon">Pour :</span> {input} </div>',
    'Ability Effect' => 'Effet de capacité',
    'About support for color-blindness' => 'À propos du soutien au daltonisme',
    'Active Players' => 'Joueurs actifs',
    'Activity' => 'Activité',
    'Add' => 'Ajouter',
    'Add Slack Integration' => 'Ajoutez l\'intégration Slack',
    'All Players' => 'Tous les joueurs',
    'Always enable horizontal scroll' => 'Toujours activer le défilement horizontal',
    'Anonymize, don\'t link from other user\'s results' => 'Anonymisation, ne pas établir de lien à partir des résultats d\'un autre utilisateur',
    'Anonymized' => 'Anonymisé',
    'Another account' => 'Un autre compte',
    'Any Time' => 'A tout moment',
    'API Info: Gears: {0}' => 'Info API : engrenages : {0}',
    'API Info: Stages (Splatoon 2)' => 'Info API : Etapes (Splatoon 2)',
    'API Info: Weapons' => 'Info API : Armes',
    'API Info: Weapons (Splatoon 2)' => 'Info API : Armes (Splatoon 2)',
    'API Token' => 'Token API',
    'Apply' => 'Postulez à',
    'Apps for {version}' => 'Apps pour {version}',
    'Area' => 'Zone',
    'Are you sure you want to regenerate your API token?' => 'Êtes-vous sûr de vouloir régénérer votre jeton d\'API ?',
    'Assist' => 'Assister',
    'Assists' => 'Aide',
    'Auto (cookie)' => 'Auto (cookie)',
    'Auto (Identicon)' => 'Auto (Identicon)',
    'Automated' => 'Automatisé',
    'Average' => 'Moyenne',
    'Average:' => 'Moyenne :',
    'Avg.' => 'Moyenne.',
    'Avg. game in {time}' => 'Jeu moyen en {time}',
    'Avg. K.O. in {time}' => 'Moyenne K.O. en {time}',
    'Avg Assists' => 'Moyens d\'assistance',
    'Avg Deaths' => 'Nombre moyen de décès',
    'Avg Inked' => 'Encre moyenne',
    'Avg Kills' => 'Nombre moyen de décès',
    'Avg KR' => 'KR moyen',
    'Avg Specials' => 'Promotions moyennes',
    'Back' => 'Retour',
    'Bad Guys' => 'Les mauvais garçons',
    'Bad guys are in control' => 'Les méchants ont le contrôle',
    'Bad guys winning' => 'Les méchants gagnent',
    'Based on deaths' => 'Basé sur les décès',
    'Based on kills' => 'Basé sur les meurtres',
    'Battle Count' => 'Compte des batailles',
    'Battle End' => 'Fin de la bataille',
    'Battles' => 'Batailles',
    'Battles:' => 'Batailles :',
    'Battles:{0} / Win %:{1} / Avg Kills:{2} / Avg Deaths:{3} / Kill Ratio:{4}' => 'Batailles : {0} / Gain % : {1} / Nombre moyen de tués : {2} / Nombre moyen de décès : {3} / Ratio de tués : {4}',
    'Battles and Users' => 'Batailles et utilisateurs',
    'Battle Start' => 'Début de la bataille',
    'between {down} and {up} {name}' => 'entre {down} et {up} {name}',
    'Black out' => 'Black out',
    'Black out except private battle' => 'Black out sauf bataille privée',
    'Black out except private battle and teammate on league battle (4 players)' => 'Black out sauf combat privé et coéquipier en combat de ligue (4 joueurs)',
    'Black out except private battle and teammate on squad battle (tri or quad)' => 'Black out sauf combat privé et coéquipier sur un combat de groupe (tri ou quad)',
    'Black out other players' => 'Black out des autres joueurs',
    'Black out other players (details)' => 'Black out des autres joueurs (détails)',
    'Black out other players (images)' => 'Black out des autres joueurs (images)',
    'Black out other players from the details list' => 'Supprimez les autres joueurs de la liste des détails',
    'Black out other players from the result image' => 'Supprimez les autres joueurs de l\'image de résultat',
    'Blog' => 'Blog',
    'Boy' => 'Garçon',
    'Brand' => 'Marque',
    'Calendar' => 'Calendrier',
    'Capture Environment' => 'Environnement de capture',
    'Cash' => 'En espèces',
    'Category' => 'Catégorie',
    'Cause of Death' => 'Cause du décès',
    'Change Icon' => 'Changer d\'icône',
    'Change Password' => 'Changer le mot de passe',
    'Channel' => 'Chaîne',
    'Click to copy' => 'Cliquez pour copier',
    'Close' => 'Fermer',
    'Clout' => 'Clout',
    'Clout (Normal)' => 'Clout (Normal)',
    'Clout (Pro)' => 'Clout (Pro)',
    'Color-Blind Support' => 'Support pour le Color-Blind',
    'Color Scheme' => 'Schéma de couleurs',
    'combos' => 'combos',
    'Compare Number Of Uses' => 'Comparer le nombre d\'utilisations',
    'Compare number of uses' => 'Comparer le nombre d\'utilisations',
    'Connectivity' => 'Connectivité',
    'Continue' => 'Continuer',
    'Copied!' => 'Copié !',
    'Correlation Coefficient' => 'Coefficient de corrélation',
    'Could not be updated.' => 'N\'a pas pu être mis à jour.',
    'Could not find specified battle.' => 'Impossible de trouver la bataille spécifiée.',
    'Could not get your twitter icon at this time.' => 'Impossible d\'obtenir votre icône twitter pour le moment.',
    'Could not update your icon. Please try again.' => 'Impossible de mettre à jour votre icône, veuillez réessayer.',
    'Count (Bad Guys)' => 'Compter (les mauvais garçons)',
    'Count (Good Guys)' => 'Comptez (les bons gars)',
    'CSV (IkaLog compat.)' => 'CSV (IkaLog compat.)',
    'CSV format' => 'Format CSV',
    'Current' => 'Actuel',
    'Current/Last Splatfest' => 'La fête de l\'eau actuelle/dernière',
    'Current Password' => 'Mot de passe actuel',
    'Current Period' => 'Période en cours',
    'Current Stages' => 'Étapes actuelles',
    'Current Time:' => 'L\'heure actuelle :',
    'd' => 'd',
    'D/min' => 'D/min',
    'Daily Report' => 'Rapport quotidien',
    'Data Sent' => 'Données envoyées',
    'Date Time' => 'Date Heure',
    'Dead' => 'Mort',
    'Deaths' => 'Décès',
    'Deaths (average):' => 'Décès (moyenne) :',
    'Deaths (median):' => 'Décès (médiane) :',
    'Deaths/min' => 'Décès/min',
    'Deaths Per Battle' => 'Décès par bataille',
    'Deaths per minute' => 'Décès par minute',
    'Default Color' => 'Couleur par défaut',
    'Delete' => 'Supprimer',
    'Detail' => 'Détail',
    'Detailed List' => 'Liste détaillée',
    'Details' => 'Détails',
    'Deviation' => 'Déviation',
    'Disabled' => 'Handicapés',
    'Don\'t anonymize, display in-game name' => 'Ne pas anonymiser, afficher le nom dans le jeu',
    'Don\'t anonymize, display stat.ink\'s name' => 'Ne pas anonymiser, afficher le nom de stat.ink',
    'Don\'t group' => 'Ne pas grouper',
    'Do not close this window.' => 'Ne fermez pas cette fenêtre.',
    'Downloads' => 'Téléchargements',
    'Download Stats' => 'Télécharger les statistiques',
    'e.g. YouTube video, like "{0}"' => 'par exemple, une vidéo YouTube, comme " {0} "',
    'Earlier Turf-Inked data is currently wrong. It will be fixed in the near future.' => 'Les données antérieures de Turf-Inked sont actuellement erronées. Elles seront corrigées dans un avenir proche.',
    'Edit' => 'Modifier',
    'Edit Your Battle: #{0}' => 'Modifier votre combat : # {0}',
    'Effects' => 'Effets',
    'Elapsed' => 'Ecoulé',
    'Elapsed Time' => 'Temps écoulé',
    'Elapsed Time (seconds)' => 'Temps écoulé (secondes)',
    'Email' => 'Envoyez un courriel à',
    'Enabled' => 'Activé',
    'Enable machine-translation' => 'Activer la traduction automatique',
    'Enable noise reduction (count)' => 'Activer la réduction du bruit (comptage)',
    'Enable noise reduction (position of the objective)' => 'Permettre la réduction du bruit (position de l\'objectif)',
    'Encounter Ratio' => 'Ratio de rencontre',
    'Enemy Weapon' => 'Arme ennemie',
    'Error' => 'Erreur',
    'Estimated X Power' => 'Estimation de la puissance X',
    'Europe' => 'Europe',
    'Europe/Oceania' => 'Europe/Océanie',
    'Excluded: Private Battles' => 'Exclus : les batailles privées',
    'Excluded: Private Battles and Squad Battles (when Rank S or S+)' => 'Exclus : les batailles privées et les batailles d\'escouade (lorsque le rang S ou S+)',
    'Excluded: The uploader, All players (Private Battle), Uploader\'s teammates (Squad Battle or Splatfest Battle)' => 'Exclus : l\'uploader, tous les joueurs (combat privé), les coéquipiers de l\'uploader (combat de groupe ou combat de Splatfest)',
    'Export' => 'Exporter',
    'Extra Data' => 'Données supplémentaires',
    'Favorite Weapon' => 'Arme préférée',
    'Favorite Weapons' => 'Armes préférées',
    'Favorite Weapons of This Site Member' => 'Armes favorites du membre de ce site',
    'Feedback or suggestions are welcome. Please contact me via GitHub or Twitter.' => 'N\'hésitez pas à me contacter via GitHub ou Twitter pour me faire part de vos commentaires ou suggestions.',
    'fest.ink' => 'fest.ink',
    'Fest Power' => 'Le pouvoir de la fête',
    'Fest Power (Normal)' => 'Puissance de la fête (normale)',
    'Fest Power (Pro)' => 'Fest Power (Pro)',
    'Few' => 'Quelques',
    'Filter' => 'Filtrez',
    'Filter Query' => 'Requête de filtrage',
    'Final Count' => 'Compte final',
    'for {title}' => 'pour {title}',
    'Freshness' => 'Fraîcheur',
    'Friend Code' => 'Code d\'ami',
    'Friend Code (Switch)' => 'Code d\'ami (Switch)',
    'Game Mode' => 'Mode jeu',
    'Game Version' => 'Version du jeu',
    'Gear' => 'Équipement',
    'GeoIP guessed {timezone}' => 'GeoIP a deviné {timezone}',
    'Getting Started' => 'Pour commencer',
    'Girl' => 'Fille',
    'GNU Social, Mastodon etc.' => 'GNU Social, Mastodon etc.',
    'Good Guys' => 'Les bons gars',
    'Good guys are in control' => 'Les bons gars ont le contrôle',
    'Good guys winning' => 'Les gentils gagnent',
    'Group by main weapon' => 'Groupe par arme principale',
    'Group by reskins' => 'Regrouper par reskins',
    'Group by weapon type' => 'Regrouper par type d\'arme',
    'Guessed:' => 'J\'ai deviné :',
    'Guessed by your IP:' => 'Deviné par votre IP :',
    'Guess the region' => 'Devinez la région',
    'Guest' => 'Invité',
    'Has disconnected player' => 'A déconnecté le joueur',
    'Hasn\'t disconnected player' => 'N\'a pas déconnecté le joueur',
    'Hawaii Time' => 'Heure d\'Hawaii',
    'Highest (current period)' => 'Le plus élevé (période actuelle)',
    'Highest (this teammates)' => 'Le plus haut (ces coéquipiers)',
    'History' => 'Histoire',
    'However, statistics information will be opened.' => 'Cependant, les informations statistiques seront ouvertes.',
    'I agree. Delete this battle.' => 'Je suis d\'accord. Supprimez cette bataille.',
    'I agree to the terms above.' => 'J\'accepte les conditions ci-dessus.',
    'Icon' => 'Icône',
    'If you already have an account, please click here.' => 'Si vous avez déjà un compte, veuillez cliquer ici.',
    'If you delete this battle, it will be gone forever.' => 'Si vous supprimez cette bataille, elle disparaîtra à jamais.',
    'If you misuse this feature, you will be banned.' => 'Si vous utilisez cette fonction de manière abusive, vous serez banni.',
    'Ika-Denwa' => 'Ika-Denwa',
    'Ika-Nakama' => 'Ika-Nakama',
    'Ika-Nakama 2' => 'Ika-Nakama 2',
    'Ika-Nakama 2 User ID' => 'ID utilisateur Ika-Nakama 2',
    'Ika-Nakama User ID' => 'ID utilisateur Ika-Nakama',
    'IkaLog' => 'IkaLog',
    'IkaLog Download Page' => 'Page de téléchargement d\'IkaLog',
    'IkaRec' => 'IkaRec',
    'IkaRec 2' => 'IkaRec 2',
    'Image Sharing' => 'Partage d\'images',
    'Incomplete Data' => 'Données incomplètes',
    'Inked' => 'Encré',
    'Inked/min' => 'Encre/min',
    'Inking Performance' => 'Performance d\'encrage',
    'Inking Performance vs Win %' => 'Performance de l\'encrage par rapport au % de gain',
    'Inkling' => 'Inkling',
    'Input new battle results' => 'Saisir de nouveaux résultats de combat',
    'In session' => 'En session',
    'Integrate' => 'Intégrer',
    'Internal ID' => 'ID interne',
    'Interval' => 'Intervalle',
    'Invalid {0} or {1}.' => 'Invalide {0} ou {1} .',
    'IQR' => 'IQR',
    'Japan' => 'Japon',
    'Japan Time' => 'Heure du Japon',
    'Join us' => 'Rejoignez-nous',
    'JSON (IkaLog compat.)' => 'JSON (IkaLog compat.)',
    'JSON (stat.ink format, gzipped)' => 'JSON (format stat.ink, gzippé)',
    'JSON format' => 'Format JSON',
    'Judge' => 'Juge',
    'Just {result} {rule} at {stage}' => 'Juste {result} {rule} à {stage}',
    'k' => 'k',
    'K/min' => 'K/min',
    'Kill or Assist' => 'Tuer ou aider',
    'Kill Rate' => 'Taux de mortalité',
    'Kill Ratio' => 'Ratio de mortalité',
    'Kills' => 'Tue',
    'Kills (average):' => 'Tue (en moyenne) :',
    'Kills (median):' => 'Tue (médiane) :',
    'Kills / Deaths' => 'Tue / Décès',
    'Kills/min' => 'Tue/mn',
    'Kills and Deaths' => 'Tueries et décès',
    'Kills per minute' => 'Tue par minute',
    'KNOCKOUT' => 'KNOCKOUT',
    'Knockout' => 'K.O.',
    'Knockout Ratio' => 'Ratio d\'élimination',
    'KR' => 'KR',
    'Language' => 'Langue',
    'Language (used for OStatus)' => 'Langue (utilisée pour OStatus)',
    'Last 24 Hours' => 'Les dernières 24 heures',
    'Last 24h: {winpct} win ({win}/{count}), Avg. {kill}k/{death}d' => 'Dernières 24h : {winpct} win ( {win} / {count} ), Moyenne {kill} k/ {death} d',
    'Last Month (UTC)' => 'Le mois dernier (UTC)',
    'Last {n} Battles' => 'Dernier {n} Batailles',
    'Last {n} Periods' => 'Dernières {n} Périodes',
    'Latest' => 'Dernières nouvelles',
    'League Power' => 'Pouvoir de la ligue',
    'Legend' => 'Légende',
    'Legends' => 'Légendes',
    'less than {min} {name}' => 'moins de {min} {name}',
    'Level' => 'Niveau',
    'Level (After)' => 'Niveau (après)',
    'Link' => 'Lien',
    'Link from other user\'s results' => 'Lien à partir des résultats d\'un autre utilisateur',
    'Links' => 'Liens',
    'List' => 'Liste',
    'Loading...' => 'Chargement...',
    'Lobby' => 'Lobby',
    'Lobby (Icon)' => 'Lobby (Icône)',
    'Location' => 'Localisation',
    'Login' => 'Connexion',
    'Login History' => 'Historique de connexion',
    'Login history will be deleted in {term}.' => 'L\'historique de connexion sera supprimé sur {term} .',
    'Login Method' => 'Méthode de connexion',
    'Log in with other services' => 'Se connecter avec d\'autres services',
    'Log in with Twitter' => 'Connectez-vous avec Twitter',
    'Logout' => 'Déconnexion',
    'Lose' => 'Perdre',
    'Lost' => 'Perdu',
    'lost' => 'perdu',
    'Low ink' => 'Faible consommation d\'encre',
    'Main Weapon' => 'Arme principale',
    'Many' => 'Nombreux',
    'Masked' => 'Masqué',
    'max={max} min={min} average={avg} median={median} mode={mode}' => 'max= {max} min= {min} average= {avg} median= {median} mode= {mode}',
    'max={max} min={min} median={median}' => 'max= {max} min= {min} median= {median}',
    'Maximum' => 'Maximum',
    'Max Inked' => 'Max Encre',
    'Max Kill Combo' => 'Combo Max Kill',
    'Max Kill Streak' => 'Max Kill Streak',
    'Median' => 'Médiane',
    'Minimum' => 'Au minimum',
    'MMMM y' => 'MMMM y',
    'Mobile' => 'Mobile',
    'Mode' => 'Mode',
    'Mode (Icon)' => 'Mode (Icône)',
    'Mode (Short)' => 'Mode (court)',
    'more...' => 'plus...',
    'more than {max} {name}' => 'plus de {max} {name}',
    'Moving Avg. ({0} Battles)' => 'Moyens de déplacement ( {0} Batailles)',
    'My team\'s league power' => 'La puissance de mon équipe en ligue',
    'My team\'s splatfest power' => 'La puissance de mon équipe en matière de splatfest',
    'My Team Count' => 'Mon compte d\'équipe',
    'My Team Score' => 'Mon score d\'équipe',
    'My Team Splatfest Power' => 'Mon équipe Splatfest Power',
    'Name' => 'Nom',
    'Name (for display)' => 'Nom (pour l\'affichage)',
    'Neutral' => 'Neutre',
    'New battle' => 'Nouvelle bataille',
    'New Password' => 'Nouveau mot de passe',
    'New Password (again)' => 'Nouveau mot de passe (encore)',
    'Next' => 'Suivant',
    'Next Battle' => 'Prochaine bataille',
    'Next Month' => 'Le mois prochain',
    'Next Stages' => 'Prochaines étapes',
    'Nintendo Network ID' => 'ID réseau Nintendo',
    'Nintendo Switch Online app' => 'L\'application Nintendo Switch Online',
    'No' => 'Non',
    'No battles' => 'Pas de batailles',
    'No black out' => 'Pas de black-out',
    'No Data' => 'Pas de données',
    'No one in control' => 'Personne aux commandes',
    'North America/Oceania' => 'Amérique du Nord/Océanie',
    'Note' => 'Note',
    'Note (private)' => 'Note (privée)',
    'Note (public)' => 'Note (publique)',
    'Octoling' => 'Octoling',
    'Official Twitter' => 'Twitter officiel',
    'Open Source Licenses' => 'Licences Open Source',
    'Others' => 'Autres',
    'Password' => 'Mot de passe',
    'Password (again)' => 'Mot de passe (encore)',
    'PC' => 'PC',
    'Peak' => 'Le sommet',
    'Period' => 'Période',
    'Permalink' => 'Lien permanent',
    'Players' => 'Joueurs',
    'Players:' => 'Les joueurs :',
    'Please copy an API key below and paste to IkaLog, IkaRec or other apps that are compatible with {0}.' => 'Veuillez copier une clé API ci-dessous et la coller dans IkaLog, IkaRec ou d\'autres applications compatibles avec {0} .',
    'Please copy this URL:' => 'Veuillez copier cette URL :',
    'Please do not use this feature to destroy evidence.' => 'Veuillez ne pas utiliser cette fonction pour détruire des preuves.',
    'Please keep it secret.' => 'Veuillez garder le secret.',
    'Please tell us about your capture environment and communication between your Wii U and User Agent (e.g. IkaLog). This information will be public.' => 'Veuillez nous indiquer votre environnement de capture et la communication entre votre Wii U et votre User Agent (par ex. IkaLog). Ces informations seront publiques.',
    'Please wait.' => 'Veuillez patienter.',
    'PNG/JPEG file up to {0}' => 'Fichier PNG/JPEG jusqu\'à {0}',
    'Points' => 'Points',
    'Position' => 'Position',
    'Powered by' => 'Propulsé par',
    'Power Level' => 'Niveau de puissance',
    'Prev.' => 'Préc.',
    'Prev. Battle' => 'Bataille précédente',
    'Prev. Month' => 'Mois précédent',
    'Previous Period' => 'Période précédente',
    'Primary Ability' => 'Aptitude principale',
    'Privacy Policy' => 'Politique de confidentialité',
    'Profile and Settings' => 'Profil et paramètres',
    'Q<sub>1/4</sub>' => 'Q1/4',
    'Q<sub>3/4</sub>' => 'Q3/4',
    'Rank' => 'Classement',
    'Rank (After)' => 'Rang (après)',
    'Rank (after the battle)' => 'Rang (après la bataille)',
    'Rank: Current' => 'Rang : Actuel',
    'Rank: Peak' => 'Rang : Maximum',
    'Rank in Team' => 'Rang dans l\'équipe',
    'Rate' => 'Evaluez',
    'Ratio' => 'Ratio',
    'Recent Battles' => 'Batailles récentes',
    'Recent Results' => 'Résultats récents',
    'Recent Use %' => 'Utilisation récente en %.',
    'Recommended to Android users:' => 'Recommandé aux utilisateurs d\'Android :',
    'Regenerate your API token' => 'Régénérer votre jeton d\'API',
    'Region (used for Splatfest)' => 'Région (utilisée pour Splatfest)',
    'Register' => 'S\'inscrire',
    'Relative Time' => 'Temps relatif',
    'Released' => 'Publié sur',
    'Remember me' => 'Se souvenir de moi',
    'Remote Follow' => 'Suivi à distance',
    'Reset icon' => 'Icône de réinitialisation',
    'Reset to default icon' => 'Rétablir l\'icône par défaut',
    'Reskin of' => 'Reskin de',
    'Result' => 'Résultat',
    'Results of {name}\'s Battle' => 'Résultats de la bataille de {name}',
    'Room' => 'Salle',
    'Room info (Private)' => 'Informations sur la chambre (Privé)',
    'S/min' => 'S/min',
    'Salmon Run CSV' => 'Salmon Run CSV',
    'Save!' => 'Économisez !',
    'Schedule' => 'Programme',
    'Scheduled' => 'Programmé',
    'Schema information' => 'Informations sur le schéma',
    'Screen Name' => 'Nom de l\'écran',
    'Screen Name (Login Name)' => 'Nom d\'écran (Nom de connexion)',
    'Search' => 'Recherchez',
    'Search {date}' => 'Recherchez {date}',
    'Search {from} - {to}' => 'Recherchez {from} - {to}',
    'Secondary Abilities' => 'Aptitudes secondaires',
    'Sent an email to your email address. Please check your mailbox and get the verification code.' => 'Vous avez envoyé un courriel à votre adresse électronique. Veuillez vérifier votre boîte aux lettres et obtenir le code de vérification.',
    'Session History' => 'Historique des sessions',
    'Settings' => 'Paramètres',
    'Show All Players' => 'Afficher tous les joueurs',
    'Show moving averages' => 'Afficher les moyennes mobiles',
    'Show your API Token' => 'Montrez votre jeton d\'API',
    'Simplified List' => 'Liste simplifiée',
    'Slack Integration' => 'Intégration lâche',
    'Source: {source}' => 'Source : {source}',
    'Source Code' => 'Code source',
    'Special' => 'Spécial',
    'Special %' => 'Spéciale %.',
    'Special (Icon)' => 'Spécial (Icône)',
    'Special:' => 'Spécial :',
    'Special Battle' => 'Bataille spéciale',
    'Special Battle (Fest)' => 'Bataille spéciale (Fest)',
    'Special Charged' => 'Spécialement chargé',
    'Specials' => 'Promotions',
    'Specials/min' => 'Promotions/min',
    'Species' => 'Espèces',
    'Specify Period' => 'Précisez la période',
    'Splatfest' => 'Splatfest',
    'Splatfest Power' => 'Le pouvoir de Splatfest',
    'Splatfest Power (Normal)' => 'Splatfest Power (Normal)',
    'Splatfest Power (Pro)' => 'Splatfest Power (Pro)',
    'Splatfest Region:' => 'Région de Splatfest :',
    'Splatfest Title' => 'Titre de Splatfest',
    'Splatfest Title (After)' => 'Titre de Splatfest (Après)',
    'SplatNet' => 'SplatNet',
    'SplatNet #' => 'SplatNet #',
    'SplatNet 2' => 'SplatNet 2',
    'SplatNet Battle #' => 'Bataille de SplatNet #',
    'Splatoon Official Website (Japan)' => 'Site officiel de Splatoon (Japon)',
    'Splatoon Official Website (UK)' => 'Site officiel de Splatoon (Royaume-Uni)',
    'Splatoon Official Website (US/Canada)' => 'Site officiel de Splatoon (États-Unis/Canada)',
    'Staaaay Fresh!' => 'Staaaay Fresh !',
    'Stack' => 'Pile',
    'Stage' => 'Scène',
    'Stage (Short)' => 'Étape (courte)',
    'Stages' => 'Étapes',
    'Standard Deviation' => 'Écart-type',
    'Stats' => 'Stats',
    'Stats (by Mode)' => 'Stats (par mode)',
    'Stats (by Mode and Stage)' => 'Stats (par mode et par étape)',
    'Stats (by Stage)' => 'Statistiques (par étape)',
    'Stats (by Weapon)' => 'Stats (par arme)',
    'Stats (Cause of Death)' => 'Statistiques (Cause du décès)',
    'Stats (Ranked Battle)' => 'Statistiques (Bataille classée)',
    'Stats (Splatfest)' => 'Stats (Splatfest)',
    'Stats (Turf War)' => 'Statistiques (Guerre du gazon)',
    'Stats (vs. Weapon)' => 'Statistiques (par rapport à l\'arme)',
    'Stats ({rule})' => 'Statistiques ( {rule} )',
    'Stats: FestPwr diff vs Win %' => 'Statistiques : FestPwr diff vs Win %.',
    'Stats: K/D vs Win %' => 'Stats : K/D vs Gain %.',
    'Stats: Knockout Ratio' => 'Statistiques : Ratio d\'élimination',
    'Stats: Stages' => 'Statistiques : Étapes',
    'Stats: User Activity' => 'Stats : Activité des utilisateurs',
    'Stats: Weapons' => 'Statistiques : Armes',
    'Std Dev' => 'Dev Std',
    'streak' => 'streak',
    'Sub:' => 'Sous :',
    'Sub Weapon' => 'Sous-arme',
    'Sub Weapon (Icon)' => 'Sous-arme (Icône)',
    'Summarize' => 'Résumez',
    'Summary: Based on the current filter' => 'Résumé : basé sur le filtre actuel',
    'Synergy Bonus' => 'Bonus de synergie',
    'Systematic error of win %' => 'Erreur systématique du % de gain',
    'Tablet' => 'Tablette',
    'Target Player\'s Team' => 'L\'équipe du joueur cible',
    'Team' => 'L\'équipe',
    'Team Icon' => 'Icône de l\'équipe',
    'Team ID' => 'ID de l\'équipe',
    'Team Inked' => 'L\'équipe Inked',
    'Team {theme}' => 'L\'équipe {theme}',
    'Test' => 'Testez',
    'The estimated location may be inaccurate.' => 'L\'emplacement estimé peut être inexact.',
    'The icon will be:' => 'L\'icône sera :',
    'Their team\'s league power' => 'La puissance de leur équipe en ligue',
    'Their team\'s splatfest power' => 'La puissance de leur équipe',
    'Their Team Count' => 'Leur équipe compte',
    'Their Team Score' => 'Leur score d\'équipe',
    'Their Team Splatfest Power' => 'La puissance de leur équipe Splatfest',
    'Themes from {name}' => 'Thèmes de {name}',
    'The password will be encrypted.' => 'Le mot de passe sera crypté.',
    'There are no data.' => 'Il n\'y a pas de données.',
    'There is no user associated with the specified twitter account.' => 'Aucun utilisateur n\'est associé au compte twitter spécifié.',
    'These battles were recorded with an outdated version of IkaLog. Please upgrade to the latest version.' => 'Ces batailles ont été enregistrées avec une version obsolète d\'IkaLog. Veuillez passer à la dernière version.',
    'This battle was recorded with an outdated version of IkaLog. Please upgrade to the latest version.' => 'Cette bataille a été enregistrée avec une version obsolète d\'IkaLog. Veuillez mettre à jour la version la plus récente.',
    'This data was totaled after normalization to 5 minute intervals for each battle.' => 'Ces données ont été totalisées après normalisation à des intervalles de 5 minutes pour chaque bataille.',
    'This document is under a <a href="http://creativecommons.org/licenses/by/4.0/deed.en">Creative Commons Attribution 4.0 International License</a>.' => 'Ce document est sous <a href="http://creativecommons.org/licenses/by/4.0/deed.en">licence internationale Creative Commons Attribution 4.0</a>.',
    'This information will be public. Integration for "log in with twitter" can be done from the profile page.' => 'Ces informations seront publiques. L\'intégration pour "se connecter avec twitter" peut être faite à partir de la page de profil.',
    'This Month (UTC)' => 'Ce mois-ci (UTC)',
    'This option is provided for deleting an incorrectly-reported battle.' => 'Cette option est prévue pour supprimer une bataille incorrectement signalée.',
    'This twitter account has already been integrated with another user.' => 'Ce compte twitter a déjà été intégré avec un autre utilisateur.',
    'This website doesn\'t support Internet Explorer. Please use a modern browser, for example Chrome or Firefox.' => 'Ce site web ne supporte pas Internet Explorer, veuillez utiliser un navigateur moderne, par exemple Chrome ou Firefox.',
    'This website has color-blind support. Please check "Color-Blind Support" in the "Username/Guest" menu of the navbar to enable it.' => 'Ce site web dispose d\'un support daltonien. Veuillez cocher "Support daltonien" dans le menu "Nom d\'utilisateur/invité" de la barre de navigation pour l\'activer.',
    'This website is an open source project. It is under the MIT License. The source code is available on GitHub.' => 'Ce site est un projet open source, sous licence MIT. Le code source est disponible sur GitHub.',
    'This website is an UNOFFICIAL SERVICE. It is not related to the Splatoon development team or Nintendo.' => 'Ce site est un SERVICE NON OFFICIEL, il n\'est pas lié à l\'équipe de développement de Splatoon ou à Nintendo.',
    'This {attribute} is already in use.' => 'Ce {attribute} est déjà utilisé.',
    'Time' => 'Temps',
    'Time is up' => 'Le temps est écoulé',
    'Times' => 'Times',
    'Time was up' => 'Le temps était écoulé',
    'Time Zone' => 'Fuseau horaire',
    'Title' => 'Titre',
    'Title (After)' => 'Titre (après)',
    'Today' => 'Aujourd\'hui',
    'Total' => 'Total',
    'Total Clout' => 'Total Clout',
    'Total Clout (After the battle)' => 'Total Clout (Après la bataille)',
    'Total Inked' => 'Total Encré',
    'Trends' => 'Tendances',
    'Turf Inked' => 'Gazon encré',
    'Turf inked (including bonus)' => 'Gazon encré (avec bonus)',
    'Turf Inked + Bonus' => 'Gazon encré + Bonus',
    'TV' => 'TV',
    'Twitter @name' => 'Nom de Twitter',
    'TZ' => 'TZ',
    'Unknown' => 'Inconnu',
    'Unlink account' => 'Compte de non-lien',
    'Update' => 'Mise à jour',
    'Update Your Email Address' => 'Mettre à jour votre adresse e-mail',
    'Update Your Icon' => 'Mettre à jour votre icône',
    'Update Your Password' => 'Mettre à jour votre mot de passe',
    'Update Your Profile' => 'Mettre à jour votre profil',
    'Upload icon' => 'Icône de téléchargement',
    'Upload new image' => 'Charger une nouvelle image',
    'URL related to this battle' => 'URL en rapport avec cette bataille',
    'Use %' => 'Utilisation %.',
    'Use % and Win %' => 'Utilisez le % et gagnez le %.',
    'Used in global stats' => 'Utilisé dans les statistiques mondiales',
    'Use full width of the screen' => 'Utiliser toute la largeur de l\'écran',
    'Use profile icon of your twitter account' => 'Utiliser l\'icône de profil de votre compte twitter',
    'User Agents in last 24 hours' => 'User Agents dans les dernières 24 heures',
    'User Count' => 'Nombre d\'utilisateurs',
    'User Name' => 'Nom d\'utilisateur',
    'Users' => 'Utilisateurs',
    'Use your profile icon' => 'Utilisez l\'icône de votre profil',
    'Verification Code' => 'Code de vérification',
    'Verify' => 'Vérifiez',
    'Version' => 'Version',
    'Version {0}' => 'Version {0}',
    'View Settings' => 'Voir les paramètres',
    'We\'ll send an email when you log in to the website or change your password.' => 'Nous vous enverrons un courriel lorsque vous vous connecterez au site ou que vous changerez votre mot de passe.',
    'Weapon' => 'Arme',
    'Weapon (Icon)' => 'Arme (Icône)',
    'Weapon (Short)' => 'Arme (courte)',
    'Weapon icons were created by {0}.' => 'Les icônes d\'armes ont été créées par {0} .',
    'Weapons' => 'Armes',
    'Weapon Trends' => 'Tendances en matière d\'armement',
    'Weapon | {weapon}' => 'Arme | {weapon}',
    'Weapon | {weapon} | {rule}' => 'Arme | {weapon} | {rule}',
    'Webhook URL' => 'URL du webhook',
    'Win' => 'Gagnez',
    'Win %' => 'Gagner %.',
    'Win % (Total)' => 'Gain % (Total)',
    'Win % ({0} Battles)' => 'Gagner % ( {0} Batailles)',
    'Winning Percentage' => 'Pourcentage de gain',
    'Winning Percentage based on K/D' => 'Pourcentage de gain basé sur K/D',
    'Win streak (Bad guys)' => 'Victoire (Méchants)',
    'Win streak (Good guys)' => 'Une série de victoires (Les bons)',
    'Win Streak: {count}' => 'Win Streak : {count}',
    'Won' => 'A gagné',
    'won' => 'a gagné',
    'Won / Lost' => 'Gagnés / Perdus',
    'X Power' => 'Puissance X',
    'X Power (after)' => 'X Puissance (après)',
    'Yes' => 'Oui',
    'Yesterday' => 'Hier',
    'You' => 'Vous',
    'You can\'t use an IDN (Internationalized Domain Names) email address' => 'Vous ne pouvez pas utiliser une adresse e-mail IDN (Internationalized Domain Names)',
    'You can delete this battle.' => 'Vous pouvez supprimer cette bataille.',
    'You must agree to the above to delete this battle.' => 'Vous devez accepter ce qui précède pour supprimer cette bataille.',
    'Your Battles' => 'Vos batailles',
    'Your browser does not support this action.' => 'Votre navigateur ne prend pas en charge cette action.',
    'Your current icon:' => 'Votre icône actuelle :',
    'Your current image will be deleted and reset to auto-generated image.' => 'Votre image actuelle sera supprimée et réinitialisée à l\'image générée automatiquement.',
    'Your profile icon has been updated.' => 'L\'icône de votre profil a été mise à jour.',
    '[Outdated]' => '[Dépassé]',
    '{0} etc.' => '{0} etc.',
    '{0}×{1} or less resolution' => '{0} × {1} ou moins de résolution',
    '{attribute} must be at most 15 alphanumeric or underscore characters.' => '{attribute} doit comporter au maximum 15 caractères alphanumériques ou de soulignement.',
    '{decimal5_7} Format' => '{decimal5_7} Format',
    '{lower}-{upper} percentile' => '{lower} - {upper} percentile',
    '{n,plural,=1{battle} other{battles}}' => '{n,plural,=1{battle} other{battles}}',
    '{name}\'s Battle' => 'La bataille de {name}',
    '{name}\'s Battle Report' => '{name} - Rapport sur les batailles',
    '{name}\'s Battles' => 'Les batailles de {name}',
    '{name}\'s Battle Stats (by Mode)' => '{name} Stats des combats (par mode)',
    '{name}\'s Battle Stats (by Mode and Stage)' => '{name} - Statistiques des combats (par mode et par étape)',
    '{name}\'s Battle Stats (by Stage)' => '{name} - Statistiques sur les batailles (par étape)',
    '{name}\'s Battle Stats (by Weapon)' => '{name} - Statistiques sur les batailles (par arme)',
    '{name}\'s Battle Stats (Cause of Death)' => '{name} (Cause de la mort)',
    '{name}\'s Battle Stats (Ranked Battle)' => '{name} (Statistiques sur les batailles classées)',
    '{name}\'s Battle Stats (Splatfest)' => '{name} (Splatfest)',
    '{name}\'s Battle Stats (Turf War)' => '{name} - Statistiques sur les batailles (Turf War)',
    '{name}\'s Battle Stats (vs. Weapon)' => '{name} - Statistiques sur les combats (contre les armes)',
    '{name}\'s Battle Stats ({rule})' => '{name} - Statistiques sur les batailles ( {rule} )',
    '{name}\'s Favorite Weapon' => 'L\'arme préférée de {name}',
    '{name}\'s Splat Log' => 'Le journal de bord de {name}',
    '{nFormatted} {n, plural, =1{battle} other{battles}}' => '{nFormatted} {n, plural, =1{battle} other{battles}}',
    '{nFormatted} {n, plural, =1{time} other{times}}' => '{nFormatted} {n, plural, =1{time} other{times}}',
    '{number, plural, =1{1 death} other{# deaths}} in {battle, plural, =1{1 battle} other{# battles}}' => '{number, plural, =1{1 death} other{# deaths}} en {battle, plural, =1{1 battle} other{# battles}}',
    '{number, plural, =1{1 egg} other{# eggs}} in {battle, plural, =1{1 shift} other{# shifts}}' => '{number, plural, =1{1 egg} other{# eggs}} en {battle, plural, =1{1 shift} other{# shifts}}',
    '{number, plural, =1{1 kill} other{# kills}}' => '{number, plural, =1{1 kill} other{# kills}}',
    '{number, plural, =1{1 kill} other{# kills}} in {battle, plural, =1{1 battle} other{# battles}}' => '{number, plural, =1{1 kill} other{# kills}} en {battle, plural, =1{1 battle} other{# battles}}',
    '{number, plural, =1{1 time} other{# times}} in {battle, plural, =1{1 shift} other{# shifts}}' => '{number, plural, =1{1 time} other{# times}} en {battle, plural, =1{1 shift} other{# shifts}}',
    '{pct_point} percentage point' => '{pct_point} point de pourcentage',
    '{pct} % loss' => '{pct} % de perte',
    '{pct} ({dupf} DU/F)' => '{pct} ( {dupf} DU/F)',
    '{percentile} Percentile' => '{percentile} Percentile',
    '{point, plural, =1{1 point} other{# points}} in {battle, plural, =1{1 battle} other{# battles}}' => '{point, plural, =1{1 point} other{# points}} en {battle, plural, =1{1 battle} other{# battles}}',
    '{point, plural, other{#p}}' => '{point, plural, other{#p}}',
    '{point}p' => '{point} p',
    '{rule}: Current' => '{rule} : En cours',
    '{rule}: Peak' => '{rule} : Le pic',
    '{sec,plural,=1{# second} other{# seconds}}' => '{sec,plural,=1{# second} other{# seconds}}',
    '{sec} seconds' => '{sec} secondes',
    '{sec} seconds ({pct} %)' => '{sec} secondes ( {pct} %)',
    '{sec} seconds, {cnt} times' => '{sec} secondes, {cnt} fois',
    '{theme} Theme' => '{theme} Thème',
    '{title} Official Website' => '{title} Site officiel',
    '~{estPower}' => '~ {estPower}',
    '~{point}p' => '~ {point} p',
];
