<?php

/**
 * @copyright Copyright (C) 2015-2021 AIZAWA Hina
 * @license https://github.com/fetus-hina/stat.ink/blob/master/LICENSE MIT
 * @author AIZAWA Hina <hina@fetus.jp>
 */

declare(strict_types=1);

return [
    '(combined)' => '(kombiniert)',
    '(default)' => '(Standard)',
    '(For only Splatoon 1 at this time)' => '(Zur Zeit nur für Splatoon 1)',
    '(incomplete)' => '(unvollständig)',
    '(unknown result)' => '(Ergebnis unbekannt)',
    '* This exclusion is an attempt to minimize overcounting in weapon usage statistics.' => '* Dieser Ausschluss ist ein Versuch, eine Überzählung in der Waffeneinsatzstatistik zu minimieren.',
    '3+9 Format' => '3+9 Format',
    '3, 9 Format' => '3, 9 Format',
    '10x Battle' => '10x Schlacht',
    '24H Win %' => '24H Gewinn %',
    '57 Format' => '57 Format',
    '100x Battle' => '100x Schlacht',
    '<div class="input-group"><span class="input-group-addon">From:</span>{input}</div>' => '<div class="input-group"><span class="input-group-addon">Von:</span> {input} </div>',
    '<div class="input-group"><span class="input-group-addon">To:</span>{input}</div>' => '<div class="input-group"><span class="input-group-addon">An:</span> {input} </div>',
    'Ability Effect' => 'Fähigkeit Effekt',
    'About support for color-blindness' => 'Über die Unterstützung bei Farbenblindheit',
    'Active Players' => 'Aktive Spieler',
    'Activity' => 'Aktivität',
    'Add' => 'hinzufügen',
    'Add Slack Integration' => 'Slack-Integration hinzufügen',
    'All Players' => 'Alle Spieler',
    'Always enable horizontal scroll' => 'Horizontalen Bildlauf immer aktivieren',
    'Anonymize, don\'t link from other user\'s results' => 'Anonymisieren, keine Verlinkung von Ergebnissen anderer Benutzer',
    'Anonymized' => 'Anonymisiert',
    'Another account' => 'Ein anderes Konto',
    'Any Time' => 'Jederzeit',
    'API Info: Gears: {0}' => 'API Info: Gänge: {0}',
    'API Info: Stages (Splatoon 2)' => 'API-Infos: Stages (Splatoon 2)',
    'API Info: Weapons' => 'API-Info: Waffen',
    'API Info: Weapons (Splatoon 2)' => 'API-Info: Waffen (Splatoon 2)',
    'API Token' => 'API-Token',
    'Apply' => 'Anwenden',
    'Apps for {version}' => 'Apps für {version}',
    'Area' => 'Bereich',
    'Are you sure you want to regenerate your API token?' => 'Sind Sie sicher, dass Sie Ihr API-Token neu generieren wollen?',
    'Assist' => 'Assistieren',
    'Assists' => 'Assists',
    'Auto (cookie)' => 'Auto (Cookie)',
    'Auto (Identicon)' => 'Auto (Identicon)',
    'Automated' => 'Automatisiert',
    'Average' => 'Durchschnitt',
    'Average:' => 'Durchschnittlich:',
    'Avg.' => 'Avg.',
    'Avg. game in {time}' => 'Avg. Spiel in {time}',
    'Avg. K.O. in {time}' => 'Avg. K.O. in {time}',
    'Avg Assists' => 'Avg Assists',
    'Avg Deaths' => 'Avg Todesfälle',
    'Avg Inked' => 'Avg eingefärbt',
    'Avg Kills' => 'Avg Tötungen',
    'Avg KR' => 'Avg KR',
    'Avg Specials' => 'Avg Besonderheiten',
    'Back' => 'Zurück',
    'Bad Guys' => 'Bösewichte',
    'Bad guys are in control' => 'Die Bösewichte haben die Kontrolle',
    'Bad guys winning' => 'Bösewichte gewinnen',
    'Based on deaths' => 'Basierend auf Todesfällen',
    'Based on kills' => 'Basierend auf Tötungen',
    'Battle Count' => 'Schlacht zählen',
    'Battle End' => 'Schlacht Ende',
    'Battles' => 'Schlachten',
    'Battles:' => 'Schlachten:',
    'Battles:{0} / Win %:{1} / Avg Kills:{2} / Avg Deaths:{3} / Kill Ratio:{4}' => 'Kämpfe: {0} / Win %: {1} / Avg Kills: {2} / Avg Deaths: {3} / Kill Ratio: {4}',
    'Battles and Users' => 'Schlachten und Benutzer',
    'Battle Start' => 'Schlacht Start',
    'between {down} and {up} {name}' => 'zwischen {down} und {up} {name}',
    'Black out' => 'Verdunkeln',
    'Black out except private battle' => 'Verdunkeln, außer privater Kampf',
    'Black out except private battle and teammate on league battle (4 players)' => 'Blackout außer Privatkampf und Teamkollege auf Ligakampf (4 Spieler)',
    'Black out except private battle and teammate on squad battle (tri or quad)' => 'Blackout außer Privatkampf und Teamkamerad auf Squad-Kampf (Tri oder Quad)',
    'Black out other players' => 'Andere Spieler ausblenden',
    'Black out other players (details)' => 'Andere Spieler ausblenden (Details)',
    'Black out other players (images)' => 'Andere Spieler schwärzen (Bilder)',
    'Black out other players from the details list' => 'Schwärzen von anderen Playern in der Details-Liste',
    'Black out other players from the result image' => 'Schwärzen Sie andere Spieler aus dem Ergebnisbild',
    'Blog' => 'Blog',
    'Boy' => 'Junge',
    'Brand' => 'Marke',
    'Calendar' => 'Kalender',
    'Capture Environment' => 'Capture-Umgebung',
    'Cash' => 'Bargeld',
    'Category' => 'Kategorie',
    'Cause of Death' => 'Todesursache',
    'Change Icon' => 'Symbol ändern',
    'Change Password' => 'Passwort ändern',
    'Channel' => 'Kanal',
    'Click to copy' => 'Zum Kopieren anklicken',
    'Close' => 'Schließen',
    'Clout' => 'Clout',
    'Clout (Normal)' => 'Schlagkraft (Normal)',
    'Clout (Pro)' => 'Schlagkraft (Pro)',
    'Color-Blind Support' => 'Farbenblind-Unterstützung',
    'Color Scheme' => 'Farbschema',
    'combos' => 'Combos',
    'Compare Number Of Uses' => 'Anzahl der Verwendungen vergleichen',
    'Compare number of uses' => 'Anzahl der Verwendungen vergleichen',
    'Connectivity' => 'Konnektivität',
    'Continue' => 'Weiter',
    'Copied!' => 'Kopiert!',
    'Correlation Coefficient' => 'Korrelationskoeffizient',
    'Could not be updated.' => 'Konnte nicht aktualisiert werden.',
    'Could not find specified battle.' => 'Die angegebene Schlacht konnte nicht gefunden werden.',
    'Could not get your twitter icon at this time.' => 'Konnte Ihr Twitter-Symbol zu diesem Zeitpunkt nicht erhalten.',
    'Could not update your icon. Please try again.' => 'Ihr Symbol konnte nicht aktualisiert werden. Bitte versuchen Sie es erneut.',
    'Count (Bad Guys)' => 'Graf (Bösewichte)',
    'Count (Good Guys)' => 'Graf (Good Guys)',
    'CSV (IkaLog compat.)' => 'CSV (IkaLog-kompat.)',
    'CSV format' => 'CSV-Format',
    'Current' => 'Aktuell',
    'Current/Last Splatfest' => 'Aktuelles/Letztes Splatfest',
    'Current Password' => 'Aktuelles Passwort',
    'Current Period' => 'Aktuelle Periode',
    'Current Stages' => 'Aktuelle Stadien',
    'Current Time:' => 'Aktuelle Zeit:',
    'd' => 'd',
    'D/min' => 'D/min',
    'Daily Report' => 'Täglicher Bericht',
    'Data Sent' => 'Gesendete Daten',
    'Date Time' => 'Datum Uhrzeit',
    'Dead' => 'Tot',
    'Deaths' => 'Todesfälle',
    'Deaths (average):' => 'Todesfälle (Durchschnitt):',
    'Deaths (median):' => 'Todesfälle (Median):',
    'Deaths/min' => 'Todesfälle/min',
    'Deaths Per Battle' => 'Todesfälle pro Schlacht',
    'Deaths per minute' => 'Todesfälle pro Minute',
    'Default Color' => 'Standardfarbe',
    'Delete' => 'Löschen',
    'Detail' => 'Detail',
    'Detailed List' => 'Detaillierte Liste',
    'Details' => 'Details',
    'Deviation' => 'Abweichung',
    'Disabled' => 'Deaktiviert',
    'Don\'t anonymize, display in-game name' => 'Nicht anonymisieren, In-Game-Name anzeigen',
    'Don\'t anonymize, display stat.ink\'s name' => 'Nicht anonymisieren, den Namen von stat.ink anzeigen',
    'Don\'t group' => 'Nicht gruppieren',
    'Do not close this window.' => 'Schließen Sie dieses Fenster nicht.',
    'Downloads' => 'Downloads',
    'Download Stats' => 'Download-Statistiken',
    'e.g. YouTube video, like "{0}"' => 'z. B. YouTube-Video, wie " {0} "',
    'Earlier Turf-Inked data is currently wrong. It will be fixed in the near future.' => 'Frühere Turf-Inked-Daten sind derzeit falsch. Sie werden in naher Zukunft korrigiert.',
    'Edit' => 'Bearbeiten',
    'Edit Your Battle: #{0}' => 'Edit Your Battle: # {0}',
    'Effects' => 'Effekte',
    'Elapsed' => 'Abgelaufen',
    'Elapsed Time' => 'Verstrichene Zeit',
    'Elapsed Time (seconds)' => 'Verstrichene Zeit (Sekunden)',
    'Email' => 'E-Mail',
    'Enabled' => 'Aktiviert',
    'Enable machine-translation' => 'Maschinenübersetzung aktivieren',
    'Enable noise reduction (count)' => 'Rauschunterdrückung einschalten (count)',
    'Enable noise reduction (position of the objective)' => 'Aktivieren Sie die Rauschunterdrückung (Position des Objektivs)',
    'Encounter Ratio' => 'Verhältnis der Begegnungen',
    'Enemy Weapon' => 'Feindliche Waffe',
    'Error' => 'Fehler',
    'Estimated X Power' => 'Geschätzte X-Leistung',
    'Europe' => 'Europa',
    'Europe/Oceania' => 'Europa/Ozeanien',
    'Excluded: Private Battles' => 'Ausgeschlossen: Private Battles',
    'Excluded: Private Battles and Squad Battles (when Rank S or S+)' => 'Ausgeschlossen: Private Battles und Squad Battles (wenn Rang S oder S+)',
    'Excluded: The uploader, All players (Private Battle), Uploader\'s teammates (Squad Battle or Splatfest Battle)' => 'Ausgeschlossen: Der Uploader, Alle Spieler (Private Battle), Teamkameraden des Uploaders (Squad Battle oder Splatfest Battle)',
    'Export' => 'Exportieren',
    'Extra Data' => 'Extra Daten',
    'Favorite Weapon' => 'Lieblingswaffe',
    'Favorite Weapons' => 'Lieblingswaffen',
    'Favorite Weapons of This Site Member' => 'Lieblingswaffen des Mitglieds dieser Website',
    'Feedback or suggestions are welcome. Please contact me via GitHub or Twitter.' => 'Feedback oder Vorschläge sind willkommen. Bitte kontaktieren Sie mich über GitHub oder Twitter.',
    'fest.ink' => 'fest.ink',
    'Fest Power' => 'Fest Strom',
    'Fest Power (Normal)' => 'Fest Leistung (Normal)',
    'Fest Power (Pro)' => 'Fest Power (Pro)',
    'Few' => 'Wenig',
    'Filter' => 'Filter',
    'Filter Query' => 'Filterabfrage',
    'Final Count' => 'Endgültige Zählung',
    'for {title}' => 'für {title}',
    'Freshness' => 'Frische',
    'Friend Code' => 'Freundes-Code',
    'Friend Code (Switch)' => 'Freundschaftscode (Switch)',
    'Game Mode' => 'Spiel-Modus',
    'Game Version' => 'Spiel Version',
    'Gear' => 'Getriebe',
    'GeoIP guessed {timezone}' => 'GeoIP erraten {timezone}',
    'Getting Started' => 'Erste Schritte',
    'Girl' => 'Mädchen',
    'GNU Social, Mastodon etc.' => 'GNU Social, Mastodon usw.',
    'Good Guys' => 'Gute Kerle',
    'Good guys are in control' => 'Die Guten haben die Kontrolle',
    'Good guys winning' => 'Gute Jungs gewinnen',
    'Group by main weapon' => 'Gruppe nach Hauptwaffe',
    'Group by reskins' => 'Gruppe nach Reskins',
    'Group by weapon type' => 'Nach Waffentyp gruppieren',
    'Guessed:' => 'Erraten:',
    'Guessed by your IP:' => 'Erraten durch Ihre IP:',
    'Guess the region' => 'Erraten Sie die Region',
    'Guest' => 'Gast',
    'Has disconnected player' => 'Hat die Verbindung zum Player unterbrochen',
    'Hasn\'t disconnected player' => 'Hat die Verbindung zum Player nicht unterbrochen',
    'Hawaii Time' => 'Hawaii-Zeit',
    'Highest (current period)' => 'Höchste (aktuelle Periode)',
    'Highest (this teammates)' => 'Höchste (diese Teammitglieder)',
    'History' => 'Geschichte',
    'However, statistics information will be opened.' => 'Es werden jedoch Statistikinformationen geöffnet.',
    'I agree. Delete this battle.' => 'Ich stimme zu. Löschen Sie diese Schlacht.',
    'I agree to the terms above.' => 'Ich bin mit den oben genannten Bedingungen einverstanden.',
    'Icon' => 'Icon',
    'If you already have an account, please click here.' => 'Wenn Sie bereits ein Konto haben, klicken Sie bitte hier.',
    'If you delete this battle, it will be gone forever.' => 'Wenn Sie dieses Battle löschen, ist es für immer verloren.',
    'If you misuse this feature, you will be banned.' => 'Wenn Sie diese Funktion missbrauchen, werden Sie gebannt.',
    'Ika-Denwa' => 'Ika-Denwa',
    'Ika-Nakama' => 'Ika-Nakama',
    'Ika-Nakama 2' => 'Ika-Nakama 2',
    'Ika-Nakama 2 User ID' => 'Ika-Nakama 2 Benutzer-ID',
    'Ika-Nakama User ID' => 'Ika-Nakama Benutzer-ID',
    'IkaLog' => 'IkaLog',
    'IkaLog Download Page' => 'IkaLog Download-Seite',
    'IkaRec' => 'IkaRec',
    'IkaRec 2' => 'IkaRec 2',
    'Image Sharing' => 'Bildfreigabe',
    'Incomplete Data' => 'Unvollständige Daten',
    'Inked' => 'Eingefärbt',
    'Inked/min' => 'Eingetippt/min',
    'Inking Performance' => 'Leistung der Tinte',
    'Inking Performance vs Win %' => 'Färbeleistung vs Win %',
    'Inkling' => 'Inkling',
    'Input new battle results' => 'Neue Kampfergebnisse eingeben',
    'In session' => 'In Sitzung',
    'Integrate' => 'Integrieren Sie',
    'Internal ID' => 'Interne ID',
    'Interval' => 'Intervall',
    'Invalid {0} or {1}.' => 'Ungültig {0} oder {1} .',
    'IQR' => 'IQR',
    'Japan' => 'Japan',
    'Japan Time' => 'Japan Zeit',
    'Join us' => 'Mitmachen',
    'JSON (IkaLog compat.)' => 'JSON (IkaLog-kompat.)',
    'JSON (stat.ink format, gzipped)' => 'JSON (stat.ink-Format, gzipped)',
    'JSON format' => 'JSON-Format',
    'Judge' => 'Richter',
    'Just {result} {rule} at {stage}' => 'Einfach {result} {rule} aufrufen. {stage}',
    'k' => 'k',
    'K/min' => 'K/min',
    'Kill or Assist' => 'Töten oder Helfen',
    'Kill Rate' => 'Tötungsrate',
    'Kill Ratio' => 'Tötungsverhältnis',
    'Kills' => 'Tötet',
    'Kills (average):' => 'Kills (Durchschnitt):',
    'Kills (median):' => 'Tötet (Median):',
    'Kills / Deaths' => 'Tötungen / Todesfälle',
    'Kills/min' => 'Tötet/min',
    'Kills and Deaths' => 'Tötungen und Todesfälle',
    'Kills per minute' => 'Tötungen pro Minute',
    'KNOCKOUT' => 'KNOCKOUT',
    'Knockout' => 'Knockout',
    'Knockout Ratio' => 'Knockout-Verhältnis',
    'KR' => 'KR',
    'Language' => 'Sprache',
    'Language (used for OStatus)' => 'Sprache (verwendet für OStatus)',
    'Last 24 Hours' => 'Letzte 24 Stunden',
    'Last 24h: {winpct} win ({win}/{count}), Avg. {kill}k/{death}d' => 'Letzte 24h: {winpct} gewinnen ( {win} / {count} ), Avg. {kill} k/ {death} d',
    'Last Month (UTC)' => 'Letzter Monat (UTC)',
    'Last {n} Battles' => 'Letzte {n} Schlachten',
    'Last {n} Periods' => 'Letzte {n} Perioden',
    'Latest' => 'Neueste',
    'League Power' => 'Liga Leistung',
    'Legend' => 'Legende',
    'Legends' => 'Legenden',
    'less than {min} {name}' => 'weniger als {min} {name}',
    'Level' => 'Ebene',
    'Level (After)' => 'Pegel (nach)',
    'Link' => 'Link',
    'Link from other user\'s results' => 'Link von den Ergebnissen eines anderen Benutzers',
    'Links' => 'Links',
    'List' => 'Liste',
    'Loading...' => 'Laden...',
    'Lobby' => 'Lobby',
    'Lobby (Icon)' => 'Lobby (Icon)',
    'Location' => 'Standort',
    'Login' => 'Anmeldung',
    'Login History' => 'Login-Verlauf',
    'Login history will be deleted in {term}.' => 'Der Anmeldeverlauf wird unter {term} gelöscht.',
    'Login Method' => 'Login-Methode',
    'Log in with other services' => 'Einloggen mit anderen Diensten',
    'Log in with Twitter' => 'Mit Twitter anmelden',
    'Logout' => 'Abmelden',
    'Lose' => 'Verlieren Sie',
    'Lost' => 'Verloren',
    'lost' => 'verloren',
    'Low ink' => 'Niedrige Tinte',
    'Main Weapon' => 'Hauptwaffe',
    'Many' => 'Viele',
    'Masked' => 'Maskiert',
    'max={max} min={min} average={avg} median={median} mode={mode}' => 'max= {max} min= {min} average= {avg} median= {median} mode= {mode}',
    'max={max} min={min} median={median}' => 'max= {max} min= {min} median= {median}',
    'Maximum' => 'Maximum',
    'Max Inked' => 'Max eingefärbt',
    'Max Kill Combo' => 'Max Kill Combo',
    'Max Kill Streak' => 'Max Kill Streak',
    'Median' => 'Median',
    'Minimum' => 'Minimum',
    'MMMM y' => 'MMMM y',
    'Mobile' => 'Mobil',
    'Mode' => 'Modus',
    'Mode (Icon)' => 'Modus (Symbol)',
    'Mode (Short)' => 'Modus (kurz)',
    'more...' => 'mehr...',
    'more than {max} {name}' => 'mehr als {max} {name}',
    'Moving Avg. ({0} Battles)' => 'Gleitender Durchschnitt ( {0} Battles)',
    'My team\'s league power' => 'Die Ligastärke meines Teams',
    'My team\'s splatfest power' => 'Die Splatfest-Leistung meines Teams',
    'My Team Count' => 'Mein Team zählen',
    'My Team Score' => 'Mein Team Ergebnis',
    'My Team Splatfest Power' => 'Mein Team Splatfest Leistung',
    'Name' => 'Name',
    'Name (for display)' => 'Name (für die Anzeige)',
    'Neutral' => 'Neutral',
    'New battle' => 'Neue Schlacht',
    'New Password' => 'Neues Passwort',
    'New Password (again)' => 'Neues Passwort (wieder)',
    'Next' => 'Nächste',
    'Next Battle' => 'Nächster Kampf',
    'Next Month' => 'Nächster Monat',
    'Next Stages' => 'Nächste Etappen',
    'Nintendo Network ID' => 'Nintendo Netzwerk-ID',
    'Nintendo Switch Online app' => 'Nintendo Switch Online-App',
    'No' => 'Nein',
    'No battles' => 'Keine Schlachten',
    'No black out' => 'Kein Stromausfall',
    'No Data' => 'Keine Daten',
    'No one in control' => 'Keiner hat die Kontrolle',
    'North America/Oceania' => 'Nordamerika/Ozeanien',
    'Note' => 'Hinweis',
    'Note (private)' => 'Hinweis (privat)',
    'Note (public)' => 'Hinweis (öffentlich)',
    'Octoling' => 'Octoling',
    'Official Twitter' => 'Offizieller Twitter',
    'Open Source Licenses' => 'Open-Source-Lizenzen',
    'Others' => 'Andere',
    'Password' => 'Passwort',
    'Password (again)' => 'Passwort (erneut)',
    'PC' => 'PC',
    'Peak' => 'Peak',
    'Period' => 'Zeitraum',
    'Permalink' => 'Permalink',
    'Players' => 'Spieler',
    'Players:' => 'Spieler:',
    'Please copy an API key below and paste to IkaLog, IkaRec or other apps that are compatible with {0}.' => 'Bitte kopieren Sie unten einen API-Schlüssel und fügen Sie ihn in IkaLog, IkaRec oder andere Apps ein, die mit {0} kompatibel sind.',
    'Please copy this URL:' => 'Bitte kopieren Sie diese URL:',
    'Please do not use this feature to destroy evidence.' => 'Bitte verwenden Sie diese Funktion nicht, um Beweise zu vernichten.',
    'Please keep it secret.' => 'Bitte halten Sie es geheim.',
    'Please tell us about your capture environment and communication between your Wii U and User Agent (e.g. IkaLog). This information will be public.' => 'Bitte informieren Sie uns über Ihre Erfassungsumgebung und die Kommunikation zwischen Ihrer Wii U und dem User Agent (z.B. IkaLog). Diese Informationen werden öffentlich sein.',
    'Please wait.' => 'Bitte warten Sie.',
    'PNG/JPEG file up to {0}' => 'PNG/JPEG-Datei bis zu {0}',
    'Points' => 'Punkte',
    'Position' => 'Position',
    'Powered by' => 'Angetrieben durch',
    'Power Level' => 'Leistungspegel',
    'Prev.' => 'Prev.',
    'Prev. Battle' => 'Vor der Schlacht',
    'Prev. Month' => 'Vormonat',
    'Previous Period' => 'Vorherige Periode',
    'Primary Ability' => 'Primäre Fähigkeit',
    'Privacy Policy' => 'Datenschutzrichtlinie',
    'Profile and Settings' => 'Profil und Einstellungen',
    'Q<sub>1/4</sub>' => '<sub>Q1/4</sub>',
    'Q<sub>3/4</sub>' => 'Q3/4',
    'Rank' => 'Rang',
    'Rank (After)' => 'Rang (nach)',
    'Rank (after the battle)' => 'Rang (nach der Schlacht)',
    'Rank: Current' => 'Rang: Aktuell',
    'Rank: Peak' => 'Rang: Spitze',
    'Rank in Team' => 'Rang im Team',
    'Rate' => 'Bewerten Sie',
    'Ratio' => 'Verhältnis',
    'Recent Battles' => 'Neueste Schlachten',
    'Recent Results' => 'Neueste Ergebnisse',
    'Recent Use %' => 'Letzte Verwendung %',
    'Recommended to Android users:' => 'Empfohlen für Android-Benutzer:',
    'Regenerate your API token' => 'Regenerieren Sie Ihr API-Token',
    'Region (used for Splatfest)' => 'Region (verwendet für Splatfest)',
    'Register' => 'Registrieren',
    'Relative Time' => 'Relative Zeit',
    'Released' => 'Freigegeben',
    'Remember me' => 'Erinnern Sie sich an mich',
    'Remote Follow' => 'Ferngesteuertes Folgen',
    'Reset icon' => 'Symbol zurücksetzen',
    'Reset to default icon' => 'Auf Standardsymbol zurücksetzen',
    'Reskin of' => 'Reskin von',
    'Result' => 'Ergebnis',
    'Results of {name}\'s Battle' => 'Ergebnisse von {name} \'s Battle',
    'Room' => 'Zimmer',
    'Room info (Private)' => 'Zimmer-Infos (Privat)',
    'S/min' => 'S/min',
    'Salmon Run CSV' => 'Lachslauf CSV',
    'Save!' => 'Speichern!',
    'Schedule' => 'Zeitplan',
    'Scheduled' => 'Geplant',
    'Schema information' => 'Schema-Informationen',
    'Screen Name' => 'Bildschirm-Name',
    'Screen Name (Login Name)' => 'Bildschirmname (Login-Name)',
    'Search' => 'Suche',
    'Search {date}' => 'Suche {date}',
    'Search {from} - {to}' => 'Suche {from} - {to}',
    'Secondary Abilities' => 'Sekundäre Fähigkeiten',
    'Sent an email to your email address. Please check your mailbox and get the verification code.' => 'Es wurde eine E-Mail an Ihre E-Mail-Adresse gesendet. Bitte prüfen Sie Ihr Postfach und holen Sie sich den Bestätigungscode.',
    'Session History' => 'Session-Verlauf',
    'Settings' => 'Einstellungen',
    'Show All Players' => 'Alle Spieler anzeigen',
    'Show moving averages' => 'Gleitende Durchschnitte anzeigen',
    'Show your API Token' => 'Zeigen Sie Ihr API-Token',
    'Simplified List' => 'Vereinfachte Liste',
    'Slack Integration' => 'Slack-Integration',
    'Source: {source}' => 'Quelle: {source}',
    'Source Code' => 'Quellcode',
    'Special' => 'Spezial',
    'Special %' => 'Spezial %',
    'Special (Icon)' => 'Spezial (Icon)',
    'Special:' => 'Spezial:',
    'Special Battle' => 'Spezial-Schlacht',
    'Special Battle (Fest)' => 'Spezial-Schlacht (Fest)',
    'Special Charged' => 'Speziell aufgeladen',
    'Specials' => 'Besonderheiten',
    'Specials/min' => 'Besonderheiten/min',
    'Species' => 'Spezies',
    'Specify Period' => 'Zeitraum angeben',
    'Splatfest' => 'Splatfest',
    'Splatfest Power' => 'Splatfest Leistung',
    'Splatfest Power (Normal)' => 'Splatfest-Leistung (Normal)',
    'Splatfest Power (Pro)' => 'Splatfest Leistung (Pro)',
    'Splatfest Region:' => 'Splatfest Region:',
    'Splatfest Title' => 'Splatfest Titel',
    'Splatfest Title (After)' => 'Splatfest-Titel (nach)',
    'SplatNet' => 'SplatNet',
    'SplatNet #' => 'SplatNet #',
    'SplatNet 2' => 'SplatNet 2',
    'SplatNet Battle #' => 'SplatNet Battle #',
    'Splatoon Official Website (Japan)' => 'Splatoon Offizielle Website (Japan)',
    'Splatoon Official Website (UK)' => 'Splatoon Offizielle Website (UK)',
    'Splatoon Official Website (US/Canada)' => 'Splatoon Offizielle Website (US/Kanada)',
    'Staaaay Fresh!' => 'Staaaay Fresh!',
    'Stack' => 'Stapel',
    'Stage' => 'Bühne',
    'Stage (Short)' => 'Bühne (Kurz)',
    'Stages' => 'Stadien',
    'Standard Deviation' => 'Standardabweichung',
    'Stats' => 'Statistiken',
    'Stats (by Mode)' => 'Statistiken (nach Modus)',
    'Stats (by Mode and Stage)' => 'Stats (nach Modus und Stufe)',
    'Stats (by Stage)' => 'Statistiken (nach Stufe)',
    'Stats (by Weapon)' => 'Werte (nach Waffe)',
    'Stats (Cause of Death)' => 'Stats (Todesursache)',
    'Stats (Ranked Battle)' => 'Statistiken (Ranglistenkampf)',
    'Stats (Splatfest)' => 'Statistiken (Splatfest)',
    'Stats (Turf War)' => 'Statistiken (Rasenkrieg)',
    'Stats (vs. Weapon)' => 'Stats (vs. Waffe)',
    'Stats ({rule})' => 'Statistiken ( {rule} )',
    'Stats: FestPwr diff vs Win %' => 'Statistik: FestPwr diff vs Win %',
    'Stats: K/D vs Win %' => 'Statistiken: K/D vs Win %',
    'Stats: Knockout Ratio' => 'Statistik: Knockout-Ratio',
    'Stats: Stages' => 'Statistiken: Etappen',
    'Stats: User Activity' => 'Statistik: Benutzeraktivität',
    'Stats: Weapons' => 'Statistik: Waffen',
    'Std Dev' => 'Std Dev',
    'streak' => 'streifen',
    'Sub:' => 'Sub:',
    'Sub Weapon' => 'Sub-Waffe',
    'Sub Weapon (Icon)' => 'Sub-Waffe (Icon)',
    'Summarize' => 'Zusammenfassen',
    'Summary: Based on the current filter' => 'Zusammenfassung: Basierend auf dem aktuellen Filter',
    'Synergy Bonus' => 'Synergie-Bonus',
    'Systematic error of win %' => 'Systematischer Fehler des Gewinns %',
    'Tablet' => 'Tablette',
    'Target Player\'s Team' => 'Team des Zielspielers',
    'Team' => 'Team',
    'Team Icon' => 'Team-Symbol',
    'Team ID' => 'Team-ID',
    'Team Inked' => 'Team Inked',
    'Team {theme}' => 'Team {theme}',
    'Test' => 'Test',
    'The estimated location may be inaccurate.' => 'Die geschätzte Position kann ungenau sein.',
    'The icon will be:' => 'Das Symbol wird sein:',
    'Their team\'s league power' => 'Die Ligastärke ihres Teams',
    'Their team\'s splatfest power' => 'Die Splatfest-Leistung ihres Teams',
    'Their Team Count' => 'Ihr Team zählt',
    'Their Team Score' => 'Ihr Team Ergebnis',
    'Their Team Splatfest Power' => 'Ihr Team Splatfest Power',
    'Themes from {name}' => 'Themen aus {name}',
    'The password will be encrypted.' => 'Das Passwort wird verschlüsselt.',
    'There are no data.' => 'Es sind keine Daten vorhanden.',
    'There is no user associated with the specified twitter account.' => 'Es gibt keinen Benutzer, der mit dem angegebenen Twitter-Konto verbunden ist.',
    'These battles were recorded with an outdated version of IkaLog. Please upgrade to the latest version.' => 'Diese Battles wurden mit einer veralteten Version von IkaLog aufgezeichnet. Bitte aktualisieren Sie auf die neueste Version.',
    'This battle was recorded with an outdated version of IkaLog. Please upgrade to the latest version.' => 'Dieser Kampf wurde mit einer veralteten Version von IkaLog aufgezeichnet. Bitte aktualisieren Sie auf die neueste Version.',
    'This data was totaled after normalization to 5 minute intervals for each battle.' => 'Diese Daten wurden nach der Normalisierung auf 5-Minuten-Intervalle für jeden Kampf summiert.',
    'This document is under a <a href="http://creativecommons.org/licenses/by/4.0/deed.en">Creative Commons Attribution 4.0 International License</a>.' => 'Dieses Dokument steht unter einer <a href="http://creativecommons.org/licenses/by/4.0/deed.en">Creative Commons Attribution 4.0 International License</a>.',
    'This information will be public. Integration for "log in with twitter" can be done from the profile page.' => 'Diese Informationen werden öffentlich sein. Die Integration für "Mit Twitter anmelden" kann von der Profilseite aus erfolgen.',
    'This Month (UTC)' => 'Dieser Monat (UTC)',
    'This option is provided for deleting an incorrectly-reported battle.' => 'Diese Option ist zum Löschen eines falsch gemeldeten Kampfes vorgesehen.',
    'This twitter account has already been integrated with another user.' => 'Dieses Twitter-Konto wurde bereits mit einem anderen Benutzer integriert.',
    'This website doesn\'t support Internet Explorer. Please use a modern browser, for example Chrome or Firefox.' => 'Diese Website unterstützt den Internet Explorer nicht. Bitte verwenden Sie einen modernen Browser, zum Beispiel Chrome oder Firefox.',
    'This website has color-blind support. Please check "Color-Blind Support" in the "Username/Guest" menu of the navbar to enable it.' => 'Diese Website bietet Unterstützung für Farbblinde. Bitte aktivieren Sie "Color-Blind Support" im Menü "Benutzername/Gast" in der Navigationsleiste.',
    'This website is an open source project. It is under the MIT License. The source code is available on GitHub.' => 'Diese Website ist ein Open-Source-Projekt. Sie steht unter der MIT-Lizenz. Der Quellcode ist auf GitHub verfügbar.',
    'This website is an UNOFFICIAL SERVICE. It is not related to the Splatoon development team or Nintendo.' => 'Diese Website ist ein UNOFFIZIELLER SERVICE und steht in keinem Zusammenhang mit dem Splatoon-Entwicklerteam oder Nintendo.',
    'This {attribute} is already in use.' => 'Diese {attribute} ist bereits in Gebrauch.',
    'Time' => 'Zeit',
    'Time is up' => 'Zeit ist abgelaufen',
    'Times' => 'Zeiten',
    'Time was up' => 'Die Zeit war um',
    'Time Zone' => 'Zeitzone',
    'Title' => 'Titel',
    'Title (After)' => 'Titel (nach)',
    'Today' => 'Heute',
    'Total' => 'Gesamt',
    'Total Clout' => 'Gesamte Schlagkraft',
    'Total Clout (After the battle)' => 'Total Clout (Nach der Schlacht)',
    'Total Inked' => 'Total eingefärbt',
    'Trends' => 'Trends',
    'Turf Inked' => 'Rasen eingefärbt',
    'Turf inked (including bonus)' => 'Turf eingefärbt (einschließlich Bonus)',
    'Turf Inked + Bonus' => 'Rasen eingefärbt + Bonus',
    'TV' => 'TV',
    'Twitter @name' => 'Twitter @name',
    'TZ' => 'TZ',
    'Unknown' => 'Unbekannt',
    'Unlink account' => 'Konto entkoppeln',
    'Update' => 'Update',
    'Update Your Email Address' => 'Aktualisieren Sie Ihre E-Mail Adresse',
    'Update Your Icon' => 'Aktualisieren Sie Ihr Icon',
    'Update Your Password' => 'Aktualisieren Sie Ihr Passwort',
    'Update Your Profile' => 'Ihr Profil aktualisieren',
    'Upload icon' => 'Symbol hochladen',
    'Upload new image' => 'Neues Bild hochladen',
    'URL related to this battle' => 'URL zu dieser Schlacht',
    'Use %' => 'Verwendung %',
    'Use % and Win %' => 'Verwendung % und Gewinn %',
    'Used in global stats' => 'Wird in globalen Statistiken verwendet',
    'Use full width of the screen' => 'Volle Breite des Bildschirms nutzen',
    'Use profile icon of your twitter account' => 'Verwenden Sie das Profilsymbol Ihres Twitter-Kontos',
    'User Agents in last 24 hours' => 'Benutzer-Agenten in den letzten 24 Stunden',
    'User Count' => 'Benutzeranzahl',
    'User Name' => 'Benutzer-Name',
    'Users' => 'Benutzer',
    'Use your profile icon' => 'Verwenden Sie Ihr Profilsymbol',
    'Verification Code' => 'Verifizierungs-Code',
    'Verify' => 'Überprüfen Sie',
    'Version' => 'Version',
    'Version {0}' => 'Version {0}',
    'View Settings' => 'Einstellungen anzeigen',
    'We\'ll send an email when you log in to the website or change your password.' => 'Wir senden Ihnen eine E-Mail, wenn Sie sich auf der Website anmelden oder Ihr Passwort ändern.',
    'Weapon' => 'Waffe',
    'Weapon (Icon)' => 'Waffe (Icon)',
    'Weapon (Short)' => 'Waffe (kurz)',
    'Weapon icons were created by {0}.' => 'Waffensymbole wurden von {0} erstellt.',
    'Weapons' => 'Waffen',
    'Weapon Trends' => 'Waffentrends',
    'Weapon | {weapon}' => 'Waffe | {weapon}',
    'Weapon | {weapon} | {rule}' => 'Waffe | {weapon} | {rule}',
    'Webhook URL' => 'Webhook-URL',
    'Win' => 'Gewinnen Sie',
    'Win %' => 'Gewinn %',
    'Win % (Total)' => 'Gewinn % (Gesamt)',
    'Win % ({0} Battles)' => 'Sieg % ( {0} Kämpfe)',
    'Winning Percentage' => 'Prozentsatz der Gewinne',
    'Winning Percentage based on K/D' => 'Gewinnprozentsatz basierend auf K/D',
    'Win streak (Bad guys)' => 'Siegesserie (Böse Jungs)',
    'Win streak (Good guys)' => 'Siegesserie (Gute Jungs)',
    'Win Streak: {count}' => 'Siegesserie: {count}',
    'Won' => 'Won',
    'won' => 'gewonnen',
    'Won / Lost' => 'Gewonnen / Verloren',
    'X Power' => 'X Leistung',
    'X Power (after)' => 'X Leistung (nach)',
    'Yes' => 'Ja',
    'Yesterday' => 'Gestern',
    'You' => 'Sie',
    'You can\'t use an IDN (Internationalized Domain Names) email address' => 'Sie können keine IDN-E-Mail-Adresse (Internationalized Domain Names) verwenden',
    'You can delete this battle.' => 'Sie können diesen Kampf löschen.',
    'You must agree to the above to delete this battle.' => 'Sie müssen dem oben genannten zustimmen, um diesen Kampf zu löschen.',
    'Your Battles' => 'Ihre Schlachten',
    'Your browser does not support this action.' => 'Ihr Browser unterstützt diese Aktion nicht.',
    'Your current icon:' => 'Ihr aktuelles Symbol:',
    'Your current image will be deleted and reset to auto-generated image.' => 'Ihr aktuelles Bild wird gelöscht und auf das automatisch erzeugte Bild zurückgesetzt.',
    'Your profile icon has been updated.' => 'Ihr Profilsymbol wurde aktualisiert.',
    '[Outdated]' => '[Veraltet]',
    '{0} etc.' => '{0} usw.',
    '{0}×{1} or less resolution' => '{0} × {1} oder weniger Auflösung',
    '{attribute} must be at most 15 alphanumeric or underscore characters.' => '{attribute} darf maximal 15 alphanumerische Zeichen oder Unterstriche enthalten.',
    '{decimal5_7} Format' => '{decimal5_7} Format',
    '{lower}-{upper} percentile' => '{lower} - {upper} Perzentil',
    '{n,plural,=1{battle} other{battles}}' => '{n,plural,=1{battle} other{battles}}',
    '{name}\'s Battle' => '{name} \'s Schlacht',
    '{name}\'s Battle Report' => '{name} \'s Schlachtbericht',
    '{name}\'s Battles' => '{name} \'s Schlachten',
    '{name}\'s Battle Stats (by Mode)' => '{name} \'s Kampfstatistiken (nach Modus)',
    '{name}\'s Battle Stats (by Mode and Stage)' => '{name} \'s Kampfstatistiken (nach Modus und Stufe)',
    '{name}\'s Battle Stats (by Stage)' => '{name} \'s Kampfstatistiken (nach Stufe)',
    '{name}\'s Battle Stats (by Weapon)' => '{name} \'s Kampfstatistiken (nach Waffe)',
    '{name}\'s Battle Stats (Cause of Death)' => '{name} \'s Battle Stats (Todesursache)',
    '{name}\'s Battle Stats (Ranked Battle)' => '{name} \'s Kampfstatistiken (Ranglistenkampf)',
    '{name}\'s Battle Stats (Splatfest)' => '{name} \'s Kampfstatistiken (Splatfest)',
    '{name}\'s Battle Stats (Turf War)' => '{name} \'s Schlacht-Statistiken (Turf War)',
    '{name}\'s Battle Stats (vs. Weapon)' => '{name} \'s Kampfstatistiken (vs. Waffe)',
    '{name}\'s Battle Stats ({rule})' => '{name} \'s Battle Stats ( {rule} )',
    '{name}\'s Favorite Weapon' => '{name} \'s Favorite Weapon',
    '{name}\'s Splat Log' => '{name} \'s Splat Log',
    '{nFormatted} {n, plural, =1{battle} other{battles}}' => '{nFormatted} {n, plural, =1{battle} other{battles}}',
    '{nFormatted} {n, plural, =1{time} other{times}}' => '{nFormatted} {n, plural, =1{time} other{times}}',
    '{number, plural, =1{1 death} other{# deaths}} in {battle, plural, =1{1 battle} other{# battles}}' => '{number, plural, =1{1 death} other{# deaths}} in {battle, plural, =1{1 battle} other{# battles}}',
    '{number, plural, =1{1 egg} other{# eggs}} in {battle, plural, =1{1 shift} other{# shifts}}' => '{number, plural, =1{1 egg} other{# eggs}} in {battle, plural, =1{1 shift} other{# shifts}}',
    '{number, plural, =1{1 kill} other{# kills}}' => '{number, plural, =1{1 kill} other{# kills}}',
    '{number, plural, =1{1 kill} other{# kills}} in {battle, plural, =1{1 battle} other{# battles}}' => '{number, plural, =1{1 kill} other{# kills}} in {battle, plural, =1{1 battle} other{# battles}}',
    '{number, plural, =1{1 time} other{# times}} in {battle, plural, =1{1 shift} other{# shifts}}' => '{number, plural, =1{1 time} other{# times}} in {battle, plural, =1{1 shift} other{# shifts}}',
    '{pct_point} percentage point' => '{pct_point} Prozentpunkt',
    '{pct} % loss' => '{pct} % Verlust',
    '{pct} ({dupf} DU/F)' => '{pct} ( {dupf} DU/F)',
    '{percentile} Percentile' => '{percentile} Perzentil',
    '{point, plural, =1{1 point} other{# points}} in {battle, plural, =1{1 battle} other{# battles}}' => '{point, plural, =1{1 point} other{# points}} in {battle, plural, =1{1 battle} other{# battles}}',
    '{point, plural, other{#p}}' => '{point, plural, other{#p}}',
    '{point}p' => '{point} p',
    '{rule}: Current' => '{rule} : Aktuell',
    '{rule}: Peak' => '{rule} : Spitze',
    '{sec,plural,=1{# second} other{# seconds}}' => '{sec,plural,=1{# second} other{# seconds}}',
    '{sec} seconds' => '{sec} Sekunden',
    '{sec} seconds ({pct} %)' => '{sec} Sekunden ( {pct} %)',
    '{sec} seconds, {cnt} times' => '{sec} Sekunden, {cnt} mal',
    '{theme} Theme' => '{theme} Thema',
    '{title} Official Website' => '{title} Offizielle Website',
    '~{estPower}' => '~ {estPower}',
    '~{point}p' => '~ {point} p',
];
