<?php

/**
 * @copyright Copyright (C) 2016 AIZAWA Hina
 * @license https://github.com/fetus-hina/stat.ink/blob/master/LICENSE MIT
 * @author AIZAWA Hina <hina@fetus.jp>
 */

namespace app\controllers;

use app\components\web\Controller;
use yii\filters\VerbFilter;

class DownloadStatsController extends Controller
{
    public $layout = 'main';

    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::class,
                'actions' => [
                    '*' => [ 'head', 'get' ],
                ],
            ],
        ];
    }

    public function actions()
    {
        $prefix = 'app\actions\downloadStats';
        return [
            'index' => [ 'class' => $prefix . '\IndexAction' ],
            'weapon-rule-map' => [ 'class' => $prefix . '\WeaponRuleMapAction' ],
        ];
    }
}
