<?php

/**
 * @copyright Copyright (C) 2015-2022 AIZAWA Hina
 * @license https://github.com/fetus-hina/stat.ink/blob/master/LICENSE MIT
 * @author AIZAWA Hina <hina@fetus.jp>
 */

declare(strict_types=1);

namespace app\components\formatters\api\v3;

use app\models\Ability3;

final class AbilityApiFormatter
{
    public static function toJson(?Ability3 $model, bool $fullTranslate = false): ?array
    {
        if (!$model) {
            return null;
        }

        return [
            'key' => $model->key,
            'name' => NameApiFormatter::toJson($model->name, 'app-ability3', $fullTranslate),
            'primary_only' => $model->primary_only,
        ];
    }
}
