-- https://docs.oracle.com/en/database/oracle/oracle-database/23/sqlrf/COVAR_POP.html
SELECT job_id, 
       COVAR_POP(SYSDATE-hire_date, salary) AS covar_pop,
       COVAR_SAMP(SYSDATE-hire_date, salary) AS covar_samp
  FROM employees
  WHERE department_id in (50, 80)
  GROUP BY job_id
  ORDER BY job_id, covar_pop, covar_samp;