ADMINISTER KEY MANAGEMENT MOVE KEYS 
TO NEW KEYSTORE '$ORACLE_BASE/admin/orcl/wallet'
IDENTIFIED BY "pass"
FROM FORCE KEYSTORE 
IDENTIFIED BY "pass"
WITH IDENTIFIER IN 
(SELECT KEY_ID FROM V$ENCRYPTION_KEYS WHERE ROWNUM < 2);

ADMINISTER KEY MANAGEMENT
    SWITCHOVER TO LIBRARY 'updated_fully_qualified_file_name_of_library' FOR ALL CONTAINERS;

ADMINISTER KEY MANAGEMENT
  CREATE KEYSTORE '/etc/ORACLE/WALLETS/orcl'
  IDENTIFIED BY "pass";

ADMINISTER KEY MANAGEMENT
  CREATE AUTO_LOGIN KEYSTORE FROM KEYSTORE '/etc/ORACLE/WALLETS/orcl'
  IDENTIFIED BY "pass";

ADMINISTER KEY MANAGEMENT
SET KEYSTORE OPEN
  IDENTIFIED BY "pass";

ADMINISTER KEY MANAGEMENT
SET KEYSTORE OPEN
  IDENTIFIED BY "pass"
  CONTAINER = CURRENT;

ADMINISTER KEY MANAGEMENT
SET KEYSTORE OPEN
  IDENTIFIED BY "user_id:password";

ADMINISTER KEY MANAGEMENT
SET KEYSTORE OPEN
  IDENTIFIED BY EXTERNAL STORE;

ADMINISTER KEY MANAGEMENT
SET KEYSTORE CLOSE
  IDENTIFIED BY "pass";

ADMINISTER KEY MANAGEMENT
SET KEYSTORE CLOSE;

ADMINISTER KEY MANAGEMENT
SET KEYSTORE CLOSE
  IDENTIFIED BY "user_id:password";

ADMINISTER KEY MANAGEMENT
SET KEYSTORE CLOSE
  IDENTIFIED BY EXTERNAL STORE;

ADMINISTER KEY MANAGEMENT
  BACKUP KEYSTORE USING 'hr.emp_keystore'
  IDENTIFIED BY "password"
  TO '/etc/ORACLE/KEYSTORE/DB1/';

ADMINISTER KEY MANAGEMENT
  ALTER KEYSTORE PASSWORD IDENTIFIED BY "old_password"
SET "new_password" WITH BACKUP USING 'pwd_change';

ADMINISTER KEY MANAGEMENT
MERGE KEYSTORE '/etc/ORACLE/KEYSTORE/DB1'
    AND KEYSTORE '/etc/ORACLE/KEYSTORE/DB2'
    IDENTIFIED BY "old-pass"
INTO NEW KEYSTORE '/etc/ORACLE/KEYSTORE/DB3'
    IDENTIFIED BY "new-pass";

ADMINISTER KEY MANAGEMENT
MERGE KEYSTORE '/etc/ORACLE/KEYSTORE/DB1'
INTO EXISTING KEYSTORE '/etc/ORACLE/KEYSTORE/DB2'
    IDENTIFIED BY "pass"
WITH BACKUP;

ADMINISTER KEY MANAGEMENT
SET KEY USING ALGORITHM 'SEED128'
  IDENTIFIED BY "pass"
WITH BACKUP;

ADMINISTER KEY MANAGEMENT
  CREATE KEY USING TAG 'mykey1'
  IDENTIFIED BY "pass"
WITH BACKUP;

ADMINISTER KEY MANAGEMENT
USE KEY 'ARgEtzPxpE/Nv8WdPu8LJJUAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
  IDENTIFIED BY "pass"
WITH BACKUP;

ADMINISTER KEY MANAGEMENT
SET TAG 'mykey2' FOR 'ARgEtzPxpE/Nv8WdPu8LJJUAAAAAAAAAAAAAAAAAAAAAAAAAAAAA'
  FORCE KEYSTORE
  IDENTIFIED BY "pass"
WITH BACKUP;

ADMINISTER KEY MANAGEMENT
  EXPORT KEYS WITH SECRET "my_secret"
                  TO '/etc/TDE/export.exp'
                  IDENTIFIED BY "password"
WITH IDENTIFIER IN 'AdoxnJ0uH08cv7xkz83ovwsAAAAAAAAAAAAAAAAAAAAAAAAAAAAA',
    'AW5z3CoyKE/yv3cNT5CWCXUAAAAAAAAAAAAAAAAAAAAAAAAAAAAA';

ADMINISTER KEY MANAGEMENT
  EXPORT KEYS WITH SECRET "my_secret"
                  TO '/etc/TDE/export.exp'
                  IDENTIFIED BY "pass"
WITH IDENTIFIER IN
(SELECT KEY_ID FROM V$ENCRYPTION_KEYS WHERE TAG IN ('mytag1', 'mytag2'));

ADMINISTER KEY MANAGEMENT
  EXPORT KEYS WITH SECRET "my_secret"
                  TO '/etc/TDE/export.exp'
                  IDENTIFIED BY "pass";

ADMINISTER KEY MANAGEMENT
  IMPORT KEYS WITH SECRET "my_secret"
              FROM '/etc/TDE/export.exp'
                  IDENTIFIED BY "pass"
WITH BACKUP;

ADMINISTER KEY MANAGEMENT
SET ENCRYPTION KEY IDENTIFIED BY "software_keystore_password"
  REVERSE MIGRATE USING "user_id:password";

ADMINISTER KEY MANAGEMENT
  ADD SECRET 'secret1' FOR CLIENT 'client1'
  USING TAG 'My first secret'
  IDENTIFIED BY "pass"
WITH BACKUP;

ADMINISTER KEY MANAGEMENT
  ADD SECRET 'secret2' FOR CLIENT 'client2'
  USING TAG 'My second secret'
  IDENTIFIED BY "user_id:password";
