CREATE OR REPLACE PROCEDURE SF_JOB_CLEANUP_SHOWCASES_START (FPN_ANZ_ZUM_VERARBEITEN NUMBER DEFAULT 10000, FPN_BULK_LIMIT NUMBER DEFAULT 5000) AS

    TYPE T_BULK_TAB IS RECORD (
        SC_ID SALESFRONT.SF_SHOWCASE.ID%TYPE,        
        JOBLIST_ID SF_JOB_CLEANUP_SHOWCASES_SCLIST.ID%TYPE
    );
    TYPE T_BULK_COLLECT_TAB IS TABLE OF T_BULK_TAB;

    LNC_ID_LIST T_BULK_COLLECT_TAB;

    COUNTER PLS_INTEGER := 0;
    LVNEXISTS PLS_INTEGER := 0;
    LVSERRORMSG VARCHAR2(4000);

    CURSOR C_DEL_SC(C_MAX_ROW NUMBER) IS
        SELECT SC.ID SC_ID , SL.ID JOBLIST_ID FROM SF_JOB_CLEANUP_SHOWCASES_SCLIST SL
            INNER JOIN SALESFRONT.SF_SHOWCASE SC ON  SC.ID = SL.SF_SHOWCASE_ID
            WHERE SL.VERARBEITEN = 1 
            AND VERARBEITET_AM IS NULL
            AND ROWNUM < C_MAX_ROW;
                   
BEGIN 
    EXECUTE IMMEDIATE 'SELECT COUNT(*) FROM USER_SCHEDULER_JOBS JO WHERE JOB_NAME=''SF_START_TOURENEXPORT'' AND JO.STATE = ''RUNNING''' 
            INTO LVNEXISTS;
    
    IF LVNEXISTS = 0 THEN
    OPEN C_DEL_SC(FPN_ANZ_ZUM_VERARBEITEN);
    LOOP
        --IN BLÖCKEN AUS PERFORMANCE GRÜNDEN
        FETCH C_DEL_SC BULK COLLECT INTO LNC_ID_LIST LIMIT FPN_BULK_LIMIT; 
            COUNTER := COUNTER + LNC_ID_LIST.COUNT;   
        EXIT WHEN C_DEL_SC%NOTFOUND;        
            
        COMMIT;
    END LOOP;
    CLOSE C_DEL_SC;
    END IF;

EXCEPTION WHEN OTHERS THEN
    LVSERRORMSG := SQLERRM || ' BACKTRACE: ' || DBMS_UTILITY.FORMAT_ERROR_BACKTRACE;
    ROLLBACK;
END;