/**
 * Copyright (c) 广州小橘灯信息科技有限公司 2016-2017, wjun_java@163.com.
 * <p>
 * Licensed under the GNU Lesser General Public License (LGPL) ,Version 3.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 * http://www.xjd2020.com
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.fastcms.web.controller.admin;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.fastcms.common.auth.ActionTypes;
import com.fastcms.common.auth.Secured;
import com.fastcms.common.constants.FastcmsConstants;
import com.fastcms.common.model.RestResult;
import com.fastcms.common.model.RestResultUtils;
import com.fastcms.entity.Resource;
import com.fastcms.service.IResourceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

import static com.fastcms.service.IResourceService.ResourceI18n.RESOURCE_NAME_RESOURCE_LIST;
import static com.fastcms.service.IResourceService.ResourceI18n.RESOURCE_NAME_RESOURCE_SYNC;

/**
 * 资源管理
 * @author： wjun_java@163.com
 * @date： 2022/5/3
 * @description：
 * @modifiedBy：
 * @version: 1.0
 */
@RestController
@RequestMapping(FastcmsConstants.ADMIN_MAPPING + "/resource")
public class ResourceController {

	@Autowired
	private IResourceService resourceService;

	/**
	 * 资源列表
	 * @return
	 */
	@GetMapping("list")
	@Secured(name = RESOURCE_NAME_RESOURCE_LIST, resource = "resource:list", action = ActionTypes.READ)
	public RestResult<List<Resource>> getResources() {
		return RestResultUtils.success(resourceService.list(Wrappers.<Resource>lambdaQuery().orderByDesc(Resource::getResourcePath)));
	}

	@PostMapping("sync")
	@Secured(name = RESOURCE_NAME_RESOURCE_SYNC, resource = "resource:sync", action = ActionTypes.WRITE)
	public Object syncResource() {
		resourceService.syncResources();
		return RestResultUtils.success();
	}

}
