package com.fastcms.cms.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fastcms.cms.utils.ArticleUtils;
import com.fastcms.core.template.StaticPathHelper;
import com.fastcms.core.utils.AttachUtils;
import com.fastcms.language.Language;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 *  文章分类
 * @author wjun_java@163.com
 * @since 2021-05-23
 */
public class ArticleCategory implements Serializable, StaticPathHelper, Language {

    private static final long serialVersionUID = 1L;

    public static final String CATEGORY_TYPE = "category";

    /**
     * id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 创建人
     */
    @TableField(fill = FieldFill.INSERT)
    private Long createUserId;

    /**
     * 上级分类
     */
    private Long parentId;

    /**
     * 分类标题
     */
    private String title;

    /**
     * 类型
     */
    private String type = "category";

    /**
     * 排序
     */
    private Integer sortNum;

    /**
     * 分类图标
     */
    private String icon;

    /**
     * 访问标识
     */
    private String suffix;

    /**
     * 访问路径
     */
    private String path;

    /**
     * 语言
     */
    private String language;

    /**
     * 创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    private LocalDateTime created;

    /**
     * 修改时间
     */
    @TableField(fill = FieldFill.INSERT_UPDATE)
    private LocalDateTime updated;

    @TableField(exist = false)
    private String iconUrl;

    @Override
    public String getUrl() {
        return ArticleUtils.getArticleCategoryUrl(this);
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(Long createUserId) {
        this.createUserId = createUserId;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Integer getSortNum() {
        return sortNum;
    }

    public void setSortNum(Integer sortNum) {
        this.sortNum = sortNum;
    }

    public String getIcon() {
        return icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getSuffix() {
        return suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public LocalDateTime getCreated() {
        return created;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getLanguage() {
        return language == null ? getLang() : language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setCreated(LocalDateTime created) {
        this.created = created;
    }

    public LocalDateTime getUpdated() {
        return updated;
    }

    public void setUpdated(LocalDateTime updated) {
        this.updated = updated;
    }

    public String getIconUrl() {
        return AttachUtils.getAttachFileDomain() == null ? getIcon() : AttachUtils.getAttachFileDomain().concat(getIcon() == null ? "" : getIcon());
    }

}
