﻿using OpenQA.Selenium;
using OpenQA.Selenium.Support.UI;
using System;

namespace LoginAutomationSolution
{
    public class LoginPage
    {
        public static void GoTo(string uri)
        {            
            Driver.Instance.Navigate().GoToUrl(uri);
            var wait = new WebDriverWait(Driver.Instance, TimeSpan.FromSeconds(10));
            wait.Until(d => d.SwitchTo().ActiveElement().GetAttribute("id") == "Email");
        }

        public static LoginCommand LoginAs(string userName)
        {
            return new LoginCommand(userName);
        }
    }

    public class LoginCommand
    {

        private readonly string userName;
        private string password;

        public LoginCommand(string userName)
        {
            this.userName = userName;
        }

        public LoginCommand WithPassword(string password)
        {
            this.password = password;
            return this;
        }

        public void Login()
        {
            var loginInput = Driver.Instance.FindElement(By.Id("Email"));
            loginInput.SendKeys(userName);

            var passwordInput = Driver.Instance.FindElement(By.Id("Passwd"));
            passwordInput.SendKeys(password);

            var loginButton = Driver.Instance.FindElement(By.Id("signIn"));
            loginButton.Click();
        }
    }    
}
