# MIT 6.828 OS Engineering

I am attending the MIT 6.828 Operating System Engineering course online. This repository contains the lecture notes, lab source code, and study resources.

## Course Schedule

[MIT 6.828 Fall 2018](https://pdos.csail.mit.edu/6.828/2018/schedule.html)

## Lectures

[Lecture 1 - OS](./lectures/lec01-os-overview.md)

[Lecture 2 - x86 PC and Architecture](./lectures/lec02-x86-pc-arch.md)

[Lecture 3 - C and GDB](./lectures/lec03-c-and-gdb.md)

[Lecture 4 - Shell & OS Organization](./lectures/lec04-shell-os.md)

[Lecture 5 - Isolation Mechanisms](./lectures/lec05-iso-mechanisms.md)

[Lecture 6 - Virtual Memory (1)](./lectures/lec06-virtual-mem-1.md)

[Lecture 7 - Virtual Memory (2)](./lectures/lec07-virtual-mem-2.md)

## Labs

[Lab 1 - Booting a PC](./labs/lab01-boot-pc/README.md)

[Lab 2 - Memory Management](./labs/lab02-mem-management/README.md)

### Tools Guide

[MIT 6.828 Lab Tools Guide](https://pdos.csail.mit.edu/6.828/2018/labguide.html)

## Homeworks

[HW 1 - Boot xv6](./homeworks/hw01-boot-xv6/README.md)

[HW 2 - Shell](./homeworks/hw02-shell/README.md)

[HW 3 - System Calls](./homeworks/hw03-syscall/README.md)

## Reading Materials

[MIT 6.828 Reference Page](https://pdos.csail.mit.edu/6.828/2018/reference.html)

[Using GNU Debugger](./resources/using-gnu-gdb.pdf)

[xv6 OS Introduction Rev.11](./resources/xv6-book-rev11.pdf)

[xv6 Source Code Rev.11](./resources/xv6-source-rev11.pdf)

[ELF Specification Ver1.2](./resources/elf-spec.pdf)

[PC Assembly Language](./resources/pc-asm-book.pdf)