# Security Policy

## Supported Versions

We are committed to addressing security vulnerabilities in the following versions of `prismadocify`:

| Version  | Supported                  |
| -------- | -------------------------- |
| `1.1.4`  | ✅ Yes (Latest stable release) |
| < `1.1.4` | ❌ No (Older versions unsupported) |

We recommend that all users update to the latest version to ensure security and stability.

## Reporting a Vulnerability

If you discover a security vulnerability within `prismadocify`, please follow the steps below to report it:

1. **Contact us directly**: Please email us at [fahimfiroz.ph@gmail.com](mailto:fahimfiroz.ph@gmail.com) with details of the vulnerability.
2. **Provide sufficient information**: Include all relevant information in your report, such as:
   - Version of `prismadocify` affected
   - Description of the vulnerability
   - Steps to reproduce the vulnerability
   - Any relevant logs or error messages
3. **We will respond promptly**: After receiving your report, we will acknowledge receipt within 48 hours and provide an estimated timeline for fixing the issue.

Please **do not disclose** any security vulnerabilities publicly until we've had a chance to address them and issue a fix.

## Security Patch Process

1. Upon verifying a reported vulnerability, we will work to develop and test a patch.
2. Once the patch is ready, we will release it as a new version of `prismadocify`.
3. Users will be notified of the security issue and encouraged to update to the latest version via the release notes.

## Security Best Practices

To help keep your project secure, we recommend the following:

- **Stay updated**: Regularly update `prismadocify` to the latest stable version.
- **Monitor dependencies**: Use tools like `npm audit` or `yarn audit` to detect security vulnerabilities in your project dependencies.
- **Limit exposure**: Follow best practices in securing your development environment and deployment process.
