Theseus includes a number of tutorials to help a user get started:
- [Tutorial 0](00_introduction.ipynb) introduces Theseus and its fundamental concepts, and shows how to use its different basic building blocks.
- [Tutorial 1](01_least_squares_optimization.ipynb) describes how to model and solve a simple least-squares optimization problem.
- [Tutorial 2](02_differentiating_theseus_layer.ipynb) describes how to model and solve a collection of least-squares optimization problems with shared parameters.
- [Tutorial 3](03_custom_cost_functions.ipynb) describes how to write custom cost functions for use in Theseus optimization problems.
- [Tutorial 4](04_motion_planning.ipynb) shows how to implement GPMP2 motion-planning algorithm [(Mukadam et al 2018)](https://arxiv.org/abs/1707.07383).
- [Tutorial 5](05_differentiable_motion_planning.ipynb) shows how to implement a differentiable motion planner, similar to dGPMP2 [(Bhardwaj et al 2020)](https://arxiv.org/pdf/1907.09591.pdf).
