This folder contains examples of how to use Theseus for several applications:

- **simple_example.py:** This is a minimal example using Theseus that is fitting a curve to a dataset of observations.
- **state_estimation_2d.py:** Is an example of how to do 2D pose estimation from simulated
noisy GPS and odometry sensors. In this example the noise is state dependent, and we
learn the cost weight as a function of pose. 
- **motion_planning_2d.py:** Is an example of how to set up a differentiable motion planning
problem, inspired by [Bhardwaj et al. 2020](https://arxiv.org/pdf/1907.09591.pdf).
- **se2_planning.py:** Brief example of how to use SE2 variables with the motion planner
utility, to handle poses with angles in 2D maps and nonholonomic constraints.
- **tactile_pose_estimation.py:** Is an example of how to set up learning models for
tactile pose estimation, as described in [Sodhi et al. 2021](https://arxiv.org/abs/1705.10664).
- **backward_modes.py:** Shows how to compute derivatives through Theseus solves and switch between backward modes.
- **se2_inverse.py:** Is an example of numerically computing the inverse of SE2. 
- **pose_graph/pose_graph_synthetic:** Is an example of how to setup a differentiable pose graph optimization
problem with loop closure outliers.
- **pose_graph/pose_graph_cube:** Is an example of profiling Theseus' optimizers on the cube datasets.
- **pose_graph/pose_graph_benchmark:** Is an example of using Theseus to solve pose graph optimization problems.
- **homography_estimation.py:** Is an example of using Theseus to learn CNN image features for homography estimation.
The features are trained to minimize the four corner distance between the warped and target image.

These can be run from your root `theseus` directory by doing

```bash
python examples/simple_example.py
python examples/state_estimation_2d.py
python examples/motion_planning_2d.py
python examples/tactile_pose_estimation.py
python examples/backward_modes.py
python examples/se2_inverse.py
python examples/pose_graph/pose_graph_synthetic.py
python examples/pose_graph/pose_graph_cube.py
python examples/pose_graph/pose_graph_benchmark.py
python examples/homography_estimation.py
```

The motion planning and tactile estimation examples require `hydra` installation, which you can obtain by running.

```bash
pip install hydra-core
```

The homography example requires `hydra`, `kornia` and `OpenCV`, which you can install with

```bash
pip install hydra-core
pip install kornia
pip install opencv-python
```

Any outputs generated by these scripts will be saved under `examples/outputs`. You can change this directory by passing the CLI option `hydra.run.dir=<your_directory>`.
