---
id: dataset_zoo
title: Dataset Zoo
sidebar_label: Dataset Zoo
---

Here is the list of datasets currently supported in MMF:

| Datasets             | Key                  | Notes                                                                                                             |
| -------------------- | -------------------- | ----------------------------------------------------------------------------------------------------------------- |
| CLEVR                | clevr                | [website](https://cs.stanford.edu/people/jcjohns/clevr/), [paper](https://arxiv.org/abs/1612.06890)                                                          |
| MS COCO 2014         | coco                 | coco has other types of data available (ie, detection), mmf only has coco caption dataset implemented, [website](https://cocodataset.org/), [paper](https://arxiv.org/abs/1504.00325)|
| MS COCO 2017         | coco17               | coco has other types of data available (ie, detection), mmf only has coco caption dataset implemented, [website](https://cocodataset.org/), [paper](https://arxiv.org/abs/1504.00325)|
| Conceptual Captions  | conceptual_captions  | [github](https://github.com/google-research-datasets/conceptual-captions), [website](https://ai.google.com/research/ConceptualCaptions) |
| Flickr30k            | flickr30k            | [github](https://github.com/BryanPlummer/flickr30k_entities)                                                     |
| GQA                  | gqa                  | [website](https://cs.stanford.edu/people/dorarad/gqa/about.html)                                                 |
| Hateful Memes        | hateful_memes        | [paper](https://arxiv.org/abs/2005.04790)                                                                         |
| Localized Narratives | localized_narratives | [website](https://google.github.io/localized-narratives/)                                                         |
| MM IMDB              | mmimdb               | [website](http://lisi1.unal.edu.co/mmimdb/), [paper](https://arxiv.org/abs/1702.01992) |
| NLVR2                | nlvr2                | [website](http://lil.nlp.cornell.edu/nlvr/), [paper](https://arxiv.org/abs/1811.00491) |
| OCRVQA               | ocrvqa               | [website](https://ocr-vqa.github.io/)                                                                             |
| OKVQA                | okvqa                | [website](https://okvqa.allenai.org/)                                                                             |
| SBU Captions         | masked_sbu           | [website](http://www.cs.virginia.edu/~vicente/sbucaptions/)                                                       |
| Scene Text VQA       | stvqa                | [paper](https://arxiv.org/abs/1905.13648)                                   |
| Text Caps            | text_caps            | [website](https://textvqa.org/textcaps)                                                                           |
| TextVQA              | textvqa              | [website](https://textvqa.org/)                                                                                   |
| VisualDialog         | visdial              | [website](https://visualdialog.org/)                                                                              |
| Visual Genome        | visual_genome        | [website](https://visualgenome.org/), [paper](https://arxiv.org/abs/1602.07332) |
| SNLI-VE              | visual_entailment    | [github](https://github.com/necla-ml/SNLI-VE), [paper](https://arxiv.org/abs/1901.06706) |
| VizWiz               | vizwiz               | [website](https://vizwiz.org/), [paper](https://arxiv.org/abs/1802.08218) |
| VQA 2.0              | vqa2                 | [website](https://visualqa.org/), [paper](https://arxiv.org/abs/1505.00468)        |
| VQA CP V2            | vqacp_v2             | [paper](https://arxiv.org/pdf/1712.00377.pdf)|

We are adding many more new datasets which will be available soon.
