#pragma once

#define FAASM_SGX_ERROR(X) (0x00000000 | (X))

typedef enum _faasm_error
{
    FAASM_SGX_SUCCESS = FAASM_SGX_ERROR(0x0),
    FAASM_SGX_INVALID_PTR = FAASM_SGX_ERROR(0x1),
    FAASM_SGX_WAMR_RTE_INIT_FAILED = FAASM_SGX_ERROR(0x2),
    FAASM_SGX_WAMR_MODULE_LOAD_FAILED = FAASM_SGX_ERROR(0x3),
    FAASM_SGX_WAMR_MODULE_INSTANTIATION_FAILED = FAASM_SGX_ERROR(0x4),
    FAASM_SGX_WAMR_EXECUTION_ENVIRONMENT_GENERATION_FAILED =
      FAASM_SGX_ERROR(0x5),
    FAASM_SGX_WAMR_FUNCTION_NOT_FOUND = FAASM_SGX_ERROR(0x6),
    FAASM_SGX_WAMR_FUNCTION_UNABLE_TO_CALL = FAASM_SGX_ERROR(0x7),
    FAASM_SGX_CPU_SGX_NOT_AVAILABLE = FAASM_SGX_ERROR(0x8),
    FAASM_SGX_CPU_SGX_V1_LEAF_NOT_AVAILABLE = FAASM_SGX_ERROR(0x9),
    FAASM_SGX_CPU_SGX_V2_LEAF_NOT_AVAILABLE = FAASM_SGX_ERROR(0xA),
    FAASM_SGX_CPU_NOT_AN_INTEL_CPU = FAASM_SGX_ERROR(0xB),
    FAASM_SGX_CPU_FEATURE_LEAF_NOT_AVAILABLE = FAASM_SGX_ERROR(0xC),
    FAASM_SGX_OUT_OF_MEMORY = FAASM_SGX_ERROR(0xD),
    FAASM_SGX_INVALID_THREAD_ID = FAASM_SGX_ERROR(0xE),
    FAASM_SGX_WAMR_MODULE_NOT_BOUND = FAASM_SGX_ERROR(0xF),
    FAASM_SGX_UNABLE_TO_ENTER_ENCLAVE = FAASM_SGX_ERROR(0x10),
    FAASM_SGX_MODULE_NOT_LOADED = FAASM_SGX_ERROR(0x11),
    FAASM_SGX_INVALID_FUNC_ID = FAASM_SGX_ERROR(0x12),
    FAASM_SGX_INVALID_OPCODE_SIZE = FAASM_SGX_ERROR(0x13),
    FAASM_SGX_OCALL_FAILED = FAASM_SGX_ERROR(0x14),
    FAASM_SGX_CRT_THREAD_FAILED = FAASM_SGX_ERROR(0x15),
    FAASM_SGX_CRT_SOCKET_FAILED = FAASM_SGX_ERROR(0x16),
    FAASM_SGX_CRT_INVALID_ADDR = FAASM_SGX_ERROR(0x17),
    FAASM_SGX_CRT_CONNECT_FAILED = FAASM_SGX_ERROR(0x18),
    FAASM_SGX_CRT_SEND_FAILED = FAASM_SGX_ERROR(0x19),
    FAASM_SGX_CRT_RECV_FAILED = FAASM_SGX_ERROR(0x1A),
    FAASM_SGX_INVALID_PAYLOAD_LEN = FAASM_SGX_ERROR(0x1B),
    FAASM_SGX_FUNCTION_NOT_WHITELISTED = FAASM_SGX_ERROR(0x1C),
    FAASM_SGX_WAMR_FUNCTION_NOT_IMPLEMENTED = FAASM_SGX_ERROR(0x1D),
    // Crypto module errros
    FAASM_SGX_READ_RAND_FAILED = FAASM_SGX_ERROR(0x1E),
    FAASM_SGX_ENCRYPTION_FAILED = FAASM_SGX_ERROR(0x1F),
    FAASM_SGX_DECRYPTION_FAILED = FAASM_SGX_ERROR(0x20),
    FAASM_SGX_HASH_FAILED = FAASM_SGX_ERROR(0x21),
    // Attestation errors
    FAASM_SGX_GENERATE_REPORT_FAILED = FAASM_SGX_ERROR(0x22),
    // Internal test errors
    FAASM_SGX_INTERNAL_TEST_ERROR = FAASM_SGX_ERROR(0x23)
} faasm_sgx_status_t;

#define FAASM_SGX_OCALL_ERROR(X)                                               \
    (faasm_sgx_status_t)((X) << 16 | (FAASM_SGX_OCALL_FAILED))
#define FAASM_SGX_OCALL_GET_SGX_ERROR(X) ((0xFFFF0000 & (X)) >> 16)
#define _FAASM_SGX_ERROR_PREFIX "FAASM_SGX_ERROR:"
