UPDATE `ey_region` SET `name`='山西省' WHERE `name` = '山西' AND `level` = '1';
UPDATE `ey_region` SET `name`='内蒙古自治区' WHERE `name` = '内蒙古' AND `level` = '1';
UPDATE `ey_region` SET `name`='广西壮族自治区' WHERE `name` = '广西' AND `level` = '1';
UPDATE `ey_region` SET `name`='西藏自治区' WHERE `name` = '西藏' AND `level` = '1';
UPDATE `ey_region` SET `name`='宁夏回族自治区' WHERE `name` = '宁夏' AND `level` = '1';
UPDATE `ey_region` SET `name`='新疆维吾尔自治区' WHERE `name` = '新疆' AND `level` = '1';
UPDATE `ey_region` SET `name`='台湾省' WHERE `name` = '台湾' AND `level` = '1';
UPDATE `ey_region` SET `name`='香港特别行政区' WHERE `name` = '香港' AND `level` = '1';
UPDATE `ey_region` SET `name`='澳门特别行政区' WHERE `name` = '澳门' AND `level` = '1';
UPDATE `ey_admin_menu` SET `icon`='iconfont e-lipinduihuan' WHERE `menu_id` = '2004023';
UPDATE `ey_admin_menu` SET `title`='留言中心' WHERE `menu_id` = '2004018';
DELETE FROM `ey_language_mark` WHERE `title` = 'Uyghur' AND `mark` = 'ug';
INSERT INTO `ey_language_mark` (`title`, `cn_title`, `mark`, `pinyin`, `sort_order`, `add_time`, `update_time`) VALUES ('Uyghur', '维吾尔族语', 'ug', 'weiwuerzuyu', '100', '0', '1541583096');
ALTER TABLE `ey_admin` ADD COLUMN `wechat_followed`  tinyint(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '记录是否关注了微信公众号，默认0；0=未关注、1=已关注' AFTER `desc`;
ALTER TABLE `ey_admin` ADD COLUMN `wechat_open_id`  varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT 'open_id，关注微信公众号后存入' AFTER `wechat_followed`;
ALTER TABLE `ey_uploads` MODIFY COLUMN `title`  varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '文档标题' AFTER `aid`;
ALTER TABLE `ey_archives` MODIFY COLUMN `prom_type`  tinyint(1) UNSIGNED NULL DEFAULT 0 COMMENT '产品类型：0=普通产品，1=虚拟(默认手动发货)，2=虚拟(网盘)，3=虚拟(自定义文本) 4-核销' AFTER `stock_show`;
ALTER TABLE `ey_weapp` ADD COLUMN `quick_sort`  int(10) NULL DEFAULT 100 COMMENT '首页快捷菜单专用排序号' AFTER `update_time`;
ALTER TABLE `ey_weapp` ADD COLUMN `checked`  tinyint(4) NULL DEFAULT 0 COMMENT '选中，0=否，1=是(首页快捷菜单用)' AFTER `quick_sort`;
ALTER TABLE `ey_quickentry` MODIFY COLUMN `controller`  varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '控制器名' AFTER `type`;
ALTER TABLE `ey_ddos_log` MODIFY COLUMN `file_name`  varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '文件名' AFTER `md5key`;
ALTER TABLE `ey_shop_order` MODIFY COLUMN `prom_type`  tinyint(1) UNSIGNED NULL DEFAULT 0 COMMENT '订单类型：0普通订单，1虚拟订单,2-核销订单(单次)' AFTER `mobile`;
ALTER TABLE `ey_wx_users` ADD COLUMN `unionid`  varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT 'unionid' AFTER `openid`;

DELETE FROM `ey_region` WHERE `parent_id` = '31618';
INSERT INTO `ey_region`(`name`, `level`, `parent_id`, `initial`) VALUES ('海棠区', 3, 31618, 'H');
INSERT INTO `ey_region`(`name`, `level`, `parent_id`, `initial`) VALUES ('吉阳区', 3, 31618, 'J');
INSERT INTO `ey_region`(`name`, `level`, `parent_id`, `initial`) VALUES ('天涯区', 3, 31618, 'T');
INSERT INTO `ey_region`(`name`, `level`, `parent_id`, `initial`) VALUES ('崖州区', 3, 31618, 'Y');

DROP TABLE IF EXISTS `ey_users_forward`;
CREATE TABLE `ey_users_forward` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `users_id` int(10) DEFAULT '0',
  `aid` int(10) DEFAULT '0' COMMENT '文档id',
  `channel` int(10) DEFAULT '0' COMMENT '模型',
  `typeid` int(10) DEFAULT '0' COMMENT '栏目',
  `title` varchar(200) DEFAULT '' COMMENT '网站标题',
  `litpic` varchar(255) DEFAULT '' COMMENT '缩略图',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='转发记录';

CREATE TABLE IF NOT EXISTS `ey_users_like` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `users_id` int(10) DEFAULT '0',
  `aid` int(10) DEFAULT '0' COMMENT '文档id',
  `channel` int(10) DEFAULT '0' COMMENT '模型',
  `typeid` int(10) DEFAULT '0' COMMENT '栏目',
  `title` varchar(200) DEFAULT '' COMMENT '网站标题',
  `litpic` varchar(255) DEFAULT '' COMMENT '缩略图',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='我喜欢的';

CREATE TABLE IF NOT EXISTS `ey_users_login_log` (
  `log_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '会员日志自增ID',
  `users_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `log_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '日志时间，年月日(例:20230406)',
  `log_count` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '日志次数',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`log_id`),
  UNIQUE KEY `users_id` (`users_id`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='会员登录日志 - 用于登录赠送积分';

DROP TABLE IF EXISTS `ey_pick_up_points`;
CREATE TABLE `ey_pick_up_points` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '提货点',
  `title` varchar(155) DEFAULT '' COMMENT '名称',
  `intro` varchar(255) DEFAULT '' COMMENT '简介',
  `phone` varchar(55) DEFAULT '' COMMENT '手机号',
  `province` mediumint(8) DEFAULT '0',
  `city` mediumint(8) DEFAULT '0',
  `area` mediumint(8) DEFAULT '0',
  `address` varchar(255) DEFAULT '' COMMENT '详细地址',
  `bussiness_time` varchar(150) DEFAULT '' COMMENT '营业时间',
  `logo` varchar(255) DEFAULT '' COMMENT 'logo',
  `litpic` varchar(255) DEFAULT '' COMMENT '大',
  `lng` varchar(100) DEFAULT '' COMMENT '经度',
  `lat` varchar(100) DEFAULT '' COMMENT '纬度',
  `add_time` int(10) DEFAULT '0',
  `update_time` int(10) DEFAULT '0',
  `status` tinyint(1) DEFAULT '0' COMMENT '状态 0-显示 1-不显示',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='核销提货点表';

DROP TABLE IF EXISTS `ey_shop_order_verify`;
CREATE TABLE `ey_shop_order_verify` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '订单核销信息表',
  `users_id` int(11) DEFAULT '0' COMMENT '用户id',
  `order_id` int(11) DEFAULT '0' COMMENT '订单id',
  `points_id` int(11) DEFAULT '0' COMMENT '提货点id',
  `verify_code` varchar(30) DEFAULT '' COMMENT '核销码',
  `status` tinyint(3) DEFAULT '1' COMMENT '核销状态 1-未核销 2-已核销',
  `add_time` int(10) DEFAULT '0',
  `update_time` int(10) DEFAULT NULL,
  `name` varchar(55) DEFAULT '' COMMENT '用户姓名',
  `mobile` varchar(25) DEFAULT '' COMMENT '联系方式',
  `verifier_id` int(11) DEFAULT '0' COMMENT '前台核销-核销员id',
  `admin_id` int(11) DEFAULT '0' COMMENT '后台核销-管理员id',
  `verify_time` int(10) DEFAULT '0' COMMENT '核销时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='订单核销表';

DROP TABLE IF EXISTS `ey_verifier`;
CREATE TABLE `ey_verifier` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '核销员',
  `users_id` int(10) DEFAULT '0' COMMENT '用户id',
  `points_id` int(10) DEFAULT '0' COMMENT '所属提货点(pick_up_points表id)',
  `name` varchar(55) DEFAULT '' COMMENT '核销员名称',
  `mobile` varchar(55) DEFAULT '' COMMENT '手机号码',
  `status` tinyint(1) DEFAULT '0' COMMENT '核销状态 开启   关闭\r\n核销状态 开启   关闭\r\n核销状态,0-开启   1-关闭',
  `add_time` int(10) DEFAULT '0',
  `update_time` int(10) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='核销员表';