ALTER TABLE `ey_archives` ADD COLUMN `editor_remote_img_local`  tinyint(1) NULL DEFAULT 1 COMMENT '远程图片本地化' AFTER `no_vip_pay`;
ALTER TABLE `ey_archives` ADD COLUMN `editor_img_clear_link`  tinyint(1) NULL DEFAULT 1 COMMENT '清除非本站链接' AFTER `editor_remote_img_local`;
ALTER TABLE `ey_shop_order_service` ADD COLUMN `manual_time`  int(11) UNSIGNED NOT NULL DEFAULT 0 COMMENT '服务单手动退款时间' AFTER `manual_refund`;
ALTER TABLE `ey_shop_order_service` ADD COLUMN `audit_time`  int(11) UNSIGNED NOT NULL DEFAULT 0 COMMENT '审核时间' AFTER `status`;
ALTER TABLE `ey_shop_order_service` ADD COLUMN `refund_remark`  varchar(500) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '' COMMENT '退款备注' AFTER `audit_time`;
ALTER TABLE `ey_admin_menu` ADD COLUMN `target`  varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT 'workspace' COMMENT '链接打开方式' AFTER `is_switch`;
ALTER TABLE `ey_product_spec_data` ADD COLUMN `open_image`  tinyint(1) UNSIGNED NULL DEFAULT 0 COMMENT '规格是否开启图片' AFTER `spec_is_select`;
ALTER TABLE `ey_product_spec_data` ADD COLUMN `spec_image`  varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '规格图片' AFTER `open_image`;
ALTER TABLE `ey_product_spec_data_handle` ADD COLUMN `open_image`  tinyint(1) UNSIGNED NULL DEFAULT 0 COMMENT '规格是否开启图片' AFTER `spec_is_select`;
ALTER TABLE `ey_product_spec_data_handle` ADD COLUMN `spec_image`  varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '规格图片' AFTER `open_image`;
ALTER TABLE `ey_product_spec_value` ADD COLUMN `spec_crossed_price`  decimal(10,2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '商品规格划线价' AFTER `spec_price`;
ALTER TABLE `ey_archives` ADD COLUMN `crossed_price`  decimal(10,2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '商品划线价' AFTER `users_price`;
ALTER TABLE `ey_archives` MODIFY COLUMN `title`  varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '文档标题' AFTER `is_b`;
ALTER TABLE `ey_archives` MODIFY COLUMN `litpic`  varchar(250) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '封面图片' AFTER `subtitle`;
ALTER TABLE `ey_archives` MODIFY COLUMN `click`  int(10) NULL DEFAULT 0 COMMENT '点击数' AFTER `author`;
ALTER TABLE `ey_archives` MODIFY COLUMN `jumplinks`  varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '跳转网址' AFTER `arcrank`;
ALTER TABLE `ey_archives` MODIFY COLUMN `tempview`  varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '文档模板' AFTER `logistics_type`;
ALTER TABLE `ey_arctype` MODIFY COLUMN `litpic`  varchar(250) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '栏目图片' AFTER `typelink`;
ALTER TABLE `ey_users` MODIFY COLUMN `thirdparty`  tinyint(1) NULL DEFAULT 0 COMMENT '第三方注册类型 0=普通, 1=微信, 2=QQ, 3=手机号, 4=微信小程序， 5=微站点, 6-微信公众号, 7-百度小程序, 8-抖音小程序' AFTER `open_id`;
UPDATE `ey_admin_menu` SET `target`='workspace';
UPDATE `ey_admin_menu` SET `target`='_blank' WHERE `param` LIKE '%|sa|page_edit%';
DELETE FROM `ey_region` WHERE `parent_id` = '12974' AND `name` = '龙港市';
INSERT INTO `ey_region` (`name`, `level`, `parent_id`, `initial`) VALUES ('龙港市', '3', '12974', 'L');
ALTER TABLE `ey_shop_order_comment` MODIFY COLUMN `content`  text CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '评论内容' AFTER `total_score`;

DROP TABLE IF EXISTS `ey_product_spec_value_handle`;
CREATE TABLE `ey_product_spec_value_handle` (
  `value_id` int(20) NOT NULL DEFAULT '0' COMMENT '对应 product_spec_value 数据表',
  `aid` int(10) NOT NULL DEFAULT '0' COMMENT '对应 product_spec_value 数据表',
  `spec_value_id` varchar(100) NOT NULL DEFAULT '' COMMENT '对应 product_spec_value 数据表',
  `spec_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '对应 product_spec_value 数据表',
  `spec_crossed_price` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '商品规格划线价',
  `spec_stock` int(10) NOT NULL DEFAULT '0' COMMENT '对应 product_spec_value 数据表',
  `spec_sales_num` int(10) NOT NULL DEFAULT '0' COMMENT '对应 product_spec_value 数据表',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '对应 product_spec_value 数据表',
  `add_time` int(11) DEFAULT '0' COMMENT '对应 product_spec_value 数据表',
  `update_time` int(11) DEFAULT '0' COMMENT '对应 product_spec_value 数据表',
  `seckill_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '对应 product_spec_value 数据表',
  `seckill_stock` int(10) NOT NULL DEFAULT '0' COMMENT '对应 product_spec_value 数据表',
  `seckill_sales_num` int(10) NOT NULL DEFAULT '0' COMMENT '对应 product_spec_value 数据表',
  `is_seckill` tinyint(1) NOT NULL DEFAULT '0' COMMENT '对应 product_spec_value 数据表',
  `discount_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '对应 product_spec_value 数据表',
  `discount_stock` int(10) NOT NULL DEFAULT '0' COMMENT '对应 product_spec_value 数据表',
  `discount_sales_num` int(10) NOT NULL DEFAULT '0' COMMENT '对应 product_spec_value 数据表',
  `is_discount` tinyint(1) NOT NULL DEFAULT '0' COMMENT '对应 product_spec_value 数据表',
  PRIMARY KEY (`value_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='商品规格价格表(product_spec_value)预处理规格价格表';

DROP TABLE IF EXISTS `ey_users_log_off`;
CREATE TABLE `ey_users_log_off` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `users_id` int(11) DEFAULT '0',
  `username` varchar(25) DEFAULT NULL,
  `nickname` varchar(30) DEFAULT NULL,
  `mobile` varchar(25) DEFAULT NULL,
  `status` tinyint(1) DEFAULT '0' COMMENT '0-审核中 1-通过 2-拒绝',
  `handle_time` int(11) DEFAULT '0' COMMENT '操作时间',
  `admin_id` int(11) DEFAULT '0' COMMENT '操作人',
  `refuse_reason` varchar(255) DEFAULT NULL COMMENT '拒绝原因',
  `add_time` int(11) DEFAULT '0' COMMENT '申请时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='会员注销日志表';

DROP TABLE IF EXISTS `ey_users_recharge_pack`;
CREATE TABLE `ey_users_recharge_pack` (
  `pack_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '会员充值套餐ID',
  `pack_names` varchar(100) NOT NULL DEFAULT '' COMMENT '会员充值套餐名称',
  `pack_face_value` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '会员充值套餐充值面值',
  `pack_buy_prices` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '会员充值套餐购买价格',
  `pack_sales_num` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员充值套餐销售数量',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '会员充值套餐状态(1:开启; 2:关闭;)',
  `sort_order` int(11) unsigned NOT NULL DEFAULT '100' COMMENT '排序号',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`pack_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='会员充值套餐列表';

DROP TABLE IF EXISTS `ey_users_recharge_pack_order`;
CREATE TABLE `ey_users_recharge_pack_order` (
  `order_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '会员充值套餐订单ID',
  `pack_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员充值套餐ID',
  `users_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `order_code` varchar(50) NOT NULL DEFAULT '' COMMENT '订单编号',
  `order_status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '订单状态(1:未支付; 2:已支付(未执行充值); 3:已充值(已执行充值); 4:已过期;)',
  `order_pack_names` varchar(100) NOT NULL DEFAULT '' COMMENT '会员充值套餐名称',
  `order_face_value` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '订单充值面值',
  `order_pay_prices` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '订单支付价格',
  `order_pay_code` varchar(50) NOT NULL DEFAULT '' COMMENT '订单支付编号(待用)',
  `order_pay_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '支付时间',
  `order_pay_name` varchar(20) NOT NULL DEFAULT '' COMMENT '支付方式名称',
  `order_pay_terminal` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '订单终端(1:电脑端; 2:手机端; 3:微信小程序; 4:抖音小程序)',
  `order_pay_details` text COMMENT '支付成功返回的数据，serialize序列化存入',
  `lang` varchar(30) NOT NULL DEFAULT 'cn' COMMENT '语言标识',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '添加时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`order_id`),
  KEY `pack_id` (`pack_id`),
  KEY `users_id` (`users_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='会员充值套餐订单';

DROP TABLE IF EXISTS `ey_foreign_pack`;
CREATE TABLE `ey_foreign_pack` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `type` int(4) DEFAULT '0' COMMENT '分类：1=列表，2=留言',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '变量名',
  `value` text NOT NULL COMMENT '变量值',
  `lang` varchar(50) DEFAULT 'cn' COMMENT '语言标识',
  `sort_order` int(10) DEFAULT '0' COMMENT '排序号',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COMMENT='外贸助手语言包变量';

INSERT INTO `ey_foreign_pack` VALUES ('1', '1', 'page1', '首页', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('2', '1', 'page2', '上一页', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('3', '1', 'page3', '下一页', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('4', '1', 'page4', '末页', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('5', '1', 'page5', '共<strong>%s</strong>页 <strong>%s</strong>条', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('6', '1', 'page1', 'Home', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('7', '1', 'page2', 'Pre', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('8', '1', 'page3', 'Next', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('9', '1', 'page4', 'Last', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('10', '1', 'page5', 'Road <strong>%s</strong> page <strong>%s</strong> strip', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('11', '2', 'gbook1', '操作成功', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('12', '2', 'gbook1', 'success', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('14', '2', 'gbook2', 'The same IP cannot be submitted repeatedly within %s seconds!', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('13', '2', 'gbook2', '同一个IP在%s秒之内不能重复提交！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('15', '2', 'gbook3', '%s不能为空！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('16', '2', 'gbook3', '%s Cannot be empty!', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('17', '2', 'gbook4', '%s格式不正确！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('18', '2', 'gbook4', '%s Incorrect format!', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('19', '2', 'gbook5', '图片验证码不能为空！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('20', '2', 'gbook5', 'Picture verification code cannot be empty!', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('21', '2', 'gbook6', '图片验证码不正确！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('22', '2', 'gbook6', 'The picture verification code is incorrect!', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('23', '2', 'gbook7', '请输入手机号码！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('24', '2', 'gbook7', 'Please enter your mobile number!', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('25', '2', 'gbook8', '手机号码和手机验证码不一致，请重新输入！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('26', '2', 'gbook8', 'Mobile phone number and mobile phone verification code are inconsistent, please re-enter!', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('27', '2', 'gbook9', '手机验证码已被使用或超时，请重新发送！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('28', '2', 'gbook9', 'The mobile phone verification code has been used or timed out. Please resend it!', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('29', '2', 'gbook10', '请输入手机验证码！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('30', '2', 'gbook10', 'Please enter the mobile phone verification code!', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('31', '2', 'gbook11', '表单缺少标签属性{$field.hidden}', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('32', '2', 'gbook11', 'The form is missing label attribute {$field.hidden}', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('33', '2', 'gbook12', '页面自动 %s跳转%s 等待时间：', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('34', '2', 'gbook12', 'Page automatic %sjump%s waiting time：', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('35', '2', 'gbook13', '%s至少选择一项！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('36', '2', 'gbook13', 'Select at least one item to %s', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('37', '2', 'gbook14', '请选择%s', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('38', '2', 'gbook14', 'Please select %s', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('39', '2', 'gbook15', '请输入正确的手机号码！', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('40', '2', 'gbook15', 'Please enter the correct mobile number！', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('41', '2', 'gbook16', '图片验证码', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('42', '2', 'gbook16', 'Picture verification code', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('43', '2', 'gbook17', '手机验证码', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('44', '2', 'gbook17', 'Mobile verification code', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('45', '2', 'gbook18', '获取验证码', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('46', '2', 'gbook18', 'Get verification code', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('47', '2', 'gbook19', '看不清？点击更换验证码', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('48', '2', 'gbook19', 'Can\'t see clearly? Click to change the verification code', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('49', '2', 'gbook20', '看不清？%s点击更换%s', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('50', '2', 'gbook20', 'Can\'t see clearly? %sClick to replace%s', 'en', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('51', '1', 'page6', '第%s页', 'cn', '100', '1543890216', '1543890216');
INSERT INTO `ey_foreign_pack` VALUES ('52', '1', 'page6', '%s', 'en', '100', '1543890216', '1543890216');