ALTER TABLE `ey_archives` ADD COLUMN `users_discount_type`  tinyint(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT '产品会员折扣类型(0:系统默认折扣; 1:指定会员级别; 2:不参与折扣;)' AFTER `users_price`;
ALTER TABLE `ey_archives` ADD COLUMN `logistics_type`  varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '1' COMMENT '商品物流支持类型(1: 物流配送; 2: 到店核销)' AFTER `prom_type`;
DELETE FROM `ey_channelfield` WHERE `name` IN ('users_discount_type','logistics_type') AND `channel_id` = '0';
INSERT INTO `ey_channelfield` (`name`, `channel_id`, `title`, `dtype`, `define`, `maxlength`, `dfvalue`, `dfvalue_unit`, `remark`, `is_screening`, `is_release`, `ifeditable`, `ifrequire`, `ifsystem`, `ifmain`, `ifcontrol`, `sort_order`, `status`, `add_time`, `update_time`, `set_type`) VALUES ('users_discount_type', '0', '产品会员折扣类型(0:系统默认折扣; 1:指定会员级别; 2:不参与折扣;)', 'switch', 'tinyint(1) unsigned', '1', '0', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1683873488', '1683873488', '0');
INSERT INTO `ey_channelfield` (`name`, `channel_id`, `title`, `dtype`, `define`, `maxlength`, `dfvalue`, `dfvalue_unit`, `remark`, `is_screening`, `is_release`, `ifeditable`, `ifrequire`, `ifsystem`, `ifmain`, `ifcontrol`, `sort_order`, `status`, `add_time`, `update_time`, `set_type`) VALUES ('logistics_type', '0', '商品物流支持类型(1: 物流配送; 2: 到店核销)', 'text', 'varchar(100)', '100', '', '', '', '0', '0', '1', '0', '1', '1', '1', '100', '1', '1690364521', '1690364521', '0');
ALTER TABLE `ey_arctype` ADD COLUMN `page_limit`  varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '0' COMMENT '限制页面 1-栏目页面 0-文档页面' AFTER `empty_logic`;
ALTER TABLE `ey_quickentry` ADD COLUMN `litpic`  varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' AFTER `checked`;
ALTER TABLE `ey_quickentry` ADD COLUMN `statistics_type`  int(5) NULL DEFAULT 0 COMMENT 'statistics_data表对应的type值' AFTER `litpic`;
ALTER TABLE `ey_shop_order` ADD COLUMN `verify_id`  int(11) UNSIGNED NOT NULL DEFAULT 0 COMMENT '核销记录表ID(weapp_verify表)' AFTER `coupon_price`;
ALTER TABLE `ey_shop_order` ADD COLUMN `logistics_type`  int(11) UNSIGNED NOT NULL DEFAULT 1 COMMENT '订单物流类型(1:快递发货; 2:到店核销;)' AFTER `verify_id`;
ALTER TABLE `ey_users` ADD COLUMN `source`  tinyint(3) NULL DEFAULT 1 COMMENT '来源\r\n1-PC端\r\n2-H5\r\n3-微信公众号\r\n4-微信小程序\r\n5-百度小程序\r\n6-抖音小程序\r\n' AFTER `union_id`;
ALTER TABLE `ey_weapp` MODIFY COLUMN `data`  longtext CHARACTER SET utf8 COLLATE utf8_general_ci NULL COMMENT '额外序列化存储数据，简单插件可以不创建表，存储这里即可' AFTER `config`;
ALTER TABLE `ey_wx_users` ADD COLUMN `provider`  varchar(25) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT '' COMMENT '来源' AFTER `update_time`;
DELETE FROM `ey_region` WHERE `id` IN ('10969','10976');
UPDATE `ey_region` SET `name`='新吴区', `initial`='X' WHERE `id` = '10961';
UPDATE `ey_region` SET `name`='梁溪区', `initial`='L' WHERE `id` = '10962';
DELETE FROM `ey_region` WHERE `parent_id` = '12974' AND `name` = '龙港市';
INSERT INTO `ey_region` (`name`, `level`, `parent_id`, `initial`) VALUES ('龙港市', '3', '12974', 'L');
ALTER TABLE `ey_shop_shipping_template` MODIFY COLUMN `template_money`  decimal(10,2) UNSIGNED NOT NULL DEFAULT 0.00 COMMENT '模板运费' AFTER `template_region`;

DELETE FROM `ey_quickentry` WHERE `type` = '21';
INSERT INTO `ey_quickentry` (`title`, `laytext`, `type`, `controller`, `action`, `vars`, `groups`, `checked`, `litpic`, `statistics_type`, `status`, `sort_order`, `add_time`, `update_time`) VALUES ('商品数', '商品总数', '21', 'ShopProduct', 'index', '', '1', '1', '', '6', '1', '1', '1569232484', '1681436771');
INSERT INTO `ey_quickentry` (`title`, `laytext`, `type`, `controller`, `action`, `vars`, `groups`, `checked`, `litpic`, `statistics_type`, `status`, `sort_order`, `add_time`, `update_time`) VALUES ('充值金额', '充值总额', '21', 'Member', 'money_index', 'status=2', '1', '0', '', '5', '1', '5', '1569232484', '1681436771');
INSERT INTO `ey_quickentry` (`title`, `laytext`, `type`, `controller`, `action`, `vars`, `groups`, `checked`, `litpic`, `statistics_type`, `status`, `sort_order`, `add_time`, `update_time`) VALUES ('会员数', '会员总数', '21', 'Member', 'users_index', '', '1', '0', '', '4', '1', '6', '1569232484', '1681436771');
INSERT INTO `ey_quickentry` (`title`, `laytext`, `type`, `controller`, `action`, `vars`, `groups`, `checked`, `litpic`, `statistics_type`, `status`, `sort_order`, `add_time`, `update_time`) VALUES ('销售额', '销售总额', '21', 'Statistics', 'index', 'conceal=1', '1', '1', '', '3', '1', '3', '1569232484', '1681436771');
INSERT INTO `ey_quickentry` (`title`, `laytext`, `type`, `controller`, `action`, `vars`, `groups`, `checked`, `litpic`, `statistics_type`, `status`, `sort_order`, `add_time`, `update_time`) VALUES ('订单数', '订单总数', '21', 'Order', 'index', '', '1', '1', '', '2', '1', '2', '1569232484', '1681436771');
INSERT INTO `ey_quickentry` (`title`, `laytext`, `type`, `controller`, `action`, `vars`, `groups`, `checked`, `litpic`, `statistics_type`, `status`, `sort_order`, `add_time`, `update_time`) VALUES ('浏览量', '总浏览量', '21', '', '', '', '1', '1', '', '1', '1', '4', '1569232484', '1681436771');

DELETE FROM `ey_quickentry` WHERE `type` = '31';
INSERT INTO `ey_quickentry` (`title`, `laytext`, `type`, `controller`, `action`, `vars`, `groups`, `checked`, `litpic`, `statistics_type`, `status`, `sort_order`, `add_time`, `update_time`) VALUES ('浏览量', '总浏览量', '31', '', '', '', '1', '1', '', '1', '1', '5', '1569232484', '1681461467');
INSERT INTO `ey_quickentry` (`title`, `laytext`, `type`, `controller`, `action`, `vars`, `groups`, `checked`, `litpic`, `statistics_type`, `status`, `sort_order`, `add_time`, `update_time`) VALUES ('订单数', '订单总数', '31', 'Order', 'index', '', '1', '1', '', '2', '1', '3', '1569232484', '1681461467');
INSERT INTO `ey_quickentry` (`title`, `laytext`, `type`, `controller`, `action`, `vars`, `groups`, `checked`, `litpic`, `statistics_type`, `status`, `sort_order`, `add_time`, `update_time`) VALUES ('销售额', '销售总额', '31', 'Statistics', 'index', 'conceal=1', '1', '1', '', '3', '1', '4', '1569232484', '1681461467');
INSERT INTO `ey_quickentry` (`title`, `laytext`, `type`, `controller`, `action`, `vars`, `groups`, `checked`, `litpic`, `statistics_type`, `status`, `sort_order`, `add_time`, `update_time`) VALUES ('会员数', '会员总数', '31', 'Member', 'users_index', '', '1', '1', '', '4', '1', '1', '1569232484', '1681461467');
INSERT INTO `ey_quickentry` (`title`, `laytext`, `type`, `controller`, `action`, `vars`, `groups`, `checked`, `litpic`, `statistics_type`, `status`, `sort_order`, `add_time`, `update_time`) VALUES ('充值金额', '充值总额', '31', 'Member', 'money_index', 'status=2', '1', '1', '', '5', '1', '6', '1569232484', '1681461467');
INSERT INTO `ey_quickentry` (`title`, `laytext`, `type`, `controller`, `action`, `vars`, `groups`, `checked`, `litpic`, `statistics_type`, `status`, `sort_order`, `add_time`, `update_time`) VALUES ('商品数', '商品总数', '31', 'ShopProduct', 'index', '', '1', '1', '', '6', '1', '2', '1569232484', '1681461467');
INSERT INTO `ey_quickentry` (`title`, `laytext`, `type`, `controller`, `action`, `vars`, `groups`, `checked`, `litpic`, `statistics_type`, `status`, `sort_order`, `add_time`, `update_time`) VALUES ('文章数', '文章总数', '31', 'Article', 'index', '', '1', '1', '', '7', '1', '7', '1569232484', '1681461467');
INSERT INTO `ey_quickentry` (`title`, `laytext`, `type`, `controller`, `action`, `vars`, `groups`, `checked`, `litpic`, `statistics_type`, `status`, `sort_order`, `add_time`, `update_time`) VALUES ('TAG标签数', 'TAG标签总数', '31', 'Tags', 'index', '', '1', '1', '', '8', '1', '8', '1569232484', '1681461467');
INSERT INTO `ey_quickentry` (`title`, `laytext`, `type`, `controller`, `action`, `vars`, `groups`, `checked`, `litpic`, `statistics_type`, `status`, `sort_order`, `add_time`, `update_time`) VALUES ('待审文档', '待审总数', '31', 'Archives', 'index_draft', 'menu=1', '1', '1', '', '9', '1', '9', '1569232484', '1681461467');

DELETE FROM `ey_quickentry` WHERE `type` = '11';
INSERT INTO `ey_quickentry` (`title`, `laytext`, `type`, `controller`, `action`, `vars`, `groups`, `checked`, `litpic`, `statistics_type`, `status`, `sort_order`, `add_time`, `update_time`) VALUES ('充值订单', '充值订单', '11', 'Member', 'money_index', 'status=2', '0', '1', '/public/static/admin/images/theme/survey_chongzhi.png', '0', '1', '7', '1569232484', '1681436759');
INSERT INTO `ey_quickentry` (`title`, `laytext`, `type`, `controller`, `action`, `vars`, `groups`, `checked`, `litpic`, `statistics_type`, `status`, `sort_order`, `add_time`, `update_time`) VALUES ('订单查询', '订单查询', '11', 'Order', 'index', '', '0', '1', '/public/static/admin/images/theme/survey_dingdan.png', '0', '1', '2', '1569232484', '1681436759');
INSERT INTO `ey_quickentry` (`title`, `laytext`, `type`, `controller`, `action`, `vars`, `groups`, `checked`, `litpic`, `statistics_type`, `status`, `sort_order`, `add_time`, `update_time`) VALUES ('发布商品', '发布商品', '11', 'ShopProduct', 'add', 'firstrun=1', '0', '1', '/public/static/admin/images/theme/survey_fabu.png', '0', '1', '1', '1569232484', '1681436759');
INSERT INTO `ey_quickentry` (`title`, `laytext`, `type`, `controller`, `action`, `vars`, `groups`, `checked`, `litpic`, `statistics_type`, `status`, `sort_order`, `add_time`, `update_time`) VALUES ('前往发货', '前往发货', '11', 'Shop', 'index', 'order_status=1', '0', '1', '/public/static/admin/images/theme/survey_fahuo.png', '0', '1', '2', '1569232484', '1669604332');
INSERT INTO `ey_quickentry` (`title`, `laytext`, `type`, `controller`, `action`, `vars`, `groups`, `checked`, `litpic`, `statistics_type`, `status`, `sort_order`, `add_time`, `update_time`) VALUES ('会员管理', '会员管理', '11', 'Member', 'users_index', '', '0', '1', '/public/static/admin/images/theme/survey_huiyuan.png', '0', '1', '5', '1569232484', '1681436759');
INSERT INTO `ey_quickentry` (`title`, `laytext`, `type`, `controller`, `action`, `vars`, `groups`, `checked`, `litpic`, `statistics_type`, `status`, `sort_order`, `add_time`, `update_time`) VALUES ('主题风格', '主题风格', '11', 'Index', 'theme_index', '', '0', '0', '/public/static/admin/images/theme/survey_pifu.png', '0', '1', '10', '1569232484', '1681436759');
INSERT INTO `ey_quickentry` (`title`, `laytext`, `type`, `controller`, `action`, `vars`, `groups`, `checked`, `litpic`, `statistics_type`, `status`, `sort_order`, `add_time`, `update_time`) VALUES ('评价管理', '评价管理', '11', 'ShopComment', 'comment_index', '', '0', '1', '/public/static/admin/images/theme/survey_pingjia.png', '0', '1', '4', '1569232484', '1681436759');
INSERT INTO `ey_quickentry` (`title`, `laytext`, `type`, `controller`, `action`, `vars`, `groups`, `checked`, `litpic`, `statistics_type`, `status`, `sort_order`, `add_time`, `update_time`) VALUES ('售后维权', '售后维权', '11', 'ShopService', 'after_service', '', '0', '1', '/public/static/admin/images/theme/survey_weiquan.png', '0', '1', '3', '1569232484', '1681436759');
INSERT INTO `ey_quickentry` (`title`, `laytext`, `type`, `controller`, `action`, `vars`, `groups`, `checked`, `litpic`, `statistics_type`, `status`, `sort_order`, `add_time`, `update_time`) VALUES ('优惠券', '优惠券', '11', 'Coupon', 'index', '', '0', '1', '/public/static/admin/images/theme/survey_youhuiquan.png', '0', '1', '9', '1569232484', '1681436759');
INSERT INTO `ey_quickentry` (`title`, `laytext`, `type`, `controller`, `action`, `vars`, `groups`, `checked`, `litpic`, `statistics_type`, `status`, `sort_order`, `add_time`, `update_time`) VALUES ('运费模板', '运费模板', '11', 'Shop', 'shipping_template', '', '0', '1', '/public/static/admin/images/theme/survey_yunfei.png', '0', '1', '8', '1569232484', '1681436759');
INSERT INTO `ey_quickentry` (`title`, `laytext`, `type`, `controller`, `action`, `vars`, `groups`, `checked`, `litpic`, `statistics_type`, `status`, `sort_order`, `add_time`, `update_time`) VALUES ('支付设置', '支付设置', '11', 'System', 'api_conf', '', '0', '1', '/public/static/admin/images/theme/survey_zhifu.png', '0', '1', '6', '1569232484', '1681436759');
INSERT INTO `ey_quickentry` (`title`, `laytext`, `type`, `controller`, `action`, `vars`, `groups`, `checked`, `litpic`, `statistics_type`, `status`, `sort_order`, `add_time`, `update_time`) VALUES ('提货设置', '提货设置', '11', 'OrderVerify', 'drive_list', '', '0', '0', '/public/static/admin/images/theme/survey_ziti.png', '0', '1', '11', '1569232484', '1681436759');

DROP TABLE IF EXISTS `ey_statistics_data`;
CREATE TABLE `ey_statistics_data` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `date` int(10) DEFAULT '0',
  `num` int(10) DEFAULT '0',
  `type` mediumint(8) DEFAULT '1' COMMENT '1-浏览量 2-订单 3-销售额 4-新增会员 5-充值金额 6-商品数 7-文章数 8-tag数 9-待审数',
  `total` decimal(8,2) DEFAULT '0.00' COMMENT 'type=3/5用',
  `lang` varchar(10) DEFAULT 'cn',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='商城欢迎页主题的统计表';

DROP TABLE IF EXISTS `ey_admin_theme`;
CREATE TABLE `ey_admin_theme` (
  `theme_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `theme_type` tinyint(1) DEFAULT '0' COMMENT '主题类型：1=登录页，2=欢迎页',
  `theme_title` varchar(50) DEFAULT '' COMMENT '主题标题',
  `theme_pic` varchar(255) DEFAULT '' COMMENT '主题效果图',
  `theme_color_model` varchar(10) DEFAULT '' COMMENT '主题颜色模式',
  `theme_main_color` varchar(20) DEFAULT '' COMMENT '主题主色',
  `theme_assist_color` varchar(20) DEFAULT '' COMMENT '主题辅色',
  `login_logo` varchar(255) DEFAULT '' COMMENT '登录图标',
  `login_bgimg_model` varchar(10) DEFAULT '' COMMENT '登录背景图模式',
  `login_bgimg` varchar(255) DEFAULT '' COMMENT '登录背景图',
  `login_tplname` varchar(100) DEFAULT '' COMMENT '登录页自定义模板',
  `admin_logo` varchar(255) DEFAULT '' COMMENT '后台Logo',
  `welcome_tplname` varchar(100) DEFAULT '' COMMENT '欢迎页自定义模板',
  `is_system` tinyint(1) DEFAULT '0' COMMENT '内置主题',
  `sort_order` int(10) DEFAULT '100' COMMENT '排序号',
  `add_time` int(11) DEFAULT '0' COMMENT '新增时间',
  `update_time` int(11) DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`theme_id`)
) ENGINE=MyISAM AUTO_INCREMENT=100 DEFAULT CHARSET=utf8 COMMENT='后台主题风格表';

INSERT INTO `ey_admin_theme` (`theme_id`, `theme_type`, `theme_title`, `theme_pic`, `theme_color_model`, `theme_main_color`, `theme_assist_color`, `login_logo`, `login_bgimg_model`, `login_bgimg`, `login_tplname`, `admin_logo`, `welcome_tplname`, `is_system`, `sort_order`, `add_time`, `update_time`) VALUES ('1', '1', '经典蓝主题', '/public/static/admin/images/theme/theme_pic_1.png', '1', '#3398cc', '#2189be', '/public/static/admin/login/login-logo_ey.png', '1', '/public/static/admin/loginbg/login-bg-1.png', '', '/public/static/admin/logo/logo_ey.png', '', '1', '100', '1681200988', '1681200988');
INSERT INTO `ey_admin_theme` (`theme_id`, `theme_type`, `theme_title`, `theme_pic`, `theme_color_model`, `theme_main_color`, `theme_assist_color`, `login_logo`, `login_bgimg_model`, `login_bgimg`, `login_tplname`, `admin_logo`, `welcome_tplname`, `is_system`, `sort_order`, `add_time`, `update_time`) VALUES ('2', '1', '易优橙主题', '/public/static/admin/images/theme/theme_pic_2.png', 'custom', '#197971', '#fa921b', '/public/static/admin/login/login-logo.png', '2', '/public/static/admin/loginbg/login-bg-1.png', '', '/public/static/admin/logo/logo.png', '', '1', '100', '1681866512', '1681866512');
INSERT INTO `ey_admin_theme` (`theme_id`, `theme_type`, `theme_title`, `theme_pic`, `theme_color_model`, `theme_main_color`, `theme_assist_color`, `login_logo`, `login_bgimg_model`, `login_bgimg`, `login_tplname`, `admin_logo`, `welcome_tplname`, `is_system`, `sort_order`, `add_time`, `update_time`) VALUES ('4', '2', '商城欢迎页', '/public/static/admin/images/theme/theme_pic_4.png', '', '', '', '', '', '', '', '', 'welcome_shop.htm', '1', '100', '1681200988', '1681200988');
INSERT INTO `ey_admin_theme` (`theme_id`, `theme_type`, `theme_title`, `theme_pic`, `theme_color_model`, `theme_main_color`, `theme_assist_color`, `login_logo`, `login_bgimg_model`, `login_bgimg`, `login_tplname`, `admin_logo`, `welcome_tplname`, `is_system`, `sort_order`, `add_time`, `update_time`) VALUES ('5', '2', '任务流欢迎页', '/public/static/admin/images/theme/theme_pic_5.png', '', '', '', '', '', '', '', '', 'welcome_taskflow.htm', '1', '100', '1681200988', '1681200988');
INSERT INTO `ey_admin_theme` (`theme_id`, `theme_type`, `theme_title`, `theme_pic`, `theme_color_model`, `theme_main_color`, `theme_assist_color`, `login_logo`, `login_bgimg_model`, `login_bgimg`, `login_tplname`, `admin_logo`, `welcome_tplname`, `is_system`, `sort_order`, `add_time`, `update_time`) VALUES ('3', '2', '默认欢迎页', '/public/static/admin/images/theme/theme_pic_default.png', '', '', '', '', '', '', '', '', '', '1', '100', '1681200988', '1681200988');

DROP TABLE IF EXISTS `ey_product_users_discount`;
CREATE TABLE `ey_product_users_discount` (
  `users_discount_id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '自增ID',
  `aid` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '产品ID',
  `level_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '会员等级ID',
  `users_discount_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '会员等级价格',
  `add_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '下单时间',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  PRIMARY KEY (`users_discount_id`),
  KEY `aid` (`aid`) USING BTREE,
  KEY `level_id` (`level_id`) USING BTREE
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='产品指定会员等级折扣列表';

DROP TABLE IF EXISTS `ey_applets_template`;
DROP TABLE IF EXISTS `ey_wechat_template`;
DROP TABLE IF EXISTS `ey_pick_up_points`;
DROP TABLE IF EXISTS `ey_shop_order_verify`;
DROP TABLE IF EXISTS `ey_verifier`;
DROP TABLE IF EXISTS `ey_form_field`;
DROP TABLE IF EXISTS `ey_form_list`;
DROP TABLE IF EXISTS `ey_form_value`;